             Editing the effect field
             ------------------------
             The effect field consists  of  2  parts:  a  command  and  an
             argument.

             The  command  can one of 16 values: 0 1 2 3 4 5 6 7 8 9 A B C
             D E F. These commands control various  aspects  of  note  and
             song  playback.   An  effect  command  generally takes effect
             starting immediately with the note field associated with that
             effect.

             The  argument  is  one  byte  long  and  is  represented   in
             hexadecimal.   A hexadecimal byte, in case you don't know, is
             a base 16 representation of a  number  that  consists  of  an
             "upper  nybble"  and a "lower nybble", each of which may take
             on a value of 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, A, B,  C,  D,  E,
             or  F.  Values from A - F correspond to the decimal values 10
             - 15.

             Certain commands listed below use the  2  nybbles  separately
             (e.g.  arpeggiation).  In  this  case,  the 1st nybble is one
             argument, and the 2nd nybble  is  the  2nd  argument.   Other
             commands  treat  the  2  nybbles  jointly  as  one byte (e.g.
             speed).  In  this  case,  the  decimal  equivalent   of   the
             hexidecimal  number  is  calculated by: (upper nybble * 16) +
             lower nybble.  So, for instance, an effect of  "F  1D"  would
             mean  set  the song speed ("F") to 29 (1*16 + D = 1*16 + 13 =
             29).

             Here's a list of effects and their  required  argument  byte.
             "xy"  for  the  argument  byte  means  each nybble is treated
             separately; "xx" means they are treated jointly as one byte.

             0 -- AREPEGGIATION
             Format:  0 xy

             Plays its associated note in arpeggiated fashion; that is, it
             rapidly steps the note between 3 pitch values:  the  original
             pitch  value,  the  original  pitch  value  +  "x"  number of
             halfsteps, and the original  pitch  value  +  "y"  number  of
             halfsteps.

             1 -- SLIDE UP
             Format:  1 xx

             Slides pitch up; slide speed is determined by the xx argument
             (remember, it's in hexadecimal).

             2 -- SLIDE DOWN
             Format:  2 xx

             Just like SLIDE UP except it slides the pitch down.

             3 -- SLIDE TO NOTE
             Format:  3 xx

             Similar  to  slide  except  it  slides  the pitch TOWARDS the
             pitch of the associated note field (commands  1  and  2  only
             specify  a  speed,  not  a  destination).  xx is the speed to
             slide the pitch.

             4 -- VIBRATO
             Format:  4 xy

             Performs  "vibrato"  on  a note (wavering  effect).  x is the
             vibrato speed; y is the vibrato depth.

             A -- VOLUME SLIDE
             Format:  A x0  or  A 0y

             Slides the volume either up or down.  If x is specified and y
             is  0,  the  volume is slid up at speed x.  If y is specified
             and x is 0, the volume is slid down at speed y.

             B -- POSITION JUMP
             Format:  B xx

             Breaks the pattern (i.e. stops  playing  it  at  its  current
             position)  and  jumps  to  position  xx (hexadecimal!) in the
             pattern sequence table.

             C -- SET VOLUME
             Format:  C xx

             Sets  the  volume  for  its associated note unit to xx.  Note
             that it only takes effect with its associated note unit,  not
             subsequent notes.  Valid volume range is 00 - 40 (hex).

             D -- PATTERN BREAK
             Format:  D 00

             Breaks the pattern (i.e. stops  playing  it  at  its  current
             position) and goes on to the next one in the pattern sequence
             table.  The argument is meaningless.

             F -- SET SPEED
             Format:  F xx

             Sets the speed of the song; hex values 00 - 1F are valid.

             The  best  way to understand what exactly these effects do is
             just to experiment and listen.

