Newsgroups: comp.theory.cell-automata
From: dbell@pdact.pd.necisa.oz.au (David I. Bell)
Subject: Spaceships in Conway's Life (Addendum 1a)
Organization: NEC Information Systems Australia, Canberra
Date: Tue, 02 Mar 1993 04:57:14 GMT
Message-ID: <1993Mar02.045714.24332@pdact.pd.necisa.oz.au>
Lines: 971

		Spaceships in Conway's Life (Addendum 1)
			by David I. Bell
			dbell@pdact.pd.necisa.oz.au
			2 Mar 1993


This is an addendum to my series of articles concerning Conway's Game of
Life.  In this article, I will show the new results about spaceships that
have been discovered since my series of articles was first posted in August
through October of 1992.

There have been new discoveries made in many of the categories of spaceships
which I had reported on in my articles.  The order of presentation in this
article will be based on the period of the spaceship.  So I will begin with
the period 2 spaceships, and end with the large period spaceships.

The vast majority of results in this article were found by Hartmut Holzwart.
These are mostly period 2 and period 4 spaceships.  (For period 4 spaceships,
almost all the results are his.)  I have contributed by finding some period 2
and period 3 spaceships, and working on large period spaceships.  Dean
Hickerson made a small but very significant contribution to these new results.

So now I will begin with the new results for period 2 c/2 spaceships.
Hartmut Holzwart found the following spaceship last September.  One of his
repeatable tagalongs from my article 2 has been slightly modified to allow
two of them to connect together.  This allows a spaceship to be constructed
which is as long and as wide as desired, and is quite dense.

 [Dense period 2 spaceship (speed c/2)]
 ..............O...................................
 ...........OOOO...................................
 ...........OO.....................................
 .........O...OO...................................
 .........OOOO.O...................................
 ......O.O.........................................
 .....OOOOOO.......................................
 ....OO.....O......................................
 ...OO....O........................................
 ....OO...OO.......................................
 ..........OOO.....................................
 ....OO......O.....................................
 ...OO.O...........................................
 ..OO..............................................
 .OO..O............................................
 OO................................................
 .OOOOO............................................
 ..................................................
 .OOOOO............................................
 OO................................................
 .OO..O............................................
 ..OO..............................................
 ...OO.O...........................................
 ....OO............................................
 ..................................................
 ....OO.............O.........O.........O.........O
 ...OO..OO........OOO.......OOO.......OOO.......OOO
 ..OO..OOO.......OO........OO........OO........OO..
 .OOO.O..........O.........O.........O.........O...
 ..OO..OOO.....O.O.......O.O.......O.O.......O.O...
 ...OO..OO...OOO.......OOO.......OOO.......OOO.....
 ....OO.....OO.O......OO.O......OO.O......OO.O.....
 ...........O.O.OO....O.O.OO....O.O.OO....O.O.OO...
 ....OO.....OO..OO....OO..OO....OO..OO....OO..OO...
 ...OO..OO..O.....OO..O.....OO..O.....OO..O.....OO.
 ..OO..OOO..OO..OO.O..OO..OO.O..OO..OO.O..OO..OO.O.
 .OOO.O.....OO.O......OO.O......OO.O......OO.O.....
 ..OO..OOO..OO..OO.O..OO..OO.O..OO..OO.O..OO..OO.O.
 ...OO..OO..O.....OO..O.....OO..O.....OO..O.....OO.
 ....OO.....OO..OO....OO..OO....OO..OO....OO..OO...
 ...........O.O.OO....O.O.OO....O.O.OO....O.O.OO...
 ....OO.....OO.O......OO.O......OO.O......OO.O.....
 ...OO..OO...OOO.......OOO.......OOO.......OOO.....
 ..OO..OOO.....O.O.......O.O.......O.O.......O.O...
 .OOO.O..........O.........O.........O.........O...
 ..OO..OOO.....O.O.......O.O.......O.O.......O.O...
 ...OO..OO...OOO.......OOO.......OOO.......OOO.....
 ....OO.....OO.O......OO.O......OO.O......OO.O.....
 ...........O.O.OO....O.O.OO....O.O.OO....O.O.OO...
 ....OO.....OO..OO....OO..OO....OO..OO....OO..OO...
 ...OO..OO..O.....OO..O.....OO..O.....OO..O.....OO.
 ..OO..OOO..OO..OO.O..OO..OO.O..OO..OO.O..OO..OO.O.
 .OOO.O.....OO.O......OO.O......OO.O......OO.O.....
 ..OO..OOO..OO..OO.O..OO..OO.O..OO..OO.O..OO..OO.O.
 ...OO..OO..O.....OO..O.....OO..O.....OO..O.....OO.
 ....OO.....OO..OO....OO..OO....OO..OO....OO..OO...
 ...........O.O.OO....O.O.OO....O.O.OO....O.O.OO...
 ....OO.....OO.O......OO.O......OO.O......OO.O.....
 ...OO..OO...OOO.......OOO.......OOO.......OOO.....
 ..OO..OOO.....O.O.......O.O.......O.O.......O.O...
 .OOO.O..........O.........O.........O.........O...
 ..OO..OOO.....O.O.......O.O.......O.O.......O.O...
 ...OO..OO...OOO.......OOO.......OOO.......OOO.....
 ....OO.....OO.O......OO.O......OO.O......OO.O.....
 ...........O.O.OO....O.O.OO....O.O.OO....O.O.OO...
 ....OO.....OO..OO....OO..OO....OO..OO....OO..OO...
 ...OO..OO..O.....OO..O.....OO..O.....OO..O.....OO.
 ..OO..OOO..OO..OO.O..OO..OO.O..OO..OO.O..OO..OO.O.
 .OOO.O.....OO.O......OO.O......OO.O......OO.O.....
 ..OO..OOO..OO..OO.O..OO..OO.O..OO..OO.O..OO..OO.O.
 ...OO..OO..O.....OO..O.....OO..O.....OO..O.....OO.
 ....OO.....OO..OO....OO..OO....OO..OO....OO..OO...
 ...........O.O.OO....O.O.OO....O.O.OO....O.O.OO...
 ....OO.....OO.O......OO.O......OO.O......OO.O.....
 ...OO..OO...OOO.......OOO.......OOO.......OOO.....
 ..OO..OOO.....O.O.......O.O.......O.O.......O.O...
 .OOO.O..........O.........O.........O.........O...
 ..OO..OOO.......OO........OO........OO........OO..
 ...OO..OO........OOO.......OOO.......OOO.......OOO
 ....OO.............O.........O.........O.........O
 ..................................................
 ....OO............................................
 ...OO.O...........................................
 ..OO..............................................
 .OO..O............................................
 OO................................................
 .OOOOO............................................
 ..................................................
 .OOOOO............................................
 OO................................................
 .OO..O............................................
 ..OO..............................................
 ...OO.O...........................................
 ....OO......O.....................................
 ..........OOO.....................................
 ....OO...OO.......................................
 ...OO....O........................................
 ....OO.....O......................................
 .....OOOOOO.......................................
 ......O.O.........................................
 .........OOOO.O...................................
 .........O...OO...................................
 ...........OO.....................................
 ...........OOOO...................................
 ..............O...................................


Hartmut also found two new "arm" components for period 2 spaceships.
These arms are derived from the "glancing head" component, and have slopes
of 5/17 and 5/13.  The following spaceship shows two copies of both of
these components.

 [Period 2 spaceship with arm components (speed c/2)]
 .............................O.O
 ............................O..O
 ...........................OO...
 ..........................O...O.
 .........................OOO.O..
 ........................O.......
 .......................O..OOOO..
 .......................O..O.....
 .......................OOO.OOO..
 .........................OO.....
 ............................O...
 ..........................O.....
 ..........................OO....
 ........................OOO.....
 .......................O...O....
 ......................OO........
 .....................O...O......
 ....................OOO.O.......
 ...................O............
 ..................O..OOOO.......
 ..................O..O..........
 ..................OOO.OOO.......
 ....................OO..........
 .......................O........
 .....................O..........
 .....................OO.........
 ...................OOO..........
 ..................O...O.........
 .................OO.............
 ................O...O...........
 ...............OOO.O............
 ..............O.................
 .............O..OOOO............
 .............O..O...............
 .............OOO.OOO............
 ...............OO...............
 ..................O.............
 ...............O.O..............
 ..............OO................
 ...............OO...............
 ................OOO.............
 .................O..............
 ...................O............
 ..............O.O.O.............
 .............O..O...............
 ............OO..................
 ...........O...O................
 ..........OOO.O.................
 .........O......................
 ........O..OOOO.................
 ........O..O....................
 ........OOO.OOO.................
 ..........OO....................
 .............O..................
 ..........O.O...................
 .........OO.....................
 ..........OO....................
 ...........OOO..................
 ............O...................
 ..............O.................
 .........O.O.O..................
 ........O..O....................
 .......OO.......................
 ......O.........................
 .....OOOOOO.....................
 ..OO.......O....................
 .O...OOO.O......................
 O...O....O......................
 O.....O....O....................
 OOO...OOOOO.....................
 ................................
 OOO...OOOOO.....................
 O.....O....O....................
 O...O....O......................
 .O...OOO.O......................
 ..OO.......O....................
 .....OOOOOO.....................
 ......O.........................
 .......OO.......................
 ........O..O....................
 .........O.O....................


Hartmut also found the following spaceship, which has repeatable glide-
reflective wicks trailing from the ends.  Between the two main components
is a large repeatable component which is only a slightly modified version
of Dean Hickerson's long period 2 spaceship.  The central component was
found using Hartmut's cylindrical search feature of the life search program.

 [Period 2 spaceship with glide-reflective wick and repeatable component
 (speed c/2)]
 ...............................................O........
 ...................O.............O..........OO.O........
 ................OOOO..........OOOO..........O...........
 ................OO............OO............O...........
 ............O.O...........O.O...........O.O.............
 ..........OO...OOOOO....OO...OOOOO....OO...OOO.......O..
 ........OO...O........OO...O........OO...O.........OOO..
 ........OOO.O..OOO.O..OOO.O..OOO.O..OOO.O..OOO....OO....
 ......O........OO...O........OO...O........OO.O...O.....
 ......OOOOOOO....OO...OOOOO....OO...OOOOO....OO.....O...
 ...O.O.............O.O...........O.O..........OOOOOO....
 ..OOOOOOO.O............OO............OO........O.O......
 .OO.......O............OOOO..........OOOO.........OOOO.O
 OO....OO..................O.............O.........O...OO
 .OO....O.O..........................................OO..
 ....................................................OOOO
 .OO....O.O.............................................O
 OO....OO.......O.O......................................
 .OO.......O..O.O........................................
 ..OOOOOOO.O.O.O...O.....................................
 ...O.O........OOO.O.....................................
 ......OOO.OO............................................
 ......O...OO.OO.........................................
 ........OOO.............................................
 ........OOO.............................................
 ........................................................
 ........OOO.............................................
 ........OOO.............................................
 ......O...OO.OO.........................................
 ......OOO.OO............................................
 ...O.O........OOO.O.....................................
 ..OOOOOOO.O.O.O...O.....................................
 .OO.......O..O.O........................................
 OO....OO.......O.O......................................
 .OO....O.O..............................................
 ........................................................
 .OO....O.O..............................................
 OO....OO.......O.O......................................
 .OO.......O..O.O........................................
 ..OOOOOOO.O.O.O...O.....................................
 ...O.O........OOO.O.....................................
 ......OOO.OO............................................
 ......O...OO.OO.........................................
 ........OOO.............................................
 ........OOO.............................................
 ........................................................
 ........OOO.............................................
 ........OOO.............................................
 ......O...OO.OO.........................................
 ......OOO.OO............................................
 ...O.O........OOO.O.....................................
 ..OOOOOOO.O.O.O...O.....................................
 .OO.......O..O.O........................................
 OO....OO.......O.O......................................
 .OO....O.O.............................................O
 ....................................................OOOO
 .OO....O.O..........................................OO..
 OO....OO..................O.............O.........O...OO
 .OO.......O............OOOO..........OOOO.........OOOO.O
 ..OOOOOOO.O............OO............OO........O.O......
 ...O.O.............O.O...........O.O..........OOOOOO....
 ......OOOOOOO....OO...OOOOO....OO...OOOOO....OO.....O...
 ......O........OO...O........OO...O........OO.O...O.....
 ........OOO.O..OOO.O..OOO.O..OOO.O..OOO.O..OOO....OO....
 ........OO...O........OO...O........OO...O.........OOO..
 ..........OO...OOOOO....OO...OOOOO....OO...OOO.......O..
 ............O.O...........O.O...........O.O.............
 ................OO............OO............O...........
 ................OOOO..........OOOO..........O...........
 ...................O.............O..........OO.O........
 ...............................................O........


Hartmut's cylindrical search also found several other repeatable components
related to the one in the above spaceship.  Most of these join each other
in the same manner in one spot.

[Period 2 spaceship demonstrating several repeating components (speed c/2)]
 .............O.........
 ...........OO..........
 ........OOOO.O.........
 ........OO.............
 ......O...OO.O.........
 ......OOOO.O.O.OO......
 ...O.O......OO.........
 ..OOOOOO.OO.OO.O....O..
 .OO.....OO...O...OOOO..
 OO....OO....O....OO....
 .OO....OOOO............
 .......................
 .OO....OOOO............
 OO....OO....O....OO....
 .OO.....OO...O...OOOO..
 ..OOOOOO.OO.OO.O....O..
 ...O.O......OO.........
 ......OOOO.O.O.OO......
 ......O...OO.O.........
 ........OOO............
 ........OOO............
 .......................
 ........OOO............
 ........OOO......OO....
 ......O...OO.O...OOOO..
 ......OOOO.O.O.O....O..
 ...O.O......OO.........
 ..OOOOOO.OO.OO.OO......
 .OO.....OO...O.........
 OO....OO....O..........
 .OO....OOOO............
 .......................
 .OO....OOOO............
 OO....OO....O.........O
 .OO.....OO...O.....OOOO
 ..OOOOOO.OO.OO.....OO..
 ...O.O......OO.O.O.....
 ......OOOO.O.O.OO.OO.O.
 ......O...OO..O..OO.O.O
 ........OOO..OO....OO..
 ........OOO...O.OOO.O..
 .......................
 ........OOO...O.OOO.O..
 ........OOO..OO....OO..
 ......O...OO..O..OO.O.O
 ......OOOO.O.O.OO.OO.O.
 ...O.O......OO.O.O.....
 ..OOOOOO.OO.OO.....OO..
 .OO.....OO...O.....OOOO
 OO....OO....O.........O
 .OO....OOOO............
 .......................
 .OO....OOOO............
 OO....OO....O..........
 .OO.....OO...O.........
 ..OOOOOO.OO.OO.OO......
 ...O.O......OO.........
 ......OOOO.O.O.O....O..
 ......O...OO.O...OOOO..
 ........OOO......OO....
 ........OOO............
 .......................
 ........OOO............
 ........OOO............
 ......O...OO.O.........
 ......OOOO.O.O...O.O...
 ...O.O......OO.OO..O...
 ..OOOOOO.OO.OO.OO......
 .OO.....OO...O....O....
 OO....OO....O..OO......
 .OO....OOOO....OOO.....
 .......................
 .OO....OOOO....OOO.....
 OO....OO....O..OO......
 .OO.....OO...O....O....
 ..OOOOOO.OO.OO.OO......
 ...O.O......OO.OO..O...
 ......OOOO.O.O...O.O...
 ......O...OO.O.........
 ........OOO............
 ........OOO............
 .......................
 ........OOO............
 ........OOO............
 ......O...OO.O.........
 ......OOOO.O.O.........
 ...O.O......OO.OO..O...
 ..OOOOOO.OO.OO.OO..O...
 .OO.....OO...O....O....
 OO....OO....O..OO......
 .OO....OOOO....OOO.....
 .......................
 .OO....OOOO....OOO.....
 OO....OO....O..OO......
 .OO.....OO...O....O....
 ..OOOOOO.OO.OO.OO..O...
 ...O.O......OO.OO..O...
 ......OOOO.O.O.........
 ......O...OO.O.........
 ........OOO............
 ........OOO............
 .......................
 ........OOO............
 ........OOO........O.O.
 ......O...OO.O....O..O.
 ......OOOO.O.O.O.OO....
 ...O.O......OO.........
 ..OOOOOO.OO.OO.OOOOOO.O
 .OO.....OO...O...O...OO
 OO....OO....O......OOO.
 .OO....OOOO........OOO.
 .......................
 .OO....OOOO........OOO.
 OO....OO....O......OOO.
 .OO.....OO...O...O...OO
 ..OOOOOO.OO.OO.OOOOOO.O
 ...O.O......OO.........
 ......OOOO.O.O.O.OO....
 ......O...OO.O....O..O.
 ........OOO........O.O.
 ........OOO............
 .......................
 ........OOO............
 ........OOO............
 ......O...OO.O.........
 ......OOOO.O.O.OO......
 ...O.O......OO.........
 ..OOOOOO.OO.OO.O....O..
 .OO.....OO...O...OOOO..
 OO....OO....O....OO....
 .OO....OOOO............
 .......................
 .OO....OOOO............
 OO....OO....O......O.O.
 .OO.....OO...O....O..O.
 ..OOOOOO.OO.OO.O.OO....
 ...O.O......OO.........
 ......OOOO.O.O.OOOOOO.O
 ......O...OO.O...O...OO
 ........OOO........OOO.
 ........OOO........OOO.
 .......................
 ........OOO........OOO.
 ........OOO........OOO.
 ......O...OO.O...O...OO
 ......OOOO.O.O.OOOOOO.O
 ...O.O......OO.........
 ..OOOOOO.OO.OO.O.OO....
 .OO.....OO...O....O..O.
 OO....OO....O......O.O.
 .OO....OOOO............
 .......................
 .OO....OOOO............
 OO....OO....O....OO....
 .OO.....OO...O...OOOO..
 ..OOOOOO.OO.OO.O....O..
 ...O.O......OO.........
 ......OOOO.O.O.OO......
 ......O...OO.O.........
 ........OO.............
 ........OOOO.O.........
 ...........OO..........
 .............O.........


Hartmut looked for period 2 spaceships with even symmetry, and found that
there are no spaceships with a width less than 28.  The smallest minimum
width spaceship which has even symmetry is the following.  Removing one
of the two middle rows will produce a spaceship with odd symmetry (but not
the one of minimum width).

[Period 2 spaceship with even symmetry of minimum width 28 (speed c/2)]
 .........O.O
 ........O..O
 .......OO...
 ......O....O
 .....OOOOO.O
 ..OO........
 .O...OOO....
 O...O.......
 O.....O.....
 O..O..O.....
 .O.O..OO.O..
 .........O..
 OOO.........
 OO..........
 OO..........
 OOO.........
 .........O..
 .O.O..OO.O..
 O..O..O.....
 O.....O.....
 O...O.......
 .O...OOO....
 ..OO........
 .....OOOOO.O
 ......O....O
 .......OO...
 ........O..O
 .........O.O


Hartmut found several modifications and tagalongs for the above spaceship.
Two of these are shown below.

 [Period 2 spaceship with large tagalongs (speed c/2)]
 .........OO.................O.....
 ........O...............OO.OO..O..
 .......OO..O...........O.....O.O..
 ......O....O..........OO..OO......
 .....OOOOO...........O............
 ..OO.....OO....O....OOO.OO.O.....O
 .O...OOO..O..OOO...O.....O....OOOO
 O...O.....OO.OO...OOO....OO...OO..
 O.....O...O...O..O.....OO...O.....
 O..O..O.....OOO.OOO....O..OO......
 .O.O..OO.O..OO.....O...O.O........
 .........O.....OOO.........OOO....
 OOO............OO.....OOO..O..O...
 OO...............O....OO...OO.....
 OO...............O....OO...OO.....
 OOO............OO.....OOO..O..O...
 .........O.....OOO.........OOO....
 .O.O..OO.O..OO.....O...O.O........
 O..O..O.....OOO.OOO....O..OO......
 O.....O...O...O..O.....OO...O.....
 O...O.....OO.OO...OOO....OO...OO..
 .O...OOO..O..OOO...O.....O....OOOO
 ..OO.....OO....O....OOO.OO.O.....O
 .....OOOOO...........O............
 ......O....O..........OO..OO......
 .......OO..O...........O.....O.O..
 ........O...............OO.OO..O..
 .........OO.................O.....


 .........OO.................O...........
 ........O...............OO.OO..O........
 .......OO..O...........O.....O.O........
 ......O....O..........OO..OO............
 .....OOOOO...........O.................O
 ..OO.....OO....O....OOO.OO.O.....O.O.OO.
 .O...OOO..O..OOO...O.....O....OOOO.O.O.O
 O...O.....OO.OO...OOO....OO...OO..O.....
 O.....O...O...O..O.....OO...O.....OOO...
 O..O..O.....OOO.OOO....O..OO......O.....
 .O.O..OO.O..OO.....O...O.O........O.O...
 .........O.....OOO.........OOO..........
 OOO............OO.....OOO..O..O..OOO....
 OO...............O....OO...OO....OO.....
 OO...............O....OO...OO....OO.....
 OOO............OO.....OOO..O..O..OOO....
 .........O.....OOO.........OOO..........
 .O.O..OO.O..OO.....O...O.O........O.O...
 O..O..O.....OOO.OOO....O..OO......O.....
 O.....O...O...O..O.....OO...O.....OOO...
 O...O.....OO.OO...OOO....OO...OO..O.....
 .O...OOO..O..OOO...O.....O....OOOO.O.O.O
 ..OO.....OO....O....OOO.OO.O.....O.O.OO.
 .....OOOOO...........O.................O
 ......O....O..........OO..OO............
 .......OO..O...........O.....O.O........
 ........O...............OO.OO..O........
 .........OO.................O...........


The second spaceship above differs by the addition of a short wide tagalong
which attaches to the feet of the previous tagalong.  This tagalong can
also be used in other spaceships where the feet appear, to join the two
spaceships.  For example, an odd-symmetrical version of the tagalong is
shown below which joins two old spaceships.

 [Period 2 spaceships joined by bridging tagalong (speed c/2)]
 .............O.............
 ...........OO..............
 ........OOOO.O.............
 ........OO.......OO........
 ......O...OO.O...OOOO......
 ......OOOO.O.O.O....O......
 ...O.O......OO.............
 ..OOOOOO.OO.OO.OO..........
 .OO.....OO...O.............
 OO....OO....O..............
 .OO....OOOO................
 ...........................
 .OO....OOOO................
 OO....OO....O..............
 .OO.....OO...O.............
 ..OOOOOO.OO.OO.OO..........
 ...O.O......OO............O
 ......OOOO.O.O.O....O.O.OO.
 ......O...OO.O...OOOO.O.O.O
 ........OO.......OO..O.....
 ........OOOO.O.......OOO...
 ...........OO........O.....
 .............O.......O.O...
 ...........................
 ....................OOO....
 ....................OO.....
 ....................OOO....
 ...........................
 .............O.......O.O...
 ...........OO........O.....
 ........OOOO.O.......OOO...
 ........OO.......OO..O.....
 ......O...OO.O...OOOO.O.O.O
 ......OOOO.O.O.O....O.O.OO.
 ...O.O......OO............O
 ..OOOOOO.OO.OO.OO..........
 .OO.....OO...O.............
 OO....OO....O..............
 .OO....OOOO................
 ...........................
 .OO....OOOO................
 OO....OO....O..............
 .OO.....OO...O.............
 ..OOOOOO.OO.OO.OO..........
 ...O.O......OO.............
 ......OOOO.O.O.O....O......
 ......O...OO.O...OOOO......
 ........OO.......OO........
 ........OOOO.O.............
 ...........OO..............
 .............O.............


In one of Hartmut's results there appeared an L-shaped repeating component
which is very small and simple.  I was asked to "tame" it by finding
components which terminated the two ends.  Amazingly, the component that
I found for the front of the L components connects to them on both of its
sides.  The following spaceship shows the front component, two arms made of
the L components, and the back component that I found.  Also shown is one
of a number of "feet" which can be attached to the L component.

[Period 2 spaceship with simple "L" arms (speed c/2)]
 ............................O
 .........................OOOO
 .........................OO..
 .......................O...OO
 .......................OOOO.O
 ....................O.O......
 ...................OOOOOO....
 ..................OO.....O...
 .................OO....O.....
 ..................O.O..OO....
 ........................OOO..
 ..................OO......O..
 .................O...........
 .................OOO.........
 ...............O.............
 ...............OOO...........
 .............O...............
 .............OOO.............
 ...........O.................
 ...........OOO...............
 .........O...................
 .........OOO.................
 .......O.....OO..............
 .......OOO...OOOO............
 .....O..........O............
 .....OOO.....................
 ...O.........................
 ...OOO.......................
 ..O..........................
 .OOO.O.......................
 .O...........................
 .OOOOO.......................
 ........O.O..................
 .O.O...O..O..................
 OO....OO.....................
 .OO......O...................
 ..OOOOO.O....................
 ...O.O.......................
 ......OOO....................
 ......O......................
 ........OOO..................
 ........O....................
 ..........OOO................
 ..........O..................
 ............OOO..............
 ............O................
 ..............OOO............
 ..............O..............
 ...............OO......O.....
 .....................OOO.....
 ...............O.O..OO.......
 ..............OO....O........
 ...............OO.....O......
 ................OOOOOO.......
 .................O.O.........
 ....................OOOO.O...
 ....................O...OO...
 ......................OO.....
 ......................OOOO...
 .........................O...


I did not find a front component for a single arm of the L components.  But
I did find that the L component can be connected to the standard component
that connects to the feet of many period 2 spaceships.  This is shown below,
where the L arm is connected to the back foot of the wicktrailer on a base
spaceship.

 [Period 2 spaceship with L arm component connection (speed c/2)]
 ............................O.....................
 .............O...........OOOO.....................
 ...........OO..........OOO.O......................
 ........OOOO.O........OO...O......................
 ........OO.......OO...O....OO.....................
 ......O...OO.O...OOOO.O.....OOO.O.................
 ......OOOO.O.O.O....OOOO......O.O.................
 ...O.O......OO.........O........OO................
 ..OOOOOO.OO.OO.OO..............OO.................
 .OO.....OO...O................O..O................
 OO....OO....O................O....................
 .OO....OOOO..................O....................
 .............................OOO..................
 .OO....OOOO...................O...................
 OO....OO....O.................OOOO................
 .OO.....OO...O...............O....O...............
 ..OOOOOO.OO.OO.OO.............O.O.................
 ...O.O......OO................O...O...............
 ......OOOO.O.O.O....O..........OOO................
 ......O...OO.O...OOOO...........O.................
 ........OO.......OO..............OOO..............
 ........OOOO.O....................O...............
 ...........OO......................OOO............
 .............O......................O.............
 .....................................OOO..........
 ......................................O...........
 .......................................O.......O..
 .......................................O....OO.O..
 ......................................OOO...O.....
 ......................................O.....O.....
 ......................................O...O.......
 .......................................O...OOO....
 ........................................OO........
 ...........................................OOOOO.O
 ............................................O....O
 .............................................OO...
 ..............................................O..O
 ...............................................O.O


I found another very messy connection of the L component to the feet of
period 2 spaceships.  This is illustrated below.  The almost-symmetrical
component in the middle is interesting, for it appears that it might be
made larger somehow.  But this has not been done yet.

 [Messy connection of L component with base period 2 spaceship (speed c/2)]
 .........................O
 ......................OOOO
 ......................OO..
 ....................O...OO
 ....................OOOO.O
 .................O.O......
 ................OOOOOO....
 ...............OO.....O...
 ..............OO....O.....
 ...............O.O..OO....
 .....................OOO..
 ...............OO......O..
 ..............O...........
 ..............OOO.........
 ............O.............
 ............OOO...........
 ..........O...............
 ..........OOO.............
 ........O.................
 ........OOO...............
 .......O..................
 ......OOO.O...............
 ......O...................
 ......OOOOO...............
 .............O.O..........
 ......O.O...O..O..........
 .....OO....OO.............
 ......OO..................
 .......OOOOOOOO...........
 ........O.O....O..........
 ..........OO.O............
 ..........O..O............
 ...............O..........
 ..........OOOOO...........
 .........OO...............
 ........OO..OOO...........
 .......OOO.O...O..........
 ........OO..OO............
 .........OO....O..........
 ..........OOOO.O..........
 ..............O...........
 ........OOOO.O.O..........
 .......OO...OO............
 ......OO..OO...O..........
 .....OOO..OOOO.O..........
 ......O......O.O..........
 .......O..................
 .......O..................
 ......OOO.................
 ......O...................
 ......O...................
 .......O..O...............
 ........OO................
 .........OO...............
 .......O.O................
 ....OOOO.O................
 ....OO....................
 ..O.......................
 ..OOOO....................
 .O........................
 OOO..O....................
 .OOO......................
 ..O.......................
 ...OOO.O..................
 ...O..OO..................
 ....OOO...................
 ......O...................
 ....O.....................
 ....O.O...................
 ...O......................
 ....O.O...................
 ....O.....................
 ......O...................
 ....OOO...................
 ...O..OO..................
 ...OOO.O..................
 ..O.......................
 .OOO......................
 OOO..O....................
 .O........................
 ..OOOO....................
 ..O.......................
 ....OO....................
 ....OOOO..................
 .......O..................


I found another "barber pole" component for period 2 spaceships.  Like the
previous barber pole component, this one appears the same in both phases,
only shifted.  The effect is not as obvious in this example, however, since
the component is so large.  The component can have feet attached to it at
many places, as is shown below.

 [Period 2 spaceship with "barber pole" repeating component (speed c/2)]
 .................O...
 ..............OOOO...
 ..............OO.....
 ............O........
 ............OOOO.....
 ...........O.........
 ..........OOO..O.....
 ...........OOO.......
 ............O........
 .............OOO.O...
 .............O..OO...
 ..............OOO....
 ................O....
 ..............O......
 ..............O.O....
 .............O.......
 ..............O.O....
 ..............O......
 ................O....
 ..............OOO....
 .............O..OO...
 .............OOO.O...
 ............O........
 ...........OOO.......
 ..........OOO..O.....
 ...........O.........
 ............OOOO.....
 ............O........
 ..............OO.....
 ..............OOOO.O.
 .................O.O.
 ...................OO
 ..................OO.
 .................O..O
 ................O....
 ................O....
 ................O....
 .................OO..
 .....................
 .................O.O.
 ................OO..O
 ................O.O..
 ................OO...
 ................O....
 ...............OOO...
 ...............O..O..
 ..............O..O...
 ..............OO.....
 .....................
 ..............O.O....
 .............OO..O...
 .............O.O.....
 .............OO......
 .............O.......
 ............OOO......
 ............O..O.....
 ...........O..O......
 ...........OO........
 .....................
 ...........O.O.......
 ..........OO..O......
 ..........O.O...OO...
 ..........OO....OOOO.
 ..........O........O.
 .........OOO.........
 .........O..O........
 ........O..O.........
 ........OO...........
 .....................
 ........O.O..........
 .......OO..O.........
 .......O.O...........
 .......OO............
 .......O.............
 ......OOO............
 ......O..............
 ......O..............
 .......O..O..........
 ........OO...........
 .........OO..........
 .......O.O...........
 ....OOOO.O...........
 ....OO...............
 ..O..................
 ..OOOO...............
 .O...................
 OOO..O...............
 .OOO.................
 ..O..................
 ...OOO.O.............
 ...O..OO.............
 ....OOO..............
 ......O..............
 ....O................
 ....O.O..............
 ...O.................
 ....O.O..............
 ....O................
 ......O..............
 ....OOO..............
 ...O..OO.............
 ...OOO.O.............
 ..O..................
 .OOO.................
 OOO..O...............
 .O...................
 ..OOOO...............
 ..O..................
 ....OO...............
 ....OOOO.............
 .......O.............


That was a summary of the new developments for period 2 spaceships.  Now I
will move on to period 3 c/3 spaceships.  There are not many new results to
report for period 3 spaceships.  All of these results were found by me.

Newsgroups: comp.theory.cell-automata
From: dbell@pdact.pd.necisa.oz.au (David I. Bell)
Subject: Spaceships in Conway's Life (Addendum 1b)
Organization: NEC Information Systems Australia, Canberra
Date: Tue, 02 Mar 1993 04:58:02 GMT
Message-ID: <1993Mar02.045802.24394@pdact.pd.necisa.oz.au>
Lines: 1063

Ever since I found the period 9 tail to period 3 c/3 spaceships, I have wanted
to turn that tail into a small component compatible with the rest of Dean
Hickerson's period 3 grammar.  At the beginning of 1993, I finally succeeded.
The resulting spaceship is shown below.

[Period 9 tail connecting to period 3 components (speed c/3)]
 .......O......
 ......O.O.....
 ......O.O.....
 ......O.......
 .....OO.......
 .....O.O......
 ..............
 ....OOO.......
 ....OO........
 ..............
 ......OOO.....
 .....O.OO.....
 ....O.........
 ....O.........
 ...OOO........
 ..O...........
 ..O..O........
 ..O..OO.......
 .....O........
 ....OO........
 .....OO.......
 ..O.....O.....
 ..O..O.O......
 .O.O..O.......
 OOO...........
 ....OOO.O.....
 ...OOO..O.....
 .OO...........
 .OOO..........
 ..............
 .O.O..........
 .O.O..........
 .O..OO........
 ..O.OO........
 ..O...........
 ....O.........
 ..OOO.........
 ..OOO.........
 ......OO......
 ......OOO.....
 ..............
 ......OOO.....
 ...O..O.......
 ..O.O.O.......
 .O..O.O.O.....
 ..O...O.......
 ...OO.........
 ..OO...O......
 .OOOOO........
 .O...OOO......
 ...O..........
 ...OO.........
 ..............
 ..O..O........
 ..O..OO.......
 .OO...O.......
 .O....O.......
 .OO.OOO.......
 ..O...O.......
 ..OO...OO.....
 ...O.OOO.....O
 ....OO.O....OO
 ......O...O.O.
 ......OOOO..O.
 ............O.
 ............O.
 ............O.
 ......OOOO..O.
 ......O...O.O.
 ....OO.O....OO
 ...O.OOO.....O
 ..OO...OO.....
 ..O...O.......
 .OO.OOO.......
 .O....O.......
 .OO...O.......
 ..O..OO.......
 ..O..O........
 ..............
 ...OO.........
 ...O..........
 .O...OOO......
 .OOOOO........
 ..OO...O......
 ...OO.........
 ..O...O.......
 .O..O.O.O.....
 ..O.O.O.......
 ...O..O.......
 ......OOO.....
 ..............
 ......OOO.....
 ......OO......
 ..OOO.........
 ..OOO.........
 ....O.........
 ..O...........
 ..O.OO........
 .O..OO........
 .O.O..........
 .O.O..........
 ..............
 .OOO..........
 .OO...........
 ...OOO..O.....
 ....OOO.O.....
 OOO...........
 .O.O..O.......
 ..O..O.O......
 ..O.....O.....
 .....OO.......
 ....OO........
 .....O........
 ..O..OO.......
 ..O..O........
 ..O...........
 ...OOO........
 ....O.........
 ....O.........
 .....O.OO.....
 ......OOO.....
 ..............
 ....OO........
 ....OOO.......
 ..............
 .....O.O......
 .....OO.......
 ......O.......
 ......O.O.....
 ......O.O.....
 .......O......


This is a large solution to the problem, however.  It only connects to Dean's
grammar at about 13 cells from either end.  The rest of it is made up of
new components.

I then looked for a smaller solution.  The following shows two things.
Firstly, a shorter arm is demonstrated which connects to the p9 component.
This is seen at the top and bottom.  The component has the same two-bit
spark as is produced by Dean's "turtle" spaceship.  Secondly, between two
copies of the period 9 component is a large symmetrical component.  Using
this you can make a wide spaceship with as many period 9 components in it
as you want.

[Period 3 spaceship with several period 9 components (speed c/3)]
 ...O.........
 ..O.O........
 .OO..........
 ...O.........
 .OO..........
 .OOO.........
 .............
 ..O.O........
 ..OOO........
 .............
 .....OOO.....
 .....OOO.....
 .............
 ....OO.......
 ....OO.......
 ......O......
 .............
 ...OOO.......
 ...O.OO......
 ......O......
 ..OOO.O......
 .O....O......
 .OO.OOO......
 OO.O..O......
 ....OO.......
 .O..OO.......
 .O..O........
 .O.OO........
 ..O.OO.O.....
 .....O.O.....
 .............
 .....OO......
 ....O..O.....
 ...OOO.......
 .......O.....
 ......O......
 ..O..........
 .OO.O........
 .O..OO.......
 OO...O.......
 O....O.......
 OO.OOO.......
 .O...O.......
 .OO...OO.....
 ..O.OOO.....O
 ...OO.O....OO
 .....O...O.O.
 .....OOOO..O.
 ...........O.
 ...........O.
 ...........O.
 .....OOOO..O.
 .....O...O.O.
 ...OO.O....OO
 ..O.OOO.....O
 .OO...OO.....
 .O...O.......
 OO.OOO.......
 O....O.......
 OO...O.......
 .O..OO.......
 .OO.O........
 ..O..........
 ......O......
 .......O.....
 ...OOO.......
 ....O..O.....
 .....OO......
 .............
 .....O.O.....
 ..O.OO.O.....
 .O.OO........
 .O..O........
 .O..OO.......
 ...OO........
 OO..OO.......
 .OO..........
 ..OOOO.......
 ......O......
 ..OOO........
 OO....O......
 OO..O.O......
 O..O.........
 OO.OOO.......
 ....OO.......
 ..O...OO.....
 ..O.OOOO.....
 ..O..........
 ...O.........
 ....OOO......
 ...OO.O......
 ..O..........
 .O..O........
 ..O.OOO......
 .............
 ..OOO........
 ...OOO.O.....
 .....O.......
 .....O.......
 .....OO......
 .............
 .....OO......
 .....O.......
 .....O.......
 ...OOO.O.....
 ..OOO........
 .............
 ..O.OOO......
 .O..O........
 ..O..........
 ...OO.O......
 ....OOO......
 ...O.........
 ..O..........
 ..O.OOOO.....
 ..O...OO.....
 ....OO.......
 OO.OOO.......
 O..O.........
 OO..O.O......
 OO....O......
 ..OOO........
 ......O......
 ..OOOO.......
 .OO..........
 OO..OO.......
 ...OO........
 .O..OO.......
 .O..O........
 .O.OO........
 ..O.OO.O.....
 .....O.O.....
 .............
 .....OO......
 ....O..O.....
 ...OOO.......
 .......O.....
 ......O......
 ..O..........
 .OO.O........
 .O..OO.......
 OO...O.......
 O....O.......
 OO.OOO.......
 .O...O.......
 .OO...OO.....
 ..O.OOO.....O
 ...OO.O....OO
 .....O...O.O.
 .....OOOO..O.
 ...........O.
 ...........O.
 ...........O.
 .....OOOO..O.
 .....O...O.O.
 ...OO.O....OO
 ..O.OOO.....O
 .OO...OO.....
 .O...O.......
 OO.OOO.......
 O....O.......
 OO...O.......
 .O..OO.......
 .OO.O........
 ..O..........
 ......O......
 .......O.....
 ...OOO.......
 ....O..O.....
 .....OO......
 .............
 .....O.O.....
 ..O.OO.O.....
 .O.OO........
 .O..O........
 .O..OO.......
 ....OO.......
 OO.O..O......
 .OO.OOO......
 .O....O......
 ..OOO.O......
 ......O......
 ...O.OO......
 ...OOO.......
 .............
 ......O......
 ....OO.......
 ....OO.......
 .............
 .....OOO.....
 .....OOO.....
 .............
 ..OOO........
 ..O.O........
 .............
 .OOO.........
 .OO..........
 ...O.........
 .OO..........
 ..O.O........
 ...O.........


The structure of the middle 3 rows in the above spaceship intrigued me, and
I then looked for more components that joined in that same manner.  The
following shows the results.  At the top is the smallest terminating
component that contains that connection (about 20 rows).  Below that is
a symmetrical component which includes a middle piece which is also in
some period 2 spaceships, but which here acts as period 3 (about 26 rows).
Below that is another symmetrical component (about 40 rows).  And at the
bottom is another copy of the termination component.

 [Period 3 spaceship with components connected in common manner (speed c/3)]
 ....O..
 ...O.O.
 ..OO...
 ...O...
 ..O.O..
 ..O....
 .O.....
 .O.O...
 .O.O...
 ..OOOO.
 ....O.O
 ....O.O
 ...O...
 ...OOO.
 .O.....
 .OOO...
 ..OOO.O
 ....O..
 ....O..
 ....OO.
 .......
 ....OO.
 ....O..
 ....O..
 ..OOO.O
 .OOO...
 .......
 .O.OOO.
 O..O...
 .O.O...
 ..O..OO
 .....OO
 ....OO.
 ...O.O.
 ..O....
 ...O.O.
 ....OO.
 .....OO
 ..O..OO
 .O.O...
 O..O...
 .O.OOO.
 .......
 .OOO...
 ..OOO.O
 ....O..
 ....O..
 ....OO.
 .......
 ....OO.
 ....O..
 ....O..
 ..OOO.O
 .OOO...
 .......
 .O.OOO.
 O..O...
 .O.O...
 ..O..OO
 .....OO
 ....OO.
 ...O.O.
 ...O...
 ..O..O.
 ..OOO.O
 .O..O..
 ..OOOOO
 ..O..O.
 ...OOOO
 .OO....
 ...OOOO
 ..O..O.
 ..OOOOO
 .O..O..
 ..OOO.O
 ..O..O.
 ...O...
 ...O.O.
 ....OO.
 .....OO
 ..O..OO
 .O.O...
 O..O...
 .O.OOO.
 .......
 .OOO...
 ..OOO.O
 ....O..
 ....O..
 ....OO.
 .......
 ....OO.
 ....O..
 ....O..
 ..OOO.O
 .OOO...
 .O.....
 ...OOO.
 ...O...
 ....O.O
 ....O.O
 ..OOOO.
 .O.O...
 .O.O...
 .O.....
 ..O....
 ..O.O..
 ...O...
 ..OO...
 ...O.O.
 ....O..


A few months ago Hartmut Holzwart did a little searching for cylindrical
components for period 3 spaceships.  He found an interesting partial result,
but could not finish it.  Recently I looked at it and found a way to tame it.

Here is the finished object.  It is a dense c/3 spaceship, which can be made
as wide and as long as desired.  Hartmut had found both of the repeatable
components in the center.  The thin stabilizing pieces on the sides of the
front are just the terminating component of the spaceship shown above.
At least one column of the repeating tagalongs is required to stabilize
the front of the spaceship.  So here is a case where the first column of
tagalongs aren't really tagalongs, but extra copies of the same component
are!

 [Dense period 3 spaceship (speed c/3)]
 ....O ..............................................................
 ...O.O..............................................................
 ..OO................................................................
 ...O................................................................
 ..O.O...............................................................
 ..O.................................................................
 .O..................................................................
 .O.O................................................................
 .O.O................................................................
 ..OOOO..............................................................
 ....O.O.............................................................
 ....O.O.............................................................
 ...O................................................................
 ...OOO..............................................................
 .O..................................................................
 .OOO................................................................
 ..OOO.O.............................................................
 ....O...............................................................
 ....O...............................................................
 ....OO..............................................................
 ....................................................................
 ....OO.....OO.O.O.O....OO.O.O.O....OO.O.O.O....OO.O.O.O....OO.O.O.O.
 ....O..O..O...O..OO...O...O..OO...O...O..OO...O...O..OO...O...O..OO.
 ....O.OO.O.....O.....O.....O.....O.....O.....O.....O.....O.....O....
 .....OOO..O......O.O..O......O.O..O......O.O..O......O.O..O......O.O
 .....OO.....OO..OO.O....OO..OO.O....OO..OO.O....OO..OO.O....OO..OO.O
 .......O...O...O.......O...O.......O...O.......O...O.......O...O....
 .....OO....O.OOO...O...O.OOO...O...O.OOO...O...O.OOO...O...O.OOO...O
 ......O.O..O...........O...........O...........O...........O........
 .......O....OOOOOOOO....OOOOOOOO....OOOOOOOO....OOOOOOOO....OOOOOOOO
 ....................................................................
 .......O....OOOOOOOO....OOOOOOOO....OOOOOOOO....OOOOOOOO....OOOOOOOO
 ......O.O..O...........O...........O...........O...........O........
 .....OO....O.OOO...O...O.OOO...O...O.OOO...O...O.OOO...O...O.OOO...O
 .......O...O...O.......O...O.......O...O.......O...O.......O...O....
 .....OO.....OO..OO.O....OO..OO.O....OO..OO.O....OO..OO.O....OO..OO.O
 .....OOO..O......O.O..O......O.O..O......O.O..O......O.O..O......O.O
 ....O.OO.O.....O.....O.....O.....O.....O.....O.....O.....O.....O....
 ....O..O..O...O..OO...O...O..OO...O...O..OO...O...O..OO...O...O..OO.
 ....OO.....OO.O.O.O....OO.O.O.O....OO.O.O.O....OO.O.O.O....OO.O.O.O.
 ....................................................................
 ....OO.....OO.O.O.O....OO.O.O.O....OO.O.O.O....OO.O.O.O....OO.O.O.O.
 ....O..O..O...O..OO...O...O..OO...O...O..OO...O...O..OO...O...O..OO.
 ....O.OO.O.....O.....O.....O.....O.....O.....O.....O.....O.....O....
 .....OOO..O......O.O..O......O.O..O......O.O..O......O.O..O......O.O
 .....OO.....OO..OO.O....OO..OO.O....OO..OO.O....OO..OO.O....OO..OO.O
 .......O...O...O.......O...O.......O...O.......O...O.......O...O....
 .....OO....O.OOO...O...O.OOO...O...O.OOO...O...O.OOO...O...O.OOO...O
 ......O.O..O...........O...........O...........O...........O........
 .......O....OOOOOOOO....OOOOOOOO....OOOOOOOO....OOOOOOOO....OOOOOOOO
 ....................................................................
 .......O....OOOOOOOO....OOOOOOOO....OOOOOOOO....OOOOOOOO....OOOOOOOO
 ......O.O..O...........O...........O...........O...........O........
 .....OO....O.OOO...O...O.OOO...O...O.OOO...O...O.OOO...O...O.OOO...O
 .......O...O...O.......O...O.......O...O.......O...O.......O...O....
 .....OO.....OO..OO.O....OO..OO.O....OO..OO.O....OO..OO.O....OO..OO.O
 .....OOO..O......O.O..O......O.O..O......O.O..O......O.O..O......O.O
 ....O.OO.O.....O.....O.....O.....O.....O.....O.....O.....O.....O....
 ....O..O..O...O..OO...O...O..OO...O...O..OO...O...O..OO...O...O..OO.
 ....OO.....OO.O.O.O....OO.O.O.O....OO.O.O.O....OO.O.O.O....OO.O.O.O.
 ....................................................................
 ....OO.....OO.O.O.O....OO.O.O.O....OO.O.O.O....OO.O.O.O....OO.O.O.O.
 ....O..O..O...O..OO...O...O..OO...O...O..OO...O...O..OO...O...O..OO.
 ....O.OO.O.....O.....O.....O.....O.....O.....O.....O.....O.....O....
 .....OOO..O......O.O..O......O.O..O......O.O..O......O.O..O......O.O
 .....OO.....OO..OO.O....OO..OO.O....OO..OO.O....OO..OO.O....OO..OO.O
 .......O...O...O.......O...O.......O...O.......O...O.......O...O....
 .....OO....O.OOO...O...O.OOO...O...O.OOO...O...O.OOO...O...O.OOO...O
 ......O.O..O...........O...........O...........O...........O........
 .......O....OOOOOOOO....OOOOOOOO....OOOOOOOO....OOOOOOOO....OOOOOOOO
 ....................................................................
 .......O....OOOOOOOO....OOOOOOOO....OOOOOOOO....OOOOOOOO....OOOOOOOO
 ......O.O..O...........O...........O...........O...........O........
 .....OO....O.OOO...O...O.OOO...O...O.OOO...O...O.OOO...O...O.OOO...O
 .......O...O...O.......O...O.......O...O.......O...O.......O...O....
 .....OO.....OO..OO.O....OO..OO.O....OO..OO.O....OO..OO.O....OO..OO.O
 .....OOO..O......O.O..O......O.O..O......O.O..O......O.O..O......O.O
 ....O.OO.O.....O.....O.....O.....O.....O.....O.....O.....O.....O....
 ....O..O..O...O..OO...O...O..OO...O...O..OO...O...O..OO...O...O..OO.
 ....OO.....OO.O.O.O....OO.O.O.O....OO.O.O.O....OO.O.O.O....OO.O.O.O.
 ....................................................................
 ....OO..............................................................
 ....O...............................................................
 ....O...............................................................
 ..OOO.O.............................................................
 .OOO................................................................
 .O..................................................................
 ...OOO..............................................................
 ...O................................................................
 ....O.O.............................................................
 ....O.O.............................................................
 ..OOOO..............................................................
 .O.O................................................................
 .O.O................................................................
 .O..................................................................
 ..O.................................................................
 ..O.O...............................................................
 ...O................................................................
 ..OO................................................................
 ...O.O..............................................................
 ....O...............................................................


The rows containing long strings of ON cells can be slid with respect to
each other left or right by 2 cells, and the spaceship will still work.

I searched for a way to tame one copy of the front component of the above
spaceship, without needing the required tagalong.  This is shown below.

 [Period 3 spaceship with required tail (speed c/3)]
 ....O....................................
 ...O.O...................................
 ...O.O...................................
 ...O.....................................
 ..OO.....................................
 ..O.O....................................
 .........................................
 .OOO.....................................
 .OOO.....................................
 .........................................
 ....OOO..................................
 ....OO...................................
 .........................................
 ...OOO...................................
 ..O..O...................................
 .OOO.OO..................................
 ....OOO..................................
 .........................................
 ....O....................................
 ....OOO.....O............................
 ...........O..O..........O...............
 ....OOO...OO...O..OO....OO...............
 ....O.....OO...O..OO..OOOOO.OOO.......O.O
 .....OO.OO........OO.O........O.O...O..O.
 .....OO....O..O.OOOO.O.O..OO....O.O.O..OO
 ...........O..OO......O....O..OOO........
 ......O.....OO.O............O............
 ......O.O................................
 ......O.O................................
 .......O.................................


The last 19 columns of this spaceship are the same as the back component
of the weaving wicktrailer shown in article 3 that connects to the "turtle"
spaceship.  So the tail of this spaceship can be made arbitrarily long by
inserting more components of that wicktrailer before the end.

Unfortunately, the completion crosses the line between the two rows of 3
cells at the front.  So the bottom part of this spaceship cannot be used to
terminate itself symmetrically, or be placed at the edges of the dense c/3
spaceship.  But if an extension component from one of the previously shown
spaceships is inserted between the two rows of 3 cells, then there is room
to do these things.  For example:

 [Period 3 spaceship with parts connected by extension component (speed c/3)]
 ........O.................................
 .......O.O................................
 ......OO..................................
 ........O....OO.O...............O.........
 ......OO....O.....OO...O...OOO..OOO.......
 ......OOO..O...O.OO.O.O....OO..O.O..O...OO
 .....O.OO.O.O...OO....O......O.O..O.O.OO..
 .....O..O...O.....O....OO..O..OOO.......O.
 .....OO......O.OO..OO.........O...........
 ...........OOO...........OO...............
 .....OO...................................
 .....O....................................
 .....O....................................
 ...OOO.O..................................
 ..OOO.....................................
 ..........................................
 ..O.OOO...................................
 .O..O.....................................
 ..O.O.....................................
 ...O..OO..................................
 ......OO..................................
 .....OO...................................
 ....O.O...................................
 ...O......................................
 ....O.O...................................
 .....OO...................................
 ......OO..................................
 ...O..OO..................................
 ..O.O.....................................
 .O..O.....................................
 ..O.OOO...................................
 ..........................................
 ..OOO.....................................
 ...OOO.O..................................
 .....O....................................
 .....O....................................
 .....OO...................................
 ...........OOO...........OO...............
 .....OO......O.OO..OO.........O...........
 .....O..O...O.....O....OO..O..OOO.......O.
 .....O.OO.O.O...OO....O......O.O..O.O.OO..
 ......OOO..O...O.OO.O.O....OO..O.O..O...OO
 ......OO....O.....OO...O...OOO..OOO.......
 ........O....OO.O...............O.........
 ......OO..................................
 .......O.O................................
 ........O.................................


That ends the summary of new results for period 3 c/3 spaceships.  Now I
will go on to period 4 spaceship results.  Firstly, I will give the new
results for the slow period 4 spaceships which travel at c/4.

In September 1992 Hartmut Holzwart found a c/4 spaceship with a new type of
front end.  This is shown below.

 [Spaceship with required tagalong (speed c/4)]
 .O..OO............O.....OO..............
 O..O....O.....O..O.O....OO..............
 .O.....OO....O.OOO...O..OO..OO..........
 ..OO....O.O....O......OO...OO.OO.O......
 ..O........OO...O.O.....O..OOOOO........
 .OO.O....O.......O...OOOO..O..OOOOOO....
 ..O.O........O...O......O..OO....O.O..OO
 ...O.O....OOOOOO.OO..................O..
 ........................................
 ...O.O....OOOOOO.OO..................O..
 ..O.O........O...O......O..OO....O.O..OO
 .OO.O....O.......O...OOOO..O..OOOOOO....
 ..O........OO...O.O.....O..OOOOO........
 ..OO....O.O....O......OO...OO.OO.O......
 .O.....OO....O.OOO...O..OO..OO..........
 O..O....O.....O..O.O....OO..............
 .O..OO............O.....OO..............


The last 20 columns of this spaceship are very similar to a tagalong that
appeared in a previously known spaceship.  The difference in the tagalongs
is in the spacing between the halves, and the position of the cells in the
last 3 columns.  In the spaceship shown here, this isn't a tagalong since
the spaceship requires the tagalong to survive.

The last 3 columns of the tagalong shown above can be reversed and the
tagalong will still work.  This same rearrangement works on several other
tagalongs that have the same end.  The rearrangement is shown below.

 [Possible rearrangement of last few columns of above spaceship]
 O.O......
 O.....O..
 OOOOO..OO
 ..O.O....
 .........
 .........
 .........
 ..O.O....
 OOOOO..OO
 O.....O..
 O.O......


Hartmut later found a second known tagalong that also can be used to support
the new front end.  This is shown below.

 [Spaceship with alternative required tagalong (speed c/4)]
 .O..OO............O............O.
 O..O....O.....O..O.O...OO..O.OOOO
 .O.....OO....O.OOO....O..OO.....O
 ..OO....O.O....O......O.OO......O
 ..O........OO...O.O..........OOOO
 .OO.O....O.......O....OO.O.....O.
 ..O.O........O...O...OO..........
 ...O.O....OOOOOO.OO....OOOO......
 .................................
 ...O.O....OOOOOO.OO....OOOO......
 ..O.O........O...O...OO..........
 .OO.O....O.......O....OO.O.....O.
 ..O........OO...O.O..........OOOO
 ..OO....O.O....O......O.OO......O
 .O.....OO....O.OOO....O..OO.....O
 O..O....O.....O..O.O...OO..O.OOOO
 .O..OO............O............O.


Hartmut also found some new tagalongs for previously known c/4 front ends.
Several of these are shown below.

 [Several different front ends for old period 4 spaceship (speed c/4)]
 ...........O......................O................
 .........O..OO...OO.....OO.......OOOO..........OOO.
 .......OOO......OOOO...O........OO.O...............
 .O..O...O.......O...O.OO...O.O.........OO...OO..OO.
 .O..O.O.OO......OOOO..OO...OO...O.....OO.O.O.OOOO..
 OO........O.OO..O..O...O.....O.............O.O.....
 .O.OO.OOOO.OO.O..OO.....OO....OO......OO....OOO..O.
 .O..........OO........................O....O.OO.O.O
 .O.OO.OOOO.OO.O..OO.....OO....OO......OO....OOO..O.
 OO........O.OO..O..O...O.....O.............O.O.....
 .O..O.O.OO......OOOO..OO...OO...O.....OO.O.O.OOOO..
 .O..O...O.......O...O.OO...O.O.........OO...OO..OO.
 .......OOO......OOOO...O........OO.O...............
 .........O..OO...OO.....OO.......OOOO..........OOO.
 ...........O......................O................



 .........O..OO...OO.....OO.......OOOO..........OOO.
 .......OOO......OOOO...O........OO.O...............
 .O..O...O.......O...O.OO...O.O.........OO...OO..OO.
 .O..O.O.OO......OOOO..OO...OO...O.....OO.O.O.OOOO..
 OO........O.OO..O..O...O.....O.............O.O.....
 .O.OO.OOOO.OO.O..OO.....OO....OO......OO....OOO..O.
 .O..........OO........................O....O.OO.O.O
 .O.OO.OOOO.OO.O..OO.....OO....OO......OO....OOO..O.
 OO........O.OO..O..O...O.....O.............O.O.....
 .O..O.O.OO......OOOO..OO...OO...O.....OO.O.O.OOOO..
 .O..O...O.......O...O.OO...O.O.........OO...OO..OO.
 .......OOO......OOOO...O........OO.O...............
 .........O..OO...OO.....OO.......OOOO..........OOO.
 ...........O......................O................



 ...........O.............................O............
 .........O..OO...OO.....OO..........OO..O.O...........
 .......OOO......OOOO...O.......O.O.OOOO.OOOO..........
 .O..O...O.......O...O.OO...O.OOO....OO.OO..OOO....O.O.
 .O..O.O.OO......OOOO..OO...OO.O.......O........O.OO..O
 OO........O.OO..O..O...O.....O..........O.....OOO....O
 .O.OO.OOOO.OO.O..OO.....OO............OO......OO......
 .O..........OO.......................O................
 .O.OO.OOOO.OO.O..OO.....OO............OO......OO......
 OO........O.OO..O..O...O.....O..........O.....OOO....O
 .O..O.O.OO......OOOO..OO...OO.O.......O........O.OO..O
 .O..O...O.......O...O.OO...O.OOO....OO.OO..OOO....O.O.
 .......OOO......OOOO...O.......O.O.OOOO.OOOO..........
 .........O..OO...OO.....OO..........OO..O.O...........
 ...........O.............................O............



 ...........O.............................O........
 .........O..OO...OO.....OO..........OO..O.O.......
 .......OOO......OOOO...O.......O.O.OOOO.OOOO......
 .O..O...O.......O...O.OO...O.OOO....OO.OO..OOO....
 .O..O.O.OO......OOOO..OO...OO.O.......O........OOO
 OO........O.OO..O..O...O.....O..........O.....OO.O
 .O.OO.OOOO.OO.O..OO.....OO............OO......OOO.
 .O..........OO.......................O............
 .O.OO.OOOO.OO.O..OO.....OO............OO......OOO.
 OO........O.OO..O..O...O.....O..........O.....OO.O
 .O..O.O.OO......OOOO..OO...OO.O.......O........OOO
 .O..O...O.......O...O.OO...O.OOO....OO.OO..OOO....
 .......OOO......OOOO...O.......O.O.OOOO.OOOO......
 .........O..OO...OO.....OO..........OO..O.O.......
 ...........O.............................O........


The last 16 columns of this spaceship are the same as the back of a spaceship
that was shown near the end of article 4.  But here the back end connects to
the rest of the spaceship in a different way.

 ...........O..............................O............
 .........O..OO...OO.....OO..........OO..OO.............
 .......OOO......OOOO...O.......O.O.OOOOO..O............
 .O..O...O.......O...O.OO...O.OOO....OOOOO.O..OOO.O.O...
 .O..O.O.OO......OOOO..OO...OO.O.........O.OO..OOOO...O.
 OO........O.OO..O..O...O.....O...........OO...........O
 .O.OO.OOOO.OO.O..OO.....OO................OOOOOOOOOOO.O
 .O..........OO.........................................
 .O.OO.OOOO.OO.O..OO.....OO................OOOOOOOOOOO.O
 OO........O.OO..O..O...O.....O...........OO...........O
 .O..O.O.OO......OOOO..OO...OO.O.........O.OO..OOOO...O.
 .O..O...O.......O...O.OO...O.OOO....OOOOO.O..OOO.O.O...
 .......OOO......OOOO...O.......O.O.OOOOO..O............
 .........O..OO...OO.....OO..........OO..OO.............
 ...........O..............................O............


All of the base slow spaceships shown so far have had odd symmetry.  In
October 1992, Hartmut Holzwart found the first base c/4 spaceship that had
even symmetry.  This is shown below.

 [First slow period 4 spaceship with even symmetry (speed c/4)]
 ............................
 ..........O...OO.OO.........
 ........OOO........O........
 ..O...OO.O..O.OO............
 OO...OOO..OOOO..O...O..OOO..
 ..O...OOO...O...O...OOO...OO
 ..........OO....OOO...O...OO
 ......OO.OO....O.....OO.O...
 ......OO.OO....O.....OO.O...
 ..........OO....OOO...O...OO
 ..O...OOO...O...O...OOO...OO
 OO...OOO..OOOO..O...O..OOO..
 ..O...OO.O..O.OO............
 ........OOO........O........
 ..........O...OO.OO.........


Hartmut has found several other c/4 spaceships with even symmetry.  They
show a range of separations between the front pair of traffic lights
predecessors.  These spaceships are shown below.

 [Other slow period 4 spaceships with even symmetry (speed c/4)]
 ..................O....
 ..O.OO.........OO..O...
 OO...O.........OO.O....
 ..O.O..........OOOO....
 ......OOO..OOOOO.......
 ......OO..O.O.O.O...OO.
 ........OOOOO.O.O...O.O
 .........OO...OOOO..O.O
 ..........O.O.O.OOO.O..
 ..........O.O.O.OOO.O..
 .........OO...OOOO..O.O
 ........OOOOO.O.O...O.O
 ......OO..O.O.O.O...OO.
 ......OOO..OOOOO.......
 ..O.O..........OOOO....
 OO...O.........OO.O....
 ..O.OO.........OO..O...
 ..................O....
 

 ...........O......OO...
 ...........OO.OO..OOO.O
 ...........O....O...O.O
 ..............OO..OOO.O
 ..O...OOO.........OO...
 OO...OOO..O.O..........
 ..O...OOOOOO.O.........
 .............O.........
 ......OO...............
 ......OO...............
 .............O.........
 ..O...OOOOOO.O.........
 OO...OOO..O.O..........
 ..O...OOO.........OO...
 ..............OO..OOO.O
 ...........O....O...O.O
 ...........OO.OO..OOO.O
 ...........O......OO...


 ..........O.................
 ........OO..................
 .....O.O.O.O.........OOO..OO
 ..O..O....O....O...OO.OOOO..
 OO...OO....O...O...O.....O.O
 ..O..OO.......O.OO.OOOOO.OO.
 ....O..O....OOO.OO.......O..
 .....OO......OO.O...OO.O....
 ....................OO..OO..
 ....................OO..OO..
 .....OO......OO.O...OO.O....
 ....O..O....OOO.OO.......O..
 ..O..OO.......O.OO.OOOOO.OO.
 OO...OO....O...O...O.....O.O
 ..O..O....O....O...OO.OOOO..
 .....O.O.O.O.........OOO..OO
 ........OO..................
 ..........O.................


Hartmut found very few tagalongs for these even symmetrical spaceships.
Tagalongs are only known for the last spaceship shown above.  The two known
tagalongs are shown below.

 [Two tagalongs for slow period 4 spaceship with even symmetry (speed c/4)]
 ..........O..............................
 ........OO...............................
 .....O.O.O.O.........OOO..OO...........O.
 ..O..O....O....O...OO.OOOO.......OO..OO..
 OO...OO....O...O...O.....O.O..O.OO.O.O.O.
 ..O..OO.......O.OO.OOOOO.OO..OO.OOOO.O.O.
 ....O..O....OOO.OO.......O.........OO...O
 .....OO......OO.O...OO.O.............O..O
 ....................OO..OO...............
 ....................OO..OO...............
 .....OO......OO.O...OO.O.............O..O
 ....O..O....OOO.OO.......O.........OO...O
 ..O..OO.......O.OO.OOOOO.OO..OO.OOOO.O.O.
 OO...OO....O...O...O.....O.O..O.OO.O.O.O.
 ..O..O....O....O...OO.OOOO.......OO..OO..
 .....O.O.O.O.........OOO..OO...........O.
 ........OO...............................
 ..........O..............................


 ..........O................................
 ........OO.................................
 .....O.O.O.O.........OOO..OO...............
 ..O..O....O....O...OO.OOOO..........O......
 OO...OO....O...O...O.....O.O.......OO....OO
 ..O..OO.......O.OO.OOOOO.OO......O...O.OOOO
 ....O..O....OOO.OO.......O...O..O......O...
 .....OO......OO.O...OO.O......O..O.O...O...
 ....................OO..OO..O..O...........
 ....................OO..OO..O..O...........
 .....OO......OO.O...OO.O......O..O.O...O...
 ....O..O....OOO.OO.......O...O..O......O...
 ..O..OO.......O.OO.OOOOO.OO......O...O.OOOO
 OO...OO....O...O...O.....O.O.......OO....OO
 ..O..O....O....O...OO.OOOO..........O......
 .....O.O.O.O.........OOO..OO...............
 ........OO.................................
 ..........O................................


No wide and short c/4 spaceships have been found yet, nor has a base c/4
spaceship which is non-symmetrical been found yet.

Near the end of October 1992, the first example of a new type of Life object
was found by Hartmut Holzwart and Dean Hickerson.  This new type of object
is now called a "wickstretcher", for reasons that will become obvious.

The first wickstretcher found is shown below.  At the left is a period 4
c/4 spaceship component that was found by Hartmut Holzwart.  As it moves
leftwards it leaves behind a thin wick which has period 5 (but which appears
to move at the speed of light).  Without a terminating component at the back
of the wick, the wick decays at the speed of light and ends up destroying
the spaceship component.  No moving termination component is known for the
wick to finish making a c/4 spaceship.  But Dean Hickerson found a period 5
stationary termination component for the wick which stabilizes it, which is
seen at the right.  In the generation shown here, the wick itself is almost
nonexistent, but quickly becomes apparent as the object is run.

 [First example of a "wickstretcher" known]
 ...................................OO..........OO........
 ...................O................O...OO.O..O.O........
 .............O.OO.OO...............O...O.O.OOOO.O.OO.....
 .............O...O.OO..........O...OO..O.O......O..O.....
 ..O...OOO....OOOOO.O.O.O......O.O....O.O..OOOOOO.O.......
 OO...OOO..O.OO.....O.O.O.......O.....O.O.......O.OO......
 ..O...OOOOOO..........O.....O.....OO.O...O..OO.....O.OO.O
 .................O......O.......O..O.OO..O..O.O..OOO.O.OO
 ......OO.......OO......O.OO.OOO.......O.......O.....O....
 ......OO.......OO......O.OO...OOOO.O..O.O.O...O.O.OO.....
 .................O......O...OO.....O.OO.OO.O...OO.O......
 ..O...OOOOOO..........O......O..OO.O...O...O........O....
 OO...OOO..O.OO.....O.O.O...O....OO.OOO.O...OO......OO....
 ..O...OOO....OOOOO.O.O.O...OO.........O..................
 .............O...O.OO................O...................
 .............O.OO.OO.................OO..................
 ...................O.....................................


A month later Dean Hickerson found a smaller version of the termination
component, which is shown below.  Like the previous terminator, this one
is unsymmetrical.  (Dean had looked for symmetrical terminators, but none
were found.)

 [Smallest version of "wickstretcher"]
 .................OO..............................
 .............OO....O.............................
 ............OOO.O................................
 O.OO..OO...O...OOOO.O.O....OO.......OO...........
 O....OO..O........O.OOO....O....OO.O..O.OO.O.....
 O.OO....OO.OO....O...........O...O.O.OO.O.OO.....
 ......O.......O.............OO.....O..O.O...OO...
 .....O.........O.O....OOO...O....O..O.O.OOO...O..
 .....O.........O.O....OOO.OO.O..OO.O.O...O..OO.O.
 ......O.......O.............OO.O...OO....OO....O.
 O.OO....OO.OO....O..........O........OO.O.O.OO.OO
 O....OO..O........O.OOO........O...O...OO.O..O.O.
 O.OO..OO...O...OOOO.O.O.......O.O...OO....O..O.O.
 ............OOO.O..............O.....O.OOO....O..
 .............OO....O.................O.O.........
 .................OO...................O..........


These two wickstretchers are the only known use of the orthogonal non-
standard speed spaceships to create objects which grow arbitrarily large.
The search for true puffers for non-standard speed spaceships is still
unsuccessful.

Newsgroups: comp.theory.cell-automata
From: dbell@pdact.pd.necisa.oz.au (David I. Bell)
Subject: Spaceships in Conway's Life (Addendum 1c)
Organization: NEC Information Systems Australia, Canberra
Date: Tue, 02 Mar 1993 04:58:49 GMT
Message-ID: <1993Mar02.045849.24456@pdact.pd.necisa.oz.au>
Lines: 864

As this article was being prepared, Hartmut Holzwart found another
reasonably small slow period 4 spaceship.  This is shown below.  The front
end of this spaceship is the same as in some previous spaceships shown in
article 4, but the back end is much smaller.

 [Newest slow period 4 spaceship (speed c/4)]
 .......O..................
 .....OO...................
 .......O...OO.....OO......
 .....OOO...OO....O.....O..
 ....OO..........OO.OOO..OO
 ..O....O...O.O.O.OOO.O....
 OO....O..O.O.OO.OO........
 ..O..OOO..................
 ..........................
 ..O..OOO..................
 OO....O..O.O.OO.OO........
 ..O....O...O.O.O.OOO.O....
 ....OO..........OO.OOO..OO
 .....OOO...OO....O.....O..
 .......O...OO.....OO......
 .....OO...................
 .......O..................


That ends the discussion of the new results for slow period 4 spaceships.
Now I will go on to the new results for the period 4 spaceships which move
at the standard speed of c/2.  Most of these new spaceships are tagalongs of
a convoy of standard spaceships, or almost-spaceships.

Hartmut found some new tagalongs for pairs of almost-spaceships with several
different separations, all of which are symmetrical.  The spaceships below
have a separation of one cell between the almost-spaceships.

 [Two period 4 spaceships (speed c/2)]
 ....................O.O......
 ...........OO.....OO....O....
 ..........OOOO....OO.....OO..
 .O.......O.O.OO.O....OOO.OOOO
 O.....O.OO.....O..OOO.OO.....
 O.....OOO....O......OO.O.O.O.
 OOOOO.O.O..OO....O....OO.....
 ........O.O.O...O......O.O...
 ........O.O..................
 ........O.O.O...O......O.O...
 OOOOO.O.O..OO....O....OO.....
 O.....OOO....O......OO.O.O.O.
 O.....O.OO.....O..OOO.OO.....
 .O.......O.O.OO.O....OOO.OOOO
 ..........OOOO....OO.....OO..
 ...........OO.....OO....O....
 ....................O.O......



 .....................O..O.O.O..........
 .....................O....O.O..........
 ..............OO.OO..O.....O...........
 .O........OOO...OO.O..O...O.......OOOO.
 O.....O..OO...........O...O.......O...O
 O.....OOO.O.O..O.......OO.O......O.....
 OOOOO.O.O.O.O..O..........OO..O.OOOO..O
 ........O.O...O............OOOO.OO.....
 ........O.O............................
 ........O.O...O............OOOO.OO.....
 OOOOO.O.O.O.O..O..........OO..O.OOOO..O
 O.....OOO.O.O..O.......OO.O......O.....
 O.....O..OO...........O...O.......O...O
 .O........OOO...OO.O..O...O.......OOOO.
 ..............OO.OO..O.....O...........
 .....................O....O.O..........
 .....................O..O.O.O..........


In the above spaceship, the last seven columns are actually a tagalong and
can be removed.  The tagalong is made of two standard spaceships pushing
ahead little bits of "dirt".

The following is a tagalong to four standard spaceships.  The separation of
one cell for the front two spaceships is the same as that used for the
Schick engine.

 [Four standard spaceships with period 4 tagalong (speed c/2)]
 ..........OOOO....
 .........OOOOOO...
 ........OO.OOOO...
 .........OO.......
 ..................
 ..............O...
 ............O.....
 OOOO.......O...O..
 O...O.....OO....O.
 O.......O..O......
 .O..O..OOO.O..O...
 ......OO..OO..O..O
 .O..O..OOO.O..O...
 O.......O..O......
 O...O.....OO....O.
 OOOO.......O...O..
 ............O.....
 ..............O...
 ..................
 .........OO.......
 ........OO.OOOO...
 .........OOOOOO...
 ..........OOOO....


For a separation of seven cells, Hartmut Holzwart found that two LWSSs can
support a particularly small tagalong.  This one could possibly have been
found manually.

 [Small period 4 tagalong for two LWSSs (speed c/2)]
 OOOO.....
 O...O....
 O........
 .O..O....
 .........
 .....OOOO
 ....O..O.
 ....O..O.
 ....O..O.
 .....OOOO
 .........
 .O..O....
 O........
 O...O....
 OOOO.....


The same two LWSSs also can support a larger tagalong, as shown below.
This tagalong has a nice set of sparks at the back.

 [Two LWSSs supporting a larger tagalong (speed c/2)] 
 OOOO..............
 O...O.......OOO...
 O.......OOO..OOO..
 .O..O..OOOO..OOO..
 ......OOO.....OO..
 ....OO....OO..OOO.
 ...O.OO.O.OO..O.OO
 ..O......O..O.O.O.
 ..O..O.....O..O.OO
 ..O......O..O.O.O.
 ...O.OO.O.OO..O.OO
 ....OO....OO..OOO.
 ......OOO.....OO..
 .O..O..OOOO..OOO..
 O.......OOO..OOO..
 O...O.......OOO...
 OOOO..............


The sparks from the above tagalong can support a number of other tagalongs.
Some of these are shown below.  In the phases shown here, some of the
connections appear very tenuous.

 [Various tagalongs to a tagalong of two LWSSs (speed c/2)]
 OOOO..................
 O...O.......OOO.......
 O.......OOO..OOO......
 .O..O..OOOO..OOO......
 ......OOO.....OO......
 ....OO....OO..OOO.....
 ...O.OO.O.OO..O.OO....
 ..O......O..O.O.O..O.O
 ..O..O.....O..O.OO....
 ..O......O..O.O.O..O.O
 ...O.OO.O.OO..O.OO....
 ....OO....OO..OOO.....
 ......OOO.....OO......
 .O..O..OOOO..OOO......
 O.......OOO..OOO......
 O...O.......OOO.......
 OOOO..................


 ...................O.O...................O.O...
 OOOO..............O.....................O..O.O.
 O...O.......OOO...O..O....OOO..........OO.....O
 O.......OOO..OOO..OOO.OO.O.OO.OO......O....O..O
 .O..O..OOOO..OOO......OO.O.O.OO...OO.OOOOO.O.O.
 ......OOO.....OO.....O...O.O...................
 ....OO....OO..OOO.....OO.OOOOOOOOO...OOO.OOO..O
 ...O.OO.O.OO..O.OO.....OO................OOO..O
 ..O......O..O.O.O........OOOOOOOOOOOO..O.......
 ..O..O.....O..O.OO.....................OO......
 ..O......O..O.O.O........OOOOOOOOOOOO..O.......
 ...O.OO.O.OO..O.OO.....OO................OOO..O
 ....OO....OO..OOO.....OO.OOOOOOOOO...OOO.OOO..O
 ......OOO.....OO.....O...O.O...................
 .O..O..OOOO..OOO......OO.O.O.OO...OO.OOOOO.O.O.
 O.......OOO..OOO..OOO.OO.O.OO.OO......O....O..O
 O...O.......OOO...O..O....OOO..........OO.....O
 OOOO..............O.....................O..O.O.
 ...................O.O...................O.O...


In the following spaceship, the final tagalong is supported by a set of
two close sparks from the first tagalong.  Those sparks could be provided
by two LWSSs instead, but that turns out not to work because the sparks from
the LWSSs two generations later destroy the MWSSs.  So you need this large
spaceship (or ones with similar sparks) in order to support the last tagalong.

 [Period 4 spaceship with simple tagalong to a tagalong (speed c/2)]
 OOOO................OO....
 O...O.......OOO....OO.OOO.
 O.......OOO..OOO....OOOOO.
 .O..O..OOOO..OOO.....OOO..
 ......OOO.....OO..........
 ....OO....OO..OOO.........
 ...O.OO.O.OO..O.OO...OO.OO
 ..O......O..O.O.O....O....
 ..O..O.....O..O.OO...O....
 ..O......O..O.O.O....O....
 ...O.OO.O.OO..O.OO...OO.OO
 ....OO....OO..OOO.........
 ......OOO.....OO..........
 .O..O..OOOO..OOO.....OOO..
 O.......OOO..OOO....OOOOO.
 O...O.......OOO....OO.OOO.
 OOOO................OO....


In the following two tagalongs in the series, the only difference is in the
last few columns.  In the first spaceship, the tail is actually of period 2.
But in the second spaceship, the last few columns revert back to period 4.

 [Two period 4 spaceships with interesting tagalongs (speed c/2)]
 ...................O.O.......O.O............
 OOOO..............O.........O.OO............
 O...O.......OOO...O..O....O..............O.O
 O.......OOO..OOO..OOO.OO.O.O.O..........O..O
 .O..O..OOOO..OOO......OO.O.O.OO........OO...
 ......OOO.....OO.....O...O.O.OO..OOO..O...O.
 ....OO....OO..OOO.....OO.O...OO.O....OOO.O..
 ...O.OO.O.OO..O.OO.....OO.....O.O...O.......
 ..O......O..O.O.O........OOOOO...OOOOOOOOO..
 ..O..O.....O..O.OO..........................
 ..O......O..O.O.O........OOOOO...OOOOOOOOO..
 ...O.OO.O.OO..O.OO.....OO.....O.O...O.......
 ....OO....OO..OOO.....OO.O...OO.O....OOO.O..
 ......OOO.....OO.....O...O.O.OO..OOO..O...O.
 .O..O..OOOO..OOO......OO.O.O.OO........OO...
 O.......OOO..OOO..OOO.OO.O.O.O..........O..O
 O...O.......OOO...O..O....O..............O.O
 OOOO..............O.........O.OO............
 ...................O.O.......O.O............



 ...................O.O.......O.O...........O.O..
 OOOO..............O.........O.OO..........O..O..
 O...O.......OOO...O..O....O..............OO.....
 O.......OOO..OOO..OOO.OO.O.O.O..........O...O...
 .O..O..OOOO..OOO......OO.O.O.OO........OOO.O....
 ......OOO.....OO.....O...O.O.OO..OOO..O.........
 ....OO....OO..OOO.....OO.O...OO.O....OOOOOOO....
 ...O.OO.O.OO..O.OO.....OO.....O.O...O........O.O
 ..O......O..O.O.O........OOOOO...OOOOOOOOOOOOOOO
 ..O..O.....O..O.OO..............................
 ..O......O..O.O.O........OOOOO...OOOOOOOOOOOOOOO
 ...O.OO.O.OO..O.OO.....OO.....O.O...O........O.O
 ....OO....OO..OOO.....OO.O...OO.O....OOOOOOO....
 ......OOO.....OO.....O...O.O.OO..OOO..O.........
 .O..O..OOOO..OOO......OO.O.O.OO........OOO.O....
 O.......OOO..OOO..OOO.OO.O.O.O..........O...O...
 O...O.......OOO...O..O....O..............OO.....
 OOOO..............O.........O.OO..........O..O..
 ...................O.O.......O.O...........O.O..


Hartmut Holzwart found another series of spaceships which are tagalongs to
four standard spaceships, and which are no longer symmetrical, but which are
glide-reflective.  Some of these are shown below.

 [Four LWSSs with various large tagalongs (speed c/2)]
 ........O..O.....................................
 .......O.........................................
 .O..O..O...O...........................O.........
 O......OOOO.......................O...O....O.O...
 O...O...............O....OO.O..OOOOO.OO..OO...OO.
 OOOO..........O..OOOOO.OO.....OO.....OOOO....O...
 .......O..O...O.OO......OOO..O.O..OOO..O....O....
 ......OO.OO.OO...OOOO.O.OO.OO..O..O.OOO.....O....
 .....O.O.O........OOO.O..OOO...OO......O...OO....
 .....O...OO.OOO...........OOO..OO........O.O.OO.O
 .....OO.OO....OOO........OO.O..OO......OO.....OO.
 .....OO.O.O.OO.OO...OO.........OO.O..O.....O...O.
 ............OOO..OO...O.O....O..O..OOO..O.....O..
 .O..O..OO...OO.O...O...O...O..O.OO.OO.OO.OO......
 O..............O...O....OOO.O.O.........O..OO....
 O...O...O..O.....O.O..OO.O.....OOO...OOO...OOO..O
 OOOO...O.........................O....OOOO.OO..O.
 .......O...O...........................O.........
 .......OOOO......................................



 ........O..O..................................
 .......O........................O.OO....OO.OO.
 .O..O..O...O.................OOOO.OO....OO....
 O......OOOO.......OO........OO...O..OOOOO..OO.
 O...O...........OOOO.......OOO..O...O..O......
 OOOO..........O.O...O..OOO..O..OO...O...O.....
 .......O..O...O......O.O.OO.............O.....
 ......OO.OO.OO.....O.OOO.O.OO........OO.O....O
 .....O.O.O.........O.OO...............OOOO.O.O
 .....O...OO.OOO..OOO.O.O.O...............O....
 .....OO.OO....OOO..OO..O.O............OOO.....
 .....OO.O.O.OO.OO......O.O.O..........OO..OO..
 ............OOO.O..........OO........O..OO.OO.
 .O..O..OO...OO.OO...OOO.O..OOOO.......O..OO...
 O..............O.OO.OO.OOO..OOO...O..O..OOO...
 O...O...O..O....OOOO.OO.OO.OO.OO....OO.OOO....
 OOOO...O....................O......O...O......
 .......O...O.................OOO.O.....OOO.O..
 .......OOOO....................O.OO.......O...
 ..........................................O...


In the last spaceship of this series, the tagalong breaks apart into two
components which do not react with each other.  Each one of these components
becomes symmetrical, which is unusual.

 [Four LWSSs with tagalong which splits and becomes symmetrical (speed c/2)]
 ........O..O...................................
 .......O................OO.........OO.OO...OO..
 .O..O..O...O..........O........OOO.OOO..O..O..O
 O......OOOO.........OOO...O..O..O..O.....O....O
 O...O...........O...O.O....OOOO.OO....O..O.O...
 OOOO..........O.OOOO....OO.O.O..O..O.....O....O
 .......O..O...O.........OO.....OOO.OOO..O..O..O
 ......OO.OO.OO....O.O.....O........OO.OO...OO..
 .....O.O.O.......O....OOO......................
 .....O...OO.OOO..O..O.O........................
 .....OO.OO....OOO..............................
 .....OO.O.O.OO.O..OO..OOO......................
 ............OOO.O..O....O.......OO.O..O..O.O..O
 .O..O..OO...OO.OOOOO....OOO.....OOO.O.O....O..O
 O..............O...OO..O..O..O.O.....OO.....OO.
 O...O...O..O....OO.O.O....O.O.OO..OOO...O..O...
 OOOO...O............O........O.O.....OO.....OO.
 .......O...O..........OOOO......OOO.O.O....O..O
 .......OOOO.....................OO.O..O..O.O..O


Here is another spaceship in a series started in article 5, where a known
front end connects to several large components.  Like those other spaceships,
this spaceship is glide-reflective.

 [Period 4 spaceship with large components (speed c/2)]
 ...................................................................O.O
 ..OOO.................................................OO..........OO.O
 .OOOO....................O..O........................OO.OO.O.....O....
 OO.....................OOO..O............O..O.........O.OO.....OO.OO..
 .O.OO.................O.....O.......O....O...O......O.O....O.O.O.O....
 ..OO.OO.O...OOO.....OO.OOO.O.......OO....O.........OO.O.OO..O.O.OO....
 ......O..OO.OO.O...O.O..OO.O......OOOOOOO.O.O......O.O.O..OO..OO......
 ....OOO.OO...OO..O...OO....O.........OO.O.O.O..OOO.O.O.O..O..O.O......
 ....OOO.....O...O.O...O.OO...OO..O........O.O...OO.O.O.O...O.OO.......
 ......O.OO.O.O...............O.OO..O.OOO.O.O....O.O.O.O....O..OO......
 ....OO.......OOO..OO.O..O......OO.OOO...OO.O.OO..O..O.O.OO....OO......
 ...OO.OOO.....O...O.O....O....O...OO.....O.O.....O..O.O....O.OO.......
 ..O...OO....OOOO.....OO..OO...O....O....O...O......OO..O.OO...........
 .OO.O.O......OO......OO.............O...OO.O........OO.O...O.O.O......
 OO..O.O................OOOO...O...........O..........O.OOO...O.OOOO...
 .OO.......................OO.O........................O....O....OOO...
 ....OO................................................OOOOO..........O
 .......................................................OO..........OO.


Finally, Hartmut Holzwart found another small symmetrical period 4 spaceship.
This produces sparks on the outside edge like a HWSS.

 [Small period 4 symmetrical spaceship (speed c/2)]
 ..OO.OOOOOO.
 .OOOO......O
 OO..........
 .O.........O
 ..OOO.O.....
 ....O.......
 ....O.......
 .....O......
 ....O.......
 ....O.......
 ..OOO.O.....
 .O.........O
 OO..........
 .OOOO......O
 ..OO.OOOOOO.


The length of the tails in the above spaceship cannot be shortened to
produce the MWSS or LWSS style of sparks.  But the tails can be lengthened
if they are supported by standard spaceships.  This is shown below.

 [Longer period 4 spaceship supported by two standard spaceships (speed c/2)]
 ......OO......
 .....OO.OOO...
 ......OOOOO...
 .......OOO....
 ..............
 ..............
 ..............
 ..OO.OOOOOOO..
 .OOOO.......O.
 OO............
 .O..........O.
 ..OOO.O...O...
 ....O.........
 ....O.........
 .....O........
 ....O.........
 ....O.........
 ..OOO.O...OO..
 .O...........O
 OO............
 .OOOO........O
 ..OO.OOOOOOOO.
 ..............
 ..............
 ..............
 .......OOOO...
 ......OOOOOO..
 .....OO.OOOO..
 ......OO......


That ends the discussion of new period 4 spaceships.  Now I will go on to
the single new result for period 5 spaceships.  On December 5, 1992, Hartmut
Holzwart found a period 5 spaceship which travels at 2c/5.  This is only
the second such base spaceship known.  Unlike the first spaceship which was
found by Dean Hickerson, this one has even symmetry.

 [Second known period 5 spaceship (speed 2c/5)]
 ...O............
 .O.O....O.......
 OO.OOO...O....O.
 .OO.O........O.O
 ......OO...OOO..
 .....O...O......
 ......OO....OOOO
 ......OO.OOOO.OO
 ................
 ................
 ......OO.OOOO.OO
 ......OO....OOOO
 .....O...O......
 ......OO...OOO..
 .OO.O........O.O
 OO.OOO...O....O.
 .O.O....O.......
 ...O............


No period 5 spaceship has been found which travels at c/5.

That ends the discussion on period 5 spaceships.  Now I will move on to
the period 96 c/12 Cordership.  In article 1 of my series, I showed Dean
Hickerson's Cordership which travels diagonally at c/12.  I neglected to
give a few useful pieces of information about it.

Firstly, the back four switch engines can be moved backwards by any multiple
of eight cells, if extra blocks are also inserted on the sides to continue
the obvious pattern.  This is because the only use of the back four switch
engines is to delete the blocks left by the other switch engines.  So this
allows an arbitrarily large spaceship to be constructed which moves diagonally
at c/12.  And where there is room, the phase of the back switch engines can
be adjusted with respect to the other switch engines.

Secondly, the Cordership will still work if the back four switch engines are
moved backwards by one or two cells.  (In fact, any combination of the four
back switch engines can be moved backwards by two cells.)

Thirdly, a Cordership can be made larger by inserting more switch engines
into each row of switch engines.  This lets you make a Cordership which is
as wide as you want.

Lastly, if one switch engine is moved one cell backwards with respect to an
adjacent one, then a block will be produced behind the two switch engines.
By adjusting the positions of the back switch engines, from 1 to 3 blocks
can be produced.  These blocks can be used to support other rows of switch
engines to produce very large compound Corderships.

Below is a compound Cordership which illustrates an extra row of switch
engines connecting two Corderships which each leave behind single blocks.
Since this is a large object, the picture has been compressed.  Each dollar
sign represents ten periods.  Simply use an editor to replace each dollar
sign by ten periods to reconstruct the full picture.

 [Two period 96 Corderships connected by switch engines (speed c/12)]
 $$$.....OO$$$$$$$$$$$$$...
 $$$.....O...OO$$$$$$$$$$$$.........
 $$$....O......O.......OOO$$$$$$$$$$$........
 $$$..OOOOO...O.....OOO$$$$$$$$$$$$.
 $$$.....O...O......OOO$$$$$$$$$$$$.
 $$$..O..O$.O$$$$$$$$$$$$..
 $$....OO.......OO$$$$$$$$$$$$$.....
 $$....OO$$$$$$$$$$$$$$....
 $$$$$$$$$$$$$$$$$
 $$$$$........O$$$$$$$$$$$.
 $$$$$........O$$$$$$$$$$$.
 $$$$$........O$$$$$$$$$$$.
 $$$$$......OO$$$$$$$$$$$..
 $$$$$.....OOO$$$$$$$$$$$..
 $......OO$$$........OO$$$$$$$$$$$..
 $......OO$$$$$$$$$$$$$$$..
 $$$$$$$$$$$$$$$$$
 $$$$$$$$$$$$$$$$$
 $$$$$$$$$$$$$$$$$
 $$$$$........O$$$$$$$$$$$.
 $$$$$.......O$$$$$$$$$$$..
 $$$$$........O$$$$$$$$$$$.
 ........OO$$$$$$$$$$$$$$$$
 ........OO$$$......O$$$$$$$$$$$$...
 $$$$.....O.O$$$$$$$$$$$$..
 $$$$....OO.OO$$$$$$$$$$$$.
 $$$$.......OO$$$$$$$$$$$$.
 $$$$.OO$$$$$$$$$$$$.......
 $$$$...O..OOO$......O.O.......OOO$$$$$$$$$..
 $$$$.OO.O$$.O.....OOO$$$$$$$$$.....
 OO$$$$.O..O$$.....OOO$$$$$$$$$.....
 OO$$$$.O$$.........O$$$$$$$$$......
 ....O.......O$$$.OO$$$$$$$$$$$$....
 ...O.O.....OOO$$$$$$$$$$$$$$$......
 ..O..O..OOOO.OO$$$O$$$$$$$$$$$$....
 ........O..OOO$$.........OO.OO$$$......O$$$$$$$$.....
 .....O..OO..O$$$.O$$$.........O$$$$$$$$.....
 ...O.O.OO$$$........O$$$......O$$$$$$$$.....
 ....O$$$$O$..O.OO$$OO$$$$$$$$......
 $$$$.........O.O......O.OOO$........OOO$$$$$$$$......
 $$$$$.O....O.O....O$........OO$$$$$$$$......
 $$$$........O...O.O......OO$$$$$$$$$$.......
 $$$$$OO..O..O...O$$$$$$$$$$........
 $$$$$.O...OO.O$$$$$$$$$$$.
 $$$$$.......O.O$$$$$$$$$$$
 $$$$$.......O.O$$....O$$$$$$$$.....
 $$......O$$$$$......O.O$$$$$$$$....
 $$.....OOO$$$$$....O..O$$$$$$$$....
 $$....OO.OO$$$$$$$$$$$$$$.
 $$.....OOO$$$$$$$$$$$$$$..
 $$......O$$$$$......O..O$$$$$$$$...
 $$....O.O$$$$$....OOO.OO$$$$$$$$...
 $$...OOOO$$$$$...O..OO$$$$$$$$.....
 $$...O$$$$$......O..O$$$$$$$$......
 $$$$$$$$.O.O$$$$$$$$......
 $$...OO.OO$$$$$$$$$$$$$$..
 $$..O.....O$$$$$$$$$$$$$$.
 $$...O...O$$$$$$$$$$$$$$..
 $$......O...O.......O$$$$$$$$$$$$$.
 $$.........O.O.....OOO$$$$$$$$$$$$$
 $$........O..O..OOOO.OO$$$$$$$$$$$$.........
 $$$....O..OOO$$$.........OO$$$$$$$$.........
 $$$.O..OO..O$$$$OO$$$$$$$$.........
 $$.........O.O.OO$$$$$$$$$$$$$.....
 $$$O$$$$$$$$$$$$$.........
 $$$$$$$$$$$$$$$$$
 $$$$$$$$$$$$$$$$$
 $$$$$$$$$$$$$$$$$
 $$$$$$$$$$$$$$$$$
 $$$$$$$.OO$$$$$$$$$.......
 $$$$$$$.OO$$$$$$$$$.......
 $$$$$...O$$$$$$$$$$$......
 $$$$$..OOO$$$$$$$$$$$.....
 $$$$$.OO.OO$$$$$$$$$$$....
 $$$.........OO$.OOO$$$$$$$$$$$.....
 $$$.........OO$..O$$$$$$$$$$$......
 $$$$$.O.O$$$$$$$$$$$......
 $$$$$OOOO.........OO$$$$$$$$$$.....
 $$$$$O$..OO$$$$$$$$$$.....
 $$$$$$$$$$$$$$$$$
 $$$$$OO.OO$$$$$$$$$$$.....
 $$$$.........O.....O$$$$$$$$$$$....
 $$$.OO$.......O...O$$$$$$$$$$$.....
 $$$.OO...O.......O........O$$$$$$....OO$$$$$
 $$$.....O.O.....OOO$$$$$$$..O...OO$$$$......
 $$$....O..O..OOOO.OO........OO$$$$$$O......O.......OOO$$$.....
 $$$$O..OOO.........OO$$$$$........OOOOO...O.....OOO$$$........
 $$$.......O..OO..O$$$$$$$...O...O......OOO$$$........
 $$$.....O.O.OO$$$$$$$....O..O$.O$$$.........
 $$$......O$$$$$$$OO.......OO$$$$$..
 $$$$$$$$$$.......OO$$$$$$.
 $$$$$$$$$$$$$$$$$
 $$$$$$$$$$$$$$.O$$........
 $$$$$$$$$$$$$$.O$$........
 $$$$$$$$$$$$$$.O$$........
 $$$$$$$$$$$$$.........OO$$.........
 $$$$$$$$$$$$$........OOO$$.........
 $$$$$........O$$$$OO$$$........OO$$.........
 $$$$$.......OOO$$$.........OO$$$$$$.........
 $$$$$......OO.OO$$$$$$$$$$.........
 $$$$$.......OOO$$$$$$$$$$$
 $$$$$........O$$$$$$$$$$$.
 $$$$$......O.O$$$$$$$$..O$$........
 $$$$$.....OOOO$$$$$$$$.O$$.........
 $$$$$.....O$$$$$$$$.....O$$........
 $$$$$$$$$.OO$$$$$$$.......
 $$$$$.....OO.OO$$$.OO$$$......O$$$$
 $$$$$....O.....O$$$$$$.......O.O$$$.........
 $$$$$.....O...O$$$$$$.......OO.OO$$$........
 $$$$$........O...O.......O$$$$$.........OO$$$........
 $$$$$$.O.O.....OOO$$$$$..OO$$$$....
 $$$$$$O..O..OOOO.OO$$$$$...O..OOO$......O.O.......OOO.........
 $$$$$$......O..OOO$$$$$..OO.O$$.O.....OOO$..
 $$$$$$...O..OO..O$..OO$$$$.O..O$$.....OOO$..
 $$$$$$.O.O.OO$......OO...O.......O$$.........O$$.........O$...
 $$$$$$..O$$....O.O.....OOO$$.........OO$$$$.
 $$$$$$$$......O..O..OOOO.OO$$$$$$$.
 $$$$$$$$$..O..OOO$$$O$$$$.
 $$$$$$$$.........O..OO..O$$.........OO.OO$$$......O..
 $$$$$$$$.......O.O.OO$$$....O$$$.........O..
 $$$$$$$$........O$$$$.O$$$......O..
 $$$$$$$$$$$$........O$..O.OO$$OO...
 $$$$$$$$$$$$$..O.O......O.OOO$........OOO...
 $$$$$$$$....O$$$$.........O....O.O....O$........OO...
 $$$$$$$$...OOO$$$$.....O...O.O......OO$$....
 $$$$$$$$..OO.OO$$$$......OO..O..O...O$$.....
 $$$$$$$$...OOO$$$$........O...OO.O$$........
 $$$$$$$$....O$$$$$.....O.O$$.......
 $$$$$$$$..O.O$$$$$.....O.O$$....O..
 $$$$$$$$.OOOO.........OO$...O$$$$$......O.O.
 $$$$$$$$.O$..OO$..OOO$$$$$....O..O.
 $$$$$$$$$$.......OO.OO$$$$$........
 $$$$$$$$.OO.OO$$..OOO$$$$$.........
 $$$$$$$$O.....O$$..O$$$$$......O..O
 $$$$$$$$.O...O$$.O.O$$$$$....OOO.OO
 $$$$$$$$....O$$.OOOO$$$$$...O..OO..
 $$$$$$$$$$......O$$$$$......O..O...
 $$$$$$$$......OO$$$$$$$......O.O...
 $$$$$$$$......OO$........OO.OO$$$$$.........
 $$$$$$$$$$.....O.....O$$$$$........
 $$$$$$$$$$......O...O$$$$$.........
 $$$$$$$$$$.........O...O.......O$$$$........
 $$$$$$$$$$$..O.O.....OOO$$$$.......
 $$$$$$$$$$$.O..O..OOOO.OO$$$$......
 $$$$$$$$$$$.......O..OOO$$$.........OO......
 $$$$$$$$$$$....O..OO..O$$$$OO......
 $$$$$$$$$$$..O.O.OO$$$$$..
 $$$$$$$$$$$...O$$$$$......
 $$$$$$$$$$$$$$$$$
 $$$$$$$$$$$$$$$$$
 $$$$$$$$$$$$$$$$$
 $$$$$$$$$$$$$$$$$
 $$$$$$$$$$$$$$$....OO$....
 $$$$$$$$$$$$$$$....OO$....
 $$$$$$$$$$$$$$$$$
 $$$$$$$$$$$$$.....O$$$....
 $$$$$$$$$$$$$....OOO$$$...
 $$$$$$$$$$$$$...OO.OO$$$..
 $$$$$$$$$$$$$....OOO$$$...
 $$$$$$$$$$$$$.....O$$$....
 $$$$$$$$$$$$$...O.O$OO$$..
 $$$$$$$$$$$$$..OOOO$OO$$..
 $$$$$$$$$$$$$..O$$$.......
 $$$$$$$$$$$$$$$$$
 $$$$$$$$$$$$$..OO.OO$$$...
 $$$$$$$$$$$$$.O.....O$$$..
 $$$$$$$$$$$$$..O...O$$$...
 $$$$$$$$$$$$$.....O$$$....
 $$$$$$$$$$$$$........OO$$$
 $$$$$$$$$$$$$........OO$$$


By combining the techniques for modifying Corderships, very large and
complicated spaceships can be constructed which travel diagonally at c/12.

That ends the discussion of the Cordership.  Now I will summarize the new
developments for large period spaceships and puffers.  The new results
found here are by me.

Firstly, it is possible to fill in some of the gaps in large period puffers.
These gaps are the periods below about 1100, above which the glider-turning
methods can produce any period which is a multiple of 4.

The pattern below is a puffer with a period of 360.  It produces several
pairs of blocks, and a small pile of random debris.  It is constructed from
two period 120 backwards rakes and a blinker puffer.  The first pair of
gliders from the rakes ignite the blinker fuse, and the rake's period is
high enough so that further gliders from the rakes miss the fuse and just
form blocks.  That is, until the fuse burns out and a new row of blinkers
is created to begin the process again.

[Period 360 puffer (speed c/2)]
 .................................OO...............................
 ..O..O.....OO...................OO.OOO............................
 .O........OOOO...................OOOOO............................
 .O...O...OO.OO....................OOO.............................
 .OOOO.....OO......................................................
 .........................OO...................................OO..
 ........................O....O..............................O....O
 ........................OO...O.............................O......
 .....OO........OO......O.OOO..O............................O.....O
 ...OO.OO.......OO.....OOO....OO............................OOOOOO.
 ...O..O..........O.....O.OO.O.....................................
 ...O..O.........O.......OOO.......................................
 ....OO...................OO.......................................
 ..................................................................
 ..................................................................
 ..O..O............................................................
 .O.........OO...............OO.................O..................
 .O...O....OO.OOO...........OO.OO..............OOO.................
 .OOOO......OOOOO............OOOO...O.....OOO......................
 ............OOO..............OO...O.OO...OOO...OO.................
 .................................O...O........OO..................
 .............................OO...O.OO...OOO......................
 ............................OOOO...O.....OOO......................
 ...........................OO.OO..................................
 ............................OO....................................
 ..................................................................
 ..................................................................
 ....................................................O.............
 ..................................................O...O...........
 .................................................O................
 .................................................O....O...........
 .................................................OOOOO............
 ..................................................................
 ..................................................................
 ..................................................................
 ..................................................OO..............
 .................................................OO.OOO.O.........
 ..................................................OOOOOOO.........
 ...................................................OOOOO..........
 ..................................................................
 ......................................................OO..........
 ....................................................O....O........
 ...................................................O..............
 ...................................................O.....O........
 ...................................................OOOOOO.........
 ..................................................................
 ..................................................................
 ..................................................................
 ..................................................................
 ..................................................................
 ............................OO....................................
 ...........................OO.OO..................................
 ............................OOOO...O.....OOO......................
 .............................OO...O.OO...OOO......................
 .................................O...O........OO..................
 ............OOO..............OO...O.OO...OOO...OO.................
 .OOOO......OOOOO............OOOO...O.....OOO......................
 .O...O....OO.OOO...........OO.OO..............OOO.................
 .O.........OO...............OO.................O..................
 ..O..O............................................................
 ..................................................................
 ..................................................................
 ....OO...................OO.......................................
 ...O..O.........O.......OOO.......................................
 ...O..O..........O.....O.OO.O.....................................
 ...OO.OO.......OO.....OOO....OO............................OOOOOO.
 .....OO........OO......O.OOO..O............................O.....O
 ........................OO...O.............................O......
 ........................O....O..............................O....O
 .........................OO...................................OO..
 .OOOO.....OO......................................................
 .O...O...OO.OO....................OOO.............................
 .O........OOOO...................OOOOO............................
 ..O..O.....OO...................OO.OOO............................
 .................................OO...............................


The particular pattern above can be squeezed down thinner than is shown, but
I left it spread out so that you can easily play with it as described below.

By moving the blinker puffer forwards (leftwards) by 12 cells (and adding 6
produced blinkers), a puffer is created with a period which is 480, which is
120 more than the original.  This process can be repeated as desired to
create a puffer of any period which is 360 + 120 * N.

By using other period rakes, some more of the missing puffer periods can
probably be constructed in the "large period gap".  But this method can
obviously only produce puffers which are multiples of the rake's periods.
The period has to be large enough so that the second pair of gliders can
clear the burning fuse (the period 120 shown here seems just large enough).

In article 6 of my series, I described how to construct large period
spaceships which use pairs of gliders to ignite a blinker trail.  I have
since discovered that a single glider will suffice for the ignition, if
the collision is perturbed by an accompanying spaceship.  So the large
period puffers do not have to be symmetrical, they can instead be one-sided.

Below is a puffer with period 1340 which illustrates how the one-sided
ignition works.  Because the puffer is long, it is given in compressed form.
Use an editor to replace each dollar sign by ten periods to reconstruct the
full picture.

 $$$.OOOO$$$$$$$$$$$$$$..
 $$$.O...O$$$$$$$$$$$$$$.
 $$$.O$$$$$$$$$$$$$$.....
 $$$..O..O$$$$$$$$$$$$$$.
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$$$$$$.......
 $....O$$$$$$$$$$$$$$$$..
 $..O...O$$$$$$$$$$$$$$$$
 $.O$$$$$$$$$$$$$$$$.....
 $.O....O$$$$$$$$$$$$$$$$
 $.OOOOO$$$$$$$$$$$$$$$$.
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$$$$$$.......
 $O$$$$$$$$$$$$$$$$......
 .OO.O...OO.OO$$$$$$$$$$$$$$$$....
 O..OOOOO.O$$$$$$$$$$$$$$$$.......
 O..O.OO.OO$....O$$$$$$$$$$$$$$$..
 OO...OOO.OO......OO.O..O.O$$$$$$$$$$$$$$$.
 ..O......OO.....O.O.OOOO.O$$$$$$$$$$$$$$$.
 .........OO.OOO.O$$$$$$$$$$$$$$$$
 ..O......OO.....O.O.OOOO.O$$$$$$$$$$$$$$$.
 OO...OOO.OO......OO.O..O.O$$$$$$$$$$$$$$$.
 O..O.OO.OO$....O$$$$$$$$$$$$$$$..
 O..OOOOO.O$$$$$$$$$$$$$$$$.......
 .OO.O...OO.OO$$$$$$$$$$$$$$$$....
 $O$$$$.....O$$$$$$$$$$$$
 $$$$$....O...O$$$$$$$$$$$........
 $$$$$...O$$$$$$$$$$$.........O..O
 $.OOOOO$$$.......O....O$$$$$$$$$$$...O....
 $.O....O$$$......OOOOO$$$$$$$$$$$....O...O
 $.O$$$$$$$$$$$$$$$$OOOO.
 $..O...O$$$$$$$$$$$$$$$$
 $....O$$$$$$$$$$$$$$$$..
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$$....OOOOOO$$$.......
 $$$$$$$$$$$$$....O.....O$$$......
 $$$$$$$$$$$$$....O$$$$..
 $$$$$$$$$$$$$.....O....O$$$......
 $$$$$$$$$$$$$.......OO$$$........
 $$$$.OO$$$$$$$$$$$$$....
 $$$$OO.OO$$$$$$$$$$$$$..
 $$$$.OOOO$$$$$$$$$$$$$..
 $$$$..OO$$$$$$$$$$$$$...
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$$$$$$.......
 $$$$$$$$$$$$......OOOOOO$$$$.....
 $$$$$$$$$$$$......O.....O$$$$....
 $$$$$$$$$$$$......O$$$$$
 $$$$$$$$$$$$.......O....O$$$$....
 $$$$$$$$$$$$.........OO$$$$......


Moving the back two HWSS backwards and outwards by 6N cells, and also moving
the back LWSS backwards by 12N cells, will produce a puffer whose period is
increased by 120N, and which attempts to leave 3N more blinkers.

If the top LWSS is removed, and replaced with a LWSS in the symmetrical
position to the one at the bottom, then the puffer will also produce a
backwards traveling glider.

This concludes my addendum to the Spaceships in Conway's Life series.
I would like to thank Harold McIntosh, Hartmut Holzwart, and especially
Dean Hickerson for reviewing this article.
