rem -- Written by Tom Dolbilin

rem -- This macro allows to use the standard Free-form dialing
rem -- dialog to dial alphanumeric phone numbers. Try assigning
rem -- it to Control-Dial (Control-Psion-Help)

PROC macro:
UseApp:( "active" )
if Info:(4) = 0
	UseApp:( "time" )
	ToFront:
endif
SendKey:( 291, 12, 1 ) rem Control-Dial
GiPrint:( "Busy" )
cache on
cachetidy
keys:(1)
GiPrint:( "" )
var%(3) = CurrPid%:
ENDP

PROC keys:( state% )
local i%
rem Capture all alphabetical keys, Space and Esc
while i% < 26
	Hotkey:( %a + i%, 0, "convert", state% )
	i% = i% + 1
endwh
Hotkey:( esc%, 0, "convert", state% )
Hotkey:( space%, 0, "list", state% )
ENDP

PROC convert:( k%, m% )
local pos%
UsePid:( var%(3) )
if k% = esc%
	Esc:
	keys:(0)
	cachetidy
else
	pos% = loc( "ABCDEFGHIJKLMNOPRSTUVWXY", chr$( k% ) )
	if pos%
		Key:( %1 + ( pos% + 2 ) / 3 )
	else
		Key:( k% )
	endif
endif
ENDP

PROC list:( k%, m% )
local name$(5,15), phone$(9,15), i%
Hotkey:( esc%, 0, "convert", 0 ) rem Temporarily release Esc
UsePid:( var%(3) )
name$(1) = "John Doe" : phone$(1) = "1234567"
name$(2) = "Friend" : phone$(2) = "7654321"
rem -- Can have up to 9 phone numbers
dInit:( "" )
i% = 1
while name$( i% ) <> ""
	dText:( name$( i% ), phone$( i% ), $400 )
	i% = i% + 1
endwh
i% = Dialog:
if i%
	SendText:( phone$( i% ) )
endif
Hotkey:( esc%, 0, "convert", 1 ) rem Re-capture Esc
ENDP
