/* *********************************************************************
 *			Midi Recorder V0.1
 *
 *			by	Mike Cohen
 *				2255 Barker Ave.
 *				Bronx, NY 10467
 *				(212) 798-0771
 *				CIS 70375,350
 *
 *			Not to be modified without permission of the author.
 *
 *	This is a sample application to demonstrate how MIDI I/O functions
 *	can be used from within a C program. The MIDI I/O was originally
 *	written by Kirk Austin for MacTutor, but I added better buffering
 *	and a cleaner C interface, which allows the clock rate and port to
 *	be specified when initializing it. I still don't do any checks for
 *	buffer overflow, although I use an 8K receive buffer which is now
 *	allocated on the heap.
 *
 *	The following MIDI functions are provided in MidiCode.REL:
 *
 *	short StartMidi(port,clock) short port,clock;
 *		port = 0 to use modem port, != 0 to use printer port
 *		clock=0 or 2 for 1 MHz, 1 for 500 KHz, 3 for 2 MHz
 *		returns 0 if successful or a memory manager error code
 *
 *	void MidiXmit(theByte) char theByte;
 *
 *	int MidiRecv();
 *		returns an unsigned data byte (0...255) or -1 if no data
 *
 *	void StopMidi();
 *		MUST BE CALLED BEFORE THE APPLICATION EXITS TO RESTORE
 *		PROPER SERIAL OPERATION AND AVOID CRASHES.
 *
 ********************************************************************* */

#include <maccdefs.h>
#include <macdefs.h>
#include <packages.h>
#include <window.h>
#include <pbdefs.h>
#include <osio.h>
#include <events.h>
#include <menu.h>

//
// this structure is used to represent bytes of MIDI data with
//		timing information
//
typedef struct {
	short delay;
	char data;
} Command;

//
// this structure is used to specify a buffered I/O mode with TKopen()
//
typedef struct {
	char filler[3];
	char mode;
	long bufsiz1;
	long bufsiz2;
	} IOmode;
	
MenuHandle deskMenu,fileMenu,editMenu;
int done = 0;

main()
{	EventRecord event;

	FlushEvents(0xffff);
	TEInit();
	InitMenus();
	InitDialogs(0L);
	InitCursor();
	maxApplZone();
	deskMenu = NewMenu(100,"\p\024");
	AppendMenu(deskMenu,"\pAbout Midi Recorder;(-");
	AddResMenu(deskMenu,'DRVR');
	InsertMenu(deskMenu,0);

	fileMenu = NewMenu(101,"\pFile");
	AppendMenu(fileMenu,"\pRecord;Play;(-;Quit");
	InsertMenu(fileMenu,0);

	editMenu = NewMenu(102,"\pEdit");
	AppendMenu(editMenu,"\pUndo/Z;(-;Cut/X;Copy/C;Paste/V;Clear");
	InsertMenu(editMenu,0);

	DrawMenuBar();
	
	if(StartMidi(0,0)) SysBeep(7);
	else
	{	while(!done)
		{	SystemTask();
			if(GetNextEvent(everyEvent,&event))
			{	switch(event.what)
				{	case mouseDown:
						doMouse(&event);
						break;
					case keyDown:
						if(event.modifiers & cmdKey)
							doMenu(MenuKey(event.message));
						break;
					case activateEvt:
						if(event.modifiers & 1)
						{	SetPort(event.message);
						}
					default:
						break;
				}
			}
		}
	}
	StopMidi();
	FlushEvents(0xffff); // zap any pending events
}

Record(vol,name)
int vol;
char *name;
{	short fd,ovol,c;
	long time=0L;
	Command cmd;
	IOmode fileMode;

	ovol = setvol(vol);
	fileMode.mode = 2;
	fileMode.bufsiz1 = fileMode.bufsiz2 = 2048;
	fd = TKopen(diskdevice,name,&fileMode);
	if(fd == 0)
	{	SysBeep(3);
		setvol(ovol);
		return(0);
	}
	while(!Button())
	{	if((c=MidiRecv()) >= 0)
		{	cmd.data = c;
			cmd.delay = time ? (TickCount() - time) : 0;
			outblock(fd,&cmd,sizeof(Command));
			time = TickCount();
		}
	}
	TKclose(fd);
	SetFileType(name,'MIDI');
	SetFileSignature(name,'MIDI');
	setvol(ovol);
}

PlayBack(vol,name)
int vol;
char *name;
{	Command cmd;
	IOmode fileMode;
	short ovol,fd;

	ovol = setvol(vol);
	fileMode.mode = 1;
	fileMode.bufsiz1 = fileMode.bufsiz2 = 2048;
	fd = TKopen(diskdevice,name,&fileMode);
	setvol(ovol);
	if(fd == 0) return(0);
	while(!eof(fd))
	{	inblock(fd,&cmd,sizeof(Command));
		Delay(cmd.delay);
		MidiXmit(cmd.data);
	}
	TKclose(fd);
}

doMouse(event)
EventRecord *event;
{	WindowPtr theWindow;
	int wCode;

	wCode = FindWindow(&event->where,&theWindow);
	switch(wCode)
	{	case inMenuBar:
			doMenu(MenuSelect(&event->where));
			break;
		case inSysWindow:
			SystemClick(event,theWindow);
			break;
		case inContent:
			if(theWindow != FrontWindow()) SelectWindow(theWindow);
			break;
		case inGoAway:
			if(TrackGoAway(theWindow,&event->where))
			{	if(((WindowPeek)theWindow)->windowKind < 0)
					CloseDeskAcc(((WindowPeek)theWindow)->windowKind);
			}
			break
		case inDrag:
			{	Rect theBox;
				theBox = QD->screenBits.bounds;
				InsetRect(&theBox,20,20);
				DragWindow(theWindow,&event->where,&theBox);
				break;
			}
	}
}

doMenu(mSelect)
long mSelect;
{	short theMenu = HiWord(mSelect), theItem = LoWord(mSelect);
	switch(theMenu)
	{	case 100:
			if(theItem == 1)
			{	char *dlg,*oldport;
				short hit;
				GetPort(&oldport);
				SetPort(dlg = GetNewDialog(256,0L,-1L));
				do
				{	ModalDialog(0L,&hit);
				} while(hit != 1);
				DisposeDialog(dlg);
				SetPort(oldport);
			}
			else
			{	char deskName[256];
				GetItem(deskMenu,theItem,deskName);
				OpenDeskAcc(deskName);
			}
			break;
		case 101:
			{	SFReply reply;
				long type = 'MIDI';

				switch(theItem)
				{	case 1:
						SFPutFile("\pSave As:","\pMidi.out",&reply);
						if(reply.good)
						{	outstr(0,
								"Now Recording. Click Mouse when done.\n");
							Record(reply.vRefNum,
								PtoCstr(&reply.Namelength));
							outstr(0,"Stopped recording.\n\n");
						}
						break;
					case 2:
						SFGetFile(1,&type,&reply);
						if(reply.good)
						{	outstr(0,"Playing back...");
							PlayBack(reply.vRefNum,
								PtoCstr(&reply.Namelength));
							outstr(0,"done.\n\n");
						}
						break;
					case 4:
						done = 1;
						break;
				}
				break;
			}
		case 102:
			SystemEdit(theItem-1);
			break;
	}
	HiliteMenu(0);
}

setvol(vol)
int vol;
{	ioParam pb;
	int ovol;
	pb.ioNamePtr = 0L;
	PBGetVol(&pb,0);
	ovol = pb.ioVRefNum;
	if(pb.ioVRefNum = vol) PBSetVol(&pb,0);
	return(ovol);
}

SFGetFile(count,types,reply)
short count;
long *types;
SFReply *reply;
{
#asm
	move.l	#$00500050,-(sp)
	clr.l	-(sp)	;prompt
	clr.l	-(sp)	;filter
	move.w	d0,-(sp)
	move.l	d1,-(sp)
	clr.l	-(sp)
	move.l	d2,-(sp)
	move.w	#2,-(sp)
	dc.w	$a9ea	;_Pack3
#endasm
}

SFPutFile(prompt,oldname,reply)
char *prompt,*oldname;
SFReply *reply;
{
#asm
	move.l	#$00500050,-(sp)
	move.l	d0,-(sp)
	move.l	d1,-(sp)
	clr.l	-(sp)
	move.l	d2,-(sp)
	move.w	#1,-(sp)
	dc.w	$a9ea	;_Pack3
#endasm
}

maxApplZone()
{
#asm
	move.l	$130,a0
	lea		$114,a1
	move.l	a0,d0
	sub.l	(a1),d0
	moveq	#12,d2
	cmp.l	d2,d0
	bcs.s	@1
	move.l	(a1),a1
	move.l	a0,$114
	move.l	d0,(a1)
	clr.b	(a1)
	move.l	$2aa,a1
	move.l	a0,(a1)
	move.l	d2,(a0)
	add.l	d0,12(a1)
@1:
#endasm
}

 