
                       Sigma's Guide to Twilight Zone
                       ==============================
                           Version as of 04/18/94

This rule compilation and tips sheet is, to the extent possible (in light of
the subject matter being the property of Bally/Williams), freeware.  It can
be modified, updated, or revised, provided only that credit to the original
author(s) remains intact.  It can be published or otherwise distributed,
provided only that such distribution is effectively free.  Another Rules
Sheet for Twilight Zone has been written by Bowen Kerins, who can be reached
as <bowen@cardinal.stanford.edu>.

This sheet is written and maintained by Kevin Martin, <sigma@rahul.net> or
<sigma@mcs.com> - if you have any questions or comments or additions or
corrections, send 'em along to me.

This version of the Guide should be considered final.

"Twilight Zone" the pinball machine is the property of Williams/Bally, and a
trademark of the licensor.  The author(s) disclaim all interest in any
trademarks or other intellectual property referenced herein.

I use the abbreviations "K" for a thousand points, "M" for a million points,
"B" for a billion points, and "LITZ" for Lost In The Zone.

                              Important Things
                              ================

This is a glossary of the shots and features that will be referred to during
the discussion of the game.  Because Twilight Zone is a rather cluttered
widebody design, this section is quite lengthy.  The features are, in
general, described starting from the lower right and proceeding
counter-clockwise.

Flippers - There are four flippers - the usual two lower ones (full-length),
  a second full-length right flipper less than halfway up the playfield, and
  a much shorter flipper high on the left side of the playfield.  Two-stage
  action is provided for both sets of flippers.  The computer has control of
  the flippers, but this is only used for ball searches.
Manual Plunger - This is a normal plunger.  Its lane is fairly short and
  leads to a gate, beyond which there are three rollover switches for the
  Skill Shot.
Automatic Plunger - This kicker is beneath the ball trough eject and has its
  own plunger lane to the left of the normal plunger lane.  A small rotating
  diverter guides balls ejected from the trough into either the manual
  plunger lane or the automatic plunger.  The automatic plunger lane fires
  the ball through a gate and onto the playfield such that it should complete
  the Right Orbit.
Skill Shot Rollovers - These are three rollover switches at the end of the
  manual plunger lane, between the gate and a scoop that feeds the ball to
  the Slot Machine kickout.  The lowest switch is the Red Zone, the middle
  is the Orange Zone, and the highest is the Yellow Zone.
Right Orbit - This lane leads past the upper right flipper around the back
  of the playfield to the upper left flipper, exiting down the Left Orbit.
  The automatic plunger fires the ball around the Right Orbit (hopefully).
  When Gumball is lit, the Right Orbit is used to load the Gumball Machine.
  When the Right Spiral is lit, shooting the Right Orbit collects it.  There
  is a Spiral Helper magnet on the Right Orbit, near the back of the
  playfield.  There is a red light on a sign above the upper right flipper,
  indicating when Gumball is lit.  The Orbit itself has a large white
  triangle indicating when Powerball Loop is lit, and beyond that there is a
  smaller orange triangle indicating when the Right Spiral is lit.
Slot Machine - This scoop is just above the upper right flipper and just to
  the left of the Right Orbit.  It is protected on the right by a rubber
  post, and on the left by a narrow Greed Target.  This is the most
  frequently used kickout in Twilight Zone, and ejected balls should come
  directly to the middle of the lower right flipper, if properly adjusted.
  A yellow light above and to the right of the scoop indicates when the Slot
  Machine is available.
Hidden Lane - This is a narrow passageway behind the Slot Machine.  Balls
  which pass through here should feed neatly to the upper right flipper.
Power Payoff - These are two red round standup targets above the Hidden Lane
  and at the bottom of the Player Piano entrance.  No distinction is made
  between the two targets.  A lightning bolt light in front of these targets
  indicates when they are lit.
Player Piano - This is a sinkhole that faces left directly towards the upper
  left flipper.  There is a round Greed Target above it and a rubber post
  below it, just above the Power Payoff targets.  There is a yellow light
  above the sinkhole, indicating when the Player Piano is available.  There
  is also a red light which indicates that a Jackpot is lit at the Player
  Piano.
Clock - This cube-shaped plastic Clock is mounted above the Player Piano.
  In Attract Mode, it can indicate the current time.  During gameplay, it
  counts down timers for various rounds and modes, and is used in special
  ways in some rounds.  On older machines, the Clock is rather plain and
  white; newer machines have a much more colorful Clock.
Lock Lane - This Lane is above the Player Piano and has a narrow line of
  sight to the lower left flipper.  The Lane turns tightly to feed to a
  stack of locked balls, and unfortunately this causes balls to sometimes
  mysteriously bounce out of the Lock and directly towards the center drain.
  There is a amber light here to indicate when an Extra Ball is lit, and a
  orange light to indicate when a Lock is lit (older machines have a green
  Lock light).  Balls are kicked out of the Lock at the Right Spiral Helper,
  such that they come down the Right Orbit to the upper right flipper.
Right Ramp - This is a short metal ramp to the left of the Lock Lane.  It
  leads steeply to a tight turn behind the Clock, where it feeds a habitrail
  that leads to the Bridge Diverter above the upper left flipper.  Beyond the
  Bridge Diverter, the habitrail feeds into the left side of the Powerfield.
  The Right Ramp uses an opto switch behind the Clock; there is no sensor in
  the Bridge Diverter itself.  There is an orange light at the entrance to
  the Right Ramp, indicating when Battle The Power is lit or the Powerfield
  is available for any other reason.
Clock Target - This is a small green standup target between the Left and
  Right Ramps.  There is a round white light in front of it, indicating when
  the Clock Target is lit for any reason.  There are several modes which make
  special use of the Clock Target.
Left Ramp - This is a shallow plastic ramp to the left of the Clock Target
  and to the right of the Left Orbit.  It has a swinging gate and sensor at
  its entrance, and uses a roll-under switch in the back right corner of the
  machine to register a completed Ramp shot.  There is a diverter further
  along the Ramp which is normally in an extended position.  Normally, balls
  feed to a habitrail which crosses the entire playfield and deposits them in
  the innermost Left Inlane.  When the diverter is retracted, balls are fed
  into the automatic plunger lane, where they may fall into the automatic
  plunger or to the manual plunger, depending on the situation.  There are
  three lamps in front of the Left Ramp.  The lowest lamp is orange and
  indicates that the Super Skill Shot is available.  The middle lamp is white
  and indicates that the Left Ramp will start Multiball.  The highest lamp is
  white and indicates that the Left Ramp will award Bonus X and two Robots
  rather than one.
Left Orbit - This is a narrow and short lane above the upper left flipper,
  leading around the back of the playfield and down the Right Orbit to the
  upper right flipper.  When the Left Spiral is lit, shooting the Left Orbit
  collects it.  There is a Spiral Helper magnet on the Left Orbit, just above
  the Bridge Diverter.  There is a yellow light on the corner of the
  Powerfield next to the Bridge Diverter, indicating when the Left Spiral is
  lit.  The Orbit itself has a large white triangle indicating when Powerball
  Loop is lit.
Bridge Diverter - This is a metal cage on the habitrail that is fed by the
  Right Ramp.  When the Powerfield is not available, balls are caught by the
  Bridge Diverter and dropped onto the playfield above the upper left
  flipper.
Gumball Machine - The Gumball Machine is in the far upper left corner of the
  playfield.  It should normally hold three of the six balls installed in
  the machine.  Balls are loaded into the Gumball Machine by a vertical
  kicker (known as the Gumball Popper) that is fed by the Right Orbit when
  the Gumball Diverter is active.  Balls are fed out of the Gumball Machine
  one at a time, where they roll over a switch and fall into the Camera
  sinkhole.
Camera - This is a large sinkhole behind the upper left flipper.  It is
  almost impossible to reach without holding that flipper up.  The Camera
  feeds into the Slot Machine kickout.
Hitchhiker Lane - This lane is beneath the Camera shot and just above the
  Jet Bumpers.  When completed, it feeds the ball into the Jet Bumpers.
Powerfield - This is a raised mini-playfield to the left of the upper left
  flipper.  When the Powerfield is available, shoot the Right Ramp to reach
  it.  Balls enter the Powerfield from the upper left corner.  There are four
  scoring switches on the lower walls of the Powerfield, and an opto near
  the upper exit.  In the lower corners are player-controlled magnets,
  called Magna-Flip(TM).  When a ball is on the active Powerfield, use the
  flipper buttons to control Magna-Flip(TM).  The upper exit feeds into the
  Camera sinkhole, and the lower exit drops the ball into the Jet Bumpers.
Dead End - This is a small sinkhole above and to the left of the Jet
  Bumpers, underneath the Powerfield.  It awards the Town Square or Dead
  End value, and feeds to the Slot Machine kickout.
Jet Bumpers - These three Jet Bumpers are also known as Town Square.  They
  are arranged in the usual triangular fashion, but dangerously close to the
  Left Outlane.  On early machines, there is a rubber bar preventing balls
  from going towards the Left Outlane directly from the Jet Bumpers, while
  encouraging balls towards the center drain.  This bar is not present on
  newer machines.
Left Outlane - The Left Outlane can be lit for Extra Ball.  There is an
  adjustable post above the left side of this Outlane.  The rubber post on
  the right side is considerably lower than the Inlane posts.
Far Left Inlane - This Inlane lights the Right Spiral during normal play.
Near Left Inlane - This Inlane temporarily lights the Slot Machine if it is
  unlit.  The Left Ramp deposits the ball in this Inlane, on the switch.
Slingshots - Normal configuration.
Right Inlane - This Inlane lights Dead End, the Left Spiral (during normal
  play), and the Left Ramp.  The right side of the Inlane is a low metal rail
  with no rubber.
Right Outlane - The Right Outlane can be lit for Special.  There is an
  adjustable rubber post above the right side of this Outlane.
Rocket - This is a catch area beneath the upper right flipper.  A successful
  Skill Shot deposits the ball here.  Whenever a ball lands in the Rocket,
  it is fired at high speed across the playfield, where it should go through
  the Hitchhiker and into the Jet Bumpers.
Greed Targets - There are seven of these yellow standup targets
  scattered across the playfield.  A narrow one stands to the left of the
  Slot Machine.  Two stand along the left side of the Slot Machine, facing
  the upper left flipper.  One stands above the Player Piano, facing the
  upper left flipper.  One stands at the bottom edge of the Hitchhiker,
  facing the upper right flipper.  Another stands just below this, facing
  the center drain.  The last stands above the Near Left Inlane, facing
  along the left Slingshot towards the lower left flipper.
Balls - Six balls should be installed in Twilight Zone, with one of them
  being a white ceramic Powerball.  Early machines had seven balls installed,
  and newer machines may still have seven indicated in their manuals.  If the
  Powerball is missing, a menu adjustment provides full compensation.

                                 Skill Shot
                                 ==========

The normal Skill Shot from the manual plunger lane is to plunge gently, such
that the ball trips one or more of the rollover switches, without landing in
the scoop at the end of the plunger lane.  Hitting the scoop feeds the ball
to the Slot Machine kickout and scores 1M (plus 100K for the Slot Machine
kickout itself).  Hitting the lowest rollover switch (Red) scores 2M and
advances one Jet Bumper (see "Town Square").  Hitting the middle rollover
switch (Orange) scores 5M and advances two Jet Bumpers.  Hitting the highest
rollover switch (Yellow) scores 10M and advances three Jet Bumpers.  It is
possible to hit the lowest rollover switch and have the ball fall back to the
manual plunger lane, in which case it is best to plunge the ball into the
scoop.  Normal Skill Shots feed the ball to the Rocket, which should fire it
through the Hitchhiker lane and into the Jet Bumpers.

The ball easily gets stuck under or in front of the gate at the bottom of the
rollover switches.  A light tap on the side of the cabinet is the easiest way
to handle this.

                               Greed Targets
                               =============

The seven Greed Targets in Twilight Zone are unlit at the beginning of each
ball.  During normal play, hitting the unlit Clock Target will light one of
the Greed Targets (starting from the lower left and working upwards).  These
can also be lit by a Camera Award or the Extra Ball Buy-In.  Hitting a lit
Greed Target awards 5M and unlights that Target.  However, due to a bug in
the software, 10M is actually awarded whenever you see this "5 Million"
animation!  This is true through at least L-4 revisions, and applies
regardless of how the target was lit.

Once per ball and only during normal play, hitting the unlit Clock Target
when all seven Greed Targets are already lit will award a Clock Bonus of 10M,
with an excellent sound effect and animation.

During Multiball modes, or when the 10M Clock Bonus has already been
collected and all seven Greed Targets are lit, hitting the unlit Clock Target
will generate a cuckoo noise.  This can be helpful by letting you know there
is a ball in that area of the playfield during Multiball modes.

The Greed Targets can all be lit automatically by the Camera: Lite Greed
Targets award, and are also used during the Door Panel Greed Round, during
Multiball, and when the Gumball Machine is lit for Powerball Mania (see
"Powerball").  When the Extra Ball Buy-In is used, all seven Greed Targets
are automatically lit and the 10M Clock Bonus is immediately available.

These Targets are also referred to as the 5 Million Targets.

                                   Clock
                                   =====

The Clock, if working properly, is used to count down various rounds and
modes (this is handled by software if the Clock is believed to be
malfunctioning).  In general, the most recently started round has control of
the Clock.  The most common use of the Clock is to count forward from noon
to midnight at a moderate pace; the amount of time this requires represents
the duration of a typical round or mode.  A distinctive sound is made at the
end of any such round or mode; there is a grace period during and briefly
after this sound for almost every such round or mode.

Note that the Clock can only move forward or backwards in a normal fashion;
its arms cannot be moved in any fashion other than the normal progression of
time in either direction.

                                Town Square
                                ===========

The three Jet Bumpers form Town Square.  Town Square has a current value,
which is normally reset to 7.5M at the beginning of each ball.  Unlit Jet
Bumpers advance the Town Square value by 100K.  Lit Jet Bumpers advance the
value by 200K.  Flashing Jet Bumpers advance the value by 300K.  The normal
Skill Shot awards advance one, two, or all three Jet Bumpers by one step,
from unlit to lit to flashing.  Shooting the unlit Camera at any time will
advance one Jet Bumper.  When all three Jet Bumpers are flashing, the next
unlit Camera shot will display "Jets At Max" and no further message will be
displayed for the rest of the current ball.  At the beginning of each ball,
all three Jet Bumpers are unlit.

To collect the current Town Square value, shoot the unlit Dead End sinkhole.
Doing this when Dead End is lit collects double the Town Square value (see
"Dead End").  The Camera: 3X Town Square award is worth three times the
current Town Square value.

The maximum Town Square value is 25M.  The Town Square value can only be
held over to the next ball by the Camera: Hold Town Square award; otherwise
it is always reset to the starting value of 7.5M.

Every Jet Bumper hit rotates the currently flashing Door Panel clockwise.
This of course skips any Panels that are already lit.

See also "Town Square Madness".

                                  Dead End
                                  ========

The Right Inlane (at any time) lights the Dead End sinkhole until it is
collected or the current ball ends.  The lit Dead End is worth double the
current Town Square value.  Lit Dead End shots are counted over the course of
the game.  On normal settings, an Extra Ball is lit when you collect the
third Dead End; this value is operator adjustable between two to seven.

The Dead End Extra Ball is normally temporary.  If you already have the
maximum number of Extra Balls stacked when you collect your third Dead End,
no Extra Ball is lit from Dead End, then or in the future.  For details, see
"Extra Balls".

See also "Easter Eggs".

                                   Robots
                                   ======

The number of Robots you collect is counted over the course of the game.  You
begin the game with one Robot.  The Left Ramp normally awards one Robot at
any time.  The Lock Lane also always awards one Robot.  While the Left Ramp
is temporarily lit by the Right Inlane, it will award two Robots.

On normal settings, a certain number of Robots will light an Extra Ball.
This value reflexes and is typically between 6 and 14 Robots.  A second Extra
Ball is normally lit at 45 Robots, and this value does not reflex.  See
"Extra Balls".

After you collect the 98th Robot, Robots are no longer counted, and every
Robot is worth a Super Robot bonus of 5M.  The Right Inlane has no effect on
this award.

At every multiple of 10 Robots (8 on Easy settings), the Camera is lit.  Lit
Cameras are stacked.  See "Camera".

See also "Easter Eggs".

                                   Camera
                                   ======

The Camera is lit at every multiple of 10 Robots (8 on Easy settings), or by
the Camera Door Panel, which actually lights the Camera twice.  There are
eight possible Camera awards.  The next Camera award is determined randomly,
except that the entire set of eight must be completed before any of the
awards can be repeated.  Also, the same award will never appear twice in a
row.  The next award is randomly pre-determined and preserved between balls,
players, games, and power cycles.  The next Camera award is part of the
status report.  Also, whenever you collect a Camera award, the next Camera
award is displayed.

The eight Camera awards are described in the following sections.

See also "Tournament Mode".

                             Camera: 20,000,000
                             ------------------

This is the simplest Camera award - just 20M, no questions asked.

                          Camera: Hold Town Square
                          ------------------------

This award prevents the Town Square value from being reset at the beginning
of the next ball.  This is the only way to do so.  It does not, technically
speaking, hold the Town Square value to its _current_ value.

                           Camera: 3X Town Square
                           ----------------------

This awards three times the current Town Square value, from a minimum of
22.5M to a maximum of 75M.

                         Camera: Lite Greed Targets
                         --------------------------

This award lights all of the Greed Targets for 5M each, as if the unlit Clock
Target had been hit the appropriate number of times.  If you have not
collected the 10M Clock Bonus on the current ball, this effectively lights
the Clock Target for that Bonus.  See also "Greed Targets".

                         Camera: Clock 10 Millions
                         -------------------------

This award starts a timed round of normal length, using the Clock as the
timer if possible.  During this time, the Clock Target adds 10M to the Clock
Millions Total, regardless of other modes or rounds.  Starting Clock 10
Millions credits a base value of 10M to the Clock Millions Total.

Scoring at least six hits on the Clock Target during this round will award a
special 20M Clock Damage Bonus (and animation) when the round ends, unless
the sixth hit was scored during the ending grace period.

See also "Door Panel: Clock Millions".

                           Camera: 10 Hitchhikers
                           ----------------------

This award awards 10 Hitchhikers as if they had been collected normally,
unless you already have 100 Hitchhikers.  Because Battle The Power is lit at
every multiple of 10 Hitchhikers, this will normally light Battle The Power
as well.  If you have between 90 and 100 Hitchhikers, this award will set
your total to 100 Hitchhikers, never any higher.

If the Hitchhiker Door Panel has been awarded on the current ball, this
award is worth an immediate 20M.

See also "Hitchhikers".

                           Camera: Lite Outlanes
                           ---------------------

This award lights the Outlanes (see "Lit Outlanes").  If the Outlanes are
already lit, this award has no effect.  If they are partially lit, this
award will reset them to normally lit.

                           Camera: Collect Bonus
                           ---------------------

This award awards your current End-of-Ball Bonus exactly as if you had just
drained, except that there is no quote for a Bonus of 100M or more.  It does
not change or reset any part of your Bonus, however.  This is obviously the
most valuable award, if used properly.

See also "End-of-Ball Bonus".

                                Hitchhikers
                                ===========

The number of Hitchhikers you collect is counted over the course of the
game.  You begin the game with one Hitchhiker.  At all times except during
Lost In The Zone, the Hitchhiker Lane will award at least one Hitchhiker
(Hitchhikers awarded during Lost In The Zone do not count towards your
normal total, although Robots do).  During normal play, hitting the
Hitchhiker Lane switch twice in very quick succession will only award one
Hitchhiker, on the correct assumption that the ball has tripped the switch
once in each direction and not fallen into the Jet Bumpers as it should.
During Multiball modes, every trip of the switch awards a Hitchhiker.
Shooting the Left Orbit and then the Hitchhiker Lane within the next second
or two will award a Triple Pickup, which is three Hitchhikers.  This is true
during all modes, including Lost In The Zone.

At the award of the third Hitchhiker and at every multiple of 10
Hitchhikers, Battle The Power is lit on the Right Ramp.  Lit Battle The
Power's are stacked.  See "Battle The Power".

After the Hitchhiker Door Panel has been awarded, every Hitchhiker for the
rest of the current ball is worth 2M.  The Triple Pickup is then worth 6M.
The Camera 10 Hitchhikers award is then worth 20M.

During Lost In The Zone, Hitchhikers are worth 2M towards the Lost In The
Zone Total.

See also "Easter Eggs".

                              Battle The Power
                              ================

There are many ways to light Battle The Power on the Right Ramp.  Battle The
Power is lit at the third and every multiple of 10 Hitchhikers.  It is also
lit by a Door Panel.  It is also lit by every other Spiral award.  It is
also lit by the Red award of the Super Skill Shot.  It can also be
automatically lit at the beginning of the game if this option has been set in
the menus.

When Battle The Power is lit, the Bridge Diverter will move aside to let the
ball onto the Powerfield.  The Magna-Flip(TM) flippers are then active.  You
have at least 10 seconds in which to attempt to defeat the Power, which is
done by magnetically propelling the ball through the upper exit from the
Powerfield.  The Powerfield value starts at 5M, and is increased by all four
scoring switches and the opto at the top of the Powerfield.  The value of
these switches starts at 500K.  After you first defeat the Power, the switch
value is 750K for the rest of the game.  After the second defeat, the switch
value is 1M.  The switch value goes no higher.  The opto at the upper exit of
the Powerfield counts as two switch closures for this purpose.

Defeating the Power doubles the Powerfield value and awards the currently
flashing Door Panel (and advances the flashing light as if you had hit the
Player Piano), leaving the Player Piano in its current lit or unlit state
(the Slot Machine will always be lit, because you just hit the Right Ramp).

Defeating the Power also lights the Power Payoff targets for 10M.  This is
not stacked.

The cumulative Powerfield values are part of your Bonus, to no known
maximum.

Defeating the Power is detected by the combination of tripping the upper
playfield opto followed by the Camera sensor in the next few seconds.  During
Powerball Mania and Lost In The Zone, this provides a way to "cheat" Mania
Jackpots by shooting the Camera while a ball is on the Powerfield.

Note that there is a grace period during which you can get a few more shots
at defeating the Power before Magna-Flip(TM) is truly disabled.  However, it
is possible to defeat the Power so late that you will but will only be given
credit for shooting the Camera.

After any use of the Powerfield, a special ball search takes place to try to
make sure that all balls have exited the Powerfield.  This special ball
search pulses Magna-Flip(TM) twice, and is of course only noticeable when a
metal ball has actually become stuck on the Powerfield.

If the Powerfield is not properly leveled, the ball will frequently become
stuck in either corner.  The special ball search will then take effect.
Regardless of what dislodges the ball, you cannot defeat the Power at this
point - a lucky shot through the upper exit will behave as if you had simply
shot the Camera.

Sometimes after a Multiball mode has ended, the Battle The Power light will
not be lit even if Battle The Power is available.  I am not referring only to
the case in which the Powerball was involved in the previous Multiball and
the software is unsure where it now resides.  I am also at a loss to explain
why the software sometimes stops balls on Spiral Helpers after a round such
as Fast Lock.  Perhaps the Powerball was spuriously detected during the round
and now the software would like to make sure it's not on the playfield.

                                  Gumball
                                  =======

Spell GUMBALL by hitting both ramps in normal play; the Left Ramp awards
GUM and the Right Ramp awards BALL.  Spelling GUMBALL lights a Lock and
the Gumball Machine.  Lit Gumball Machines are stacked, but you cannot
spell GUMBALL again until you have used the lit Lock or completed Multiball.

See also "Combos".

                              Gumball Machine
                              ===============

The Gumball Machine can be lit by spelling GUMBALL or by the Lite Gumball
Door Panel.  When it is lit, shoot the Right Orbit during normal play to
load the Gumball Machine.  The Gumball Diverter will activate and the ball
will be kicked into the Gumball Machine.  Another ball will then be fed from
the bottom of the Gumball Machine to the Slot Machine kickout by way of the
Camera sinkhole.  In normal play, there should be three balls in the Gumball
Machine, and typically one of them is the Powerball, such that every third
load of the Gumball Machine will release the Powerball.

Loading the Gumball Machine the first time in a game (for each player) is
worth 15M, the second time is worth 20M, and all subsequent loads are worth
25M.  These points are awarded immediately.

Note that on newer ROMs, an automatic plunge (as from a ball saver) will not
load the Gumball Machine (or start Powerball Mania).

Older machines lack a plastic piece in the Gumball Machine that keeps the
balls stacked vertically.  In these machines, it is possible for the balls
to rotate as a ball is fed out, such that one ball is never let out of the
Gumball Machine.  You should probably complain to your operator if you run
into this problem.

                                 Powerball
                                 =========

The Powerball is a ceramic ball much like a steel pinball.  It is very
slightly lighter and very slightly larger.  It plays very differently from
a steel pinball partly for these reasons and partly because it tends to
spin and bounce differently.  The Powerball is, of course, completely immune
to magnets.

There are two Powerball Sensors (called Proximity Sensors) in Twilight Zone;
one is in the trough at the next ball to be served, and the other is just
above and to the left of the Slot Machine kickout, such that the Sensor is
crossed by balls coming from the Player Piano, Camera, Gumball Machine,
Powerfield upper exit, and Dead End, but not by balls that enter the plunger
lane scoop or the Slot Machine itself.

When the Powerball is on the playfield during normal play and has been
detected by at least one of the Powerball Sensors, the Gumball Machine is
lit for Powerball Mania, and the Greed Targets are flashing.  There is a
Powerball Payoff value which always starts at a base of 10M.  The Greed
Targets increase the Powerball Payoff value (by 5M each) while the Powerball
is known to be the only ball on the playfield.  All game features which do
not involve the use of magnets are still available at this time.  Spiral
Helper magnets are disabled and Battle The Power is temporarily unavailable,
but you may still collect Door Panels, spell GUMBALL, light and use Locks,
start Multiball, collect Combos, etc.

Whenever the Powerball completes an Orbit, a Powerball Loop is awarded, which
is worth an immediate 10M.  This can be done with the left Orbit when
Powerball Mania is lit, or with either Orbit during any Multiball mode except
Powerball Mania itself.

Shooting the Right Orbit to the Gumball Diverter awards the current Powerball
Payoff value and starts Powerball Mania.  See "Powerball Mania".

Note that on newer ROMs, an automatic plunge (as from a ball saver) will not
start Powerball Mania.

If the Powerball is missing from the machine, there is software compensation
to simulate it.  When the Powerball is being simulated by software, the
"Powerball" display is in reverse video.

If the Powerball has not been detected after a certain number of consecutive
loads of the Gumball Machine (five or six?), it is simulated and Powerball
Mania begins immediately (there is no round in which to build up the Payoff
value).  It is possible to encounter this form of compensation while the
Powerball is resting in the trough (rather than truly missing), by using
stacked Gumball's from previously spelled GUMBALL's.  This form of
compensation only happens when the Trough Proximity Sensor is faulty.

This simulation of the Powerball may also be dictated by a menu adjustment,
which will cause the Powerball sensors to be ignored.  In this case, the
Powerball is simulated for every second ball released from the Gumball
Machine, and a normal Powerball Payoff round is available while Powerball
Mania is lit.

Note that if the powerball is being simulated (normally as the result of a
menu adjustment), every other ball dispensed by the Gumball Machine for each
player will be designated a Powerball.

The software attempts to deduce which ball is the Powerball by keeping track
of which balls are _not_ the Powerball, although it is difficult to make good
use of this knowledge.  The most helpful consequence of this is that the
Powerball is kept track of in the Lock Lane even though there is no Proximity
Sensor there.  However, I have seen this lead to unusual behavior on some
machines, where a steel ball is released from the Lock and identified as the
Powerball.

The software also keeps virtual track of where it thinks the Powerball is in
the Gumball Machine, as additional but not necessarily helpful verification
that the Machine and Proximity Sensors are working properly.

                              Powerball Mania
                              ===============

Powerball Mania can only be started by loading the Powerball into the
Gumball Machine when the game knows the Powerball is the only ball on the
playfield, or by every second load of the Gumball Machine when software
compensation is active as described under "Powerball".

Starting Powerball Mania immediately awards the current Powerball Payoff
value, which starts at 10M (5M on prototype ROMs) and is increased by the
Greed Targets before Powerball Mania.  The Powerball is loaded back into the
Gumball Machine, one ball is fed from the Gumball Machine, and two other
balls are put into play.  These other balls come from the Lock if possible,
otherwise from the trough by way of the automatic plunger.

The Clock counts down at the beginning of Powerball Mania.  Until it reaches
the end of its cycle, all targets credit 250K to the Powerball Mania Total,
which is part of your End-of-Ball Bonus.  The Powerball Mania Total begins at
5M.  The Clock never pauses when timing this initial Frenzy, even when all
balls are out of play (that is, locked or being launched).

There is a short grace period at the beginning of Powerball Mania, during
which balls that drain will be relaunched into play by the automatic plunger.
It is possible for all three balls to drain and be relaunched into play.

During Powerball Mania, the Right Ramp is flashing for a special version of
Battle The Power.  You can shoot any number of balls up the Right Ramp to
enter the Powerfield, where Magna-Flip(TM) is active while the real flippers
are also active.  Each ball that enters the Powerfield resets the timer for
Magna-Flip(TM).  The Powerfield switch value is always 750K during Powerball
Mania, and this is credited to your Powerball Mania Total.  Therefore, during
the initial Frenzy, Powerfield switches credit a total of 1M each to the
Powerball Mania Total.

Defeating the Power during Powerball Mania awards a Mania Jackpot, which is
always 50M.  This value is credited towards your Powerball Mania Total.
After defeating the Power, the timer continues for any balls remaining on
the Powerfield, but the Right Ramp no longer feeds the Powerfield.  Hit the
Left Ramp to relight the Right Ramp to reach the Powerfield.  After each
Mania Jackpot, the Powerfield timer becomes shorter, to a minimum of roughly
four seconds.  This shorter timer applies to all subsequent Powerball
Manias.  It also seems that a very quick drain from the Powerfield will make
the next Powerfield timer more generous.

You can collect "cheat" Mania Jackpots during Powerball Mania by shooting the
Camera after a ball has tripped the upper opto on the Powerfield.  This can
be used to collect several Mania Jackpots with only one ball on the
Powerfield.

It is possible to defeat the Power twice in very quick succession, such that
only one ball will be detected and only one Mania Jackpot awarded.  This was
corrected in ROM revision L-4.  The corrected version also makes it easier to
"cheat" multiple jackpots as a result.

As in all other Multiball modes, Door Panels, Combos, Spiral Values, and the
Camera are unavailable during Powerball Mania.

Powerball Mania ends when you drain at least two of the three balls in play.

The Low Line menu option applies to Powerball Mania.  This option disables
the upper flippers during this mode, which provides more power to the
Magna-Flip(TM) magnets.  These magnets invariably have less power while the
flippers are active.

                                   Locks
                                   =====

Locks are lit at the Lock Lane by spelling GUMBALL (see "Gumball").  Locks
cannot be stacked, as you cannot spell GUMBALL until you have used the
currently lit Lock.

On normal settings, only one Lock is needed to light the Left Ramp for the
first Multiball, and the second and third Locks are effectively lit for free.
For the second Multiball, locking the second ball will leave the Lock Lane
lit for the third Lock without spelling GUMBALL again.  Menu adjustments can
affect these rules.  Specifically, it is possible to allow Multiball to be
started from the Left Ramp after the first time, and to allow the third Lock
to be lit for free after the second time.

The Super Skill Shot on the Left Ramp takes precedence over starting
Multiball.  See "Door Panel: Super Skill Shot".

Locking the third ball or hitting the Left Ramp when lit for Multiball
immediately starts Multiball.  Multiball cannot be started during any other
Multiball mode or when the Fast Lock countdown is running.  However, it is
compatible with all other rounds.

                                 Multiball
                                 =========

When Multiball starts, the Jackpot is immediately lit at the Player Piano.
Its starting value is 15M if only one ball was locked before starting
Multiball (this is normally only possible for the first Multiball); otherwise
it starts at 40M.  On prototype ROMs, these values are each 5M less.

During Multiball, the Greed Targets are always flashing, lit to increase the
Jackpot value by 5M each.  When a Greed Target is hit, it remains unlit until
all seven Targets have been hit or until a Jackpot has been collected, which
resets all seven Targets.  When all seven Targets have been hit and the
Jackpot has still not been collected, one Target is lit at a time, proceeding
in order from the lower left set of three, to the far upper right, then from
top to bottom in the set of three at the Slot Machine.  The Jackpot can be
increased to a maximum of 255M by hitting the Greed Targets.

Greed Targets which were lit by the unlit Clock Target during normal play
before Multiball remain lit during all Multiball modes but this is unrelated
to the Jackpot value.

Hit the Player Piano to collect the Jackpot.  This resets the Jackpot to its
previous base value plus 10M.  It also resets the Greed Targets and leaves
the Jackpot unlit.  Relight the Jackpot by shooting the Camera.  This
sequence proceeds as long as at least two balls are in play.  There is a
grace period for shooting the Jackpot, during which a Door Panel will also be
awarded from the Player Piano after the Jackpot animation (if the Player
Piano is in fact lit).

The base Jackpot value will only increase five times.  This limits the base
Jackpot value to 65M or 90M, depending on how many balls were locked before
starting Multiball.

During the Jackpot animation, no balls are kicked out from the Slot Machine
or automatic plunger.

Spiral Helpers will help you with both the Jackpot and Camera shots as
appropriate, unless the Door Panel Spiral Round is running, in which case
its rules take precedence (see "Spiral Helpers").  When the Jackpot is lit,
the left Spiral Helper is active.  When the Camera is lit to relight the
Jackpot, the right Spiral Helper is active.  Note that during Multiball, both
Spiral Helpers will always be reachable from either Orbit.  When the Spiral
Helpers are active (they can only be overridden by Spiral Breakthrus), a
completed Orbit will be credited as a Powerball Loop for 10M, on the
assumption that the Powerball completed an Orbit and was of course unaffected
by the Spiral Helpers.

The Right Ramp will also neatly present the ball to the upper left flipper
for a shot at the Jackpot.  When the Right Ramp is hit and the Jackpot is
lit, other kickouts will be delayed until you've been given a brief but
clean shot at the Jackpot.  In fact, given a choice between dropping a ball
from the Bridge Diverter and activating other kickouts, the Bridge Diverter
will take precedence regardless of whether the Jackpot is lit or not.  This
is somewhat unfortunate.  However, when there is a ball in the Lock Lane or
on the Right Spiral Helper and the Camera is lit to relight the Jackpot, the
Slot Machine kickout will be delayed until you've been given a very brief but
clean shot at the Camera.

Shooting the Jackpot with the Powerball (if properly detected) will award
double the Jackpot value.  This value is displayed as doubled without regard
to internal 8-bit overflow, such that a 255M Jackpot becomes 254M when
doubled, 140M becomes 25M, etc.  This is merely a display error, however; the
correct value is still added to your score.

Double Jackpots depend entirely on the Powerball Sensor at the Slot Machine;
they can be awarded even when the Powerball is obviously somewhere else.
This most commonly happens when a ball falls into the Slot Machine
immediately after a Jackpot registers; the software sees the ball at the Slot
Machine before the intervening Proximity Sensor detects a metal ball, so it
assumes that the Powerball passed from the Jackpot switch to the Slot Machine
switch.

Double Jackpots are not available when menu adjustments indicate that the
Powerball is missing, because the Powerball Sensors are then categorically
ignored.

There is no grace period for relaunching balls during Multiball.  If you
drain two of the three balls without collecting any Jackpots, the Lock Lane
will be lit for a Multiball Restart for 15 seconds.  The Restart will resume
Multiball as it was before, with the Jackpot value as it was before, although
subsequent Jackpots will progress as if Multiball had been started with only
one ball locked; that is, the second Jackpot is 25M, and the maximum base
value is 65M.

There is no grace period on the Multiball Restart, even though the music runs
for a second or two after the timer expires.  There is, however, a lead-in
grace period.  That is, if the last thing you shot was the Lock Lane when the
other balls drained, you may be given credit for the Restart immediately,
even though the ball has already been ejected from the Lock Lane.  This is
much appreciated.

In all Multiball modes (normal, Fast Lock, and Powerball Mania), Door Panels,
Combos, Spiral Values, and the Camera are unavailable.  During the Multiball
Restart period, the only difference is that Combos are available.

Multiball ends when you drain at least two of the three balls in play, with
the exception of Multiball Restart as described above.

                               Spiral Values
                               =============

Spiral Values are represented by a row of six lights directly above the
lower flippers.  The Spiral Values are, in order:

2 Million
3 Million + Battle The Power
4 Million
5 Million + Battle The Power
10 Million
Lite Extra Ball + 10 Million + Battle The Power

After the last award, subsequent Spiral Values (until reset) alternate
between 10 Million and 10 Million + Battle The Power.  On normal settings,
collecting the last award will reset the Spiral Values at the beginning of
the next ball, such that only the first award is flashing.

On normal settings, the first two lights are lit at the beginning of the
game, and the third light is flashing.  The flashing light represents the
next Spiral Value to be awarded.  Collect a Spiral Value by shooting a lit
Orbit.  The Right Orbit is lit by the Far Left Inlane, while the Left Orbit
is lit by the Right Inlane.  Also, shooting either Orbit when unlit will
light that Orbit.  Orbits only remain lit for a few seconds, and the timers
do not ever pause.  Shooting a lit Orbit does not leave it lit for an
additional Spiral Value.

Shooting an unlit Orbit does not light that Orbit for a Spiral Value if the
Spiral Helper on the near side was active, as this would make Spiral Values
too easy to collect under certain conditions (such as when the Camera is lit
in normal play).  See "Spiral Helpers".

Normally, the Extra Ball lit by the last Spiral Value is a temporary Extra
Ball.  See "Extra Balls".

On prototype machines, lighting Battle The Power was not part of the Spiral
Values.

Here's a truly bizarre case:  If the Right Spiral is lit and you shoot the
Lock Lane but the ball jumps leftwards and over the divider that separates
the Lock Lane from the Gumball Diverter sinkhole, the Gumball Machine will be
loaded (with points awarded if the Gumball Machine was lit), and the next
Spiral Value will be awarded as compensation!

                               Spiral Helpers
                               ==============

The Spiral Helpers are magnets located on either Orbit.  These magnets are
triggered by accompanying opto sensors and activated when appropriate.  The
exact conditions for each Spiral Helper to be active are complex, and this
section attempts to describe all possible situations.  Thanks go to Mark
Phaedrus, <phaedrus@halcyon.com>, for the format of this explanation.  The
conditions are listed below, with precedence from top to bottom.  If no
information is presented for one Orbit under a given condition, that
condition does not affect Helpers on that Orbit shot.

Powerball is known to be the only ball on the playfield (obvious case):
  -  left Orbit: no Helper
  - right Orbit: no Helper
Spiral Round running, fourth and later Orbits for Spiral Breakthru:
  -  left Orbit: no Helper
  - right Orbit: no Helper
Lost In The Zone running:
  -  left Orbit: no Helper
  - right Orbit: no Helper
Gumball Machine lit for GUMBALL or Powerball Mania:
  - right Orbit: no Helper
Automatic plunger during Multiball:
  - right Orbit: no Helper (left Helper on slow balls if Jackpot lit)
Automatic plunger for ball saver:
  - right Orbit: left Helper active if Right Spiral is lit, but right Helper
      is always disabled
Jackpot lit during Multiball:
  -  left Orbit: left Helper
  - right Orbit: left Helper
Camera lit during Multiball:
  -  left Orbit: right Helper
  - right Orbit: right Helper
Town Square Madness running:
  -  left Orbit: right Helper
  - right Orbit: right Helper
Camera lit during normal play:
  -  left Orbit: right Helper
  - right Orbit: right Helper
Spiral Round running, first Orbit:
  -  left Orbit: left Helper
  - right Orbit: right Helper
Spiral Round running, second Orbit:
  -  left Orbit: left Helper
  - right Orbit: right Helper if first Orbit was on left
  - right Orbit: left Helper if first Orbit was on right
Spiral Round running, third Orbit:
  -  left Orbit: right Helper
  - right Orbit: right Helper if first two Orbits were on left
                 left Helper if Orbit has been made on right
Spiral Value lit on left Orbit:
  -  left Orbit: right Helper
Spiral Value lit on right Orbit:
  - right Orbit: left Helper
Normal play:
  -  left Orbit: no Helper
  - right Orbit: no Helper

Note that none of the Helper behaviors prevent the award of lit Spiral
Values, although some cases make it easier to collect a Spiral Value.
Specifically, if a Spiral Helper is active on the near side of a lit Spiral,
credit is given for the entire Spiral shot when the ball reaches the near
Spiral Helper, provided that the ball appears to reach that Spiral Helper
before the opposite Helper.  For example, when the Camera is lit in normal
play, a weak Right Orbit shot can collect a lit Spiral Value by only reaching
the right Spiral Helper, rather than having to go all the way around to the
left Spiral Helper.

Credit is given for the lit right Spiral whenever a ball is loaded into the
Gumball Machine.

Also, shooting the Left Orbit to the right Spiral Helper when Town Square
Madness is running or the Camera is lit (in normal play) does not disallow
collecting the Triple Pickup by shooting the Hitchhiker Lane.

When Spiral Helpers are lit during any Multiball mode and a ball completes an
Orbit without being properly caught, a Powerball Loop will be awarded for
10M, on the assumption that the Powerball has just rightfully ignored the
Spiral Helper magnets.  Note that in order to detect legitimate Powerball
Loops, the Spiral Helpers are enabled when the Powerball is known to be the
only ball in play.

The Spiral Round can be very confusing.  The basic idea is that the left
Spiral Helper is used no more than twice and the right Spiral Helper is used
no more than once.  When shooting an Orbit, if the near Spiral Helper is
still available according to these specifications, it will be activated;
otherwise, the far Spiral Helper will be activated.  After three Spirals have
been collected, Helpers are deactivated for the remainder of the Spiral
round.

During the Spiral Round, loading the Gumball Machine behaves as if a normal
right Orbit was completed, counting as one use of the right Helper if it had
not been used previously, otherwise counting as a use of the left Helper.
Also, a ball ejected from the Lock Lane can trip the right Helper and give
credit for a Spiral award if the right Helper had not yet been used.

If fewer than two Spirals have been collected during the Spiral Round and a
ball is automatically plunged, two Spiral values are awarded, one for each
Spiral Helper.

Similarly, if the Powerball is used to complete an Orbit during the Spiral
Round (before two Spirals have been collected), two Spiral awards will be
given, plus the 10M Powerball Loop.  This is usually only possible on the
left loop when Powerball Mania is lit, although it could also theoretically
be done during Multiball if the autoplunger failed to collect more than one
Spiral award automatically.

If the ball is launched from the automatic plunger when this is not expected
(due to some hardware failure), the overrides described above for the
automatic plunger do not apply.  In particular, the ball can be launched
directly onto the active Right Spiral Helper, which does a very impressive
job of decelerating it.

In general, the right Spiral Helper gets more use than the left one.

                                Lit Outlanes
                                ============

The Outlanes can be lit by a Camera award or by the Orange award of the
Super Skill Shot.  The Left Outlane lights for an Extra Ball (the only Extra
Ball which is not awarded from the Lock Lane), and the Right Outlane lights
for Special.  On normal settings, Outlanes are "hard", which means that only
one Outlane is lit at a time (starting with the left for Extra Ball), and the
lit Outlane is steered by the slingshots.  Hitting either slingshot moves the
light to the opposite Outlane.  When one lit Outlane has been collected, the
other will be lit on every second slingshot hit.

Strangely, the light is also moved to the opposite Outlane when you collect
an Extra Ball, either at the Lock Lane or from the Left Outlane itself.

When the Outlanes are set to "easy", both Outlanes are lit at once and the
slingshots and Lock Lane have no effect on the Outlanes.

Lighting the Outlanes when they are already lit has no effect unless one
Outlane has already been collected, in which case the Outlanes are reset to
normally lit.  You cannot have both Outlanes simultaneously lit on the
default "hard" settings.

                                  The Door
                                  ========

The Door is arguably the most central feature of Twilight Zone.  The Door is
a large collection of lights in the lower middle of the playfield,
representing a grid of awards and progress towards Multiball.  The four large
red lights indicate progress in spelling GUMBALL and locking balls.  The
yellow lights on the perimeter of the Door represent Door Panels, which are
awards and rounds described in later sections.  The small white Door handle
represents Lost In The Zone, which also has its own section.

On normal settings, collecting the Yellow award from a normal skill shot
will spot the 10 Million Door Panel.  Menu adjustments also allow the free
spotting of the Battle The Power and Lite Gumball Door Panels whenever that
award has been accomplished in some other fashion.  These rather unusual
settings are intended to make it easier to reach Lost In The Zone by reducing
the number of times one must shoot the Player Piano or the Slot Machine or
defeat the Power.

Collecting any Extra Ball disables the Lite Extra Ball Door Panel on the
current Door, regardless of settings.  Also, if you have the maximum number
of Extra Balls stacked when you begin a new Door, the Lite Extra Ball Door
Panel will be spotted.  See "Extra Balls".

Starting Multiball makes many noisy references to the Door.

                                Player Piano
                                ============

During normal play and when lit (yellow light), the Player Piano awards the
currently flashing Door Panel.  The flashing light then advances clockwise
to the next available Door Panel (or to the Door Handle), and the Player
Piano remains unlit unless Lost In The Zone is the next award.  The Player
Piano is lit by the Left Ramp.  On normal settings, the Player Piano is
automatically lit at the beginning of each ball.  This is not true on hard
settings or for five ball play.

During Multiball, the lit Player Piano (red light) awards the Jackpot.

                                 Odd Change
                                 ==========

When the Player Piano is unlit or unavailable because of a running Multiball
mode, it awards Odd Change.  This is a random value between 10 and 9,999,990,
inclusive.  The distribution of these values is certainly not even.  It seems
most likely that a random number of digits (two to seven) is selected and
then the digits are generated.  During Lost In The Zone, however, Odd Change
values are always seven digits.

An Odd Change value of 10M is not possible.

                                Slot Machine
                                ============

During normal play and when lit, the Slot Machine awards a random Door
Panel.  If at all possible, this is not the currently flashing Door Panel or
the Lite Extra Ball Door Panel.  Unless the currently flashing Door Panel was
awarded, the flashing light is not affected by this award.  The Slot Machine
remains unlit until relit indefinitely by the Right Ramp or temporarily by
the Near Left Inlane.  On normal settings, the Slot Machine is automatically
lit at the beginning of each ball.  On hard settings or for five ball play,
this is not the case.

The unlit Slot Machine awards 100K.

Hitting the Slot Machine immediately after a kickout from the Slot Machine
awards nothing, on the assumption that the ball was not properly kicked out.
The timing for this is flawless and it should be impossible to hit the ball
back in quickly enough to have a problem with this.

The Slot Machine tends to favor the weaker awards, such as 10 Million, Lite
Gumball, Battle The Power, and Super Slot.

                                Door Panels
                                ===========

There are fifteen Door Panels, counting the Handle.  During normal play, the
currently flashing Door Panel is awarded by the lit Player Piano or by
defeating the Power, and a random Door Panel is awarded by the lit Slot
Machine.  There is no other way to collect Door Panels.

Lit Door Panels have already been collected or spotted, and cannot be
collected again until after Lost In The Zone has been completed.  The
flashing Door Panel is rotated clockwise by the Jet Bumpers.

At the beginning of the game, one of four Door Panels will be the currently
flashing award: Town Square Madness, Clock Millions, Camera, or Clock Chaos.
This is not necessarily the same for each player in a multi-player game.

The Door Panels are described here in clockwise order, starting in the upper
left corner.

                      Door Panel: Town Square Madness
                      -------------------------------

This is a timed round of normal length, during which all targets increase
the Town Square Madness Total, which is part of the End-of-Ball Bonus.
Starting Town Square Madness credits 3M to the Town Square Madness Total.
Every switch in the game increases that Total by 350K.  Each hit of the Jet
Bumpers credits the _current_ switch value and increases that switch value by
25K.  The maximum switch value during Town Square Madness is 1M.

When Town Square Madness is running, the right Spiral Helper will catch
balls to allow a shot at the Hitchhiker Lane, subject to various conditions.
See "Spiral Helpers".

                        Door Panel: Lite Extra Ball
                        ---------------------------

This award immediately lights an Extra Ball, provided that you do not
currently have too many Extra Balls.  Collecting any Extra Ball will disable
this award on the current Door.  If Extra Balls have been completely disabled
by menu adjustments, this Door Panel will always be lit and does not need to
be collected in order to reach Lost In The Zone.  If you begin a new Door and
already have the maximum number of Extra Balls stacked, this Door Panel will
be lit and unavailable.

See also "Extra Balls".

                           Door Panel: Super Slot
                           ----------------------

This is a timed round of normal length, during which the Slot Machine's
yellow light is rapidly flashing, and the Slot Machine is worth a random
value of 10M to 20M (by millions) in addition to its usual behavior.  These
points are awarded immediately.  In order to collect Door Panels from the
Slot Machine during this round, you must light it in the usual fashion.

                         Door Panel: Clock Millions
                         --------------------------

This is a timed round of normal length, during which the Clock Target is
worth the current position of the Clock's hour hand, in millions.  Because
the Clock runs from noon to midnight, this means that there is a brief
initial period during which the Clock Target is worth 12M.  Values awarded
by the Clock Target are credited to the Clock Millions Total, which is part
of the End-of-Ball Bonus.  Starting Clock Millions credits 5M to this Total.
During the brief grace period, the Clock Target's value is 12M.  This grace
period is actually long enough to hit the Clock Target twice.

Scoring at least six hits on the Clock Target during this round will award a
special 10M Clock Damage Bonus (and animation) when the round ends, unless
the sixth hit was scored during the ending grace period.

                           Door Panel: The Spiral
                           ----------------------

This is a timed round of normal length, during which all Orbit shots are
worth a special value in addition to normal behavior, and during which most
typical Spiral Helper behavior is overriden (for an exact description of
behavior, see "Spiral Helpers").  The first two Orbit shots are worth 10M
each, the third is worth 15M, and all subsequent Orbit shots during this
round award a Spiral Breakthru for 15M.  These points are awarded
immediately, in addition to other awards, and there is no grace period for
collecting these values.

                        Door Panel: Battle The Power
                        ----------------------------

This Door Panel lights Battle The Power on the Right Ramp (these can be
stacked).  If the Powerfield is currently unavailable (for example, the
Powerball is on the playfield), lit Battle The Power's are remembered.

This Door Panel can be spotted by lighting Battle The Power in any other
fashion, if the appropriate menu adjustment has been made.

                           Door Panel: 10 Million
                           ----------------------

This Door Panel immediately awards 10M.  Big Points ;-)

This Door Panel is spotted by the Yellow award from the normal skill shot on
normal settings.

                             Door Panel: Greed
                             -----------------

This is a timed round of normal length, during which all seven Greed Targets
are flashing.  In addition to their normal behavior, these Targets credit 5M
to the Greed Total, which is part of the End-of-Ball Bonus.  Starting the
Greed round credits 5M to this Total.  Hitting a flashing Target unlights it.
When all seven Targets have been hit, all of the Targets will return to
flashing status.

A Greed Total of 25M or more will earn a familiar quote from Rod: "There,
see what Greed will get you?"

                             Door Panel: Camera
                             ------------------

This Door Panel lights the Camera twice.  Lit Cameras are stacked, of course.
See "Camera".

                           Door Panel: Hitchhiker
                           ----------------------

This Door Panel awards an immediate 2M for each Hitchhiker that you
currently have, and makes every Hitchhiker collected for the rest of the
current ball worth an immediate 2M (Triple Pickup awards 6M, Camera: 10
Hitchhikers awards 20M).  The points count down slowly at first but soon
become gunfire.  Collecting this Door Panel twice on a single ball does not
increase this value, unfortunately.

Because the maximum number of Hitchhikers is 100, the maximum value of this
award is a pleasant 200M.

On L-4 ROMs, the volume is turned down considerably during this award.

                          Door Panel: Clock Chaos
                          -----------------------

This is a timed round of potentially unlimited length.  A base of 5M is
credited to the Clock Chaos Total, which is part of your End-of-Ball Bonus.
The Clock winds itself to 6 o'clock and starts slowly winding backwards
towards noon.  Hitting the Clock Target credits the current value of the
Clock's hour hand in millions to the Clock Chaos Total, and reverses the
direction of the Clock's winding.  When this happens, the music ("Pop Goes
The Weasel") and the winding become faster.

Scoring at least six hits on the Clock Target during this round will get you
a special quote and adds 25M to the Clock Chaos Total; see "Easter Eggs".

Hitting the Clock Target during the grace period will credit 12M to the
Clock Chaos Total and resume the Clock Chaos round!  At least once, however,
I have received a mysterious 63M towards my Clock Chaos Total for doing this.

Clock Chaos is undoubtedly the worst time for the physical Clock to be
disabled because the software believes it is malfunctioning.  It is much,
much easier to read the current time and direction of time from the real
Clock than it is from the display, especially during Multiball modes.

The good news is that if the Clock is indeed working, Clock Chaos will always
take precendence over any other round that wants to use the Clock.

                        Door Panel: Super Skill Shot
                        ----------------------------

This Door Panel lights the Left Ramp for the Super Skill Shot, which takes
precedence over Multiball on the Ramp.  Hitting the Left Ramp during normal
play (including when the Powerball is on the playfield) will divert the ball
into the manual plunger lane, where the Skill Shot Rollovers are lit for very
attractive awards.

For the Super Skill Shot, all three awards and the scoop award 10M,
regardless of skill.  The Red award lights Battle The Power (see "Battle The
Power").  The Orange award lights the Outlanes (see "Lit Outlanes").  The
Yellow award lights a temporary Extra Ball (see "Extra Balls").  Missing
simply awards 10M and ejects the ball from the Slot Machine Kickout.

Super Skill Shots cannot be stacked.

                           Door Panel: Fast Lock
                           ---------------------

This is a timed round of normal length, during which a radio tunes itself
down from 17.3M to 5.3M before the round ends.  During this time, the Lock
Lane is lit to award the current value and start Fast Lock Multiball.  The
gimmick here is that the sound effects, quotes, and music during this round
and the (optional) ensuing Multiball correspond to previous games of Pat
Lawlor design.  These effects, quotes, and music are listed here in the order
they are presented during the round (with thanks and credit to Bowen Kerins,
<bowen@cardinal.stanford.edu>):

  - The Addams Family: Sounds of Cousin It mumbling.  When hit, Cousin It
    yelps.  During Multiball, Jackpot lit music from The Addams Family.
  - Funhouse: Rudy says, "Hey, it's only pinball!"  When hit, Rudy says,
    "Gulp... bleaagggh!"  During Multiball, Jackpot lit music from Funhouse.
  - Whirlwind: "Return to your homes."  When hit, "Do not panic."  During
    Multiball, post-Jackpot music from Whirlwind.
  - Earthshaker: "It's sunny drive time!"  When hit, "Ooh, gimme shelter!"
    During Multiball, normal Earthshaker theme music.
  - Banzai Run: "Welcome race fans!"  When hit, "Go for the hill!"  During
    Multiball, normal Banzai Run theme music.

Sometimes you will hear a spurious quote from a previous machine just as Fast
Lock times out.  You may also think that during the static between sound
effects, it sounds like the Power is saying "You suck!"

During Fast Lock Multiball, the Lock Lane is lit for the same value that was
collected at the beginning of the Multiball.  As in all other Multiball
modes, Door Panels, Combos, Spiral Values, the Camera, and other Multiball
modes are unavailable during Fast Lock Multiball.  Strangely enough, however,
the Lock Lane will no longer award Robots during this round.

Fast Lock Multiball ends when you drain at least two of the three balls in
play.  There is no grace period at all for relaunching balls.  However, there
is a brief grace period for collecting one last Fast Lock value.

                          Door Panel: Lite Gumball
                          ------------------------

This Door Panel lights the Gumball Machine on the Right Orbit (these can be
stacked).

This Door Panel can be spotted by lighting the Gumball Machine in the usual
fashion (by spelling GUMBALL), if the appropriate menu adjustment has been
made.

                              Lost In The Zone
                              ================

The last Door Panel is the Handle.  When the Handle is flashing, the Player
Piano and Slot Machine should automatically be lit (although there are some
strange cases on machines that do not automatically relight both at the
beginning of each ball).  The Handle can also be awarded by defeating the
Power during Battle The Power.

The Door Handle awards Lost In The Zone.  This is a slow timed round (total
duration is 45 seconds) during which almost every playfield feature is active
and all six balls are kept in play by the automatic plunger (the Gumball
Machine is emptied at the beginning of the round).  During this round:

  - Clock Millions is running, adding to the current Clock Millions Total.
  - Town Square Madness is running, adding to the current Town Square
    Madness Total.  However, only the Jet Bumpers appear to award the
    current switch value, as typical Town Square Madness values are
    impossibly low.
  - Powerball Mania is running, adding to the current Powerball Mania Total.
    This means that the Powerfield is lit and defeating the Power is worth
    50M.  The Left Ramp relights the Right Ramp to reach the Powerfield.  The
    detection of Mania Jackpots seems to be extremely forgiving during Lost
    In The Zone, and shooting the Camera while a ball is on the Powerfield
    almost guarantees that you will receive credit for a Mania Jackpot.
  - The Greed round is running, with all seven Greed Targets flashing all of
    the time.  This adds to the current Greed Total.
  - Odd Change is always lit at the Player Piano and is always a seven digit
    value.  An Odd Change Total is tracked, with an initial value of 10M.
  - Super Slot is always lit at the Slot Machine.  A Super Slot Total is
    tracked, which has an initial value of 20M.
  - Hitchhikers are worth 2M, but are not remembered after Lost In The Zone
    ends (that is to say, they are not added to your running total).  You
    are given credit for 5 Hitchhikers at the start of LITZ, guaranteeing a
    total of at least 10M.
  - Dead End behaves normally, although the screen indicates that it "is
    lit".  You must still light and relight Dead End as in normal play.
  - The Left Ramp is worth 10M (and Extra Balls can be lit by Robots).

When the round ends, the flippers go dead and your Lost In The Zone Total is
computed:

  - 2M per Hitchhiker collected during LITZ
  - Odd Change Total
  - Super Slot Total
  - Town Square Madness Total (includes total from current ball)
  - Greed Total (includes total from current ball)
  - Clock Millions Total (includes total from current ball)
  - Powerball Mania (includes total from current ball)
  - 10M per Left Ramp collected during this round

All values which are part of the Lost In The Zone Total are reset to zero.
The only values which will remain for your current End-Of-Ball Bonus (other
than the base) are Clock Chaos and Powerfield.

While this total is being computed, the automatic plunger attempts to reload
the Gumball Machine.

With the exception of Fast Lock, rounds that are running at the beginning of
Lost In The Zone continue to run throughout the round.  This is especially
nice in certain cases:

  - Camera: Clock 10 Millions will greatly improve your Clock Millions
    Total, as many balls will be hitting the Clock Target.
  - Door Panel: Spiral will award numerous Spiral Breakthrus at 15M each,
    although these do not count towards the Lost In The Zone Total.
  - Clock Chaos is also handy but does not count towards the Total.

However, rounds which are automatically started as part of Lost In The Zone
do not run twice, so to speak, if they are running when Lost In The Zone is
started.  It is better to maximize the points from that round before starting
Lost In The Zone, as those points will then go towards your Lost In The Zone
Total.

Combos, Spiral Values, the Camera, and of course Door Panels are unavailable
during Lost In The Zone.  Lit Outlanes can be collected, however, as can lit
Extra Balls from the Lock Lane.

The Town Square value is increased normally during Lost In The Zone (to its
usual maximum of 25M), and the unlit Camera will advance a Jet Bumper if the
Jets are not at maximum.

Collecting a Special from the lit Right Outlane during Lost In The Zone will
delay its animation until Lost In The Zone has ended.  Strangely, the
animation will display REPLAY rather than SPECIAL.

                                 Extra Balls
                                 ===========

There are many ways to get Extra Balls in Twilight Zone, and there are some
unusual interactions to be noted.  Almost all Extra Balls are lit at the Lock
Lane, and almost the only way to collect an Extra Ball is to shoot the Lock
Lane.  There are only two exceptions - see "Extra Ball Buy-In" and "Lit
Outlanes".

The most obvious Extra Ball is lit by a Door Panel award.  However,
collecting _any_ Extra Ball will disable this Panel on the current Door,
robbing you of one potential Extra Ball.  This cannot be prevented by any
menu adjustment.  Also, the Slot Machine will not give out the Lite Extra
Ball Door Panel unless it has no choice (which is an unlikely situation, to
say the least).

An Extra Ball is lit by Robots; typically between 6 and 14 Robots are
required (this value reflexes).  Another Extra Ball is lit at 45 Robots.

All other Extra Balls are temporary; that is, if they are not collected on
the current ball, they will no longer be lit.  This also applies with the
Extra Ball Buy-In; any temporary Extra Balls that are lit will disappear when
you use the Buy-In.

The sixth Spiral Value lights an Extra Ball.  This can only be achieved once
per ball, and the Spiral Value is fully reset to the first award at the
beginning of every ball after lighting the Extra Ball in this fashion.

The left Outlane awards an Extra Ball when lit.  See "Lit Outlanes".

A temporary Extra Ball is lit at a certain number of Dead Ends, typically 3,
but menu adjustable between 2 and 7, inclusive.

The Yellow award of the Super Skill Shot lights a temporary Extra Ball.
This is the only temporary Extra Ball which cannot be made permanent by any
menu adjustments.

There is normally a limit on the number of Extra Balls you can collect at
any one time.  When you have reached this limit, no more Extra Balls will be
lit; instead, they are simply skipped.  This is particularly rude when you
consider that most such Extra Balls cannot then be lit at some later time.
The normal limit is to allow no more than four Extra Balls to be collected at
any one time.  If you do manage to light Extra Balls such that you can
collect more than four at once, you will still only have four Extra Balls,
although the only way to verify this is by examining the Status Report (that
is, the animations proceed normally).

If you have the maximum number of Extra Balls stacked when you complete Lost
In The Zone, the Lite Extra Ball Door Panel will be lit and therefore
unavailable on the new Door.  If you have the maximum number of Extra Balls
stacked when you hit the Super Skill Shot, the Yellow award will be only 10M.
Lighting Outlanes when you have the maximum number of Extra Balls stacked
will only light the right Outlane (on the default "hard" settings, this means
it is lit only for every second slingshot hit).

During Multiball modes, including Lost In The Zone, lighting an Extra Ball
while a ball is being briefly held in the Lock Lane will award the Extra Ball
immediately.  Collecting an Extra Ball during Lost In The Zone does not
necessarily (but see above) spot the Lite Extra Ball Door Panel on the next
Door.

                                 Combo Shots
                                 ===========

Most of this information comes from Bowen Kerins and other netters, as I
have personally made limited use of Combo Shots in Twilight Zone.  There are
plenty of these shots, however.

The only 2-way Combo is the Gum-Ball Combo, which is Left Ramp followed by
Right Ramp, when neither GUM nor BALL has been spelled for the next Lock.
This is worth 5M and if Battle The Power is not lit, you can proceed to
3-way or 4-way Combos.  It is possible (but extremely rare) to collect this
Combo by shooting both ramps just as a Multiball mode ends, and find that
only BALL has been spelled.  This is very strange, of course.

These are the 3-way Combos, each worth 10M:

  - Left Ramp -> Right Ramp -> Player Piano (regardless of GUMBALL)
  - Left Ramp -> Lock Lane (unlit) -> Camera
  - Left Ramp -> Lock Lane (unlit) -> Hitchhiker Lane

These are the 4-way Combos, each worth 20M:

  - Left Ramp -> Right Ramp -> Hidden Lane -> Camera
  - Left Ramp -> Right Ramp -> Hidden Lane -> Hitchhiker Lane
  - Left Ramp -> Right Spiral (without Spiral Helpers) -> Hidden Lane ->
      Hitchhiker Lane
  - Left Ramp -> Right Spiral (without Spiral Helpers) -> Hidden Lane ->
      Camera

These Combos do not actually exist, but have been listed here previously in
error:

  - Right Ramp -> Hidden Lane -> Camera
  - Right Ramp -> Hidden Lane -> Hitchhiker Lane
  - Left Ramp -> Right Spiral (with right Spiral Helper) -> Camera
  - Left Ramp -> Right Spiral (with right Spiral Helper) -> Hitchhiker Lane

Note that in non-prototype machines, there is no opto sensor in the Hidden
Lane (and even when present, such a sensor is ignored by newer software);
Combos which involve the Hidden Lane can actually be scored without passing
through it, usually through a very strange bounce.  However, a certain delay
seems to be necessary in order to receive credit.  Also, Combos are sometimes
mysteriously not awarded, for no apparent reason.  For the most part, hitting
miscellaneous targets while completing a Combo does not interfere with
collecting that Combo.

Combo Shots are unavailable during all Multiball modes.  However, they are
available during the 15 second Multiball restart (except the Gumball Combo,
of course).

Collecting a Replay while the ball is sitting in the Bridge Diverter will
prevent you from completing any Combos you were working on.

                              Bonus Multiplier
                              ================

The Bonus Multiplier is increased by the Left Ramp when briefly lit by the
Right Inlane.  It progresses to 2X, 3X, 4X, and a maximum of 5X.  This is
available at all times.  The Bonus Multiplier is never held over between
balls.

Whenever the Bonus Multiplier is increased, the Left Ramp also awards two
Robots rather than one (unless, of course, you have reached Super Robots).
After reaching 5X, the Left Ramp will only award one Robot.

                              End-of-Ball Bonus
                              =================

End-of-Ball Bonus is the sum of many different things.  Some of these
subtotals are also part of the Lost In The Zone total, which resets such
subtotals to zero.  Your entire current End-of-Ball Bonus is awarded (but not
reset) by the Camera: Collect Bonus award.

The base upon which End-of-Ball Bonus is built is:

  - ((500K * Hitchhikers) + (500K * Door Panels)) * Bonus Multiplier

The subtotals from all appropriate rounds are then added to this base.  A
grand total of 100M or more earns a quote from Rod: "Big risk, big reward...
in the Twilight Zone".  You can speed up the Bonus countdown by holding both
flippers; doing so will also eliminate the quote.

Other elements of the End-of-Ball Bonus are:

  - Town Square Madness
  - Clock Millions (includes Camera: Clock 10 Millions)
  - Clock Chaos
  - Greed
  - Powerfield (normal Battle The Power play)
  - Powerball Mania

See also "Easter Eggs".

                                Ball Savers
                                ===========

By default, there is no ball saver during the course of a normal game of
Twilight Zone.  A ten second ball saver is enabled after the Extra Ball
Buy-In, and a ball saver can be operator selected for up to fifteen seconds,
but only on the first ball of the game!  Both of these ball savers have
timers which run regardless of other activity, once the ball has been put
into play.  This is most unfortunate.

There is at least one ball saver as compensation for what the software
believes to be failed hardware.  If a successful Skill Shot is made (this
includes the Super Skill Shot) and the ball does not land properly in the
Rocket Kicker and drains shortly thereafter, the ball will be autoplunged.
This can be relied upon if you're being tricky.

Normally, a ball which is kicked out of the Slot Machine and drains without
hitting anything is considered a true drain.  However, very rarely, the ball
will quietly be returned to the manual plunger lane, even though points have
been scored.  I have also seen this happen at the end of Powerball Mania, for
no apparent reason.

                          Tips, Tricks, Strategies
                          ========================

My tips, tricks, and strategies are presented in an order that roughly
corresponds to the order of analogous sections in the rest of the Rules
Sheet.  Think of this section as wholesale undiluted opinion and advice
that builds upon the mechanics and semantics described in other sections.

In my opinion, the foundation of Twilight Zone is its ramps, particularly the
Left Ramp.  The ramps are used to spell GUMBALL to light Locks and the
Gumball Machine, to light Extra Balls and the Camera, and to relight the
Player Piano and Slot Machine.  They are also used to active special features
such as Battle The Power and the Super Skill Shot.  Therefore, the second
most important shots to master in Twilight Zone are the two ramps, either of
which you should be able to hit from either lower flipper.

However, the _most_ important "shot" to master is gaining control of a ball
coming from the Slot Machine kickout.  Unfortunately, this kickout is
generally very inconsistent from machine to machine and, in fact, from minute
to minute.  Your options include a drop catch, holding the right flipper up
(which may also lead to a perfect bounce for a catch on the left on some
machines), or just letting the ball bounce over.  A particularly tricky
option is to attempt to live catch the ball.  If the kickout is reasonable
and reliable, I prefer to simply attack the ejected ball, shooting for either
ramp or the Left Orbit, whichever is appropriate at the time.

The most disagreeable shot is certainly the Lock Lane, because of its narrow
sweet spot and its tendency to bounce back out towards the center drain even
when hit fair and square.  Shooting the Slot Machine is tricky for similar
reasons.  Most other shots in the game are, to varying degrees, easily
mastered.

My first bit of advice for playing Twilight Zone is that in most cases the
Skill Shot should be avoided.  The payoff is relatively slim, and because the
ball is automatically delivered into the Jet Bumpers afterwards, there is a
significant risk of a quick left drain.  In fact, Pat Lawlor has been known
to describe this design as "not one of my shining moments as a designer".
If a ball saver is active, it is quite reasonable to go for the Skill Shot.
In particular, collecting the Yellow Award has the benefit of spotting the
10M Door Panel.  Also, it is important to master the manual plunger in order
to reap the benefits of the Super Skill Shot.

One trick which is helpful with the Skill Shot and especially the Super Skill
Shot (because if you have collected the Super Yellow Award, it is essential
to collect the lit Extra Ball as soon as possible) is shaking the ball out of
the Rocket Kicker.  If a nudge is given as the ball first lands in the
Kicker, a good bounce and a few additional nudges will encourage the ball to
fall out of the Kicker and come to the lower right flipper.  This can be done
even with fairly sensitive Tilt on the machine.  Doing this after a Skill
Shot has the added advantage of enabling a "secret" ball saver.  In fact, you
may want to purposely let the ball drain in order to have it autoplunged.

You can generally ignore the unlit Clock Target unless you see that all or
nearly all of the Greed Targets are lit and you just can't resist going for
the 10M Clock Bonus.  Note that the 10M Clock Bonus is also lit for free when
you collect Camera: Lite Greed Targets or use the Extra Ball Buy-In.

I generally ignore the Town Square value.  In the course of a good ball, it
will reach a high enough value to make Dead Ends and the Camera: 3X Town
Square award attractive, but it is too dangerous to shoot for Town Square
specifically.  The best exception to this is various Multiball modes,
particularly Fast Lock.  During these modes, it is slightly less dangerous to
put the ball in the Jet Bumpers, simply because one quick drain won't
necessarily end the current ball.

Dead Ends are a lot of fun to shoot for, or at least some people think so.
The Dead End can become a very important shot towards the end of a very long
game, when Extra Balls are becoming very scarce.  Lost In The Zone can also
be a very good time to pick up Dead Ends, because it is always lit.  Note
that if you are playing on a fairly shallow but fast machine, the Jet Bumpers
will tend to knock the ball up into the Dead End sinkhole automatically,
which is very pleasant, as it also provides a safe exit from the Jet Bumpers.
Actually, the Jet Bumpers can also knock the ball around the Dead End
sinkhole and backwards down the Hitchhiker Lane!

The Dead End Bonus of 100M isn't necessarily worthwhile in terms of points,
unless you find yourself very close to it, but it's awfully cool and worth
seeing at least once if you get the chance.

The first Extra Ball lit by Robots reflexes (I've never seen it higher than
14, but this proves nothing).  A high value for this can actually be a good
thing, as it provides more time for you to try to collect the Lite Extra Ball
Door Panel before collecting (or better yet, lighting) any other Extra Balls.
Of course, it also makes it harder to collect any Extra Ball other than the
one from the Door - that's the entire idea of reflexing, after all.

I do not feel that Super Robots are especially worthwhile.  The 5M award was
noteworthy on The Addams Family (for Super Bear Bonus, which is clearly the
origin of Super Robots), but not really in line with the scoring on Twilight
Zone.  But the real problem is that once you have reached Super Robots, the
only way to light the Camera is the Door Panel, which will usually only be
collected a very few times during the course of the game.  In a long game,
the Camera will eventually become unavailable and gameplay is at least
slightly weakened as a result.

With a few exceptions, I try to collect all lit Camera awards as soon as
possible.  If the award is fairly uninteresting (20M, Hold Town Square, 3X
Town Square, for example), collect it in order to get it out of the way and
see what the next award is.  You may want to hold off a bit on the other
awards, however.  Lite Greed Targets is sometimes almost completely unhelpful
(for example, most or all of the Targets are already lit).  Clock 10 Millions
is best when used in conjunction with Door Panel Clock Millions or any
Multiball mode.  10 Hitchhikers will light Battle The Power; if it is
currently unlit and you have a useful Door Panel lit at the Player Piano, you
may prefer to have the clean shot from the upper left flipper instead of
having to defeat the Power.  Lite Outlanes is best for Multiball modes; in
fact, lit Outlanes are sometimes the best reason for starting Multiball
modes, especially Fast Lock.

And last and most notably, the Collect Bonus award from the Camera should not
be wasted.  Your End-Of-Ball Bonus can be well into the hundreds of millions.
Battling the Power a few times or having a good Powerball Mania or a few more
Door Panels or even a better Bonus Multiplier will provide double rewards
when you use the Collect Bonus award, and there's nothing as disappointing as
picking up the Collect Bonus award at the beginning of a ball.

Hitchhikers are generally dangerous to shoot for, just because the Jet
Bumpers are dangerous.  The best time to pick up Hitchhikers is during
Multiball modes, especially Fast Lock.  Triple Pickups are the most efficient
way to pick up Hitchhikers, of course.  On many machines, a Triple Pickup can
be automatically collected by simply holding the upper right flipper up after
a fast Left Orbit shot.  Be careful, though - if this misses, you may find
the ball in the Right Outlane.  Whether or not this works is almost entirely
dependent on the speed of the table, and to a lesser degree to its angle of
steepness.

I highly recommend trying to pick up 100 Hitchhikers, just to say you've done
it.  Collecting the Hitchhiker Door Panel with 100 Hitchhikers is
particularly thrilling.

There are many strategies for battling the Power.  The most important thing
is to get the hang of flipping for just long enough to maximize the effect on
the ball.  Flipping too briefly will not impart enough velocity, while
flipping for too long will slow the ball down on its path away from the
magnet.  The best way to practice this is to battle gently - flipping once
and watching where the ball goes, then flipping again, and so on.  You may
wish to adopt this "gentle" style for real battling, but its disadvantage is
that it does not build a very large Powerfield value at all.

Another strategy is to flip repeatedly with the Magna-Flip(TM) that the ball
is nearest, bouncing the ball off of the two nearest walls many times until
it is eventually thrown free, hopefully finding its way to the upper exit.
This is not quite as haphazard as it sounds, once you learn when to recognize
an escaping ball and stop flipping to give it a chance, and once you find the
right frequency at which to flip.  This correct frequency varies according to
machine, Powerfield angle, and the speed (cleanliness) of the Powerfield
surface.  It seems to me that a faster surface requires a _slower_ frequency,
although I am at a loss to convincingly explain why.  It does certainly seem,
however, that the worst thing to do when you're having trouble with the
Powerfield is to flip as quickly as possible.  And you should never use both
flippers at once!  Also, a small nudge with one solid shot will encourage the
ball towards the upper exit quite reliably.  You can, of course, Tilt while
the ball is on the Powerfield, though, so be careful.

One useful trick for battling the Power, which is dependent on how quickly
the ball is moving when it enters the Powerfield more than anything else, is
to flip once with the right Magna-Flip(TM) as the ball enters the Powerfield
and drops past the right magnet.  With the appropriate timing, this can quite
often throw the ball directly through the upper exit.

Often when the ball goes through the upper exit of the Powerfield quickly, it
will roll up the Gumball exit lane and trip the Gumball Geneva switch.  This
is harmless, as the software wisely ignores it.

Over the course of the game, you can stack an amazing number of lit Gumball
Machine shots if you concentrate on starting Multiball.  Be sure to cash in
on these shots at some point before the game ends.  At 25M each, this can add
up nicely, and it's relatively easy points.  This is particularly tempting if
the Powerball is in the trough.  In fact, if you can safely let the ball from
the Slot Machine kickout bounce over to the left flipper for a quick shot at
the Right Orbit, every second load of the Gumball Machine will also collect a
Spiral Value.

Don't forget that you can also make good use of these lit Gumball Machine
shots when you want a Powerball Mania - for example, to run up your Bonus
before starting Lost In The Zone, in order to get a better total, or to get
better use of the Collect Bonus award from the Camera.

In my opinion, there is usually only one reasonable thing to do with the
Powerball, and that's to get rid of it as soon as possible.  If you're lucky,
you can let the Powerball bounce over after the Slot Machine kickout and
you'll get a nice easy shot at the Right Orbit from the lower left flipper.
Otherwise, you'll have to make a trap or running shot from the lower right
flipper (preferably at the Left Ramp) in order to get the Powerball to the
lower left flipper.

I avoid doing anything else with the Powerball because, on most machines, it
is quite uncooperative, especially in the Bridge Diverter and the Lock Lane.
There are also problems arising from airballs, the worst of which send the
ball from the upper playfield directly to the Left Outlane, below the sensor.

The only other reasonable thing to do with the Powerball would be to lock it
(if the Powerball has any chance of staying in the Lock Lane on your machine;
it may be too fast to avoid bouncing out) or shoot the Left Ramp to start
Multiball.  This is only useful because collecting a Multiball Jackpot with
the Powerball doubles its value.  Otherwise, the Powerball is still difficult
to control and of course immune to the Spiral Helper magnets.

Some have suggested that when you have the Powerball on the table, you can
just shoot for Powerball Loops instead of starting Powerball Mania.  Needless
to say, I don't recommend this.  In fact, I recommend ignoring Powerball
Loops except for one case - if you have the Powerball on the lower left
flipper during Multiball with the Jackpot lit, a Right Orbit shot isn't a bad
idea at all.

Powerball Mania can be quite lucrative with a little luck and a reasonable
amount of skill.  The most important thing is being able to shoot the Right
Ramp from either lower flipper at almost any time.  Keep as many balls on the
Powerfield as possible, and never try to hold other balls on the flippers
while you are trying to use Magna-Flip(TM).

Your strategy for defeating the Power during Powerball Mania should be the
same as during a normal battle, except that Magna-Flip(TM) will be at least
slightly weaker and this makes the battle more difficult (but hopefully not
impossible).  The only other thing to watch out for, other than keeping the
other balls in play of course, is the opportunity to collect a "cheat" Mania
Jackpot.  This is done by shooting the Camera during a few seconds after a
ball on the Powerfield has tripped the opto by the upper exit.  Such a
"cheat" Mania Jackpot can be collected even after all balls have drained from
the Powerfield.  This trick also works with the Dead End sinkhole.  The
strangest case of all is when you fail to defeat the Power, but the Jet
Bumpers immediately knock the ball into the Dead End sinkhole and you are
given the Mania Jackpot!

I always try to lock two balls for the first Multiball.  It makes quite a
difference in the Jackpot values you will be collecting, especially if you
only get a couple of Jackpots.  But of course it's better to go ahead and
have a Multiball with low-value Jackpots than to drain while trying to lock
the second ball, so use your best judgment.

Multiball is a lot of fun on Twilight Zone.  Obviously you want to pick up as
many Jackpots as possible, as quickly as possible.  This is actually easier
with only two balls in play, and as there is no real penalty for losing just
one ball, don't try too desperately to keep all three in play.

If any balls are being autoplunged at the start of Multiball, it's a very
good thing to collect the first Jackpot from one of those balls.  Since the
Spiral Helper magnets will be disabled for the autoplunge, you'll have to get
the hang of a running shot at the Player Piano from the upper left flipper.
The most common problem with this shot is flipping too late.

If all of the balls are coming from the Lock or the autoplunge is not making
it all the way around, you can either shoot the balls into the Camera (they
should then be ejected from the Slot Machine kickout one at a time), go for
the Hitchhiker Lane, or attempt a bounce shot into the Player Piano.  Such a
bounce shot has the advantage that the next ball from the Lock can be put
into the Camera to relight the Jackpot immediately.

The easiest way to relight the Jackpot is to shoot the Right Orbit for the
Right Spiral Helper to line up a shot at the Camera.  Shots at the Left Orbit
or the Lock Lane are not unreasonable but are usually trickier.  You can also
backhand the Right Orbit from the lower right flipper, or even from the upper
right flipper.

When the Jackpot is lit and balls are being ejected from the Slot Machine
(hopefully one at a time), you have three options for going after the
Jackpot.  One is a quick shot at the Left Orbit, where the ball will be
caught and the other kickouts delayed to allow a brief but clean shot at the
Jackpot.  You can also shoot for the Right Ramp with similar consequences.  I
happen to prefer the Left Orbit shot, although it's a bit tricky.  Your third
option is any of a number of trick shots, bouncing the ball off of posts or
Greed Targets or the Clock Target and into the Player Piano.

You can also, of course, shoot balls up the Left Ramp, which may be easier
and more reliable.  From the lower left flipper, you can shoot the Right
Ramp, the Right Orbit, or go for a bounce shot into the Player Piano.

If the Spiral Round is running, you cannot rely on the Spiral Helper magnets.
To safely reach the Camera, use the Lock Lane.  To safely shoot the Jackpot,
use the Right Ramp.

In general, there are many options in Multiball, even though it is a
relatively simple mode.  I generally ignore the Greed Targets, as they are
hit often enough by wandering balls (and tend to be quick drain shots
besides).  The only possible exception is the Greed Target directly above the
Player Piano - you can hit this on your way into the Player Piano when
collecting the Jackpot.

You can shoot the lit Jackpot and the Camera at the same time, such that the
Jackpot is awarded but its red light never even flickers off.

Sometimes, if you shoot a ball into the Slot Machine right after shooting the
Jackpot, the machine will decide that you used the Powerball and will double
the Jackpot value accordingly, even though the Powerball is not even on the
table.

Don't forget the grace period at the end of Multiball.  There is no better
time to go for a wild bounce shot into the Player Piano if the Jackpot was
lit.  Also, if you see the other ball(s) draining and the Jackpot is lit,
shoot for the Right Ramp immediately if at all possible.

Keep an eye on the Spiral Values.  Usually, if you haven't yet collected an
Extra Ball from the Spiral Values, you should shoot for any lit Orbits that
present themselves, especially the Right Orbit.  After the Spiral Values have
reset, however, it's difficult to get interested in trying to collect all six
of them in the course of one ball, although it's by no means impossible.

Learn most of the cases for Spiral Helper behavior so that you'll never be
caught by surprise.  Unfortunately, there are some cases that are completely
inexplicable.  For example, I have found one or both Spiral Helper magnets
fully active throughout a Powerball Mania or Fast Lock mode, for no reason at
all.  When this happens (it is thankfully rare), you cannot help but be
surprised.

When the Outlanes are lit (assuming they are on the default "hard" settings),
I prefer to keep the left Outlane lit whenever possible.  Also, when the left
Outlane is indeed lit, shots to the Hitchhiker Lane are much safer, as is the
Skill Shot.

If you can do Bang Backs and/or Death Saves, you may want to go ahead and
pick up lit Outlanes as soon as possible (fearing a center drain).
Otherwise, the best thing to do is start a Multiball mode.  This is the best
use of Fast Lock, for example.  The best case is Powerball Mania, during
which you can quickly side drain a couple of balls and actually get them back
at no penalty whatsoever.

The most reliable way to collect Door Panels, in my opinion, is by shooting
the Player Piano from the upper left flipper.  Mastery of this shot is
extremely helpful for progressing towards Lost In The Zone and for
controlling the flow of your game in general.  If you are having trouble with
this shot, try leaning over the machine and watching the ball very carefully.
The ball should travel along the bright yellow path drawn from the upper left
flipper into the Player Piano.  Remember, if the ball is going above the
Player Piano, you're flipping too early, and if it is going below, you're
flipping too late.  Simply adjust your timing accordingly.  Also, the timing
is dependent on the speed of the ball.  This is obvious for autoplunged balls
such as you will encounter in Multiball, but the trickier case is a ball
which rolls up in front of the upper left flipper and is moving more slowly
than normal.

If the Player Piano switch is flaky on your machine, you can sometimes
receive credit for shooting the Slot Machine by hitting the Player Piano.
The disadvantages of this are obvious, but it can sometimes be helpful - if,
for example, the Player Piano is currently unlit.

The Slot Machine may be a relatively easy shot on your machine, or more
likely it's quite tricky.  You'll fare better if you aim very slightly to the
right of the scoop, where the post can help guide the ball in.  On the left
side, the narrow Greed Target is less helpful, and, as it is slowly bent
backwards by repeated attacks from fast moving balls, it tends to form a
small ramp that encourages airballs from missed Slot Machine shots.

Don't forget that defeating the Power awards Door Panels as well, and if you
battle the Power when something especially attractive is lit on the Door,
such as Lite Extra Ball, there's the added pressure that failing to defeat
the Power will drop the ball into the Jet Bumpers, changing the lit value to
something less attractive.

You can ignore Odd Change.  However, don't forget that you can also shoot for
the Greed Target or the Power Payoff targets right next to the Player Piano
if it is unlit.

Town Square Madness never seems to pay off like it should, especially when
you consider that it's dangerous to shoot for the Jet Bumpers to increase the
switch value.  The best Town Square Madness Totals I've seen (70M or so) have
come during Multiball modes.

If you have a good opportunity, try to pick up the Lite Extra Ball Door Panel
before you collect any Extra Balls.  In particular, if you start the game
with Town Square Madness as your flashing Door Panel, collect it, relight the
Player Piano, and collect that as quickly as possible.  Note that the Lite
Extra Ball Door Panel comes immediately after the Town Square Madness Door
Panel, tempting you to shoot for the Jet Bumpers for a better Town Square
Madness, thereby unselecting the Lite Extra Ball Door Panel.  This is exactly
the same reasoning behind the layout of The Addams Family Mansion, in which
Raise The Dead is followed immediately by Light Extra Ball.

If you want to do anything with Super Slot, try to get in a rhythm of
shooting the Left Ramp followed by the Slot Machine and repeating.  This will
collect Door Panels along with Super Slot values.

When Clock Millions starts, try to hit the Clock Target once right away,
unless you have something more interesting to shoot for (such as Multiball on
the Left Ramp).  If you don't hit the Clock Target during the brief initial
period for 12M, it's not a worthwhile shot for a while.  Ignore it until it's
worth more; a 3M shot at the Clock isn't worth losing control of the ball.

I have become very fond of the Spiral round, although I cannot really explain
why.  I particularly enjoy having a Multiball mode in conjunction with the
Spiral round, and I try to collect as many Spiral Breakthrus as possible.
These are quick and relatively easy points, especially since they are awarded
for shots that you might be making normally, such as the Right Orbit for the
lit Gumball Machine.

One particularly useful trick is to start the Spiral round right before Lost
In The Zone.  Almost every autoplunged ball will count as a Spiral Breakthru
for an immediate 15M!

Note that the 10M Door Panel comes immediately after the Battle The Power
Door Panel, such that proceeding to defeat the Power immediately will only
net you 10M.

I usually ignore the Greed round, much as I ignore the Greed Targets during
Multiball.  Ball action will generally collect a few Targets for you with no
additional effort.  It's not too unreasonable to shoot at a few Targets in
the upper half of the playfield, though, if you get the chance.  Also, having
Greed running during Multiball will make the Greed Targets even more
attractive than usual.

Don't worry about collecting the Hitchhiker Door Panel even when you have few
Hitchhikers.  It takes a while to build up a significant number of
Hitchhikers, and any you collect on the current ball will still be worth the
2M bonus after you collect this Door Panel.  Of course, if you're towards the
end of a long game and have quite a few Hitchhikers, this Door Panel is very
tempting - go for it!

Clock Chaos is another of my favorite rounds in Twilight Zone.  Since the
Clock first winds in reverse, it's best to shoot for the Clock Target as soon
as possible.  Early in this round, you'll want to hit the Clock Target while
it's on the later (ie, more valuable) times, but eventually you'll have very
little time in either direction, so you'll want to hit the Clock Target while
the Clock is close to finishing on the side it's headed towards.  In any
case, don't forget about the grace period - not only does it provide you with
12M, it restarts the round!

One other useful thing to remember about Clock Chaos is that the Clock pauses
while certain things are happening, such as collecting a Jackpot during
Multiball.  During this time, you can pick up several Clock Target values
safely.  Of course, you should try to remember which way the Clock will
resume winding after you score these "free" hits.

The Super Skill Shot can be quite frustrating.  You can hardly avoid having
to eventually use it once it's lit - only Multiball modes prevent the Left
Ramp from diverting the ball for the Super Skill Shot, and therefore that is
your only chance to relight the Player Piano before using it.

If Outlanes are set to "easy" on your machine, the Orange award from the
Super Skill Shot is likely your best choice, especially if you can perform
Death Saves or Bang Backs.  Otherwise, try for the Yellow award.  The problem
is that the ball will be automatically delivered into the Jet Bumpers for any
of the three awards, and you may never even get a shot at the temporarily lit
Extra Ball.  This can be avoided by nudging the ball out of the Rocket Kicker
immediately after the Skill Shot.  This is most easily done with a good nudge
as the ball first lands there, followed by several back-and-forth nudges to
rattle the ball out.  With practice, this can be done even on fairly Tilt
sensitive machines, and is often quite worthwhile, as it also enables a
brief, "invisible" ball saver.

If you choose not to shoot for the big awards from the Super Skill Shot (for
example, you have already stacked the maximum number of Extra Balls), you can
still safely collect the Red award by plunging the ball just hard enough to
reach under the gate, trip the Red rollover sensor, and fall back to the
plunger, from where you can plunge into the scoop.

I do not feel that Fast Lock is worth shooting for in and of itself, as it
delays progress towards other Multiball modes and Lost In The Zone, and
because of the generally difficult nature of the Lock Lane, it is hard to
make this Multiball pay off.  However, Fast Lock is a perfect opportunity for
collecting lit Outlanes or maximizing the payoff from Door Panel awards such
as the Spiral Round, Town Square Madness, and various Clock rounds.  You can
also collect Hitchhikers "safely" during Fast Lock, although I try to avoid
having all of the balls in the Jet Bumpers at any one time.

Lost In The Zone is a thrilling and almost overwhelming round, especially the
first time you get to it.  There are several strategies for maximizing the
points collected during Lost In The Zone, but the single best strategy for
having a high Lost In The Zone total is very simple - maximize your Bonus
_before_ you start Lost In The Zone.  The easiest way to do this is to have a
good Powerball Mania or two on the same ball first.  Even Clock Millions or
Town Square Madness can be very helpful.  Regardless of how well you play
during the actual Lost In The Zone round, the Lost In The Zone Champion will
almost always be held by someone who had at least 200M in Powerball Mania
when they started Lost In The Zone.

During Lost In The Zone, I like to shoot for the Right Ramp early.  This
gives you a good chance at one or more "cheat" Mania Jackpots from shooting
the Camera, along with the credit towards your Powerball Mania total for each
wall hit, and the usual chance of a real Mania Jackpot.  Towards the end of
the round, the Clock Target becomes quite valuable.  At all times, the three
Greed Targets in the lower left corner of the playfield are worthwhile shots,
as they are very quick and if you miss, the ball will likely go into the Jet
Bumpers to increase your Town Square Madness Total.

I recommend mostly ignoring everything else during Lost In The Zone.  Balls
wandering around and being hit by the upper flippers (unless the Low Line
option is set) will pick up a reasonable amount of everything else with no
attention or effort on your part.

If you start a game with Town Square Madness lit, I recommend shooting for
the Lite Extra Ball Door Panel as soon as possible.  Otherwise, don't worry
about it too much unless it happens to come up.  My worst games have been
those where I worried too much about collecting this Door Panel and failed to
do anything else useful at all.  My only other advice about Extra Balls is
that you become familiar with the various ways of lighting them, and always
keep an eye on how many you have (on default settings, having four at a time
prevents lighting or collecting any more).

Most of the Combo Shots in Twilight Zone can safely be ignored.  You will
most likely run into the Gumball Combo and the ensuing 3-way Combo (to the
Player Piano) most often.  If the Player Piano is not lit, you may wish to
shoot for the 4-way Combo by aiming for the Hidden Lane.  After a fast Right
Orbit shot, you may be able to put the ball through the Hidden Lane by simply
holding the upper left flipper up.

Bonus Multiplier becomes very valuable later in a long game, if, for example,
you have 50 Hitchhikers and 30 Door Panels, in which case the Bonus
Multiplier is worth 40M.

Don't forget the Flipper Bonus.  Everything counts.

                           Miscellaneous Scoring
                           =====================

These are some of the miscellaneous scoring values in Twilight Zone:

  - Any kickout from the Slot Machine = 100K
  - Spiral Helper opto sensors = 50K
  - Inlanes = 100K
  - Outlanes = 250K
  - Right Ramp = 500K
  - Left Ramp = 250K for gate, 250K for completion
  - Lock Lane = 250K
  - Unlit Camera = 500K
  - Unlit Greed = 500K
  - Unlit Power Payoff = 250K
  - Rocket Kicker = 100K
  - Slingshots = 2570

                                Trick Shots
                                ===========

There are plenty of trick shots in Twilight Zone, and some of them are even
reproducible.  Examples include:

  - From either lower flipper into the Player Piano, bounced off of any post
    in the upper playfield area.  The most reliable case is a shot from the
    lower left flipper to the post to the right of the Right Ramp.
  - From the upper left flipper into the Camera, bounced off of the Greed
    Targets alongside the Slot Machine.
  - From the upper right flipper into the Player Piano, bounced off of the
    lowered upper left flipper.
  - From the upper right flipper up the Left Ramp, flipped off of the upper
    left flipper.
  - From the upper right flipper backhanded up the Right Orbit.  This is
    especially good when starting Powerball Mania.
  - From the upper left flipper into the Lock Lane, bounced off of the post
    below the Player Piano.  This only seems to happen by accident.
  - From the lower right flipper into the Lock Lane, bounced off of the Greed
    Target that faces the upper right flipper.
  - From the upper right flipper into the Slot Machine.  This requires a
    moving ball, of course.

There are plenty more, but some of them are too unusual to be described or
even believed.

                                  Cheats
                                  ======

There are a few techniques that can be used when Twilight Zone that might be
considered cheats.  All such cheats that I know of are described in this
section.

As has already been described elsewhere, you can collect "cheat" Mania
Jackpots during Powerball Mania and Lost In The Zone by shooting the Camera
shortly after tripping the upper exit opto on the Powerfield.  This is
probably the most reliable and helpful of the cheats listed here.

If the Extra Ball Buy-In is enabled on your machine, you can use it in a
multi-player game as a cheat.  When the Buy-In is offered to Player One, wait
for the ball to be delivered to the plunger lane (this happens long before
the Buy-In expires).  Plunge the ball while the Buy-In is still being offered
and, before the ball reaches the gate in the plunger lane, press Start or
flip both flippers to abort the Buy-In.  The software will not notice that
you tripped the Skill Shot Rollovers.  Instead, it will see the ball in the
Slot Machine and award a random Door Panel as if you had hit the Slot Machine
fairly.  This will not work, of course, if your machine does not relight the
Slot Machine automatically and it was previously unlit.  This trick works
even on L-4 ROMs.

I have been told that if there is at least one ball sitting in the Lock Lane
and you have an Extra Ball lit, you can pick the machine up and trip the Lock
Lane sensor with that ball to collect the Extra Ball.  Supposedly, this will
work even when the machine has Tilted or when the Extra Ball Buy-In is being
offered, but I have not verified this.  I have, however, had the machine
mysteriously award the lit Extra Ball after a Death Save - this is likely the
same effect.

When Lost In The Zone starts, any balls in the Lock Lane are ejected, of
course.  However, these balls are ejected early in the opening animation,
before other balls are put into play.  If you are careful, you can get this
ball up the Right Ramp right away, and if you trip the upper exit opto, the
balls coming out of the Gumball Machine will be counted as Mania Jackpots!

                         Death Saves and Bang Backs
                         ==========================

Death Saves are possible from the right drain on Twilight Zone, and are only
moderately difficult.  However, due to the distance from the trough to the
flippers, it is difficult (but not impossible) to get a Death Save on a
machine with sensitive Tilt.

Bang Backs are extremely easy on most Twilight Zone machines, from either
side drain.  The left drain requires a harder hit because the lower lane is
much wider than on the right side.  I think that Twilight Zone is definitely
the best machine on which to learn how to do Bang Backs.

For more information on Death Saves and Bang Backs in general, check these
files in the Archive:

  - Info/bangbacks
  - Info/playingtips
  - Misc/deathsave.gif
  - Misc/deathsave.ps

                              Tournament Mode
                              ===============

In Tournament Mode, Camera awards are parallelized; this means that the 
same award is offered to each player even after another player has collected 
it, although Camera awards are still selected in the usual restricted but
random fashion.

When Extra Balls are disabled (as is common in tournament play), the Lite
Extra Ball Door Panel is automatically lit.

At the beginning of the game, Clock Millions is the currently flashing Door
Panel, and the Slot Machine will always award the next available Door Panel
starting with Lite Gumball and proceeding counter-clockwise (that is to say,
the Slot Machine is no longer random).

Another reasonable modification for tournament play is to remove one ball
from the machine, such that only two balls reside in the Gumball Machine.
This makes it easier to get a fair chance at playing the Powerball.  Even
better is to remove the Powerball and have it simulated by software (use the
menu adjustment to indicate that no Powerball is present), although this
arguably detracts from the game a bit.

                             Extra Ball Buy-In
                             =================

This option, enabled by default, allows the player to purchase an Extra Ball
for one credit.  The game proceeds as if an Extra Ball had been collected in
some other fashion.  Temporary Extra Balls become unlit.  There is normally a
ten-second ball saver for the purchased Extra Ball.  Also, all seven Greed
Targets are automatically lit, just as if the Camera: Lite Greed Targets
award had been collected.  And of course there's a quote: "Greeeeeeed".

The Buy-In is especially useful when you're very close to some useful goal,
such as Lost In The Zone, one or more Extra Balls, or the Grand Champion
score.  I would never recommend using real money to purchase the Extra Ball;
you should instead be able to use a credit from a Replay or a Special.

                                Easter Eggs
                                ===========

This section includes semi-secret information, not all of which is really an
Easter Egg.

In the first Extra Ball animation, the Extra Ball blows up.  In the second,
it grows legs and a hat and walks away.  In the third, it turns into a
deflating balloon which lands on Talking Tina's face.  All subsequent Extra
Ball animations are the same as the first.

Once per ball and only during normal play, hitting the unlit Clock Target
when all seven Greed Targets are already lit will award a Clock Bonus of 10M,
with a nifty sound effect and animation.

Scoring at least six hits on the Clock Target during a Clock Chaos round
gets a special quote from Rudy of Funhouse fame: "Quit playin' with the
clock!"  This also adds 25M to the Clock Chaos Total.

After the 98th Robot, Robots are no longer counted.  Subsequent shots to the
Left Ramp or Lock Lane awards a Super Robot, which is an immediate 5M.  The
Camera can no longer be lit by Robots once Super Robot is reached.  The Right
Inlane has no effect on the Super Robot on the Left Ramp.

The maximum number of Hitchhikers is 100.  When the 100th Hitchhiker is
awarded, the display is slightly messed up.  There is no display for any
further Hitchhikers collected, only a sound effect.  The 100th Hitchhiker
lights Battle The Power for the last time by this method.

There is a secret award at the 8th and 20th Dead Ends, in P-3 and newer
ROMs.  When these Dead Ends are collected, the animation changes - the car
suddenly drives _through_ the Dead End wall, with a twinkling effect and
sound, and a Dead End Bonus of 100M is awarded.  Very cool.

There is a cow in the Replay animation.  Watch the center reel of the Slot
Machine.

If a Replay is awarded by collecting your End-Of-Ball Bonus at the end of a
ball, flipping both flippers simultaneously will award a Flipper Bonus of 5M.
If you wait until the first reel of the Slot Machine has come to rest, this
will be accompanied by a pleasant sound effect.

There is a mysterious joystick on the backglass.

There is a miniature T-Rex on the backglass, being towered over by Rod
Serling.  There are also some brontosaurs, but they seem irrelevant.

There is at least one attract mode sequence to display an Easter Egg: an
extended version of the credits.  This sequence "has not yet been published".
Feel free to pass any such sequences along to me, though :)

There are persistent rumours and reported sightings of the Super Stunt Cow
in Twilight Zone.  It has always been reported in a particular context:
collecting a replay by loading the Gumball Machine.  Variations specify a lit
right Spiral, a Powerball in play, lighting Extra Ball from the lit right
Spiral, etc.  I have not seen this or been able to reproduce it, so if it
exists, the conditions are likely very picky.

                             Prototype Machines
                             ==================

There have been many changes from the rules of prototype Twilight Zone
machines.  These are mostly trivial and pointless to remember, but sometimes
it's interesting to know.  The changes of which I am aware include the
following:

Camera awards were at the Player Piano instead.  The Camera was the Jackpot
during Multiball.  There was no Super Slot round.  There was a Quick
Multiball round (other than Fast Lock).  There was a Door Panel for 5M
instead of Lite Gumball.  Spiral Values did not include lighting Battle The
Power.  The Clock Target was where the Power Payoff target is now.  Seven
balls were installed in the machine, with four residing in the Gumball
Machine.  There was an opto in the Hidden Lane.  There were _two_ optos and
Spiral Helper magnets on the Right Orbit.

Cosmetic changes include the following:

The Powerfield lacked point value labels and the FLIP HERE message.  The sign
above the upper right flipper did not indicate anything about the Gumball
Machine (apparently this was handled by a small light where the Spiral lamp
is now).  There was a sign above the upper left flipper indicating the
purpose of the yellow lamp there (lit Spiral).  There was no Bonus X lamp on
the Left Ramp.  The flasher above the central Clock Target was red.  The Dead
End lamp was red.  Why are you reading this paragraph?  A pair of glasses
appears in the artwork atop the Slot Machine.  The Lock light was green.

                                   Music
                                   =====

The main theme music of the Twilight Zone machine is derived, strangely
enough, from the song "Twilight Zone" by Golden Earring.  Hey, why not?
There is also some use of the original Twilight Zone theme music, of course,
and the other musical pieces are original compositions.  More details of the
music in Twilight Zone are available in the file "Quotes/tzone.quotes" in the
Archive.

                                   Quotes
                                   ======

A listing of Twilight Zone quotes ("Quotes/tzone.quotes") has been compiled
by Brian Dominy, <gt6139a@prism.gatech.edu>, and thanks go to him and
everyone who helped him out.  This section has, of course, benefited greatly
from his compilation.

Quotes from Rod Serling (impersonated by Fred Young):

  "An opportunity awaits you in the form... of an extra ball."
    (lighting an Extra Ball at the Lock Lane)
  "Be careful." (starting Super Skill Shot)
  "Beyond this door is a dimension of mind." (random)
  "Beyond this door is a dimension of sight." (locking first ball)
  "Beyond this door is a dimension of sound." (locking second ball)
  "Beyond this door is a dimension of time." (random)
  "Big risk, big reward... in the Twilight Zone."
    (100M or more End-of-Ball Bonus)
  "Deal with the devil at your own risk... in the Twilight Zone." (Tilt)
  "It seems that one of life's payoffs is ahead." (starting Super Slot)
  "It's time to tune in to... the Twilight Zone." (lighting Fast Lock)
  "Never underestimate the Power... in the Twilight Zone."
    (failing to defeat the Power)
  "Not an ordinary day." (early, random)
  "Not an ordinary day or an ordinary place." (early, random)
  "Note the hitchhiker... there, by the side of the road."
    (collecting Hitchhiker Door Panel)
  "Picture... the future." (Camera lit by Robots)
  "Player ___" (adding players to a game)
  "Player ___: Not an ordinary game... or an ordinary player."
    (entering your initials)
  "Ten million points." (collecting 10M Door Panel)
  "The spiral awaits you." (start of Spiral Round)
  "The stakes are higher... in the Twilight Zone." (starting Greed)
  "There is madness in town square." (starting Town Square Madness)
  "There, see what greed will get you?" (total of 25M or more from Greed)
  "Things are not as they first appear." (ball saver used, also random)
  "This clock... is worth millions."
    (starting Clock Millions or Clock 10 Millions)
  "This is a most unusual camera." (lighting Camera)
  "This shot requires skill... Super Skill." (lighting Super Skill Shot)
  "Time is a one-way street... except in the Twilight Zone."
    (starting Clock Chaos)
  "You have come to the end of your journey.  Survival _is_ everything."
    (starting Lost in the Zone)
  "You have just crossed over... into the Twilight Zone."
    (start of Multiball)
  "You have just taken a detour... through the Twilight Zone."
    (end of Multiball Restart)
  "You unlock this door with the key of imagination." (start of game)

Quotes from the Robot:

  "Breakthrough!" (collecting Spiral Breakthrough)
  "Don't touch the door." (locking first ball)
  "Don't touch the door, don't touch the door." (locking second ball)
  "Don't touch the door, don't touch the door, don't touch the door, don't
   touch the door, don't touch the door!" (starting Multiball)
  "Don't miss!" (Multiball Jackpot relit by Camera)
  "Enter the spiral." (early in Spiral Round)
  "Faster!" (Multiball Restart lit)
  "Get the extra ball." (Extra Ball lit at Lock Lane)
  "Look to the future." (Camera is lit)
  "More..." (second and subsequent Greed Targets in Greed Round)
  "Oh no!" (Multiball Restart ends)
  "One." (collecting first Spiral in Spiral Round)
  "The robots can help." (one more robot to light Extra Ball or Camera)
  "Three." (collecting third Spiral in Spiral Round)
  "Two." (collecting second Spiral in Spiral Round)
  "Webba wobba wubba." (Shoot Again)
  "You can do it!" (Multiball Restart lit)
  "You want more?" (first Greed Target in Greed Round)

Quotes from the Power:

  "Agggggggghh!" (defeating Power in Battle The Power)
  "Are you ready to battle?" (lighting Battle The Power)
  "Feel lucky?" (first time lighting Battle The Power)
  "Five, four, three, two, one..." (end of Lost In The Zone)
  "Give it back!" (Powerball Mania lit)
  "Heh heh heh heh!" (first time on Powerfield)
  "It's not yours!" (Powerball Mania lit)
  "Jackpot!" (Multiball Jackpot or Mania Jackpot)
  "Lucky!" (second time on Powerfield)
  "Noooooooo..." (entering Powerfield in Powerball Mania or Lost In The Zone)
  "Picture the future." (while Camera is lit)
  "Powerball!" (when Powerball detected, Powerball Loop scored, Powerball
    Mania started, or Multiball Jackpot doubled by Powerball)
  "Put it back!" (Powerball Mania lit)
  "Stop it!" (third time on Powerfield)
  "Three, two, one..." (end of Battle The Power)
  "Too hot to handle?" (Powerball Mania lit)

Quotes from Tina:

  "Here's your extra ball!  Tee hee huh!" (collecting any Extra Ball)
  "Hi, I'm talking Tina!" (collecting first Extra Ball at Lock Lane)

Quotes from the Hitchhiker:

  "Going my way?" (collecting Triple Pickup or the Camera: Hitchhiker award,
    unless doing so lights Battle The Power when it was not already lit)

Miscellaneous quotes:

  "(mumble)" (first segment of Fast Lock - from Cousin It)
  "Aieeee!  Oh no!" (Town Square Madness - crowd members)
  "BWAAAAAAAAHH!" (Fast Lock started - from Cousin It)
  "Do _not_ panic." (Fast Lock started - from Whirlwind)
  "Go for the hill!" (Fast Lock started - from Banzai Run)
  "Greeeeeeeed..." (using Extra Ball Buy-In - sounds suspiciously like Gomez
    from The Addams Family)
  "(GULP)... Bleeeeeeeeahh!" (Fast Lock started - from Rudy)
  "Long-legged woman, where have you been all my life--life--life?"
    (just kidding)
  "Hey, it's only pinball!" (second segment of Fast Lock - from Rudy)
  "It's sunny drive time!" (fourth segment of Fast Lock - from Earthshaker)
  "Ooh, gimme shelter!" (Fast Lock started - from Earthshaker)
  "Quit playing with the Clock!" (sixth hit in Clock Chaos - from Rudy)
  "Return to your homes." (third segment of Fast Lock - from Whirlwind)
  "Welcome, race fans!" (fifth segment of Fast Lock - from Banzai Run)

                                  Bragging
                                  ========

I don't brag anymore.  I just don't enjoy it like I used to.  But yeah, I've
rolled the game over, and even got over 7B once with the Tilt installed.  Ah,
in my heyday... ;-)

With Bang Backs, scoring is potentially unlimited...

                                  Credits
                                  =======

Credit must be given to Bowen Kerins <bowen@cardinal.stanford.edu>, who
first wrote a Twilight Zone Rules Sheet and Spoiler file.  Mark Phaedrus
<phaedrus@halcyon.com> posted a very helpful article on the behavior of
Spiral Helpers.  Thanks go in general to all other netters who have
contributed directly and indirectly...

And don't forget the Pinball Archive, the Fount of All That is Good:

ftp.rahul.net:/pub/sigma/pinball
(192.160.13.1)

[end of file]

 