Newsgroups: comp.patents
From: patents@cs.su.oz.au (patents newsgroup moderator)
Subject: [ARTICLE] Shneiderman article on User Interfaces
Organization: Basser Dept of Computer Science, University of Sydney, Australia
Date: Fri, 27 Nov 1992 19:33:58 GMT
Message-ID: <1992Dec1.020151.27700@cs.su.oz.au>
X-Article-Number: uklpf Msg # 200
X-Full-Sender-Address: @dlgm.daresbury.ac.uk:uklpf-request@daresbury.ac.uk
Lines: 223

[MOD- this article is from the UKLPF list and its author is rumoured
to be the expert witness on Graphical User interfaces in the Apple v.
Microsoft case]

-------------------------------------------------------------------------

		Protecting rights in user interface designs
 

                       (Prepared for ACM SIGCHI Bulletin October 1990
                           special issue on copyright legal issues)


 Ben Shneiderman
 Department of Computer Science
 University of Maryland
 College Park, MD 20742
 
 
Sacrificing individual rights in the hopes of benefitting the public
good is a tempting but often misguided pursuit.  I believe that
protecting individual rights (civil, voting, privacy, intellectual
property, etc.) is usually the best way to benefit and advance
the public good.
 
The current policy debate rages over the merits of offering
intellectual property protection to user interface designs.  While
most commentators agree that copyright is appropriate for books,
songs, or artwork, some are reluctant to offer such protection for
user interfaces.  These critics argue strenuously that intellectual
protection for user interfaces is "monopolistic" and that it would 
have a destructive effect on the public good by limiting dissemination of
of useful innovations and inhibiting standardization.  These critics claim that 
the traditional individual and corporate rights to creative works should 
be denied to user interface designers.
 
This position deserves some respect on its merits and because it is
quite widely held, but I strongly disagree.  I am now ready to speak
out in favor of protecting individual rights as the more effective
and durable path to increasing the public good.  My insight to these
issues has been enriched by participation as an expert witness for
the plaintiff in a major case now before the courts.  I had initially
rejected invitations to participate by lawyers from both sides of the
case.  Then during 1989, I more clearly realized the importance of
fighting for user interface designers as creative people who should
have the right to protect their creative work.
 
 
Background
 
Advocates of public domain software and shareware have benefitted the
computing community and I hope they will continue to do their work.
However, I am a strong believer in recognizing, rewarding,
respecting, and protecting individual creative activity in music,
film, poetry, writing, drawing, and user interface design.
Similarly, I support protection of functional devices (mechanical,
optical, electrical, etc.) by patent.  Creative works are extensions
of ourselves and, like our children, deserve protection.
 
I believe that participants in this debate are all in favor of
increasing the public good, but the issue is whether individual
rights must be given up.  Advocates of state-controlled economies,
communal utopias, restrictive zoning, and stop-and-search laws also
have argued that individual rights must be given up to increase the
public good, but often these arguments are short-sighted.  Although
there are compelling examples on both sides of the issue, I think
that the benefit to the public good is usually maximized by allowing
individuals and corporations to protect their efforts. 
 
 
The case for protection
 
If individuals or corporations have invested time and
resources to produce a creative work, they should be able to secure
legal protection.  This encourages innovation in at least two ways.
 
First, it offers the promise of honor and financial reward plus the
knowledge that they can influence who uses their work and how it is
used.  If I write a book or design a user interface, I want to know
that my name will remain connected with the work, that I will be
asked permission for its use, that I can influence the context of its
proposed use, and that I can ask compensation if I so wish.  I
regularly grant permission to use my works for free, but in other
situations I feel entitled to ask for payment.  Financial
remuneration is often necessary to continue development, refine the
creative work, and adequately market a product.
 
Second, new user interface designers are compelled to push forward
the state of the art to gain similiar recognition and reward.  If
user interfaces are unprotectable, then designers can ripoff the
currently fashionable design.  This can lead to acceptance of the
lowest common denominator while marketeers pat themselves on the back
in the belief that they are promoting standardization.  But this lazy
approach undermines the public good in that there is little pressure
or incentive to push the technology forward with innovative
solutions.  
 
 
Challenging the fear-mongers
 
Critics of protection paint a fearsome portrait of vicious
corporations and monopolistic individuals, but these scare tactics
seem exaggerated and naive.  Individuals and companies that produce
creative works want to see their creations put to work and are
usually eager to negotiate licenses that permit access for a fee.
This is quite well accepted even in the gentle world of folk music,
but also in the competitive worlds of film making and book
publishing.  
 
It does seem ironic that critics of protection publish their articles
in copyrighted journals.  Also the professional societies (ACM, IEEE,
etc.) have moved vigorously to assert their copyright over written
materials and more recently for electronically published sources.  
 
Allowing individuals or companies to assert ownership stimulates them
to disseminate their works, rather than keep them secret for as long
as possible.  Without protection, innovators might be reluctant to
share their developments until products were distributed.  With
protection an innovator can show a novel design and openly seek
partnerships.  
 
Of course there will be extreme anecdotes told by both sides and
strong claims made in legal briefs, but overall I vote to pursue the 
market-oriented policies that have more often than not been generative 
of innovation.  The user interface industry is growing up fast and like 
the rock music superstars, we must also learn to live with the 
lawyers and the legal system.  
 
The lawyers, courts, and judges are not malicious or poorly informed,
but they do have a different set of rules, that have been established
over decades.  The sooner we learn the rules, the more effective will
be our use of them to guide and promote innovation. 
  
 
Are user interfaces different from other expressive works? 
 
Copyrights are traditionally applied to creative works such as books,
poems, songs, or movies that have expressive aspects.  Copyrights are
secured easily and last for the author's lifetime plus fifty years.
Infringement is established as "substantial similarity as judged by ordinary
observers".  Patents are traditionally applied to inventions such as
staple guns, telescopes, motors, and radios that are functional.
Patents take several years to obtain and last 17 years, but
protection is strong.  Neither protection applies to principles of
nature or generic ideas.
 
Even critics recognize that the user interfaces for video games, children's 
entertainment software, and educational software are expressive and that 
they are copyrightable.  Designers of business computer applications such 
as word processors, spreadsheets, database managers, etc. have become more 
attentive to the expressive aspects of their user interfaces.
These interfaces now have eye-catching visual images, engaging animations,
colorful decorations, appealing sound effects, and playful aspects
(cute icons, 3-D, texture, shading, etc.) forming a harmonious ensemble.  
 
While the line between videogames and business applications is not
clear and the line between expressive and functional is not always clear,
I believe that the expressive aspects of user interfaces should be
protectable by copyright or possibly some new form of intellectual
property protection.
 
Increasingly, I find it possible to separate the user interface from
the functional components of an application.  We will have to rely on
the progress of our technology of specification and on legal
precedents to help chart a course.  This is a complex issue and clean
solutions are not to be expected, but that does not discourage me
>from pursuing this path.  I will stand up to protect individual rights.  
 
In some cases it is clear that infringement has occurred (exact copying), 
and in other cases the jury or judge will listen to the opposing parties 
and then make their judgment, just as they do for songs or movie scripts.
Cooperation by licensing and mediation when there is conflict seem
preferable, but when an adverserial situation arises we have
traditionally relied on the courts for resolution and precedents.
I prefer the courtroom, with all its burdens and expenses, to the Wild
West environment of Ripoff City.
 
 
Is a new form of intellectual protection needed?
 
Where there is an expressive component to a user interface, copyright 
seems appropriate.  Where the boundary between expression and function is 
fuzzier we may need a new form of protection.  I propose that researchers, 
developers, lawyers, and legislators explore the need for new forms of 
protection that would:
 
  - permit rapid filing and dissemination of novel works
     (more difficult than copyright, 
      but easier and quicker than patent)
  - contain a clear statement of what is protected
  - offer a limited time of protection (maybe 8-10 years)
  - encourage licensing for reasonable royalties
  - support a reasonable standardization process
 
 
Conclusion
 
Members of the user interface community should be aware that
important issues are at stake in these debates and court cases.  It
will be helpful to be informed so that they can sort out
the rhetoric and participate intelligently and constructively.  
 
A cooperative world in which partnership naturally leads to
respect for individual accomplishments is a great dream, but my
experience leads me to believe in the benefit of proper legal
protection.  I recommend support for intellectual property protection
for user interfaces in the belief that individual rights are the
foundation for a more progressive society.  At the same time, let's
honor user interface designers with our own form of Emmys, Oscars,
and Pulitzer Prizes.  
-------------------------------end of article---------------------------

 ---------------    Sam Nelson, Computer Officer, Dept of Computing Science,
| (paste        |   University of Stirling, Stirling FK9 4LA, Scotland.
|  complicated  |   E-mail: See From: line
|  logo         |   Tel:    +44 786 67443 (+44 786 467443 from 6.12.92)
|  here)        |   G3 Fax: +44 786 64551 (+44 786 464551 from 6.12.92)
|               |   Member of the League for Programming Freedom
|               |     (lpf@uunet.uu.net for details)
 ---------------    $\Delta p\Delta {\bf r}\stackrel{\textstyle >}{\sim}\hbar$
