		page	60,132
		title	'Sony Control Demo'

;==============================================================================
;
;           Antona Corporation
;           Sony Control Demo
;
;           September 28, 1986
;
;         (c) Antona Corporation
;         1643 1/2 Westwood Blvd.
;       West Los Angeles, California
;                  90024
;
;             (213) 473-8995
;
;   Produced by:
;      Software Systems / Sierra Madre
;
;   Written by:
;              J L Calaway
;
;==============================================================================


; assembly stuff
;
; masm/l/n sonyctl;
;
; link/dos sonyctl;
;

; version numbers and update record
;
;vers		equ	00001h			; first try
;vers		equ	00100h			; operational
;vers		equ	00101h			; 09-04-90 fixes
;vers		equ	00102h			; add que function
;vers		equ	00103h			; init i/o, and reset on exit
vers		equ	00104h			; i, o, n

; conditionals
;
;debug		equ	00001h			; test stuff
;shortlist	equ	00001h			; small is nice

; assembler equates
;
cr		equ	00dh			; carriage return
lf		equ	00ah			; line feed
eom		equ	024h			; dos eom
xx		equ	000h			; user supplied data
mxwait		equ	0600h			; cpu speed dependent
qmax		equ	00fh			; number of que slots-1
qsiz		equ	qmax+1
tail		equ	080h			; dos command line tail

comnum		equ	000h			; uses dos com port
tbe		equ	020h
dav		equ	001h

io_wait		macro
		jmp short $+2
		jmp short $+2
		endm


;==============================================================================
; tack segment
;==============================================================================


sseg	segment para stack 'stack'
		db	512 dup(?)
tos		equ	$
sseg		ends

		ifdef	shortlist
		.xlist
		endif ; shortlist

;==============================================================================
; fixed strings and tables
;==============================================================================

dseg	segment para memory 'dgroup'

; sony strings
;	byte 0 = count
;	byte 1 = cmd1
;	byte 2 = cmd2
;	byte 3 = data if any
;
stpstr		db	2,020h,000h		; stop
plystr		db	2,020h,001h		; play
ffwstr		db	2,020h,010h		; fast fwd
frvstr		db	2,020h,020h		; fast rev
srcstr		db	3,021h,013h,xx		; search fwd/rev
dtrstr		db	2,000h,011h		; device type
stastr		db	3,061h,020h,007h	; status
tmrstr		db	3,061h,00ch,004h	; timer
tcrstr		db	3,061h,00ch,001h	; time code reader
prestr		db	6,044h,031h,xx,xx,xx,xx	; preroll
questr		db	6,024h,031h,xx,xx,xx,xx	; cue up with data

; messages
;
;	byte 0 = col
;	byte 1 = row
;	byte 3 = data
;	byte x = eol
;
;
titlm		db	20,31,0,'Antona Corporation'
vmsg		db	14,34,1,'Version '
		db	(00fh and (vers / 256)) + '0'
		db	'.'
		db	(00fh and (vers / 16)) + '0'
		db	(00fh and vers) + '0'

no_port		db	'No comm port found',eom

inmsg		db	8,6,4,'I = In'
indata		db	15,3,5,'00:00:00:00  '
outmsg		db	9,25,4,'O = Out'
outdat		db	15,23,5,'00:00:00:00  '
durmsg		db	10,44,4,'Duration'
durdat		db	15,43,5,'00:00:00:00  '
posdat		db	15,63,5,'00:00:00:00 N'
tymsg		db	6,12,8,'Type'
tydata		db	10,18,8,'********'
ty800		db	10,18,8,'BVU-800 '
ty2000		db	10,18,8,'BVH-2000'
tybeta		db	10,18,8,'BETA-cam'
stmsg		db	8,51,8,'Status'
stofl		db	10,59,8,'Off-Line'
stonl		db	10,59,8,'On-Line '
ssped		db	31,26,10,'<        Search Speed       >'
sscale		db	31,26,11,'| . . . . . . 0 . . . . . . |'
clrspd		db	3,26,12,' '
		db	3,28,12,' '
		db	3,30,12,' '
		db	3,32,12,' '
		db	3,34,12,' '
		db	3,36,12,' '
		db	3,38,12,' '
		db	3,40,12,' '
		db	3,42,12,' '
		db	3,44,12,' '
		db	3,46,12,' '
		db	3,48,12,' '
		db	3,50,12,' '
		db	3,52,12,' '
		db	3,54,12,' '
setspd		db	3,26,12,'*'
		db	3,28,12,'*'
		db	3,30,12,'*'
		db	3,32,12,'*'
		db	3,34,12,'*'
		db	3,36,12,'*'
		db	3,38,12,'*'
		db	3,40,12,'*'
		db	3,42,12,'*'
		db	3,44,12,'*'
		db	3,46,12,'*'
		db	3,48,12,'*'
		db	3,50,12,'*'
		db	3,52,12,'*'
		db	3,54,12,'*'

modmsg		db	15,15,14,'  = Stop     '
modsz		equ	$-modmsg
		db	15,15,15,'P = Play     '
		db	15,15,16,'F = Fast fwd '
		db	15,15,17,'R = Rewind   '
		db	15,15,18,'S = Search   '
		db	15,15,19,'Q = Cue      '
		db	15,55,15,'D = Display  '
		db	15,55,16,'E = Exit     '
		db	15,55,17,'I = In Time  '
		db	15,55,18,'O = Out Time '

dtmr		db	11,65,4,'  Timer  '
dtcr		db	11,65,4,'Time Code'

blktbl		db	3,13,14,' '
blktz		equ	$-blktbl
		db	3,13,15,' '
		db	3,13,16,' '
		db	3,13,17,' '
		db	3,13,18,' '
		db	3,13,19,' '
		db	3,13,20,' '
strtbl		db	3,13,14,'*'
		db	3,13,15,'*'
		db	3,13,16,'*'
		db	3,13,17,'*'
		db	3,13,18,'*'
		db	3,13,19,'*'
		db	3,13,20,'*'

cmdkey		db	039h			; stop
		db	019h			; play
		db	021h			; fast fwd
		db	013h			; fast rev
		db	01fh			; search
		db	010h			; cue

		db	020h			; d type
		db	012h			; exit
		db	04bh			; slow
		db	04dh			; fast
		db	017h			; in point
		db	018h			; outpoint
cmdsiz		equ	$-cmdkey

cmdtbl		dw	allstp			; 00
		dw	play			; 01
		dw	fastf			; 02
		dw	fastr			; 03
		dw	srch			; 04
		dw	queup			; 05

		dw	dtype			; 06
		dw	exit			; 07
		dw	slow			; 08
		dw	fast			; 09
		dw	inpt			; 0a
		dw	outpt			; 0b

sstbl		db	000h			; 00  00
		db	010h			; 01  ff
		db	020h			; 02  fe
		db	02ah			; 03  fd
		db	036h			; 04  fc
		db	040h			; 05  fb
		db	04ah			; 06  fa
		db	057h			; 07  f9

tcmask		db	00fh			; u-frames
		db	003h			; t-frames
		db	00fh			; u-sec
		db	007h			; t-sec
		db	00fh			; u-min
		db	007h			; t-min
		db	00fh			; u-hrs
		db	003h			; t-hrs

two		db	002h,000h,000h,000h
tctbl		db	030h,060h,060h,024h

bd384		db	003h			; lsb of baud (38.4)
		db	000h			; msb of baud
		db	00bh			; line control
		db	003h			; modem function on
		db	000h			; ints off

com_adrs	dw	03f8h			; comm 1
		dw	02f8h			; comm 2
		dw	03e8h			; comm 3
		dw	02e8h			; comm 4
		dw	02c0h			; host 1
		dw	02d8h			; host 2

scrn_tbl	dw	titlm			; screen text
		dw	vmsg
		dw	inmsg
		dw	outmsg
		dw	durmsg
		dw	durdat
		dw	indata
		dw	outdat
		dw	posdat
		dw	tymsg
		dw	tydata
		dw	stmsg
		dw	stofl
		dw	ssped
		dw	sscale
scrn_z		equ	($ - scrn_tbl) /2

;==============================================================================
; variale data
;==============================================================================

tick		dd	0			; original tic address

strz		equ	$

rtclk		dw	?			; our time counter
mode		dw	?			; machine mode/command
mtime		dw	?			; 0=tc, 1=timer
ossdta		db	?			; last speed
ssdta		db	?			; current search speed/dir
rbuf		db	32 dup(?)		; return data
pbuf		db	4 dup(?)		; positon
ibuf		db	4 dup(?)		; in point
obuf		db	4 dup(?)		; out point
dbuf		db	4 dup(?)		; duration
ioport		dw	?			; serial port
saved_io	db	5 dup(?)		; saved io init

; quques
;
vmptr		dw	?			; ! vtr
vmctr		db	?			; !
vctr		db	?			; !
		db	?			; !
		db	?			; !
		dw	qsiz dup(?)		; *
dmptr		dw	?			; ! vtr
dmctr		db	?			; !
dctr		db	?			; !
		db	?			; !
		db	?			; !
		dw	qsiz dup(?)		; *

endz		equ	$
dseg		ends


;==============================================================================
;
; main routine
;
;==============================================================================

cseg		segment	para public 'code'
assume		cs:cseg,ds:dseg,es:dseg,ss:sseg

; start up code
begin		proc	near
		mov	bx,ds			; save ds

		; set up our enviroment
		cld				; always fwd
		cli				; ints off
		mov	ax,seg dseg		; data segs
		mov	ds,ax
		mov	es,ax
		mov	ax,seg sseg		; stack seg
		mov	ss,ax
		mov	sp,offset tos
		sti

		; clear ram
		mov	di,offset strz		; zero ram
		mov	cx,endz-strz
		xor	al,al
		rep	stosb

		; get default port address
		push	bx			; save org ds
		push	es			; save
		mov	bx,00040h		; bios seg
		mov	es,bx
		mov	bx,comnum		; which
		add	bx,bx			; to word
		mov	ax,es:[bx]		; get address
		pop	es			; restore
		mov	ioport,ax		; save

		; see if they gave us one
		pop	ds			; original ds
		mov	bx,tail			; offset 00080h -> count
		mov	ah,[bx]			; get count
		mov	al,[bx+2]		; no extra spaces
		push	es			; reset our ds
		pop	ds
		or	ah,ah			; anything
		jz	no_user			; no

		; valid number
		cmp	al,'1'			; 1 - 6
		jl	no_user
		cmp	al,'6'
		jg	no_user

		; set address
		sub	al,'1'			; strip ascii
		cbw				; to 16 bits
		xchg	ax,bx			; use bx
		add	bx,bx			; to words
		mov	ax,com_adrs[bx]		; get address
		mov	ioport,ax		; and set
no_user:

		; do we have a port
		mov	bx,ioport		; get port
		or	bx,bx			; test for non-zero
		jnz	save_cur		; ok

		; no port, report and exit
		mov	dx,offset no_port
		mov	ah,009h
		int	021h

		ifdef	debug
		int	003h
		else
		mov	ax,04c01h
		int	021h			; back to dos
		endif

		; save current seeting
save_cur:
		mov	di,offset saved_io
		call	save_port
				
		; set uart
		mov	bx,ioport
		mov	si,offset bd384
		call	int_port

		; clear screen and sign on
		mov	cl,0			; start col
		mov	ch,0			; start row
		mov	dh,25			; end row
		mov	dl,79			; end col
		mov	al,0			; lines to clear (all)
		mov	bh,7			; attrib
		mov	ah,6			; command
		int	010h
	
		; setup screen
		mov	si,offset scrn_tbl	; first address
		mov	cx,scrn_z		; to do
sloop:
		push	si			; save
		push	cx			; save
		mov	si,[si]			; get string
		call	pmsg			; show it
		pop	cx			; get'em back
		pop	si
		add	si,2			; next entry
		loop	sloop			; do all

		call	shotmr

		mov	cx,10			; to do
dloop:
		push	cx
		mov	ax,10
		sub	ax,cx
		mov	bl,modsz
		mul	bl
		mov	si,offset modmsg
		add	si,ax
		call	pmsg
		pop	cx
		loop	dloop
		mov	si,offset strtbl
		call	pmsg
		call	shospd

		; save current tick vector
		test	word ptr tick,0ffffh	; skip if set
		jnz	skpsav
		push	es
		mov	al,01ch
		mov	ah,035h
		cli
		int	021h			; get interupt
		sti
		mov	word ptr tick,es	; segment
		mov	word ptr tick+2,bx	; address
		pop	es
skpsav:

		; set new tick vector
		; from here interupts are hot
		push	ds
		mov	ah,025h
		mov	al,01ch
		push	cs
		pop	ds
		mov	dx,offset rtc
		cli
		int	021h			; set new
		sti
		pop	ds
begin		endp

;==============================================================================
; idle here
;==============================================================================

idle		proc	near
		; display?
		mov	bx,offset dmptr
		test	byte ptr [bx+2],0ffh
		jz	idle0

		; process character
		mov	si,[bx]
		inc	word ptr [bx]
		dec	byte ptr [bx+2]
		mov	al,[si]
		mov	bx,0
		mov	cx,1
		mov	ah,14
		int	010h			; display
		jmp	idle2

		; cursor
idle0:
		test	byte ptr [bx+3],0ffh
		jz	idle2

		; do cursor
		call	unque
		mov	bx,offset dmptr
		mov	si,[bx]			; cursor address
		add	word ptr [bx],2		; skip to message
		sub	byte ptr [bx+2],2	; - cursor size
		mov	dx,[si]			; get real cursor
		mov	bh,0			; page
		mov	ah,2			; set cursor
		int	010h			; do it

		; get keyboard status
idle2:
		mov	ah,1
		int	016h
		jz	idle			; wait

		; get key
		mov	ah,0
		int	016h

		; process key
		xchg	al,ah			; get code
		mov	cx,cmdsiz		; number to check
		mov	si,offset cmdkey
idle3:
		cmp	al,[si]
		jz	idle4			; not found
		inc	si
		loop	idle3
		jmp	idle

		; got one
idle4:
		mov	ax,cmdsiz		; convert
		sub	ax,cx
		mov	cx,ax			; save number
		mov	dx,offset idler
		push	dx			; return address
		mov	bx,offset cmdtbl
		add	ax,ax			; *2
		add	bx,ax			; to entry
		call	[bx]			; off we go

idler:
		jmp	idle

exit:
		; restore tick vector
		push	ds			; save
		mov	dx,word ptr tick+2	; get offset
		mov	ax,word ptr tick	; and segment
		mov	ds,ax			; set segment
		mov	ah,025h			; set interupt
		mov	al,01ch			; vector
		cli
		int	021h			; do
		sti
		pop	ds			; restore

		; zap the screen
		mov	cl,0			; start col
		mov	ch,0			; start row
		mov	dh,25			; end row
		mov	dl,79			; end col
		mov	al,0			; lines to clear (all)
		mov	bh,7			; attrib
		mov	ah,6			; command
		int	010h

		; restore the port
		mov	bx,ioport
		mov	si,offset saved_io
		call	int_port

		ifdef	debug
		int	3			; do break to debug
		else
		mov	ah,04ch			; exit
		mov	al,000h			; ok
		int	021h
		endif
idle		endp

;==============================================================================
; support routines
;==============================================================================


; stop vtr = 0
;
allstp		proc	near
		push	cx			; save cmd number
		call	mrkblk			; clear old mark
		pop	ax			; get number
		call	mrkstr			; show astrix
		mov	si,offset stpstr	; issue this string
		call	tovtr			; add to que
		ret
allstp		endp

;
;
play		proc	near
		push	cx			; save number
		call	mrkblk
		pop	ax
		call	mrkstr
		mov	si,offset plystr
		call	tovtr
		ret
play		endp

;
;
fastf		proc	near
		push	cx			; save number
		call	mrkblk
		pop	ax
		call	mrkstr
		mov	si,offset ffwstr
		call	tovtr
		ret
fastf		endp

;
;
fastr		proc	near
		push	cx			; save number
		call	mrkblk
		pop	ax
		call	mrkstr
		mov	si,offset frvstr
		call	tovtr
		ret
fastr		endp

;
;
srch		proc	near
		push	cx			; save number
		call	mrkblk
		pop	ax
		call	mrkstr
		mov	si,offset srcstr
		call	tovtr
		ret
srch		endp

; select timer/time code
;
dtype		proc	near
		cli
		inc	mtime			; 0 or 1
		and	mtime,001h
		sti

;
shotmr:
		mov	si,offset dtcr		; time code reader
		test	mtime,0ffh		; which?
		jz	$+5			; tcr
		mov	si,offset dtmr		; timer
		call	qmsg			; display
		ret
dtype		endp

;
;
queup		proc	near
		push	cx			; save number
		call	mrkblk			; clear old
		pop	ax
		call	mrkstr			; show new
		mov	si,offset prestr	; pre-roll = 0
		call	tovtr			; issue preroll
		mov	si,offset ibuf		; in time (sony format)
		mov	di,offset questr+3	; dest
		mov	cx,4			; copy
		rep	movsb
		mov	si,offset questr	; and issue
		call	tovtr
		ret
queup		endp

;
;
slow		proc	near
		cmp	mode,4			; in search?
		jz	$+3			; yes
		ret				; skip

		; do search
		cmp	ssdta,0f9h		; all ready max?
		jnz	$+3			; no, more
		ret
		mov	al,ssdta		; get current
		mov	ossdta,al		; save
		dec	ssdta			; next smaller
		jmp	sfsrc			; cont
slow		endp

;
;
fast		proc	near
		cmp	mode,4			; in search
		jz	$+3
		ret

		; search
		cmp	ssdta,7			; max
		jnz	$+3			; no
		ret
		mov	al,ssdta		; get it
		mov	ossdta,al		; save old
		inc	ssdta			; next higher
fast		endp

		; process data
sfsrc		proc	near
		mov	byte ptr srcstr+2,013h	; fwd
		mov	al,ssdta
		or	al,al
		jns	sfsrc1
		mov	byte ptr srcstr+2,023h	; rev
		neg	al
sfsrc1:
		xor	ah,ah			; find sony value
		mov	bx,offset sstbl
		add	bx,ax
		mov	al,[bx]			; get it
		mov	byte ptr srcstr+3,al	; set string
		mov	si,offset srcstr	; send speed
		call	tovtr
sfsrc		endp

;
shospd		proc	near
		mov	al,ossdta		; clear old
		add	al,7			; fit table
		mov	bl,4
		mul	bl
		mov	si,offset clrspd
		add	si,ax
		call	qmsg			; blank old
		mov	al,ssdta		; new
		add	al,7
		mov	bl,4
		mul	bl
		mov	si,offset setspd	; show astrix
		add	si,ax
		call	qmsg
		ret
shospd		endp

;
;
inpt		proc	near
		; copy position data
		mov	si,offset pbuf		; last read timecode
		mov	di,offset ibuf		; dest
		mov	cx,4			; four bytes
		rep	movsb			; copy
		and	byte ptr ibuf,00111111b	; clear df

		; format to ascii
		mov	si,offset ibuf		; source
		mov	di,offset indata+15	; dest
		call	btoa			; to bcd to ascii

		; format and show
		mov	si,offset indata	; and show
		mov	byte ptr [si+15],' '	; blank
		call	qmsg

		; figure and show duration
		call	durat			; figure duration
		ret
inpt		endp

;
;
outpt		proc	near
		; copy position data
		mov	si,offset pbuf
		mov	di,offset obuf
		mov	cx,4
		rep	movsb
		and	byte ptr obuf,00111111b	; clear df

		; format to ascii
		mov	si,offset obuf
		mov	di,offset outdat+15
		call	btoa

		; format and show
		mov	si,offset outdat
		mov	byte ptr [si+15],' '
		call	qmsg

		; figure and show duration
		call	durat
		ret
outpt		endp

;
;
durat		proc	near
		; assume no duration
		xor	al,al			; all zeros
		mov	cx,4
		mov	di,offset dbuf
		rep	stosb

		; test for positive value
		mov	si,offset ibuf		; who's bigger
		mov	di,offset obuf
		call	cptm
		jc	durat1

		; do calculation
		mov	di,offset dbuf
		mov	si,offset obuf
		mov	bx,offset ibuf
		call	subtc

		; format to ascii
durat1:
		mov	si,offset dbuf
		mov	di,offset durdat+15
		call	btoa

		; and show
		mov	si,offset durdat
		mov	byte ptr [si+15],' '
		call	qmsg
		ret
durat		endp

; blank current star
;
mrkblk		proc	near
		mov	ax,mode			; old mode
		mov	bl,blktz		; size
		mul	bl
		mov	si,offset blktbl	; blanking strings
		add	si,ax			; to correct one
		call	qmsg			; blank
		ret
mrkblk		endp

; set current star
; ax=mode
;
mrkstr		proc	near
		mov	mode,ax			; set new mode
		mov	bl,blktz		; size
		mul	bl
		mov	si,offset strtbl	; asxtrix table
		add	si,ax			; correct one
		call	qmsg			; show it
		ret
mrkstr		endp

; time code subtraction
;
; call with:
;	[di]=dest
;	[si]->arg1
;	[bx]->arg2
;
; [di]=[si]-[bx]
;
subtc		proc	near
		push	di			; save result
		call	subbcd			; do subtraction
		pop	di			; result back
		mov	al,byte ptr pbuf	; was it df
		and	al,040h			; df flag
		jnz	$+3			; yes
		ret				; no

		; check df result
		add	di,2			; to minutes
		mov	al,[di]			; mins
		and	al,00fh			; iso lower
		jnz	$+3			; units min's must not be zero
		ret
		dec	di			; seconds
		mov	al,[di]
		or	al,al			; must be zero
		jz	$+3
		ret
		dec	di			; frames
		mov	al,[di]
		or	al,al			; if zero or 1
		jz	sbchk1			; must do
		dec	al
		jz	sbchk1
		ret
subtc		endp

; correction
;
sbchk1		proc	near
		mov	bx,offset two
		mov	si,di
sbchk1		endp

; bcd subtraction
;
subbcd		proc	near
		mov	dx,offset tctbl		; max
		mov	cx,4			; to do
		clc				; cy=0
subbc1:
		mov	al,[si]			; arg1
		sbb	al,[bx]			; + arg2
		das				; bcd!
		jnc	subbc2			; yes
		xchg	dx,bx
		add	al,[bx]
		xchg	bx,dx
		daa
		stc				; cy=0
subbc2:
		mov	[di],al			; save answer
		inc	di			; result
		inc	si			; arg1
		inc	bx			; arg2
		inc	dx			; table
		loop	subbc1
		ret
subbcd		endp

; call with [di]->lsb, [si]->lsb
; returns
;
; di < si  c=1  z=0
; di = si  c=0  z=1
; di > si  c=0, z=0
;
cptm		proc	near
		; to msd
		add	di,3
		add	si,3
		mov	cx,4			; do four
cptm1:
		mov	al,[di]
		cmp	al,[si]
		jnz	cptmx
		dec	si
		dec	di
		loop	cptm1
cptmx:
		ret
cptm		endp

; display
;
qmsg		proc	near
		mov	bx,offset dctr
		call	adque
		ret
qmsg		endp

;==============================================================================
;
; add messages to que
;
; call with si = mess, [bx] = que ctr
;
; que format
;
;	byte 00 = que ctr
;	byte 01 = que in
;	byte 02 = que out
;	byte 03 = que buff
;
;==============================================================================

adque		proc	near
		pushf				; save int
		cli				; ints off
		mov	al,[bx]			; get count
		cmp	al,qmax			; full?
		jnz	adque1			; no
		popf				; restore ints
		ret				; yes

		; do add
adque1:
		inc	byte ptr [bx]		; +1
		mov	al,1[bx]		; get in
		push	ax			; save
		inc	al
		and	al,qmax			; roll over
		mov	1[bx],al		; next
		pop	ax			; get current
		cbw				; make word
		sal	ax,1			; x2
		add	bx,ax			; offset
		mov	3[bx],si		; save message
		popf
		ret
adque		endp

;==============================================================================
;
; remove message from que
;
; call with [bx] = mess ptr
; returns with [si]-message
;
;	byte 00 = msg ptr
;	     01
;	byte 02 = msg ctr
;	byte 03 = que ctr
;	byte 04 = que in
;	byte 05 = que out
;	byte 06 = que buff
;
;==============================================================================

unque		proc	near
		pushf				; save ints
		cli
		dec	byte ptr 3 [bx]		; +1
		push	bx			; for exit
		mov	al,5[bx]		; out ctr
		push	ax			; save
		inc	al			; next
		and	al,qmax			; iso
		mov	5[bx],al		; save
		pop	ax
		cbw				; to word
		sal	ax,1			; x2
		add	bx,ax			; offset
		mov	bx,6[bx]		; get

		; move data to message ptr
		mov	al,[bx]			; get chr ct
		inc	bx			; begin mess
		mov	si,bx			; save in si
		pop	bx			; offset back
		mov	2[bx],al		; mess ctr
		mov	[bx],si			; mess ptr
		popf
		ret
unque		endp

; transport commands
; [si]->string
;
tovtr		proc	near
		mov	bx,offset vctr
		call	adque
		ret
tovtr		endp

; command to vtr
; [si]-> string
; return data in rbuf
; cy=1=ng
;
xmit		proc	near
		; get count
		mov	cl,[si]
		inc	si			; to message
		mov	bl,0			; checksum
		cli				; ints off

		; get port address
		mov	dx,ioport

		; send data
xmit0:
		add	dx,5			; to status
xmit1:
		in	al,dx			; get
		io_wait
		and	al,tbe
		jz	xmit1			; busy
		sub	dx,5			; to data port
		lodsb				; get data
		out	dx,al
		io_wait
		add	bl,al			; check sum
		dec	cl
		jnz	xmit0

		; now send checksum
		add	dx,5
xmit2:
		in	al,dx
		io_wait
		and	al,tbe
		jz	xmit2
		sub	dx,5
		mov	al,bl
		out	dx,al
		io_wait

		; ready to recieve
		sti				; ints on for a second
		mov	di,offset rbuf		; dest
		mov	bx,mxwait
		mov	cx,0			; ch=checksum, cl=count
		cli				; off again

		; get count
		mov	dx,ioport
		add	dx,5
xmit4:
		in	al,dx
		io_wait
		and	al,dav
		jnz	xmit5			; got it
		dec	bx
		jz	xmitb			; bad
		jmp	xmit4

		; got count
xmit5:
		sub	dx,5
		in	al,dx
		io_wait
		add	ch,al			; checksum
		stosb				; to buffer
		and	al,00fh			; iso count
		inc	al			; +1
		mov	cl,al

		; get message
xmit6:
		add	dx,5			; to status
xmit7:
		in	al,dx
		io_wait
		and	al,dav
		jnz	xmit8			; got char
		dec	bx
		jz	xmitb
		jmp	xmit7

		; process char
xmit8:
		sub	dx,5
		in	al,dx
		io_wait
		add	ch,al
		stosb
		dec	cl
		jnz	xmit6

		; get checksum
		add	dx,5			; back to status
xmit9:
		in	al,dx
		io_wait
		and	al,dav
		jnz	xmita
		dec	bx
		jz	xmitb
		jmp	xmit9
xmita:
		sub	dx,5
		in	al,dx			; get check
		io_wait
		cmp	al,ch			; compare
		jnz	xmitb			; ng if not same
		sti
		clc				; cy=0=ok
		ret

		; ng report
xmitb:
		sti
		stc				; cy=1=ng
		ret
xmit		endp

; bcd to ascii
;
btoa		proc	near
		; set df/ndf
		mov	byte ptr [di],'N'	; assume non-drop
		test	byte ptr [si],01000000b	; test df flag
		jz	btoa0
		mov	byte ptr [di],'D'
btoa0:
		mov	bx,offset tcmask
		dec	di
		dec	di			; units frames
		mov	cx,4			; to do
btoa1:
		mov	al,[si]			; get lsb
		and	al,[bx]			; iso
		inc	bx
		add	al,'0'			; to ascii
		mov	[di],al
		dec	di			; to tens
		mov	al,[si]
		sar	al,1
		sar	al,1
		sar	al,1
		sar	al,1
		and	al,[bx]
		inc	bx
		add	al,'0'
		mov	[di],al
		dec	di			; to colon
		dec	di			; next units
		inc	si
		loop	btoa1
		ret
btoa		endp

; display message
; [si]-> count
; do not call with interupts in service
;
pmsg		proc	near
		mov	cl,[si]			; get count
		sub	cl,2			; -2 for coursor
		xor	ch,ch			; zero hi
		inc	si			; to cursor
		mov	dx,[si]			; get cursor
		mov	bh,0			; current page
		mov	ah,2			; set
		push	cx			; save count
		push	si			; save message
		int	010h			; set cursor
		pop	si			; get message
		pop	cx			; and count
		add	si,2			; skip cursor
		or	cl,cl			; cursor only?
		jnz	pmsg0			; no, do message
		ret

		; print message
pmsg0:
		push	cx			; save count
		lodsb				; get char
		push	si			; save pointer
		mov	ah,14			; print message
		int	010h
		pop	si			; pointer back
		pop	cx			; and count
		loop	pmsg0
		ret
pmsg		endp

; real time clock intereupt
;
rtc		proc	far
		; save regs
		pushf
		push	ax
		push	bx
		push	cx
		push	dx
		push	si
		push	di
		push	ds
		push	es
		mov	ax,seg dseg
		mov	ds,ax
		mov	es,ax

		; select string
		mov	si,offset dtrstr
		mov	al,byte ptr rtclk	; our clock
		and	al,00fh			; 1 in 15
		cmp	al,00fh
		jz	rtc0			; ask for machine type
		mov	si,offset stastr	; status
		cmp	al,007h			; 1 in 7
		jz	rtc0
		mov	si,offset tcrstr	; all otheres time
		test	mtime,0ffh
		jz	$+5
		mov	si,offset tmrstr

		; anything
rtc0:
		mov	bx,offset vmptr
		test	byte ptr [bx+3],0ffh
		jz	rtc1
		call	unque
		dec	si
rtc1:
		call	xmit
		jc	rtcx

		; process return data
		mov	al,byte ptr rbuf
		and	al,0f0h			; iso cmd 1

		; time or type type?
		cmp	al,010h			; type?
		jnz	rtc2			; no, must be time/sta
		mov	al,byte ptr rbuf+1
		cmp	al,011h
		jnz	rtcx			; unknown

		; which machine type
		mov	al,byte ptr rbuf+2
		mov	si,offset ty2000
		and	al,0f0h
		jz	rtc3
		mov	si,offset ty800
		cmp	al,010h
		jz	rtc3
		mov	si,offset tybeta
		cmp	al,020h
		jz	rtc3
		mov	si,offset tydata
		jmp	rtc3

		; time/status
rtc2:
		cmp	al,070h
		jnz	rtcx			; unknown

		; which
		mov	al,byte ptr rbuf+1
		cmp	al,020h			; status?
		jnz	rtc4			; no, time

		; status
		mov	al,rbuf+2		; get on line stat
		and	al,001h			; iso

		; show it
		mov	si,offset stonl
		jz	$+5
		mov	si,offset stofl
		jmp	rtc3

		; time
rtc4:
		mov	si,offset rbuf+2
		mov	di,offset pbuf
		mov	cx,4
		rep	movsb

		; format to ascii
		mov	si,offset pbuf
		mov	di,offset posdat+15
		call	btoa

		; show it
		mov	si,offset posdat
rtc3:
		call	qmsg

		; exit
rtcx:
		inc	rtclk
		pop	es
		pop	ds
		pop	di
		pop	si
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		popf
		iret
rtc		endp

;==============================================================================
; serial port initilization
;
; call: bx = port address
;       si-> data
;
; return: nothing
;==============================================================================

int_port	proc	near
		mov	dx,bx			; base to dx
		add	dx,3			; +3 = line control reg
		mov	al,080h			; dlab=1
		out	dx,al			; select divisor
		io_wait
		mov	dx,bx			; dlab=0=rx, dlab=1=lsb div
		lodsb				; get lsb
		out	dx,al			; set it
		io_wait
		mov	dx,bx
		inc	dx			; +1 = msb divisor
		lodsb				; get msb
		out	dx,al			; set it
		io_wait
		mov	dx,bx
		add	dx,3			; +3 = line ctl reg, dlab=0
		lodsb
		out	dx,al
		io_wait
		mov	dx,bx
		add	dx,4			; +4 = modem control
		lodsb
		out	dx,al
		io_wait
		mov	dx,bx
		inc	dx			; +1 = dlab=0, int ctl
		lodsb				; interupt bits
		out	dx,al			; set
		io_wait

		; clear port
		mov	dx,bx			; data
		in	al,dx			; get it
		ret
int_port	endp

;==============================================================================
; save serial port init
;
; call: bx = port address
;       di-> data
;
; return: nothing
;==============================================================================

save_port	proc	near
		; read line control
		mov	dx,bx			; get current
		add	dx,3
		in	al,dx
		io_wait
		push	ax			; save

		; set dlab high
		mov	al,080h			; dlab=1
		out	dx,al			; select divisor
		io_wait

		; read divisor's
		mov	dx,bx			; address to dx
		in	al,dx			; dlab=0=rx, dlab=1=lsb div
		io_wait
		stosb				; save
		mov	dx,bx
		inc	dx			; +1 = msb divisor
		in	al,dx
		io_wait
		stosb

		; save line control, clear dlab
		pop	ax			; old line control
		stosb				; save for next
		mov	dx,bx
		add	dx,3			; +3 = line ctl reg, dlab=0
		out	dx,al			; reset, dlab = 0
		io_wait

		; get modem control
		mov	dx,bx
		add	dx,4			; +4 = modem control
		in	al,dx
		io_wait
		stosb
		mov	dx,bx
		inc	dx			; +1 = dlab=0, int ctl
		in	al,dx
		io_wait
		stosb

		; clear port
		mov	dx,bx			; data
		in	al,dx			; get it
		ret
save_port	endp

;==============================================================================
;
; that all folks
;
;==============================================================================

cseg		ends
		end	begin
