program adda;   (* A/D - D/A demostrations program *)
(*$i-*)
(*$i \pascal\plib\mslib.pas *)
(*$i \pascal\plib\video.lib *)
(*$i \pascal\plib\mylib.pas*)

const
  (* port adresser *)
  channel_nr                   = $278;
  ad_input_low_8_bit           = $279;
  ad_input_high_4_bit          = $27a;
  clear_ad_register            = $27b;
  ad_conversion_loop_low       = $27c;
  ad_conversion_loop_high      = $27d;
  output_da_low_8_bit          = $27e;
  output_da_high_4_bit         = $27f;
  
var
  low_byte,high_byte           : integer;  (* numeric value of ad_input  *)
  ad_data                      : integer;  (* numeric value of high_byte *)
                                           (* and low_byte readings      *)
  output_low_8_bit             : integer;
  output_high_4_bit            : integer;
  show                         : boolean;
  kanal_nr                     : integer;
  proportional_band            : real;
  set_punkt                    : real;
  ad_data_set_punkt            : integer;
  part_pr_percentage           : integer;
  port_a    : INTEGER;
  port_b    : INTEGER;
  port_c    : INTEGER;
  port_d    : INTEGER;
  bin_data  : REAL;
  data      : BYTE;
  realdata  : REAL;

(*_________________________________________________________________*)

procedure kanal;
 begin
  gotoxy(30,19);
  write('Which Channel No. ',blkon,'(0..15) ',blkoff);
  cursor(true);
  repeat
    read(kanal_nr);
    if (kanal_nr>15) or (kanal_nr<0) then
      begin
        write(chr(7));
        gotoxy(56,19);
        write('            ');
        gotoxy(56,19);
      end;
  until (kanal_nr) in (.0..15.); 
 cursor(false);
end;
procedure main_frame;    

var
  x,y,z  : integer;
  
begin
  z:=0;                             (* line counter *)
  color(7,0);
  write(clrhom);
  z:=z+1;
  gotoxy(2,z);
  write(chr(218));
  for x:=1 to 74 do
    write(chr(196));
  writeln(chr(191));
  for x:=1 to 3 do
    begin
      z:=z+1;
      write('  ',chr(179));
      gotoxy(77,z);
      writeln(chr(179));
    end;
  z:=z+1;
  write('  ',chr(198));
  for x:=1 to 74 do
    write(chr(205));
  writeln(chr(181));
  for x:=1 to 17 do
    begin
      z:=z+1;
      write('  ',chr(179));
      gotoxy(77,z);
      writeln(chr(179));
    end;
  z:=z+1;
  write('  ',chr(192));
  for x:=1 to 74 do
    write(chr(196));
  writeln(chr(217));
end;  (* procedure main_frame *)

(*_________________________________________________________________*)

procedure clear_frame;

var
  x,z  : integer;
  
begin Code
  $b7,$00,
  $b4,$07,
  $b0,$00,
  $b5,$06,
  $b1,$04,
  $b6,$16,
  $b2,$49,
  $cd,$10;
end;  (* procedure clear_frame )

(*_________________________________________________________________*)

procedure main_menu;  

begin
  color(7,0);
  gotoxy(10,3);
  write('  ANALOG / DIGITAL  -  DIGITAL / ANALOG       DEMO PROGRAM');
  gotoxy(25,9);
  write('1.  ANALOG/DIGITAL - INPUT');
  gotoxy(25,11);
  write('2.  DIGITAL/ANALOG - OUTPUT');
  gotoxy(25,13);
  write('3.  REGULATION - DEMO');
  gotoxy(25,15);
  write('4.  DIGITAL OUT - ANALOG IN DEMO');
  gotoxy(25,17);
  write('5.  PC- INPUT/OUTPUT TEST ');
  gotoxy(52,22);
  write('F9 = EXIT from PROGRAM');
end;  (* procedure main_menu *)

(*_________________________________________________________________*)

procedure read_input;

var
  x,y         : real;
  i,j         : integer;
  ad_data_sum : real;                         (* sum af flere mlinger  *)

begin
    ad_data_sum:=0;
    for j:=1 to 10 do
      begin
        port(.channel_nr.):=kanal_nr;         (* set input kanal nummer *)
        x:=port(.clear_ad_register.);         (* clear register         *)
        for i:=1 to 7 do
          y:=port(.ad_conversion_loop_low.);  (* convertering loop low  *)
        for i:=1 to 7 do
          y:=port(.ad_conversion_loop_high.); (* convertering loop high *)
        x:=port(.ad_input_high_4_bit.);       (* ls high 4-bits        *)
        high_byte:=round((x/16-int(x/16))*16);(* conv. high-bits til    *)
                                              (* integer                *)
        low_byte:=port(.ad_input_low_8_bit.); (* ls low 8-bits         *)
        ad_data:=(high_byte*256+low_byte);    (* st high and low bits  *)
                                              (* sammen til een integer *) 
        ad_data_sum:=ad_data_sum+ad_data;     (* add til forrige sum    *)
      end;
 ad_data:=round((ad_data_sum)/10);            (* beregn gennemsnit af   *)
                                              (* udfrte mlinger       *)
end;  (* procedure read_input *)


(*_________________________________________________________________*)

procedure ad_demo;  (* demo af A/D input *)

var
  x : real;
                   (*__________________*)

procedure ad_demo_menu;

begin
  gotoxy(30,10);
  write('Presentation of:');
  gotoxy(30,13);
  write('1.  Single Channel');
  gotoxy(30,15);
  write('2.  All channels');
  gotoxy(51,22);
  write('F10 = EXIT to MAIN-MENU');
  repeat
    getkey;
  until ch in(.'1','2','D'.);
end;  (* procedure ad_demo_menu *)

                   (*__________________*)

procedure read_single_input;

begin
  kanal;
  clear_frame;
  gotoxy(30,8);
  write('CHANNEL NUMBER:  ',kanal_nr:2);
  gotoxy(30,9);
  write('___________________');
  gotoxy(10,12);
  write('Numeric Value:                               Value %');
  gotoxy(51,22);
  write('F10 = EXIT to MAIN-MENU');
  repeat
    read_input;
    gotoxy(12,14);
    write(ad_data:5);
    gotoxy(56,14);
    x:=(int(((ad_data)/4095)*1000))/10;
    write(x:5:1);
    if keypress then
      begin
        read(kbd,ch);
        key:=integer(ch);
      end;
  until ch='D';
end;  (* procedure read_single_input *)

                   (*__________________*)

procedure read_all_input;

var
  x,z   : integer;
  y     : real;
  
begin
  ch:='0';
  clear_frame;
  repeat
    gotoxy(8,8);
    write('Channel number: Numeric    %');
    gotoxy(43,8);
    write('Channel number: Numeric    %');
    gotoxy(43,9);
    gotoxy(8,9);
    write('                 Value   Value');
    gotoxy(43,9);
    write('                 Value   Value');
    gotoxy(49,22);
    write('F10 = EXIT to MAIN-MENU');
    z:=10;                                     (* line number             *)
    x:=8;                                      (* start pos. number       *)
    for kanal_nr:=0 to 7 do
      begin
        z:=z+1;
        read_input;  
        gotoxy(x,z);
        write('Channel Nr ',kanal_nr:2,':  ',ad_data:5);
        gotoxy(x+24,z);
        y:=(int(((ad_data)/4095)*1000))/10;
        write(y:5:1);
      end;
      z:=10;
      x:=43;
    for kanal_nr:=8 to 15 do
      begin
        z:=z+1;
        read_input;  
        gotoxy(x,z);
        write('Channel Nr ',kanal_nr:2,':  ',ad_data:5);
        gotoxy(x+24,z);
        y:=(int(((ad_data)/4095)*1000))/10;
        write(y:5:1);
      end;
    if keypress then
      begin
        read(kbd,ch);
      end;
  until (ch='D') or (integer(ch)=27);
end;  (* procedure read_all_input *)
                   (*__________________*)

begin
  clear_frame;
  cursor(false);
  ad_demo_menu;
  case ch of
    '1' : begin
            read_single_input;
          end;
    '2' : begin
            read_all_input;
          end;
  end;
end;  (* procedure ad_demo *)

(*_________________________________________________________________*)

procedure da_demo;  (* demo af D/A output *)

var
  valg_ch1  : char;
  valg_ch2  : char;
  
                   (*__________________*)

procedure da_demo_menu;

begin
  clear_frame;
  gotoxy(25,9);
  write('Presentation of:');
  gotoxy(25,12);
  write('1.  Every tenth of percent.');
  gotoxy(25,14);
  write('2.  Every percent.');
  gotoxy(25,16);
  write('3.  every ten percent.');
  gotoxy(25,18);
  write('4.  Only "0" and "100" percent.');
  gotoxy(51,22);
  write('F10 = EXIT to MAIN-MENU');
  repeat
    getkey;
  until ch in (.'1','2','3','4','D'.);
  valg_ch1:=ch;
  clear_frame;
end;  (* procedure da_demo_menu *)

                   (*__________________*)

procedure show_da_value;   

var
  x : real;
  y : integer;
  
begin
  x:=(int(((output_high_4_bit*256+output_low_8_bit)/4095)*1000))/10;
  y:=round(x*10);
  case valg_ch1 of
    '1' :   if y mod 1=0 then
              begin
                gotoxy(12,13);
                write(output_high_4_bit*256+output_low_8_bit:6);
                gotoxy(56,13);
                write(x:5:1);
              end;
    '2' :   if y mod 10=0 then
              begin
                gotoxy(12,13);
                write(output_high_4_bit*256+output_low_8_bit:6);
                gotoxy(56,13);
                write(x:5:1);
              end;
    '3' : if y mod 100=0 then
            begin
              gotoxy(12,13);
              write(output_high_4_bit*256+output_low_8_bit:6);
              gotoxy(56,13);
              write(x:5:1);
            end;
    '4' : if y mod 1000=0 then
            begin
              gotoxy(12,13);
              write(output_high_4_bit*256+output_low_8_bit:6);
              gotoxy(56,13);
              write(x:5:1);
            end;
  end;      
end;  (* procedure show_da_value *)

                   (*__________________*)
   


begin
  clear_frame;
  da_demo_menu;
  gotoxy(10,10);
  write('Numeric Value:                               Value %');
  if valg_ch1 in (.'1','2','3','4'.) then
    begin
      gotoxy(10,10);
      write('Numeric Value:                               Value %');
      repeat
        for output_high_4_bit:=0 to $f do
          begin
            port(.output_da_high_4_bit.):=output_high_4_bit;
            for output_low_8_bit:=0 to $ff do
              begin
                port(.output_da_low_8_bit.):=output_low_8_bit;
                show_da_value;
              end;
          end;
        for output_high_4_bit:=$f downto 0 do
          begin
            if (output_high_4_bit=7) and (output_low_8_bit=$ff) then
              begin
                output_high_4_bit:=6;
                port(.output_da_high_4_bit.):=output_high_4_bit;
                output_high_4_bit:=7;
                port(.output_da_high_4_bit.):=output_high_4_bit;
              end;
            port(.output_da_high_4_bit.):=output_high_4_bit;
            for output_low_8_bit:=$ff downto 0 do
              begin
                show_da_value;
                port(.output_da_low_8_bit.):=output_low_8_bit;
                show_da_value;
              end;
            output_low_8_bit:=$ff;
          end;
          if keypress then
            begin
              read(kbd,ch);
              key:=integer(ch);
            end;
          valg_ch2:=ch;
      until (valg_ch2='D') or (integer(valg_ch2)=27);
    end;
end;  (* procedure da_demo *)
  
(*_________________________________________________________________*)

procedure reg_demo;  

var
  set_punkt_afvigelse        : integer;
  max_set_punkt_afvigelse    : integer;
  upper_limit                : integer;
  lower_limit                : integer;
  regulator_spring           : integer;  
  reg_data                   : integer;
  i,j                        : integer;  
  x,y                        : real;
  
                   (*__________________*)
   
procedure reg_menu;

begin
  clear_frame;
  gotoxy(25,8);
  write('REGULATOR-DEMONSTRATION:');
  gotoxy(25,9);
  write('________________________');
  gotoxy(15,12);
  write('1.  Change SET-PUNKT,        (present value:   ');
  write(set_punkt:5:1,')');
  gotoxy(15,14);
  write('2.  Change PROPORTINAL-BAND, (present value:   ');
  write(proportional_band:5:1,')');
  gotoxy(15,16);
  write('3.  Change CHANNEL NR.       (present channel: ');
  write(kanal_nr,')');
  gotoxy(15,18);
  write('4.  Run REGULATION');
  gotoxy(51,22);
  write('F10 = EXIT to MAIN-MENU');
  repeat
    getkey;
  until ch in (.'1','2','3','4','D'.);
    
end;  (* reg_menu *)

                   (*__________________*)
   
procedure get_set_punkt;

begin
  gotoxy(15,12);
  write('Enter SET-PUNKT for regulator in % (',set_punkt:5:1,')  ');
  read(set_punkt);
  if set_punkt>100 then
    set_punkt:=100;
  if set_punkt<1 then
    set_punkt:=1;
  ad_data_set_punkt:=round((4095*set_punkt)/100);
end;  (* procedure get_set_punkt *)

                   (*__________________*)
   
procedure get_proportional_band;

begin
  gotoxy(15,12);
  write('Enter PROPORTIONAL-BAND for regulator in % (');
  write(proportional_band:5:1,')  ');
  read(proportional_band);
  if proportional_band>100 then
    proportional_band:=100;
  if proportional_band<1 then
    proportional_band:=1; 
  part_pr_percentage:=round(4095/proportional_band);
end;  (* procedure get_proportional_band *)

                   (*__________________*)

procedure get_set_punkt_afvigelse;   

var
  x : real;

begin
  read_input;
  set_punkt_afvigelse:=ad_data_set_punkt-ad_data;
  if set_punkt_afvigelse<0 then
    set_punkt_afvigelse:=set_punkt_afvigelse*(-1);
  x:=(set_punkt+(proportional_band/2));
  upper_limit:=round((4095*x)/100);
  if upper_limit>4095 then
    upper_limit:=4095;
  x:=(set_punkt-(proportional_band/2));
  lower_limit:=round((4095*x)/100);
  if lower_limit<0 then
    lower_limit:=0;
      
  regulator_spring:=round(100/proportional_band);

end;  (* procedure get_set_punkt_afvigelse *)

                   (*__________________*)

procedure reg_picture;

begin
  clear_frame;
  gotoxy(30,7);
  write('REGULATOR - CONSTANTS:');
  gotoxy(30,8);
  write('______________________');
  gotoxy(5,11);  
  write('    Channel  Lower-   SET-PUNKT  upper-    ');
  write('PROPORTIONAL   regulator-');
  gotoxy(5,12);
  write('    number:  limit:              limit:        ');
  write('BAND:        units:');
  gotoxy(4,14);
  write('Integ.');
  gotoxy(11,14);
  write(kanal_nr:2);
  gotoxy(19,14);
  write(lower_limit:4);
  gotoxy(29,14);
  write(ad_data_set_punkt:4);
  gotoxy(39,14);
  write(upper_limit:4);
  gotoxy(54,14);
  write('-');
  gotoxy(64,14);
  write(regulator_spring:5);
  
  gotoxy(4,16);
  write('   %');
  gotoxy(11,16);
  write(kanal_nr:2);
  gotoxy(19,16);
  write(set_punkt-(proportional_band/2):4:1);
  gotoxy(29,16);
  write(set_punkt:4:1);
  gotoxy(39,16);
  write(set_punkt+(proportional_band/2):4:1);
  gotoxy(52,16);
  write(proportional_band:3:1);
  gotoxy(68,16);
  write('-');
  gotoxy(2,18);
  write(chr(195));
  for i:=1 to 74 do
    write(chr(196));
  write(chr(180));
  gotoxy(4,20);
  write('Actual Meassurement:          %');
  write('         Regulator Value:          %');
  gotoxy(51,22);
  write('  F8 = EXIT to REG. MENU');
end;  (* procedure reg_picture *)

                   (*__________________*)
   
procedure run_reg;

begin
  repeat
    read_input;
    if ad_data<=lower_limit then
      reg_data:=4095;
    if ad_data>=upper_limit then
      reg_data:=0;
    if (ad_data>lower_limit) and (ad_data<upper_limit) then
      begin
        i:=upper_limit-ad_data;
        reg_data:=i*regulator_spring;
      end;  
    gotoxy(27,20);
    x:=(int(((ad_data)/4095)*1000))/10;
    write(x:5:1);
    gotoxy(63,20);
    x:=(int(((reg_data)/4095)*1000))/10;
    port(.output_da_high_4_bit.):=(reg_data div 256);
    port(.output_da_low_8_bit.):=(reg_data mod 256);
    write(x:5:1);
      if keypress then
        begin
          read(kbd,ch);
        end;
  until (ch='B') or (integer(ch)=27);
end;  (* procedure run_reg *)

                   (*__________________*)
   
procedure init_reg;

begin
  upper_limit:=2457;
  lower_limit:=1638;
  regulator_spring:=5;  
  ad_data_set_punkt:=2048;
  set_punkt:=50;
  proportional_band:=20;
end;  (* procedure init_reg *)

                   (*__________________*)


begin
  init_reg;
  repeat
    reg_menu;
    case ch of
      '1' : begin
              clear_frame;
              gotoxy(2,18);
              write(chr(179));
              gotoxy(77,18);
              writeln(chr(179));
              get_set_punkt;
            end;
      '2' : begin
              clear_frame;
              gotoxy(2,18);
              write(chr(179));
              gotoxy(77,18);
              writeln(chr(179));
              get_proportional_band;
            end;
      '3' : begin
              clear_frame;
              gotoxy(2,18);
              write(chr(179));
              gotoxy(77,18);
              writeln(chr(179));
              kanal;   
            end;
      '4' : begin
              get_set_punkt_afvigelse;
              reg_picture;
              run_reg;
            end;
    end;
    gotoxy(2,18);
    write(chr(179));
    gotoxy(77,18);
    writeln(chr(179));
  until ch='D';   (* (integer(ch)=27) or (ch='C');  *)
  
end;  (* procedure reg_demo *)

procedure daout_adin_demo;
var
 x   : real;

procedure start_daout_demo;

begin
  gotoxy(30,8);
  write('CHANNEL NUMBER:  ',kanal_nr:2);
  gotoxy(30,9);
  write('___________________');
  gotoxy(10,12);
  write('Numeric Value:                               Value %');
  gotoxy(12,22);
  write('ANY KEY TO EXIT TO MAIN-MENU . WAIT FOR LOOP TO BE FINISHED!');
end;  (* procedure start_daout_demo *)
procedure read;
begin
 read_input;
 gotoxy(12,14);
 write(ad_data:5);
 gotoxy(56,14);
 x:=(int(((ad_data)/4095)*1000))/10;
 write(x:5:1);
end;
procedure da_out;

begin
        for output_high_4_bit:=0 to $f do
          begin
            port(.output_da_high_4_bit.):=output_high_4_bit;
            for output_low_8_bit:=0 to $ff do
              begin
                port(.output_da_low_8_bit.):=output_low_8_bit;
                read;
              end;
          end;
end;
begin
clear_frame;
gotoxy(15,11);
write(' DEMO AF DA KANALEN TIL EN AF AD KANALERNE');
kanal;
clear_frame;
start_daout_demo;
repeat
da_out;
  until keypress;
end;

(*_________________________________________________________________*)
procedure pcio_test;
procedure main_menu;  

begin
  gotoxy(10,3);
  write('  CIRCUIT DESIGN PC - I/O         TEST  PROGRAM');
  gotoxy(25,9);
  write('1.  TEST AF KANAL A: INPUT AF DATA          ');
  gotoxy(25,11);
  write('2.  TEST AF KANAL B: OUTPUT AF VILKRLIG DATA');
  gotoxy(25,13);
  write('3.  TEST AF KANAL C: OUTPUT AF VILKRLIG DATA');
  gotoxy(25,15);
  write('4.  TEST AF KANAL C: INPUT AF DATA');
  gotoxy(51,22);
  write('F10 = EXIT to MAIN MENU');
end;  (* procedure main_menu *)
(* Denne procedure omvandler et decimaltal om til et binaert
   tal. det decimale tal skal ligge mellem 0 og 255.
   Variabler der skal overfres er :
        Data : det tal der skal omvandles
         Bin_data : Resultatet                    *)
Procedure bindata(realdata: Real;Var bin_data : Real);

 var
   mellem : real;
   count : Integer;
 begin
  bin_data:=0;
  count :=0;
  mellem:=0;
  repeat
   mellem := Int(realdata/2);
   bin_data := bin_data +((realdata  - (mellem*2))*pwrten(count));
   realdata := mellem;
   count :=count+1;
  until mellem = 0;
 end;

 
procedure find_adress(VAR port_a,port_b,port_c,port_d :INTEGER);

VAR
  svitch_nr    : Integer;

begin
gotoxy(10,3);write('  CIRCUIT DESIGN PC - I/O         TEST  PROGRAM');
gotoxy(15,9); writeln('  Hvilken switch p din adresseomskifter er stillet ON ?');
gotoxy(17,12);writeln('  NR.:       1   2   3   4   5   6   7   8   ');
gotoxy(15,20); write('  Indgiv switchnummer :  '); 
 readln(svitch_nr);
 case svitch_nr OF
  1:  begin port_a:=$300;port_b:=$301;port_c:=$302;port_d:=$303;end;
  2:  begin port_a:=$304;port_b:=$305;port_c:=$306;port_d:=$307;end;
  3:  begin port_a:=$308;port_b:=$309;port_c:=$30A;port_d:=$30B;end;
  4:  begin port_a:=$30C;port_b:=$30D;port_c:=$30E;port_d:=$30F;end;
  5:  begin port_a:=$310;port_b:=$311;port_c:=$312;port_d:=$313;end;
  6:  begin port_a:=$314;port_b:=$315;port_c:=$316;port_d:=$317;end;
  7:  begin port_a:=$318;port_b:=$319;port_c:=$31A;port_d:=$31B;end;
  8:  begin port_a:=$31C;port_b:=$31D;port_c:=$31E;port_d:=$31F;end;
 otherwise
 end; 
end;

procedure write_port;
begin
 repeat
  gotoxy(20,13);write('DECIMAL :             ');
  gotoxy(36,13);readln(data);
 until (data >=0) or (data <=255) ;
 realdata := data;
 bindata(realdata,bin_data);
 gotoxy(20,17);write('Decimal : ',realdata:4:0,'    Binrt   : ',bin_data:9:0); 
end;
procedure read_port_a;

begin
clear_frame;
gotoxy(15,9);write('Input fra port A p adresse :',port_a:5);
gotoxy(20,17);write('Indlst data er :');
gotoxy(45,22);write('ANY key to MAINMENU');
repeat
 realdata:=port(.port_a.);
 bindata(realdata,bin_data);
 gotoxy(20,17);write('Decimal : ',realdata:4:0,'    Binrt   : ',bin_data:9:0); 
until keypress; 
end; (*procedure read_port_a*)

procedure write_port_b; 

begin
clear_frame;
gotoxy(45,22);write(' ENTER 0 FOR MAIN MENU ');
gotoxy(15,9);write(' Hvilket tal skal skrives ud p porten ?  ');
repeat
 write_port;
 port(.port_b.):=data;
until data = 0;
end; (*procedure write_port_b*)

procedure write_port_c;

begin
port(.port_d.):=144;
clear_frame;
gotoxy(51,22);write(' 0 FOR MAIN MENU ');
gotoxy(15,9);write(' Hvilket tal skal skrives ud p porten ?  ');
repeat
 write_port;
 port(.port_c.):=data;
until data= 0 ;
end; (*procedure write_port_c*)

procedure read_port_c; 
begin
 clear_frame;
 gotoxy(15,9);write('Input fra port C p adresse :',port_c:5);
 gotoxy(45,22);write('ANY key to MAINMENU');
repeat
realdata:=port(.port_c.);
 bindata(realdata,bin_data);
 gotoxy(20,17);write('Decimal : ',realdata:4:0,'    Binrt   : ',bin_data:9:0); 
until keypress; 
end; (*procedure read_port_c*)


begin (*hovedprogram pciotest *)
main_frame;
find_adress(port_a,port_b,port_c,port_d);
repeat
 clear_frame;
 main_menu;
    repeat
      getkey;
    until ch in (.'1','2','3','4','D'.);
    case ch of
      '1' : read_port_a;
      '2' : write_port_b;
      '3' : write_port_c;
      '4' : read_port_c;
    otherwise  
    end;
   if ch<>'D' then
      clear_frame;
  until ch ='D';
end;  

(* MAIN PROGRAM *)

begin
  kanal_nr:=0;
  cursor(false);
  main_frame;
  repeat
    main_menu;
    repeat
      getkey;
    until ch in (.'1','2','3','4','5','C'.);
    case ch of
      '1' : ad_demo;
      '2' : da_demo;
      '3' : reg_demo;
      '4' : daout_adin_demo;
      '5' : pcio_test;
    end;
    if ch<>'C' then
      clear_frame;
  until ch='C';
  write(clrhom);
   cursor(true);
end.  
