#include <stdio.h>
#include <dos.h>
#include <sound.h>
/* Dick Dixon April 1992                                                */
/*                                                                      */
/* A crude and simple diagnostic for the Paramid MIDI interface.        */
/* Please do not pass judgement on my programming style on the basis    */
/* of this program ;-}                                                  */
/*                                                                      */
/* The present code defaults to a port address of 0x378 (..9, ..A)      */
/* for the printer interface.  An alternative address can be supplied   */
/* on the command line.                                                 */
/*                                                                      */
/* This is a simple data loop program, which for normal operation       */
/* requires that a midi cable is connected between out and in on the    */
/* Paramid unit.  Every <many> bytes of data, an overrun error is forced*/
/* to check that the interface correctly reports it.                    */
/*                                                                      */
/* Modification to provide scope loops for various purposes should be   */
/* trivial.   Notice that there is no attempt to verify that the        */
/* interrupt mechanism is working. Timing in all cases is via simple    */
/* count-down loops, so may need adjustment if you have a fast          */
/* machine.                                                             */
/*                                                                      */
/* This code was written for Zortech C level 2.1.  Conversion to        */
/* Turbo or Microsoft C should be trivial (though why bother, with      */
/* such a short program?).                                              */


/* put the I/O port definitions out in front */
#define base 0x378
/* possible alternatives are 278, 3BC.  The next two should be OK on all machines. */
#define ctl data + 2
/* control port */
#define sts data + 1
/* status port */



/*=================================================================================*/
int main(int argc, char * argv[])
{

	int data = base, i = 0, p, q, r, s, t;
	int f = 0, err = 0;

	/* if a command-line parm was provided, should be I/O port number */
	if (argc > 1)
		if (sscanf(argv[1], "%p", &data) < 0)
			return 1;

	/* main loop.  Keep going until a keyboard key is hit.  */
	while (!kbhit())
	{
start:
		outp(ctl, 0);			/* clear the control port */
		s = inp(sts);			/* read the status port for UART ready */
		t = 10000;			/* a counter for maximum wait time */

		/* wait for UART ready (bit 7 of status == 0) or timeout */
		while ((s & 0x80) && (--t))	
			s =inp(sts);		/* read status each time around loop */

		/* if UART is not ready, notify and report status */
		if ((s & 0x80))
		{
			printf("Failed to come ready - sts = %2.2x\n", s);
			return 1;
		}

		/* else all seems OK - send a byte out of the MIDI port */
		outp(ctl, 0);			/* clear the control port */
		outp(base, i);			/* apply a data pattern to the data port */
		outp(ctl, 1);			/* strobe the UART... */
		outp(ctl, 0);			/* ...and clear the strobe */

		/* once every 65536 bytes, force an overrun error by sending 2 bytes
			without reading */
		if (!f)	/* check force-error flag */
		{
			/* usual wait-ready loop */
			s = inp(sts);
			t = 10000;
			while ((s & 0x80) && (--t))
				s =inp(sts);
				if ((s & 0x80))
			{
				printf("Failed to come ready - sts = %2.2x\n", s);
				return 1;
			}
			/* output the same byte as the main line code, in the same way */
			outp(ctl, 0);
			outp(base, i);
			outp(ctl, 1);
			outp(ctl, 0);
		}
		

		/* we have output one (or two) bytes; now wait for one to come back to
			the UART via the data loop cable */
		s = inp(sts);			/* fetch the status */
		t = 100;			/* note shorter timeout for data wait */

		/* relevant status bit is bit 5 - note that status is only presented on the
			status port so long as the control port bits 1 & 2 are zeroed */
		while (!(s & 0x20) && (--t))
			s = inp(sts);

		/* did we get a byte? */
		if (!(s & 0x20))
		{
			/* nope - complain and restart */
			printf("Failed to receive data - sts = %2.2x\n", s);
			goto start;
		}

		/* are we expecting a forced overrun error ? */
		if (f)
		/* no error was anticipated */
		{
			/* so report one if it is present */
			if (s & 0x18)		/* mask for framing and overrun error bits */
				printf("UART RX data error sts = %2.2x\n", s);
		}
		else
		/* we expect to receive an overrun error */
		{
			/* like an ordinary wait-ready loop, but wait for overrun to 
				present */
			s = inp(sts);
			t = 10000;
			while (!(s & 0x18) && (--t))
				s = inp(sts);

			/* If we didn't get one, complain... */
			if (!(s & 0x18))
			{
				printf("Failed to receive overrun - sts = %2.2x\n", s);
				return 1;
			}
		}
			
		
		/* OK, we have some data on the interface.  Read it in 2 gasps. */
		outp(ctl, 2);			/* set bit 1 - read hi nybble */
		q = inp(sts);			/* get the nybble */
		outp(ctl, 4);			/* set bit 2 - read lo nybble & reset DRR */
		p = inp(sts);			/* get the nybble */
		outp(ctl, 0);			/* reset ctl reg so status is presented */

		/* each data nybble is presented via bits 6..3 of the status register.
			Assemble a data byte from the two nybbles */
		r = (((p & 0x78) >> 3) | ((q & 0x78) << 1));

		/* check the data - we are looped Tx to Rx, should be identical... */
		if (r != i)
		{
			printf("Data error: sent %2.2x, received p = %2.2x, q = %2.2x\n\
received %2.2x\n", i, p, q, r);
			err++;			/* keep a count of errors */
		}

check:

		/* after we read the lo nybble, the UART DRR (data receive ready) status
			should clear.  Check that it's working: we should not need to 
			wait for the status to go, even on a fast machine. */
		s = inp(sts);
		if ((s & 0x20) || (s & 0x18))	/* Funny way to check for DRR, FE or OE */
		{
			/* report any strange bits we saw */
			if (s & 0x20)
				printf("Failed to clear rx data status - sts = %2.2x\n", s);
			if (s & 0x18) 
			{
				/* were we expecting an error? */
				if (f)		/* no - this is a Bad Thing */
					printf("UART RX error sts after input = %2.2x\n", s);
				else		/* yes - we made an overrun happen */
				{
					printf("UART RX error status reported ok - ");
					if (s & 0x10) printf("OE ");
					if (s & 0x08) printf("FE ");
					printf("\n");
				}
			}
				
			/* since we got an error, reset the UART and verify that the error
				bits go away. */
			outp(ctl, 6);		/* bits 1 & 2 both set == reset UART */
			for (t=0; t<1000; t++){}	/* wait a bit */
			outp(ctl, 0);		/* revert to normal ctl port = 0 */
			for (t=0; t<1000; t++){}	/* wait a bit more */
			goto check;		/* go test the error status now */
		}

		/* cycle the generated data around all possible 1-byte values */
		i = (++i & 0xff);

		/* every time the value comes back to 0, sound a tick so that it's
			apparent from across the workshop that it's happily running. */
		if(!i)
			sound_click();

		/* increment pass count so that we know when to force an error */
		f++;

	}

	/* when exited via normal keypress, report total data mismatch errors seen.
		Does not presently count weird statuses or missed overruns etc. */
	printf("Total detected data errors = %i\n", err);

} /*main*/

