Newsgroups: comp.dcom.modems
From: blochc@nickel.ucs.indiana.edu (charles bloch)
Subject: Re: v32, v.32bis, v.42bis, MNP5 -- what are they?
Message-ID: <C1D04u.6M5@usenet.ucs.indiana.edu>
Keywords: v32, v.32bis, v.42bis, MNP
Organization: Indiana University
Date: Sun, 24 Jan 1993 13:00:30 GMT
Lines: 685

kayman@csd-d-5.Stanford.EDU (Robert Kayman) writes:

>That is, please explain to me what v32, v.32bis, v.42bis, and MNP4 and 5
>are.  I understand some are for error correction and some are for data

I saw this posted here some time ago, but many people seem to be
asking questions I believe it covers (at least in part).  So no one
unnecessarily duplicates any of this work, I am reposting it.  cb.


/* ---------- "comp.dcom.modems lexicon" ---------- */
Here is version 1.4 of the lexicon.

Comp.dcom.modems lexicon, by Eamonn McManus <em@dce.ie>.
Contributions by:
  Charles Bryant <ch@dce.ie>
  Ronald S H Khoo <ronald@robobar.co.uk>
  David Lesher <wb8foz@mthvax.cs.miami.edu>
  Chip Rosenthal <chip@chinacat.unicom.com>
  Colin Plumb <ccplumb@rose.uwaterloo.ca>
  Toby Nixon <tnixon@hayes.uucp>
  Eric Gundrum <gundrum@sv.portal.com>
  Evan Gamblin <0001847804@mcimail.com>
  George Horosh <goshah@glas.apc.org>
  Maria Iakimets <masha@glas.apc.org>

This lexicon is intended to provide a basic introduction to terms
     used in modem technology.  In the interests of brevity, some
     technical    details   and   qualifications   are   omitted.
     Corrections,  additions,  and suggestions are welcome;  send
     them to <em@dce.ie>.

This document IS NOT copyrighted and may be used freely.

Words in  angle brackets,  like <this>,  denote cross-references.
     The following terms are defined or discussed here:

     ACK, Acoustic  Coupler,  ASCII,   Asymmetric,   Asynchronous
     transmission,   Attenuation,   AT  commands,  Back  channel,
     Bandwidth,  Baud, BCC, Bell standards, BERT, bit, Bps, Byte,
     Carrier,  CCITT, Command File, Common Carrier, Conditioning,
     Compression, CRC, CTS, C-weighting, Dataphone, dB, dBm, DCD,
     DCE,  Delay Distortion,  Dibit,  DPSK,  DSR, DTE, DTMF, DTR,
     EBCDIC,   Echo,   EIA232,   Emulation,   Error   Correction,
     Equalazer,  External modem,  Fall back,  FAX,  Flow Control,
     Four wire,  Frame, FSK, Full duplex, Half duplex, Handshake,
     Hayes,  HDLC, Hertz, Hybrid Transformer, Interface, Internal
     modem,  IPARS,  ISO,  Kermit,  Latency,  Leased  line,  LED,
     Limited distance modem,  Link, Loadig coil, Local loop, LRC,
     Mark,  MIL-STD-188-C,  MNP,  Modem  eliminator,  Modulation,
     Multiplexer,  NAK,  Network,  Node,  Null modem, Octet, OOK,
     OSI,  Packet,  Packet switching,  Parallel, Parity bit, PBX,
     PEP,  Phase modulation,  Post processing, Protocol, Protocol
     converter, PTT, Public Telephone Network, QAM, Quadbit, RAM,
     ROM,  RS-Standards,  RS-232, RTS, Script file, SDLC, Serial,
     Space,   Speed   buffering,   Spoofing,   Start/Stop   bits,
     Statistical  multiplexer,  Store  and Forward,  Synchronous,
     Synchronous  transmission,  Tralblazer,   Turnaround   time,
     V.standards,    V.series,   Window,   XMODEM,   X.standards,
     XON/XOFF,                                            ZMODEM.
     ------------------------------------------------------------



ACK,Acknowledgment -    A    communication    control   character
     transmitted by a receiver indicating that  the  massage  was
     reseived correctly.

Acoustic Coupler  -  A  device  converting  electrical  to  audio
     signals and vice versa,  allowing the connection of a  modem
     to  the <Public Telephone Network> by means of any telephone
     headset.

ASCII - The American Standart Code for Information Interchange is
     an 8-<bit> code accepted as a data communication standart in
     North  America  to  achieve   compatibility   between   data
     services.  ASCII  uses 7 <bits> for information and the 8-th
     <bit> for parity.

Asymmetric -  Faster in one direction than the other.  The faster
     direction is called the main channel and the slower  is  the
     back  channel.  See  <V.23> and <PEP> for examples.  Both of
     these allow the directions of the channels to be  exchanged;
     see <turnaround time>.

Asynchronous Transmission  -  Transmission  in  which  the   time
     intervals  between  teansmitted charecters may be of unequal
     length.  Transmission is controlled by the  start  and  stop
     <bits>  at  the  beginning  and end of each character.  Also
     referred to as start-stop  transmission.  Used  of  <serial>
     connection. See <synchronous>.

AT commands - See <Hayes>. (Unrelated to the PC/AT.)

Attenuation -  Decrease in the signal amplitude.  If the decrease
     is a function of frequency than the  <attenuation>  relative
     to  <attenuation>  at  1000  <Hz>  is  called  <attenuation>
     distortion.

Back channel - See <asymmetric>.

Bandwidth -  Range  of   frequencies   which   are   subject   to
     <attenuation> of typically less than 3 <db>.

Baud -  A  unit of <modulation> rate. Equal to transmission speed
    divided by the number of <bits> per signal element.Frequently
    confused with <bits> per second<bps>.
     
BCC - Block Check Character,  is used for error checking  and  is
     the   result   of   a  transmission  verification  algorithm
     accumulated over a transmission  block  during  <synchronous
     transmission> of data.

Bell standards - <Modulation> techniques used in  North  America.
     Bell 103 is a 300<bps> standard;  Bell 22 is 1200<bps>.  Not
     allowed in some European countries. See <V series>.

BERT -<Bit> error rate test set.  An instrument used for checking
     quality of data transmission.

Bit - A binary digit,  can be  0  or  1,  the  smallest  unit  of
     information.

Bps, Bits per second - Unit of transmission  speed  is  equal  to
     quantity  of  phisicaly  transmited  <bits> per second.  See
     <baud>.

Byte - A  sequence  of  8  <bits>,  usially  corresponding  to  a
     character.

Carrier -  Roughly  speaking,  the tones a modem sends when it is
     not sending data.  Data are then variations in these  tones.
     When  the  remote modem stops emitting <carrier>,  the local
     modem can assume it has hung up,  unless the local modem  is
     now the sending party in a <half duplex> connection.

CCITT - A French acronym  for  the  International  Telegraph  and
     Telephone  Consultative Committee,  which sets standards for
     telephone communication among other things.  Their standards
     (or  `recommendations'  as they have it) are published every
     so often in a set of `fascicles',  whose colour varies  with
     the  year.  The current set is the `blue books' published in
     1988.  The  standards  are  copyrighted,  so  they  are  not
     available electronically. You should be able to find them at
     any good engineering library. See <V series>.

Command File  -(See  <Script file>) User-written program requied by
    the communications software to make a data phone call. Contains
    parameters such as the phone number, transmission speed, number
    of data/stop <bits>, and parity.

Common Carrier  - A public owner of transmission facilities which
     has the obligation to provide such facilities to the  public
     on demand.

Conditioning -  Special  teatment  of  transmission facilities to
     reduce their <attenuation> and <delay distortions>.

Compression -  Reduction  of  the  size  of  data  by  exploiting
     redundancy.  Many modern modems incorporate  use  <MNP5>  or
     <V.42  bis>  to  compress data before they are sent over the
     phone line.  For this to be effective, the modem must be fed
     data   at   a  higher  speed  than  the  phone  line  speed.
     <compression> is most useful for interactive sessions in the
     modem.  If  you  are sending files,  compressing them on the
     computer before sending is usually more effective.  In  this
     case,  make  sure  that  the  modem  is  not  also trying to
     compress, because already-compressed data will become bigger
     if re-compressed. For <compression> to work, it is essential
     that the data are sent over an error-free <link>.  Otherwise
     the  modems  could get out of sync and hopelessly garble the
     data.  Since  common  <error   correction>   protocols   are
     <synchronous>,  there  is usually a throughput gain there as
     well.  Manufacturer  claims  that  <MNP5>  provides  a   2:1
     reduction in size,  or that <V.42 bis> provides 4:1,  should
     be taken with a grain  of  salt.  They  are  only  true  for
     suitable data. See <MNP5> and <V.42 bis>.

CRC -  Cyclic Redundancy Check,  a checking method used to detect
     errors, in which the numeric binary value of a block of data
     is divided by a constant divisor.  The quotient is discarded
     and the remainder serves as check sequence.

CTS - Clear to send. A signal from <DCE> to <DTE>. Typically used
     for <flow control>.

C-weighting - Frequency <attenuation>  shaping  of  certain  test
     instruments to simulate a frequency response of human ear to
     various components of the audio spectrum.

Dataphone - A trademark of AT&T applied to various modems.

dB - Decibel - logarithmic ratio.  Generally  applied  to  power,
     voltages or curents.

dBm - Decibel above 1 mW - unit of electrical power.

DCD - Data <carrier>  detect.  A  signal  from  <DCE>  to  <DTE>,
     indicating  that  a  <carrier>  tone is being heard from the
     remote modem. See <DSR>.

DCE - Data circuit-terminating equipment.  Whatever is  connected
     to a phone line. Effectively, a modem.

Delay Distortion - Characteristic  of  the  transmission  medium,
     affects  the transmission speed of frequency components of a
     data signal. Results in signal distortion.

Dibit -  A  sequence  of  two  <bits>  assosiated with one signal
     element.

Differential Phase Shift Keying (DPSK) - <Modulation> method used
     by  the  Bell  212A  modem  based on detection of successive
     relative phase changes of the data signal.

DSR - Data set ready.  A signal from <DCE> to  <DTE>,  indicating
     that   a  connection  is  in  progress.  For  <half  duplex>
     connections,<DSR> will be  on  during  the  entire  session,
     while <DCD> will be on only when the modem is receiving.

DTE - Data terminal equipment.  The  computer  or  terminal  that
     talks to a modem locally.

DTMF - Dual tone multiple frequency. The standard method for tone
     dialling.

DTR -  Data  terminal  ready.  A  signal  from  <DTE>  to  <DCE>.
     Sometimes  used  for  <flow  control>,  though <RTS> is more
     usual nowadays.  Typically,  dropping <DTR> will  cause  the
     modem to hang up.

EBCDIC - Extended  Binary  Coded  Decimal  Interchange  Code,  an
     8-<bit>  code used mostly by IBM.  Enables representation of
     graphics and control code characters.

Echo -  Data  or  voice  reflected  back  to  the  transmitter by
     impedance mismatches along the transmission path.

EIA232 - Electronic  Industries  Assosiation  -  a  group  of  US
     manufacturers recodnized as the standards writing agency for
     communications equipment, See also <RS232>.

Emulation - Use of the system to imitate all functions of another
     system.  The  emulating system will operate under control of
     any software written for the emulated system.

Error correction  -  Communication  between  the modems to ensure
     that the data sent by one end are the same as those received
     by  the  other,  even  in the presence of noise on the line.
     Typically this is done by adding checksums to the  data.  If
     the  received  data don't match their checksum the receiving
     modem   asks   for   them   to   be   sent    again.    Like
     <compression>,<error correction> in the modem is most useful
     for interactive use.  When sending files,  it  is  generally
     best  to  let  the  computers at each end do the correction,
     using a <protocol> like <Kermit>  or  <uucp>.  However,  the
     ability  of  <MNP4>  and <V.42> to send data <synchronously>
     may make it worthwhile to use them. See also <spoofing>.

Equalizer - Device to compensate  for  distortion  introduced  by
     transmission facilities.

External modem - See <internal modem>.

Fall back  -  The  ability of a modem to operate at a lower speed
     than its maximum,  used  either  for  compatibility  with  a
     different  type  of modem (e.g.  <V.22 bis> can fall back to
     <V.22>) or to reduce the number of errors over a <link> that
     cannot carry the fastest speed.

FAX - Discussions on FAX  should  usually  be  in  the  newsgroup
     comp.dcom.fax.   This   entry  names  some  of  the  <CCITT>
     standards used by Group 3  FAX.  Parameter  negotiation  and
     session  control  are  done  using  <V.21>;  the formats are
     defined by T.3. Images are sent using <V.27 ter> and <V.29>;
     the format is defined by T.4. The new <V.17> standard may be
     available in recent  machines.  FAX  transmission  is  <half
     duplex>.

Flow control - Ensuring that a unit, whether mode or computer, is
     not supplied with more data than it can cope with.  The unit
     must have some way to signal to  the  data  source  to  stop
     sending.  Ideally,  every  unit  on  the  communication path
     should have a way to manage <flow control> with  its  peers;
     otherwise  if  available  buffer space is exceeded some data
     may be lost.  Between <DTE> and <DCE> the possibilities  are
     <RTS>/<CTS> and <XON/XOFF>. Between two <DCE>s <XON/XOFF> is
     the only possibiliyy. However, if a <protocol> such as <MNP>
     is being run between the modems, this will contain provision
     for <flow control>.If you can guarantee that the <DTE>s will
     always  be  able  to accept data,  you should not need <flow
     control> between the <DCE>s.

Four wire  -  A  <leased  line>  with  separate  connections  for
     transmitting data in each direction.

Frame -  Transmission  data  segment.  In <synchronous> protocols
     data is formatted in blocks or  <frames>  for  transmission.
     Each  <frame> consists of a start flag followed by an adress
     field, control field, data field, <frame> check sequence and
     a stop flag.

Frequency Shift Keying (FSK) - Method of  <modulation>,  where  a
     binary   "0"  generates  one  frequency  and  a  binary  "1"
     generates another frequency.

Full duplex - Able to send data in both directions at once.

Half duplex  - Able to send data in only one direction at a time.
     Some <protocol> is usually used to switch the  direction  as
     needed.

Handshake - Exchange of predetermined signals occuring  when  the
     data connection is first established.

Hayes - Modem manufacturer.  The `Hayes command set' is supported
     by  most  modern  modems.  Hayes  commands look like ATD1234
     (dial 1234) or ATA (answer  the  phone).  The  commands  for
     simple  things  like  this  are  fairly  standard,  but more
     complex things tend to be manufacturer-specific.  A  <CCITT>
     standard for Hayes commands is in preparation.

HDLC -  High  Level  Data  Link  Control.  A  <link>  level <bit>
     oriented <protocol> used in <synchronous transmission>.

Hertz (Hz) - Unit of frequency, equal to cycles per second.

Hybrid Transformer - A special kind of transformer used  to  wire
     transmission  systems  to  separate  the  two  directions of
     transmission.

Interface - A shared boundary between two communications devices,
     e.g.  a  computer,  a  modem,  a  printer or a communication
     channel.

Internal modem  - A modem card that slots into your computer,  as
     opposed to an <external modem>,  which is a  separate  unit.
     <Internal  modem>s  are  usually  cheaper but they have some
     disadvantages.  An <external modem> can  be  used  with  any
     computer;  it  will  have  diagnostic  lights to see what is
     going on;  and it means the phone line is further from  your
     PC and so less likely to conduct lightning strikes into it.

IPARS -   International  Passenger  Airline  Reservation  System.
     Originally developed by IBM for  its  nominal  purpose,  but
     fast becoming a generic term for any airline <protocol>.

ISO -   Internetional  Standards  Organizattion  responsible  for
     development of general <network> <protocol>.

Kermit - A file-transfer <protocol>, available for a wide variety
     of machines.  It contains provisions for  transferring  text
     and binary files over 7- and 8-<bit> connections.

Latency - The delay between data being sent and being received by
     the  far  end.  A  combination  of  transmission  delays and
     <modulation> properties.

Leased Line - A telecommunication channel leased from the <Common
     Carrier>  between  two or more fixed locations.  Charges are
     ussualy a fixed sum per month.

Light Emmitting Diode (LED) - A semiconductor  low  current,  low
     voltage  lamp.  Special LEDs are used as generators of light
     energy for lasers and for fider optics transmission.

Limited Dictance Modem   -   A   device   which   permits   data
     communications over short distances.

Link -  A  transmission  path between two data sets,  channels or
     switching offices.

Loading Coil - Inductance added to a telephone  line  to  improve
     its   frequency   distortion   at   low   frequencies.   Not
     erecommended for data transmission.

Local Loop - A pair of wires connecting the telephone  subscriber
     to the local telephone office.

LRC -  Longitudinal Redundancy Check,  a simple parity check of a
     block of data.

Mark - A signal on a data circuit inditicating a binary "one".

MIL-STD-188-C - A  US  military  standard  similar  to  RS-232-C,
     except that the voltage levels are different.


MNP -  Microcom  Network  Protocols.  A  set  of   modem-to-modem
     protocols that provide <error correction> and <compression>.
     The commonly encountered ones are these:

  MNP2. <Error correction> using <asynchronous transmission>.
  MNP3. <Error  correction>  using   <synchronous   transmission>
     between   the   modems   (the  <DTE>  <interface>  is  still
     <asynchronous>).  Since each eight-<bit> <byte> takes  eight
     rather  than ten <bits> to transmit there is scope for a 20%
     increase in throughput.  Unfortunately the  MNP3  <protocol>
     overhead is rather high so this increase is not realised.
  MNP4. Introduces `data phase optimisation',  which improves  on
     the   rather  inefficient  <protocol>  design  of  MNP2  and
     MNP3.<Synchronous> MNP4 comes closer to  achieving  the  20%
     throughput increase mentioned above.
  MNP5. Simple  data  <compression>.  Dynamically  arranges   for
     commonly  occurring  characters to be transmitted with fewer
     <bits> than rare characters.  It takes account  of  changing
     character frequencies as it runs.  Also encodes long rnns of
     the same character specially.  Typically compresses text  by
     35%; with 20% for MNP4 this reduces data by almost 50%.

Modem Eliminator - Sometimes used to describe a limited  distance
     modem, sometimes to describe a "null" modem.

Modulation - Converting a data stream into sounds to be sent down
     a phone line.  The opposite is demodulation.  `Mddem' stands
     for modulator/ demodulator.

Multiplexer -   A  device  to  combine  several  signals  into  a
     composite data stream for economic transmission.  Techniques
     employed  are  frequensy  division  (FDM)  and time division
     (TDM).

NAK - Negative Acknowledment,  a communication control  character
     indicating that some information was received incorrectly.

Network -  A  series  of  point  interconnected  by communication
     channels,  often on  switched  basis.  Networks  are  either
     common  to  all  users  or  are privately leased from common
     carriers for exclusive use by a customer.

Node -  A  point in a transmission system,  where lines or trunks
     from many system meet.  Also the point in a <network>, where
     switching occurs.

Null Modem  -  A  cable  or  dual-sided  plug  which  allows  the
     connection of two <DCE>s or two <DTE>s.

Octet - Standard <CCITT> term for a group of eight <bits>,  i.e.,
     what the rest of us think of as a <byte>.  They avoid `byte'
     because some strange machines have <bytes> with more or less
     than eight <bits>.

OOK -  On/Off Keying,  the simplest form of <modulation> consists
     of turning the signal on or off.

OSI -  Open  System  Interconnection.Standardized  procedures for
     exchange of information among terminal  devices,  computers,
     people,  <networks>, processes, etc., that are "open" to one
     another for this purpose by virtue of their  mutual  use  of
     these  procedures.  OSI  is  being  developed  by  <ISO> and
     <CCITT>. It will provide a common basis for the coordination
     of   standards   development   for  the  purpose  of  system
     interconnection whithin a seven layer model.

Packet - Data drouped for  transmission  through  a  public  data
     <network> such as PSTN and X.25 <network>.

Packet Switching - Transfer  of  data  by  means  of  addressable
     <packets>, where a channel is only occupied for the duration
     of transmission of the <packet>. The channel is then avaible
     for  transmission  of  other  <packets>.  In  contrast  with
     circuit switching,  the data  <network>  determines  routing
     during, rather then prior to, the transfer of a <packet>.

Parallel - Sending several <bits> at a time, usually 8, each over
     a separate wire. Some modems have a parallel connection from
     <DTE> to <DCE>.

Parity <bit>  -  An  eighth  <bit>  added  to  the  seven  <bits>
     representing  a  character,  so  that  the  total  "one"  or
     "<mark>"  <bits>  in a character including the parity <bit>,
     will be either even,  for  even  parity,  or  odd,  for  odd
     parity.

PBX or  PABX  -  Private  Branch  Exchange,  telephone  switching
     service usually at a customer's premises.

PEP - A proprietary <modulation> and <error correction> technique
     devised by Telebit and used in their Trailblazer modems.  It
     can achieve  throughput  of  9600<bps>  or  better,  and  is
     reported to be able to sustain noisy connections better than
     <V.32>. However, it is <asymmetric> a with a very slow <back
     channel>   and  a  long  <turnaround  time>  and  <latency>.
     <Protocols> with small <windows>  work  very  poorly  unless
     <spoofing> is used. Trailblazers can spoof <uucp>, <Kermit>,
     and <XMODEM>.

Phase Modulation - Mithod of <modulation>,  where  a  binary  "0"
     generates  one  phase  value  and  the  binary "1" generates
     another frequency.  Phase values are frequently assigned  to
     <dibits> or <quadbits>, rather than to single <bits>.

Post Processing  -  The ability of <protocol> analyzer to perform
     data analisis on data contained in  a  data  capture  buffer
     just as if the data were arriving in real time.

Protocol -  A  formal set of conventions governing the format and
     control of inputs and  outputs  between  two  communications
     devices or processes.

Protocol Converter  -  A  device  for  translating  output of one
     computer or terminal into formats which can  be  interpreted
     by another computer or terminal.

PTT -  General term for the national organisation(s) in charge of
     telephone and postal communications.

Public Telephone Network - Switched telephone <network>  operated
     by the <Common Carrier>.

Quadrature Amplitude  Modulation (QAM) - <Modulation> method used
     by  high  speed  modems  combining  amplitude   and   <phase
     modulation> of the data signal.

Quadbit -  A  sequence  of four <bits> associated with one signal
     element.

RAM - Random Access Memory,  used to store temporary data in  the
     computer.

ROM -  Read  Only Memory,  used to store permanent data which can
     not be changed.

RS Standards - US Industry standards for interfacing computers to
     data  communications  equipment  developed by EIA.  The most
     popular <interface> standard in the US is the RS-232-C.

RS232 -  The  usual  connection  between  <DCE>  and  <DTE>,  now
     properly called <EIA232>.  It allows for 25 signals, most of
     which are not  used  on  typical  connections.  The  minimum
     needed  signals  are  ground,  TxD (transmit data),  and RxD
     (receive data).  Typically modem  control  lines  <DCD>  and
     <DTR>  and  flow  control  lines <RTS> and <CTS> will also b
     used. See <V.24>.

RTS,Request to send - A signal from <DTE>  to  <DCE>.  In  modern
     modems,  this  is  generally  used for <flow control>;  when
     <RTS> is off the modem will not send data to  the  terminal.
     In <half duplex> connections,  <RTS> may mean that the <DTE>
     has data to send, so the <DCE> should stop sending to it and
     assert <CTS>.

Script File  -(See  <Command file>) User-written program required
     by the communications software to guide the data phone  call
     after a connection has been established. Contains parameters
     such as the logon sequence, password, and menu selection.

SDLC -  Synchronous  Data  Link  Control,  a  <synchronous>  data
     transmission <protocol>.

Serial - Sending one <bit> at a time. Opposite of <parallel>.

Space - A binary "zero", opposite of "<mark>".

Speed buffering  -  Early  modems  had very simple hardware which
     modulated data from the terminal  directly  onto  the  phone
     line.  This meant that the terminal speed and the line speed
     had to be the same. Modern modems allow them to be different
     (speed  buffering),  but unfortunately the old assumption is
     wired into many communications programs, so modems also have
     to  provide  the  ability to change the erminal speed to the
     same as the line speed when a connection is established.  If
     the  terminal  speed  is  faster than the line speed,  <flow
     control> to the terminal will usually be needed.

Spoofing - <Protocol>  spoofing  is  used  by  Trailblazers  (see
     <PEP>).  The  modem  knows  what <protocol> you are using to
     transfer files to the far end.  It pretends to be the remote
     computer  and acknowledges the local data as soon as it gets
     them.  The two Trailblazers then conspire to  get  the  data
     safely to the far end.

Start/Stop Bits  -  Special  character-delimiting  <bits  used in
     <asynchronous transmission>.

Statistical Multiplexer   -    Multiplexer    equipment,    which
     dynamically  allocates  transmission capacity to only active
     channels, thus allowing better channel utilization than with
     regular <multiplexer>.

Store and Forward  -  A method of transmission in which messages
     received from one user are stored at intermediate points and
     retransmitted to other users whenever a transmission path is
     available. Used in <packet> switching <networks>.

Synchronous - Used of a <serial>  connection  where  <bytes>  are
     sent  in  a  continuous  stream.  Some sort of <protocol> is
     needd to flag the case where no <bytes> are available to  be
     sent.

Synchronous Transmission  -  Method  of  communication  in  which
     synchronization  between  the  transmitter  and  receiver is
     achieved  by  sending  timing  signal  independent  of   the
     transmitted   characters.   Timing  can  be  common  to  all
     <network> stations or can be included in each block of data.

Trailblazer - See <PEP>.

Turnaround time   -   The  time  taken  in  a  <half  duplex>  or
     <asymmetric> <link> to reverse the direction of communicaton
     uucp. Unix-to-Unix copy. This is the name of a Unix command,
     but it is now also used to refer to the <protocols> used  by
     it  to  transfer  files  between Unix machines.  There are a
     number of such <protocols>,  and  the  two  machines  choose
     between  the  ones  supported by each.  Free implementations
     also exist for VMS and MS-DOS.  The newsgroup comp.mail.uucp
     may be more appropriate for discussions.

V. stsndard - A series of voice grade recommendations (standards)
     developed by <CCITT> for interfacing and modem standards.

V series  - A set of standards published by the <CCITT> for `Data
     Communication over the  Telephone  Network'.  The  following
     standards describe the important <modulation> techniques:

  V.17: 14400<bps> <half duplex> with <fall back> to  12000<bps>,
     9600<bps> and 7200<bps>.
  V.21: 300<bps>.
  V.22: 1200<bps>, with <fall back> to 600<bps>.
  V.22 bis: 2400<bps>, with <fall back> to V.22.
  V.23: 1200<bps>  with 75<bps> <back channel>,  with <fall back>
     to 600<bps>/75<bps>.
  V.27 ter:  4800<bps>  with  <fall  back> to 2400<bps>,  used by
     <FAX>.
  V.29: 9600<bps>  <half  duplex>  or <four wire> (used by <FAX>)
     with <fall back> to 7200<bps> and 4800<bps>.
  V.32: 9600<bps> with <fall back> to 4800<bps>.
  V.32 bis: 14400<bps> with <fall back> to 12000<bps>, 9600<bps>,
     7200<bps> and 4800 <bps>.

  Other standards you may encounter:

  V.24: connection between <DCE> and <DTE>.  Effectively the same
     as <RS232>,  though V.24 only specifies the meaning  of  the
     signals, not the connector nor the voltages used.
  V.25 bis: a cryptic command language for modems.
  V.42: <error  correction>  with <asynchronous> to <synchronous>
     conversion.
  V.42 bis:   data   <compression>  using  a  Lempel-Ziv  related
     technique,  which  detects  frequently  occurring  character
     strings  and  replaces them with tokens.  This is similar to
     Unix compress.  Typical <compression> for  text  is  50%  or
     better;  with nearly 20%  gain from <synchronous> conversion
     this gives reduces transmission time by almost 60%.

Window - Most  <protocols>  divide  the  data  to  be  sent  into
     `<packets>'.  To  eliminate  delays several <packets> may be
     sent before any one is acknowledged. If this is allowed by a
     <protocol>, the <window> is the number of <packets> that can
     be sent before an <acknowledgement> is received.

XMODEM -  A  primitive  file-transfer  <protocol>.  It  has   the
     property  that  files  must  be  padded to a multiple of 128
     <bytes> long.  It is <half duplex> (has a  <window>  of  one
     <packet>) so it performs badly on fast modems.

X. Standards   -   A   series   of  <CCITT>  recommendations  for
     transmission of data over public data  <network>.  The  best
     known of these standards is X.25.

XON/XOFF -  A  method  of  <flow  control>.  The  XOFF  character
     (<ASCII> 19) is sett to stop  further  characters,  and  XON
     (<ASCII> 17) is sent to resume them. This method is inferior
     to hardware <flow control> using <RTS> and <CTS>,  since  it
     means  that XON and XOFF characters cannot be freely used in
     the data.

ZMODEM - A fast file-transfer <protocol> with <windows>.  It  has
     been  carefully  optimised for a variety of conditions,  and
     has useful features such as the ability to resume an aborted
     transfer where it left off.









-- 
# Chuck Bloch                   ___     blochc@bronze.ucs.indiana.edu   #
# IUCF                         |DoD|    blochc@gold.bitnet              #
# 2401 Milo B. Sampson Lane    |300|    cbloch@venus.iucf.indiana.edu   #
# Bloomington IN 47408          ~~~     IND::VENUS::CBLOCH              #
 