From: oppedahl@panix.com (Carl Oppedahl)
Newsgroups: comp.sys.mac.comm
Subject: Neat stuff about modems
Message-ID: <C0Cyup.EvI@panix.com>
Date: 5 Jan 93 01:59:12 GMT
Organization: Panix Public Access Internet & Unix, NYC
Lines: 1836

Recently a kind soul on panix directed me to a file called TRM20.TXT 
available from Hayes at 1-800-874-2937.  It has all sorts of neat stuff
about the Hayes command set that I have never seen anywhere else.

Among the neatest things I learned are:

 - if you send a command line such as ATZ followed by other things, the 
other things are likely to be lost, because most Hayes-compatible modems 
ignore everything after the Z.

 - how to interpret the strings you get when you send ATI4.

 - how to interpret the string you get when you send ATI0.

 - how to test to be sure you have a cable that does hardware handshaking.

Excerpts follow.

--------------------------------------------------------------------------

TECHNICAL REFERENCE FOR HAYES (TM) MODEM USERS

15 Sept 1992
Version P2.0

Hayes Microcomputer Products, Inc.
P.O. Box 105203
Atlanta, Georgia 30348 U.S.A.

(c) 1990, 1992 Hayes Microcomputer Products, Inc.
All rights reserved.

44-00012 AA H32 (BBS Version)
Note: This version of the "Technical Reference for Hayes Modem Users" is a 
special version edited for bulletin-board downloading. As a plain ASCII 
character file, it therefore cannot contain any of the illustrations and 
graphic elements provided in the printed version.

------------------------------------------------------------------------

I - Internal Memory Tests

The various forms of the I command instruct the modem to query its 
memory for information about itself. The results of these tests are 
frequently used by programmers to determine compatibility with software. 
Because these commands request information about the modem's firmware, 
they are not run when a connection has been established with a remote 
modem.

I0 - Display Product Code

This option reports the product code of the modem to the DTE. The modem 
produces information text dependent upon its highest DCE line speed. The 
responses below are examples:

Result Codes     Description
------------------------------------------------------------------------
300              Smartmodem 300.
120              Smartmodem 1200, Smartmodem 1200B, Smartmodem 1200C, 
                 Smartmodem 1200A.
240              Smartmodem 2400, Smartmodem 2400B, Smartmodem 2400P, 
                 Smartmodem 2400Q, Smartmodem 2400M, V-series Smartmodem 
                 2400, V-series Smartmodem 2400B, V-series Smartmodem 
                 2400 Quad, V-series Smartmodem 2400M, Smartmodem OPTIMA 
                 (TM) 24, Smartmodem OPTIMA 24 + FAX96, 
                 ACCURA (TM) 2400 EC/FAX96.
960              Smartmodem 9600, V-series Smartmodem 9600, V-series 
                 Smartmodem 9600B, V-series ULTRA (TM) Smartmodem 2400, 
                 V-series ULTRA Smartmodem 9600, V-series ULTRA 24 with 
                 Express 96, Smartmodem OPTIMA 9600, Smartmodem 
                 OPTIMA 96 + FAX96, ACCURA 9600 EC/FAX96.  
14400            V-series ULTRA Smartmodem 14400, Smartmodem OPTIMA 144, 
                 Smartmodem OPTIMA 144 + FAX144, ACCURA 14400 EC/FAX144. 
------------------------------------------------------------------------

I1- Display ROM Checksum

The I1 command instructs the modem to calculate the value of the ROM 
checksum. The response is a number, the sum of all of the bytes in ROM.

I2 - Perform ROM Checksum

This command instructs the modem to verify the ROM checksum. Depending 
on whether the ROM checksum has been found to be correct, the modem 
produces text that resembles a result code. The modem memory test 
compares the ROM checksum and tests it against the correct sum, also 
stored in ROM. Rather than returning a numeric value as in I1, the I2 
command generates a result code. When the checksum is valid, the 
response is: OK. When the ROM checksum fails, the modem responds with 
ERROR.

I4 -  Identify Product Features

The capabilities and features of the modem are encoded into a string of 
text that consists of several strings that are ASCII character 
representations of hex numerals which are bit-mapped. The first 
character of each string identifies which bit maps are in that string. 
For example, the "a-string" starts with a lower case "a" and identifies 
most of the basic modem capabilities such as modulation standards 
supported and support for AutoSync.

Since the following tables identify features for Hayes modem products, 
the values included here and the number of strings are subject to change 
and expansion. The maximum length per string is 40 characters.

The I4 text is displayed in the following form:

     a097800C204C264
     bF60410000
     r1031111111010000
     r3000111010000000

surrounded by additional <CR> and <LF> characters as are required by the 
V command option in effect. According to convention, all <CR> and <LF> 
characters are defined by S3 and S4, respectively. The meanings of the 
a, b, r1, and r3 strings currently defined are described below.

I4 "a" String
The first string, the a-string, is composed of the ASCII character "a" 
followed by a series of hexadecimal characters (D1-D16 in this example). 
The bit map for each byte is defined below.

a D1 D2 D3 D4 D5 D6 D7 D8 D9 D10 D11 D12 D13 D14 D15 D16 D17 D18....

------------------------------------------------------------------------
D1, D2     Reserved
D3         Bit 3: Indicates modem based on SM1200FE commands 
           Bit 2: Indicates modem based on SM2400 commands 
           Bit 1: Indicates that modem supports &J commands
           Bit 0: Indicates that modem supports &L commands 
D4         Bit 3: Indicates that modem supports AutoSync (&Q4)
D5         Bit 3: Plug-in board modem product
           Bit 2: Standalone modem product
           Bit 1: Supports &H0 through &H4
           Bit 0: Supports &I0 through &I4 
D6         Bit 3: Reserved
           Bit 2: Supports M4 command
           Bit 1: Supports 32-bit FCS (frame check sequence 
           for AutoSync)
           Bit 0: Supports AutoSync II
D7         Bit 3: Supports V.22 at 1200 bps (B0)
           Bit 2: Supports 212A (B1)
           Bit 1: Supports ASB in V.23 75 bps xmt/1200 bps rcv (B2)
           Bit 0: Supports ASB in V.23 1200 bps xmt/75rcv (B3)
D8         Bit 3: Supports V.23 1200 bps xmt/75 bps rcv (B4)
           Bit 2: Supports V.23 1200 half duplex (B5)
           Bit 1: Supports V.23 75 bps xmt/1200 bps rcv (B10)
           Bit 0: Supports V.23 75 bps xmt/600 bps rcv  (B11)
D9         Bit 3: Supports V.21 100/300 bps (B15)
           Bit 2: Supports ASB in V.23 75 bps xmt/600 bps rcv (B20)
           Bit 1: Supports ASB in V.23 600 bps xmt/75 bps rcv (B21)
           Bit 0: Supports V.23 600 bps xmt/75 bps rcv  (B22)
D10        Bit 3: Supports V.23 600 bps half-duplex (B23)
           Bit 2: Supports V.22bis at 2400 bps (B30)
           Bit 1: Supports V.27ter at 2400 bps (B31)
           Bit 0: Supports V.27ter at 4800 bps  (B40)
D11        Bit 3: Supports V.32 full duplex at 4800 bps (B41)
           Bit 2: Supports Express 96 at 4800 bps (B42)
           Bit 1: Reserved
           Bit 0: Supports V.29 half duplex at 4800 bps (B44)
D12        Bit 3: Supports V.29 half duplex at 7200 bps (B50)
           Bit 2: Supports V.32 full duplex at 9600 bps (B60)
           Bit 1: Supports Express 96 at 9600 bps (B61)
           Bit 0: Reserved
D13        Bit 3: Supports V.29 half duplex at 9600 bps (B63)
           Bit 2: Supports 103 110/300 bps (B16)
           Bit 1: Supports V.32bis (7200/12000/14400 bps)
           Bit 0: Reserved
------------------------------------------------------------------------

------------------------------------------------------------------------
D1, D2      Reserved
D14         0: Reserved
            1: Personal Modem 1200
            2: Personal Modem 2400
            3: Personal Modem 1200 Plus
            4: Personal Modem 2400 Plus
            5: Pocket Edition
D15         Bit 3: Reserved
            Bit 2: Supports $ dial modifier and NO DIALTONE result code.
            Bit 1: Supports S95 Bit 5 for COMPRESSION: result code
            Bit 0: Supports S95 Bit 4 for AUTOSTREAM: result code 
D16         Bit 3: Supports S95 Bit 3 PROTOCOL: result code
            Bit 2: Supports S95 Bit 2 CARRIER result code
            Bit 1: Supports S95 Bit 1 CONNECT/ARQ result code
            Bit 0: Supports S95 Bit 0 CONNECT XXXX (for DCE rate) 
------------------------------------------------------------------------

I4 "b" String

The second string, the b-string, is composed of the ASCII character "b" 
followed by a series of hexadecimal characters (D1-D9). The bit map for 
each character is defined as follows:

b D1 D2 D3 D4 D5 D6 D7 D8 D9....

------------------------------------------------------------------------
D1          Bit 3: V.42 Alternate Protocol Supported
            Bit 2: V.42 LAPM Protocol Supported
            Bit 1: X.25 Protocol Supported
            Bit 0: LAPB (Point-to-point error control) protocol supported
D2          Bit 3: Reserved (should be set to zero)
            Bit 2 MNP (TM) Class 5 supported
            Bit 1: V.42bis supported
            Bit 0: Compression through the X.25 network supported
D3/D4       These combine to indicate the number of AutoStream 
            Type A channels which are supported. The formula 
            (D3*16 + D4) is used. Zero means AutoStream is not supported
D5          Bit 3: Reserved
            Bit 2: Reserved
            Bit 1: Adjustable startup (ASU) is supported
            Bit 0: Negotiates adjustable startup
D6          Bit 3: &K5 not supported
            Bit 2: &K5 supported
            Bit 1: Unidirectional flow control
            Bit 0: S105 N104 parameter supported
------------------------------------------------------------------------

I4 "r1, r2" and "r3" strings

These ID strings allow software to determine the available speeds that 
may be used to send AT commands. The r1-string contains a bit map that 
indicates at which DTE rates the autobaud process is supported.

The presence of the r2-string in the I4 result infers that S87 is 
supported and is required for autobauding at the higher speeds. To 
autobaud at one of the speeds indicated in the r2-string requires that 
S87 be set to match that speed. 

The r3-string is issued if synchronous DTE speeds are supported. The map 
indicates which DTE rates are supported in synchronous modes. Each r-
string begins with the lower case letter "r" and may be followed by as 
many as 39 additional characters, not counting <CR><LF>'s that will be 
used to separate them from other strings. Those 39 additional characters 
are limited to the ASCII-HEX alphabet 0-9 and A-F.

After the two lead-in characters (i.e., r<n>), all subsequent characters 
contain the DTE rate maps. All maps have the same mapping for 
convenience to software. (Refer to the following chart.) Not all bit 
assignments are possible: for example, the split speeds have no meaning 
in the r3 synchronous map and are always filled with zeros.

In r1, if the bit is filled with a 1, the corresponding DTE rate is 
supported for sending AT commands to the device. A zero indicates that 
DTE rate is not supported for AT commands.

In the r3 map, the bits simply indicate which DTE rates are supported 
for synchronous operation on-line. This does not indicate, however, the 
supported rates for synchronous V.25bis commands.

Split speeds if available are marked in the r1 string only when the 
appropriate B command option has been selected. Future expansion of 
these strings may include new speeds that are not in strict ascending 
order.

DTE Rate Bit Map for r1, r2 and r3 Strings

Character    Bit #       DTE Rate
------------------------------------------------------------------------
 3:  1       bit 0       45.45 bps
     2       bit 1       50
     4       bit 2       75
     8       bit 3       75/600 (xmt is 75, rcv is 600) 
 4:  1       bit 4       75/1200
     2       bit 5       110
     4       bit 6       134.5
     8       bit 7       50
 5:  1       bit 8       300
     2       bit 9       450
     4       bit 10      600
     8       bit 11      600/75
 6:  1       bit 12      1200
     2       bit 13      1200/75
     4       bit 14      1800
     8       bit 15      2000
 7:  1       bit 16      2400
     2       bit 17      3000
     4       bit 18      3600
     8       bit 19      4200
 8:  1       bit 20      4800
     2       bit 21      5400
     4       bit 22      6000
     8       bit 23      6600
 9:  1       bit 24      7200
     2       bit 25      7800
     4       bit 26      8400
     8       bit 27      9000
10:  1       bit 28      9600
     2       bit 29      12000
     4       bit 30      14400
     8       bit 31      16800
11:  1       bit 32      19200
     2       bit 33      21600
     4       bit 34      24000
     8       bit 35      26400
12:  1       bit 36      28800
     2       bit 37      31200
     4       bit 38      33600
     8       bit 39      36000
13:  1       bit 40      38400
     2       bit 41      43200
     4       bit 42      48000
     8       bit 43      52800
14:  1       bit 44      56000
     2       bit 45      57600
     4       bit 46      62400
     8       bit 47      64000
15:  1       bit 48      67200
     2       bit 49      72000
     4       bit 50      76800
     8       bit 51      81600
16:  1       bit 52      86400
     2       bit 53      91200
     4       bit 54      96000
     8       bit 55      100800
17:  1       bit 56      105600
     2       bit 57      110400
     4       bit 58      115200
     8       bit 59      reserved ("0")
------------------------------------------------------------------------

W - Negotiation Progress Message Selection

The W command works in conjunction with S95 (where supported) to 
determine which result codes will be used to describe the type of 
connection and protocol, etc., that resulted from handshaking and 
negotiation. 

The W command supports extended result codes in addition to 
the CONNECT result code. When the modem is operated in error-control 
mode (&Q5 is in effect), the W command and S95 together allow the user 
to select these additional result codes:

CARRIER
PROTOCOL
AUTOSTREAM
COMPRESSION
CONNECT

Any result codes enabled by the W command and S95 will be generated in 
the order indicated above. If AutoStream is not being used, no 
AUTOSTREAM result code is returned. Result codes not enabled when the W 
command option is in effect may be turned on by setting certain bits in 
S95. The W command options below are available when S95 is configured 
for any setting other than the factory-setting of 0.

------------------------------------------------------------------------
W0     CONNECT result code reports DTE speed, and if S95=0, then disable
       all extended result codes.
W1     CONNECT result code reports DTE speed, and if S95=0, then enable
       the CARRIER and PROTOCOL extended result codes.
W2     CONNECT result code reports DCE speed, and if S95=0, then disable
       all extended result codes.
------------------------------------------------------------------------

Refer to the S95 bit map description in the next section. Note that 
selecting W0 and setting S95=12 is the same as selecting W1; and that 
selecting W0 and setting S95=1 is the same as selecting W2. S95 cannot 
be configured to force W2 to report DTE speed in the CONNECT result 
code; there is no setting of S95 that will force W1 not to produce the 
CARRIER and PROTOCOL result codes. S95 extends the functionality of the 
W command. The W command with S95=0 (factory setting) maintains 
backwards compatibility with previous Hayes Products. However, 
selecting W0 and setting S95 as required allows you to tailor result 
code characteristics to your own requirements.

------------------------------------------------------------------------

Z - Soft Reset Command

The modem can be reset by issuing the Z command. The command tells the 
modem to go on hook and restore the selected stored profile. Any non-
storable parameters previously set by commands are returned to their 
factory settings. The modem aborts execution of all commands following 
the Z command on the same command line. Subsequent commands on the same 
line are ignored. Refer to the &W command for description of which modem 
parameters are included in a stored profile. Z0 recalls stored user 
profile 0, stored with &W0; Z1 recalls stored user profile 1, stored 
with &W1.

------------------------------------------------------------------------
Z0     Recall stored profile 0
Z1     Recall stored profile 1
------------------------------------------------------------------------

&T19 - Perform RTS/CTS Cable Test

Software can use &T19 to help determine whether the DTE-to-Modem cable 
supports the RTS and CTS signals necessary for hardware flow control, 
which is selected by the &K3 command.

&T19 in the modem works interactively with the DTE to confirm the RTS 
and CTS signal. Only the DTE can detect CTS, and only the modem can 
detect RTS. The modem cannot verify both signals without the active 
involvement of the DTE software.

The modem performs the following algorithm in response to the AT&T19<CR> 
command:

1.  Turns OFF CTS (normally ON).
2.  Starts a 500 millisecond timer.
3.  Monitors RTS for ON and OFF states.
4.  If both states of RTS are detected before the 500ms timer 
    expires then:
      a. Restore CTS to the ON state.
      b. End the test (stop the timer).
      c. Return the OK result code (meaning the modem has 
      verified RTS).
5.  If the timer expires before both states of RTS are detected then:
      a. Restore CTS to the ON state.
      b. Return the ERROR result code (meaning the modem has not 
      verified RTS).

Note: By itself, the modem cannot verify either signal. The DTE must 
toggle RTS during the test in order for the modem to be able to detect a 
change. Also, the DTE should look for CTS to drop during the test to 
verify it is connected.

The following algorithm is used by Hayes Smartcom software in its use of 
the &T19 test:

1.  Issue AT&T19 <CR>

Note: For more predictable timing, do not combine other commands on the 
same command line with &T19. Also, higher DTE port speeds improve the 
timing resolution.

2.  Wait 500ms for CTS to drop. If CTS does not drop in that time, then 
the test fails.

3.  If CTS drop is detected, then:
      a. Drop RTS, wait 50ms, raise RTS, wait 50ms, repeat up to 6 
      times, or until CTS is  detected high.
      b. If CTS is detected returning high before 6 iterations, then the
      test is passing (and an OK result code may be expected soon), or 
      if all 6 iterations did not result in CTS being raised, then the 
      RTS part of the test is failing (and an ERROR result code may be 
      expected after the 500ms timer expires).

4.  Process the result code from the modem. Success during Step 3 above 
    and an OK result code implies that RTS and CTS are both wired 
    correctly. Failure during Step 3 or an ERROR result code implies 
    that either RTS or CTS is not wired in the cable.

Note: Keep in mind that the result code may arrive while you are still 
in Steps 2 and 3 above.

A modification to the software algorithm could be made to permit 
software to detect which signal is missing from the cable. After issuing 
the AT&T19 <CR> command, give the modem about 100ms to drop CTS. Then, 
even if the CTS drop is not detected, proceed to toggle RTS anyway, 
keeping in mind that the CTS part of the test has failed.

RTS/CTS flow control is preferred because it is "out of band", that is, 
it does not consume any of the 256 serial codes from the user data. 
XON/XOFF flow control uses DC1 (ASCII 17) and DC3 (ASCII 19). If RTS/CTS 
is not supported, then Transparent Flow Control (&K5) is the next best 
option (IF the software supports it) because it accomplishes Xon/Xoff 
flow control without interfering with the user data (e.g. during binary 
file transfers).

************************************************************************
1.2     Result Code Listing

This section defines the result codes returned by Hayes modems in 
response to commands.

The table below shows the various formats in which modem responses can 
be presented. Note that the "text" of the info-text may consist of 
multiple lines of text. The formats depicted here only refer to the 
<CR><LF> characters between info-texts and not within them.

------------------------------------------------------------------------
                  V0            V1
Information Text  text          <CR><LF>
                  <CR><LF>      text
                                <CR><LF>
Result Codes      numeric code  <CR><LF>
                  <CR>          verbose code
                                <CR><LF>
------------------------------------------------------------------------

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
1.2.1     Command Response and Call Progress Monitoring
This set of result codes includes responses to commands and call 
progress monitoring responses. They are available to all modems within 
the capabilities of the modem. For example, the result code CONNECT 9600 
is not available to Smartmodem 2400. The factory setting for all high-
speed modems enables the extended set of call progress monitoring (X4). 
When set up in this way, the modem performs and reports full call 
progress monitoring (RING, NO CARRIER, NO DIALTONE, and BUSY). It also 
indicates the speed of the connection (CONNECT 1200 as opposed to simply 
CONNECT). The factory setting for Smartmodem 300, Smartmodem 1200, and 
all others whose highest speed is 1200 bps is basic call progress 
monitoring (X0).

The command response and call progress monitoring result codes are 
defined below:

0 - OK
This result code indicates that a command or command string was 
executed. Note that if more than one command were included on a line and 
an ERROR result code received, this means that one or more of the 
commands was not processed. If one or more were executed properly, but 
even one was invalid, no OK will be issued, only the ERROR.

1 - CONNECT
This result code indicates a connection was made between the DTE and the 
modem. If X4 (extended set of call progress monitoring) were selected, 
the code indicates that a connection from at 0 to 300 bps was made. 
However, if X0 (basic set of call progress monitoring) were selected, 
the connection could be 0-300, 1200, 1200/75, 75/1200, 2400, 4800, 7200, 
9600, 14400, 19200, or 38400 bps. If the modem is not operating in 
error-control or ASB mode, this is the same as the line speed. See other 
CONNECT messages and CARRIER messages.

2 - RING
This result code indicates the modem has detected a ring signal. No 
distinction can be made as to whether this is a voice call, a modem 
call, a fax call, or other type.

3 - NO CARRIER
This result code indicates that no carrier signal was detected, or that 
the signal was lost. This is the response the modem will give when no 
connection is made; see CONNECT result code. The modem will also return 
this message when the connection is broken, either intentionally as when 
the hangup process completes, or if line difficulties break the 
connection.

4 - ERROR
This result code indicates that an invalid command was issued, or that 
there was an error in the command line. For example, if the command line 
exceeds the character limit for your modem, this result code will be 
returned. See your user documentation to determine the character limit for 
your modem. This result code is also returned in response to the I1 command 
requesting a ROM checksum, if the modem detects an error in the computation.

5 - CONNECT 1200
This result code indicates a connection has been established at 1200, 
1200/75 or 75/1200 bps between the modem and the DTE. If the modem is 
not operating in error-control mode, this is the same as the line speed. 
This result code is disabled by X0. Only CONNECT is reported.

6 - NO DIALTONE
This result code indicates that no dial tone was detected when the modem 
went off hook. Dial tone detection and this result code are enabled by 
X2 or X4, or the W dial modifier.

7 - BUSY
This result code indicates that the modem detected a busy signal when it 
attempted to connect with the modem at the number dialed. Busy signal 
detection and this result code are enabled by X3 or X4.

8 - NO ANSWER
This result code indicates no silence was detected when dialing a system 
not providing a dial tone. Enabled by the @ dial modifier.

10 - CONNECT 2400
This result code indicates a connection has been established at 2400 bps 
between the modem and the DTE. If the modem is not operating in error-
control mode, this is the same as the line speed. This result code is 
disabled by X0. Only CONNECT is reported.

11 - CONNECT 4800
This result code indicates a connection has been established at 4800 bps 
between the modem and the DTE. This result code is disabled by X0.

12 - CONNECT 9600
This result code indicates a connection has been established at 9600 bps 
between the modem and the DTE. This result code is disabled by X0.

13 - CONNECT 14400
This result code indicates a connection has been established at 14400 
bps between the modem and the DTE. This result code is disabled by X0.

14 - CONNECT 19200
This result code indicates a connection has been established at 19200 
bps between the modem and the DTE. This result code is disabled by X0.

22 - CONNECT 1200/75
This result code indicates a connection has been established at 1200 bps 
when transmitting data and 75 bps when receiving data between the modem 
and the DTE.

23 - CONNECT 75/1200
This result code indicates a connection has been established at 75 bps 
when transmitting data and 1200 bps when receiving data between the 
modem and the DTE.

24 - CONNECT 7200
This result code indicates a connection has been established at 7200 bps 
between the modem and the DTE. This result code is disabled by X0.

25 - CONNECT 12000
This result code indicates a connection has been established at 12000 
bps between the modem and the DTE. This result code is disabled by X0.

28 - CONNECT 38400
This result code indicates a connection has been established at 38400 
bps between the modem and the DTE. This result code is disabled by X0.

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
1.2.2     Negotiation Progress Messages

Hayes products report special result codes during error-control 
negotiation. Whether or not these messages are displayed is selected 
with the W command (not to be confused with the W dial modifier). The 
factory setting is messages disabled (W0) to avoid conflict with 
software programs that do not support this additional level of call 
progress monitoring.

Negotiation progress messages are reported in the following order:

CARRIER
PROTOCOL
AUTOSTREAM
COMPRESSION
CONNECT

If AutoStream is not used, no message is reported.

40 - CARRIER 300
This message indicates that a carrier signal has been detected at 300 
bps (modem-to-modem line speed).

44 - CARRIER 1200/75
This message indicates that a carrier signal has been detected at 1200 
bps when transmitting and at 75 when receiving (modem-to-modem line 
speed).

45 - CARRIER 75/1200
This message indicates that a carrier signal has been detected at 75 bps 
when transmitting and at 1200 bps when receiving (modem-to-modem line 
speed).

46 - CARRIER 1200
This message indicates that a carrier signal has been detected at 1200 
bps (modem-to-modem line speed).

47 - CARRIER 2400
This message indicates that a carrier signal has been detected at 2400 
bps (modem-to-modem line speed).

48 - CARRIER 4800
This message indicates that a carrier signal has been detected at 4800 
bps (modem-to-modem line speed).

49 - CARRIER 7200
This message indicates that a carrier signal has been detected at 7200 
bps (modem-to-modem line speed).

50 - CARRIER 9600
This message indicates that a carrier signal has been detected at 9600 
bps (modem-to-modem line speed).

51 - CARRIER 12000
This message indicates that a carrier signal has been detected at 12000 
bps (modem-to-modem line speed).

52 - CARRIER 14400
This message indicates that a carrier signal has been detected at 14400 
bps (modem-to-modem line speed).

66 - COMPRESSION: CLASS 5
This message indicates that data compression using MNP Class 5 has been 
negotiated for the connection.

67 - COMPRESSION: V.42BIS
This message indicates that data compression using CCITT V.42bis has 
been negotiated for the connection.

68 - COMPRESSION: ADC
This message indicates that data compression using Hayes Adaptive Data 
Compression has been negotiated for the connection.

69 - COMPRESSION: NONE
This message indicates that data compression was not negotiated for the 
connection.

70 - PROTOCOL: NONE
This message indicates that no protocol was negotiated for the 
connection. A standard asynchronous connection was made.

71 - PROTOCOL: ERROR-CONTROL/ LAPB
This message indicates that an error-control connection was negotiated 
with LAPB protocol. 

72 - PROTOCOL: ERROR-CONTROL/ LAPB/HDX
This message indicates that a half-duplex error-control connection was 
negotiated with LAPB protocol. 

73 - PROTOCOL: ERROR-CONTROL/LAPB/AFT
This message indicates that an error-control connection was negotiated 
using the Hayes Asynchronous Framing Technique. This protocol is used 
for connections between modems such as Smartmodem 1200 that do not 
communicate synchronously across the telephone line. AFT enables an 
error-control protocol to be used.

74 - PROTOCOL: X.25/LAPB
This message indicates that an error-control connection using the X.25 
protocol was established with a carrier speed of 1200, 2400, 4800, or 
9600 bps.

75 - PROTOCOL: X.25/LAPB/HDX
This message indicates that a half-duplex error-control connection using 
the X.25 protocol was established with a carrier speed of 4800 or 9600 
bps.

76 - PROTOCOL: X.25/LAPB/AFT
This message indicates that an asynchronous error-control connection 
using the X.25 protocol was established with a carrier speed of 1200 
bps. The Hayes Asynchronous Framing Technique was used.

77 - PROTOCOL: LAP-M
This message indicates that an error-control connection using the V.42 
LAPM protocol was established. 

78 - PROTOCOL: LAP-M/HDX
This message indicates that a half-duplex error-control connection using 
the V.42 LAPM protocol was established. 

79 - PROTOCOL:  LAP-M/AFT
This message indicates that an asynchronous error-control connection 
using the V.42 LAPM protocol was established with a carrier speed of 
1200 bps. The Hayes Asynchronous Framing Technique was used.

80 - PROTOCOL:  ALT
This message indicates that an errorge indicates that an error-control 
connection using the V.42 LAPM alternative protocol was established.  
This protocol is MNP Classes 2, 3, and 4 compatible.

91 - AUTOSTREAM:        LEVEL 1
This message indicates that Hayes AutoStream Level 1 has been negotiated 
for the connection. This technique provides for multiplexing of multiple 
virtual channels.

92 - AUTOSTREAM:        LEVEL 2
This message indicates that Hayes AutoStream Level 2 has been negotiated 
for the connectionsage indicates that Hayes AutoStream Level 2 has been 
negotiated for the connection. This technique provides for multiplexing 
of multiple virtual channels, with transparent control of one PAD (non-
simultaneous). Level 3 has been negotiated for the connection. This 
technique provides for multiplexing of multiple virtual channels, with 
transparent control of all PADs (simultaneous).

93 - AUTOSREAM          LEVEL 3
This message indicates that Hayes Autostream Level 3 has been negoitiated 
for the connection. This technique provides for multiplexing of multiple 
virtual channels, with transparent control of all PADs (simultaneous). 

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

S95     Negotiation Message Options

S95 enables various result codes that indicate the sequence of events in 
the establishment of an error-control connection. This register does not 
affect the way in which the modem negotiates the connection; it merely 
enables message options. The factory setting for this register is value 
0, no bits selected. To enable any combination of the bits, add the 
value(s) to the right of the bit number and set the register to this 
sum.

Note: The bit values of S95 may be set to override some of the 
characteristics of the Wn command. Setting any of the S95 bits to "1" 
enables the corresponding result codes regardless of the Wn command in 
effect. Changing the Wn command setting does not affect the value set 
for this register.

Bit   Value    Explanation
------------------------------------------------------------------------
0     1        Verbose CONNECT result code indicates the DCE speed 
               (rather than DTE speed). Numeric result codes are also 
               different when CONNECT reports DCE speed.
1     2        Append "/ARQ" to CONNECT result code when an 
               error-control connection is made.
2     4        Add CARRIER messages
3     8        Add PROTOCOL messages
4     16       Add AUTOSTREAM messages
5     32       Add COMPRESSION messages
------------------------------------------------------------------------

For example, if you want to add the compression result code (with W1 
selected), you would select bit 5 (value of 32). The command line 
ATS95=32J<CR> will then enable the COMPRESSION negotiation messages.

Refer to the Wn and Xn commands for additional and related information. 


========================================================================
APPENDIX D:  APPLICATION SUGGESTIONS

This appendix offers suggestions for developing applications software 
using the Hayes Standard AT Command Set. The techniques described apply 
to Hayes modems in general except where specifically indicated. Although 
provided here, this information is intended for experienced programmers 
who want assistance in modem application development.

************************************************************************
D.1  Modem Identification

The initial concern for most communications software is modem 
identification. Before the software determines the type of modem (e.g., 
is it a Hayes modem, a high-speed modem, what features does it support -
error-control or compression?). By limiting the AT command controller 
portion of the software to work with a known set of modems, you can 
limit the complexity of your software.

Because the type of modem that will be present, certain assumptions can 
be made regarding modem characteristics, such as maximum transmission 
rate, support of AT commands or specific commands such as L or 
X. If a more general application is being designed for an environment 
about which assumptions cannot be made regarding type or brand of modem 
that might be used, the software's first task should be to identify the 
modem.

The I0 and I4 command options make this process simple. In the initial 
versions of Smartmodem 1200, I0 returned the three digit response: 120. 
Since then, responses have been extended for several groups identifying 
modem supporting 2400 bps, 9600 bps, and other products. The I0 response 
simply indicates the speed category of the modem.

The result of the I0 command is a number which identifies the category 
of modem product. Some unique I0 values can be used to identify a unique 
product which has specific behaviors. 960, for example, identifies a 
Hayes product capable of 9600 bps, which has additional commands and 
behaviors.

The I4 command provides a reliable means of communicating 
specific features and modulation protocols to software. The responses to 
the I4 command are strings delimited by <CR> and beginning with a 
lowercase letter and typically followed by a hex-character bit-map. The 
I0 and I4 responses currently defined are detailed in the description of 
the I4 command in Chapter 1.  The tables show the decoding of the hex-
map returned in the "a", and "b" bit-mapped strings. If I4 is used to 
identify features of the modem, consider that new result strings are 
periodically defined that may be returned in addition to those expected. 
Fields once designated as "reserved" that held a zero may now have values 
assigned. The strings themselves may also be of different lengths than 
previously implemented.

In spite of the modifications to this command necessary to be current 
with new modems, the I4 command is the best way for software to 
determine the modem type and capability, if the guidelines below are 
considered:

*  I0 or I4 commands should be issued at 1200 bps. All Hayes products 
(including the Smartmodem 300) respond to AT commands at 1200 bps. Most 
other brands also respond at 1200 bps. You can switch to a higher 
transmission rate once the modem has been identified.

*  Result codes should be parsed as strings surrounded by <CR><LF>. The 
string will begin with a lower-case letter followed by up to 39 
additional characters.

*  After all result strings have been sent, an OK result is returned 
that obeys the V and Q command settings.

*  ERROR, OK, or a numeric result in response to the I4 command should 
be expected. These results may be returned by products shipped before 
the I4 command was introduced, or by non-Hayes products.

*  The length of the strings may be different than anticipated. If 
shorter than expected, empty positions should be presumed zeros. If 
longer than expected, extra characters should be ignored.

*  Some non-Hayes brand modems return unpredictable results in response 
to I0 or I4 commands. One brand of modem actually responds with its 
configuration when the I4 command is sent.

An example I4 command and response is shown below:

                     AT E0 V1 Q0 S0=0 I4 <CR>
response:

     <CR><LF>a087840C004424<CR><LF> 
     <CR><LF>bF60410000<CR><LF> 
     <CR><LF>cUS<CR><LF> J
     <CR><LF>m0000000001001FFFF<CR><LF> 
     <CR><LF>OK<CR><LF> 

Note: Each I4 result is surrounded by <CR><LF>; not all responses are 
hex-strings; and some responses may not be expected at all.

************************************************************************
D.2  Result Code Recognition

Modems that are equivalent to Hayes modems support verbose and numeric 
forms of result codes. Unless echo may be a problem and you will be 
installing the controller in a limited-growth environment, verbose 
results rather than numeric results are preferred. Numeric result codes 
were originally intended to make it easier for software to control the 
modem, but there are two primary reasons they should not be used:

Software can be confused by a command echo. For example, if the 
following command were sent with echo on (E1) and numeric results (V0) 
on:

                       AT ... S9=20 <CR>

The resulting data, echoed by the modem, would be followed by the 
numeric result code zero, meaning OK:

                      AT ... S9=20<CR>0 <CR>

Software may become confused by seeing a 0<CR> result which is actually 
part of the command echo, then another 0<CR> which is the numeric 
result. A program can become unsynchronized with the command processor 
in the modem.

Turning off echo mode (E0) in the initial setup string would solve this 
problem; however, do not end that command with any digits (simply E).

Another shortcoming of numeric results is that the software must 
anticipate all possible responses. This requires updating controller 
software whenever new result codes are added. For example, suppose a 
CONNECT 115200 result were added with a numeric value of 31. If verbose 
results were used instead, and the controller directed to interpret the 
number after the CONNECT result as simply the connection speed in bits 
per second, no changes to the driver are necessitated by the new result 
code. If, however, numeric result codes were used, the result code 31 
must be added to the table, and the controller modified to interpret it 
appropriately.

As characters are received, they should be processed through a state 
machine providing the functionality of the following one. This state 
machine recognizes strings surrounded by <CR><LF> characters and stores 
the string in a character array. <CR><LF> are defined by S3 and S4.

Sample State Machine
Initialize with: state = 1 ;

ch = <next character from the input>
switch( state )
{
     case 1:     /*-- Scanning for leading CR --*/
               if( ch == CR ) state = 2 ;
               i = 0 ;
               break ;
     case 2:     /*-- Scanning for leading LF --*/
               if( ch == LF ) state = 3 ;
               else if( ch == CR ) state = 2 ;
               else state = 1 ;
               break ;
     case 3:     /*-- Buffer result, watch for trailing CR --*/
               if( ch == CR ) state = 4 ;
               else buf[ i++ ] = ch ;
               if( i > LIMIT ) state = 1 ;
               break ;
     case 4:     /*-- Scanning for trailing LF --*/
               if( ch == LF ) state = 5 ;
               else if( ch == CR ) state = 2 ;
               else state = 1 ;
               break ;
}
if( state == 5 )
{
     buf[ i ] = 0 ; /* Null terminate buffer */
     <process result in 'buf'>
     state = 1 ;
}

This state machine can be imbedded within a loop that reads all received 
data one character at a time, checks for a timeout, and also checks for 
user abort. Once a result is recognized, that loop can be exited or 
continued if additional results are expected.

Once a result code string is returned, it can be compared against the 
known result code strings. Some strings may incorporate wild-card 
suffixes. For example CONNECT followed by any numeric value indicates a 
successful connection at the indicated transmission rate. Even if a 
result such as CONNECT 38400 is not anticipated, if the controller has 
been coded for wild-card recognition, the controller will be capable of 
interpreting such responses correctly. This practice also facilitates 
interpretation of connection failed messages that are preceded by NO 
followed by any other character string such as DIALTONE, CARRIER, or 
ANSWER.

************************************************************************
D.3  Modem Preparation

Once the modem has been identified, the controller can continue to 
program any registers or user-defined values into the modem necessary 
prior to initiating the connection process. Typically, the setup 
operation is separated from the connection processing because it is 
performed independently of whether the call establishment will be in the 
originating or answering mode.

Setup commands can be issued at the highest transmission rate the modem 
supports as determined from the identification process or it may be 
fixed at a certain value if the modem is not identified.

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.3.1  Reset

Before issuing any other commands to the modem, it is advisable to issue 
a Z or &F command to the modem before the identification or setup 
process. No specific response should be anticipated. The modem may be 
set up to return numeric, or no result codes. If a reset will be used, 
the following points should be considered:

*  Even if a recognizable result within 2.6 seconds, the program should 
continue. (Some modems do a lengthy reset process before responding with 
a result; others may be in Q1 or V0 mode.)

*  Following an OK result, an additional 600ms delay should be imposed. 
Some modems will respond with an OK then do lengthy reset processing, in 
which case they are unable to accept additional commands.

After the modem is reset, the first setup string (e.g., verbose rather 
than numeric result codes) should be issued, then the identification 
command.

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.3.2  Setup

Software should generally provide some modem setup. However, the 
software can be written to rely on modem configuration via a stored 
profile recalled on reset, or  by DIP switches set depending on the 
product. In this case, any unique settings must have been set up prior 
to running the software, and all the program does is send the Z command 
to recall the desired profile. Even more basically, software can assume 
the modem is in the power-up state. However, unless the software will be 
used within a very predictable environment, these assumptions may result 
in failures with the controller software.

Some commands will always be overridden by the controller in order to 
ensure its proper functioning. Other command options should either 
default to the factory setting, or simply act as the "transfer agent" 
for the commands specified by the user. Menus and dialogs can be 
provided to prompt the user for specific activities; the program can 
then interpret these requests and configure the modem accordingly, as 
Hayes Smartcom products do, or provide the user opportunity to enter AT 
command strings.

Commands frequently set by a modem controller:

E0         Turn off echo mode to avoid having command echoes pass 
           through the result code scanner.

&F         Recall the factory profile.

Q1         Enable result codes to ensure that commands are being 
           processed, and to synchronize with the modem command 
           processor (except for synchronous communications where result 
           codes may cause the DTE confusion).

V0 or V1   Use either numeric result codes or verbose (recommended) 
           result codes.

S0=0       Disable auto-answer during the setup process to avoid 
           inadvertent disruption by an incoming call.

H0         Ensure modem is on hook before continuing to the answer or 
           originate process.

S12=10     Set the escape sequence guard time to 200ms to hasten the 
           escape for hang-up process. Also reduces the probability of 
           inadvertent user escapes.

S2=*       Change the escape sequence character for two reasons: To 
           avoid inadvertent user escapes, and to provide different 
           escape sequence characters for answer and originate ends. 
           This prevents inadvertent escaping when data is echoed.

S4=*       Modify the linefeed character to make the <CR><LF>NO 
           CARRIER<CR><LF> result code more unique if you scan for it
           to detect carrier loss.

S95=60     Enables the result codes which will provide the maximum 
           amount of information about the connection when it is 
           established.

Two typical setup sequences using these recommendations are shown below:

Recommendation for software design based on using pre-existing user 
settings:
              AT E Q V S0=0 H S12=10 S2=28 S4=31 S95=60 <CR>

Recommendation for software design based on starting from a known 
factory setting: 
              AT &F S2=28 S4=31 S12=10 S95=60

Note: Where the zero suffix is used, it may be omitted from a command. 
Spaces are shown above for readability, but the use of spaces between 
commands is not recommended. 

Once this setup command has been sent, and the OK response returned, the 
controller can continue to the originate or answer processing.

If user-programmed settings are included in additional setup strings, or 
the user is permitted to enter AT setup strings, the software should 
anticipate ERROR result codes. If an ERROR is returned in response to 
such a command, the result does not have to be reported to the user, but 
the controller should not be prevented from continuing in either case. 
Many times a connection can be made even though some setting is in error 
or is inappropriate for the class of modem being addressed.

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.3.3  Establishing the Desired Connection and Fallback Strategy 
       (S36 Developers' Tips)

S36 determines which fallback action will occur if the protocols and 
procedures set by S46 and S48 do not produce a LAP-based (LAPB) error-
controlled connection.

The optimum fallback control strategy depends on which Hayes error-
control modem you have. The fallback behavior is determined by S36, S46, 
S48, and &Q5.

There have been two improvements in the V-series, OPTIMA and ACCURA EC 
modems that affect S36: The first added &Q6 Asynchronous Speed Buffering
(ASB); ASB provides the same fixed speed DTE interface and local flow control 
as in the error control mode but without the error control or remote 
flow control. The second improvement added V.42 with its Alternate 
Protocol (MNP).

Previously, S36 only consisted of one bit, Bit 0, 
which permitted the user to decide whether the modem would hang up or 
not if it did not succeed in negotiating an error-controlled connection. 
The factory default for S36 was 1, which meant fall back to direct async 
rather than hang up if an error control protocol is not established in 
&Q5 mode.

When &Q6 (ASB) was added, a fall back option for &Q5 mode, which can be 
controlled with S36, was also added. If S36 Bit 1 is set, and bit 0 is 
also set, the modem will fall back to ASB instead of direct async if no 
error control protocol is established in &Q5 mode. The factory default 
for S36 remained 1.

When V.42 was added, it added another fall back option, MNP, to S36. If 
S36 Bit 2 is set, then MNP will be attempted if the primary protocol 
selected in S48 is not established. Bit 2 is evaluated before Bits 0, 
then Bit 1. If MNP is established as the protocol, then Bits 0 and 1 are 
ignored. The factory default became 5 and later was changed to 7 to take 
more advantage of ASB.

Now that we know that there are three versions of S36, we may need a way 
to tell which version our software is controlling. First, verify that it 
is a Hayes error-control modem. This is done by issuing an I4 command 
and looking for the existence of a "b-string". A b-string begins with a 
lower case letter "b" and is followed by several upper case letters or 
numbers forming a hex value.

The easiest way for software to identify whether a Hayes modem 
supports Asynchronous Speed Buffering (also known as ASB, Buffered 
Async, or Normal) is to issue the following AT command,  AT &Q6 &Q5 
<CR>. If the result code is OK then &Q6 is supported, and ASB is also 
supported as a fall back. If the result code is ERROR, then &Q6 is not 
supported. If this is the case, then software should be prepared to fall 
back to a direct async connection.

The easiest way for software to identify whether a Hayes modem 
supports V.42 (and MNP) is to decode the first character after the 
leading "b" in the b-string of the I4 ID command response. The 
characters following the "b" in that line are "ASCII-hex" (0-9, A-F), 
which decode into 4 bits of ID code (3-0).  If Bit 3 is set, then MNP is 
supported; Bit 2 is V.42.

Armed with the knowledge of which S36 bits are supported, the software 
may now safely configure the modem and properly anticipate the fall-back 
action.

It should be safe to set S36 bit 2 to enable V.42 (and MNP) even if 
those protocols are not supported in the modem.

If the modem does not support ASB, then software should be prepared to 
follow the CONNECT XXXXX speed result code and change the DTE port speed 
to match the indicated line speed of the direct connection when no error 
controlled connection was negotiated.

If software will not change port speeds in response to the CONNECT 
message, then when software has identified a 'pre-ASB' modem, 
it should set S36 to 0 or 4 so that if no protocol is negotiated, the 
modem will hang up.

The following table shows the order in which the bits of S36 are 
evaluated: (Remember, these steps only occur after the S46/S48 
selections have failed to make a LAPBased error controlled connection in 
&Q5 mode.)

------------------------------------------------------------------------
S36      Bit 7-3=0       reserved 
First    Bit 2 (4)       If set, means try MNP protocol; reset means 
                         don't use MNP. 
Third    Bit 1 (2)       If set, means fall back to ASB; reset means 
                         direct async. 
Second   Bit 0 (1)       If set, means fall back based on Bit 1;
                         reset means hang up.
------------------------------------------------------------------------
         
The following table shows the meaning of each setting:

------------------------------------------------------------------------
S36=7   Try MNP, then fall back to ASB. 
S36=6   Try MNP, then hang up. 
S36=5   Try MNP, then fall back to direct async. 
S36=4   Try MNP, then hang up. 
S36=3   Don't try MNP; fall back to ASB. 
S36=2   Don't try MNP; hang up. 
S36=1   Don't try MNP; fall back to direct async. 
S36=0   Don't try MNP; hang up.
------------------------------------------------------------------------

There are three types of fallback stratagies which Hayes products use.

Type 1: Hayes Modem Operation in &Q5 Communications Mode
Applies to V-series Smartmodem 2400 up to and including Version 1.3 and 
V-series Smartmodem 9600 up to and including Version 1.4.

Type 2: Hayes Modem Operation in &Q5 Communications Mode
Applies to V-series Smartmodem 2400 Version 1.4 and V-series Smartmodem 
9600 Versions 1.5 and 1.6.

Type 3: Hayes Modem Operation in &Q5 Communications Mode
Applies to all V-series products newer than Types 1 and 2 and all OPTIMA 
and ACCURA EC products.
 
------------------------------------------------------------------------
               ATI3 Response contains...     
               V-SERIES SMARTMODEM 2400    V-SERIES SMARTMODEM 9600
Type 1         04-00005-10                 04-00015-10
               04-00005-11                 04-00015-11
               04-00005-12                 04-00015-12
               04-00005-13                 04-00015-13
                                           04-00015-14
Type 2         04-00005-14                 04-00015-15
                                           04-00015-16
Type 3         Does not contain any        Does not contain any
               of the above numbers        any of the above numbers
------------------------------------------------------------------------

************************************************************************
D.4  Connect Processing

Once the setup operation has been completed, the commands to establish 
the connection can be issued. The instruction can be either to originate 
(using the D command), or to answer (using the A or S0 commands).

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.4.1  Originating a Call

If the D command is issued with the desired phone number, several 
possible result codes can be returned. The list below outlines some 
results to expect:

Result Code        Meaning
------------------------------------------------------------------------
NO CARRIER         Connection failed
NO ANSWER          No response to '@' dial modifier
NO DIALTONE        No dial tone in X4 mode
NO ____            Connection failed for some other reason
BUSY               Busy signal detected
CONNECT ____       Connection successful; you may need to change DTE 
                   speed to the indicated baud rate. (See Wn and S95)
CARRIER ____       * DCE carrier speed. (See Wn and S95)
PROTOCOL: ____     * Error-correction protocol being used by the modems. 
                   (See Wn and S95)
COMPRESSION:____   Compression technique in use by modems. (See Wn 
                   and S95)
AUTOSTREAM         Autostream technique in use by modems if selected by 
                   user. (See Wn and S95)
------------------------------------------------------------------------

Ignore other responses, but continue to wait for CONNECT ___, BUSY, or 
NO ___ responses. The CARRIER and PROTOCOL results are intermediate 
results and precede either a CONNECT ____ or NO ____ result. These 
results are only returned by Hayes modems when configured to use an 
error-correcting protocol.

If you recognize any numeric value for the baud rate after the CONNECT 
result, you will have a much more robust controller able to handle many 
situations. You can use the PROTOCOL result to determine if the flow 
control requested by the &K command is in effect.

Note: If you want to manually dial a call and then have the modem connect, 
enter the command string ATX1D (X1 disables dial tone detection) when you 
hear the dial tone. 

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.4.2  Answering a Call

The simplest technique for answering an incoming call is to set S0 and 
wait for a CONNECT ___ result. You may get several RING results, and 
possibly a NO CARRIER result if the caller hangs up before connecting. 
These results should not cause your controller to abort. Continue to 
wait for a CONNECT result code.

If you set S0, you may want to set it back to zero after your controller 
finishes the call to prevent inadvertent answering when your software is 
not running. By setting S0 to the number of rings you desire before the 
modem answers, you utilize the ring detection technology already built 
into the modem.

You should not use the A command to answer after counting RING results 
because the command may collide with another RING result from the modem 
and be missed. The RING results may be generated in pairs depending on 
the ringing cadence of the phone system.

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.4.3  Using the CD Line

Monitoring the Carrier Detect (CD) line of the RS-232 interface is 
another technique for carrier detection in answer or originate mode. 
This assumes that &C1 or the corresponding DIP-switch has been set and 
the cable is wired properly. Both are risky assumptions. You will have a 
more robust controller if you use result code scanning rather than the 
RS-232 lines.

If you use CD, you do not know when the modem has given up waiting for 
the carrier, or why. If the line is busy, you may want to re-try the 
dial operation. If there is no dial tone, the user needs to know this.

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.4.4  Aborting a Connect Request

Once the D or S0 command has been issued, the modem goes off hook (or 
may be off hook for S0) and it must be put back on hook (hangPup) before 
the abort is completed. To abort an in-progress connect command, send 
any character to the modem. This will typically result in a NO CARRIER 
response. The result code scanner should be called after the abort 
character is sent to prevent additional commands from being sent before 
the controller and the modem are again in sync.

Smartcom products send AT<CR> to abort an in-progress connect command. 
This elicits a result code regardless of whether the modem were off-hook 
or not. If the modem was off-hook attempting to connect, this will abort 
the connect operation and return NO CARRIER. If the modem was on-hook in 
command mode, this simply returns <CR><LF>OK<CR><LF>.

************************************************************************
D.5  Carrier Loss Detection

You want your application to be able to detect when the carrier has been 
lost so you can determine when the connection is complete. You might be 
unable to put this part of the code in your controller software, since 
the controller is typically running only during the connect or hang-up 
process. Once the application has detected the carrier loss event, it 
can call the modem controller and restore the modem settings.

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.5.1  Using the CD line

If you are confident of the communications environment and cabling 
requirements, and have access to the RS-232 signal status, then 
monitoring the CD line is the easiest carrier loss detection method to 
implement. This requires &C1 to be programmed at setup time, or be 
stored in the modem as the value recalled on reset or power-up.

However, this is the most restrictive and risky choice. It requires a 
properly wired cable and support of &C1 by the modem's command set or 
proper DIP-switch settings.

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.5.2  Scanning the Incoming Data Stream

In cases where you  cannot depend on 100% Hayes compatibility or want to 
be independent from the cable wiring, then scanning for the NO CARRIER 
result code is more reliable. It is also more complex to implement.

Typically, at the low-level of the program all received data is 
retrieved through one subroutine. This subroutine can be augmented or 
layered to provide the service needed. As data passes through, the last 
fourteen characters are buffered, typically in a circular buffer. If 
more data passes in each call, only the last fourteen need to be copied. 
At a time when the processor is free, such as after 100 ms of idle time 
or the receive routine has returned no data for 30 to 100 calls, then 
the buffer is compared against the <CR><LF>NO CARRIER<CR><LF> result 
code. If a match is found, the carrier lost event is triggered.

By only checking when there is idle time, or after no data has been 
received for a while, you reduce the CPU overhead and ensure that the 
modem is not falsely triggered when the string is imbedded in an actual 
data stream.

You can also modify the linefeed character by using S4 to a different 
value such as S4=31 to make the result code sequence more unique. This 
action, however, affects other result codes generated by the modem.

************************************************************************
D.6  Escape and Hang Up

When your controller has been instructed to terminate the connection, 
you must put the modem back in command state and issue the hang-up (H) 
command. In addition to hanging-up, you will also want to restore 
settings you changed to their factory-set values, or issue an ATZ<CR> to 
undo the effects of your changes. In any case, restoration of the modem 
settings is necessary even if the connection was terminated due to loss 
of carrier.

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.6.1  Escaping the Modem to Command State

To escape the modem, the controller must first delay the escape sequence 
guard time (specified by S12), then issue the escape sequence character 
three times (specified by S2); then wait for an OK result. Waiting for 
the result also enforces the required guard time after the escape 
sequence. Once the OK result is received, the modem has entered command 
state. The controller can then hang up and restore the modem.

The controller software must be sure to wait the required guard time 
before sending the escape sequence characters. Your controller may have 
been called just after data was transmitted and, without the delay, your 
characters will just be sent without triggering the escape sequence 
recognition process. It is important that the serial transmitter be 
permitted to be idle for the escape sequence guard time, plus a few 
extra milliseconds to allow for error, before sending characters.

For example, if  S12=10, a delay of at least 200 milliseconds is 
required before sending the escape sequence characters. After sending 
the escape sequence characters, the OK result will be received after 
another 200 millisecond wait. This completes the escape sequence process 
in slightly over 400 milliseconds. If S12=50 (factory setting) is used, 
one full second must pass before the characters can be sent, then 
another second delay must transpire prior to the OK result. This 
completes the process in slightly over two seconds. For this reason, it 
is recommended that S12=10 be issued to speed up this process.

A delay slightly longer than that stored in S12 should be used to allow 
for errors in the system clock as well as in the modem clock. 100ms is 
an adequate safety margin.

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.6.2  Using DTR to Escape or Hang Up

The DTR RS-232 signal can be used to escape the modem to command state, 
or to reset the modem depending on the &D command set or DIP-switch 
settings. This also requires the cable to be properly wired. Unless the 
software will operate in a highly-controlled environment, this technique 
is discouraged over using the escape sequence process because of the 
requirements to make it function properly. Leaving a call connected 
simply because the cable was not properly wired can be potentially 
expensive. The escape sequence is reliable in all environments if it is 
properly utilized.

************************************************************************
D.7  Modem Re-configuration

When a call has been completed, a "clean-up" command should be issued to 
return the modem a more known configuration. For example, if verbose 
result codes were selected when the modem was reset, and the controller 
selected numeric result codes, on completing the session, the controller 
should reset the modem to re-select verbose result codes. In the same 
way, if the linefeed character were changed to suit the software or 
environment, the character should be set to its former value. Any other 
command options that were modified, should be restored to their factory-
set values.

The minimum the controller should do when through with the modem is 
issue a Z command option to ensure the modem is restored to its power-up 
state.

************************************************************************
D.8  Timing Considerations

A modem controller inherently has a sense of time. Usually all that is 
needed to utilize the timing part of the controller is access to a time 
reference. For example, the number of milliseconds since power-up or 
program launch, or a "system tick" value can be used. 

Under DOS, the INT 1C timer tick produces an interrupt every 55 
milliseconds. An ISR can be installed on this interrupt to add 55 to a 
long integer every time it is called. This will provide a millisecond 
counter.

On the Macintosh, the "Tick Count" function will return the number of 
vertical-retrace ticks since computer power-up. Each tick represents 
1/60 of a second.

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.8.1  Programming for Time

The time value is used to determine relative time. For example, if a 
loop should be executed for only 2 seconds it could be coded as:

timeout = Tick Count( ) + 120 ; /* 60 tics per second = 2 seconds */
do
{
     got_one = Check_Result( ) ;
}
while( ( ! got_one ) && ( SystemTick( ) < timeout ) ) ;

This code fragment continues to call the Check_Result function until it 
returns a true value, or until two seconds have elapsed.

This technique is independent of processor speed. A faster processor may 
make thousands of trips through the loop, where a slower one would only 
make a few hundred. Any anticipated result code would arrive within that 
two-second real-time window.

Care should be given to considering when to start the timing loop. If an 
AT command string is sent, then a loop executed, the time interval may 
also include the time required to send the AT command (if data is 
buffered and sent by an interrupt service routine).

At 300 bps, where each character takes 33ms just to transmit (10/300), a 
40 character AT command would take over a second to transmit. This means 
a two second loop spends more than half of its time waiting for the AT 
command process to complete, leaving only a fraction of a second for the 
modem to respond with the result (again at 33ms per character).

One way to avoid this is to wait until all data has been transmitted by 
an ISR before entering the result code scan loop. Alternatively, more 
time can be provided for loops to process results. Another option is to 
measure idle time rather then elapsed time.

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.8.2  When to Consider Time

The use of timing varies from command to command and operation to 
operation. Some commands take longer to execute. The guidelines below 
can be used to determine the best amount of time to wait.

*  For the Z command, wait two seconds for a response, then wait an 
additional 600 ms, whether a response were received or not.

*  For general setup commands, wait two seconds for the response.

*  For the hang-up command (H), wait up to 20 seconds for a response. 
Some modems may take longer to hang-up if data buffered within the 
modem is still waiting to be transmitted and acknowledged. This time is 
controlled by S38.

*  For dial commands (D or O) wait at least one minute or more. Values 
set for carrier detect time, tone versus pulse dialing, commas in the 
phone number, all can take additional time.

If the software times out, the modem may, in fact, not be connected to 
the computer, disconnected, or turned off. If this is the case, enforce 
a reasonable timeout to the first setup or identification command. That 
will determine whether a modem is attached and functioning.

A timeout may also occur when the software receives a result code it 
does not recognize. The software may continue to wait until it receives 
a code it does recognize. If this is the case, the controller should 
proceed as if an ERROR response were received. The only instance in 
which it is not prudent to continue is when a connect (D, A, or S0) 
command was issued.

Before implementing a timeout, the advantages, if any, to this level of 
program interruption should be considered. For example, if the program 
times out from a dial command in one minute when it may take two minutes 
to complete the call, the timeout defeats the purpose of the command. 
The modem always responds with a result code, whether BUSY, NO CARRIER, 
or CONNECT, after some length of time.

Idle time is the time since data was received. Elapsed time is the time 
since the software started looking for the result. Idle time can be 
measured by resetting the timeout clock each time the software receives 
a character. Rather than exiting the loop after two seconds of elapsed 
time, the logic changes to exit after no further data has been received 
for two seconds.

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.8.3   Recovering when "Out Of Sync"

Another disadvantage of timing out is that an early timeout can put the 
software out of sync with the modem command processor. The controller 
may be interpreting results sent in response to previous commands as the 
response to later commands. To avoid this condition, any pending receive 
data should be flushed before the next command is issued.

************************************************************************
D.9  Transparent XON/XOFF Local Flow Control

The use of flow control during error-control modem connections is 
essential to avoid loss of data during error-control protocol 
retransmissions. Use of flow control allows the DTE-DCE interface to be 
run faster than the line speed, permitting the additional benefit of 
increased throughput due to stripping of start and stop bits by the 
error control protocol and data compression techniques such as V.42bis. 
When the interface is run at high speed, data loss due to modem buffer 
overrun is quite likely to occur if flow control is absent or not 
functioning properly.

Hayes modems support the industry standard "RTS/CTS" hardware 
flow control (invoked by the &K3 command) and "XON/XOFF" character-based 
flow control (&K4) schemes. However, in some situations, it is not 
possible to use either of these. For example, hardware flow control 
cannot be used if the DTE serial port does not support the RTS and/or 
CTS hardware signals, if corresponding conductors are not present in the 
interface cable, or if intermediate equipment does not properly transfer 
the RTS and CTS signals. XON/XOFF flow control cannot be used if the XON 
and XOFF characters appear in the user data or in the control 
information associated with the file transfer protocol in use, since 
this would interfere with the use of these characters for flow control, 
resulting in failure of data transfer and possibly locking up the 
interface.

Hayes addressed these problems in the design of V-series, OPTIMA and 
ACCURA EC modems. Desiring to provide a complete solution for all users, 
Hayes provided a third flow control scheme, which accommodates systems 
which cannot use RTS/CTS but which must transfer data containing the 
XON and XOFF characters. This scheme, known as Transparent XON/XOFF 
Local Flow Control (invoked by the &K5 command), uses only the Transmit 
Data and Receive Data circuits, yet provides for the transfer of all 
256 possible 8-bit characters over the interface without interfering 
with the flow control scheme.

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.9.1  Summary

Transparent XON/XOFF Flow Control functions on the interface between the 
local DTE (computer or terminal) and local DCE (modem). When the data is 
placed on the link between the modems, the original characters have been 
restored. Neither the remote DTE nor DCE are aware, or need to be aware, 
of the fact that Transparent XON/XOFF Flow Control is in use.

Transparent flow control can be viewed as a layered process, organized 
as follows. Note that this process is duplicated in the reverse 
direction (operates in both directions simultaneously).

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.9.2  Transparentization

Transparent XON/XOFF Flow Control operates by scanning the data stream 
for XON ($11), XOFF ($13), and DLE ($10) characters ("$" indicates 
hexadecimal), with either 0 or 1 in the high-order bit position. When 
one is found, a DLE with same parity character is inserted ahead of it. 
The original character is then "transparentized" by exclusive-ORing the 
character with the value $21 (hexadecimal 21, decimal 33, binary 
00100001), which preserves the parity bit value. XON and XOFF characters 
are thus "hidden" in the data stream. 

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.9.3  Flow Control

Once the XON and XOFF characters have been transparentized (hidden), the 
DTE and DCE are free to insert XON and XOFF characters for flow control 
purposes at any point in the data stream. This includes the possibility 
of inserting XONs and XOFFs between a DLE and the following 
transparentized character. XON and XOFF characters in the user data will 
not interfere with the flow control scheme. The operation of this 
XON/XOFF flow control process is identical to traditional XON/XOFF flow 
control.

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.9.4  De-Transparentization

In the de-transparentization process, the receiving device scans for 
DLEs. When one is found, it is discarded, and the following character is 
once again exclusive-ORed with the value $21, recovering the original 
character. Note that XONs and XOFFs that appear between the DLE and the 
following transparentized character are used for flow control purposes 
and do not affect the detransparentization process.

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.9.5  Examples

The following discussion is written in terms of the actions performed by 
the computer software. The modem performs identical actions on the 
reverse directions of transmission. This text is not meant to constrain 
implementation or to imply that better implementations are not possible, 
but serves simply as an example. 

........................................................................
D.9.5.1  Transmitter Example

Each character in the user data stream is individual examined. It it is 
any of the six characters $10, $11, $13, $90, $91, or $93, it is 
exclusive-ORed with the value $21, and prefixed by a DLE character 
($10). This can also be viewed as a replacement function according to 
the following table:

Char      Replaced By
------------------------------------------------------------------------
$10       $10 $31
$11       $10 $30
$13       $10 $32
$90       $10 $B1
$91       $10 $B0
$93       $10 $B2
------------------------------------------------------------------------

The characters are transmitted using the parity setting then in force on 
the DTE-DCE interface; the XOR with $21 preserves the correct value of 
the parity bit.

If the software wants the modem to suspend delivering data, it inserts 
an XOFF ($13 at current parity setting) in the transmitted data stream 
at any arbitrary point, which may be between a DLE ($10) and the 
following transparentized character. The XOFF should be issued BEFORE 
the buffer is completely full, since there may be a lag of several 
characters before the modem is able to react to the XOFF and suspend 
delivery. To resume delivery of data, the software inserts an XON ($11 
at current parity setting) at any arbitrary point. Characters inserted 
for flow control purposes are NOT passed through the transparency 
algorithm defined above. 

........................................................................
D.9.5.2  Receiver Example

Each character received from the modem is individually examined. A 
"transparency sequence in progress" flag (TSIP-FLAG) is maintained as 
part of a simple state machine. The initial value of the TSIP-FLAG is 
OFF. The following tests and actions should be undertaken in the order 
listed.

If the character received is $13 or $93 (XOFF with either parity), it is 
interpreted (regardless of the setting of the TSIP-FLAG) as a request 
from the modem for the DTE to suspend transmission of data to the modem. 
The receiver portion of the software must communicate this request to 
the transmitter portion of the software in a timely manner, since the 
modem has a limited amount of buffer space to allow for additional 
characters to be received after it sends XOFF (about 64 characters 
maximum). The XOFF character is discarded from the received data stream. 
The TSIP-FLAG is not changed.

If the character received is $11 or $91 (XON with either parity), it is 
interpreted (regardless of the setting of the TSIP-FLAG) as a request 
from the modem for the DTE to resume transmission of data to the modem, 
if any is available. The XON character is discarded from the received 
data stream. The TSIP-FLAG is not changed.

If the character is neither an XON or and XOFF, the following steps are 
performed:

If the TSIP-FLAG is ON, the received character is exclusive-ORed with 
$21, then delivered to the higher layer for further processing (e.g., 
placed in a receive data buffer). The TSIP-FLAG is then turned OFF.

If the TSIP-FLAG is OFF and the character received is $10 or $90 (DLE 
with either parity), the beginning of a transparency sequence is 
indicated. The DLE is discarded from the received data stream, and the 
TSIP-FLAG is turned ON. 

If the TSIP-FLAG is OFF and the character received is neither a $10 nor 
$90, the character is a normal untransparentized user data character 
which should be delivered to the higher layer for further processing 
(e.g., placed in a receive data buffer). The TSIP-FLAG remains OFF 
(unchanged).

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
D.9.6  Conclusion

When properly implemented, Transparent XON/XOFF Local Flow Control 
permits a fully-functional flow-controlled interface even when only 
three conductors are present (Transmit Data, Receive Data, and Signal 
Ground). Versatile software may use the &T19 cable test feature of Hayes 
modems to determine whether or not RTS/CTS flow control can be 
used, and, if RTS/CTS is unavailable, automatically select &K5 operation 
to use Transparent XON/XOFF flow control, and allow the user to continue 
to transfer data using any protocol or data contents without concern for 
possible interference with the XON/XOFF flow control scheme.

************************************************************************
D.10     General Tips and Techniques

The following are tips and techniques that may help in the exchange of 
information between the software controller and the modem command 
processor.

*  Commands in the command line should be ordered starting with the 
safest and ending with the most risky. Risk is defined as the potential 
to generate an ERROR, causing the remainder of the command line to be 
ignored.

*  Any command that may return ERROR should be anticipated. This or 
other unexpected results can be ignored unless the command is critical 
(configuration or call placement).

*  Send I0 or I4 at 1200 bps, which is supported by the majority of 
modem products. A modem reset (&F or Z) should be performed at 1200 bps 
before sending the identification commands.

*  Setup processing can be speeded by sending all but the last D or S0 
command at the highest DTE rate supported by the modem. The last command 
must be sent at the speed at which the connection should be made (except 
V-series, OPTIMA and ACCURA EC products which specify this with S37).

*  Any dependency on proper cabling can be eliminated by avoiding 
techniques that depend on RS-232 signals:
     Have the software scan for result codes, rather than depending 
     on the condition of the CD line.
     Transparent flow control should be used with V-series, OPTIMA and 
     ACCURA EC products rather than with RTS/CTS signals.
     The escape sequence with guard time process and H command 
     should be used to hangup instead of terminate a connection by 
     dropping DTR.
     Any unexpected RING result codes may indicate the last command 
     may not have been processed correctly. The command should be-
     issued.

Sample Controller/Modem Exchange

Clock     Controller                    Speed      Modem 
                                        (1200)
                                         bps)
------------------------------------------------------------------------
00000     ATZ<CR>                        
00034                                              ATZ<CR>
00068                                             (one second to do 
                                                   reset)
01068                                             0<CR> (V0 stored as 
                                                   default)
01084     (delay additional 600ms)
01684     ATEQV1S0=0S12=10S4=3HI<CR>          
01884                                             ATEQV1S0=0S12=10S4=3HI
                                                  <CR> (echo)
02084                                             <CR><LF>960<CR><LF> 
02142                                             <CR><LF>OK<CR><LF>
                                         (19200
                                          bps)     
02192     ATM0X4L1S12=10S2=1&Q5W1S36
          =7S37=9&K5<CR>
02206                                             <CR><LF>OK<CR><LF> 
02209     ATDT9W14045551212<CR>
38000                                             <CR><LF>CARRIER 
                                                  2400<CR><LF>
45000                                             <CR><LF>PROTOCOL: 
                                                  NONE<CR><LF>
45010                                             <CR><LF>CONNECT 
                                                  2400<CR><LF>
                                        (2400 
                                        bps)
                                        
(Connection Established)
-----------------------------------------------------------------------
                                        (2400 
                                         bps)
00000     (delay 300ms, need 200, add 
          100 for safety)
00300     (escape char is ^A, S2=1)
00313                                              (waits 200ms)
00513                                              <CR><LF>OK<CR><LF>
00538     ATHE1S2=43S12=50W0&Q0<CR>
00630                                              <CR><LF>OK<CR><LF> 
------------------------------------------------------------------------

========================================================================

-- 
Carl Oppedahl AA2KW  (intellectual property lawyer)
30 Rockefeller Plaza
New York, NY  10112-0228
voice 212-408-2578     fax 212-765-2519
 