' 
' X_REMAP.BAS  5-11-94  Copyright 1994 by Matt Hart
'
' Keyboard remapper for 286+ enhanced keyboards
'
' Shield Equalizer
' Full Lasers, Shields and No Lasers, Shields + Full Speed, Default Power,
' Shield equalize + laser to shields power transfer
' 
' Compile and LINK with:
'
' C:\>bc X_REMAP /o;
' C:\>link /nod/noe/ex X_REMAP _noread _noerror _noval str00256,,nul,smalldos
'  pdq;
' C:\>exe2com X_REMAP
'
' Requires the Microsoft BASIC Compiler version 4.x, 6.x, 7.x, or
' Visual Basic/DOS 1.0 and the Crescent Software PDQ library.  VB/DOS or 7.x
' using /fs requires PDQ with far string support.
' 

DEFINT A-Z

'$INCLUDE: 'PDQDECL.BAS'
CONST False = 0
CONST True  = NOT False

DIM Registers AS RegType

ID$ = "X-WING Power/Shields Subsystem 1.33"
PRINT
PRINT ID$                       'print it
PRINT
PRINT "Copyright 1994 by Matt E. Hart  CompuServe : 75450,3705"

DEF SEG = &H40                  ' low BIOS data segment
IF PEEK(&H96) AND &H10 = 0 THEN
    PRINT "Unable to install.  Enhanced keyboard not present."
    END
ENDIF

C$ = UCASE$(COMMAND$)
IF INSTR(C$,"?") OR INSTR(C$,"HELP") THEN
    PRINT
    PRINT " For use with LucasArt's X-WING"
    PRINT
    PRINT " Tilde/Back Quote `~ mapped to shield equalization plus laser power"
    PRINT "                     transfer to shields"
    PRINT " F11 mapped to full power to engines plus max speed"
    PRINT " F12 mapped to full power to lasers and shields"
    PRINT " Shift-Tab mapped to set default power configuration 1"
    PRINT " Tab mapped to default power configuration 1"
    PRINT " Shift-Q mapped to set default power configuration 2"
    PRINT " Q mapped to default power configuration 2"
    PRINT " CapsLock mapped to ignore target"
    PRINT
    PRINT " Press Shift-F11 to reset power settings at the beginning of a mission"
    PRINT
    PRINT "    Syntax:"
    PRINT "           C:\>X_REMAP {/u}"
    PRINT "    /u = Uninstall"
    PRINT
    END
ENDIF
DGroup = TSRInstalled%(ID$)     'see if we're already installed
IF DGroup THEN
    IF INSTR(C$,"/U") THEN
        Success1 = PopDeinstall(DGroup, ID$)
        Success2 = UnhookInt(Registers, DGroup)
        IF Success1 AND Success2 THEN
            PRINT "X_REMAP removed"
        ELSE
            PRINT "Unable to remove X_REMAP.  Re-boot now!"
        ENDIF
    ELSE
        PRINT "X_REMAP already installed"
    ENDIF
    END
ELSEIF INSTR(C$,"/U") THEN
    PRINT "X_REMAP not installed"
    END
END IF

Lasers = 2 : Shields = 2
DLasers1 = 2 : DShields1 = 2
DLasers2 = 2 : DShields2 = 2
F9$ = CHR$(0)+CHR$(67)
F10$ = CHR$(0)+CHR$(68)

'  INTERRUPT 15h
'---- Trap keyboard Interrupt 15H, misc services
Registers.IntNum = &H15             'specify trapping Int 15h
CALL PointIntHere(Registers)        'trap the interrupt
GOTO PopUp                          'skip past the Int 15h handler to PopUpHere

CALL IntEntry1                      'we arrive here when an app calls for a key
CALL IntEntry2(Registers, Zero)     'these are the two mandatory calls

CallIt = True
IF Registers.AX AND &H4F00 THEN
    MakeBreak = Registers.AX AND &HFF
    'B$ = STR$(MakeBreak) + CHR$(13) + CHR$(10)
    'CALL BiosLPrint(B$,BYVAL 1)
    SELECT CASE MakeBreak
        CASE 41                 ' Tilde Make Code
        CASE 169                ' Tilde Break Code
            CALL CallOldInt(Registers)      'call the original Int 15h handler
            CallIt = False
            Strg$ = "sss''''''''" : GOSUB StuffIt

        CASE 15                 ' Tab Make Code
        CASE 143                ' Tab Break Code
            CALL CallOldInt(Registers)      'call the original Int 15h handler
            CallIt = False
            IF PEEK(&H17) AND 3 THEN
                DLasers1 = Lasers
                DShields1 = Shields
            ELSE
                SaveLasers = Lasers : SaveShields = Shields
                Strg$ = "" : LN = DLasers1 : SN = DShields1 : GOSUB DoLoops
                IF LEN(Strg$) THEN
                    GOSUB StuffIt
                    IF NOT StuffOkay THEN Lasers = SaveLasers : Shields = SaveShields
                ENDIF
            ENDIF

        CASE 16                 ' Tab Make Code
        CASE 144                ' Tab Break Code
            CALL CallOldInt(Registers)      'call the original Int 15h handler
            CallIt = False
            IF PEEK(&H17) AND 3 THEN
                DLasers2 = Lasers
                DShields2 = Shields
            ELSE
                SaveLasers = Lasers : SaveShields = Shields
                Strg$ = "" : LN = DLasers2 : SN = DShields2 : GOSUB DoLoops
                IF LEN(Strg$) THEN
                    GOSUB StuffIt
                    IF NOT StuffOkay THEN Lasers = SaveLasers : Shields = SaveShields
                ENDIF
            ENDIF

        CASE 58                 ' Caps Lock Make Code
            Registers.AX = Registers.AX AND &HFF00 OR 42        ' Shift Make Code
        CASE 186                ' Caps Lock Break Code
            Registers.AX = Registers.AX AND &HFF00 OR 170       ' Shift Break Code
            CALL CallOldInt(Registers)      'call the original Int 15h handler
            CallIt = False
            Strg$ = "I" : GOSUB StuffIt

        CASE 67                 ' F9 Make Code
        CASE 195                ' F9 Break Code
            Lasers = Lasers + 1 : IF Lasers > 4 THEN Lasers = 0

        CASE 68                 ' F10 Make Code
        CASE 196                ' F10 Break Code
            Shields = Shields + 1 : IF Shields > 4 THEN Shields = 0

        CASE 87                 ' F11 Make Code
        CASE 215                ' F11 Break Code
            CALL CallOldInt(Registers)      'call the original Int 15h handler
            CallIt = False
            IF PEEK(&H17) AND 3 THEN
                Lasers = 2 : Shields = 2
            ELSE
                SaveLasers = Lasers : SaveShields = Shields
                Strg$ = CHR$(8) : LN = 0 : SN = 0 : GOSUB DoLoops
                GOSUB StuffIt
                IF NOT StuffOkay THEN Lasers = SaveLasers : Shields = SaveShields
            ENDIF

        CASE 88                 ' F12 Make Code
        CASE 216                ' F12 Break Code
            CALL CallOldInt(Registers)      'call the original Int 15h handler
            CallIt = False
            SaveLasers = Lasers : SaveShields = Shields
            Strg$ = "" : LN = 4 : SN = 4 : GOSUB DoLoops
            IF LEN(Strg$) THEN
                GOSUB StuffIt
                IF NOT StuffOkay THEN Lasers = SaveLasers : Shields = SaveShields
            ENDIF
    END SELECT
ENDIF

IF CallIt THEN CALL CallOldInt(Registers)      'call the original Int 15h handler

CALL ReturnFromInt(Registers)   'return to the underlying application
' 
StuffIt:
    NoBuf = ( PEEK(&H1A)=PEEK(&H1C) AND PEEK(&H1B)=PEEK(&H1D) )
    IF NoBuf THEN
        CALL StuffBuf(Strg$)
        StuffOkay = True
    ELSE
        StuffOkay = False
    ENDIF
RETURN
' 
DoLoops:
    DO UNTIL Lasers = LN
        Strg$ = Strg$ + F9$
        Lasers = Lasers + 1 : IF Lasers > 4 THEN Lasers = 0
    LOOP
    DO UNTIL Shields = SN
        Strg$ = Strg$ + F10$
        Shields = Shields + 1 : IF Shields > 4 THEN Shields = 0
    LOOP
RETURN
' 
PopUp:
CALL PopUpHere(0, ID$)          ' no hot key
GOTO EndIt                      ' continue on and end as a TSR
CALL PopDown                    'no matter what, pop down
' 
EndIt:
CALL EndTSR(ID$)                'terminate and stay resident
' 
