#include <stdio.h>

void useage();

void main(int n, char *a[])
{
  int i;
  char s = 0;
  FILE *fp;

/*                                                                         *\
** If no command line arguments, display useage.                           **
\*                                                                         */

  if(n == 1)
    useage();

/*                                                                         *\
** Open file, checking for error. Print useage message if open fails.      **
\*                                                                         */

  if((fp = fopen(a[1], "r+b")) == NULL)
    {
      printf("Error opening input file.\r\n");
      useage();
    }

/*                                                                          \
** Goto the killed/captured pilot flag in the file. Quits if error.         *
\*                                                                          /

  if(fseek(fp, (long)2, SEEK_SET))
    {
      printf("Unknown error in FSEEK.\r\n");
      exit();
    }

/*                                                                         *\
** Get flag character, determine if the pilot was killed or captured, and  **
** give an appropriate text message.                                       **
\*                                                                         */

  s = getc(fp);
  printf("s = %1d", (int)s);
  switch(s)
    {
    case 0:
      printf("This pilot is already alive and not captured!\r\n");
      exit();
      break;
    case 1:
      printf("Rescuing captured pilot...\r\n");
      break;
    case 2:
      printf("Resurrecting pilot killed in action...\r\n");
      break;
    }
  fseek(fp, (long)2, SEEK_SET);

/*                                                                         *\
** Reset flag to "alive" status, close file, give OK message, and quit.    **
\*                                                                         */

  putc(0, fp);
  close(fp);
  switch(s)
    {
    case 1:
      printf("Pilot rescued!\r\n");
      break;
    case 2:
      printf("Pilot resurrected!\r\n");
      break;
    }
}


/*                                                                         *\
** Useage(): Displays a common UNIX-style help message, and exits.         **
\*                                                                         */

void useage()
{
  printf("Useage: REVIVE <name.PLT>\r\n");
  printf(" <name.PLT>: Name of the pilot to revive, with the extention \".PLT\"\r\n");
  printf("\r\n\r\n");
  exit();
}
