' 
' FILEWTCH.BAS  12-19-94  by Matt Hart
'
' Display/print file accesses
' 
' Compile and LINK with:
'
' C:\>bc FILEWTCH /o;
'
' C:\>link /nod/noe/ex FILEWTCH _noread _noerror _noval str00256,,nul,smalldos
'  pdq;
' C:\>exe2com FILEWTCH
'
' Requires the Microsoft BASIC Compiler version 4.x, 6.x, 7.x, or
' Visual Basic/DOS 1.0 and the Crescent Software PDQ library.  VB/DOS or 7.x
' using /fs requires PDQ with far string support.
' 

DEFINT A-Z

'$INCLUDE: 'PDQDECL.BAS'
CONST False = 0
CONST True  = NOT False

DIM Registers AS RegType
DIM Reg AS RegType

ID$ = "FILEWATCH DOS File Open (Int 21h, 3Dh)"
PRINT
PRINT ID$                       'print it
PRINT
PRINT "Copyright 1994 by Matt E. Hart  CompuServe : 75450,3705"

C$ = UCASE$(LTRIM$(RTRIM$(COMMAND$)))
IF INSTR(C$,"?") OR INSTR(C$,"HELP") THEN
ShowHelp:
    PRINT
    PRINT " Syntax:"
    PRINT "        C:\> FILEWTCH [/v] [/{lpt number}]"
    PRINT " /v = Video display"
    PRINT " /1-3 = LPT port number to print to"
    PRINT
    PRINT " Example:
    PRINT "       C:\> FILEWTCH /v /1"
    PRINT " Show filename on screen AND print to LPT1"
    PRINT
    END
ENDIF
DGroup = TSRInstalled%(ID$)     'see if we're already installed
IF DGroup THEN
    IF INSTR(C$,"/U") THEN
        Success1 = UnhookInt(Registers, DGroup)
        Success2 = DeinstallTSR(DGroup, ID$)
        IF Success1 AND Success2 THEN
            PRINT "FILEWATCH removed"
        ELSE
            PRINT "Unable to remove FILEWATCH.  Re-boot now!"
        ENDIF
    ELSE
        PRINT "FILEWATCH already installed"
    ENDIF
    END
ELSEIF INSTR(C$,"/U") THEN
    PRINT "FILEWATCH not installed"
    END
END IF

IF INSTR(C$,"/V") THEN DoVideo = True
IF INSTR(C$,"/1") THEN
    PortNum = 1
ELSEIF INSTR(C$,"/2") THEN
    PortNum = 2
ELSEIF INSTR(C$,"/3") THEN
    PortNum = 3
ENDIF
IF PortNum = 0 THEN DoVideo = True
'  INTERRUPT 21h
'---- Trap Interrupt 21H, DOS services
Registers.IntNum = &H21             'specify trapping Int 21h
CALL PointIntHere(Registers)        'trap the interrupt
GOTO EndIt                          'skip past the Int 21h handler

CALL IntEntry1                      'we arrive here when an app calls for a key
CALL IntEntry2(Registers, Zero)     'these are the two mandatory calls

Service = Registers.AX \ 256

IF Service = &H3D THEN              ' Open file
    IF DoVideo THEN
        IF LEN(ReqFile$) THEN
            LOCATE 1,1
            ReqFile$ = SPACE$(LEN(ReqFile$))
            PRINT ReqFile$;
        ENDIF
    ENDIF
    DEF SEG = Registers.DS
    ReqFile$ = ""
    FOR i = 0 TO 64
        Char = PEEK(Registers.DX + i)
        IF Char = 0 THEN EXIT FOR
        ReqFile$ = ReqFile$ + CHR$(Char)
    NEXT
    DEF SEG
    IF DoVideo THEN
        LOCATE 1,1
        PRINT ReqFile$;
        T& = PDQTimer&+1 : DO UNTIL PDQTimer& > T& : LOOP
    ENDIF
    IF PortNum THEN
        ReqFile$ = ReqFile$ + CHR$(9)
        CALL BIOSLPrint(ReqFile$, BYVAL PortNum)
    ENDIF
ENDIF

CALL GotoOldInt(Registers)      'continue on to the original Int 21h
' 
EndIt:
CALL EndTSR(ID$)                'terminate and stay resident
' 
