  
  SUGGESTED USE:  This is the fact sheet distributed to press and analysts
  needing more information to write about the 21064 microprocessor at the
  time of its announcement, February 25, 1992.

  


                    Digital Equipment Corporation
                             Fact Sheet



 PRODUCT NAME: 21064 150 MHz Microprocessor

 OVERVIEW:   Digital's 21064 150 MHz microprocessor is the first in a
 family of chips to implement Digital's Alpha architecture. ("Alpha" is
 Digital's internal code name.) The 21064 microprocessor is a .75 micron
 CMOS-based super-scalar, super-pipelined processor using dual instruction
 issue and a 150 MHz cycle time (contact Digital for information on faster
 clock rate implementations). The Alpha architecture is a 64-bit RISC
 architecture designed with particular emphasis on speed, multiple
 instruction issue, and multiple processors. 


 21064 MICROPROCESSOR KEY FEATURES:

 o Implements the Advanced Alpha RISC Architecture
     - Optimized for high performance implementations
     - Multiprocessor support
     - IEEE single and double precision, VAX F_floating and G_floating,
       longword, and quadword data types
     - Cycle counter for code optimization

 o Single-chip implementation

 o 3.3-volt supply voltage
 
 o High performance 
     - Dual-pipelined architecture
     - 150 MHz cycle time (contact Digital for information on faster clock
       rate implementations)
     - Peak instruction execution of 300 million operations per second
       (MIPS)

 o Privileged Architecture Library Code (PALcode) supports:
     - Optimization for multiple operating systems
     - Flexible memory management implementations
     - Multi-instruction atomic sequences

 o On-chip write buffer with four 32-byte entries

 o On-chip pipelined floating point unit

 o On-chip 8 Kbyte data cache

 o On-chip 8 Kbyte instruction cache

 o On-chip demand paged memory management unit
     - 12-entry I-stream TB with 8 entries for 8 Kbyte pages and 4 entries
       for 4 Mbyte pages
     - 32-entry D-stream TB with each entry able to map 8 Kbyte, 64 Kbyte,
       512 Kbyte, or 4 Mbyte pages

 o On-chip parity and ECC generators and checkers
 
 o On-chip internal clock generator provides:
     - High-speed chip clock
     - Pair of programmable system clocks (CPU/2 to CPU/8)


                         -more-
 

 o Programmable on-chip performance counters measure CPU and system
   performance

 o Selectable data bus width speed, 64 or 128 bits, 75 MHz to 18.75 MHz

 o External cache memory support:
     - On-chip external secondary cache control
     - Programmable cache size and speed

 o Chip and module level test support


 Operating Characteristics

        Power Supply                      Vss 0.0 V, Vdd 3.3 V +/-5%
        Operating Temperature             Tj max = 85 deg. C
        Storage Temperature Range         -55 deg. C to 125 deg. C
        Power Dissipation @Vdd = 3.45V    23 W typical, 27.5 W maximum
                                          Speed = 6.6 ns
        Die Size		          13.9mm x 16.8mm
        Transistor Count		  1.68 million
        Package				  431 pin PGA
       
 
 Alpha Architecture Summary:

 The 21064 microprocessor implements the Alpha architecture. The Alpha
 architecture supports:

 o A 64-bit virtual address space

 o Separate integer and floating point registers
    - 32 64-bit integer registers
    - 32 64-bit floating point registers
 
 o 32-bit (longword) and 64-bit (quadword) integer along with 32-bit and
   64-bit IEEE and VAX floating-point data types
  
 o Privileged Architecture Library Code (PALcode)

 Instruction Set:  Alpha instructions are all 32 bits in length using four
 different instruction formats specifying 0, 1, 2, or 3 five-bit register
 fields. Each format uses a 6-bit opcode.

 Conditional branch instructions test a register for positive/negative,
 zero/nonzero, or even/odd, and perform a PC relative branch. Unconditional
 branch instructions perform either a PC relative or absolute jump using an
 arbitrary 64-bit register value. They can update a destination register
 with a return address.

 Load/Store Instructions can move either 32-bit or 64-bit quantities. 
 8-bit and 16-bit load/store operations are supported through an extensive
 set of in-register byte manipulations.

 Integer Operate Instructions manipulate full 64-bit values, and include a
 full complement of arithmetic, compare, logical, and shift instructions. 
 In addition there are three 32-bit integer operates: add, subtract, and
 multiply.


                         -more-
 

 The Alpha architecture provides scaled add/subtract for quick subscript
 calculation, 128-bit multiply for division by a constant and
 multiprecision arithmetic, conditional moves for avoiding branches, and an
 extensive set of in-register byte manipulation instructions.

 Floating-Point Operate Instructions include four complete sets of
 instructions for IEEE single, IEEE  double, VAX F_floating and VAX
 G_floating arithmetic. In addition to arithmetic instructions there are
 also  instructions for conversions between floating and integer values
 including the VAX D_floating data type.

 Privileged Architecture Library Code:   PALcode is a privileged library of
 software that atomically performs such functions as the dispatching and
 servicing of interrupts, exceptions, task switching, and additional
 privileged and unprivileged user instructions as specified by operating
 systems using the CALL_PAL instruction.

 PALcode is the only method of performing some operations on the hardware. 
 In addition to the entire Alpha instruction set, a set of implementation
 specific instructions is provided.

 PALcode runs in an environment with privileges enabled, instruction 
 stream mapping disabled, and interrupts disabled.  Disabling memory
 mapping allows PALcode to support functions such as TB miss routines. 
 Disabling interrupts allows the  instruction stream to provide
 multi-instruction sequences as atomic operations.

 Memory Management:   The Alpha memory management architecture is designed
 to provide a large address space for instructions and data, convenient
 and efficient sharing of instructions and data, independent read and write
 access protection, and flexibility through programmable PALcode support.


 Microarchitecture:

 Digital's 21064 microprocessor consists of four independent functional
 units: the integer execution unit (Ebox), floating point unit (Fbox), the
 load/store or address unit (Abox), and the branch unit. Other sections
 include the central control unit (Ibox) and the I and D cache. 

 The Ebox contains a 64-bit, fully pipelined integer execution data path
 including: adder, logic box, barrel shifter, byte extract and mask, and
 independent integer multiplier. The Ebox also contains a 32-entry 64-bit
 integer register file.

 The Fbox contains a fully pipelined floating point unit and independent
 divider, supporting both IEEE and VAX floating point data types. IEEE
 single-precision and double-precision floating point data types are
 supported. VAX F_floating and G_floating data types are fully supported
 with limited support for the D_floating data type.

 The Abox contains five major sections: address translation data path, load
 silo, write buffer, Data cache (Dcache), and the external bus interface
 unit (BIU). The Abox supports all integer and floating point load and
 store instructions, including address calculation and translation, and
 cache control logic.

 The Ibox performs instruction fetch, resource checks, and dual instruction
 issue to the Ebox, Abox, Fbox, or branch unit. In addition, the Ibox
 controls pipeline stalls, aborts, and restarts.

                         -more-
 

 Pipeline Organization: The 21064 microprocessor uses a seven-stage
 pipeline for integer operate and memory reference instructions, and a
 ten-stage pipeline for floating point operate instructions.  The Ibox
 maintains state for all pipeline stages to track outstanding register
 writes.

 Cache Organization:  The 21064 microprocessor contains two on-chip
 caches, data cache (D-cache) and instruction cache (I-cache).  The chip
 also supports an external cache. The D-cache contains 8 Kbytes and is a
 write-through, direct-mapped, read-allocate physical cache with 32-byte
 blocks. The I-cache contains 8 Kbytes and is a physical direct-mapped cache
 with 32-byte blocks.

 The 21064 chip supports external cache built from off-the-shelf static
 RAMs. The 21064 chip directly controls the RAMs  using its programmable
 external cache interface, allowing each implementation to make its own
 external cache speed and configuration trade-offs.

 The external cache interface supports cache sizes from 0 to 8 Mbytes and
 a range of operating speeds that are sub-multiples of the chip clock.

 Virtual Address Space:  The virtual address is a 64-bit unsigned integer
 that specifies a byte location within the virtual address space. The 21064
 microprocessor checks all 64 bits of a virtual address and implements a
 43-bit subset of the address space.  The 21064 supports a physical address
 space of 16 Gbytes.

 
 

 PRICING:  Samples (through June 1992) $3375 each. Volume quantities (July
 1992) starting at $1650 (1,000 pieces).


 AVAILABILITY:  Sample parts available February 1992 for customer
 evaluation. Quantities to support customers' volume ramps available in
 July 1992.

                                 # # #

 
 For Further Information Contact our Hotline:

	1-800-DEC-2717
	1-800-DEC-2515 (Telecommunications Device for the Deaf  TDD)
	508-568-6868 (local number)

 
 Note to Editors:   DEC, the Digital logo, VAX and VMS are trademarks of
 Digital Equipment Corporation.

 OSF/1 is a registered trademark of Open Software Foundation, Inc. UNIX is
 a registered trademark of UNIX System Laboratories, Inc.
 
 