;***********************************************
;	_cnvtime.asm -- replacement of LSI C-86
;	                run time library routine
;***********************************************
			page	0, 128

include	amscls.inc
$_init	GEN

LHA		=		1

CGROUP	GROUP	TEXT
DGROUP	GROUP	DATA,BSS
		assume	cs:CGROUP, ds:DGROUP, ss:DGROUP

TEXT	segment byte public 'CODE'
TEXT	ends

DATA	segment word public 'DATA'
DATA	ends

BSS		segment word public 'DATA'
BSS		ends

tm	struc
	tm_sec		dw		1 dup (?)
	tm_min		dw		1 dup (?)
	tm_hour		dw		1 dup (?)
	tm_mday		dw		1 dup (?)
	tm_mon		dw		1 dup (?)
	tm_year		dw		1 dup (?)
	tm_wday		dw		1 dup (?)
	tm_yday		dw		1 dup (?)
	tm_isdst	dw		1 dup (?)
tm	ends

DATA	segment word public 'DATA'
daysmonth	label	word
m3		dw		31
m4		dw		30
m5		dw		31
m6		dw		30
m7		dw		31
m8		dw		31
m9		dw		30
m10		dw		31
m11		dw		30
m12		dw		31
m1		dw		31
m2		dw		29
DATA	ends

TEXT	segment byte public 'CODE'
			public	_convtime_
_convtime_	proc	near
	push	cx
	push	dx
	push	si
	push	di
	mov		si, ax

	mov		di, 60
	mov		ax, [bx + 2]
	xor		dx, dx
	div		di
	mov		cx, ax
	mov		ax, [bx]
	div		di					; cx:ax
	mov		tm_sec[si], dx

	xchg	ax, cx
	xor		dx, dx
	div		di
	xchg	ax, cx
	div		di					; cx:ax
	mov		tm_min[si], dx

	mov		di, 24
	xchg	ax, cx
	xor		dx, dx
	div		di
	xchg	ax, cx
	div		di					; cx:ax
	mov		tm_hour[si], dx

	mov		cx, ax
	xor		dx, dx
	mov		di, 7
	div		di
	mov		tm_wday[si], dx
	mov		ax, cx

	mov		cx, 68
										; adjust to 1968-3-1
	$_if <add ax, 365 * 2 - 31 - 28>, C, OR
	$_c  <cmp ax, 365 * 32 + 8>, AE
		sub		ax, 365 * 32 + 8		; adjust to 2000-3-1
		mov		cx, 100
if 0
		xor		dx, dx
		mov		di, 365 * 400 + 97
		div		di
		push	dx
		mov		di, 400
		mul		di
		add		cx, ax
		pop		ax
endif
		xor		dx, dx
		mov		di, 365 * 100 + 24
		div		di
		push	dx
		mov		di, 100
		mul		di
		add		cx, ax
		pop		ax
	$_endif
	xor		dx, dx
	mov		di, 365 * 4 + 1
	div		di
	shl		ax, 1
	shl		ax, 1
	add		cx, ax

	mov		di, 365
	mov		ax, dx
	xor		dx, dx
	div		di
	$_if <cmp ax, 4>, AE
		dec		ax
		add		dx, di
	$_endif
	add		ax, cx
ifndef LHA
	mov		bx, dx
	add		bx, 31 + 28
endif
	mov		cx, 2
	mov		di, offset DGROUP:daysmonth
	$_while <sub dx, [di]>, AE
		inc		di
		inc		di
		inc		cx
	$_enddo
	add		dx, [di]
ifndef LHA
	$_if <cmp cx, 12>, AE
		inc		ax
		sub		cx, 12
		sub		bx, 365
	$_else
		$_if <test ax, 3>, Z
			inc		bx
		$_endif
	$_endif
else
	$_if <cmp cx, 12>, AE
		inc		ax
		sub		cx, 12
	$_endif
endif

	inc		dx
	mov		tm_mday[si], dx
	mov		tm_mon[si], cx
	mov		tm_year[si], ax
ifndef LHA
	mov		tm_yday[si], bx
endif
	pop		di
	pop		si
	pop		dx
	pop		cx
	ret
_convtime_	endp
TEXT	ends

		end
