;***********************************************
;	larc_.asm -- extract *.lzs
;***********************************************
			page	0, 128

include	amscls.inc
$_init	GEN


CGROUP	GROUP	TEXT
DGROUP	GROUP	DATA,BSS

TEXT	segment byte public 'CODE'
	assume	cs:CGROUP, ds:DGROUP, ss:DGROUP
TEXT	ends

DATA	segment byte public 'DATA'
DATA	ends

BSS	segment byte public 'DATA'
MAGIC0		=		18
MAGIC5		=		19

flag_		db		1 dup (?)
flagcnt_	db		1 dup (?)
matchpos_	dw		1 dup (?)
BSS	ends

TEXT	segment byte public 'CODE'
	assume	cs:CGROUP, ds:DGROUP, ss:DGROUP
;
;ushort decode_c_lzs(void)
;

	public	decode_c_lzs_
decode_c_lzs_:		
	mov		al,1
	call	getbits_
	$_if <test	ax, ax>, NZ
		mov		al, 8
		jmp		getbits_
	$_endif
	mov		al, 11
	call	getbits_
	mov		matchpos_, ax
	mov		al, 4
	call	getbits_
	add		ax, 256
	ret


;
;ushort decode_p_lzs(int loc)
;

	public	decode_p_lzs_
decode_p_lzs_:		
	sub		ax, matchpos_
	sub		ax, MAGIC0
	and		ax, 07ffh
	ret


;
;void decode_start_lzs(void)
;

	public	decode_start_lzs_
decode_start_lzs_:		
	jmp		init_getbits_


;
;ushort decode_c_lz5(void)
;

	public	decode_c_lz5_
decode_c_lz5_:		
	$_if <dec flagcnt_>, S
		mov		flagcnt_, 7
		mov		ax, infile_
		call	fgetc_
		mov		flag_, al
	$_endif
	mov		ax,	infile_
	call	fgetc_
	$_if <shr flag_, 1>, NC
		mov		matchpos_, ax
		mov		ax, infile_
		call	fgetc_
		mov		bx, ax
		and		bx, 0f0h
		shl		bx, 1
		shl		bx, 1
		shl		bx, 1
		shl		bx, 1
		add		matchpos_, bx
		and		ax, 0fh
		add		ax, 100h
	$_endif
	ret


;
;ushort decode_p_lz5(int loc)
;

	public	decode_p_lz5_
decode_p_lz5_:		
	sub		ax, word ptr DGROUP:[matchpos_]
	sub		ax, MAGIC5
	and		ax, 0fffh
	ret


;
;void decode_start_lz5(void)
;

	public	decode_start_lz5_
decode_start_lz5_:		
	push	cx
	push	di
	xor		ax, ax
	mov		flagcnt_, al
	push	ds
	pop		es
	cld
	mov		di, offset DGROUP:text_ + 3000h + 18
	mov		ch, al
	$_do
		mov		cl, 13
		rep		stosb
	$_until <inc al>, Z
	$_do
		stosb
	$_until <inc al>, Z
	$_do
		dec		al
		stosb
	$_until , Z
	mov		cx, 128
	rep		stosb
	mov		cx, 128 - 18
	mov		al, ' '
	rep		stosb
	pop		di
	pop		cx
	RET	

	EXTRN	getbits_:near
	EXTRN	init_getbits_:near
	EXTRN	memset_:near
	EXTRN	fgetc_:near

TEXT	ends

	EXTRN	text_:byte
	EXTRN	infile_:word

	END
