/***********************************************************
	getopt.c -- get options
***********************************************************/
#include <ctype.h>
#include <stddef.h>
#include <string.h>
#include "lh.h"

char	flg_r, flg_p, flg_x, flg_m, flg_a, flg_c, flg_n, flg_t, flg_u,
        flg_v, flg_w, flg_i, flg_h = 1, flg_o, flg_z, flg_l, flg_at;

/*******************************
		get options
*******************************/
int getopt(char *p)
{
	static char flg[] = "rpxmacntuvwihozl-";
	static char *flgpos[] = {&flg_r, &flg_p, &flg_x, &flg_m, &flg_a, 
							 &flg_c, &flg_n, &flg_t, &flg_u, &flg_v, 
							 &flg_w, &flg_i, &flg_h, &flg_o, &flg_z,
							 &flg_l, &flg_at};
	static char val[] = "0-1+2";

	int i;
	char s;
	char *q;

	while ((s = tolower(*p)) != 0) {
		p++;
		q = strchr(flg, s);		/* search switch */
		if (q) {
			i = q - flg;
			if (*p && (q = strchr(val, *p)) != NULL) {
				*flgpos[i] = (q - val) / 2;
				p++;
			}
#if 0
			  else if (s == 'v' && *p) {
				if (flg_v == 0)			/* process of '/vSTRING' */
					flg_v = 1;
				pager = p;
				p = "";
			}
#endif
			  else if (s == 'z' && *p) {
				flg_z = 2;				/* process of '/zSTRING' */
				regext(p);
				p = "";
			} else if (s == 'w' && *p) {
				flg_w = 1;				/* process of '/wSTRING' */
				strcpy(workdir, p);
				p = "";
			} else {
				/* flip-flop */
				*flgpos[i] = !*flgpos[i];
			}
		}
#if 0
		  else if (s == 'k') {
			keyword = p;
			p = "";
		}
#endif
		  else {
			if (s == '?') usage();
			return 1;
		}
	}
	return 0;
}
