/***********************************************************
	dosio.c -- MS-DOS dependent I/O
***********************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dos.h>
#include "lh.h"

time_t getfiletime(FILE *f)
{
	union stamp stamp;

	_dos_getftime(fileno(f), (unsigned *)&(stamp.t.date), 
	                         (unsigned *)&(stamp.t.time));
	return dos2unix(&stamp.s);
}

int setfiletime(FILE *f, time_t utc)
{
	union stamp *stamp;

	stamp = (union stamp *)unix2dos(utc);
	fflush(f);
	return _dos_setftime(fileno(f), stamp -> t.date, stamp -> t.time);
}

static char breakval;

static char breakctrl(char al, char dl)
{
    union REGS reg;

    reg.h.ah = 0x33;
    reg.h.al = al;
    reg.h.dl = dl;
    intdos(&reg, &reg);
    return reg.h.dl;
}

void break_get_on(void)
{
	breakval = breakctrl(0, 0);
	breakctrl(1, 1);
}

void break_off(void)
{
	breakctrl(1, 0);
}

void break_set(void)
{
	breakctrl(1, breakval);
}

#if 0
#if 1
int getfileattr(char *path)
{
    union REGS reg;
    struct SREGS sreg;

    segread(&sreg);
    reg.x.ax = 0x4300;
    reg.x.dx = FP_OFF(path);
    sreg.ds = FP_SEG(path);
    intdosx(&reg, &reg, &sreg);
    return reg.x.cflag ? -1 : reg.x.cx;
}

int setfileattr(char *path, int attr)
{
    union REGS reg;
    struct SREGS sreg;

    segread(&sreg);
    reg.x.ax = 0x4301;
    reg.x.cx = attr;
    reg.x.dx = FP_OFF(path);
    sreg.ds = FP_SEG(path);
    intdosx(&reg, &reg, &sreg);
    return reg.x.cflag ? -1 : reg.x.cx;
}

#else
int getfileattr(char *path)
{
	int i;

	return _chmod(path, 0);
}

int setfileattr(char *path, int attr)
{
	return _chmod(path, 1, attr);
}
#endif
#endif

static char physicaldrive(char *filename)
{
	union REGS regs;
	char physical[80];

	strcpy(physical, filename);
	regs.x.si = (unsigned)filename;
	regs.x.di = (unsigned)physical;
	regs.h.ah = 0x60;
	intdos(&regs, &regs);
	if (physical[1] != ':') return 0;
	return *physical - 'A' + 1;
}

long diskspace(char *filename)
{
	struct diskfree_t dtable;
	struct find_t srchbuf;
	long cluster, freespace;

	if (_dos_findfirst(filename, 0x07, &srchbuf)) srchbuf.size = 0;
	_dos_getdiskfree(physicaldrive(filename), &dtable);
	cluster = (long)dtable.bytes_per_sector * (long)dtable.sectors_per_cluster;
	freespace = (long)dtable.avail_clusters * cluster;
	freespace += (srchbuf.size + cluster - 1) / cluster * cluster;
	return freespace;
}
