/***********************************************************
	disp.c -- display filenames
***********************************************************/
#include <stdio.h>
#include "lh.h"
#include "intrface.h"

char *procptr;
char *fileptr;
ushort maxblk;
ushort blkcnt;
ushort curcnt;
ushort nxtcnt;

extern int fcount, tcount;

void regdisp(char *p, char *q)
{
	procptr = p;
	fileptr = (flg_l) ? hpb.pathname : hpb.filename;
	if (q && flg_l == 2) fileptr = q;
	maxblk = (flg_l) ? 67 : 57;
	fcount++;
}

void dispname(void)
{
	if (flg_n == 2) return;
	eprintf((flg_l) ? "\r  %-8s " : "\r%-8s %-12s ", procptr, fileptr);
}

void dispalone(char *p)
{
	regdisp(p, NULL);
	if (outredir) printf("%s\n", fileptr);
	if (flg_n != 2) eprintf("%-8s %s", p, fileptr);
}

void disp(int view, int redir)
{
	int dicsiz, blk;

	blkcnt = -1;
	if (view) return;
	if (redir) printf("%s\n", fileptr);
	if (flg_n == 2) return;
	if (flg_l) {
		eprintf("[%d", fcount);
		if (cmd == 'U' || cmd == 'M') eprintf("/%d", tcount);
		eprintf("] %s\n", fileptr);
	}
	dispname();
	if (flg_n) return;
	dicsiz = 1 << interface.dicbit;
	blkcnt = blk =(interface.original + dicsiz - 1) / dicsiz;
	if (blk > maxblk) blk = maxblk;
	while (blk) {
		fputc('.', stderr);
		blk--;
	}
	dispname();
}

void enddisp(char *p)
{
	if (flg_n == 2) return;
	eprintf((flg_l) ? "\r  %-8s \n" : "\r%-8s \n", p);
}

#if 0
void initdisp(void)
{
	curcnt = nxtcnt = 0;
	if (blkcnt == -1) nxtcnt = -1;
}

void dispmark(char mark)
{
	if (curcnt >= nxtcnt) {
		fputc(mark, stderr);
		if (blkcnt > maxblk) {
			nxtcnt = (((long)curcnt * maxblk + blkcnt - 1) / blkcnt + 1) 
			         * blkcnt / maxblk;
		} else {
			nxtcnt++;
		}
	}
	curcnt++;
}
#endif

void increment_disp(void)
{
	fcount++;
}

void skipdisp(char *mes)
{
	if (flg_n == 2) return;
	regdisp("Skipped", cmd == 'E' ? filename3 : NULL);
	interface.original = 0;
	disp(0, 0);
	eprintf(": %s\n", mes);
}
