/*********************************************************************

   FAXCOM Copyright Raymond P. Wilson 1989.

   This program is a shareware program. If you use it then credit must be
   given to the author (me). If you find this program useful please send
   ($25 is suggested) or whatever you think it is worth to :

			Raymond P. Wilson
			38 Paremata St
			Atawhai
			Nelson
			New Zealand

If you wish to use this, or parts of this, program in a commercial product then the authors permission is required.

**********************************************************************/
/* This file contains variable and macro definitions common to the
   faxcoder and faxdecoder */

#define NUM_LINES          2376    /* Number of lines in the fax */
#define BYTES_PER_LINE     216     /* Bytes per line in fax */
#define BITS_PER_LINE      (8 * BYTES_PER_LINE)
				   /* Bits on a fax line */
#define FAX_SIZE           (NUM_LINES * BYTES_PER_LINE)
				   /* Size (in bytes) of a fax file */
#define MODEL_ORDER        16      /* Number of bits of context */
#define NUM_CONTEXTS       (1 << MODEL_ORDER)
#define HALVE_LIMIT        16383   /* Halve counts when sum reaches this */

#define CONTEXT_MASK       0x3ff /* This masks out unwanted portions of the
                                    context from the bit immediately above */
                                    
#define CONTEXT_SIDE_BITS  3 /* Number bits to side of fax page to allow
				for context spilling over sides */
                              
#define CONTEXT_WINDOW_BPL (BITS_PER_LINE + 2 * CONTEXT_SIDE_BITS)
			     /* Bits per line for context bits array */

int cmpbytes = 0,   /* Number of compressed bytes outputted */
    line,           /* Line currently on in fax file */
    saved[CONTEXT_WINDOW_BPL];
                    /* Array that holds saved pieces of context */

struct context_type    /* This structure holds the counts for zeros and the */
{		       /* sum of zeros and ones for a context               */
   int zero_count, sum;
} contexts[NUM_CONTEXTS]; /* The array that holds context information */

/* Get a bit from the input file */

#define getabit() 	\
   if ((mask>>=1) ==0)	\
   {			\
      byte=getchar();	\
      mask=0x80;	\
   }

/* Write a zero bit out to the output file */

#define write_decoded0       \
{                            \
   byte <<= 1 ;              \
   bitsleft-- ;              \
   if (bitsleft==0)          \
   {                         \
      putc(byte, stdout) ;   \
      bitsleft = 8 ;         \
   }                         \
}

/* Write a one bit out to the output file */

#define write_decoded1       \
{                            \
   byte = (byte << 1) | 0x1; \
   bitsleft-- ;              \
   if (bitsleft==0)          \
   {                         \
      putc(byte, stdout) ;   \
      bitsleft = 8 ;         \
   }                         \
}

#ifdef UNIX
float start_time,total_time;
/*
 * get_time()
 *
 * return amount of CPU time in seconds used since starting
 */

float get_time()
{
        struct rusage rusage;

	getrusage(RUSAGE_SELF,&rusage);
        return(rusage.ru_utime.tv_sec +
	       rusage.ru_utime.tv_usec/1000000.0 +
	       rusage.ru_stime.tv_sec +
	       rusage.ru_stime.tv_usec/1000000.0) ;
}
#endif
