*****************************************
*	68HC11 INTERNAL REGISTERS	*
*	  J P SOMERS   05/01/87		*
*****************************************

*     DEFINITIONS

REGS	EQU     $1000

*  PORT A DATA REGISTER
PORTA	EQU	0

RESVD	EQU	1	UNUSED

*  PARALLEL I/O CONTROL REGISTER
PIOC	EQU	2
* STROBE A FLAG
*  0= INACTIVE
*  1= SET AT ACTIVE EDGE OF STRA PIN
STAF	EQU	%10000000
* STROBE A INTERRUPT ENABLE
*  0= NO HARDWARE INTERRUPT GENERATED
*  1= HARDWARE INTERRUPT REQ WHEN STAF=1
STAI	EQU	%01000000
* PORT C WIRE-OR MODE
*  0= PORT C OUTPUTS NORMAL
*  1= OPEN DRAIN
CWOM	EQU	%00100000
* HANDSHAKE/SIMPLE STROBE MODE SELECT
*  0= SIMPLE STROBE MODE
*  1= FULL HANDSHAKE MODES
HNDS	EQU	%00010000
* OUTPUT/INPUT HANDSHAKE SELECT
*  0= INPUT
*  1= OUTPUT
OIN	EQU	%00001000
* PULSE MODE SELECT FOR STRB OUTPUT
*  0= STRB LEVEL ACTIVE
*  1= STRB PULSES
PLS	EQU	%00000100
* ACTIVE EDGE SELECT FOR STRA
*  0= HI TO LO (FALLING)
*  1= LO TO HI (RISING)
EGA	EQU	%00000010
* INVERT STRB OUTPUT
*  0= STRB ACTIVE LOW
*  1= STRB ACTIVE HIGH
INVB	EQU	%00000001

*  PORT C DATA REGISTER
PORTC	EQU	3
*  PORTB DATA REGISTER
PORTB	EQU	4
*  PORT C LATCHED DATA REGISTER
PORTCL	EQU	5
RESVD1	EQU	6	UNUSED
*  DATA DIRECTION REGISTER FOR PORT C
DDRC	EQU	7
*  PORT D DATA REGISTER
PORTD	EQU	8
*  DATA DIRECTION REGISTER FOR PORT D
DDRD	EQU	9
*  PORT E DATA REGISTER
PORTE	EQU	$A

*  TIMER COMPARE FORCE REGISTER
CFORC	EQU	$B
FOC1	EQU	%10000000
FOC2	EQU	%01000000
FOC3	EQU	%00100000
FOC4	EQU	%00010000
FOC5	EQU	%00001000

*  OUTPUT COMPARE 1 MASK REGISTER
OC1M	EQU	$C
OC1M7	EQU	%10000000
OC1M6	EQU	%01000000
OC1M5	EQU	%00100000
OC1M4	EQU	%00010000
OC1M3	EQU	%00001000

*  OUTPUT COMPARE 1 DATA REGISTER
OC1D	EQU	$D
OC1D7	EQU	%10000000
OC1D6	EQU	%01000000
OC1D5	EQU	%00100000
OC1D4	EQU	%00010000
OC1D3	EQU	%00001000

*  TIMER COUNTER REGISTER (2 BYTES)
TCNT	EQU	$E

*  TIMER INPUT CAPTURE REGISTERS (3 REGS, 6 BYTES)
TIC1	EQU	$10
TIC2	EQU	$12
TIC3	EQU	$14
*  TIMER OUTPUT COMPARE REGISTERS (5 REGS, 10 BYTES)
TOC1	EQU	$16
TOC2	EQU	$18
TOC3	EQU	$1A
TOC4	EQU	$1C
TOC5	EQU	$1E

*  TIMER CONTROL REGISTER 1
TCLT1	EQU	$20
*  OMx  OLx  ACTION UPON SUCCESSFUL COMPARE
*   0    0    TIMER DISC FROM OUTPUT PIN
*   0    1    TOGGLE OCx OUTPUT LINE
*   1    0    CLEAR OCx OUTPUT LINE TO ZERO
*   1    1    SET OCx OUTPUT LINE TO ONE
OM2	EQU	%10000000
OL2	EQU	%01000000
OM3	EQU	%00100000
OL3	EQU	%00010000
OM4	EQU	%00001000
OL4	EQU	%00000100
OM5	EQU	%00000010
OL5	EQU	%00000001

*  TIMER CONTROL REGISTER 2
TCLT2	EQU	$21
* EDGxB EDGxA  CONFIGURATION
*   0     0    CAPTURE DISABLED
*   0     1    CAPTURE ON RISING EDGES ONLY
*   1     0    CAPTURE ON FALING EDGES ONLY
*   1     1    CAPTURE ON ANY EDGE (RISING OR FALLING)
EDG1B	EQU	%00100000
EDG1A	EQU	%00010000
EDG2B	EQU	%00001000
EDG2A	EQU	%00000100
EDG3B	EQU	%00000010
EDG3A	EQU	%00000001

*  MAIN TIMER INTERRUPT MASK REG 1
TMSK1	EQU	$22
OC1I	EQU	%10000000
OC2I	EQU	%01000000
OC3I	EQU	%00100000
OC4I	EQU	%00010000
OC5I	EQU	%00001000
IC1I	EQU	%00000100
IC2I	EQU	%00000010
IC3I	EQU	%00000001

*  MAIN TIMER INTERRUPT FLAG REG 1
TFLG1	EQU	$23
OC1F	EQU	%10000000
OC2F	EQU	%01000000
OC3F	EQU	%00100000
OC4F	EQU	%00010000
OC5F	EQU	%00001000
IC1F	EQU	%00000100
IC2F	EQU	%00000010
IC3F	EQU	%00000001

*  MISC TIMER INTERRUPT MASK REG 2
TMSK2	EQU	$24
* TIMER OVERFLOW INTERRUPT ENABLE
TOI	EQU	%10000000
* RTI INTERRUPT ENABLE
RTII	EQU	%01000000
* PULSE ACCUMULATOR OVERFLOW INTERRUPT ENABLE
PAOVI	EQU	%00100000
* PULSE ACCUMULATOR INPUT INTERRUPT ENABLE
*  0= INTERRUPT INHIBITED
*  1= INTERRUPT REQUESTED IF FLAG SET
PAII	EQU	%00010000
* PR1  PR2  PRESCALE FACTOR
*  0    0      1
*  0    1      4
*  1    0      8
*  1    1     16
PR1	EQU	%00000010
PR0	EQU	%00000001

*  MISC TIMER INTERRUPT FLAG REG 2
TFLG2	EQU	$25
* TIMER OVERFLOW FLAG
TOF	EQU	%10000000
* REAL TIME (PERIODIC) INTERRUPT FLAG
RTIF	EQU	%01000000
* PULSE ACCUMULATOR OVERFLOW FLAG
PAOVF	EQU	%00100000
* PULSE ACCUMULATOR INPUT EDGE FLAG
PAIF	EQU	%00010000

*  PULSE ACCUMULATOR CONTROL REGISTER
PACTL	EQU	$26
* DATA DIRECTION FOR PA7
*  0= INPUT
*  1= OUTPUT
DDRA7	EQU	%10000000
* PULSE ACCUMULATOR SYSTEM ENABLE
*  0= DISABLED
*  1= ENABLED
PAEN	EQU	%01000000
* PULSE ACCUMULATOR MODE
*  0= EVENT COUNTER
*  1= GATED TIME ACCUMULATION
PAMOD	EQU	%00100000
* PULSE ACCUMULATOR EDGE CONTROL
*  0= FALLING EDGES, HIGH LEVEL ENABLES ACCUM
*  1= RISING EDGES, LOW LEVEL ENABLES ACCUM
PEDGE	EQU	%00010000
* RTI INTERRUPT RATE
*  RTR1 RTR0  DIV E BY
*   0    0     2^13
*   0    1     2^14
*   1    0     2^15
*   1    1     2^16
RTR1	EQU	%00000010
RTR0	EQU	%00000001

*  PULSE ACCUMULATOR COUNT REGISTER
PACNT	EQU	$27

*  SPI CONTROL REGISTER
SPCR	EQU	$28
* SPI INTERRUPT ENABLE
SPIE	EQU	%10000000
* SPI SYSTEM ENABLE
SPE	EQU	%01000000
* PORT D WIRE-OR MODE
*  0=PORT D OUTPUTS NORMAL
*  1=OPEN DRAIN
DWOM	EQU	%00100000
* MASTER/SLAVE MODE SELECT
*  0=SLAVE MODE
*  1=MASTER MODE
MSTR	EQU	%00010000
* CLOCK POLARITY
CPOL	EQU	%00001000
* CLOCK PHASE
CPHA	EQU	%00000100
* SPI CLOCK (SCK) RATE BIT
*  SPR1 SPR0  E DIV BY
*   0    0       2
*   0    1       4
*   1    0       16
*   1    1       32
SPR1	EQU	%00000010
SPR0	EQU	%00000001

*  SPI STATUS REGISTER
SPSR	EQU	$29
* SPI INTERRUPT REQUEST
SPIF	EQU	%10000000
* WRITE COLLISION STATUS FLAG
WCOL	EQU	%01000000
* SPI MODE ERROR INTERRUPT STATUS FLAG
MODF	EQU	%00010000

*  SPI DATA REGISTER
SPDR	EQU	$2A

*  SCI BAUD RATE CONTROL REGISTER
BAUD	EQU	$2B
* CLEAR BAUD COUNTER CHAIN (TEST ONLY)
TCLR	EQU	%10000000
* SERIAL PRESCALER SELECTS
*  SCP1 SCP0  DIV E BY
*   0    0       1
*   0    1       3
*   1    0       4
*   1    1      13
SCP1	EQU	%00100000
SCP0	EQU	%00010000
* SCI BAUD RATE CLOCK TEST (TEST ONLY)
RCKB	EQU	%00001000
* SCI RATE SELECT BIT 2 THRU BIT 0
*  SCR2 SCR1 SCR0  PRESC OUT DIV BY
*   0    0    0          1
*   0    0    1          2
*   0    1    0          4
*   0    1    1          8
*   1    0    0         16
*   1    0    1         32
*   1    1    0         64
*   1    1    1        128
SCR2	EQU	%00000100
SCR1	EQU	%00000010
SCR0	EQU	%00000001

*  SCI CONTROL REGISTER 1
SCCR1	EQU	$2C
* RECEIVE BIT 8
R8	EQU	%10000000
* TRANSMIT BIT 8
T8	EQU	%01000000
* MODE SELECT
*  0 = 1 START, 8 DATA, 1 STOP
*  1 = 1 START, 8 DATA, 9TH DATA, 1 STOP BIT
M	EQU	%00010000
* WAKE = WAKE UP (BY ADDRESS MARK/IDLE)
*  0 = WAKE UP BY IDEL LINE
*  1 = WAKE UP BY ADDRESS MARK
WAKE	EQU	%00001000

*  SCI CONTROL REGISTER 2
SCCR2	EQU	$2D
* TRANSMIT INTERRUPT ENABLE
TIE	EQU	%10000000
* TRANSMIT COMPLETE INTERRUPT ENABLE
TCIE	EQU	%01000000
* RECEIVER INTERRUPT ENABLE
RIE	EQU	%00100000
* IDLE LINE INTERRUPT ENABLE
*  0=INHIBIT INTERRUPTS
*  1=ENABLE INTERRUPTS
ILIE	EQU	%00010000
* TRANSMITER ENABLE (TOGGLE TO QUEUE IDLE CHAR)
TE	EQU	%00001000
* RECEIVER ENABLE
*  0=OFF
*  1=ON
RE	EQU	%00000100
* RECEIVER WAKE-UP CONTROL
*  0=NORMAL
*  1=RECEIVER ASLEEP
RWU	EQU	%00000010
* SEND BREAK
SBK	EQU	%00000001

*  SCI STATUS REGISTER
SCSR	EQU	$2E
* TRANSMIT DATA REG EMPTY FLAG
TDRE	EQU	%10000000
* TRANSMIT COMPLETE FLAG
TC	EQU	%01000000
* RECEIVE DATA REG FULL FLAG
RDRF	EQU	%00100000
* IDLE LINE DETECTED FLAG
IDLE	EQU	%00010000
* OVER-RUN ERROR FLAG
OR	EQU	%00001000
* NOISE ERROR FLAG
NF	EQU	%00000100
* FRAMING ERROR FLAG
FE	EQU	%00000010

*  SCI DATA REGISTER
* RECEIVE AND TRANSMIT DOUBLE BUFFERED
SCDR	EQU	$2F

*  A/D CONTROL/STATUS REGISTER
ADCTL	EQU	$30
* CONVERSIONS COMPLETE FLAG (SETS AFTER 4TH CONVERSION)
CCF	EQU	%10000000
* CONTINUOUS SCAN CONTROL
*  0=4 CONVERSIONS AND STOP
*  1=CONVERT CONTINUOUSLY
SCAN	EQU	%00100000
* MULTIPLE CHANNEL/SINGLE CHANNEL CONTROL
*  0=CONVER SINGLE CHANNEL
*  1=CONVERT FOUR CHANNEL GROUP
MULT	EQU	%00010000
*  CD  CC  CB  CA    CHANNEL SIGNAL  RESULT IN ADRX
*--------------------------------------------------
*  0   0   0   0     ADO PORT E0	ADR1
*  0   0   0   1     ADO PORT E1	ADR2
*  0   0   1   0     ADO PORT E2	ADR3
*  0   0   1   1     ADO PORT E3	ADR4
*  0   1   0   0     ADO PORT E4	ADR1
*  0   1   0   1     ADO PORT E5	ADR2
*  0   1   1   0     ADO PORT E6	ADR3
*  0   1   1   1     ADO PORT E7	ADR4
*  1   0   0   0     RESERVED		ADR1
*  1   0   0   1     RESERVED		ADR2
*  1   0   1   0     RESERVED		ADR3
*  1   0   1   1     RESERVED		ADR4
*  1   1   0   0     VREF HI		ADR1
*  1   1   0   1     VREF LOW		ADR2
*  1   1   1   0     VREF HI/2		ADR3
*  1   1   1   1     TEST/RESERVED	ADR4
CD	EQU	%00001000
CC	EQU	%00000100
CB	EQU	%00000010
CA	EQU	%00000001

*  A/D RESULT REGISTERS
ADR1	EQU	$31
ADR2	EQU	$32
ADR3	EQU	$33
ADR4	EQU	$34

RESVD2	EQU	$35	UNUSED
RESVD3	EQU	$36	UNUSED
RESVD4	EQU	$37	UNUSED
RESVD5	EQU	$38	UNUSED

*  SYSTEM CONFIGURATION OPTIONS
OPTION	EQU	$39
* A TO D POWER UP
*  0= A/D SYSTEM POWERED DOWN
*  1= A/D SYSTEM POWERED UP
ADPU	EQU	%10000000
* CLOCK SELECT
* SHOULD BE USED IF E LESS THAN 1MHZ
*  0= A/D & EE USE SYSTEM E CLOCK
*  1= A/D & EE USE AN INTERNAL R-C CLOCK
CSEL	EQU	%01000000
* IRQ SELECT EDGE SENSITIVE ONLY (TIME PROTECTED)
*  0= IRQ CONFIGURED FOR LOW LEVEL
*  1= IRQ CONFIGURED FOR FALLING EDGES
IRQE	EQU	%00100000
* ENABLE OSCILATOR START UP DELAY (EXITING FROM STOP)
*  0= NO DELAY
*  1= A DELAY IS IMPOSED
DLY	EQU	%00010000
* CLOCK MONITOR ENABLE
*  0= DISABLED
*  1= SLOW OR STOPPED CLOCKS CAUSE RESET
CME	EQU	%00001000
* COP TIMER RATE SELECT BITS
* CR1 CR0 E/2^15 DIV BY
*  0   0      1
*  0   1      4
*  1   0     16
*  1   1     64
CR1	EQU	%00000010
CR0	EQU	%00000001

*  CR1  CR0	E/2^15 DIV BY
*----------------------------
*   0    0	1
*   0    1	4
*   1    0	16
*   1    1	64

*  ARM/RESET COP TIMER CIRCUITRY
COPRST	EQU	$3A

*  EEPROM PROGRAMMING REGISTER
PPROG	EQU	$3B
* PROGRAM ODD ROWS IN HALF OF EEPROM (TEST)
ODD	EQU	%10000000
* PROGRAM EVEN ROWS IN HALF OF EEPROM (TEST)
EVEN	EQU	%01000000
* BYTE/OTHER EEPROM ERASE MODE
*  0= ROW OR ALL ERASE MODE WILL BE USED
*  1= ERASE ONLY ONE BYTE OF EEPROM
BYTE	EQU	%00010000
* ROW/ALL EEPROM ERASE MODE
*  0= ALL 512 BYTES OF EEPROM TO BE ERASED
*  1= ERASE ONLY ONE 16 BYTE ROW OF EEPROM
ROW	EQU	%00001000
* ERASE/NORMAL CONTROL OF EEPROM
*  0= NORMAL READ OR PROGRAM MODE
*  1= ERASE MODE
ERASE	EQU	%00000100
*  EEPROM LATCH CONTROL
*  0= EEPROM ADDRESS AND DATA BUS CONFIG FOR READS
*  1= EEPROM BUSS CONFIG FOR PROGRAM OR ERASE
*     EEPROM CANNOT BE READ WHILE EELAT = 1
EELAT	EQU	%00000010
* EEPROM PROGRAM COMMAND
*   WRITABLE ONLY IF EELAT = 1
*  0= PROGRAM (OR ERASE) POWER SWITCHED OFF
*  1= PROGRAM (OR ERASE) POWER SWITCHED ON
EEPGM	EQU	%00000001

*  HIGHEST PRIORITY INTERRUPT AND MISC.
HPRIO	EQU	$3C
* READ BOOTSTRAP ROM (ONLY WRITABLE IF SMOD=1)
*  0= BOOT ROM NOT IN MAP (NORMAL)
*  1= BOOT ROM ENABLED
RBOOT	EQU	%10000000
* INTERNAL READ VISIBILITY
*  0= NO VISIBILITY OF INTERNAL READS ON EXTERNAL BUS
*  1= DATA FROM INTERNAL READS IS DRIVEN OUT DATA BUS
IRV	EQU	%00010000
* SPECIAL MODE SELECT
*  MODB MODA	MODE DESCR	SMOD MDA
*---------------------------------------
*   1    0	SINGLE CHIP	0    0
*   1	 1	EXPANDED MUX	0    1
*   0	 0	BOOTSTRAP	1    0
*   0	 1	SPECIAL TEST	1    1
SMOD	EQU	%01000000
* MODE SELECT
MDA	EQU	%00100000
* PRIORITY SELECT
* MAY ONLY BE WRITTEN IF I BIT IN CC REG IS 1
* PSEL3 PSEL2 PSEL1 PSEL0	INTERRUPT
*------------------------------------------
*   0     0     0     0		TIMER OVERFLOW
*   0     0     0     1		PULSE ACCUM OVERFL
*   0     0     1     0		PULSE ACC EDGE
*   0     0     1     1		SPI XFER COMPLETE
*   0     1     0     0		SCI SERIAL SYSTEM
*   0     1     0     1		RESERVED (DEFAULT IRQ)
*   0     1     1     0		IRQ (PIN OR PAR I/O)
*   0     1     1     1		REAL TIME INTERRUPT
*   1     0     0     0		TIMER INPUT CAPTURE 1
*   1     0     0     1		TIMER INPUT CAPTURE 2
*   1     0     1     0		TIMER INPUT CAPTURE 3
*   1     0     1     1		TIMER OUTPUT COMPARE 1
*   1     1     0     0		TIMER OUTPUT COMPARE 2
*   1     1     0     1		TIMER OUTPUT COMPARE 3
*   1     1     1     0		TIMER OUTPUT COMPARE 4
*   1     1     1     1		TIMER OUTPUT COMPARE 5
PSEL3	EQU	%00001000
PSEL2	EQU	%00000100
PSEL1	EQU	%00000010
PSEL0	EQU	%00000001

*  RAM AND I/O MAPPING REGISTER
INIT	EQU	$3D
RAM3	EQU	%10000000
RAM2	EQU	%01000000
RAM1	EQU	%00100000
RAM0	EQU	%00010000
REG3	EQU	%00001000
REG2	EQU	%00000100
REG1	EQU	%00000010
REG0	EQU	%00000001

*  FACTORY TEST REGISTER
*   RESTRICTED TEST MODES ONLY
TEST1	EQU	$3E
* TEST ILLEGAL OPCODE
TILOP	EQU	%10000000
* OUTPUT CONDITION CODE REG STAT TO TIMER PORT
OCCR	EQU	%00100000
* TIMER DIVIDER CHAIN BYPASS
CBYP	EQU	%00010000
* DISABLE RESETS FROM COP AND CLOCK MONITOR
DISR	EQU	%00001000
* FORCE CLOCK MONITOR FAILURE
FCM	EQU	%00000100
* FORCE COP WATCHDOG FAILURE
FCOP	EQU	%00000010
* TEST CONFIGURATION
TCON	EQU	%00000001

*  CONFIGURATION CONTROL REGISTER
CONFIG	EQU	$3F
* SECURITY MODE DISABLE (MASK)
*  0=SECURITY MODE
*  1=NO SECURITY
NOSEC	EQU	%00001000
* COP SYSTEM DISABLE
*  0=COP SYSTEM ENABLED (FORCES RESET ON TIMEOUT)
*  1=COP SYSTEM DISABLED
NOCOP	EQU	%00000100
* ROM ENABLE
*  0= ROM IS NOT IN THE MEMORY MAP
*  1= ROM ON AT $E000 TO $FFFF
ROMON	EQU	%00000010
* EEPROM ENABLE
*  0= EEPROM IS NOT IN THE MEMORY MAP
*  1= EEPROM ON AT $B600 TO $B7FF
EEON	EQU	%00000001

*   INTERRUPT VECTOR ASSIGNMENT

RESVEC0	EQU	$FFC0	RESERVED
RESVEC1	EQU	$FFC2	RESERVED
RESVEC2	EQU	$FFC4	RESERVED
RESVEC3	EQU	$FFC6	RESERVED
RESVEC4	EQU	$FFC8	RESERVED
RESVEC5	EQU	$FFCA	RESERVED
RESVEC6	EQU	$FFCC	RESERVED
RESVEC7	EQU	$FFCE	RESERVED
RESVEC8	EQU	$FFD0	RESERVED
RESVEC9	EQU	$FFD2	RESERVED
RESVECA	EQU	$FFD4	RESERVED
VECSCI	EQU	$FFD6	SCI SERIAL SYSTEM
VECSPI	EQU	$FFD8	SPI SERIAL TRANSFER COMPLETE
VECPAI	EQU	$FFDA	PULSE ACC INPUT EDGE
VECPAO	EQU	$FFDC	PULSE ACC OVERFLOW
VECTOV	EQU	$FFDE	TIMER OVERFLOW
VECTO5	EQU	$FFE0	TIMER OUTPUT COMPARE 5
VECTO4	EQU	$FFE2	TIMER OUTPUT COMPARE 4
VECTO3	EQU	$FFE4	TIMER OUTPUT COMPARE 3
VECTO2	EQU	$FFE6	TIMER OUTPUT COMPARE 2
VECTO1	EQU	$FFE8	TIMER OUTPUT COMPARE 1
VECTI3	EQU	$FFEA	TIMER INPUT CAPTURE 3
VECTI2	EQU	$FFEC	TIMER INPUT CAPTURE 2
VECTI1	EQU	$FFEE	TIMER INPUT CAPTURE 1
VECRTI	EQU	$FFF0	REAL TIME INTERRUPT
VECIRQ	EQU	$FFF2	IRQ
VECXIRQ	EQU	$FFF4	XIRQ
VECSWI	EQU	$FFF6	SWI
VECILL	EQU	$FFF8	ILLEGAL OPCODE TRAP
VECCOP	EQU	$FFFA	COP FAILURE (RESET)
VECCMF	EQU	$FFFC	COP CLOCK MONITOR FAIL (RESET)
VECRES	EQU	$FFFE	RESET
