10  '  *******  E9CONFIG.BAS  7/3/88    Version 1.0 *******'
20 ' Written by R.Soja, Motorola East Kilbride'
30 ' Motorola Copyright 1987'
40 ' This program downloads S record file to the MC68HC11 through special'
50 ' bootstrap program, designed to program either internal or external '
60 ' EEPROM in the 68HC11E9's memory map'
70 ' The loader can also verify memory against an S record file.'
80 ' Downloaded data is optionally echoed on terminal.'
90 ' ==================================
100 DIM S$(1000)
110 CR$=CHR$(13)
120 MIN$=CHR$(32)
130 MAX$=CHR$(127)
140 TRUE%=-1:FALSE%=0
150 ERM$="Can't find "
160 '----- Change the following variables as required -----'
170 LOADER$="EEPROGIX.BOO": 'Modified loader for 2.47MHz external clock on E9'
180 CHAN$="2"
190 ECHO$="Y"
200 EEOPT$="I": 'Program/verify option: I,X or V'
210 F$="CONFIG.REC"
220 BOOTRATE$="2400"
230 LOADRATE$="9600"
240 '------------------------------------------------------'
250 CLRLN$=SPACE$(80)
260 VER$="1.0": 'Version number of EELOAD'
270 CLS
280 ' ==== Restart program here in event of communication failure ===='
290 PRINT "  <<<<<<<<          HC11VDD Version ";VER$;"                     >>>>>>>>"
300 PRINT "  <<<<<<<< 68HC11 Internal/External EEPROM loader/verifier >>>>>>>>"
310 PRINT "  <<<<<<<< Runs with 2.47MHz external clock only!!!        >>>>>>>>"
320 PRINT "==>  Before continuing, ensure 68HC11 is in bootstrap mode,"
330 PRINT "     RESET is off, and COM1 or COM2 is connected to the SCI"
340 PRINT
350 CLOSE
360 OPEN F$ FOR INPUT AS #2
370 K%=0
380 WHILE NOT EOF(2)
390  K%=K%+1
400  INPUT #2,S$(K%)
410 WEND
420 CLOSE #2
430 ' First make sure loader program is available'
440 ON ERROR GOTO 990
450 OPEN LOADER$ FOR INPUT AS #2
460 CLOSE #2
470 ON ERROR GOTO 0
480 ROW=CSRLIN: 'Store current line number'
490 CM$="COM"+CHAN$
500 ' Now set baud rate to 1200 and load EEPROG through boot loader'
510 ' by executing DOS MODE and COPY commands'
520 PRINT "Hit space bar to start test"
530 IF INPUT$(1)<>" " THEN 930
540 SHELL "MODE "+CM$+":"+BOOTRATE$+",N,8,1"
550 SHELL "COPY "+LOADER$+" "+CM$
560 GOSUB 1190
570 FOR I%=1 TO 4:PRINT CLRLN$;:NEXT I%:PRINT: 'Clear DOS commands from screen'
580 ROW=CSRLIN: 'Store current line number'
590 IF EEOPT$="I" THEN OPT$="Internal"
600 IF EEOPT$="X" THEN OPT$="External"
610 IF EEOPT$="V" THEN OPT$="Verify":V%=TRUE% ELSE V%=FALSE
620 IF ECHO$="Y" THEN E%=TRUE% ELSE E%=FALSE%
630 ROW=CSRLIN: 'Store current line position in case of file error'
640 RXERR=0:    'Initialise number of RX errors allowed'
650 ON ERROR GOTO 1020
660 GOSUB 1190
670 CLOSE
680 ON ERROR GOTO 0
690 'COM1 or 2 connected to SCI on HC11'
700  OPEN CM$+":"+LOADRATE$+",N,8,1" AS #1
710 'Establish contact with HC11 by sending CR char & waiting for echo'
720 ON ERROR GOTO 970: 'Clear potential RX error'
730 PRINT #1,CR$;
740 GOSUB 1100: 'Read char into B$'
750 'Transmit Internal,External or Verify EEPROM option char to 68HC11'
760 PRINT #1,EEOPT$;:GOSUB 1100:              'Screen echo option'
770 ON ERROR GOTO 1040
780 PRINT "Starting download of <";F$;"> to: ";OPT$;" Eeprom"
790 ERRTOT%=0:  'Number of errors found by verify operation'
800 FOR J%=1 TO K%
810  L%=LEN(S$(J%))
820  FOR I%=1 TO L%
830      PRINT #1,MID$(S$(J%),I%,1);:GOSUB 1100:IF E% THEN PRINT B$;
840      IF V% THEN GOSUB 1150:IF C$<>"" THEN PRINT ":";HEX$(ASC(C$));
850  NEXT I%
860  IF E% THEN PRINT
870 NEXT J%
880 PRINT
890 PRINT "Download Complete"
900 IF V% THEN PRINT ERRTOT%;" error(s) found"
910 ON ERROR GOTO 0
920 GOTO 520
930 CLOSE
940 SYSTEM
950 END
960 ' -----------------'
970 IF RXERR>5 THEN 1050 ELSE RXERR=RXERR+1:RESUME 670
980 ' -----------------'
990 PRINT:PRINT ERM$;LOADER$:PRINT "Program aborted"
1000 GOTO 940
1010 ' -----------------'
1020 PRINT ERM$;F$;SPACE$(40)
1030 RESUME 650
1040 '-----------------'
1050 PRINT:PRINT "Communication breakdown: Download aborted"
1060 GOTO 280 :  'Restart test if device fails'
1070 '--------------------'
1080 '--SUB waits for received character, with time limit'
1090 '--    returns with char in B$, or aborts if time limit exceeded'
1100 T0%=0:WHILE LOC(1)=0:IF T0%>100 THEN 1050 ELSE T0%=T0%+1:WEND
1110 B$=INPUT$(1,#1)
1115 RETURN
1120 '--------------------'
1130 '--SUB waits for received character, with time limit'
1140 '--    returns with char in C$, or null in C$ if time limit exceeded'
1150 T0%=0:C$="":WHILE LOC(1)=0 AND T0%<1:T0%=T0%+1:WEND
1160 IF LOC(1)>0 THEN C$=INPUT$(1,#1):ERRTOT%=ERRTOT%+1
1170 RETURN
1180 '--------------------'
1190 '--SUB Clear line '
1200 LOCATE ROW,1,1:PRINT CLRLN$
1210 LOCATE ROW,1,1:RETURN
1220 '--------------------'
