
;	LIST	+S

;	last changed   17:11   19/07/91

;	comment

COMMENT /

	test file for the Z-80 Cross Assembler

	every Z-80 instruction, (except .REL file commands), or
	assembler directive possible is in this file
/

;	include

	INCLUDE	TESTMACS.ASM

N8	EQU	05AH	an 8-bit value
N16	EQU	0A5A5H	a 16-bit value
COND	EQU	0	conditional label (change to 1 to test results)

;	org

	ORG	#0000

;	ADC

	ADC	A,N8
	ADC	A,A
	ADC	A,B
	ADC	A,C
	ADC	A,D
	ADC	A,E
	ADC	A,H
	ADC	A,L
	ADC	A,(HL)
	ADC	A,(IX+N8)
	ADC	A,(IY+N8)
	ADC	HL,BC
	ADC	HL,DE
	ADC	HL,HL
	ADC	HL,SP

;	ADD

	ADD	A,N8
	ADD	A,A
	ADD	A,B
	ADD	A,C
	ADD	A,D
	ADD	A,E
	ADD	A,H
	ADD	A,L
	ADD	A,(HL)
	ADD	A,(IX+N8)
	ADD	A,(IY+N8)
	ADD	HL,BC
	ADD	HL,DE
	ADD	HL,HL
	ADD	HL,SP
	ADD	IX,BC
	ADD	IY,BC
	ADD	IX,DE
	ADD	IY,DE
	ADD	IX,IX
	ADD	IY,IY
	ADD	IX,SP
	ADD	IY,SP

;	AND

	AND	N8
	AND	A
	AND	B
	AND	C
	AND	D
	AND	E
	AND	H
	AND	L
	AND	(HL)
	AND	(IX+N8)
	AND	(IY+N8)

;	BIT

	BIT	0,A
	BIT	1,A
	BIT	2,A
	BIT	3,A
	BIT	4,A
	BIT	5,A
	BIT	6,A
	BIT	7,A
	BIT	0,B
	BIT	1,B
	BIT	2,B
	BIT	3,B
	BIT	4,B
	BIT	5,B
	BIT	6,B
	BIT	7,B
	BIT	0,C
	BIT	1,C
	BIT	2,C
	BIT	3,C
	BIT	4,C
	BIT	5,C
	BIT	6,C
	BIT	7,C
	BIT	0,D
	BIT	1,D
	BIT	2,D
	BIT	3,D
	BIT	4,D
	BIT	5,D
	BIT	6,D
	BIT	7,D
	BIT	0,E
	BIT	1,E
	BIT	2,E
	BIT	3,E
	BIT	4,E
	BIT	5,E
	BIT	6,E
	BIT	7,E
	BIT	0,H
	BIT	1,H
	BIT	2,H
	BIT	3,H
	BIT	4,H
	BIT	5,H
	BIT	6,H
	BIT	7,H
	BIT	0,L
	BIT	1,L
	BIT	2,L
	BIT	3,L
	BIT	4,L
	BIT	5,L
	BIT	6,L
	BIT	7,L
	BIT	0,(HL)
	BIT	1,(HL)
	BIT	2,(HL)
	BIT	3,(HL)
	BIT	4,(HL)
	BIT	5,(HL)
	BIT	6,(HL)
	BIT	7,(HL)
	BIT	0,(IX+N8)
	BIT	1,(IX+N8)
	BIT	2,(IX+N8)
	BIT	3,(IX+N8)
	BIT	4,(IX+N8)
	BIT	5,(IX+N8)
	BIT	6,(IX+N8)
	BIT	7,(IX+N8)
	BIT	0,(IY+N8)
	BIT	1,(IY+N8)
	BIT	2,(IY+N8)
	BIT	3,(IY+N8)
	BIT	4,(IY+N8)
	BIT	5,(IY+N8)
	BIT	6,(IY+N8)
	BIT	7,(IY+N8)

;	CALL

	CALL	N16
	CALL	C,N16
	CALL	NC,N16
	CALL	P,N16
	CALL	M,N16
	CALL	Z,N16
	CALL	NZ,N16
	CALL	PE,N16
	CALL	PO,N16

;	CCF

	CCF

;	CP

	CP	N8
	CP	A
	CP	B
	CP	C
	CP	D
	CP	E
	CP	H
	CP	L
	CP	(HL)
	CP	(IX+N8)
	CP	(IY+N8)

;	CPD, CPI

	CPD
	CPDR
	CPI
	CPIR

;	CPL

	CPL

;	DAA

	DAA

;	DEC

	DEC	A
	DEC	B
	DEC	C
	DEC	D
	DEC	E
	DEC	H
	DEC	L
	DEC	(HL)
	DEC	(IX+N8)
	DEC	(IY+N8)
	DEC	BC
	DEC	DE
	DEC	HL
	DEC	SP
	DEC	IX
	DEC	IY

;	DI & EI

	DI
	EI

;	DJNZ

	DJNZ	$-1

;	EX

	EX	AF,AF'
	EX	DE,HL
	EX	(SP),HL
	EX	(SP),IX
	EX	(SP),IY
	EXX

;	HALT

	HALT

;	IM

	IM	0
	IM	1
	IM	2

;	IN

	IN	A,(N8)
	IN	A,(C)
	IN	B,(C)
	IN	C,(C)
	IN	D,(C)
	IN	E,(C)
	IN	H,(C)
	IN	L,(C)

;	INC

	INC	A
	INC	B
	INC	C
	INC	D
	INC	E
	INC	H
	INC	L
	INC	BC
	INC	DE
	INC	HL
	INC	SP
	INC	(HL)
	INC	(IX+N8)
	INC	(IY+N8)
	INC	IX
	INC	IY

;	IND, INI

	IND
	INDR
	INI
	INIR

;	JP

	JP	N16
	JP	(HL)
	JP	(IX)
	JP	(IY)
	JP	NZ,N16
	JP	Z,N16
	JP	NC,N16
	JP	C,N16
	JP	PO,N16
	JP	PE,N16
	JP	P,N16
	JP	M,N16

;	JR

	JR	$-1
	JR	NZ,$-1
	JR	Z,$-1
	JR	NC,$-1
	JR	C,$-1

;	LD

	LD	A,I
	LD	A,R
	LD	A,(N16)
	LD	A,(BC)
	LD	A,(DE)
	LD	A,N8
	LD	B,N8
	LD	C,N8
	LD	D,N8
	LD	E,N8
	LD	H,N8
	LD	L,N8
	LD	A,A
	LD	A,B
	LD	A,C
	LD	A,D
	LD	A,E
	LD	A,H
	LD	A,L
	LD	B,A
	LD	B,B
	LD	B,C
	LD	B,D
	LD	B,E
	LD	B,H
	LD	B,L
	LD	C,A
	LD	C,B
	LD	C,C
	LD	C,D
	LD	C,E
	LD	C,H
	LD	C,L
	LD	D,A
	LD	D,B
	LD	D,C
	LD	D,D
	LD	D,E
	LD	D,H
	LD	D,L
	LD	E,A
	LD	E,B
	LD	E,C
	LD	E,D
	LD	E,E
	LD	E,H
	LD	E,L
	LD	H,A
	LD	H,B
	LD	H,C
	LD	H,D
	LD	H,E
	LD	H,H
	LD	H,L
	LD	L,A
	LD	L,B
	LD	L,C
	LD	L,D
	LD	L,E
	LD	L,H
	LD	L,L
	LD	A,(HL)
	LD	B,(HL)
	LD	C,(HL)
	LD	D,(HL)
	LD	E,(HL)
	LD	H,(HL)
	LD	L,(HL)
	LD	A,(IX+N8)
	LD	B,(IX+N8)
	LD	C,(IX+N8)
	LD	D,(IX+N8)
	LD	E,(IX+N8)
	LD	H,(IX+N8)
	LD	L,(IX+N8)
	LD	A,(IY+N8)
	LD	B,(IY+N8)
	LD	C,(IY+N8)
	LD	D,(IY+N8)
	LD	E,(IY+N8)
	LD	H,(IY+N8)
	LD	L,(IY+N8)
	LD	I,A
	LD	R,A
	LD	BC,N16
	LD	DE,N16
	LD	HL,N16
	LD	SP,N16
	LD	IX,N16
	LD	IY,N16
	LD	BC,(N16)
	LD	DE,(N16)
	LD	HL,(N16)
	LD	SP,(N16)
	LD	IY,(N16)
	LD	IX,(N16)
	LD	SP,HL
	LD	SP,IX
	LD	SP,IY
	LD	(N16),A
	LD	(N16),BC
	LD	(N16),DE
	LD	(N16),HL
	LD	(N16),SP
	LD	(N16),IX
	LD	(N16),IY
	LD	(BC),A
	LD	(DE),A
	LD	(HL),N8
	LD	(HL),A
	LD	(HL),B
	LD	(HL),C
	LD	(HL),D
	LD	(HL),E
	LD	(HL),H
	LD	(HL),L
	LD	(IX+N8),N8
	LD	(IY+N8),N8
	LD	(IX+N8),A
	LD	(IX+N8),B
	LD	(IX+N8),C
	LD	(IX+N8),D
	LD	(IX+N8),E
	LD	(IX+N8),H
	LD	(IX+N8),L
	LD	(IY+N8),A
	LD	(IY+N8),B
	LD	(IY+N8),C
	LD	(IY+N8),D
	LD	(IY+N8),E
	LD	(IY+N8),H
	LD	(IY+N8),L

;	LDD, LDI

	LDD
	LDDR
	LDI
	LDIR

;	NEG

	NEG

;	NOP

	NOP

;	OR

	OR	N8
	OR	A
	OR	B
	OR	C
	OR	D
	OR	E
	OR	H
	OR	L
	OR	(HL)
	OR	(IX+N8)
	OR	(IY+N8)

;	OUT

	OTDR
	OTIR
	OUT	(C),A
	OUT	(C),B
	OUT	(C),C
	OUT	(C),D
	OUT	(C),E
	OUT	(C),H
	OUT	(C),L
	OUT	(N8),A
	OUTD
	OUTI

;	PUSH & POP

	POP	AF
	POP	BC
	POP	DE
	POP	HL
	POP	IX
	POP	IY
	PUSH	AF
	PUSH	BC
	PUSH	DE
	PUSH	HL
	PUSH	IX
	PUSH	IY

;	RES

	RES	0,A
	RES	1,A
	RES	2,A
	RES	3,A
	RES	4,A
	RES	5,A
	RES	6,A
	RES	7,A
	RES	0,B
	RES	1,B
	RES	2,B
	RES	3,B
	RES	4,B
	RES	5,B
	RES	6,B
	RES	7,B
	RES	0,C
	RES	1,C
	RES	2,C
	RES	3,C
	RES	4,C
	RES	5,C
	RES	6,C
	RES	7,C
	RES	0,D
	RES	1,D
	RES	2,D
	RES	3,D
	RES	4,D
	RES	5,D
	RES	6,D
	RES	7,D
	RES	0,E
	RES	1,E
	RES	2,E
	RES	3,E
	RES	4,E
	RES	5,E
	RES	6,E
	RES	7,E
	RES	0,H
	RES	1,H
	RES	2,H
	RES	3,H
	RES	4,H
	RES	5,H
	RES	6,H
	RES	7,H
	RES	0,L
	RES	1,L
	RES	2,L
	RES	3,L
	RES	4,L
	RES	5,L
	RES	6,L
	RES	7,L
	RES	0,(HL)
	RES	1,(HL)
	RES	2,(HL)
	RES	3,(HL)
	RES	4,(HL)
	RES	5,(HL)
	RES	6,(HL)
	RES	7,(HL)
	RES	0,(IX+N8)
	RES	1,(IX+N8)
	RES	2,(IX+N8)
	RES	3,(IX+N8)
	RES	4,(IX+N8)
	RES	5,(IX+N8)
	RES	6,(IX+N8)
	RES	7,(IX+N8)
	RES	0,(IY+N8)
	RES	1,(IY+N8)
	RES	2,(IY+N8)
	RES	3,(IY+N8)
	RES	4,(IY+N8)
	RES	5,(IY+N8)
	RES	6,(IY+N8)
	RES	7,(IY+N8)

;	RET

	RET
	RET	NZ
	RET	Z
	RET	NC
	RET	C
	RET	PO
	RET	PE
	RET	P
	RET	M
	RETI
	RETN

;	RL

	RL	A
	RL	B
	RL	C
	RL	D
	RL	E
	RL	H
	RL	L
	RL	(HL)
	RL	(IX+N8)
	RL	(IY+N8)
	RLA

;	RLC

	RLC	A
	RLC	B
	RLC	C
	RLC	D
	RLC	E
	RLC	H
	RLC	L
	RLC	(HL)
	RLC	(IX+N8)
	RLC	(IY+N8)
	RLCA

;	RLD

	RLD

;	RR

	RR	A
	RR	B
	RR	C
	RR	D
	RR	E
	RR	H
	RR	L
	RR	(HL)
	RR	(IX+N8)
	RR	(IY+N8)
	RRA

;	RRC

	RRC	A
	RRC	B
	RRC	C
	RRC	D
	RRC	E
	RRC	H
	RRC	L
	RRC	(HL)
	RRC	(IX+N8)
	RRC	(IY+N8)
	RRCA

;	RRD

	RRD

;	RST

	RST	#0
	RST	#08
	RST	#10
	RST	#18
	RST	#20
	RST	#28
	RST	#30
	RST	#38

;	SBC

	SBC	A,N8
	SBC	A,A
	SBC	A,B
	SBC	A,C
	SBC	A,D
	SBC	A,E
	SBC	A,H
	SBC	A,L
	SBC	A,(HL)
	SBC	A,(IX+N8)
	SBC	A,(IY+N8)
	SBC	HL,BC
	SBC	HL,DE
	SBC	HL,HL
	SBC	HL,SP

;	SCF

	SCF

;	SET

	SET	0,A
	SET	1,A
	SET	2,A
	SET	3,A
	SET	4,A
	SET	5,A
	SET	6,A
	SET	7,A
	SET	0,B
	SET	1,B
	SET	2,B
	SET	3,B
	SET	4,B
	SET	5,B
	SET	6,B
	SET	7,B
	SET	0,C
	SET	1,C
	SET	2,C
	SET	3,C
	SET	4,C
	SET	5,C
	SET	6,C
	SET	7,C
	SET	0,D
	SET	1,D
	SET	2,D
	SET	3,D
	SET	4,D
	SET	5,D
	SET	6,D
	SET	7,D
	SET	0,E
	SET	1,E
	SET	2,E
	SET	3,E
	SET	4,E
	SET	5,E
	SET	6,E
	SET	7,E
	SET	0,H
	SET	1,H
	SET	2,H
	SET	3,H
	SET	4,H
	SET	5,H
	SET	6,H
	SET	7,H
	SET	0,L
	SET	1,L
	SET	2,L
	SET	3,L
	SET	4,L
	SET	5,L
	SET	6,L
	SET	7,L
	SET	0,(HL)
	SET	1,(HL)
	SET	2,(HL)
	SET	3,(HL)
	SET	4,(HL)
	SET	5,(HL)
	SET	6,(HL)
	SET	7,(HL)
	SET	0,(IX+N8)
	SET	1,(IX+N8)
	SET	2,(IX+N8)
	SET	3,(IX+N8)
	SET	4,(IX+N8)
	SET	5,(IX+N8)
	SET	6,(IX+N8)
	SET	7,(IX+N8)
	SET	0,(IY+N8)
	SET	1,(IY+N8)
	SET	2,(IY+N8)
	SET	3,(IY+N8)
	SET	4,(IY+N8)
	SET	5,(IY+N8)
	SET	6,(IY+N8)
	SET	7,(IY+N8)

;	SLA

	SLA	A
	SLA	B
	SLA	C
	SLA	D
	SLA	E
	SLA	H
	SLA	L
	SLA	(HL)
	SLA	(IX+N8)
	SLA	(IY+N8)

;	SRA

	SRA	A
	SRA	B
	SRA	C
	SRA	D
	SRA	E
	SRA	H
	SRA	L
	SRA	(HL)
	SRA	(IX+N8)
	SRA	(IY+N8)

;	SRL

	SRL	A
	SRL	B
	SRL	C
	SRL	D
	SRL	E
	SRL	H
	SRL	L
	SRL	(HL)
	SRL	(IX+N8)
	SRL	(IY+N8)

;	SUB

	SUB	N8
	SUB	A
	SUB	B
	SUB	C
	SUB	D
	SUB	E
	SUB	H
	SUB	L
	SUB	(HL)
	SUB	(IX+N8)
	SUB	(IY+N8)

;	XOR

	XOR	N8
	XOR	A
	XOR	B
	XOR	C
	XOR	D
	XOR	E
	XOR	H
	XOR	L
	XOR	(HL)
	XOR	(IX+N8)
	XOR	(IY+N8)

;	do some maths

;	the answer is 42 (but what was the question)

	LD	HL,373+#4C-%1001*2/04H&10110000B!69@00FFH

;	now do assembler directives

;	defb

	DEFB	N8,0FFH,00001111B,128

;	defw

	DEFW	N16,0FFFFH,1111000011110000B,32768

;	defm

	DEFM	"Hello there everybody"

;	defs

	DEFS	010H

;	version number macro expansion

	VERSION

;	conditional assembly

	IFEQ	COND

	LD	HL,N8

	ELSEIF

	LD	HL,N16

	ENDC

;	conditional macro expansion

	CONDMAC	N8,N16

;	end statement

	END
;
