;
;
;	last changed   14:06   18/10/90
;
;
;	intel hex record save & load routines
;
;
;	set macro definition
;
;
	MACRO	CPJP		;compare & jump
	CP	\0		;test value
	JR	\1,\2		;jump on result
;
	ENDM
;
;
BREAK	EQU	0		;break key (change to suit)
;
;
;	load an Intel hex file
;
LDIREC	CALL	WTBYTE		;get next byte
;
	JR	Z,LDIR05	;exit if 'break' pressed
;
	CPJP	":",NZ,LDIREC	;repeat if not record header
;
	LD	HL,IHRBAS	;record store base address
LDIR01	CALL	WTBYTE		;get next byte
;
	JR	Z,LDIR05	;exit on 'break'
;
	LD	(HL),A		;store byte
	INC	HL		;bump pointer
;
	CPJP	#0D,NZ,LDIR01	;repeat until cr
;
;	test record checksum
;
	LD	HL,IHRBAS	;base of received record
	LD	DE,IHCBAS	;store for converted bytes
	LD	C,#00		;clear checksum
LDIR02	LD	A,(HL)		;get next byte
;
	CPJP	#30,C,LDIR03	;test finished on non-ascii
;
	CALL	ASCBYT		;convert ascii to hex
;
	LD	(DE),A		;store byte
	INC	DE		;bump pointer
	ADD	A,C		;add old checksum
	LD	C,A		;and store
	JR	LDIR02		;and repeat
;
LDIR03	AND	C		;test checksum
	JR	NZ,LDIR05	;exit on error
;
	LD	HL,IHCBAS	;record base
	LD	B,#00
	LD	C,(HL)		;get byte count
	INC	HL		;bump pointer
;
	LD	D,(HL)		;load address hi
	INC	HL		;bump pointer
	LD	E,(HL)		;load address lo
	INC	HL		;bump pointer
;
	LD	A,(HL)		;get record type
	INC	HL		;bump pointer
	AND	A		;eof record?
	JR	NZ,LDIR05	;finished if so
;
LDIR04	LDIR			;store bytes 
;
	JR	LDIREC		;and repeat
;
LDIR05	RET			;and exit
;
;
;	wait for a received data byte
;	exit with zero flag set if 'break' pressed
;	else byte in A reg
;
WTBYTE	CALL	SCAN		;scan keyboard
;
	AND	A		;any pressed?
	JR	Z,WBYT00	;jump if not
;
	CPJP	BREAK,Z,WBYT01	;exit on break
;
WBYT00	CALL	RSRXCH		;test for character
;
	JR	Z,WTBYTE	;wait until found
;
WBYT01	RET			;and exit
;
;
;	convert 2 ascii bytes to single byte form
;	HL points to ascii version
;
ASCBYT	LD	A,(HL)		;get first byte (nibble)
	INC	HL		;bump pointer
	CALL	ASCNIB		;convert it
;
	SLA	A
	SLA	A
	SLA	A
	SLA	A		;move to upper nibble
	LD	B,A		;save hi nibble
	LD	A,(HL)		;get second byte (nibble)
	INC	HL		;bump pointer
	CALL	ASCNIB		;convert it
;
	OR	B		;include hi nibble
	RET			;and exit
;
;
;	convert ascii byte to nibble
;
ASCNIB	SUB	#30		;- ascii base
;
	CPJP	#0A,C,ASCN00	;jump on 0-9
;
	SUB	#07		;make A-F
ASCN00	RET			;and exit
;
;
;	recieve a character from RS232 interface
;
RSRXCH	
;
;	your code goes here
;
	RET			;and exit
;
;
;	read keyboard
;
SCAN	
;
;	your code goes here
;
	RET			;and exit
;
;	storage space for hex record
;
IHRBAS	DEFS	100		;hex record store
IHCBAS	DEFS	100		;converted record store
;
