*******************************
* IN DEVPAC 2 !!
*
* RUNS IN LOW-RESOLUTION !!
*******************************
*
*	MFP EQUATES
*
MFP	EQU	$FFFA00
IERA	EQU	MFP+$7
IERB	EQU	MFP+$9
IPRA	EQU	MFP+$B
ISRA	EQU	MFP+$F
IMRA	EQU	MFP+$13
IMRB	EQU	MFP+$15
VECTOR	EQU	MFP+$17
TACR	EQU	MFP+$19
TADR	EQU	MFP+$1F
ISRVEC	EQU	$134
*
*	THE SOUND CHIP
*
SCREG	EQU	$FF8800	* CHIP REGISTER SELECT
SCDATA	EQU	$FF8802	* REGISTER DATA

*	BDOS EQUATES 

SUPER  	EQU	$20
IKBDWS	EQU	$19

*******************
*  THE PROGRAMME  *
*******************

REPLAY	CLR.L	-(A7)
	MOVE.W	#SUPER,-(A7)	* GOTO SUPERVISOR
	TRAP	#1
	ADDQ.L	#6,A7
	MOVE.L	D0,OLD_STACK	* SAVE BASIC STACK (IN CASE)	
textscroll
	jsr	init
	move.l	$70,-(sp)
	move.l	#vbl,$70

*	A5 = START%   : REM A5 CONTAINS FIRST ADDRESS OF SAMPLE
*	D5 = LENGHT   : REM D5 CONTAINS LENGTH OF SAMPLE
*	D4 = 1        : REM D4 CONTAINS PLAYBACK SPEED (7.5 KHZ)

	move.l	#samp,a5
	move.l	#6071,d5
	move.l	#1,d4

	BSR	SAVEMFP		* SAVE NATURAL MFP CONDITIONS

	MOVE.W	#$2700,SR		* ALL INTERRUPTS OFF
	LEA	INULL,A0
	BSR	SETINT		* SET NULL INTERRUPT ADDRESS

	BSR	SETFREQ	 * SET INITIAL FREQUENCY

	BSR	DISMOUS	 * SWITCH MOUSE REPORTING OFF
	BSR	ENABMFP		* SET THE MFP RUNNING
	BSR	SETSND		* SET UP SOUND REGISTERS
	BSR	REGSINT	 * SET OUTPUT THROUGH SPEAKER
		
***************************
*  NOW THE PROGRAM PROPER *
***************************
*  CALCULATE THE SAMPLE END ADDRESS

	ADD.L	A5,D5	* START + LENGTH = END

* SET UP INTERRUPT AND START REPLAYING

	LEA	IREPLAY,A0	* ROUTINE ADDRESS
	BSR	SETINT		* INSTALL
	ST	INUSE		* FLAG INTERRUPT ACTIVE
	MOVE.W	#$2300,SR		* Tillat vbl och mpf
	
prog	cmp.b	#$39,$fffc02
	beq	exit		* WAIT HERE UNTIL DONE
	jmp	t8scr
back	bra.s	prog
	
exit	MOVE.W	#$2700,SR
	LEA	INULL,A0		* REMOVE REPLAY INT.
	BSR	SETINT
	SF	INUSE
	MOVE.W	#$2500,SR
	MOVE.W	#$2700,SR		* DISABLE INTS
	BSR	OLDMFP		* RESTORE WORKING MFP
	MOVE.W	#$2000,SR
	BSR	ENMOUSE		* RE ENABLE MOUSE
	move.l	(sp)+,$70
	MOVE.L	OLD_STACK,-(A7)
	MOVE.W	#$20,-(A7)	* RETURN TO USER MODE
	TRAP	#1
	ADDQ.L	#6,A7
	move.w	#1,-(sp)
	move.l	#$78000,-(sp)
	move.l	#$78000,-(sp)
	move.w	#5,-(sp)
	trap	#14
	add.l	#12,sp

	clr.w	-(sp)
	trap	#1		* RETURN TO BASIC
************
* VBL interupt
************
vbl	st	vbiflag
	rte

vbiflag	ds.b	1
	even
****************************************
*   THE INTERRUPT SERVICE ROUTINES     *
****************************************
*	A5 = POINTER TO BASE OF REPLAY RAM
*	A4 = G.I. CHIP ADDRESS
*	A3 = INT. SND LOOK UP TABLE
*	A0 = RESERVED FOR MAIN PROG.
*	D7 = BYTE TO BE OUTPUT
*	D5 = POINTER TO END OF REPLAY RAM
*	D3 = SOUND CHIP DATA
*	D2 = SOUND CHIP DATA
*
****************************************
*     THE NULL INTERRUPT ROUTINE       *
****************************************

INULL	RTE

****************************************
*       REPLAY FROM MEMORY             *
****************************************

IREPLAY
	MOVE.B	(A5)+,D7		* READ FROM RAM
	CMP.L	D5,A5		* EXCEDED END STOP
	BGE.S	HALTREP		* BRANCH IF SO

	AND.W	#$FF,D7		* MASK OFF RUBBISH
	ADD.B	#$80,D7		* COMPLENT VALUE
	LSL.W	#3,D7		* DOUBLE LONG WORD OFFSET
	MOVE.L	0(A3,D7.W),D3	* GET DATA #1
	MOVE.W	4(A3,D7.W),D2	* GET DATA #2
	MOVEP.L	D3,0(A4)		* PLAY #1
	MOVEP.W	D2,0(A4)		* PLAY #2
	
	RTE

HALTREP	
	move.l	#samp,a5
	rte

***************************
* THE SYSTEM SUB-ROUTINES *
******************************
* PRESERVE THE MFP REGISTERS *
******************************

SAVEMFP	MOVE.B	IERA,MFPMEM	* PUSH CURRENT MFP DATA
	MOVE.B	IERB,MFPMEM+1
	MOVE.B	IMRA,MFPMEM+2
	MOVE.B	IMRB,MFPMEM+3
	MOVE.B	TADR,MFPMEM+4
	MOVE.B	TACR,MFPMEM+5
	MOVE.B	VECTOR,MFPMEM+6
	RTS

*****************************************
*   REPLACE NATURAL RUNNING MFP VALUES  *
*****************************************

OLDMFP	MOVE.B	MFPMEM+6,VECTOR	* RESTORE OLD MFP VALS
	MOVE.B	MFPMEM+5,TACR
	MOVE.B	MFPMEM+4,TADR
	MOVE.B	MFPMEM+3,IMRB
	MOVE.B	MFPMEM+2,IMRA
	MOVE.B	MFPMEM+1,IERB
	MOVE.B	MFPMEM,IERA
	RTS

*************************
*  IKBD ENABLE/DISABLE  *
*************************

DISMOUS	PEA	SKBDDIS
	MOVE.W	#1,-(A7)		* 2 PARAMETERS
	BRA.S	DO_IKBD
ENMOUSE
	PEA	SKBDEN
	MOVE.W	#0,-(A7)		* 1 PARAMETER
DO_IKBD
	MOVE.W	#IKBDWS,-(A7)
	TRAP	#14
	ADDQ.L	#8,A7
	RTS
	
*****************************
*  CHOOSE INTERRUPT VECTOR  *
*****************************
*
*   SET UP SELECTED INTERRUPT WITH A0.L
*   CONTAINING THE NEW ROUTINE VECTOR
*
SETINT	MOVE.W	SR,D0
	MOVE.W	#$2700,SR
	MOVE.L	A0,ISRVEC		* INSTALL NEW ROUTINE
	MOVE.W	D0,SR
	RTS

*************************
*  SET UP MFP FREQUENCY *
*************************
*
*   SET UP MFP TIMER 'A' TO GENERATE INTERRUPTS.
*   ENTER WITH D4.W SET WITH A FREQUENCY NUMBER 0 TO 7
*   D4.W = $2, GETS 3RD MFP DATA FROM TABLE (10 KHZ)
*
SETFREQ	MOVE.B	#0,TACR			* DISABLE TIMER
	AND.W	#7,D4			* ENSURE 0-7
	LEA	FREQTAB,A0 		* GET FREQ TABLE ADDR
	LSL.W	#1,D4			* CONVERT TO WORD TABLE OFFSET
	MOVE.W	0(A0,D4.W),D4		* GET THE MFP DATA
	MOVE.B	D4,TACR			* LSB = CONTROL REG BYTE
	LSR.W	#8,D4			* SHIFT DOWN NEXT BYTE
 	MOVE.B	D4,TADR			* NEXT = DATA REG BYTE
	RTS

*******************
*  ENABLE THE MFP *
*******************

ENABMFP	MOVE.B	#$20,IMRA
	MOVE.B	#0,IMRB
	MOVE.B	#$20,IERA
	MOVE.B	#0,IERB
	BCLR.B	#3,VECTOR
	RTS

************************************
*  SET UP THE SOUND CHIP CHANNELS  *
************************************

SETSND	MOVE.B	#0,SCREG		* CHANNEL A
	MOVE.B	#0,SCDATA
	MOVE.B	#1,SCREG
	MOVE.B	#0,SCDATA

	MOVE.B	#2,SCREG		* CHANNEL B
	MOVE.B	#0,SCDATA
	MOVE.B	#3,SCREG
	MOVE.B	#0,SCDATA

	MOVE.B	#4,SCREG		* CHANNEL C
	MOVE.B	#0,SCDATA
	MOVE.B	#5,SCREG
	MOVE.B	#0,SCDATA

	MOVE.B	#7,SCREG		* SET UP CHANNEL MIXING
	MOVE.B	#$FF,SCDATA

	MOVE.B	#8,SCREG		* SET ALL VOLUMES TO ZERO
	MOVE.B	#0,SCDATA
	MOVE.B	#9,SCREG
	MOVE.B	#0,SCDATA
	MOVE.B	#10,SCREG
	MOVE.B	#0,SCDATA
	RTS
	
***************************************
*    SET UP REGS. FOR INTERNAL        *
***************************************

REGSINT	MOVE.W	SR,D0
	MOVE.W	#$2700,SR
	MOVE.L	#SCREG,A4		* SOUND CHIP CNTRL REG
	LEA	SND_OUT,A3	* LOOK UP TABLES
	MOVEQ	#0,D7
	MOVE.W	D0,SR
	RTS

***************
*   8*8 font  *
*   t-scroll  *
*   890617    *
***************

init	move.w	#0,-(sp)
	move.l	#-1,-(sp)
	move.l	#-1,-(sp)
	move.w	#5,-(sp)
	trap	#14
	add.l	#12,sp		* lagupplosning
	move.l	#text,messnow
	move.w	#2,-(sp)
	trap	#14
	addq.l	#2,sp
	move.l	d0,physbase	* spara physbase
	rts
t8scr	
	move.w	$ff8240,-(sp)
	move.w	#$700,$ff8240
	bsr	scroll
	bsr	scroll
	bsr	plot
	bsr	copy
	move.w	#$070,$ff8240
	bsr	vsync
	move.w	(sp)+,$ff8240
	jmp 	back

scroll
	lea	scrollbuf,a0
	lea	40(a0),a0
	move.l	#8,unicount
.loop
	and.b	#0,ccr
dum	SET	0
	REPT	21
	roxl.w	dum(a0)
dum	SET	dum-2
	ENDR
	lea	42(a0),a0
	sub.l	#1,unicount
	tst.l	unicount
	bne	.loop
	rts

plot	
	cmp.b	#3,ifplot
	beq	yesplot
noplot	
	add.b	#1,ifplot
	rts
yesplot
	move.b	#0,ifplot
	moveq.l	#0,d0
ag	move.l	messnow,a0
	move.b	(a0),d0
	cmp.b	#$ff,d0
	bne	no_end
	move.l	#text,messnow
	bra.s	ag
no_end	
	sub.l	#32,d0
	mulu	#8,d0
	add.l	#FONT,d0
	move.l	d0,a0
	lea	scrollbuf,a1
	lea	40(a1),a1
	move.l	#8,unicount
.loop
	move.b	(a0)+,(a1)
	lea	42(a1),a1
	sub.l	#1,unicount
	tst.l	unicount
	bne	.loop
	add.l	#1,messnow
	rts
	
copy
	lea	scrollbuf,a0
	move.l	physbase,a1
	move.l	#8,unicount
.loop	REPT	20
	move.w	(a0)+,(a1)
	lea	8(a1),a1
	ENDR
	lea	2(a0),a0
	sub.l	#1,unicount
	tst.l	unicount
	bne	.loop	
	rts

vsync
	cmp.b	#$ff,vbiflag
	bne	vsync
	sf	vbiflag
	rts

text	dc.b	"If you are thinking of changing this scroll"
	dc.b	" to one of your own, then be careful not to change "
	dc.b	"the registers that the sampling-routine uses.    "
	dc.b	"Some code taken from the Example-file in ST-REPLAY. "
	dc.b	"Text-scroll and interupt changes by Roine Stenberg.....     "
	dc.b	$ff
	EVEN


scrollbuf		ds.b	336
unicount		ds.l	1
messnow		ds.l	1
physbase		ds.l	1
ifplot		ds.b	1
teck		ds.b	1
	EVEN
FONT	DC.B	0,0,0,0,0,0,0,0
	DC.B	$18,$18,$18,$18,$18,0,$18,0
	DC.B	$66,$66,$66,0,0,0,0,0
	DC.B	0,$6C,$FE,$6C,$FE,$6C,0,0
	DC.B	$30,$7E,$C0,$7C,6,$FC,$30,0
	DC.B	0,$C6,$CC,$18,$30,$66,$C6,0
	DC.B	$70,$D8,$70,$70,$DA,$CC,$7A,0
	DC.B	$18,$18,$10,0,0,0,0,0
	DC.B	$C,$18,$18,$18,$10,$18,4,0
	DC.B	$30,$18,$18,$18,8,$18,$20,0
	DC.B	0,0,$18,$7E,$3C,$7E,$18,0
	DC.B	0,0,$18,$18,$7E,$18,$18,0
	DC.B	0,0,0,0,0,$18,$18,$10
	DC.B	0,0,0,0,$7E,0,0,0
	DC.B	0,0,0,0,0,$18,$18,0
	DC.B	2,6,$C,$18,$30,$60,$C0,0
	DC.B	$7C,$C6,$CE,$DE,$F6,$E6,$7C,0
	DC.B	$18,$38,$78,$18,$18,$18,$18,0
	DC.B	$7C,$C6,6,$7C,$C0,$C0,$FE,0
	DC.B	$7C,$C6,6,$3C,6,$C6,$7C,0
	DC.B	$1C,$3C,$6C,$CC,$FE,$C,$C,0
	DC.B	$FE,$C0,$C0,$FC,6,$C6,$7C,0
	DC.B	$7C,$C0,$C0,$FC,$C6,$C6,$7C,0
	DC.B	$FE,6,6,$C,$18,$30,$30,0
	DC.B	$7C,$C6,$C6,$7C,$C6,$C6,$7C,0
	DC.B	$7C,$C6,$C6,$7E,6,$C6,$7C,0
	DC.B	0,$18,$18,0,0,$18,$18,0
	DC.B	0,$18,$18,0,0,$18,$18,$10
	DC.B	0,0,$C,$18,$30,$18,$C,0
	DC.B	0,0,0,$7E,0,$7E,0,0
	DC.B	0,0,$30,$18,$C,$18,$30,0
	DC.B	$7C,$C6,$C6,$1C,$30,0,$30,0
	DC.B	$7C,$C6,$DE,$D6,$DE,$C0,$7E,0
	DC.B	$38,$6C,$C6,$C6,$FE,$C6,$C6,$C0
	DC.B	$FC,$E6,$66,$7C,$66,$66,$7C,0
	DC.B	$7C,$C6,$C6,$C0,$C0,$C0,$7E,0
	DC.B	$FC,$E6,$66,$66,$66,$66,$7C,0
	DC.B	$FE,$E0,$60,$7C,$60,$60,$7E,0
	DC.B	$FE,$E0,$60,$7C,$60,$60,$60,0
	DC.B	$7C,$C6,$C0,$DE,$C6,$C6,$7C,0
	DC.B	6,$C6,$C6,$FE,$C6,$C6,$C6,$C0
	DC.B	0,$3C,$18,$18,$18,$18,$18,$3C
	DC.B	$1E,6,6,$C6,$C6,$C6,$7C,0
	DC.B	6,$C6,$CC,$F8,$CC,$C6,$C6,6
	DC.B	$60,$60,$60,$60,$60,$E0,$FE,0
	DC.B	6,$CE,$EE,$FE,$D6,$C6,$C6,$C0
	DC.B	6,$C6,$E6,$F6,$DE,$CE,$C6,$C0
	DC.B	$3C,$66,$66,$66,$66,$66,$3C,0
	DC.B	$FC,$66,$66,$7C,$60,$60,$60,0
	DC.B	$7C,$C6,$C6,$D6,$DE,$CC,$7E,0
	DC.B	$FC,$E6,$66,$7C,$6C,$66,$66,6
	DC.B	$3C,$66,$60,$3C,6,$C6,$7C,0
	DC.B	$FE,$18,$18,$18,$18,$18,$18,0
	DC.B	6,$C6,$C6,$C6,$C6,$C6,$7C,0
	DC.B	$C0,$C6,$C6,$C6,$6C,$38,$10,0
	DC.B	$C0,$C6,$C6,$D6,$FE,$EE,$44,0
	DC.B	$C0,$6C,$38,$38,$6C,$C6,6,0
	DC.B	$C6,$C6,$66,$3C,$18,$18,$18,0
	DC.B	$7E,$C,$18,$30,$60,$C0,$FC,0
	DC.B	$1E,$18,$18,$18,$18,$18,$1E,0
	DC.B	$80,$C0,$60,$30,$18,$C,6,0
	DC.B	$78,$18,$18,$18,$18,$18,$78,0
	DC.B	$10,$38,$6C,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,$FF
	DC.B	$18,$18,8,0,0,0,0,0
	DC.B	0,0,$FC,6,$7E,$C6,$7E,0
	DC.B	$C0,$C0,$FC,$C6,$C6,$C6,$7C,0
	DC.B	0,0,$7E,$C0,$C0,$C6,$7C,0
	DC.B	$1E,6,$7E,$C6,$C6,$C6,$7E,0
	DC.B	0,0,$7C,$C6,$FC,$60,$3C,0
	DC.B	$1C,$30,$7E,$30,$30,$30,$30,$30
	DC.B	0,0,$7E,$C6,$C6,$7E,6,$7C
	DC.B	$C0,$C0,$FC,$C6,$C6,$C6,$C6,6
	DC.B	$18,0,$18,$18,$18,$18,$18,0
	DC.B	$18,0,$18,$18,$18,$18,$18,$60
	DC.B	$C0,$C0,$C6,$CC,$F8,$CC,6,6
	DC.B	$30,$30,$30,$30,$30,$30,$30,0
	DC.B	0,0,$EC,$FE,$D6,$D6,$D6,6
	DC.B	0,0,$FC,$C6,$C6,$C6,$C6,6
	DC.B	0,0,$7C,$C6,$C6,$C6,$7C,0
	DC.B	0,0,$FC,$66,$66,$66,$7C,$60
	DC.B	0,0,$7E,$C6,$C6,$C6,$7E,6
	DC.B	0,0,$FC,$66,$60,$60,$60,$60
	DC.B	0,0,$7C,$C0,$7C,6,$7C,0
	DC.B	$30,$30,$7C,$30,$30,$30,$1C,0
	DC.B	0,0,6,$C6,$C6,$C6,$7E,0
	DC.B	0,$C0,$C6,$C6,$6C,$38,$10,0
	DC.B	0,$C0,$C6,$D6,$D6,$FE,$6C,0
	DC.B	$C0,$6C,$38,$38,$6C,$C6,6,0
	DC.B	0,$C0,$C6,$C6,$C6,$7E,6,$FC
	DC.B	0,0,$FE,6,$7C,$C0,$FE,0
	DC.B	$1E,$18,$38,$70,$38,$18,$1E,0
	DC.B	$18,$18,$18,$18,$18,$18,$18,$18
	DC.B	$78,$18,$1C,$E,$1C,$18,$78,0
***************************************
*    INTERNAL SOUND LOOKUP TABLE.     *
***************************************
	EVEN
SND_OUT	DC.W	$80C,$90B,$A09,0,$80C,$90B,$A09,0
	DC.W	$80D,$908,$A08,0,$80B,$90B,$A0B,0
	DC.W	$80D,$909,$A05,0,$80C,$90B,$A08,0
	DC.W	$80D,$909,$A02,0,$80D,$908,$A06,0
	DC.W	$80C,$90B,$A07,0,$80D,$907,$A07,0
	DC.W	$80C,$90B,$A06,0,$80C,$90A,$A09,0
	DC.W	$80B,$90B,$A0A,0,$80C,$90B,$A02,0
	DC.W	$80C,$90B,$A00,0,$80C,$90A,$A08,0

	DC.W	$80D,$906,$A04,0,$80D,$905,$A05,0
	DC.W	$80D,$905,$A04,0,$80C,$909,$A09,0
	DC.W	$80D,$904,$A03,0,$80B,$90B,$A09,0
	DC.W	$80C,$90A,$A05,0,$80B,$90A,$A0A,0
	DC.W	$80C,$909,$A08,0,$80B,$90B,$A08,0
	DC.W	$80C,$90A,$A00,0,$80C,$90A,$A00,0
	DC.W	$80C,$909,$A07,0,$80B,$90B,$A07,0
	DC.W	$80C,$909,$A06,0,$80B,$90B,$A06,0

	DC.W	$80B,$90A,$A09,0,$80B,$90B,$A05,0
	DC.W	$80A,$90A,$A0A,0,$80B,$90B,$A02,0
	DC.W	$80B,$90A,$A08,0,$80C,$907,$A07,0
	DC.W	$80C,$908,$A04,0,$80C,$907,$A06,0
	DC.W	$80B,$909,$A09,0,$80C,$906,$A06,0
	DC.W	$80A,$90A,$A09,0,$80C,$907,$A03,0
	DC.W	$80B,$90A,$A05,0,$80B,$909,$A08,0
	DC.W	$80B,$90A,$A03,0,$80A,$90A,$A08,0

	DC.W	$80B,$90A,$A00,0,$80B,$909,$A07,0
	DC.W	$80B,$908,$A08,0,$80A,$90A,$A07,0
	DC.W	$80A,$909,$A09,0,$80C,$901,$A01,0
	DC.W	$80A,$90A,$A06,0,$80B,$908,$A07,0
	DC.W	$80A,$90A,$A05,0,$80A,$909,$A08,0
	DC.W	$80A,$90A,$A02,0,$80A,$90A,$A01,0
	DC.W	$80A,$90A,$A00,0,$809,$909,$A09,0
	DC.W	$80A,$908,$A08,0,$80B,$908,$A01,0

	DC.W	$80A,$909,$A06,0,$80B,$907,$A04,0
	DC.W	$80A,$909,$A05,0,$809,$909,$A08,0
	DC.W	$80A,$909,$A03,0,$80A,$908,$A06,0
	DC.W	$80A,$909,$A00,0,$809,$909,$A07,0
	DC.W	$809,$908,$A08,0,$80A,$908,$A04,0
	DC.W	$809,$909,$A06,0,$80A,$908,$A01,0
	DC.W	$809,$909,$A05,0,$809,$908,$A07,0
	DC.W	$808,$908,$A08,0,$809,$909,$A02,0

	DC.W	$809,$908,$A06,0,$809,$909,$A00,0
	DC.W	$809,$907,$A07,0,$808,$908,$A07,0
	DC.W	$809,$907,$A06,0,$809,$908,$A02,0
	DC.W	$808,$908,$A06,0,$809,$906,$A06,0
	DC.W	$808,$907,$A07,0,$808,$908,$A04,0
	DC.W	$808,$907,$A06,0,$808,$908,$A02,0
	DC.W	$807,$907,$A07,0,$808,$906,$A06,0
	DC.W	$808,$907,$A04,0,$807,$907,$A06,0

	DC.W	$808,$906,$A05,0,$808,$906,$A04,0
	DC.W	$807,$906,$A06,0,$807,$907,$A04,0
	DC.W	$808,$905,$A04,0,$806,$906,$A06,0
	DC.W	$807,$906,$A04,0,$807,$905,$A05,0
	DC.W	$806,$906,$A05,0,$806,$906,$A04,0
	DC.W	$806,$905,$A05,0,$806,$906,$A02,0
	DC.W	$806,$905,$A04,0,$805,$905,$A05,0
	DC.W	$806,$905,$A02,0,$805,$905,$A04,0

	DC.W	$805,$904,$A04,0,$805,$905,$A02,0
	DC.W	$804,$904,$A04,0,$804,$904,$A03,0
	DC.W	$804,$904,$A02,0,$804,$903,$A03,0
	DC.W	$803,$903,$A03,0,$803,$903,$A02,0
	DC.W	$803,$902,$A02,0,$802,$902,$A02,0
	DC.W	$802,$902,$A01,0,$801,$901,$A01,0
	DC.W	$802,$901,$A00,0,$801,$901,$A00,0
	DC.W	$801,$900,$A00,0,$800,$900,$A00,0

	DC.W	$80E,$90D,$A0C,0,$80F,$903,$A00,0
	DC.W	$80F,$903,$A00,0,$80F,$903,$A00,0
	DC.W	$80F,$903,$A00,0,$80F,$903,$A00,0
	DC.W	$80F,$903,$A00,0,$80E,$90D,$A0B,0
	DC.W	$80E,$90D,$A0B,0,$80E,$90D,$A0B,0
	DC.W	$80E,$90D,$A0B,0,$80E,$90D,$A0B,0
	DC.W	$80E,$90D,$A0B,0,$80E,$90D,$A0B,0
	DC.W	$80E,$90D,$A0A,0,$80E,$90D,$A0A,0

	DC.W	$80E,$90D,$A0A,0,$80E,$90D,$A0A,0
	DC.W	$80E,$90C,$A0C,0,$80E,$90D,$A00,0
	DC.W	$80D,$90D,$A0D,0,$80D,$90D,$A0D,0
	DC.W	$80D,$90D,$A0D,0,$80D,$90D,$A0D,0
	DC.W	$80D,$90D,$A0D,0,$80D,$90D,$A0D,0
	DC.W	$80E,$90C,$A0B,0,$80E,$90C,$A0B,0
	DC.W	$80E,$90C,$A0B,0,$80E,$90C,$A0B,0
	DC.W	$80E,$90C,$A0B,0,$80E,$90C,$A0B,0

	DC.W	$80E,$90C,$A0B,0,$80E,$90C,$A0B,0
	DC.W	$80E,$90C,$A0A,0,$80E,$90C,$A0A,0
	DC.W	$80E,$90C,$A0A,0,$80E,$90C,$A0A,0
	DC.W	$80D,$90D,$A0C,0,$80D,$90D,$A0C,0
	DC.W	$80E,$90C,$A09,0,$80E,$90C,$A09,0
	DC.W	$80E,$90C,$A05,0,$80E,$90C,$A00,0
	DC.W	$80E,$90C,$A00,0,$80E,$90B,$A0B,0
	DC.W	$80E,$90B,$A0B,0,$80E,$90B,$A0B,0

	DC.W	$80E,$90B,$A0B,0,$80E,$90B,$A0A,0
	DC.W	$80E,$90B,$A0A,0,$80E,$90B,$A0A,0
	DC.W	$80D,$90D,$A0B,0,$80D,$90D,$A0B,0
	DC.W	$80D,$90D,$A0B,0,$80E,$90B,$A09,0
	DC.W	$80E,$90B,$A09,0,$80E,$90B,$A09,0
	DC.W	$80D,$90C,$A0C,0,$80D,$90D,$A0A,0
	DC.W	$80E,$90B,$A07,0,$80E,$90B,$A00,0
	DC.W	$80E,$90B,$A00,0,$80D,$90D,$A09,0

	DC.W	$80D,$90D,$A09,0,$80E,$90A,$A09,0
	DC.W	$80D,$90D,$A08,0,$80D,$90D,$A07,0
	DC.W	$80D,$90D,$A04,0,$80D,$90D,$A00,0
	DC.W	$80E,$90A,$A04,0,$80E,$909,$A09,0
	DC.W	$80E,$909,$A09,0,$80D,$90C,$A0B,0
	DC.W	$80E,$909,$A08,0,$80E,$909,$A08,0
	DC.W	$80E,$909,$A07,0,$80E,$908,$A08,0
	DC.W	$80E,$909,$A01,0,$80C,$90C,$A0C,0

	DC.W	$80D,$90C,$A0A,0,$80E,$908,$A06,0
	DC.W	$80E,$907,$A07,0,$80E,$908,$A00,0
	DC.W	$80E,$907,$A05,0,$80E,$906,$A06,0
	DC.W	$80D,$90C,$A09,0,$80E,$905,$A05,0
	DC.W	$80E,$904,$A04,0,$80D,$90C,$A08,0
	DC.W	$80D,$90B,$A0B,0,$80E,$900,$A00,0
	DC.W	$80D,$90C,$A06,0,$80D,$90C,$A05,0
	DC.W	$80D,$90C,$A02,0,$80C,$90C,$A0B,0

	DC.W	$80C,$90C,$A0B,0,$80D,$90B,$A0A,0
	DC.W	$80D,$90B,$A0A,0,$80D,$90B,$A0A,0
	DC.W	$80D,$90B,$A0A,0,$80C,$90C,$A0A,0
	DC.W	$80C,$90C,$A0A,0,$80C,$90C,$A0A,0
	DC.W	$80D,$90B,$A09,0,$80D,$90B,$A09,0
	DC.W	$80D,$90A,$A0A,0,$80D,$90A,$A0A,0
	DC.W	$80D,$90A,$A0A,0,$80C,$90C,$A09,0
	DC.W	$80C,$90C,$A09,0,$80C,$90C,$A09,0

	DC.W	$80D,$90B,$A06,0,$80C,$90B,$A0B,0
	DC.W	$80C,$90C,$A08,0,$80D,$90B,$A00,0
	DC.W	$80D,$90B,$A00,0,$80C,$90C,$A07,0
	DC.W	$80C,$90C,$A06,0,$80C,$90C,$A05,0
	DC.W	$80C,$90C,$A03,0,$80C,$90C,$A01,0
	DC.W	$80C,$90B,$A0A,0,$80D,$90A,$A05,0
	DC.W	$80D,$90A,$A04,0,$80D,$90A,$A02,0
	DC.W	$80D,$909,$A08,0,$80D,$909,$A08,0

***********************
* MFP/FREQUENCY TABLE *
***********************
	EVEN
FREQTAB	DC.W	$506		* (0) = 4.9 KHZ
	DC.W	$505		* (1) = 7.68 KHZ
	DC.W	$405		* (2) = 9.6 KHZ
	DC.W	$2901		* (3)	= 15  KHZ
	DC.W	$1F01		* (4) = 19.8 KHZ
	DC.W	$802		* (5) = 30.7 KHZ
	DC.W	$405		* (6) = SPARE
	DC.W	$405		* (7) = SPARE
	
****************************
* KEYBOARD MESSAGE STRINGS *
****************************

SKBDDIS	DC.B	$12,$1A		* DISABLE MOUSE AND JYSTKS
SKBDEN	DC.B	$8		* RESET KBD
**************************
* DEFINE PROGRAM STORAGE *
**************************
	EVEN

samp	incbin	"revoluti.spl"		* DIN SAMPLING

	even
OLD_STACK	DS.L	1	* SUPER BASIC STACK
MFPMEM	DS.B	8	* SAVED MFP DATA
INUSE	DS.B	1	* INTERRUPT IN-USE FLAG
	even
