
#include <time.h>
#include "proto.h"

void bitblt(OBJECT *tree,MFDB *form,boolean flag)
{
	register int pxy[8],*ptr=pxy;
	register int x = tree->ob_x - 3,y = tree->ob_y - 3;
	register int w = tree->ob_width + 5,h = tree->ob_height + 5;
	
	graf_mouse(M_OFF,NULL);

	if (flag)
	{
		*ptr++ = x;
		*ptr++ = y;
		*ptr++ = x + w;
		*ptr++ = y + h;
		*ptr++ = *ptr++ = 0;
		*ptr++ = w;
		*ptr   = h;
		vro_cpyfm(x_handle,3,pxy,screen,form);
	}
	else
	{
		*ptr++ = *ptr++ = 0;
		*ptr++ = w;
		*ptr++ = h;
		*ptr++ = x;
		*ptr++ = y;
		*ptr++ = x + w;
		*ptr   = y + h;
		vro_cpyfm(x_handle,3,pxy,form,screen);
	}

	graf_mouse(M_ON,NULL);
}

void line(int x1,int y1,int x2,int y2)
{
	register int pxy[4];
	
	pxy[0] = x1;
	pxy[1] = y1;
	pxy[2] = x2;
	pxy[3] = y2;
	v_pline(x_handle,2,pxy);
}

void bar(int x,int y,int w,int h,int interior,int color)
{
	register int pxy[4];

	vsf_interior(x_handle,interior);
	vsf_color(x_handle,color);	
	pxy[0] = x;
	pxy[1] = y;
	pxy[2] = x + w;
	pxy[3] = y + h;
	v_bar(x_handle,pxy);
}

void vdi_attr(int mode,int wid,int col)
{
	vswr_mode(x_handle,mode);
	vsl_width(x_handle,wid);
	vsl_color(x_handle,col);
}

void beg_ctrl()
{
	wind_update(BEG_UPDATE);
	wind_update(BEG_MCTRL);
}

void end_ctrl()
{
	wind_update(END_MCTRL);
	wind_update(END_UPDATE);
}

void no_click()
{
	int button,dummy;
	graf_mkstate(&dummy,&dummy,&button,&dummy);
	if (button & 1)
		evnt_button(1,1,0,&dummy,&dummy,&dummy,&dummy);
}

/*************************/

int min(int v_1,int v_2)
{
	if (v_1<v_2)
		return(v_1);
	else
		return(v_2);
}

int max(int v_1,int v_2)
{
	if (v_1>v_2)
		return(v_1);
	else
		return(v_2);
}

void Min(int *var,int val)
{
	if (*var>val)
		*var = val;
}

void Max(int *var,int val)
{
	if (*var<val)
		*var = val;
}

int scan_2_ascii(int scan,int state)
{
	register KEYTAB *keytab = Keytbl((void *) -1l,(void *) -1l,(void *) -1l);

	if (state)
	{
		scan >>=8;
		if ((scan>=120) && (scan<=131))
			scan -= 118;
			
		if (state & 3)
			scan = (int) *(keytab->shift+scan);
		else
			scan = (int) *(keytab->unshift+scan);
	}

	scan &= 0xff;
	if (scan>='a')
	{
		if (scan<='z')
			scan -= 32;
		else if (scan=='')
			scan='';
		else if (scan=='')
			scan='';
		else if (scan=='')
			scan='';
	}
	return(scan);
}

void mfdb(MFDB *fm,int *adr,int w,int h,int st,int pl)
{
	fm->fd_addr		= adr;
	fm->fd_w		= (w+15) & 0xfff0;
	fm->fd_h		= h;
	fm->fd_wdwidth	= fm->fd_w>>4;
	fm->fd_stand	= st;
	fm->fd_nplanes	= pl;
}

long count_size(MFDB *fm)
{
	return ((long) (fm->fd_wdwidth<<1) * (long) fm->fd_h * (long) fm->fd_nplanes);
}

int Event_Multi(EVENT *event,long last)
{
	register int events;
	int button,dummy;
	long timer;

	if (event->ev_mflags & MU_TIMER)
	{
		if (last>0)
			timer = last;
		else
			timer = clock();
		timer += ((event->ev_mthicount<<16)|event->ev_mtlocount)/5;
	}
	
	do
	{
	 	events = EvntMulti(event);
		if ((events & MU_BUTTON) && !event->ev_mbstate)
		{
			vq_mouse(x_handle,&button,&dummy,&dummy);
			if (button & event->ev_bmask)
				events &= ~MU_BUTTON;
		}
		if ((event->ev_mflags & MU_TIMER) && !(events & MU_TIMER))
			if (clock()>=timer)
				events |= MU_TIMER;
	} while(!events);
	return (events);
}

void rc_clear(GRECT *dest)
{
	rc_scr_copy(dest,dest->g_x,dest->g_y,0);
}

void rc_scr_copy(GRECT *source,int dx,int dy,int mode)
{
	if (rc_intersect(&desk,source))
	{
		register GRECT dest;

		dest.g_x = dx;
		dest.g_y = dy;
		dest.g_w = source->g_w;
		dest.g_h = source->g_h;
		
		if (rc_intersect(&desk,&dest))
		{
			register int pxy[8];

			rc_grect_to_array(source,pxy);
			rc_grect_to_array(&dest,pxy+4);
			vro_cpyfm(x_handle,mode,pxy,screen,screen);
		}
	}
}
