
#include <stdio.h>
#include "proto.h"

static int cdecl draw_menu(PARMBLK *pb);
static USERBLK menublk = {draw_menu,0l};

void menu_tune(OBJECT *tree)
{
	do
	{
		tree++;
		if (tree->ob_type == G_STRING )
		if ((tree->ob_state & DISABLED) && (tree->ob_spec.free_string[0] == '-'))
		{
			tree->ob_type = G_USERDEF;
			tree->ob_spec.userblk = &menublk;
		}
	}
	while(!(tree->ob_flags & LASTOB));
}

int cdecl draw_menu(PARMBLK *pb)
{
	register int pxy[4];
	
	vswr_mode(x_handle,MD_REPLACE);
	vsf_interior(x_handle,FIS_PATTERN);
	vsf_style(x_handle,4);
	vsf_color(x_handle,1);
	
	pxy[0] = pb->pb_x;
	pxy[1] = pb->pb_y + (pb->pb_h>>1) - 1;
	pxy[2] = pxy[0] + pb->pb_w - 1;
	pxy[3] = pxy[1] + 1;
	vr_recfl(x_handle,pxy);
	
	return(FALSE);
}

void menu_enable(OBJECT *tree,boolean enable,boolean show)
{
	register OBJECT *obj = tree;

	if (show)
		menu_bar(tree,0);

	if (enable)
		while (!(obj->ob_flags & LASTOB))
		{
			if (obj->ob_state & 0x8000)
				obj->ob_state &= ~(0x8000|DISABLED);
			obj++;
		}
	else
	{
		register int index = 0,head = -2,state = 0x8000|DISABLED;
		int tail,title = 0,info = 1,box = 0;

		while (!(obj->ob_flags & LASTOB))
		{
			switch (obj->ob_type)
			{
			case G_TITLE:
				if (title)
					obj->ob_state |= state;
				else
					title = TRUE;
				break;
			case G_BOX:
				box++;
				if (head<0 && box==2)
				{
					head = obj->ob_head;
					tail = obj->ob_tail;
				}
				break;
			case G_STRING:
				if (index<=head || index>tail || info)
				{
					obj->ob_state |= state;
					info = 0;
				}
			}
			index++;
			obj++;
		}
	}

	if (show)
		menu_bar(tree,1);
}
