
#include "proto.h"

static EVENT event =
{ 0,1,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,{0,0,0,0,0,0,0,0} };

static void draw_rubber(int *);

void graf_rt_slide_box(OBJECT *ptree,int parent,int slider,int left,int right,int object,int slvh,
					   int mode,int wait,int speed,int (*call_func)(OBJECT *obj,int new,int max))
{
	register OBJECT *ob_ptr = &ptree[slider],*par_ptr = &ptree[parent];
	register int pos,prev,offset = 0,index,max_pos,count;
	int	start_x,start_y,delta,events,flag = 0,dummy;
	DIAINFO *info = get_info(ptree);
	boolean sl_mode;
	GRECT par;

	start_x = ob_ptr->ob_x;
	start_y = ob_ptr->ob_y;

	if (object==left || object==right)
	{
		sl_mode = TRUE;
		count = index = 0;
		if (object==left)
			left = FAIL;
		else
			right = FAIL;
	}
	else
	{
		if (object==slider)
		{
			graf_mkstate ( &event.ev_mm1x, &event.ev_mm1y, &dummy, &dummy);
			start_x -= event.ev_mm1x;
			start_y -= event.ev_mm1y;
			sl_mode = FAIL;
		}
		else
		{
			graf_mkstate ( &start_x, &start_y, &dummy, &dummy);
			
			sl_mode = FALSE;
		}
		mode = FAIL;
	}

	objc_offset(ptree,parent,&par.g_x,&par.g_y);
	par.g_w = par_ptr->ob_width;
	par.g_h = par_ptr->ob_height;

	if (slvh)
		max_pos = par_ptr->ob_height - ob_ptr->ob_height;
	else
		max_pos = par_ptr->ob_width - ob_ptr->ob_width;

	beg_ctrl();
	event.ev_mflags	= MU_BUTTON|MU_TIMER;
	if (sl_mode>0)
	{
		event.ev_mtlocount = speed;
		ob_draw_chg(info,object,NULL,ptree[object].ob_state | SELECTED,FALSE);
		evnt_timer(wait,0);
	}
	else if (!sl_mode)
	{
		if (slvh)
		{
			delta = ob_ptr->ob_height;
			if (start_y<par.g_y + ob_ptr->ob_y)
				delta = -delta;
		}
		else
		{
			delta = ob_ptr->ob_width;
		 	if (start_x<(par.g_x+ob_ptr->ob_x))
				delta = -delta;
		}
		event.ev_mtlocount = wait;
	}
	else
	{
		event.ev_mflags = MU_BUTTON|MU_M1;
		graf_mouse (FLAT_HAND,NULL);
	}
	
	do
	{
		if (mode==SL_LOG)
		{
			count++;
			event.ev_mtlocount = speed/count;
		}

		events = Event_Multi(&event,0);
		event.ev_mm1x = event.ev_mmox;
		event.ev_mm1y = event.ev_mmoy;

		if (max_pos>0)
		{
			prev = (slvh) ? ob_ptr->ob_y : ob_ptr->ob_x;

			if (sl_mode>0)
			{
				do
				{
					if (mode==SL_EXP)
						offset += ++index;
					else
						offset = ++index;
	
					pos = (slvh) ? start_y : start_x;
					if (left<0)
						pos -= offset;
					else
						pos += offset;

					if (pos<0 || pos>max_pos)
					{
						pos = min(max(pos,0),max_pos);
						flag = TRUE;
					}

					if (pos!=prev && call_func)
						pos = call_func(ob_ptr,pos,max_pos);
				} while (pos==prev && !flag);
			}
			else if (sl_mode<0)
			{
				if (slvh)
					pos = start_y + event.ev_mm1y;
				else
					pos = start_x + event.ev_mm1x;
			}
			else
				pos = prev + delta;
			pos = min(max(pos,0),max_pos);

			if (pos!=prev)
			{
				if (sl_mode<=0 && call_func)
					pos = call_func(ob_ptr,pos,max_pos);
				if (pos!=prev)
				{
				 	register GRECT area = par;
				 	register int dif = (pos < prev) ? (prev - pos) : (pos - prev);
				
					dif++;
					if (slvh)
					{
						area.g_h = dif;
						if (pos<prev)
							area.g_y += pos + ob_ptr->ob_height;
						else
							area.g_y += prev - 1;
					}
					else
					{
						area.g_w = dif;
						if (pos<prev)
							area.g_x += pos + ob_ptr->ob_width;
						else
							area.g_x += prev - 1;
					}
				
					if (slvh)
						ob_ptr->ob_y = pos;
					else
						ob_ptr->ob_x = pos;

					ob_draw_chg(info,parent,&area,FAIL,FALSE);
					ob_draw_chg(info,slider,NULL,FAIL,FALSE);
					graf_arrows(info,1,parent,slider,slvh,left,right);
				}
			}
		}
	} while (!((events & MU_BUTTON) || flag || mode==SL_STEP));

	no_click();
	if (sl_mode>0)
	{
		if (left<0)
			left = object;
		else
			right = object;
		ob_draw_chg(info,object,NULL,ptree[object].ob_state & (~SELECTED),FALSE);
		graf_arrows(info,1,parent,slider,slvh,left,right);
	}
	else
		graf_mouse (ARROW, NULL);
	end_ctrl();	
}



void graf_arrows(DIAINFO *info,int show,int parent,int slider,int slvh, int left,int right)
{
	register OBJECT *ptree = info->di_tree,*ob_ptr = ptree+slider,*par_ptr = ptree+parent;
	register int pos;
	
	if (slvh)
		pos = ob_ptr->ob_y;
	else
		pos = ob_ptr->ob_x;

	if (left!=FAIL)
	{
		register int flag = FALSE;
		if (ptree[left].ob_state & DISABLED)
		{
			if (pos)
			{
				ptree[left].ob_state &= ~DISABLED;
				flag = TRUE;
			}
		}
		else if (!pos)
		{
			ptree[left].ob_state |= DISABLED;
			flag = TRUE;
		}
		if (show && flag)
			ob_draw_chg(info,left,NULL,FAIL,FALSE);
	}
	
	if (right!=FAIL)
	{
		register int max_pos,flag = FALSE;

		if (slvh)
			max_pos = par_ptr->ob_height - ob_ptr->ob_height;
		else
			max_pos = par_ptr->ob_width - ob_ptr->ob_width;

		if (ptree[right].ob_state & DISABLED)
		{
			if (pos<max_pos)
			{
				ptree[right].ob_state &= ~DISABLED;
				flag = TRUE;
			}
		}
		else if (pos==max_pos)
		{
			ptree[right].ob_state |= DISABLED;
			flag = TRUE;
		}
		if (show && flag)
			ob_draw_chg(info,right,NULL,FAIL,FALSE);
	}
}

int graf_rt_rubberbox(int s_x,int s_y,GRECT *rect,int *r_w,int *r_h,void (*call_func)(int *new_rect))
{
	EVENT event;
	register int pxy[4];
	int events,rect_xy[4],max_1,max_2,dif,_void;
	
	if (!rc_inside(s_x,s_y,rect))
		return(FALSE);

	rc_grect_to_array(rect,rect_xy);
	
	pxy[0] = s_x;
	pxy[1] = s_y;
	
	max_1 = min(s_x - rect_xy[0],s_y - rect_xy[1]);
	max_2 = min(rect_xy[2] - s_x,rect_xy[3] - s_y);
	
	vdi_attr(MD_XOR,1,1);
	vsl_type(x_handle,7);

	beg_ctrl();	
	graf_mouse(POINT_HAND,NULL);
	graf_mkstate(&event.ev_mm1x,&event.ev_mm1y,&event.ev_mmokstate,&_void);
	
	event.ev_mflags = MU_BUTTON|MU_M1;
	event.ev_mbclicks = event.ev_bmask = event.ev_mm1flags = 1;
	event.ev_mbstate = 0;
	event.ev_mm1width = event.ev_mm1height = 1;
	
	do
	{
		pxy[2] = max(event.ev_mm1x,rect_xy[0]);
		Min(pxy+2,rect_xy[2]);
		
		pxy[3] = max(event.ev_mm1y,rect_xy[1]);
		Min(pxy+3,rect_xy[3]);
		
		if (event.ev_mmokstate & (K_LSHIFT | K_RSHIFT))
		{
			dif = pxy[2] - pxy[0];
			dif = (dif>0) ? min(dif,max_2) : max(dif,-max_1);
			pxy[2] = pxy[0] + dif;
			pxy[3] = pxy[1] + dif;
		}
		
		draw_rubber(pxy);
		
		if (call_func)
			call_func(pxy);
		
		events = Event_Multi(&event,0);
		draw_rubber(pxy);
	}
	while(!(events & MU_BUTTON));

	vsl_udsty(x_handle,0x5555);
	vsl_type(x_handle,1);

	graf_mouse(ARROW,NULL);
	end_ctrl();	
	
	*r_w = pxy[2] - pxy[0];
	*r_h = pxy[3] - pxy[1];
	
	return(TRUE);
}

void draw_rubber(register int *pxy)
{
	graf_mouse(M_OFF,0l);
	vsl_udsty(x_handle,(pxy[0] & 1) == (pxy[1] & 1) ? 21845 : (int) 43690L);
	line(pxy[0],pxy[1],pxy[0],pxy[3]);
	
	vsl_udsty(x_handle,(pxy[2] & 1) == (pxy[1] & 1) ? 21845 : (int) 43690L);
	line(pxy[2],pxy[1],pxy[2],pxy[3]);

	vsl_udsty(x_handle,(pxy[1] & 1) ? (int) 43690L : 21845);
	line(pxy[0],pxy[1],pxy[2],pxy[1]);
	
	vsl_udsty(x_handle,(pxy[3] & 1) ? (int) 43690L : 21845);
	line(pxy[0],pxy[3],pxy[2],pxy[3]);
	graf_mouse(M_ON,0l);
}
