/*

 NES.h - include file for NES.c - defines and function prototypes

 Ethan Dicks  <erd@kumiss.UUCP>

 Version 1.0	24-Mar-1992

*/
#ifndef NES_H_INCLUDE
#define NES_N_INCLUDE

#include <exec/types.h>
#include <hardware/cia.h>
#include <resources/cia.h>

/* Structure definition for CIA-A chip (parallel port) */
extern struct CIA far ciaa;

/* bits from parallel port -- Alan's hack */
#define		GDATA           0x04    /* glove data in */
#define		GLATCH          0x02    /* glove latch out */
#define		GCLOCK          0x01    /* glove clock out */
#define		GCLOLAT         (GLATCH|GCLOCK) /* latch and clock */

#define getbit()  	(ciaa.ciaprb & GDATA) >> 2
#define initport()	ciaa.ciaddrb = GCLOLAT

#define     C0L0()       ciaa.ciaprb = 0        /* clock 0 latch 0 */
#define     C0L1()       ciaa.ciaprb = GLATCH   /* clock 0 latch 1 */
#define     C1L0()       ciaa.ciaprb = GCLOCK   /* clock 1 latch 0 */
#define     C1L1()       ciaa.ciaprb = GCLOLAT  /* clock 1 latch 1 */

#define     setporta()	delay(3)
#define     setportb()  delay(3)

/* convert microseconds to cia ticks */
#define delay(usec) timersleep((usec*1397)/1000)

/* Function prototypes for NES.c */
int control_c( void );			/* ctrl-c trap handler */
UBYTE query_NES( void );		/* controller poll routine */
void init_NES( void );			/* I/O port initializer */

/* Bit definitions for standard NES controller bits */
#define PG_right	1
#define PG_left		2
#define PG_down		4
#define PG_up		8
#define PG_start	16
#define PG_select	32
#define PG_B		64
#define PG_A		128

#endif /* NES_H_INCLUDE */
