/*

 lores.c - a simple example of how to read a single byte NES controller

 Ethan Dicks  <erd@kumiss.UUCP>

 Version 1.0  24-Mar-1992

*/

#include <stdio.h>
#include "NES.h"

char *don[]  = {"right","left","down","up","start","select","B","A"};
char *doff[] = {"     ","    ","    ","  ","     ","      "," "," "};

void main (int argc, char **argv)
{
	UBYTE NES_response;
	register int i;

	init_NES();
	while(1) {
		NES_response = query_NES();

		printf("%02x ", NES_response);

		if (argc == 1) {
			for (i = 0; i < 8; i++) {
				printf("%s ",  NES_response & 1 ? doff[i] : don[i]);
				NES_response >>= 1;
			}
			printf("\r");
		}
	}
}
