/*
 * main.c for readilbm.c and writeilbm.c by Brett Van Sprewenburg
 *
 * main.c 
 *
 * Version	Date	
 *  1.2		2/4/93	Integration of both readilbm and writeilbm. Multiple bugs squashed
 *  1.2.1	2/10/93	Added version string information
 *  1.2.2	2/12/93 First public release
 */ 

#include <writeilbm.h>

extern WriteILBM(char *, int);
extern ReadILBM(char *, char *);

main(int argc, char **argv)
{
  FILE *ifp;
  int status,compression = 1;

  if (argc == 5) {
    compression = (int)((*argv[3] - '\0') - 48); 
    if ((compression > 1) || (compression < 0)) {
      fprintf(stderr,"Illegal value '%d', Compression is either '1' or '0'\n",compression);
      exit(1);
    }
  } else
  if (argc == 1) {
    fprintf(stderr,"Usage: %s [-r][-w] srcfile destfile\n",argv[0]);
    fprintf(stderr,"  Use '-r' when srcfile is an IFF24 ILBM and you want a Sun Raster in destfile.\n");
    fprintf(stderr,"  Use '-w' when srcfile is a Sun Raster and you want an IFF24 ILBM in destfile.\n");
    exit(1);
  }

  switch (argv[1][1] - '\0') {
    case 118:   /* v */
	fprintf(stderr,"Version: %s by Brett Van Sprewenburg\n",VERSION);
	break;

    case 119:	/* w */

  	status = LoadSunRas(argv[2]);
  	if (status < 0) {
    	  fprintf(stderr,"\nLoad of Sun Raster failed. Exiting, status %d.\n",status); 
    	exit(-1);
  	}
  	status = WriteILBM(argv[3],compression);
  	if (status < 0) {
    	  fprintf(stderr,"Write of IFF ILBM failed. Exiting, status %d.\n",status); 
    	exit(-2);
  	}
        break;

    case 114:  /* r */

	status = ReadILBM(argv[2],argv[3]);
  	if (status < 0) {
    	  fprintf(stderr,"ReadILBM failed. Exiting, status %d.\n",status); 
    	exit(-1);
  	}
	break;
 
    default:
	
	fprintf(stderr,"Unknown option '%s'.\n",argv[1]);
	exit(-1);
  }
}  
