/* ilbm.h - header file for IFF ILBM files
*/

#define RowBytes(cols)		( ( ( (int)(cols) + 15 ) / 16 ) * 2 )

/* definitions for BMHD */

struct BitMapHeader
{
    unsigned short w, h;
    short x, y;
    unsigned char nPlanes, masking, compression, pad1;
    unsigned short transparentColor;
    unsigned char xAspect, yAspect;
    short pageWidth, pageHeight;
};

#define mskNone			0
#define mskHasMask		1
#define mskHasTransparentColor	2
#define mskLasso		3

#define cmpNone			0
#define cmpByteRun1		1

typedef struct
    {
    unsigned char r, g, b;
    } pixel;

#define VERSION "1.3.1"
