 KGg  GgGgGgGgGgGg;-------------------T--------T

Track=1	;0=ASM-One version
	;1=Track version
AGA=0
Raster=0
Width=352
Height=288
Middle=9000
BckCol=$301
TandCol=$312

MyDmaco2=%11001000000
MyDmacon=%11111100000
;         abcdefghhhh
; a = Blitter nasty
; b = Enable DMA activity (always set this!)
; c = Bitplane enable
; d = Copper enable
; e = Blitter enable
; f = Sprite enable
; g = Disk enable
; h = Audio channels enable

MyIntena=%100000000100000
;         abcdeeeefghijkl
; a = Enable interrupts
; b = Lev. 6 External interrupt
; c = Lev. 5 Disk sync found
; d = Lev. 5 Serial port receive buffer full
; e = Lev. 4 Audio ch. 3-0 block finished
; f = Lev. 3 Blitter finished
; g = Lev. 3 Vertical blank
; h = Lev. 3 Copper
; i = Lev. 2 I/O Ports and timers
; j = Lev. 1 Software
; k = Lev. 1 Disk block finished
; l = Lev. 1 Serial port transmit buffer empty

	JumpPtr	Begin

	SECTION	Kode,code

*******************************************************************************
**Macros
*******************************************************************************
CopBltWait:	EQU	$00017ffe

WaitBlt:	MACRO
	btst	#14,Dmaconr+_Custom
.vent\@:	if	Raster=1
	move.w	#$fff,Color00+_Custom
	endif
	btst	#14,Dmaconr+_Custom
	bne.b	.vent\@
	if	Raster=1
	move.w	#0,Color00+_Custom
	endif
	ENDM

SetInt:	MACRO
	move.l	(Lev\1Base).w,OldIrq\1
	move.l	#Lev\1Irq,(Lev\1Base).w
	bra.b	jumpo\@
OldIrq\1:	dc.l	0
jumpo\@:
	ENDM

ClrInt:	MACRO
	move.l	OldIrq\1(pc),(Lev\1Base).w
	ENDM

Push.l:	MACRO
	movem.l	\1,-(sp)
	ENDM

Push.w:	MACRO
	movem.w	\1,-(sp)
	ENDM

Pull.l:	MACRO
	movem.l	(sp)+,\1
	ENDM

Pull.w:	MACRO
	movem.w	(sp)+,\1
	ENDM

StartPrg:	MACRO
	move.w	#$7fff,Intreq+_Custom
	move.w	#MyDmacon+$8000,Dmacon+_Custom
	move.w	#MyIntena+$8000,Intena+_Custom
	ENDM

StopPrg:	MACRO
	move.w	#$7fff,Intena+_Custom
	move.w	#$7fff,Dmacon+_Custom
	move.w	#$7fff,Intreq+_Custom
	ENDM

StopSystem:	MACRO
	move.w	Intenar+_Custom,OldIntena
	move.w	Dmaconr+_Custom,OldDmacon
	StopPrg
	bra.b	jumpo\@
OldIntena:	dc.w	0
OldDmacon:	dc.w	0
jumpo\@:
	ENDM

StartSystem:	MACRO
	move.w	OldDmacon(pc),d0
	or.w	#$8000,d0
	move.w	d0,Dmacon+_Custom
	move.w	OldIntena(pc),d0
	or.w	#$8000,d0
	move.w	d0,Intena+_Custom
	ENDM


*******************************************************************************
**Initialisering
*******************************************************************************
Begin:
	IF	Track=0
	Push.l	d0-a6
	StopSystem
	ELSE
	move.l	#Lev3Irq,(Lev1Base).w
	rts
	ENDC
**Init starter -----------------------------------
	lea	Clear,a0
	move.l	#(TheEnd-Clear)/4,d0
.clrloop:	clr.l	(a0)+
	subq.l	#1,d0
	bne.b	.clrloop

	lea	SinusTabel(pc),a0
	move.w	#1024+256-1,d0
.loop	asr.w	#1,(a0)+
	dbra	d0,.loop

	lea	ZMovesExtra(pc),a0
	move.w	-2(a0),d0
	move.w	d0,d1
	sub.w	-4(a0),d1
	add.w	d1,d0
	moveq	#34-1,d7
.moreloop	move.w	d0,(a0)+
	add.w	d1,d0
	dbra	d7,.moreloop

	bsr	InitMegaMulsTable_Plane

	lea	Muls80Tab,a0
	moveq	#0,d0
.mloop	move.w	d0,(a0)+
	add.w	#88,d0
	cmp.w	#88*288,d0
	bne.b	.mloop

	move.l	#BltCopper2,BltPtr

	move.l	#FontScreen,d0
	lea	TextPlan+2,a0
	lea	Copper_PlanePtr2+2,a1
	move.w	d0,4(a0)
	move.w	d0,4(a1)
	swap	d0
	move.w	d0,(a0)
	move.w	d0,(a1)

	bsr.w	TypeScreen_Plane

	IF	Track=0
;	move.l	#NoCopper,Cop1lch+_Custom
	move.w	#MyDmaco2+$8000,Dmacon+_Custom
	ENDC

	bsr	DrawSunAnim
	WaitBlt

**Init slutter -----------------------------------

	IFEQ	Track-0
	SetInt	3
	clr.l	$0.w
	StartPrg

*******************************************************************************
**Vent p exitsignal
*******************************************************************************
WaitForExit:	bsr	WaitVBlank
	tst.w	IWantOut
	bne.b	ExitToDos
	bra.b	WaitForExit

WaitBlanks:	bsr	WaitVBlank
	dbra	d0,WaitBlanks
	rts
WaitVBlank:	clr.w	VBlank
.wait	tst.w	VBlank
	beq.b	.wait
	rts

*******************************************************************************
**Exit to AmigaDOS
*******************************************************************************
ExitToDos:
	StopPrg

**Exit starter -----------------------------------
	ClrInt	3
**Exit slutter -----------------------------------

	StartSystem

	Pull.l	d0-a6
	moveq	#0,d0
	ENDC
	rts

*******************************************************************************
**Level 3 interrupt
*******************************************************************************
MegaPause:	dc.w	0
MegaStory:	dc.w	0
MaxRast:	dc.w	0
VBlank:	dc.w	0
	IF	Track=0
IWantOut:	dc.w	0
	ELSE
IWantOut:	EQU	$80
	ENDC
Lev3Irq:	move.w	#1,VBlank
	Push.l	d0-a6
**Lev3irq starter --------------------------------
	bsr	MegaStoryBoard
**Lev3irq slutter --------------------------------
	IFEQ	Track-1
	btst	#6,$bfe001
	bne.b	.noleft
	move.w	#-1,IWantOut
.noleft	ENDC
	WaitBlt
	IF	Raster=1
	move.w	#$f00,$dff180
	ENDIF
	move.b	$dff005,d0
	lsl.w	#8,d0
	move.b	$dff006,d0
	cmp.w	MaxRast(pc),d0
	bls.b	.nooot
	move.w	d0,MaxRast
.nooot	Pull.l	d0-a6
	IFEQ	Track-0
	move.w	#$0020,Intreq+_Custom
	ELSE
	move.w	#$0004,Intreq+_Custom
	ENDC
	rte


MegaStoryBoard:	move.w	MegaStory(pc),d0
	add.w	d0,d0
	add.w	d0,d0
	move.l	.routines(PC,d0.w),a0
	jmp	(a0)

.routines	dc.l	Init_Plane1,Init_Plane2,FadeUp,Lev3_Plane
	dc.l	Init_Vec,Init_Vec2,Init_Vec3,Lev3_Vec
	dc.l	Init_Plane11,Init_Plane21,Init_Plane3
	dc.l	Lev3_Plane
	dc.l	FadeDown,MakeExit

Ting:	dc.w	0

FadeUp:	move.l	#SunCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	bsr	MoveSun

	moveq	#2-1,d7
	lea	FadeColsBck(pc),a1
	lea	FadeCopper+2,a0
.dloop	move.w	(a0),d0
	move.w	(a1)+,d1
	bsr	fader
	move.w	d0,(a0)
	addq.w	#4,a0
	dbra	d7,.dloop

	addq.w	#1,Ting
	cmp.w	#20,Ting
	bne.b	.out
	addq.w	#1,MegaStory
.out	rts

FadeDown:	move.l	#SunCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	bsr	MoveSun

	moveq	#2-1,d7
	lea	FadeCopper+2,a0
.dloop	move.w	(a0),d0
	moveq	#0,d1
	bsr	fader
	move.w	d0,(a0)
	addq.w	#4,a0
	dbra	d7,.dloop

	subq.w	#1,Ting
	bne.b	.out
	addq.w	#1,MegaStory
.out	rts


FadeColsBck:	dc.w	BckCol
	dc.w	TandCol



TPause:	dc.w	100
TestPause:	move.l	#BlackCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	subq.w	#1,TPause
	bne.b	.out
	addq.w	#1,MegaStory
	move.w	#100,TPause
.out	rts

MakeExit:	move.l	#SunCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	move.w	#-1,IWantOut
	rts


Lev3_Vec:	move.l	#Copper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#%10,Copcon+_Custom

	bsr.w	SwapScr
	bsr	MoveSun
	bsr.w	ClrScr
	bsr.w	RotatePoints
	bsr.w	CalcFaces
	bsr.w	DrawFaces
	bsr.w	FillScr
	bsr.w	MoveObject
	bsr	FadeSvend

	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
;	IF	Raster=1
;	move.l	#Color00<<16+$888,(a6)+
;	ENDIF
	move.l	#-2,(a6)+
	move.l	a6,BltCopPtr

;	cmp.w	#820,MegaPause
;	bne.b	.noleft
;	addq.w	#1,MegaStory
.noleft	addq.w	#1,MegaPause

	rts

Init_Vec:	move.l	#BlackCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	bsr.w	SwapScr
	bsr.w	ClrScr
	bsr.w	MoveObject
	bsr.w	RotatePoints
	bsr.w	CalcFaces
	bsr.w	DrawFaces
	bsr.w	FillScr
	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	IF	Raster=1
	move.l	#Color00<<16+$888,(a6)+
	ENDIF
	move.l	#-2,(a6)
	addq.w	#1,MegaStory
	rts

Init_Vec2:	move.l	#BlackCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	bsr	MoveSun
	lea	_Custom,a6
	WaitBlt
	move.l	#Tand_Screen1,Bltdpth(a6)
	move.l	#$01000000,Bltcon0(a6)
	move.w	#0,Bltdmod(a6)
	move.w	#288<<6!44,Bltsize(a6)
	addq.w	#1,MegaStory
	rts

Init_Vec3:	move.l	#BlackCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	bsr	MoveSun
	lea	_Custom,a6
	WaitBlt
	move.l	#Tand_Screen2,Bltdpth(a6)
	move.l	#$01000000,Bltcon0(a6)
	move.w	#0,Bltdmod(a6)
	move.w	#288<<6!44,Bltsize(a6)
	addq.w	#1,MegaStory
	rts



Lev3_Plane:	move.l	#WriterCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#%10,Copcon+_Custom
	bsr.w	SwapScr_Plane
	bsr	MoveSun
	bsr.w	ClrScr_Plane
	bsr.w	CopyWriter_Plane
	bsr	StoryBoard_Plane
	rts


Init_Plane1Var:	dc.w	0
Init_Plane1:	move.l	#SunCopper,Cop2lch+_Custom
	bra.b	Init_Plane11|.hehe
Init_Plane11:	move.l	#BlackCopper,Cop2lch+_Custom
.hehe	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	bsr	MoveSun
	lea	BltCopper1,a0
	lea	BltCopper2,a1
	move.w	Init_Plane1Var(pc),d0
	move.w	d0,d1
	mulu	#24*36,d0
	add.w	d0,a0
	add.w	d0,a1
	cmp.w	#10,d1
	beq.b	.svend
	move.w	#24-1,d7
.bltloop	move.l	#$00017ffe,(a0)+
	move.l	#$00017ffe,(a1)+
	move.l	#Bltcpth<<16,(a0)+
	move.l	#Bltcpth<<16,(a1)+
	move.l	#Bltcptl<<16,(a0)+
	move.l	#Bltcptl<<16,(a1)+
	move.l	#Bltdpth<<16,(a0)+
	move.l	#Bltdpth<<16,(a1)+
	move.l	#Bltdptl<<16,(a0)+
	move.l	#Bltdptl<<16,(a1)+
	move.l	#Bltapth<<16,(a0)+
	move.l	#Bltapth<<16,(a1)+
	move.l	#Bltaptl<<16,(a0)+
	move.l	#Bltaptl<<16,(a1)+
	move.l	#Bltcon0<<16!$0BFA,(a0)+
	move.l	#Bltcon0<<16!$0BFA,(a1)+
	move.l	#Bltsize<<16!(1<<6!23),(a0)+
	move.l	#Bltsize<<16!(1<<6!23),(a1)+
	dbra	d7,.bltloop
	addq.w	#1,Init_Plane1Var
	rts
.svend	move.l	#Cop2lch<<16,(a0)+
	move.l	#Cop2lch<<16,(a1)+
	move.l	#Cop2lcl<<16,(a0)+
	move.l	#Cop2lcl<<16,(a1)+
	move.l	#-2,(a0)+
	move.l	#-2,(a1)+
	addq.w	#1,MegaStory
	clr.w	Init_Plane1Var
	rts

Init_Plane2:	move.l	#SunCopper,Cop2lch+_Custom
	bra.b	Init_Plane21|.hehe
Init_Plane21:	move.l	#BlackCopper,Cop2lch+_Custom
.hehe	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	bsr.w	SwapScr_Plane
	bsr	MoveSun
	bsr.w	ClrScr_Plane
	bsr.w	CopyWriter_Plane
	addq.w	#1,MegaStory
	rts

Init_Plane3:	move.l	#BlackCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	bsr	MoveSun
	lea	_Custom,a6
	WaitBlt
	move.l	#FontScreen,Bltapth(a6)
	move.l	#Screen1,Bltdpth(a6)
	move.l	#44,Bltamod(a6)
	move.l	#-1,Bltafwm(a6)
	move.l	#$09f00000,Bltcon0(a6)
	move.w	#288<<6!22,Bltsize(a6)
	WaitBlt
	move.l	#FontScreen,Bltapth(a6)
	move.l	#Screen2,Bltdpth(a6)
	move.l	#44,Bltamod(a6)
	move.l	#-1,Bltafwm(a6)
	move.l	#$09f00000,Bltcon0(a6)
	move.w	#288<<6!22,Bltsize(a6)
	addq.w	#1,MegaStory
	rts



*******************************************************************************
**
**  Storyboard
**
*******************************************************************************
Story_Plane:	dc.w	0
StoryBoard_Plane:	move.w	Story_Plane(pc),d0
	beq.b	Story_In_Plane
	subq.w	#1,d0
	beq.b	Story_Out_Plane
	rts

Story_In_Plane:	addq.w	#1,Writer_FaderPtr_Plane
	cmp.w	#255,Writer_FaderPtr_Plane
	bne.b	.ok
	addq.w	#1,Story_Plane
	addq.w	#1,MegaStory
.ok	rts

Story_Out_Plane:	subq.w	#1,Writer_FaderPtr_Plane
	bne.b	.ok
	addq.w	#1,Story_Plane
	addq.w	#1,MegaStory
.ok	rts


*******************************************************************************
**
**  Copy Writer
**
*******************************************************************************
CopyWriter_Plane:	move.l	BltPtr,a0
	addq.w	#4+2,a0
	lea	FontScreen+24*44,a1
	move.l	Screen_Draw,a2
	moveq	#0,d0
	move.w	Writer_FaderPtr_Plane(pc),d0
	lsl.w	#8,d0
	lea	MegaMulsTable,a3
	add.l	d0,a3
	lea	Muls80Tab,a4
	move.w	Writer_SinusPtr_Plane(pc),d3
	move.w	#240-1,d7
.loop	move.w	16*2(a3,d3.w),d0
	move.w	(a3,d3.w),d1
	add.w	#240-1+24,d1
	sub.w	d7,d1
	bge.b	.yok1
.ynotok	move.w	#352,d0
	moveq	#0,d1
	bra.b	.plotit
.yok1	cmp.w	#287,d1
	bgt.b	.ynotok
	cmp.w	#352,d0
	bgt.b	.ynotok
	cmp.w	#-352,d0
	ble.b	.ynotok
.plotit	add.w	d1,d1
	move.w	(a4,d1.w),d1
	move.w	d0,d2
	asr.w	#4,d0
	add.w	d0,d0
	add.w	d0,d1	;byteoffset
	lsl.b	#4,d2
	or.b	#%1011,d2	;bltcon0
	ext.l	d1
	add.l	a2,d1	;screenbytepos
	move.w	d1,4(a0)
	move.w	d1,8+4(a0)
	swap	d1
	move.w	d1,(a0)
	move.w	d1,8(a0)
	move.l	a1,d1
	move.w	d1,16+4(a0)
	swap	d1
	move.w	d1,16(a0)
	move.b	d2,24(a0)
	lea	36(a0),a0	;nextcopper
	lea	44(a1),a1	;nextline
	addq.w	#2,d3
	and.w	#64*2-1,d3
	dbra	d7,.loop
	addq.w	#2,Writer_SinusPtr_Plane
	and.w	#64*2-1,Writer_SinusPtr_Plane
	rts


InitMegaMulsTable_Plane:	lea	Writer_Fader_Plane(pc),a0
	lea	MegaMulsTable,a2
	move.w	#256-1,d6
.loop2	move.w	(a0)+,d1
	lea	Writer_Sinus_Plane(pc),a1
	move.w	#64-1,d7
.loop	move.w	(a1)+,d0
	muls	d1,d0
	asr.l	#8,d0
	asr.l	#1,d0
	move.w	d0,64*2(a2)
	move.w	d0,(a2)+
	dbra	d7,.loop
	lea	64*2(a2),a2
	dbra	d6,.loop2
	rts

Writer_SinusPtr_Plane:	dc.w	0
Writer_Sinus_Plane:	;0,360,64,512,0,l,1,y,n
	QREPT	2
	DC.W	$0019,$004B,$007C,$00AC,$00DA,$0107,$0130,$0157,$017B,$019B
	DC.W	$01B7,$01CE,$01E2,$01F0,$01FA,$01FF,$01FF,$01FA,$01F0,$01E2
	DC.W	$01CE,$01B7,$019B,$017B,$0157,$0130,$0107,$00DA,$00AC,$007C
	DC.W	$004B,$0019,$FFE7,$FFB5,$FF84,$FF54,$FF26,$FEF9,$FED0,$FEA9
	DC.W	$FE85,$FE65,$FE49,$FE32,$FE1E,$FE10,$FE06,$FE01,$FE01,$FE06
	DC.W	$FE10,$FE1E,$FE32,$FE49,$FE65,$FE85,$FEA9,$FED0,$FEF9,$FF26
	DC.W	$FF54,$FF84,$FFB5,$FFE7
	ENDQR

Writer_FaderPtr_Plane:	dc.w	0
Writer_Fader_Plane:	;180,270,256,256,256,w,1,n,y
	DC.W	$0200,$01FD,$01FA,$01F7,$01F3,$01F0,$01ED,$01EA,$01E7,$01E4
	DC.W	$01E1,$01DD,$01DA,$01D7,$01D4,$01D1,$01CE,$01CB,$01C8,$01C4
	DC.W	$01C1,$01BE,$01BB,$01B8,$01B5,$01B2,$01AF,$01AC,$01A8,$01A5
	DC.W	$01A2,$019F,$019C,$0199,$0196,$0193,$0190,$018D,$018A,$0187
	DC.W	$0184,$0181,$017E,$017A,$0177,$0174,$0171,$016E,$016B,$0168
	DC.W	$0165,$0162,$015F,$015C,$0159,$0156,$0154,$0151,$014E,$014B
	DC.W	$0148,$0145,$0142,$013F,$013C,$0139,$0136,$0133,$0131,$012E
	DC.W	$012B,$0128,$0125,$0122,$011F,$011D,$011A,$0117,$0114,$0111
	DC.W	$010F,$010C,$0109,$0106,$0104,$0101,$00FE,$00FB,$00F9,$00F6
	DC.W	$00F3,$00F1,$00EE,$00EB,$00E9,$00E6,$00E4,$00E1,$00DE,$00DC
	DC.W	$00D9,$00D7,$00D4,$00D2,$00CF,$00CC,$00CA,$00C7,$00C5,$00C3
	DC.W	$00C0,$00BE,$00BB,$00B9,$00B6,$00B4,$00B2,$00AF,$00AD,$00AA
	DC.W	$00A8,$00A6,$00A4,$00A1,$009F,$009D,$009A,$0098,$0096,$0094
	DC.W	$0092,$008F,$008D,$008B,$0089,$0087,$0085,$0083,$0080,$007E
	DC.W	$007C,$007A,$0078,$0076,$0074,$0072,$0070,$006E,$006C,$006A
	DC.W	$0069,$0067,$0065,$0063,$0061,$005F,$005D,$005C,$005A,$0058
	DC.W	$0056,$0055,$0053,$0051,$004F,$004E,$004C,$004A,$0049,$0047
	DC.W	$0046,$0044,$0043,$0041,$003F,$003E,$003C,$003B,$003A,$0038
	DC.W	$0037,$0035,$0034,$0033,$0031,$0030,$002F,$002D,$002C,$002B
	DC.W	$0029,$0028,$0027,$0026,$0025,$0023,$0022,$0021,$0020,$001F
	DC.W	$001E,$001D,$001C,$001B,$001A,$0019,$0018,$0017,$0016,$0015
	DC.W	$0014,$0013,$0013,$0012,$0011,$0010,$000F,$000F,$000E,$000D
	DC.W	$000C,$000C,$000B,$000A,$000A,$0009,$0009,$0008,$0008,$0007
	DC.W	$0007,$0006,$0006,$0005,$0005,$0004,$0004,$0003,$0003,$0003
	DC.W	$0002,$0002,$0002,$0002,$0001,$0001,$0001,$0001,$0001,$0000
	DC.W	$0000,$0000,$0000,$0000,$0000,$0000




*******************************************************************************
**
**  Type screen
**
*******************************************************************************
TypeScreen_Plane:	lea	FontScreen+2*44+24*44,a6
	lea	PlaneFont,a0
	lea	Text_Plane(pc),a1
.next	tst.b	(a1)
	beq.b	.out
	bsr.b	WriteLine_Plane
	bra.b	.next
.out	rts

WriteLine_Plane:	moveq	#0,d0
	move.b	(a1)+,d0
	cmp.b	#10,d0
	beq.b	.CRLF
	cmp.b	#1,d0
	bne.b	.notvenstre
	moveq	#0,d1	;X-Pos
	bra.b	.printit
.notvenstre	bsr.w	FindPixelSize_Plane
	move.w	#352,d1
	sub.w	d3,d1
	bge.b	.ok
	moveq	#0,d1
.ok	cmp.b	#2,d0
	bne.b	.printit
	lsr.w	#1,d1
.printit	moveq	#0,d0
	move.b	(a1)+,d0
	cmp.b	#10,d0
	beq.b	.CRLF
	bsr.b	PrintChar_Plane
	add.w	d2,d1
	bra.b	.printit
.CRLF	lea	20*44(a6),a6
	rts


** in:  d0=asciichar
**      d1=pos
**      a0=font
**      a6=screen
** out: d2=charsize
** trashes:
PrintChar_Plane:	bra.b	.jump
.wloop	bsr.b	.copybyte
	addq.w	#1,a2
	bsr.b	.copybyte
	lea	35(a2),a2
	lea	42(a3),a3
	dbra	d4,.wloop
	rts
.copybyte	moveq	#0,d5
	move.b	(a2),d5
	ror.w	d3,d5
	or.b	d5,(a3)+
	lsr.w	#8,d5
	or.b	d5,(a3)
	rts
.jump	sub.b	#32,d0
	add.w	d0,d0
	moveq	#0,d2
	moveq	#0,d3
	move.b	FontConverter_Plane(PC,d0.w),d3
	move.b	FontConverter_Plane+1(PC,d0.w),d2
	cmp.b	#35,d3
	shi	d5
	divu	#36,d3
	move.w	d3,d4
	mulu	#36*17,d4
	swap	d3
	add.w	d3,d4
	lea	(a0,d4.w),a2	;font
	move.w	d1,d3
	move.w	d3,d4
	lsr.w	#3,d4
	lea	(a6,d4.w),a3	;screen
	tst.b	d5
	beq.b	.small
	lea	-2*44(a3),a3
.small	and.w	#7,d3	;scrollvalue
	moveq	#17-1,d4
	cmp.b	#8,d2
	bhi.b	.wloop
.bloop	bsr.b	.copybyte
	lea	36(a2),a2
	lea	43(a3),a3
	dbra	d4,.bloop
	rts

** in:  a1=text_Plane
** out: d3=pixelsize
** trashes: d2/d4/a2
FindPixelSize_Plane:	move.l	a1,a2
	moveq	#0,d3
.next	moveq	#0,d2
	move.b	(a2)+,d2
	cmp.b	#10,d2
	beq.b	.gotit
	sub.b	#32,d2
	add.w	d2,d2
	moveq	#0,d4
	move.b	FontConverter_Plane+1(PC,d2.w),d4
	add.w	d4,d3
	bra.b	.next
.gotit	rts

FontConverter_Plane:	dc.b	82,6,86,3,79,8,82,6	 ; SPC - '#'
	dc.b	82,6,82,6,75,8,80,4	 ; '$' - '''
	dc.b	72,6,73,6,89,10,82,6	 ; '(' - '+'
	dc.b	77,4,74,5,76,3,83,11	 ; ',' - '/'
	dc.b	82,6,87,7,88,8,82,6	 ; '0' - '3'
	dc.b	82,6,82,6,82,6,82,6	 ; '4' - '7'
	dc.b	82,6,82,6,78,3,82,6	 ; '8' - ';'
	dc.b	82,6,82,6,82,6,85,8	 ; '<' - '?'
	dc.b	82,6,36,8,37,8,38,8	 ; '@' - 'C'
	dc.b	39,8,40,8,41,8,42,8	 ; 'D' - 'G'
	dc.b	43,8,44,3,45,8,46,8	 ; 'H' - 'K'
	dc.b	47,4,48,12,50,8,51,8 ; 'L' - 'O'
	dc.b	52,8,53,8,54,8,55,8	 ; 'P' - 'S'
	dc.b	56,8,57,8,58,8,59,12 ; 'T' - 'W'
	dc.b	61,8,62,8,63,8,72,6	 ; 'X' - '['
	dc.b	82,6,73,6,82,6,82,6	 ; '\' - '_'
	dc.b	81,8,00,8,01,8,02,8	 ; '`' - 'c'
	dc.b	03,8,04,8,05,8,06,8	 ; 'd' - 'g'
	dc.b	07,8,08,3,09,8,10,8	 ; 'h' - 'k'
	dc.b	11,4,12,12,14,8,15,8 ; 'l' - 'o'
	dc.b	16,8,17,8,18,8,19,8	 ; 'p' - 's'
	dc.b	20,8,21,8,22,8,23,12 ; 't' - 'w'
	dc.b	25,8,26,8,27,8,72,6	 ; 'x' - '{'
	dc.b	82,6,82,6,82,6,82,6	 ; '|' - DEL

	blk.w	32,(82<<8)!6

	dc.b	82,6,82,6,82,6,82,6	 ; SPC - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	71,8,68,8,64,10,82,6 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,69,8,82,6	 ; '' - ''
	dc.b	66,10,82,6,82,6,82,6 ; '' - ''
	dc.b	70,8,82,6,82,8,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	35,8,32,8,28,11,82,6 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,33,8,82,6	 ; '' - ''
	dc.b	30,10,82,6,82,6,82,6 ; '' - ''
	dc.b	34,8,82,6,82,8,82,6	 ; '' - ''


Text_Plane:	dc.b	2,'How To Skin A Cat consists of:',10
	dc.b	2,'(apart from the special A12OO features...)',10
	dc.b	10
	dc.b	2,'Trancing Music by Nuke/Lemon.',10
	dc.b	10
	dc.b	2,'2nd Titlepic by Mack',10
	dc.b	2,'All other graphics (hidden included) by Solnova',10
	dc.b	10
	dc.b	2,'Code by Slammer',10
	dc.b	10
	dc.b	2,'And so... everybody lived happily ever after!',10
	dc.b	0
	EVEN


*******************************************************************************
**
**  Clear screen using blitter
**
*******************************************************************************
ClrScr_Plane:	move.l	Screen_Show,d0
	lea	CopBlit1+2,a0
.insert	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	rts



*******************************************************************************
**
**  Swap screen for doublebuffering!
**
*******************************************************************************
SwapScr_Plane:	move.l	Screen_Draw(pc),a0
	move.l	Screen_Show(pc),a1
	move.l	a1,Screen_Draw
	move.l	a0,Screen_Show

	lea	Copper_PlanePtr+2,a3
	move.l	Screen_Draw,d0
.loop	move.w	d0,4(a3)
	swap	d0
	move.w	d0,(a3)

	lea	BltPtr,a0
	move.l	(a0),d0
	lea	BltCopper1,a1
	lea	BltCopper2,a2
	lea	BlitCopPtr,a3

	move.w	d0,6(a3)
	swap	d0
	move.w	d0,2(a3)
	swap	d0
	cmp.l	d0,a1
	beq.b	.make2
	move.l	a1,(a0)
	rts
.make2	move.l	a2,(a0)
	rts







Screen_Draw:	dc.l	Screen2
Screen_Show:	dc.l	Screen1







*******************************************************************************
**Fade svend
*******************************************************************************
FadeSvend:	cmp.w	#20,MegaPause
	blt.b	.up
	rts
.up	moveq	#6-1,d7
	lea	BckVecColors(pc),a1
	lea	VecColors(pc),a0
.dloop	move.w	(a0),d0
	move.w	(a1)+,d1
	bsr	fader
	move.w	d0,(a0)+
	dbra	d7,.dloop
	rts

LamFarve:	macro
	dc.w	((\1>>4)<<8)!((\2>>4)<<4)!(\3>>4)
	endm

BckVecColors:	LamFarve	217,165,255
	LamFarve	081,255,226
	LamFarve	255,154,206
	LamFarve	255,229,174
	LamFarve	139,165,255
	LamFarve	136,238,255



**d0=fade from
**d1=fade to
**out: d0=newcol
fader:	move.w	d0,d2
	move.w	d1,d3
	lsr.w	#8,d2
	lsr.w	#8,d3
	cmp.w	d2,d3
	beq	.nored
	blt	.redsub
	add.w	#$100,d0
	bra	.nored
.redsub:	sub.w	#$100,d0
.nored:	move.w	d0,d2
	move.w	d1,d3
	lsr.w	#4,d2
	lsr.w	#4,d3
	and.w	#$f,d2
	and.w	#$f,d3
	cmp.w	d2,d3
	beq	.nogreen
	blt	.greensub
	add.w	#$10,d0
	bra	.nogreen
.greensub:	sub.w	#$10,d0
.nogreen:	move.w	d0,d2
	move.w	d1,d3
	and.w	#$f,d2
	and.w	#$f,d3
	cmp.w	d2,d3
	beq	.noblue
	blt	.bluesub
	addq.w	#$1,d0
	bra	.noblue
.bluesub:	subq.w	#$1,d0
.noblue:	rts







*******************************************************************************
**Calc faces
*******************************************************************************
CalcFaces:
	lea	Faces(pc),a0
	lea	Rotated(pc),a1
	lea	FaceColors(pc),a2
	lea	VecColors(pc),a3
	lea	AllColors(pc),a4
	clr.w	-(sp)

.nextface:	clr.w	(a2)

	move.w	(a0)+,(sp)	;farve
	blt.w	.ud

	move.w	(a0)+,d6	;antal linjer

	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d0
	move.w	2(a1,d7.w),d1

	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d2
	move.w	2(a1,d7.w),d3

	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d4
	move.w	2(a1,d7.w),d5
	

	sub.w	d0,d2
	sub.w	d1,d3
	sub.w	d0,d4
	sub.w	d1,d5
	muls	d2,d5
	muls	d3,d4
	sub.l	d4,d5
	blt.w	.donext

	move.w	(sp),d0
	move.w	d0,(a2)
	subq.w	#1,d0
	add.w	d0,d0
	move.w	d0,-(sp)

	cmp.w	#6000,ZCenter
	bgt.b	.stor
	move.l	#44672727/16,d4
	divu	ZCenter(pc),d4
	sub.w	#6000/16,d4
	bra.b	.makecol
.stor	cmp.w	#12000,ZCenter
	bgt.b	.storre
	move.l	#13320000/16,d4
	divu	ZCenter(pc),d4
	sub.w	#820/16,d4
	bra.b	.makecol
.storre	move.w	ZCenter(pc),d4
	muls	#-245/16,d4
	divs	#18000,d4
	add.w	#453/16,d4
.makecol	divu	d4,d5

	move.w	(a3),d4
	move.w	d4,d0
	move.w	d4,d1
	move.w	d4,d2
	and.w	#$f00,d0
	and.w	#$0f0,d1
	and.w	#$00f,d2
	mulu	d5,d0
	mulu	d5,d1
	mulu	d5,d2

	Push.l	d0-d2
	lsr.l	#4,d0
	lsr.l	#4,d1
	lsr.l	#4,d2
	and.w	#$f00,d0
	and.w	#$0f0,d1
	and.w	#$00f,d2
	or.w	d1,d0
	or.w	d2,d0
	move.w	d0,d4
	Pull.l	d0-d2

	lsr.l	#8,d0
	lsr.l	#8,d1
	lsr.l	#8,d2
	and.w	#$f00,d0
	and.w	#$0f0,d1
	and.w	#$00f,d2
	or.w	d1,d0
	or.w	d2,d0

	move.w	(sp)+,d5
	move.w	d0,(a4,d5.w)
	move.w	d4,6(a4,d5.w)


.donext:	addq.w	#2,a3
	subq.w	#3,d6
	add.w	d6,d6
	add.w	d6,a0
	addq.w	#2,a2
	bra.w	.nextface

.ud:	addq.w	#2,sp
	lea	AllColors(pc),a0
	lea	CopColors,a1
	move.w	(a0)+,4*1+2(a1)
	move.w	(a0)+,4*4+2(a1)
	move.w	(a0)+,4*5+2(a1)
	IFEQ	AGA-1
	lea	CopColorsAga,a2
	move.w	(a0)+,4*1+2(a2)
	move.w	(a0)+,4*4+2(a2)
	move.w	(a0)+,4*5+2(a2)
	ENDC
	cmp.w	#Middle,ZCenter
	bgt.b	.tandcover
	lea	AllColors(pc),a0
	move.w	(a0)+,4*3+2(a1)
	move.w	(a0)+,4*6+2(a1)
	move.w	(a0)+,4*7+2(a1)
	IFEQ	AGA-1
	move.w	(a0)+,4*3+2(a2)
	move.w	(a0)+,4*6+2(a2)
	move.w	(a0)+,4*7+2(a2)
	ENDC
	rts
.tandcover	move.w	#TandCol,4*3+2(a1)
	move.w	#TandCol,4*6+2(a1)
	move.w	#TandCol,4*7+2(a1)
	IFEQ	AGA-1
	move.w	#TandCol,4*3+2(a2)
	move.w	#TandCol,4*6+2(a2)
	move.w	#TandCol,4*7+2(a2)
	ENDC
	rts

VecColors:	dc.w	$000,$000,$000,$000,$000,$000
AllColors:	blk.w	6,0








*******************************************************************************
**Draw Faces
*******************************************************************************

DrawFaces:
	bsr.w	Init_Line

	lea	Faces(pc),a0
	lea	Rotated(pc),a1
	lea	FaceColors(pc),a3

.nextface:
	tst.w	(a0)+
	blt.w	.ud

	move.w	(a0)+,d6	;antal linjer

	move.w	(a3)+,LineCol
	bne.b	.drawit

;	addq.w	#1,d6
	add.w	d6,d6
	add.w	d6,a0
	bra.b	.nextface

.drawit:	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d0
	move.w	2(a1,d7.w),d1

	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d2
	move.w	2(a1,d7.w),d3

	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d4
	move.w	2(a1,d7.w),d5

	Push.w	d0-d1

	Push.w	d0-d5

	movem.w	(sp),d0-d3
	bsr.w	Line_Draw
	movem.w	4(sp),d0-d3
	bsr.w	Line_Draw
	addq.w	#8,sp
	movem.w	(sp)+,d0-d1

	subq.w	#3,d6
	bra.b	.jumpin

.lines:	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d2
	move.w	2(a1,d7.w),d3
	Push.w	d2-d3
	bsr.w	Line_Draw
	Pull.w	d0-d1
.jumpin	dbra	d6,.lines

	Pull.w	d2-d3
	bsr.w	Line_Draw

	bra.w	.nextface

.ud:	lea	MinX1(pc),a0

	cmp.w	#Width-1,(a0)
	bgt.b	.makeno1
	cmp.w	#Height-1,2(a0)
	bgt.b	.makeno1
	tst.w	4(a0)
	blt.b	.makeno1
	tst.w	6(a0)
	blt.b	.makeno1

	tst.w	(a0)+
	bge.b	.xok1
	clr.w	-2(a0)
.xok1:	tst.w	(a0)+
	bge.b	.yok1
	clr.w	-2(a0)
.yok1:	cmp.w	#Width-1,(a0)+
	ble.b	.xok2
	move.w	#Width-1,-2(a0)
.xok2:	cmp.w	#Height-1,(a0)+
	ble.b	.yok2
	move.w	#Height-1,-2(a0)
	bra.b	.yok2
.makeno1:	move.l	#$7fff7fff,(a0)+
	move.l	#$80008000,(a0)+
.yok2:
	cmp.w	#Width-1,(a0)
	bgt.b	.makeno2
	cmp.w	#Height-1,2(a0)
	bgt.b	.makeno2
	tst.w	4(a0)
	blt.b	.makeno2
	tst.w	6(a0)
	blt.b	.makeno2

	tst.w	(a0)+
	bge.b	.xok12
	clr.w	-2(a0)
.xok12:	tst.w	(a0)+
	bge.b	.yok12
	clr.w	-2(a0)
.yok12:	cmp.w	#Width-1,(a0)+
	ble.b	.xok22
	move.w	#Width-1,-2(a0)
.xok22:	cmp.w	#Height-1,(a0)+
	ble.b	.yok22
	move.w	#Height-1,-2(a0)
	rts
.makeno2:	move.l	#$7fff7fff,(a0)+
	move.l	#$80008000,(a0)+
.yok22:
	rts






*******************************************************************************
**Rotate Points
*******************************************************************************
RotatePoints:
	lea	Points(pc),a5
	lea	Rotated(pc),a6
	lea	SinusTabel(pc),a0
	lea	CosinusTabel(pc),a1

	move.w	ZAngle(pc),d4
	add.w	d4,d4
	move.w	(a0,d4.w),d0
	swap	d0
	move.w	(a1,d4.w),d0
	move.l	d0,a2

	move.w	XAngle(pc),d4
	add.w	d4,d4
	move.w	(a0,d4.w),d0
	swap	d0
	move.w	(a1,d4.w),d0
	move.l	d0,a3

	move.w	YAngle(pc),d4
	add.w	d4,d4
	move.w	(a0,d4.w),d0
	swap	d0
	move.w	(a1,d4.w),d0
	move.l	d0,a4

.nextpoint:	move.w	(a5)+,d5
	cmp.w	#$8000,d5
	beq.w	.ud
	move.w	(a5)+,d6
	move.w	(a5)+,d7

**Rotation om z-aksen
	move.l	a2,d0
	move.w	d0,d1	;cos
	swap	d0	;sin
	move.w	d0,d2
	add.w	d1,d2	;sin+cos
	muls	d6,d0	;y*sin
	muls	d5,d1	;x*cos
	add.w	d5,d6	;x+y
	move.l	d1,d5
	sub.l	d0,d5
	swap	d5
	add.w	d5,d5
	add.w	d5,d5	;x*cos-y*sin
	muls	d2,d6	;(x+y)*(sin+cos)=x*sin+y*cos+x*cos+y*sin
	sub.l	d0,d6	;x*sin+y*cos+x*cos
	sub.l	d1,d6	;x*sin+y*cos
	swap	d6
	add.w	d6,d6
	add.w	d6,d6

**Rotation om x-aksen
	move.l	a3,d0
	move.w	d0,d1	;cos
	swap	d0	;sin
	move.w	d0,d2
	add.w	d1,d2	;sin+cos
	muls	d6,d0	;y*sin
	muls	d7,d1	;z*cos
	add.w	d7,d6	;z+y
	move.l	d1,d7
	sub.l	d0,d7
	swap	d7
	add.w	d7,d7
	add.w	d7,d7	;z*cos-y*sin
	muls	d2,d6	;(z+y)*(sin+cos)=z*sin+y*cos+z*cos+y*sin
	sub.l	d0,d6	;z*sin+y*cos+z*cos
	sub.l	d1,d6	;z*sin+y*cos
	swap	d6
	add.w	d6,d6
	add.w	d6,d6

**Rotation om y-aksen
	move.l	a4,d0
	move.w	d0,d1	;cos
	swap	d0	;sin
	move.w	d0,d2
	add.w	d1,d2	;sin+cos
	muls	d5,d0	;x*sin
	muls	d7,d1	;z*cos
	add.w	d7,d5	;z+x
	move.l	d1,d7
	sub.l	d0,d7
	swap	d7
	add.w	d7,d7
	add.w	d7,d7	;z*cos-x*sin
	muls	d2,d5	;(z+x)*(sin+cos)=z*sin+x*cos+z*cos+x*sin
	sub.l	d0,d5	;z*sin+x*cos+z*cos
	sub.l	d1,d5	;z*sin+x*cos
	swap	d5
	add.w	d5,d5
	add.w	d5,d5

**3d -> 2d
	add.w	XCenter(pc),d5
	add.w	YCenter(pc),d6
	add.w	ZCenter(pc),d7
	moveq	#9,d4
	ext.l	d5
	ext.l	d6
	asl.l	d4,d5
	asl.l	d4,d6
	divs	d7,d5
	divs	d7,d6

	add.w	#Width/2,d5
	add.w	#Height/2,d6

	movem.w	d5-d6,(a6)
	addq.w	#4,a6
	bra.w	.nextpoint

.ud:	rts

fak=15

Points:
	dc.w	-50*fak,-50*fak,-50*fak
	dc.w	50*fak,-50*fak,-50*fak
	dc.w	50*fak,50*fak,-50*fak
	dc.w	-50*fak,50*fak,-50*fak
	dc.w	-50*fak,-50*fak,50*fak
	dc.w	50*fak,-50*fak,50*fak
	dc.w	50*fak,50*fak,50*fak
	dc.w	-50*fak,50*fak,50*fak
	dc.w	$8000

Rotated:	blk.l	8,0

Faces:
	dc.w	1,4,0,1,2,3
	dc.w	1,4,7,6,5,4
	dc.w	2,4,4,5,1,0
	dc.w	2,4,3,2,6,7
	dc.w	3,4,0,3,7,4
	dc.w	3,4,2,1,5,6
	dc.w	$8000







*******************************************************************************
**Double-buffer
*******************************************************************************
Screen:	dc.l	Tand_Screen1
BltCop:	dc.l	BltCopper1
BltCopPtr:	dc.l	BltCopper1
SwapScr:
	move.l	BltCop(pc),d0
	lea	Bltpointer,a0
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)

	lea	Screen(pc),a0
	lea	Tand_Screen1,a1
	lea	Tand_Screen2,a2
	cmp.l	(a0),a1
	beq.b	.scr2
	move.l	a1,(a0)
	move.l	#BltCopper1,BltCop
	move.l	#BltCopper1,BltCopPtr
	bra	.dorest
.scr2:	move.l	a2,(a0)
	move.l	#BltCopper2,BltCop
	move.l	#BltCopper2,BltCopPtr
.dorest:
	move.l	Screen(pc),d0
	lea	Bitplaner+4*2,a0
	moveq	#2-1,d1
.loop:	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	add.l	#ByteWidth/2,d0
	addq.w	#8,a0
	dbra	d1,.loop

	rts

*******************************************************************************
**Fill Screen
*******************************************************************************
FillScr:
	cmp.l	#$7fff7fff,MinX1
	beq.w	.bpl2
	move.w	MaxY1(pc),d0
	muls	#ByteWidth,d0
	move.l	d0,a0
	move.w	MaxX1(pc),d1
	lsr.w	#3,d1
	and.w	#$fffe,d1
	add.w	d1,a0
	add.l	Screen(pc),a0	;Pointer
	move.w	MinX1(pc),d0
	lsr.w	#3,d0
	and.w	#$fffe,d0
	move.w	#ByteWidth-2,d2
	sub.w	d1,d2
	add.w	d0,d2
	move.w	d2,d3
	swap	d3
	move.w	d2,d3	;modulo
	move.w	MaxY1(pc),d2
	sub.w	MinY1(pc),d2
	addq.w	#1,d2
	lsl.w	#6,d2
	sub.w	d0,d1
	lsr.w	#1,d1
	addq.w	#1,d1
	or.w	d1,d2	;bltsize

	move.l	a0,d0
	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltaptl,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d0,(a6)+
	swap	d0
	move.w	#Bltapth,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdpth,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	#%0000100111110000,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	#$12,(a6)+
	move.w	#Bltafwm,(a6)+
	move.w	#-1,(a6)+
	move.w	#Bltalwm,(a6)+
	move.w	#-1,(a6)+
	move.w	#Bltdmod,(a6)+
	move.w	d3,(a6)+
	swap	d3
	move.w	#Bltamod,(a6)+
	move.w	d3,(a6)+
	move.w	#Bltsize,(a6)+
	move.w	d2,(a6)+
	move.l	a6,BltCopPtr

.bpl2:
	cmp.l	#$7fff7fff,MinX2
	beq.w	.bpl3
	move.w	MaxY2(pc),d0
	muls	#ByteWidth,d0
	move.l	d0,a0
	move.w	MaxX2(pc),d1
	lsr.w	#3,d1
	and.w	#$fffe,d1
	add.w	d1,a0
	add.l	Screen(pc),a0
	add.w	#ByteWidth/2,a0	;Pointer
	move.w	MinX2(pc),d0
	lsr.w	#3,d0
	and.w	#$fffe,d0
	move.w	#ByteWidth-2,d2
	sub.w	d1,d2
	add.w	d0,d2
	move.w	d2,d3
	swap	d3
	move.w	d2,d3	;modulo
	move.w	MaxY2(pc),d2
	sub.w	MinY2(pc),d2
	addq.w	#1,d2
	lsl.w	#6,d2
	sub.w	d0,d1
	lsr.w	#1,d1
	addq.w	#1,d1
	or.w	d1,d2	;bltsize

	move.l	a0,d0
	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltaptl,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d0,(a6)+
	swap	d0
	move.w	#Bltapth,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdpth,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	#%0000100111110000,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	#$12,(a6)+
	move.w	#Bltafwm,(a6)+
	move.w	#-1,(a6)+
	move.w	#Bltalwm,(a6)+
	move.w	#-1,(a6)+
	move.w	#Bltdmod,(a6)+
	move.w	d3,(a6)+
	swap	d3
	move.w	#Bltamod,(a6)+
	move.w	d3,(a6)+
	move.w	#Bltsize,(a6)+
	move.w	d2,(a6)+
	move.l	a6,BltCopPtr

.bpl3:
	rts






	
MinX1:	dc.w	$7fff
MinY1:	dc.w	$7fff
MaxX1:	dc.w	$8000
MaxY1:	dc.w	$8000
MinX2:	dc.w	$7fff
MinY2:	dc.w	$7fff
MaxX2:	dc.w	$8000
MaxY2:	dc.w	$8000
MinX3:	dc.w	$7fff
MinY3:	dc.w	$7fff
MaxX3:	dc.w	$8000
MaxY3:	dc.w	$8000

	dc.l	$7fff7fff,$80008000
	dc.l	$7fff7fff,$80008000
	dc.l	$7fff7fff,$80008000

	dc.l	$7fff7fff,$80008000
	dc.l	$7fff7fff,$80008000
	dc.l	$7fff7fff,$80008000


*******************************************************************************
**Line routine
**regs used: d0-d5/a0/a6
*******************************************************************************
ByteWidth=44*2
LineCol:	dc.w	0

Init_Line:	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltcmod,(a6)+
	move.w	#ByteWidth,(a6)+
	move.w	#Bltbdat,(a6)+
	move.w	#$ffff,(a6)+
	move.w	#Bltadat,(a6)+
	move.w	#$8000,(a6)+
	move.w	#Bltafwm,(a6)+
	move.w	#-1,(a6)+
	move.w	#Bltalwm,(a6)+
	move.w	#-1,(a6)+
	move.l	a6,BltCopPtr
	rts

Line_Draw:	move.w	LineCol(pc),d7
	btst	#0,d7
	beq.b	.tstbpl2
	lea	MinX1(pc),a2
	cmp.w	(a2)+,d0
	bgt.b	.minxok1
	move.w	d0,-2(a2)
.minxok1:	cmp.w	(a2)+,d1
	bgt.b	.minyok1
	move.w	d1,-2(a2)
.minyok1:	cmp.w	(a2)+,d0
	blt.b	.maxxok1
	move.w	d0,-2(a2)
.maxxok1:	cmp.w	(a2)+,d1
	blt.b	.tstbpl2
	move.w	d1,-2(a2)
.tstbpl2:	btst	#1,d7
	beq.b	.tstbpl3
	lea	MinX2(pc),a2
	cmp.w	(a2)+,d0
	bgt.b	.minxok2
	move.w	d0,-2(a2)
.minxok2:	cmp.w	(a2)+,d1
	bgt.b	.minyok2
	move.w	d1,-2(a2)
.minyok2:	cmp.w	(a2)+,d0
	blt.b	.maxxok2
	move.w	d0,-2(a2)
.maxxok2:	cmp.w	(a2)+,d1
	blt.b	.tstbpl3
	move.w	d1,-2(a2)
.tstbpl3:	btst	#2,d7
	beq.b	.makeline
	lea	MinX3(pc),a2
	cmp.w	(a2)+,d0
	bgt.b	.minxok3
	move.w	d0,-2(a2)
.minxok3:	cmp.w	(a2)+,d1
	bgt.b	.minyok3
	move.w	d1,-2(a2)
.minyok3:	cmp.w	(a2)+,d0
	blt.b	.maxxok3
	move.w	d0,-2(a2)
.maxxok3:	cmp.w	(a2)+,d1
	blt.b	.makeline
	move.w	d1,-2(a2)
.makeline:
	bsr.w	Line_Clip
	beq.w	.out

	cmp.w	d1,d3
	bgt.w	.line1
	exg	d0,d2
	exg	d1,d3
	beq.w	.out
.line1:	move.w	d1,d4
	muls	#ByteWidth,d4
	move.w	d0,d5
	add.l	Screen(pc),d4
	asr.w	#3,d5
	ext.l	d5
	add.l	d5,d4
	moveq	#0,d5
	sub.w	d1,d3
	sub.w	d0,d2
	bpl.s	.line2
	moveq	#1,d5
	neg.w	d2
.line2:	move.w	d3,d1
	add.w	d1,d1
	cmp.w	d2,d1
	dbhi	d3,.line3
.line3:	move.w	d3,d1
	sub.w	d2,d1
	bpl.s	.line4
	exg	d2,d3
.line4:	addx.w	d5,d5
	add.w	d2,d2
	move.w	d2,d1
	sub.w	d3,d2
	addx.w	d5,d5
	and.w	#15,d0
	ror.w	#4,d0
	or.w	#$a4a,d0
	move.w	d2,-(sp)
	sub.w	d3,d2
	lsl.w	#6,d3
	addq.w	#2,d3
	lea	Octants(pc),a2
	move.b	(a2,d5.w),d5
	swap	d1
	move.w	d2,d1
	btst	#0,d7
	beq.b	.bpl2

	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltaptl,(a6)+
	move.w	(sp),(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	d5,(a6)+
	move.w	#Bltcptl,(a6)+
	move.w	d4,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d4,(a6)+
	swap	d4
	move.w	#Bltcpth,(a6)+
	move.w	d4,(a6)+
	move.w	#Bltdpth,(a6)+
	move.w	d4,(a6)+
	swap	d4
	move.w	#Bltamod,(a6)+
	move.w	d1,(a6)+
	swap	d1
	move.w	#Bltbmod,(a6)+
	move.w	d1,(a6)+
	swap	d1
	move.w	#Bltsize,(a6)+
	move.w	d3,(a6)+
	move.l	a6,BltCopPtr
.bpl2:	add.l	#ByteWidth/2,d4
	btst	#1,d7
	beq.b	.bpl3
	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltaptl,(a6)+
	move.w	(sp),(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	d5,(a6)+
	move.w	#Bltcptl,(a6)+
	move.w	d4,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d4,(a6)+
	swap	d4
	move.w	#Bltcpth,(a6)+
	move.w	d4,(a6)+
	move.w	#Bltdpth,(a6)+
	move.w	d4,(a6)+
	swap	d4
	move.w	#Bltamod,(a6)+
	move.w	d1,(a6)+
	swap	d1
	move.w	#Bltbmod,(a6)+
	move.w	d1,(a6)+
	swap	d1
	move.w	#Bltsize,(a6)+
	move.w	d3,(a6)+
	move.l	a6,BltCopPtr
.bpl3:
	addq.w	#2,sp
	tst.w	Clip_Mark
	beq.b	.out
	move.w	#(Width-1),d0
	move.w	Clip_LineY1(pc),d1
	move.w	#(Width-1),d2
	move.w	Clip_LineY2(pc),d3
	bra.w	Line_Draw
.out:	RTS

Octants:	dc.b	$03,$43,$13,$53,$0b,$4b,$17,$57





*******************************************************************************
**ClipLine routine
**regs used: d0-d5
**input:
**d0: xstart  d1: ystart  d2: xstop  d3: ystop
**output:
**d0: xstart  d1: ystart  d2: xstop  d3: ystop
**d4: 0 if line is not supposed to be drawn
**sr: tst.w d4
*******************************************************************************
Screen_Width:	EQU	352
Screen_Height:	EQU	288
Clip_LineY1:	dc.w	0
Clip_LineY2:	dc.w	0
Clip_Mark:	dc.w	0
Line_Clip:	clr.l	Clip_LineY1
	clr.w	Clip_Mark
.tryagain:	cmp.w	d1,d3
	bge.b	.yturned
	exg	d0,d2
	exg	d1,d3
.yturned:	tst.w	d3
	blt.b	.dontdraw
	cmp.w	#Screen_Height-1,d1
	bgt.b	.dontdraw
	cmp.w	#Screen_Height-1,d3
	bgt.b	.clipdown
	tst.w	d1
	blt.b	.clipup

	cmp.w	d0,d2
	bge.b	.xturned
	exg	d0,d2
	exg	d1,d3
.xturned:	tst.w	d2
	blt.b	.dontdraw
	cmp.w	#Screen_Width-1,d0
	bgt.b	.dontdraw
	tst.w	d0
	blt.b	.clipleft
	cmp.w	#Screen_Width-1,d2
	bgt.b	.clipright

	moveq	#-1,d4	;drawit
	rts
.dontdraw:	moveq	#0,d4	;dontdrawit
	rts

.clipright:	move.w	#Screen_Width-1,d4
	sub.w	d0,d4	;skal ns
	sub.w	d0,d2	;er nu
	move.w	d3,Clip_LineY1
	sub.w	d1,d3
	muls	d4,d3
	divs	d2,d3
	add.w	d1,d3
	move.w	d3,Clip_LineY2
	move.w	#-1,Clip_Mark
	move.w	#Screen_Width-1,d2
	bra.b	.tryagain

.clipleft:		;skal ns=d2
	sub.w	d2,d0
	neg.w	d0	;er nu
	sub.w	d3,d1
	muls	d2,d1
	divs	d0,d1
	add.w	d3,d1
	moveq	#0,d0
	bra.b	.tryagain

.clipdown:	move.w	#Screen_Height-1,d4
	sub.w	d1,d4	;skal ns
	sub.w	d1,d3	;er nu
	sub.w	d0,d2
	muls	d4,d2
	divs	d3,d2
	add.w	d0,d2
	move.w	#Screen_Height-1,d3
	bra.w	.tryagain

.clipup:		;skal ns=d3
	sub.w	d3,d1
	neg.w	d1	;er nu
	sub.w	d2,d0
	muls	d3,d0
	divs	d1,d0
	add.w	d2,d0
	moveq	#0,d1
	bra.w	.tryagain









*******************************************************************************
**Move object
*******************************************************************************
StartPosX:	EQU	9000
StartPosY:	EQU	-3000
StartPosZ:	EQU	30000

StopPosX:	EQU	-3500
StopPosY:	EQU	1500
StopPosZ:	EQU	2000

MovePause:	dc.w	10

MoveObject:
	lea	XAdd(pc),a0
	lea	XAngle(pc),a1
	moveq	#3-1,d1
.loop:	move.w	(a0)+,d0
	add.w	d0,(a1)
	and.w	#1024-1,(a1)+
	dbra	d1,.loop

	cmp.w	#(533+20*10)*2,XSinusPtr
	beq.b	.out
	lea	ZSinus(pc),a0
	add.w	XSinusPtr(pc),a0
	move.w	(a0),ZCenter
	lea	YSinus(pc),a0
	add.w	XSinusPtr(pc),a0
	move.w	(a0),YCenter
	lea	XSinus(pc),a0
	add.w	XSinusPtr(pc),a0
	move.w	(a0),XCenter
	addq.w	#2,XSinusPtr
	rts
.out	cmp.w	#30500,ZCenter
	bhi.b	.out2
	add.w	#800,ZCenter
	add.w	#450,YCenter
	add.w	#400,XCenter
	rts
.out2	addq.w	#1,MegaStory
	rts


XAdd:	dc.w	2
YAdd:	dc.w	1
ZAdd:	dc.w	3

XAngle:	dc.w	0
YAngle:	dc.w	0
ZAngle:	dc.w	0

XCenter:	dc.w	9000
YCenter:	dc.w	0
ZCenter:	dc.w	30000

MoveNumber:	dc.w	0

FaceColors:	blk.w	6,0

ZSinus:	;90,180,400,21750,8250,w,1,y,n
	DC.W	$752F,$752F,$752E,$752D,$752C,$752A,$7528,$7526,$7523,$7520
	DC.W	$751D,$7519,$7515,$7511,$750C,$7507,$7502,$74FC,$74F6,$74F0
	DC.W	$74E9,$74E2,$74DB,$74D3,$74CB,$74C3,$74BA,$74B1,$74A7,$749E
	DC.W	$7494,$7489,$747F,$7474,$7468,$745C,$7450,$7444,$7437,$742A
	DC.W	$741D,$740F,$7401,$73F3,$73E4,$73D5,$73C6,$73B6,$73A6,$7396
	DC.W	$7385,$7374,$7363,$7351,$733F,$732D,$731A,$7307,$72F4,$72E0
	DC.W	$72CD,$72B8,$72A4,$728F,$727A,$7264,$724E,$7238,$7221,$720A
	DC.W	$71F3,$71DC,$71C4,$71AC,$7193,$717B,$7161,$7148,$712E,$7114
	DC.W	$70FA,$70DF,$70C4,$70A9,$708D,$7071,$7055,$7038,$701B,$6FFE
	DC.W	$6FE0,$6FC2,$6FA4,$6F86,$6F67,$6F48,$6F28,$6F09,$6EE9,$6EC8
	DC.W	$6EA7,$6E87,$6E65,$6E44,$6E22,$6DFF,$6DDD,$6DBA,$6D97,$6D73
	DC.W	$6D50,$6D2C,$6D07,$6CE3,$6CBE,$6C98,$6C73,$6C4D,$6C27,$6C00
	DC.W	$6BD9,$6BB2,$6B8B,$6B63,$6B3B,$6B13,$6AEB,$6AC2,$6A99,$6A6F
	DC.W	$6A45,$6A1B,$69F1,$69C6,$699C,$6970,$6945,$6919,$68ED,$68C1
	DC.W	$6894,$6867,$683A,$680C,$67DF,$67B1,$6782,$6754,$6725,$66F6
	DC.W	$66C6,$6696,$6666,$6636,$6606,$65D5,$65A4,$6572,$6541,$650F
	DC.W	$64DC,$64AA,$6477,$6444,$6411,$63DD,$63AA,$6376,$6341,$630D
	DC.W	$62D8,$62A3,$626D,$6237,$6202,$61CB,$6195,$615E,$6127,$60F0
	DC.W	$60B9,$6081,$6049,$6011,$5FD8,$5F9F,$5F66,$5F2D,$5EF4,$5EBA
	DC.W	$5E80,$5E46,$5E0B,$5DD1,$5D96,$5D5A,$5D1F,$5CE3,$5CA7,$5C6B
	DC.W	$5C2F,$5BF2,$5BB5,$5B78,$5B3B,$5AFD,$5AC0,$5A81,$5A43,$5A05
	DC.W	$59C6,$5987,$5948,$5909,$58C9,$5889,$5849,$5809,$57C8,$5787
	DC.W	$5746,$5705,$56C4,$5682,$5641,$55FF,$55BC,$557A,$5537,$54F4
	DC.W	$54B1,$546E,$542A,$53E7,$53A3,$535F,$531A,$52D6,$5291,$524C
	DC.W	$5207,$51C2,$517C,$5137,$50F1,$50AB,$5065,$501E,$4FD7,$4F91
	DC.W	$4F4A,$4F02,$4EBB,$4E73,$4E2C,$4DE4,$4D9C,$4D53,$4D0B,$4CC2
	DC.W	$4C79,$4C30,$4BE7,$4B9E,$4B54,$4B0B,$4AC1,$4A77,$4A2D,$49E2
	DC.W	$4998,$494D,$4902,$48B7,$486C,$4821,$47D5,$478A,$473E,$46F2
	DC.W	$46A6,$4659,$460D,$45C1,$4574,$4527,$44DA,$448D,$4440,$43F2
	DC.W	$43A5,$4357,$4309,$42BB,$426D,$421F,$41D0,$4182,$4133,$40E4
	DC.W	$4095,$4046,$3FF7,$3FA8,$3F58,$3F09,$3EB9,$3E6A,$3E1A,$3DCA
	DC.W	$3D79,$3D29,$3CD9,$3C88,$3C38,$3BE7,$3B96,$3B45,$3AF4,$3AA3
	DC.W	$3A52,$3A01,$39AF,$395E,$390C,$38BA,$3868,$3817,$37C5,$3772
	DC.W	$3720,$36CE,$367C,$3629,$35D6,$3584,$3531,$34DE,$348B,$3438
	DC.W	$33E5,$3392,$333F,$32EC,$3298,$3245,$31F1,$319E,$314A,$30F7
	DC.W	$30A3,$304F,$2FFB,$2FA7,$2F53,$2EFF,$2EAB,$2E57,$2E02,$2DAE
	DC.W	$2D5A,$2D05,$2CB1,$2C5C,$2C08,$2BB3,$2B5F,$2B0A,$2AB5,$2A60
	DC.W	$2A0C,$29B7,$2962,$290D,$28B8,$2863,$280E,$27B9,$2764,$270F
	DC.W	$26B9,$2664,$260F,$25BA,$2565,$250F,$24BA,$2465,$240F,$23BA
	DC.W	$2365,$230F,$22BA,$2265,$220F,$21BA,$2164,$210F,$20BA,$2064
ZMovesExtra:	BLK.W	34,0
;	270,360,100,9000-5368,9000,w,1,y,n
	DC.W	$14F9,$14FA,$14FB,$14FE,$1502,$1506,$150B,$1512,$1519,$1521
	DC.W	$152A,$1534,$153E,$154A,$1556,$1564,$1572,$1581,$1591,$15A2
	DC.W	$15B3,$15C6,$15D9,$15ED,$1602,$1618,$162F,$1646,$165E,$1678
	DC.W	$1691,$16AC,$16C8,$16E4,$1701,$171F,$173D,$175D,$177D,$179D
	DC.W	$17BF,$17E1,$1804,$1828,$184C,$1871,$1897,$18BD,$18E4,$190C
	DC.W	$1935,$195E,$1987,$19B1,$19DC,$1A07,$1A33,$1A60,$1A8D,$1ABB
	DC.W	$1AE9,$1B17,$1B47,$1B76,$1BA7,$1BD7,$1C08,$1C3A,$1C6C,$1C9E
	DC.W	$1CD1,$1D04,$1D38,$1D6C,$1DA0,$1DD5,$1E0A,$1E3F,$1E75,$1EAB
	DC.W	$1EE1,$1F18,$1F4F,$1F86,$1FBD,$1FF4,$202C,$2064,$209C,$20D4
	DC.W	$210D,$2145,$217E,$21B6,$21EF,$2228,$2261,$229A,$22D3,$230C
;	0,180,100,5000,9000,w,1,y,n
	DC.W	$2376,$2413,$24B0,$254C,$25E8,$2683,$271D,$27B7,$284F,$28E6
	DC.W	$297B,$2A0F,$2AA1,$2B31,$2BBF,$2C4B,$2CD5,$2D5C,$2DE1,$2E63
	DC.W	$2EE2,$2F5E,$2FD7,$304D,$30BF,$312E,$319A,$3202,$3266,$32C6
	DC.W	$3322,$337B,$33CF,$341F,$346A,$34B2,$34F5,$3533,$356D,$35A2
	DC.W	$35D2,$35FE,$3625,$3648,$3665,$367E,$3691,$36A0,$36AA,$36AF
	DC.W	$36AF,$36AA,$36A0,$3691,$367E,$3665,$3648,$3625,$35FE,$35D2
	DC.W	$35A2,$356D,$3533,$34F5,$34B2,$346A,$341F,$33CF,$337B,$3322
	DC.W	$32C6,$3266,$3202,$319A,$312E,$30BF,$304D,$2FD7,$2F5E,$2EE2
	DC.W	$2E63,$2DE1,$2D5C,$2CD5,$2C4B,$2BBF,$2B31,$2AA1,$2A0F,$297B
	DC.W	$28E6,$284F,$27B7,$271D,$2683,$25E8,$254C,$24B0,$2413,$2376
;	180,360,100,5000,9000,w,1,y,n
	DC.W	$22DA,$223D,$21A0,$2104,$2068,$1FCD,$1F33,$1E99,$1E01,$1D6A
	DC.W	$1CD5,$1C41,$1BAF,$1B1F,$1A91,$1A05,$197B,$18F4,$186F,$17ED
	DC.W	$176E,$16F2,$1679,$1603,$1591,$1522,$14B6,$144E,$13EA,$138A
	DC.W	$132E,$12D5,$1281,$1231,$11E6,$119E,$115B,$111D,$10E3,$10AE
	DC.W	$107E,$1052,$102B,$1008,$0FEB,$0FD2,$0FBF,$0FB0,$0FA6,$0FA1
	DC.W	$0FA1,$0FA6,$0FB0,$0FBF,$0FD2,$0FEB,$1008,$102B,$1052,$107E
	DC.W	$10AE,$10E3,$111D,$115B,$119E,$11E6,$1231,$1281,$12D5,$132E
	DC.W	$138A,$13EA,$144E,$14B6,$1522,$1591,$1603,$1679,$16F2,$176E
	DC.W	$17ED,$186F,$18F4,$197B,$1A05,$1A91,$1B1F,$1BAF,$1C41,$1CD5
	DC.W	$1D6A,$1E01,$1E99,$1F33,$1FCD,$2068,$2104,$21A0,$223D,$22DA



	BLK.W	60,0


XSinusPtr:	dc.w	0
XSinus:	BLK.W	234+20*10,0
;	180,270,100,2500,0,w,1,y,n
	DC.W	$FFED,$FFC6,$FF9E,$FF77,$FF50,$FF29,$FF02,$FEDB,$FEB4,$FE8D
	DC.W	$FE66,$FE3F,$FE19,$FDF2,$FDCC,$FDA6,$FD80,$FD5A,$FD34,$FD0F
	DC.W	$FCE9,$FCC4,$FC9F,$FC7A,$FC56,$FC32,$FC0E,$FBEA,$FBC6,$FBA3
	DC.W	$FB80,$FB5D,$FB3B,$FB19,$FAF7,$FAD6,$FAB4,$FA94,$FA73,$FA53
	DC.W	$FA33,$FA14,$F9F5,$F9D6,$F9B8,$F99A,$F97D,$F95F,$F943,$F927
	DC.W	$F90B,$F8F0,$F8D5,$F8BA,$F8A0,$F887,$F86E,$F855,$F83D,$F826
	DC.W	$F80E,$F7F8,$F7E2,$F7CC,$F7B7,$F7A3,$F78F,$F77B,$F768,$F756
	DC.W	$F744,$F733,$F722,$F712,$F702,$F6F3,$F6E5,$F6D7,$F6CA,$F6BD
	DC.W	$F6B1,$F6A5,$F69A,$F690,$F686,$F67D,$F674,$F66D,$F665,$F65E
	DC.W	$F658,$F653,$F64E,$F64A,$F646,$F643,$F640,$F63E,$F63D,$F63D
;	270,270+180,100,1250,-1250,w,1,y,n,
	DC.W	$F63D,$F63E,$F640,$F644,$F649,$F64F,$F656,$F65F,$F669,$F674
	DC.W	$F680,$F68D,$F69C,$F6AB,$F6BC,$F6CE,$F6E1,$F6F5,$F70A,$F720
	DC.W	$F737,$F74F,$F768,$F782,$F79D,$F7B9,$F7D5,$F7F3,$F811,$F830
	DC.W	$F850,$F870,$F891,$F8B3,$F8D6,$F8F9,$F91C,$F940,$F965,$F98A
	DC.W	$F9AF,$F9D5,$F9FB,$FA21,$FA48,$FA6E,$FA95,$FABC,$FAE4,$FB0B
	DC.W	$FB31,$FB58,$FB80,$FBA7,$FBCE,$FBF4,$FC1B,$FC41,$FC67,$FC8D
	DC.W	$FCB2,$FCD7,$FCFC,$FD20,$FD43,$FD66,$FD89,$FDAB,$FDCC,$FDEC
	DC.W	$FE0C,$FE2B,$FE49,$FE67,$FE83,$FE9F,$FEBA,$FED4,$FEED,$FF05
	DC.W	$FF1C,$FF32,$FF47,$FF5B,$FF6E,$FF80,$FF91,$FFA0,$FFAF,$FFBC
	DC.W	$FFC8,$FFD3,$FFDD,$FFE6,$FFED,$FFF3,$FFF8,$FFFC,$FFFE,$FFFF
;	90,270,100,1250,-1250,w,1,y,n
	DC.W	$FFFF,$FFFE,$FFFC,$FFF8,$FFF3,$FFED,$FFE6,$FFDD,$FFD3,$FFC8
	DC.W	$FFBC,$FFAF,$FFA0,$FF91,$FF80,$FF6E,$FF5B,$FF47,$FF32,$FF1C
	DC.W	$FF05,$FEED,$FED4,$FEBA,$FE9F,$FE83,$FE67,$FE49,$FE2B,$FE0C
	DC.W	$FDEC,$FDCC,$FDAB,$FD89,$FD66,$FD43,$FD20,$FCFC,$FCD7,$FCB2
	DC.W	$FC8D,$FC67,$FC41,$FC1B,$FBF4,$FBCE,$FBA7,$FB80,$FB58,$FB31
	DC.W	$FB0B,$FAE4,$FABC,$FA95,$FA6E,$FA48,$FA21,$F9FB,$F9D5,$F9AF
	DC.W	$F98A,$F965,$F940,$F91C,$F8F9,$F8D6,$F8B3,$F891,$F870,$F850
	DC.W	$F830,$F811,$F7F3,$F7D5,$F7B9,$F79D,$F782,$F768,$F74F,$F737
	DC.W	$F720,$F70A,$F6F5,$F6E1,$F6CE,$F6BC,$F6AB,$F69C,$F68D,$F680
	DC.W	$F674,$F669,$F65F,$F656,$F64F,$F649,$F644,$F640,$F63E,$F63D




	BLK.W	60,0


YSinus:	;180,270,400,9000,9000,w,1,y,n
	DC.W	$2317,$22F3,$22D0,$22AD,$2289,$2266,$2243,$221F,$21FC,$21D9
	DC.W	$21B6,$2192,$216F,$214C,$2128,$2105,$20E2,$20BE,$209B,$2078
	DC.W	$2055,$2032,$200E,$1FEB,$1FC8,$1FA5,$1F82,$1F5E,$1F3B,$1F18
	DC.W	$1EF5,$1ED2,$1EAF,$1E8C,$1E69,$1E46,$1E23,$1E00,$1DDD,$1DBA
	DC.W	$1D97,$1D74,$1D51,$1D2F,$1D0C,$1CE9,$1CC6,$1CA3,$1C81,$1C5E
	DC.W	$1C3B,$1C19,$1BF6,$1BD4,$1BB1,$1B8E,$1B6C,$1B4A,$1B27,$1B05
	DC.W	$1AE2,$1AC0,$1A9E,$1A7B,$1A59,$1A37,$1A15,$19F3,$19D1,$19AF
	DC.W	$198D,$196B,$1949,$1927,$1905,$18E3,$18C1,$18A0,$187E,$185C
	DC.W	$183B,$1819,$17F7,$17D6,$17B5,$1793,$1772,$1750,$172F,$170E
	DC.W	$16ED,$16CC,$16AB,$168A,$1669,$1648,$1627,$1606,$15E5,$15C5
	DC.W	$15A4,$1583,$1563,$1542,$1522,$1502,$14E1,$14C1,$14A1,$1481
	DC.W	$1461,$1440,$1421,$1401,$13E1,$13C1,$13A1,$1382,$1362,$1342
	DC.W	$1323,$1303,$12E4,$12C5,$12A6,$1286,$1267,$1248,$1229,$120A
	DC.W	$11EB,$11CD,$11AE,$118F,$1171,$1152,$1134,$1116,$10F7,$10D9
	DC.W	$10BB,$109D,$107F,$1061,$1043,$1025,$1008,$0FEA,$0FCD,$0FAF
	DC.W	$0F92,$0F74,$0F57,$0F3A,$0F1D,$0F00,$0EE3,$0EC6,$0EA9,$0E8D
	DC.W	$0E70,$0E54,$0E37,$0E1B,$0DFF,$0DE2,$0DC6,$0DAA,$0D8E,$0D73
	DC.W	$0D57,$0D3B,$0D20,$0D04,$0CE9,$0CCD,$0CB2,$0C97,$0C7C,$0C61
	DC.W	$0C46,$0C2B,$0C11,$0BF6,$0BDB,$0BC1,$0BA7,$0B8C,$0B72,$0B58
	DC.W	$0B3E,$0B24,$0B0B,$0AF1,$0AD7,$0ABE,$0AA5,$0A8B,$0A72,$0A59
	DC.W	$0A40,$0A27,$0A0E,$09F6,$09DD,$09C5,$09AC,$0994,$097C,$0964
	DC.W	$094C,$0934,$091C,$0904,$08ED,$08D5,$08BE,$08A7,$088F,$0878
	DC.W	$0861,$084B,$0834,$081D,$0807,$07F0,$07DA,$07C4,$07AE,$0798
	DC.W	$0782,$076C,$0756,$0741,$072B,$0716,$0701,$06EC,$06D7,$06C2
	DC.W	$06AD,$0698,$0684,$066F,$065B,$0647,$0633,$061F,$060B,$05F7
	DC.W	$05E4,$05D0,$05BD,$05A9,$0596,$0583,$0570,$055D,$054B,$0538
	DC.W	$0526,$0513,$0501,$04EF,$04DD,$04CB,$04B9,$04A8,$0496,$0485
	DC.W	$0473,$0462,$0451,$0440,$0430,$041F,$040E,$03FE,$03EE,$03DE
	DC.W	$03CD,$03BE,$03AE,$039E,$038F,$037F,$0370,$0361,$0352,$0343
	DC.W	$0334,$0325,$0317,$0308,$02FA,$02EC,$02DE,$02D0,$02C2,$02B4
	DC.W	$02A7,$029A,$028C,$027F,$0272,$0265,$0258,$024C,$023F,$0233
	DC.W	$0227,$021B,$020F,$0203,$01F7,$01EC,$01E0,$01D5,$01CA,$01BF
	DC.W	$01B4,$01A9,$019E,$0194,$0189,$017F,$0175,$016B,$0161,$0157
	DC.W	$014E,$0144,$013B,$0132,$0129,$0120,$0117,$010E,$0106,$00FD
	DC.W	$00F5,$00ED,$00E5,$00DD,$00D5,$00CE,$00C6,$00BF,$00B8,$00B1
	DC.W	$00AA,$00A3,$009D,$0096,$0090,$008A,$0084,$007E,$0078,$0072
	DC.W	$006D,$0067,$0062,$005D,$0058,$0053,$004E,$004A,$0045,$0041
	DC.W	$003D,$0039,$0035,$0031,$002E,$002A,$0027,$0024,$0021,$001E
	DC.W	$001B,$0018,$0016,$0013,$0011,$000F,$000D,$000B,$000A,$0008
	DC.W	$0007,$0006,$0004,$0003,$0003,$0002,$0001,$0001,$0001,$0001
	BLK.W	34,0
;	180,270,100,2500,0,w,1,y,n
	DC.W	$FFED,$FFC6,$FF9E,$FF77,$FF50,$FF29,$FF02,$FEDB,$FEB4,$FE8D
	DC.W	$FE66,$FE3F,$FE19,$FDF2,$FDCC,$FDA6,$FD80,$FD5A,$FD34,$FD0F
	DC.W	$FCE9,$FCC4,$FC9F,$FC7A,$FC56,$FC32,$FC0E,$FBEA,$FBC6,$FBA3
	DC.W	$FB80,$FB5D,$FB3B,$FB19,$FAF7,$FAD6,$FAB4,$FA94,$FA73,$FA53
	DC.W	$FA33,$FA14,$F9F5,$F9D6,$F9B8,$F99A,$F97D,$F95F,$F943,$F927
	DC.W	$F90B,$F8F0,$F8D5,$F8BA,$F8A0,$F887,$F86E,$F855,$F83D,$F826
	DC.W	$F80E,$F7F8,$F7E2,$F7CC,$F7B7,$F7A3,$F78F,$F77B,$F768,$F756
	DC.W	$F744,$F733,$F722,$F712,$F702,$F6F3,$F6E5,$F6D7,$F6CA,$F6BD
	DC.W	$F6B1,$F6A5,$F69A,$F690,$F686,$F67D,$F674,$F66D,$F665,$F65E
	DC.W	$F658,$F653,$F64E,$F64A,$F646,$F643,$F640,$F63E,$F63D,$F63D
;	270,270+180,100,1250,-1250,w,1,y,n,
	DC.W	$F63D,$F63E,$F640,$F644,$F649,$F64F,$F656,$F65F,$F669,$F674
	DC.W	$F680,$F68D,$F69C,$F6AB,$F6BC,$F6CE,$F6E1,$F6F5,$F70A,$F720
	DC.W	$F737,$F74F,$F768,$F782,$F79D,$F7B9,$F7D5,$F7F3,$F811,$F830
	DC.W	$F850,$F870,$F891,$F8B3,$F8D6,$F8F9,$F91C,$F940,$F965,$F98A
	DC.W	$F9AF,$F9D5,$F9FB,$FA21,$FA48,$FA6E,$FA95,$FABC,$FAE4,$FB0B
	DC.W	$FB31,$FB58,$FB80,$FBA7,$FBCE,$FBF4,$FC1B,$FC41,$FC67,$FC8D
	DC.W	$FCB2,$FCD7,$FCFC,$FD20,$FD43,$FD66,$FD89,$FDAB,$FDCC,$FDEC
	DC.W	$FE0C,$FE2B,$FE49,$FE67,$FE83,$FE9F,$FEBA,$FED4,$FEED,$FF05
	DC.W	$FF1C,$FF32,$FF47,$FF5B,$FF6E,$FF80,$FF91,$FFA0,$FFAF,$FFBC
	DC.W	$FFC8,$FFD3,$FFDD,$FFE6,$FFED,$FFF3,$FFF8,$FFFC,$FFFE,$FFFF
;	90,270,100,1250,-1250,w,1,y,n
	DC.W	$FFFF,$FFFE,$FFFC,$FFF8,$FFF3,$FFED,$FFE6,$FFDD,$FFD3,$FFC8
	DC.W	$FFBC,$FFAF,$FFA0,$FF91,$FF80,$FF6E,$FF5B,$FF47,$FF32,$FF1C
	DC.W	$FF05,$FEED,$FED4,$FEBA,$FE9F,$FE83,$FE67,$FE49,$FE2B,$FE0C
	DC.W	$FDEC,$FDCC,$FDAB,$FD89,$FD66,$FD43,$FD20,$FCFC,$FCD7,$FCB2
	DC.W	$FC8D,$FC67,$FC41,$FC1B,$FBF4,$FBCE,$FBA7,$FB80,$FB58,$FB31
	DC.W	$FB0B,$FAE4,$FABC,$FA95,$FA6E,$FA48,$FA21,$F9FB,$F9D5,$F9AF
	DC.W	$F98A,$F965,$F940,$F91C,$F8F9,$F8D6,$F8B3,$F891,$F870,$F850
	DC.W	$F830,$F811,$F7F3,$F7D5,$F7B9,$F79D,$F782,$F768,$F74F,$F737
	DC.W	$F720,$F70A,$F6F5,$F6E1,$F6CE,$F6BC,$F6AB,$F69C,$F68D,$F680
	DC.W	$F674,$F669,$F65F,$F656,$F64F,$F649,$F644,$F640,$F63E,$F63D






*******************************************************************************
**Clear Screen
*******************************************************************************
ClrScr:
	lea	MinX1+48(pc),a1
	lea	MinX1+72(pc),a2
	moveq	#12-1,d0
.moveloop:	move.l	-(a1),-(a2)
	dbra	d0,.moveloop

	lea	MinX1(pc),a0
	move.l	#$7fff7fff,d0
	move.l	#$80008000,d1
	move.l	d0,(a0)+
	move.l	d1,(a0)+
	move.l	d0,(a0)+
	move.l	d1,(a0)+
	move.l	d0,(a0)+
	move.l	d1,(a0)+

	lea	_Custom,a6

	move.w	MinY1+48(pc),d0
	cmp.w	#$7fff,d0
	beq.w	.bpl2
	muls	#ByteWidth,d0
	move.l	d0,a0
	move.w	MinX1+48(pc),d1
	lsr.w	#3,d1
	and.w	#$fffe,d1
	add.w	d1,a0
	add.l	Screen(pc),a0	;Pointer
	move.w	MaxX1+48(pc),d0
	lsr.w	#3,d0
	and.w	#$fffe,d0
	move.w	#ByteWidth-2,d2
	sub.w	d0,d2
	add.w	d1,d2
	move.w	d2,d3
	swap	d3
	move.w	d2,d3	;modulo
	move.w	MaxY1+48(pc),d2
	sub.w	MinY1+48(pc),d2
	addq.w	#1,d2
	lsl.w	#6,d2
	sub.w	d1,d0
	lsr.w	#1,d0
	addq.w	#1,d0
	or.w	d0,d2	;bltsize

	move.l	a0,d0
	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d0,(a6)+
	swap	d0
	move.w	#Bltdpth,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdmod,(a6)+
	move.w	d3,(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	#$0100,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	#$0000,(a6)+
	move.w	#Bltsize,(a6)+
	move.w	d2,(a6)+
	move.l	a6,BltCopPtr

.bpl2:
	move.w	MinY2+48(pc),d0
	cmp.w	#$7fff,d0
	beq.w	.bpl3
	muls	#ByteWidth,d0
	move.l	d0,a0
	move.w	MinX2+48(pc),d1
	lsr.w	#3,d1
	and.w	#$fffe,d1
	add.w	d1,a0
	add.l	Screen(pc),a0
	add.w	#ByteWidth/2,a0	;Pointer
	move.w	MaxX2+48(pc),d0
	lsr.w	#3,d0
	and.w	#$fffe,d0
	move.w	#ByteWidth-2,d2
	sub.w	d0,d2
	add.w	d1,d2
	move.w	d2,d3
	swap	d3
	move.w	d2,d3	;modulo
	move.w	MaxY2+48(pc),d2
	sub.w	MinY2+48(pc),d2
	addq.w	#1,d2
	lsl.w	#6,d2
	sub.w	d1,d0
	lsr.w	#1,d0
	addq.w	#1,d0
	or.w	d0,d2	;bltsize

	move.l	a0,d0
	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d0,(a6)+
	swap	d0
	move.w	#Bltdpth,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdmod,(a6)+
	move.w	d3,(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	#$0100,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	#$0000,(a6)+
	move.w	#Bltsize,(a6)+
	move.w	d2,(a6)+
	move.l	a6,BltCopPtr

.bpl3:
	rts







*******************************************************************************
**Tabeller
*******************************************************************************
SinusTabel:
;Option n  = 1
;Min. y-val = -3.27680E+04
;Max. y-val =  3.27670E+04
;Startvalue = min
;Length     = 1024
	dc.w	-1,201,402,603,804,1005,1206,1406,1607,1808,2009,2209,2410,2610,2811,3011
	dc.w	3211,3411,3611,3811,4011,4210,4409,4609,4807,5006,5205,5403,5601,5799,5997,6195
	dc.w	6392,6589,6786,6983,7179,7375,7571,7766,7961,8156,8351,8545,8739,8933,9126,9319
	dc.w	9511,9704,9895,10087,10278,10469,10659,10849,11039,11228,11416,11605,11792,11980,12167,12353
	dc.w	12539,12725,12910,13094,13278,13462,13645,13827,14009,14191,14372,14552,14732,14911,15090,15268
	dc.w	15446,15623,15799,15975,16151,16325,16499,16673,16845,17017,17189,17360,17530,17700,17868,18037
	dc.w	18204,18371,18537,18703,18867,19031,19195,19357,19519,19680,19841,20000,20159,20317,20475,20631
	dc.w	20787,20942,21096,21250,21402,21554,21705,21855,22005,22153,22301,22448,22594,22739,22884,23027
	dc.w	23170,23311,23452,23592,23731,23869,24007,24143,24279,24413,24547,24680,24811,24942,25072,25201
	dc.w	25329,25456,25582,25707,25832,25955,26077,26198,26319,26438,26556,26673,26790,26905,27019,27132
	dc.w	27245,27356,27466,27575,27683,27790,27896,28001,28105,28208,28310,28410,28510,28609,28706,28803
	dc.w	28898,28992,29085,29177,29268,29358,29447,29534,29621,29706,29791,29874,29956,30037,30117,30195
	dc.w	30273,30349,30424,30498,30571,30643,30714,30783,30852,30919,30985,31050,31113,31176,31237,31297
	dc.w	31356,31414,31470,31526,31580,31633,31685,31736,31785,31833,31880,31926,31971,32014,32057,32098
	dc.w	32137,32176,32213,32250,32285,32318,32351,32382,32412,32441,32469,32495,32521,32545,32567,32589
	dc.w	32609,32628,32646,32663,32678,32692,32705,32717,32728,32737,32745,32752,32757,32761,32765,32766

CosinusTabel:
;Option n  = 1
;Min. y-val = -3.27680E+04
;Max. y-val =  3.27670E+04
;Startvalue = max
;Length     = 1024
	dc.w	32767,32766,32765,32761,32757,32752,32745,32737,32728,32717,32705,32692,32678,32663,32646,32628
	dc.w	32609,32589,32567,32545,32521,32495,32469,32441,32412,32382,32351,32318,32285,32250,32213,32176
	dc.w	32137,32098,32057,32014,31971,31926,31880,31833,31785,31736,31685,31633,31580,31526,31470,31414
	dc.w	31356,31297,31237,31176,31113,31050,30985,30919,30852,30783,30714,30643,30571,30498,30424,30349
	dc.w	30273,30195,30117,30037,29956,29874,29791,29706,29621,29534,29447,29358,29268,29177,29085,28992
	dc.w	28898,28803,28706,28609,28510,28410,28310,28208,28105,28001,27896,27790,27683,27575,27466,27356
	dc.w	27245,27132,27019,26905,26790,26673,26556,26438,26319,26198,26077,25955,25832,25707,25582,25456
	dc.w	25329,25201,25072,24942,24811,24680,24547,24413,24279,24143,24007,23869,23731,23592,23452,23311
	dc.w	23170,23027,22884,22739,22594,22448,22301,22153,22005,21855,21705,21554,21402,21250,21096,20942
	dc.w	20787,20631,20475,20317,20159,20000,19841,19680,19519,19357,19195,19031,18867,18703,18537,18371
	dc.w	18204,18037,17868,17700,17530,17360,17189,17017,16845,16673,16499,16325,16151,15975,15799,15623
	dc.w	15446,15268,15090,14911,14732,14552,14372,14191,14009,13827,13645,13462,13278,13094,12910,12725
	dc.w	12539,12353,12167,11980,11792,11605,11416,11228,11039,10849,10659,10469,10278,10087,9895,9704
	dc.w	9511,9319,9126,8933,8739,8545,8351,8156,7961,7766,7571,7375,7179,6983,6786,6589
	dc.w	6392,6195,5997,5799,5601,5403,5205,5006,4807,4609,4409,4210,4011,3811,3611,3411
	dc.w	3211,3011,2811,2610,2410,2209,2009,1808,1607,1406,1206,1005,804,603,402,201
	dc.w	-1,-202,-403,-604,-805,-1006,-1207,-1407,-1608,-1809,-2010,-2210,-2411,-2611,-2812,-3012
	dc.w	-3212,-3412,-3612,-3812,-4012,-4211,-4410,-4610,-4808,-5007,-5206,-5404,-5602,-5800,-5998,-6196
	dc.w	-6393,-6590,-6787,-6984,-7180,-7376,-7572,-7767,-7962,-8157,-8352,-8546,-8740,-8934,-9127,-9320
	dc.w	-9512,-9705,-9896,-10088,-10279,-10470,-10660,-10850,-11040,-11229,-11417,-11606,-11793,-11981,-12168,-12354
	dc.w	-12540,-12726,-12911,-13095,-13279,-13463,-13646,-13828,-14010,-14192,-14373,-14553,-14733,-14912,-15091,-15269
	dc.w	-15447,-15624,-15800,-15976,-16152,-16326,-16500,-16674,-16846,-17018,-17190,-17361,-17531,-17701,-17869,-18038
	dc.w	-18205,-18372,-18538,-18704,-18868,-19032,-19196,-19358,-19520,-19681,-19842,-20001,-20160,-20318,-20476,-20632
	dc.w	-20788,-20943,-21097,-21251,-21403,-21555,-21706,-21856,-22006,-22154,-22302,-22449,-22595,-22740,-22885,-23028
	dc.w	-23171,-23312,-23453,-23593,-23732,-23870,-24008,-24144,-24280,-24414,-24548,-24681,-24812,-24943,-25073,-25202
	dc.w	-25330,-25457,-25583,-25708,-25833,-25956,-26078,-26199,-26320,-26439,-26557,-26674,-26791,-26906,-27020,-27133
	dc.w	-27246,-27357,-27467,-27576,-27684,-27791,-27897,-28002,-28106,-28209,-28311,-28411,-28511,-28610,-28707,-28804
	dc.w	-28899,-28993,-29086,-29178,-29269,-29359,-29448,-29535,-29622,-29707,-29792,-29875,-29957,-30038,-30118,-30196
	dc.w	-30274,-30350,-30425,-30499,-30572,-30644,-30715,-30784,-30853,-30920,-30986,-31051,-31114,-31177,-31238,-31298
	dc.w	-31357,-31415,-31471,-31527,-31581,-31634,-31686,-31737,-31786,-31834,-31881,-31927,-31972,-32015,-32058,-32099
	dc.w	-32138,-32177,-32214,-32251,-32286,-32319,-32352,-32383,-32413,-32442,-32470,-32496,-32522,-32546,-32568,-32590
	dc.w	-32610,-32629,-32647,-32664,-32679,-32693,-32706,-32718,-32729,-32738,-32746,-32753,-32758,-32762,-32766,-32767
	dc.w	-32768,-32767,-32766,-32762,-32758,-32753,-32746,-32738,-32729,-32718,-32706,-32693,-32679,-32664,-32647,-32629
	dc.w	-32610,-32590,-32568,-32546,-32522,-32496,-32470,-32442,-32413,-32383,-32352,-32319,-32286,-32251,-32214,-32177
	dc.w	-32138,-32099,-32058,-32015,-31972,-31927,-31881,-31834,-31786,-31737,-31686,-31634,-31581,-31527,-31471,-31415
	dc.w	-31357,-31298,-31238,-31177,-31114,-31051,-30986,-30920,-30853,-30784,-30715,-30644,-30572,-30499,-30425,-30350
	dc.w	-30274,-30196,-30118,-30038,-29957,-29875,-29792,-29707,-29622,-29535,-29448,-29359,-29269,-29178,-29086,-28993
	dc.w	-28899,-28804,-28707,-28610,-28511,-28411,-28311,-28209,-28106,-28002,-27897,-27791,-27684,-27576,-27467,-27357
	dc.w	-27246,-27133,-27020,-26906,-26791,-26674,-26557,-26439,-26320,-26199,-26078,-25956,-25833,-25708,-25583,-25457
	dc.w	-25330,-25202,-25073,-24943,-24812,-24681,-24548,-24414,-24280,-24144,-24008,-23870,-23732,-23593,-23453,-23312
	dc.w	-23171,-23028,-22885,-22740,-22595,-22449,-22302,-22154,-22006,-21856,-21706,-21555,-21403,-21251,-21097,-20943
	dc.w	-20788,-20632,-20476,-20318,-20160,-20001,-19842,-19681,-19520,-19358,-19196,-19032,-18868,-18704,-18538,-18372
	dc.w	-18205,-18038,-17869,-17701,-17531,-17361,-17190,-17018,-16846,-16674,-16500,-16326,-16152,-15976,-15800,-15624
	dc.w	-15447,-15269,-15091,-14912,-14733,-14553,-14373,-14192,-14010,-13828,-13646,-13463,-13279,-13095,-12911,-12726
	dc.w	-12540,-12354,-12168,-11981,-11793,-11606,-11417,-11229,-11040,-10850,-10660,-10470,-10279,-10088,-9896,-9705
	dc.w	-9512,-9320,-9127,-8934,-8740,-8546,-8352,-8157,-7962,-7767,-7572,-7376,-7180,-6984,-6787,-6590
	dc.w	-6393,-6196,-5998,-5800,-5603,-5404,-5206,-5007,-4809,-4610,-4410,-4211,-4012,-3812,-3612,-3412
	dc.w	-3212,-3012,-2812,-2612,-2411,-2210,-2010,-1809,-1608,-1407,-1207,-1006,-805,-604,-403,-202
	dc.w	-1,201,402,603,804,1005,1206,1406,1607,1808,2009,2209,2410,2610,2811,3011
	dc.w	3211,3411,3611,3811,4011,4210,4409,4609,4807,5006,5205,5403,5601,5799,5997,6195
	dc.w	6392,6589,6786,6983,7179,7375,7571,7766,7961,8156,8351,8545,8739,8933,9126,9319
	dc.w	9511,9704,9895,10087,10278,10469,10659,10849,11039,11228,11416,11605,11792,11980,12167,12353
	dc.w	12539,12725,12910,13094,13278,13462,13645,13827,14009,14191,14372,14552,14732,14911,15090,15268
	dc.w	15446,15623,15799,15975,16151,16325,16499,16673,16845,17017,17189,17360,17530,17700,17868,18037
	dc.w	18204,18371,18537,18703,18867,19031,19195,19357,19519,19680,19841,20000,20159,20317,20475,20631
	dc.w	20787,20942,21096,21250,21402,21554,21705,21855,22005,22153,22301,22448,22594,22739,22884,23027
	dc.w	23170,23311,23452,23592,23731,23869,24007,24143,24279,24413,24547,24680,24811,24942,25072,25201
	dc.w	25329,25456,25582,25707,25832,25955,26077,26198,26319,26438,26556,26673,26790,26905,27019,27132
	dc.w	27245,27356,27466,27575,27683,27790,27896,28001,28105,28208,28310,28410,28510,28609,28706,28803
	dc.w	28898,28992,29085,29177,29268,29358,29447,29534,29621,29706,29791,29874,29956,30037,30117,30195
	dc.w	30273,30349,30424,30498,30571,30643,30714,30783,30852,30919,30985,31050,31113,31176,31237,31297
	dc.w	31356,31414,31470,31526,31580,31633,31685,31736,31785,31833,31880,31926,31971,32014,32057,32098
	dc.w	32137,32176,32213,32250,32285,32318,32351,32382,32412,32441,32469,32495,32521,32545,32567,32589
	dc.w	32609,32628,32646,32663,32678,32692,32705,32717,32728,32737,32745,32752,32757,32761,32765,32766









*******************************************************************************
**THE SUN
*******************************************************************************
MoveSun:	move.l	#Screens,d1
	move.w	FrameNumber(pc),d0
	mulu	#288*44,d0
	add.l	d0,d1
	lea	Bitplaner,a0
	lea	Copper_PlanePtr+8,a1
	lea	Copper_PlanePtr2+8,a2
	lea	Copper_PlanePtr3,a3
	move.w	d1,6(a0)
	move.w	d1,6(a1)
	move.w	d1,6(a2)
	move.w	d1,6(a3)
	swap	d1
	move.w	d1,2(a0)
	move.w	d1,2(a1)
	move.w	d1,2(a2)
	move.w	d1,2(a3)
	addq.w	#1,FrameNumber
	cmp.w	#10,FrameNumber
	bne.b	.out
	clr.w	FrameNumber
.out	rts

DrawSunAnim:	bsr	DrawOneFrame
	addq.w	#1,FrameNumber
	cmp.w	#10,FrameNumber
	bne.b	DrawSunAnim
	clr.w	FrameNumber
	rts

FrameNumber:	dc.w	0
DrawOneFrame:	lea	Screens,a0
	move.w	FrameNumber(pc),d0
	mulu	#288*44,d0
	add.l	d0,a0
	move.l	a0,Screen

	lea	Cosinus1(pc),a0
	lea	Sinus1(pc),a1
	lea	Cosinus2(pc),a2
	lea	Sinus2(pc),a3
	moveq	#0,d4
	moveq	#5*2,d5
	move.w	FrameNumber(pc),d0
	add.w	d0,d0
	add.w	d0,d4
	add.w	d0,d5

	moveq	#36-1,d7
	moveq	#0,d0
	moveq	#0,d1
	move.w	(a0,d4.w),d0
	move.w	(a1,d4.w),d1
.loop	moveq	#0,d2
	moveq	#0,d3
	move.w	(a2,d5.w),d2
	move.w	(a3,d5.w),d3
	bsr	Sun_Init_Line
	bsr	IncreaseD4
	move.w	(a0,d4.w),d0
	move.w	(a1,d4.w),d1
	bsr	Sun_Init_Line
	bsr	IncreaseD5
	dbra	d7,.loop

	lea	Cosinus3(pc),a0
	lea	Sinus3(pc),a1
	lea	Cosinus4(pc),a2
	lea	Sinus4(pc),a3
	moveq	#0,d4
	moveq	#5*2,d5
	move.w	FrameNumber(pc),d0
	add.w	d0,d0
	sub.w	d0,d4
	sub.w	d0,d5
	tst.w	d4
	bge.b	.d4ok
	add.w	#360*2,d4
.d4ok	tst.w	d5
	bge.b	.d5ok
	add.w	#360*2,d5
.d5ok
	moveq	#36-1,d7
	moveq	#0,d0
	moveq	#0,d1
	move.w	(a0,d4.w),d0
	move.w	(a1,d4.w),d1
.loop2	moveq	#0,d2
	moveq	#0,d3
	move.w	(a2,d5.w),d2
	move.w	(a3,d5.w),d3
	bsr	Sun_Init_Line
	bsr	IncreaseD4
	move.w	(a0,d4.w),d0
	move.w	(a1,d4.w),d1
	bsr	Sun_Init_Line
	bsr	IncreaseD5
	dbra	d7,.loop2

	WaitBlt
	lea	_Custom,a6
	move.l	Screen(pc),d0
	add.l	#288*44-2,d0
	move.l	d0,Bltapth(a6)
	move.l	d0,Bltdpth(a6)
	move.l	#-1,Bltafwm(a6)
	move.l	#$09f00012,Bltcon0(a6)
	move.l	#0,Bltamod(a6)
	move.w	#288<<6+22,Bltsize(a6)

	rts

IncreaseD4:	add.w	#10*2,d4
	cmp.w	#360*2,d4
	blo.b	.d4ok
	sub.w	#360*2,d4
.d4ok	rts

IncreaseD5:	add.w	#10*2,d5
	cmp.w	#360*2,d5
	blo.b	.d5ok
	sub.w	#360*2,d5
.d5ok	rts


Sinus1:	;0,360,360,144,144,w,1,y,n
	DC.W	$0091,$0093,$0096,$0098,$009B,$009D,$00A0,$00A2,$00A5,$00A7
	DC.W	$00AA,$00AC,$00AF,$00B1,$00B4,$00B6,$00B8,$00BB,$00BD,$00C0
	DC.W	$00C2,$00C4,$00C7,$00C9,$00CB,$00CD,$00D0,$00D2,$00D4,$00D6
	DC.W	$00D9,$00DB,$00DD,$00DF,$00E1,$00E3,$00E5,$00E7,$00E9,$00EB
	DC.W	$00ED,$00EF,$00F1,$00F3,$00F4,$00F6,$00F8,$00FA,$00FB,$00FD
	DC.W	$00FF,$0100,$0102,$0103,$0105,$0106,$0108,$0109,$010A,$010C
	DC.W	$010D,$010E,$010F,$0110,$0111,$0113,$0114,$0115,$0115,$0116
	DC.W	$0117,$0118,$0119,$011A,$011A,$011B,$011C,$011C,$011D,$011D
	DC.W	$011E,$011E,$011E,$011F,$011F,$011F,$011F,$011F,$011F,$011F
	DC.W	$011F,$011F,$011F,$011F,$011F,$011F,$011F,$011E,$011E,$011E
	DC.W	$011D,$011D,$011C,$011C,$011B,$011A,$011A,$0119,$0118,$0117
	DC.W	$0116,$0115,$0115,$0114,$0113,$0111,$0110,$010F,$010E,$010D
	DC.W	$010C,$010A,$0109,$0108,$0106,$0105,$0103,$0102,$0100,$00FF
	DC.W	$00FD,$00FB,$00FA,$00F8,$00F6,$00F4,$00F3,$00F1,$00EF,$00ED
	DC.W	$00EB,$00E9,$00E7,$00E5,$00E3,$00E1,$00DF,$00DD,$00DB,$00D9
	DC.W	$00D6,$00D4,$00D2,$00D0,$00CD,$00CB,$00C9,$00C7,$00C4,$00C2
	DC.W	$00C0,$00BD,$00BB,$00B8,$00B6,$00B4,$00B1,$00AF,$00AC,$00AA
	DC.W	$00A7,$00A5,$00A2,$00A0,$009D,$009B,$0098,$0096,$0093,$0091
	DC.W	$008F,$008D,$008A,$0088,$0085,$0083,$0080,$007E,$007B,$0079
	DC.W	$0076,$0074,$0071,$006F,$006C,$006A,$0068,$0065,$0063,$0060
	DC.W	$005E,$005C,$0059,$0057,$0055,$0053,$0050,$004E,$004C,$004A
	DC.W	$0047,$0045,$0043,$0041,$003F,$003D,$003B,$0039,$0037,$0035
	DC.W	$0033,$0031,$002F,$002D,$002C,$002A,$0028,$0026,$0025,$0023
	DC.W	$0021,$0020,$001E,$001D,$001B,$001A,$0018,$0017,$0016,$0014
	DC.W	$0013,$0012,$0011,$0010,$000F,$000D,$000C,$000B,$000B,$000A
	DC.W	$0009,$0008,$0007,$0006,$0006,$0005,$0004,$0004,$0003,$0003
	DC.W	$0002,$0002,$0002,$0001,$0001,$0001,$0001,$0001,$0001,$0001
	DC.W	$0001,$0001,$0001,$0001,$0001,$0001,$0001,$0002,$0002,$0002
	DC.W	$0003,$0003,$0004,$0004,$0005,$0006,$0006,$0007,$0008,$0009
	DC.W	$000A,$000B,$000B,$000C,$000D,$000F,$0010,$0011,$0012,$0013
	DC.W	$0014,$0016,$0017,$0018,$001A,$001B,$001D,$001E,$0020,$0021
	DC.W	$0023,$0025,$0026,$0028,$002A,$002C,$002D,$002F,$0031,$0033
	DC.W	$0035,$0037,$0039,$003B,$003D,$003F,$0041,$0043,$0045,$0047
	DC.W	$004A,$004C,$004E,$0050,$0053,$0055,$0057,$0059,$005C,$005E
	DC.W	$0060,$0063,$0065,$0068,$006A,$006C,$006F,$0071,$0074,$0076
	DC.W	$0079,$007B,$007E,$0080,$0083,$0085,$0088,$008A,$008D,$008F


Cosinus1:	;90,450,360,144,176,w,1,y,n
	DC.W	$013F,$013F,$013F,$013F,$013F,$013F,$013F,$013E,$013E,$013E
	DC.W	$013D,$013D,$013C,$013C,$013B,$013A,$013A,$0139,$0138,$0137
	DC.W	$0136,$0135,$0135,$0134,$0133,$0131,$0130,$012F,$012E,$012D
	DC.W	$012C,$012A,$0129,$0128,$0126,$0125,$0123,$0122,$0120,$011F
	DC.W	$011D,$011B,$011A,$0118,$0116,$0114,$0113,$0111,$010F,$010D
	DC.W	$010B,$0109,$0107,$0105,$0103,$0101,$00FF,$00FD,$00FB,$00F9
	DC.W	$00F6,$00F4,$00F2,$00F0,$00ED,$00EB,$00E9,$00E7,$00E4,$00E2
	DC.W	$00E0,$00DD,$00DB,$00D8,$00D6,$00D4,$00D1,$00CF,$00CC,$00CA
	DC.W	$00C7,$00C5,$00C2,$00C0,$00BD,$00BB,$00B8,$00B6,$00B3,$00B1
	DC.W	$00AF,$00AD,$00AA,$00A8,$00A5,$00A3,$00A0,$009E,$009B,$0099
	DC.W	$0096,$0094,$0091,$008F,$008C,$008A,$0088,$0085,$0083,$0080
	DC.W	$007E,$007C,$0079,$0077,$0075,$0073,$0070,$006E,$006C,$006A
	DC.W	$0067,$0065,$0063,$0061,$005F,$005D,$005B,$0059,$0057,$0055
	DC.W	$0053,$0051,$004F,$004D,$004C,$004A,$0048,$0046,$0045,$0043
	DC.W	$0041,$0040,$003E,$003D,$003B,$003A,$0038,$0037,$0036,$0034
	DC.W	$0033,$0032,$0031,$0030,$002F,$002D,$002C,$002B,$002B,$002A
	DC.W	$0029,$0028,$0027,$0026,$0026,$0025,$0024,$0024,$0023,$0023
	DC.W	$0022,$0022,$0022,$0021,$0021,$0021,$0021,$0021,$0021,$0021
	DC.W	$0021,$0021,$0021,$0021,$0021,$0021,$0021,$0022,$0022,$0022
	DC.W	$0023,$0023,$0024,$0024,$0025,$0026,$0026,$0027,$0028,$0029
	DC.W	$002A,$002B,$002B,$002C,$002D,$002F,$0030,$0031,$0032,$0033
	DC.W	$0034,$0036,$0037,$0038,$003A,$003B,$003D,$003E,$0040,$0041
	DC.W	$0043,$0045,$0046,$0048,$004A,$004C,$004D,$004F,$0051,$0053
	DC.W	$0055,$0057,$0059,$005B,$005D,$005F,$0061,$0063,$0065,$0067
	DC.W	$006A,$006C,$006E,$0070,$0073,$0075,$0077,$0079,$007C,$007E
	DC.W	$0080,$0083,$0085,$0088,$008A,$008C,$008F,$0091,$0094,$0096
	DC.W	$0099,$009B,$009E,$00A0,$00A3,$00A5,$00A8,$00AA,$00AD,$00AF
	DC.W	$00B1,$00B3,$00B6,$00B8,$00BB,$00BD,$00C0,$00C2,$00C5,$00C7
	DC.W	$00CA,$00CC,$00CF,$00D1,$00D4,$00D6,$00D8,$00DB,$00DD,$00E0
	DC.W	$00E2,$00E4,$00E7,$00E9,$00EB,$00ED,$00F0,$00F2,$00F4,$00F6
	DC.W	$00F9,$00FB,$00FD,$00FF,$0101,$0103,$0105,$0107,$0109,$010B
	DC.W	$010D,$010F,$0111,$0113,$0114,$0116,$0118,$011A,$011B,$011D
	DC.W	$011F,$0120,$0122,$0123,$0125,$0126,$0128,$0129,$012A,$012C
	DC.W	$012D,$012E,$012F,$0130,$0131,$0133,$0134,$0135,$0135,$0136
	DC.W	$0137,$0138,$0139,$013A,$013A,$013B,$013C,$013C,$013D,$013D
	DC.W	$013E,$013E,$013E,$013F,$013F,$013F,$013F,$013F,$013F,$013F

Sinus2:	;0,360,360,112,144,w,1,y,n
	DC.W	$0090,$0092,$0094,$0096,$0098,$009A,$009C,$009E,$00A0,$00A2
	DC.W	$00A4,$00A6,$00A8,$00AA,$00AC,$00AD,$00AF,$00B1,$00B3,$00B5
	DC.W	$00B7,$00B9,$00BA,$00BC,$00BE,$00C0,$00C1,$00C3,$00C5,$00C7
	DC.W	$00C8,$00CA,$00CC,$00CD,$00CF,$00D1,$00D2,$00D4,$00D5,$00D7
	DC.W	$00D8,$00DA,$00DB,$00DD,$00DE,$00DF,$00E1,$00E2,$00E3,$00E5
	DC.W	$00E6,$00E7,$00E8,$00EA,$00EB,$00EC,$00ED,$00EE,$00EF,$00F0
	DC.W	$00F1,$00F2,$00F3,$00F4,$00F5,$00F5,$00F6,$00F7,$00F8,$00F8
	DC.W	$00F9,$00FA,$00FA,$00FB,$00FB,$00FC,$00FC,$00FD,$00FD,$00FE
	DC.W	$00FE,$00FE,$00FF,$00FF,$00FF,$00FF,$00FF,$00FF,$00FF,$00FF
	DC.W	$00FF,$00FF,$00FF,$00FF,$00FF,$00FF,$00FF,$00FF,$00FE,$00FE
	DC.W	$00FE,$00FD,$00FD,$00FC,$00FC,$00FB,$00FB,$00FA,$00FA,$00F9
	DC.W	$00F8,$00F8,$00F7,$00F6,$00F5,$00F5,$00F4,$00F3,$00F2,$00F1
	DC.W	$00F0,$00EF,$00EE,$00ED,$00EC,$00EB,$00EA,$00E8,$00E7,$00E6
	DC.W	$00E5,$00E3,$00E2,$00E1,$00DF,$00DE,$00DD,$00DB,$00DA,$00D8
	DC.W	$00D7,$00D5,$00D4,$00D2,$00D1,$00CF,$00CD,$00CC,$00CA,$00C8
	DC.W	$00C7,$00C5,$00C3,$00C1,$00C0,$00BE,$00BC,$00BA,$00B9,$00B7
	DC.W	$00B5,$00B3,$00B1,$00AF,$00AD,$00AC,$00AA,$00A8,$00A6,$00A4
	DC.W	$00A2,$00A0,$009E,$009C,$009A,$0098,$0096,$0094,$0092,$0090
	DC.W	$0090,$008E,$008C,$008A,$0088,$0086,$0084,$0082,$0080,$007E
	DC.W	$007C,$007A,$0078,$0076,$0074,$0073,$0071,$006F,$006D,$006B
	DC.W	$0069,$0067,$0066,$0064,$0062,$0060,$005F,$005D,$005B,$0059
	DC.W	$0058,$0056,$0054,$0053,$0051,$004F,$004E,$004C,$004B,$0049
	DC.W	$0048,$0046,$0045,$0043,$0042,$0041,$003F,$003E,$003D,$003B
	DC.W	$003A,$0039,$0038,$0036,$0035,$0034,$0033,$0032,$0031,$0030
	DC.W	$002F,$002E,$002D,$002C,$002B,$002B,$002A,$0029,$0028,$0028
	DC.W	$0027,$0026,$0026,$0025,$0025,$0024,$0024,$0023,$0023,$0022
	DC.W	$0022,$0022,$0021,$0021,$0021,$0021,$0021,$0021,$0021,$0021
	DC.W	$0021,$0021,$0021,$0021,$0021,$0021,$0021,$0021,$0022,$0022
	DC.W	$0022,$0023,$0023,$0024,$0024,$0025,$0025,$0026,$0026,$0027
	DC.W	$0028,$0028,$0029,$002A,$002B,$002B,$002C,$002D,$002E,$002F
	DC.W	$0030,$0031,$0032,$0033,$0034,$0035,$0036,$0038,$0039,$003A
	DC.W	$003B,$003D,$003E,$003F,$0041,$0042,$0043,$0045,$0046,$0048
	DC.W	$0049,$004B,$004C,$004E,$004F,$0051,$0053,$0054,$0056,$0058
	DC.W	$0059,$005B,$005D,$005F,$0060,$0062,$0064,$0066,$0067,$0069
	DC.W	$006B,$006D,$006F,$0071,$0073,$0074,$0076,$0078,$007A,$007C
	DC.W	$007E,$0080,$0082,$0084,$0086,$0088,$008A,$008C,$008E,$0090


Cosinus2:	;90,450,360,112,176,w,1,y,n
	DC.W	$011F,$011F,$011F,$011F,$011F,$011F,$011F,$011F,$011E,$011E
	DC.W	$011E,$011D,$011D,$011C,$011C,$011B,$011B,$011A,$011A,$0119
	DC.W	$0118,$0118,$0117,$0116,$0115,$0115,$0114,$0113,$0112,$0111
	DC.W	$0110,$010F,$010E,$010D,$010C,$010B,$010A,$0108,$0107,$0106
	DC.W	$0105,$0103,$0102,$0101,$00FF,$00FE,$00FD,$00FB,$00FA,$00F8
	DC.W	$00F7,$00F5,$00F4,$00F2,$00F1,$00EF,$00ED,$00EC,$00EA,$00E8
	DC.W	$00E7,$00E5,$00E3,$00E1,$00E0,$00DE,$00DC,$00DA,$00D9,$00D7
	DC.W	$00D5,$00D3,$00D1,$00CF,$00CD,$00CC,$00CA,$00C8,$00C6,$00C4
	DC.W	$00C2,$00C0,$00BE,$00BC,$00BA,$00B8,$00B6,$00B4,$00B2,$00B0
	DC.W	$00B0,$00AE,$00AC,$00AA,$00A8,$00A6,$00A4,$00A2,$00A0,$009E
	DC.W	$009C,$009A,$0098,$0096,$0094,$0093,$0091,$008F,$008D,$008B
	DC.W	$0089,$0087,$0086,$0084,$0082,$0080,$007F,$007D,$007B,$0079
	DC.W	$0078,$0076,$0074,$0073,$0071,$006F,$006E,$006C,$006B,$0069
	DC.W	$0068,$0066,$0065,$0063,$0062,$0061,$005F,$005E,$005D,$005B
	DC.W	$005A,$0059,$0058,$0056,$0055,$0054,$0053,$0052,$0051,$0050
	DC.W	$004F,$004E,$004D,$004C,$004B,$004B,$004A,$0049,$0048,$0048
	DC.W	$0047,$0046,$0046,$0045,$0045,$0044,$0044,$0043,$0043,$0042
	DC.W	$0042,$0042,$0041,$0041,$0041,$0041,$0041,$0041,$0041,$0041
	DC.W	$0041,$0041,$0041,$0041,$0041,$0041,$0041,$0041,$0042,$0042
	DC.W	$0042,$0043,$0043,$0044,$0044,$0045,$0045,$0046,$0046,$0047
	DC.W	$0048,$0048,$0049,$004A,$004B,$004B,$004C,$004D,$004E,$004F
	DC.W	$0050,$0051,$0052,$0053,$0054,$0055,$0056,$0058,$0059,$005A
	DC.W	$005B,$005D,$005E,$005F,$0061,$0062,$0063,$0065,$0066,$0068
	DC.W	$0069,$006B,$006C,$006E,$006F,$0071,$0073,$0074,$0076,$0078
	DC.W	$0079,$007B,$007D,$007F,$0080,$0082,$0084,$0086,$0087,$0089
	DC.W	$008B,$008D,$008F,$0091,$0093,$0094,$0096,$0098,$009A,$009C
	DC.W	$009E,$00A0,$00A2,$00A4,$00A6,$00A8,$00AA,$00AC,$00AE,$00B0
	DC.W	$00B0,$00B2,$00B4,$00B6,$00B8,$00BA,$00BC,$00BE,$00C0,$00C2
	DC.W	$00C4,$00C6,$00C8,$00CA,$00CC,$00CD,$00CF,$00D1,$00D3,$00D5
	DC.W	$00D7,$00D9,$00DA,$00DC,$00DE,$00E0,$00E1,$00E3,$00E5,$00E7
	DC.W	$00E8,$00EA,$00EC,$00ED,$00EF,$00F1,$00F2,$00F4,$00F5,$00F7
	DC.W	$00F8,$00FA,$00FB,$00FD,$00FE,$00FF,$0101,$0102,$0103,$0105
	DC.W	$0106,$0107,$0108,$010A,$010B,$010C,$010D,$010E,$010F,$0110
	DC.W	$0111,$0112,$0113,$0114,$0115,$0115,$0116,$0117,$0118,$0118
	DC.W	$0119,$011A,$011A,$011B,$011B,$011C,$011C,$011D,$011D,$011E
	DC.W	$011E,$011E,$011F,$011F,$011F,$011F,$011F,$011F,$011F,$011F


Sinus3:	;0,360,360,96,144,w,1,y,n
	DC.W	$0090,$0092,$0094,$0095,$0097,$0099,$009A,$009C,$009E,$009F
	DC.W	$00A1,$00A3,$00A4,$00A6,$00A8,$00A9,$00AB,$00AC,$00AE,$00B0
	DC.W	$00B1,$00B3,$00B4,$00B6,$00B7,$00B9,$00BA,$00BC,$00BD,$00BF
	DC.W	$00C0,$00C2,$00C3,$00C4,$00C6,$00C7,$00C9,$00CA,$00CB,$00CD
	DC.W	$00CE,$00CF,$00D0,$00D2,$00D3,$00D4,$00D5,$00D6,$00D7,$00D8
	DC.W	$00DA,$00DB,$00DC,$00DD,$00DE,$00DF,$00E0,$00E0,$00E1,$00E2
	DC.W	$00E3,$00E4,$00E5,$00E5,$00E6,$00E7,$00E8,$00E8,$00E9,$00E9
	DC.W	$00EA,$00EB,$00EB,$00EC,$00EC,$00EC,$00ED,$00ED,$00EE,$00EE
	DC.W	$00EE,$00EE,$00EF,$00EF,$00EF,$00EF,$00EF,$00EF,$00EF,$00EF
	DC.W	$00EF,$00EF,$00EF,$00EF,$00EF,$00EF,$00EF,$00EF,$00EE,$00EE
	DC.W	$00EE,$00EE,$00ED,$00ED,$00EC,$00EC,$00EC,$00EB,$00EB,$00EA
	DC.W	$00E9,$00E9,$00E8,$00E8,$00E7,$00E6,$00E5,$00E5,$00E4,$00E3
	DC.W	$00E2,$00E1,$00E0,$00E0,$00DF,$00DE,$00DD,$00DC,$00DB,$00DA
	DC.W	$00D8,$00D7,$00D6,$00D5,$00D4,$00D3,$00D2,$00D0,$00CF,$00CE
	DC.W	$00CD,$00CB,$00CA,$00C9,$00C7,$00C6,$00C4,$00C3,$00C2,$00C0
	DC.W	$00BF,$00BD,$00BC,$00BA,$00B9,$00B7,$00B6,$00B4,$00B3,$00B1
	DC.W	$00B0,$00AE,$00AC,$00AB,$00A9,$00A8,$00A6,$00A4,$00A3,$00A1
	DC.W	$009F,$009E,$009C,$009A,$0099,$0097,$0095,$0094,$0092,$0090
	DC.W	$0090,$008E,$008C,$008B,$0089,$0087,$0086,$0084,$0082,$0081
	DC.W	$007F,$007D,$007C,$007A,$0078,$0077,$0075,$0074,$0072,$0070
	DC.W	$006F,$006D,$006C,$006A,$0069,$0067,$0066,$0064,$0063,$0061
	DC.W	$0060,$005E,$005D,$005C,$005A,$0059,$0057,$0056,$0055,$0053
	DC.W	$0052,$0051,$0050,$004E,$004D,$004C,$004B,$004A,$0049,$0048
	DC.W	$0046,$0045,$0044,$0043,$0042,$0041,$0040,$0040,$003F,$003E
	DC.W	$003D,$003C,$003B,$003B,$003A,$0039,$0038,$0038,$0037,$0037
	DC.W	$0036,$0035,$0035,$0034,$0034,$0034,$0033,$0033,$0032,$0032
	DC.W	$0032,$0032,$0031,$0031,$0031,$0031,$0031,$0031,$0031,$0031
	DC.W	$0031,$0031,$0031,$0031,$0031,$0031,$0031,$0031,$0032,$0032
	DC.W	$0032,$0032,$0033,$0033,$0034,$0034,$0034,$0035,$0035,$0036
	DC.W	$0037,$0037,$0038,$0038,$0039,$003A,$003B,$003B,$003C,$003D
	DC.W	$003E,$003F,$0040,$0040,$0041,$0042,$0043,$0044,$0045,$0046
	DC.W	$0047,$0049,$004A,$004B,$004C,$004D,$004E,$0050,$0051,$0052
	DC.W	$0053,$0055,$0056,$0057,$0059,$005A,$005C,$005D,$005E,$0060
	DC.W	$0061,$0063,$0064,$0066,$0067,$0069,$006A,$006C,$006D,$006F
	DC.W	$0070,$0072,$0074,$0075,$0077,$0078,$007A,$007C,$007D,$007F
	DC.W	$0081,$0082,$0084,$0086,$0087,$0089,$008B,$008C,$008E,$0090


Cosinus3:	;90,450,360,96,176,w,1,y,n
	DC.W	$010F,$010F,$010F,$010F,$010F,$010F,$010F,$010F,$010E,$010E
	DC.W	$010E,$010E,$010D,$010D,$010C,$010C,$010C,$010B,$010B,$010A
	DC.W	$0109,$0109,$0108,$0108,$0107,$0106,$0105,$0105,$0104,$0103
	DC.W	$0102,$0101,$0100,$0100,$00FF,$00FE,$00FD,$00FC,$00FB,$00FA
	DC.W	$00F8,$00F7,$00F6,$00F5,$00F4,$00F3,$00F2,$00F0,$00EF,$00EE
	DC.W	$00ED,$00EB,$00EA,$00E9,$00E7,$00E6,$00E4,$00E3,$00E2,$00E0
	DC.W	$00DF,$00DD,$00DC,$00DA,$00D9,$00D7,$00D6,$00D4,$00D3,$00D1
	DC.W	$00D0,$00CE,$00CC,$00CB,$00C9,$00C8,$00C6,$00C4,$00C3,$00C1
	DC.W	$00BF,$00BE,$00BC,$00BA,$00B9,$00B7,$00B5,$00B4,$00B2,$00B0
	DC.W	$00B0,$00AE,$00AC,$00AB,$00A9,$00A7,$00A6,$00A4,$00A2,$00A1
	DC.W	$009F,$009D,$009C,$009A,$0098,$0097,$0095,$0094,$0092,$0090
	DC.W	$008F,$008D,$008C,$008A,$0089,$0087,$0086,$0084,$0083,$0081
	DC.W	$0080,$007E,$007D,$007C,$007A,$0079,$0077,$0076,$0075,$0073
	DC.W	$0072,$0071,$0070,$006E,$006D,$006C,$006B,$006A,$0069,$0068
	DC.W	$0066,$0065,$0064,$0063,$0062,$0061,$0060,$0060,$005F,$005E
	DC.W	$005D,$005C,$005B,$005B,$005A,$0059,$0058,$0058,$0057,$0057
	DC.W	$0056,$0055,$0055,$0054,$0054,$0054,$0053,$0053,$0052,$0052
	DC.W	$0052,$0052,$0051,$0051,$0051,$0051,$0051,$0051,$0051,$0051
	DC.W	$0051,$0051,$0051,$0051,$0051,$0051,$0051,$0051,$0052,$0052
	DC.W	$0052,$0052,$0053,$0053,$0054,$0054,$0054,$0055,$0055,$0056
	DC.W	$0057,$0057,$0058,$0058,$0059,$005A,$005B,$005B,$005C,$005D
	DC.W	$005E,$005F,$0060,$0060,$0061,$0062,$0063,$0064,$0065,$0066
	DC.W	$0067,$0069,$006A,$006B,$006C,$006D,$006E,$0070,$0071,$0072
	DC.W	$0073,$0075,$0076,$0077,$0079,$007A,$007C,$007D,$007E,$0080
	DC.W	$0081,$0083,$0084,$0086,$0087,$0089,$008A,$008C,$008D,$008F
	DC.W	$0090,$0092,$0094,$0095,$0097,$0098,$009A,$009C,$009D,$009F
	DC.W	$00A1,$00A2,$00A4,$00A6,$00A7,$00A9,$00AB,$00AC,$00AE,$00B0
	DC.W	$00B0,$00B2,$00B4,$00B5,$00B7,$00B9,$00BA,$00BC,$00BE,$00BF
	DC.W	$00C1,$00C3,$00C4,$00C6,$00C8,$00C9,$00CB,$00CC,$00CE,$00D0
	DC.W	$00D1,$00D3,$00D4,$00D6,$00D7,$00D9,$00DA,$00DC,$00DD,$00DF
	DC.W	$00E0,$00E2,$00E3,$00E4,$00E6,$00E7,$00E9,$00EA,$00EB,$00ED
	DC.W	$00EE,$00EF,$00F0,$00F2,$00F3,$00F4,$00F5,$00F6,$00F7,$00F8
	DC.W	$00FA,$00FB,$00FC,$00FD,$00FE,$00FF,$0100,$0100,$0101,$0102
	DC.W	$0103,$0104,$0105,$0105,$0106,$0107,$0108,$0108,$0109,$0109
	DC.W	$010A,$010B,$010B,$010C,$010C,$010C,$010D,$010D,$010E,$010E
	DC.W	$010E,$010E,$010F,$010F,$010F,$010F,$010F,$010F,$010F,$010F


Sinus4:	;0,360,64,144,w,1,y,n
	DC.W	$0090,$0091,$0092,$0093,$0095,$0096,$0097,$0098,$0099,$009A
	DC.W	$009B,$009C,$009D,$009E,$00A0,$00A1,$00A2,$00A3,$00A4,$00A5
	DC.W	$00A6,$00A7,$00A8,$00A9,$00AA,$00AB,$00AC,$00AD,$00AE,$00AF
	DC.W	$00B0,$00B1,$00B2,$00B3,$00B4,$00B5,$00B6,$00B6,$00B7,$00B8
	DC.W	$00B9,$00BA,$00BB,$00BC,$00BC,$00BD,$00BE,$00BF,$00BF,$00C0
	DC.W	$00C1,$00C2,$00C2,$00C3,$00C4,$00C4,$00C5,$00C5,$00C6,$00C7
	DC.W	$00C7,$00C8,$00C8,$00C9,$00C9,$00CA,$00CA,$00CB,$00CB,$00CB
	DC.W	$00CC,$00CC,$00CD,$00CD,$00CD,$00CD,$00CE,$00CE,$00CE,$00CE
	DC.W	$00CF,$00CF,$00CF,$00CF,$00CF,$00CF,$00CF,$00CF,$00CF,$00CF
	DC.W	$00CF,$00CF,$00CF,$00CF,$00CF,$00CF,$00CF,$00CF,$00CF,$00CF
	DC.W	$00CE,$00CE,$00CE,$00CE,$00CD,$00CD,$00CD,$00CD,$00CC,$00CC
	DC.W	$00CB,$00CB,$00CB,$00CA,$00CA,$00C9,$00C9,$00C8,$00C8,$00C7
	DC.W	$00C7,$00C6,$00C5,$00C5,$00C4,$00C4,$00C3,$00C2,$00C2,$00C1
	DC.W	$00C0,$00BF,$00BF,$00BE,$00BD,$00BC,$00BC,$00BB,$00BA,$00B9
	DC.W	$00B8,$00B7,$00B6,$00B6,$00B5,$00B4,$00B3,$00B2,$00B1,$00B0
	DC.W	$00AF,$00AE,$00AD,$00AC,$00AB,$00AA,$00A9,$00A8,$00A7,$00A6
	DC.W	$00A5,$00A4,$00A3,$00A2,$00A1,$00A0,$009E,$009D,$009C,$009B
	DC.W	$009A,$0099,$0098,$0097,$0096,$0095,$0093,$0092,$0091,$0090
	DC.W	$0090,$008F,$008E,$008D,$008B,$008A,$0089,$0088,$0087,$0086
	DC.W	$0085,$0084,$0083,$0082,$0080,$007F,$007E,$007D,$007C,$007B
	DC.W	$007A,$0079,$0078,$0077,$0076,$0075,$0074,$0073,$0072,$0071
	DC.W	$0070,$006F,$006E,$006D,$006C,$006B,$006A,$006A,$0069,$0068
	DC.W	$0067,$0066,$0065,$0064,$0064,$0063,$0062,$0061,$0061,$0060
	DC.W	$005F,$005E,$005E,$005D,$005C,$005C,$005B,$005B,$005A,$0059
	DC.W	$0059,$0058,$0058,$0057,$0057,$0056,$0056,$0055,$0055,$0055
	DC.W	$0054,$0054,$0053,$0053,$0053,$0053,$0052,$0052,$0052,$0052
	DC.W	$0051,$0051,$0051,$0051,$0051,$0051,$0051,$0051,$0051,$0051
	DC.W	$0051,$0051,$0051,$0051,$0051,$0051,$0051,$0051,$0051,$0051
	DC.W	$0052,$0052,$0052,$0052,$0053,$0053,$0053,$0053,$0054,$0054
	DC.W	$0055,$0055,$0055,$0056,$0056,$0057,$0057,$0058,$0058,$0059
	DC.W	$0059,$005A,$005B,$005B,$005C,$005C,$005D,$005E,$005E,$005F
	DC.W	$0060,$0061,$0061,$0062,$0063,$0064,$0064,$0065,$0066,$0067
	DC.W	$0068,$0069,$006A,$006A,$006B,$006C,$006D,$006E,$006F,$0070
	DC.W	$0071,$0072,$0073,$0074,$0075,$0076,$0077,$0078,$0079,$007A
	DC.W	$007B,$007C,$007D,$007E,$007F,$0080,$0082,$0083,$0084,$0085
	DC.W	$0086,$0087,$0088,$0089,$008A,$008B,$008D,$008E,$008F,$0090


Cosinus4:	;90,450,360,64,176,w,1,y,n
	DC.W	$00EF,$00EF,$00EF,$00EF,$00EF,$00EF,$00EF,$00EF,$00EF,$00EF
	DC.W	$00EE,$00EE,$00EE,$00EE,$00ED,$00ED,$00ED,$00ED,$00EC,$00EC
	DC.W	$00EB,$00EB,$00EB,$00EA,$00EA,$00E9,$00E9,$00E8,$00E8,$00E7
	DC.W	$00E7,$00E6,$00E5,$00E5,$00E4,$00E4,$00E3,$00E2,$00E2,$00E1
	DC.W	$00E0,$00DF,$00DF,$00DE,$00DD,$00DC,$00DC,$00DB,$00DA,$00D9
	DC.W	$00D8,$00D7,$00D6,$00D6,$00D5,$00D4,$00D3,$00D2,$00D1,$00D0
	DC.W	$00CF,$00CE,$00CD,$00CC,$00CB,$00CA,$00C9,$00C8,$00C7,$00C6
	DC.W	$00C5,$00C4,$00C3,$00C2,$00C1,$00C0,$00BE,$00BD,$00BC,$00BB
	DC.W	$00BA,$00B9,$00B8,$00B7,$00B6,$00B5,$00B3,$00B2,$00B1,$00B0
	DC.W	$00B0,$00AF,$00AE,$00AD,$00AB,$00AA,$00A9,$00A8,$00A7,$00A6
	DC.W	$00A5,$00A4,$00A3,$00A2,$00A0,$009F,$009E,$009D,$009C,$009B
	DC.W	$009A,$0099,$0098,$0097,$0096,$0095,$0094,$0093,$0092,$0091
	DC.W	$0090,$008F,$008E,$008D,$008C,$008B,$008A,$008A,$0089,$0088
	DC.W	$0087,$0086,$0085,$0084,$0084,$0083,$0082,$0081,$0081,$0080
	DC.W	$007F,$007E,$007E,$007D,$007C,$007C,$007B,$007B,$007A,$0079
	DC.W	$0079,$0078,$0078,$0077,$0077,$0076,$0076,$0075,$0075,$0075
	DC.W	$0074,$0074,$0073,$0073,$0073,$0073,$0072,$0072,$0072,$0072
	DC.W	$0071,$0071,$0071,$0071,$0071,$0071,$0071,$0071,$0071,$0071
	DC.W	$0071,$0071,$0071,$0071,$0071,$0071,$0071,$0071,$0071,$0071
	DC.W	$0072,$0072,$0072,$0072,$0073,$0073,$0073,$0073,$0074,$0074
	DC.W	$0075,$0075,$0075,$0076,$0076,$0077,$0077,$0078,$0078,$0079
	DC.W	$0079,$007A,$007B,$007B,$007C,$007C,$007D,$007E,$007E,$007F
	DC.W	$0080,$0081,$0081,$0082,$0083,$0084,$0084,$0085,$0086,$0087
	DC.W	$0088,$0089,$008A,$008A,$008B,$008C,$008D,$008E,$008F,$0090
	DC.W	$0091,$0092,$0093,$0094,$0095,$0096,$0097,$0098,$0099,$009A
	DC.W	$009B,$009C,$009D,$009E,$009F,$00A0,$00A2,$00A3,$00A4,$00A5
	DC.W	$00A6,$00A7,$00A8,$00A9,$00AA,$00AB,$00AD,$00AE,$00AF,$00B0
	DC.W	$00B0,$00B1,$00B2,$00B3,$00B5,$00B6,$00B7,$00B8,$00B9,$00BA
	DC.W	$00BB,$00BC,$00BD,$00BE,$00C0,$00C1,$00C2,$00C3,$00C4,$00C5
	DC.W	$00C6,$00C7,$00C8,$00C9,$00CA,$00CB,$00CC,$00CD,$00CE,$00CF
	DC.W	$00D0,$00D1,$00D2,$00D3,$00D4,$00D5,$00D6,$00D6,$00D7,$00D8
	DC.W	$00D9,$00DA,$00DB,$00DC,$00DC,$00DD,$00DE,$00DF,$00DF,$00E0
	DC.W	$00E1,$00E2,$00E2,$00E3,$00E4,$00E4,$00E5,$00E5,$00E6,$00E7
	DC.W	$00E7,$00E8,$00E8,$00E9,$00E9,$00EA,$00EA,$00EB,$00EB,$00EB
	DC.W	$00EC,$00EC,$00ED,$00ED,$00ED,$00ED,$00EE,$00EE,$00EE,$00EE
	DC.W	$00EF,$00EF,$00EF,$00EF,$00EF,$00EF,$00EF,$00EF,$00EF,$00EF







*******************************************************************************
**Line routine
**regs used: d0-d5/a0/a6
*******************************************************************************
ScreenWidth:	EQU	44

Sun_Init_Line:	Push.l	d0-a6
	lea	_Custom,a6
	WaitBlt
	move.w	#ScreenWidth,Bltcmod(a6)
	move.l	#-$8000,Bltbdat(a6)
	move.l	#-1,Bltafwm(a6)
	move.l	Screen(pc),a0

	cmp.w	d1,d3
	bgt.s	.line1
	exg	d0,d2
	exg	d1,d3
	beq.w	.out
.line1	move.w	d1,d4
	muls	#ScreenWidth,d4
	moveq	#0,d5
	move.w	d0,d5
	add.l	a0,d4
	asr.l	#4,d5
	add.l	d5,d5
	add.l	d5,d4
	moveq	#0,d5
	sub.w	d1,d3
	sub.w	d0,d2
	bpl.s	.line2
	moveq	#1,d5
	neg.w	d2
.line2	move.w	d3,d1
	add.w	d1,d1
	cmp.w	d2,d1
	dbhi	d3,.line3
.line3	move.w	d3,d1
	sub.w	d2,d1
	bpl.s	.line4
	exg	d2,d3
.line4	addx.w	d5,d5
	add.w	d2,d2
	move.w	d2,d1
	sub.w	d3,d2
	addx.w	d5,d5
	and.w	#15,d0
	ror.w	#4,d0
	or.w	#$a4a,d0
	WaitBlt
	move.w	d2,Bltaptl(a6)
	sub.w	d3,d2
	lsl.w	#6,d3
	addq.w	#2,d3
	move.w	d0,Bltcon0(a6)
	move.b	Sun_Octants(pc,d5.w),Bltcon1+1(a6)
	move.l	d4,Bltcpth(a6)
	move.l	d4,Bltdpth(a6)
	movem.w	d1/d2,Bltbmod(a6)
	move.w	d3,Bltsize(a6)
.out	WaitBlt
	Pull.l	d0-a6
	rts

Sun_Octants:	dc.b	$03,$43,$13,$53,$0b,$4b,$17,$57






*******************************************************************************
**Og den vildeste copperliste...
*******************************************************************************
	SECTION	Copper,data_c
SunCopper:	dc.w	$1001,$fffe

	dc.w	Diwstrt,$1c71
	dc.w	Bplcon0,$1200
	dc.w	Bplcon2,$0024
	dc.w	Bplcon3,$0c40
	dc.w	Diwstop,$3cd1
	dc.w	Ddfstrt,$0030
	dc.w	Ddfstop,$00d8
	dc.w	Bplcon1,$0000
	dc.w	Bpl1mod,0
	dc.w	Bpl2mod,0

	dc.w	Spr0pth,0,Spr0ptl,0
	dc.w	Spr1pth,0,Spr1ptl,0
	dc.w	Spr2pth,0,Spr2ptl,0
	dc.w	Spr3pth,0,Spr3ptl,0
	dc.w	Spr4pth,0,Spr4ptl,0
	dc.w	Spr5pth,0,Spr5ptl,0
	dc.w	Spr6pth,0,Spr6ptl,0
	dc.w	Spr7pth,0,Spr7ptl,0

Copper_PlanePtr3:	dc.w	Bpl1pth,0,Bpl1ptl,0

	dc.w	$106,$0c40

FadeCopper:	dc.w	Color00,$000	;000
	dc.w	Color01,$000	;001

	IFEQ	AGA-1
	dc.w	$106,$0e40

	dc.w	Color00,$000	;000
	dc.w	Color01,$000	;001
	ENDC

	dc.l	-2
	dc.l	-2



BlackCopper:	dc.w	$1001,$fffe

	dc.w	Diwstrt,$1c71
	dc.w	Bplcon0,$2200
	dc.w	Bplcon2,$0024
	dc.w	Bplcon3,$0c40
	dc.w	Diwstop,$3cd1
	dc.w	Ddfstrt,$0030
	dc.w	Ddfstop,$00d8
	dc.w	Bplcon1,$0000
	dc.w	Bpl1mod,0
	dc.w	Bpl2mod,0

	dc.w	Spr0pth,0,Spr0ptl,0
	dc.w	Spr1pth,0,Spr1ptl,0
	dc.w	Spr2pth,0,Spr2ptl,0
	dc.w	Spr3pth,0,Spr3ptl,0
	dc.w	Spr4pth,0,Spr4ptl,0
	dc.w	Spr5pth,0,Spr5ptl,0
	dc.w	Spr6pth,0,Spr6ptl,0
	dc.w	Spr7pth,0,Spr7ptl,0

Copper_PlanePtr2:	dc.w	Bpl1pth,0,Bpl1ptl,0
	dc.w	Bpl2pth,0,Bpl2ptl,0

	dc.w	$106,$0c40

	dc.w	Color00,BckCol	;000
	dc.w	Color01,$fff	;001
	dc.w	Color02,TandCol	;010
	dc.w	Color03,$fff	;011

	IFEQ	AGA-1
	dc.w	$106,$0e40

	dc.w	Color00,$000	;000
	dc.w	Color01,$000	;001
	dc.w	Color02,$000	;010
	dc.w	Color03,$000	;011
	ENDC

	dc.l	-2
	dc.l	-2



Copper:	dc.w	$1001,$fffe

	dc.w	Diwstrt,$1c71
	dc.w	Diwstop,$3cd1
	dc.w	Ddfstrt,$0030
	dc.w	Ddfstop,$00d8

	dc.w	Spr0pth,$0000,Spr0ptl,$0000
	dc.w	Spr1pth,$0000,Spr1ptl,$0000
	dc.w	Spr2pth,$0000,Spr2ptl,$0000
	dc.w	Spr3pth,$0000,Spr3ptl,$0000
	dc.w	Spr4pth,$0000,Spr4ptl,$0000
	dc.w	Spr5pth,$0000,Spr5ptl,$0000
	dc.w	Spr6pth,$0000,Spr6ptl,$0000
	dc.w	Spr7pth,$0000,Spr7ptl,$0000

	dc.w	Bpl1mod,ByteWidth-44,Bpl2mod,0

	dc.w	$106,$0c40

CopColors:	dc.w	Color00,BckCol	;000
	dc.w	Color01,BckCol	;001
	dc.w	Color02,TandCol	;010
	dc.w	Color03,TandCol	;011
	dc.w	Color04,BckCol	;100
	dc.w	Color05,BckCol	;101
	dc.w	Color06,TandCol	;110
	dc.w	Color07,TandCol	;111

	dc.w	Color08,$fff,Color09,$fff,Color10,$fff,Color11,$fff
	dc.w	Color12,$fff,Color13,$fff,Color14,$fff,Color15,$fff

	IFEQ	AGA-1

	dc.w	$106,$0e40

CopColorsAga:	dc.w	Color00,$000	;000
	dc.w	Color01,$000	;001
	dc.w	Color02,$000	;010
	dc.w	Color03,$000	;011
	dc.w	Color04,$000	;100
	dc.w	Color05,$000	;101
	dc.w	Color06,$000	;110
	dc.w	Color07,$000	;111

	dc.w	Color08,0,Color09,0,Color10,0,Color11,0
	dc.w	Color12,0,Color13,0,Color14,0,Color15,0

	ENDC


Bitplaner:	dc.w	Bpl2pth,0
	dc.w	Bpl2ptl,0
	dc.w	Bpl1pth,0
	dc.w	Bpl1ptl,0
	dc.w	Bpl3pth,0
	dc.w	Bpl3ptl,0

TextPlan:	dc.w	Bpl4pth,0
	dc.w	Bpl4ptl,0

	dc.w	Bplcon0,$4200
	dc.w	Bplcon1,$0000
	dc.w	Bplcon2,$0024

	dc.w	$106,$0e40

Bltpointer:	dc.w	Cop2lch,0
	dc.w	Cop2lcl,0
	dc.w	Copjmp2,$1992







WriterCopper:	dc.w	$1001,$fffe
	dc.w	Bplcon0,$0201
	dc.w	Bplcon1,$0000
	dc.w	Bplcon2,$0024
	dc.w	Bplcon3,$0c40

	dc.w	Spr0pth,0,Spr0ptl,0
	dc.w	Spr1pth,0,Spr1ptl,0
	dc.w	Spr2pth,0,Spr2ptl,0
	dc.w	Spr3pth,0,Spr3ptl,0
	dc.w	Spr4pth,0,Spr4ptl,0
	dc.w	Spr5pth,0,Spr5ptl,0
	dc.w	Spr6pth,0,Spr6ptl,0
	dc.w	Spr7pth,0,Spr7ptl,0

	dc.w	$106,$0c40

	dc.w	Color00,BckCol
	dc.w	Color01,$fff
	dc.w	Color02,TandCol
	dc.w	Color03,$fff

	IFEQ	AGA-1

	dc.w	$106,$0e40

	dc.w	Color00,$000	;000
	dc.w	Color01,$000	;001
	dc.w	Color02,$000	;010
	dc.w	Color03,$000	;011

	ENDC

Copper_PlanePtr:	dc.w	Bpl1pth,0,Bpl1ptl,0
	dc.w	Bpl2pth,0,Bpl2ptl,0

	dc.w	Diwstrt,$1c71
	dc.w	Bplcon0,$2200
	dc.w	Bplcon2,$0024
	dc.w	Bplcon3,$0c40
	dc.w	Diwstop,$3cd1
	dc.w	Ddfstrt,$0030
	dc.w	Ddfstop,$00d8
	dc.w	Bplcon1,$0000
	dc.w	Bpl1mod,88-44
	dc.w	Bpl2mod,0

	dc.w	$0001,$7ffe		;WaitBlt
CopBlit1:	dc.w	Bltdpth,0,Bltdptl,0
	dc.w	Bltcon0,$0100,Bltcon1,$0000
	dc.w	Bltdmod,88-44
	dc.w	Bltsize,288<<6!22

	dc.w	$0001,$7ffe		;WaitBlt
	dc.w	Bltcon1,$0000
	dc.w	Bltamod,-2
	dc.w	Bltcmod,88-46
	dc.w	Bltdmod,88-46
	dc.w	Bltafwm,-1
	dc.w	Bltalwm,0

BlitCopPtr:	dc.w	Cop2lch,0
	dc.w	Cop2lcl,0
	dc.w	Copjmp2,0

	dc.l	-2
	dc.l	-2


*******************************************************************************
**Screens+Gfx
*******************************************************************************
	INCDIR	Work:Code/Sources/HTSAC/PlaneWriter/
PlaneFont:	INCBIN	Planefont.raw

	SECTION	Gfx,bss_c
Clear:
FontScreen:	ds.b	288*44
Screen1:	ds.b	288*88
Screen2:	ds.b	288*88

Tand_Screen1:	EQU	Screen1
Tand_Screen2:	EQU	Tand_Screen1+288*44*2

BltCopper1:	ds.l	9*240+3
BltCopper2:	ds.l	9*240+3

Screens:	ds.b	44*288*10

TheEnd:

	SECTION	Other,bss

Muls80Tab:	ds.w	288
MegaMulsTable:	ds.w	64*2*256
BltPtr:	ds.l	1






	IF	Track=0
	PRINTT	`ASM-ONE VERSION`
	ELSE
	PRINTT	`TRACK VERSION`
	ENDC
	PRINTT

*******************************************************************************
**Hardware registers
*******************************************************************************
Bltddat=$000
Dmaconr=$002
Vposr=$004
Vhposr=$006
Dskdatr=$008
Joy0dat=$00a
Joy1dat=$00c
Clxdat=$00e
Adkconr=$010
Pot0dat=$012
Pot1dat=$014
Potgor=$016
Serdatr=$018
Dskbytr=$01a
Intenar=$01c
Intreqr=$01e
Dskpth=$020
Dskptl=$022
Dsklen=$024
Dskdat=$026
Refptr=$028
Vposw=$02a
Vhposw=$02c
Copcon=$02e
Serdat=$030
Serper=$032
Potgo=$034
Joytest=$036
Strequ=$038
Strvbl=$03a
Strhor=$03c
Strlong=$03e
Bltcon0=$040
Bltcon1=$042
Bltafwm=$044
Bltalwm=$046
Bltcpth=$048
Bltcptl=$04a
Bltbpth=$04c
Bltbptl=$04e
Bltapth=$050
Bltaptl=$052
Bltdpth=$054
Bltdptl=$056
Bltsize=$058
Bltcmod=$060
Bltbmod=$062
Bltamod=$064
Bltdmod=$066
Bltcdat=$070
Bltbdat=$072
Bltadat=$074
Dsksync=$07e
Cop1lch=$080
Cop1lcl=$082
Cop2lch=$084
Cop2lcl=$086
Copjmp1=$088
Copjmp2=$08a
Copins=$08c
Diwstrt=$08e
Diwstop=$090
Ddfstrt=$092
Ddfstop=$094
Dmacon=$096
Clxcon=$98
Intena=$09a
Intreq=$09c
Adkcon=$09e
Aud0dat=$0aa
Aud1dat=$0ba
Aud2dat=$0ca
Aud3dat=$0da
Aud0lch=$0a0
Aud1lch=$0b0
Aud2lch=$0c0
Aud3lch=$0d0
Aud0len=$0a4
Aud1len=$0b4
Aud2len=$0c4
Aud3len=$0d4
Aud0per=$0a6
Aud1per=$0b6
Aud2per=$0c6
Aud3per=$0d6
Aud0vol=$0a8
Aud1vol=$0b8
Aud2vol=$0c8
Aud3vol=$0d8
Aud0lcl=$0a2
Aud1lcl=$0b2
Aud2lcl=$0c2
Aud3lcl=$0d2
Bpl1pth=$0e0
Bpl1ptl=$0e2
Bpl2pth=$0e4
Bpl2ptl=$0e6
Bpl3pth=$0e8
Bpl3ptl=$0ea
Bpl4pth=$0ec
Bpl4ptl=$0ee
Bpl5pth=$0f0
Bpl5ptl=$0f2
Bpl6pth=$0f4
Bpl6ptl=$0f6
Bplcon0=$100
Bplcon1=$102
Bplcon2=$104
Bplcon3=$106
Bpl1mod=$108
Bpl2mod=$10a
Bpl1dat=$110
Bpl2dat=$112
Bpl3dat=$114
Bpl4dat=$116
Bpl5dat=$118
Bpl6dat=$11a
Spr0pth=$120
Spr0ptl=$122
Spr1pth=$124
Spr1ptl=$126
Spr2pth=$128
Spr2ptl=$12a
Spr3pth=$12c
Spr3ptl=$12e
Spr4pth=$130
Spr4ptl=$132
Spr5pth=$134
Spr5ptl=$136
Spr6pth=$138
Spr6ptl=$13a
Spr7pth=$13c
Spr7ptl=$13e
Spr0pos=$140
Spr0ctl=$142
Spr0data=$144
Spr0datb=$146
Spr1pos=$148
Spr1ctl=$14a
Spr1data=$14c
Spr1datb=$14e
Spr2pos=$150
Spr2ctl=$152
Spr2data=$154
Spr2datb=$156
Spr3pos=$158
Spr3ctl=$15a
Spr3data=$15c
Spr3datb=$15e
Spr4pos=$160
Spr4ctl=$162
Spr4data=$164
Spr4datb=$166
Spr5pos=$168
Spr5ctl=$16a
Spr5data=$16c
Spr5datb=$16e
Spr6pos=$170
Spr6ctl=$172
Spr6data=$174
Spr6datb=$176
Spr7pos=$178
Spr7ctl=$17a
Spr7data=$17c
Spr7datb=$17e
Color00=$180
Color01=$182
Color02=$184
Color03=$186
Color04=$188
Color05=$18a
Color06=$18c
Color07=$18e
Color08=$190
Color09=$192
Color10=$194
Color11=$196
Color12=$198
Color13=$19a
Color14=$19c
Color15=$19e
Color16=$1a0
Color17=$1a2
Color18=$1a4
Color19=$1a6
Color20=$1a8
Color21=$1aa
Color22=$1ac
Color23=$1ae
Color24=$1b0
Color25=$1b2
Color26=$1b4
Color27=$1b6
Color28=$1b8
Color29=$1ba
Color30=$1bc
Color31=$1be
_Custom=$dff000

*******************************************************************************
**Interrupt addresses
*******************************************************************************
Lev1Base=$64
Lev2Base=$68
Lev3Base=$6c
Lev4Base=$70
Lev5Base=$74
Lev6Base=$78
Lev7Base=$7c
Trap0=$80

