    ?;------------------T--------T------------------T
Track:	EQU	0
Raster:	EQU	0


MyDmacon=%01111100000
;         abcdefghhhh
; a = Blitter nasty
; b = Enable DMA activity (always set this!)
; c = Bitplane enable
; d = Copper enable
; e = Blitter enable
; f = Sprite enable
; g = Disk enable
; h = Audio channels enable

MyIntena=%100000000100000
;         abcdeeeefghijkl
; a = Enable interrupts
; b = Lev. 6 External interrupt
; c = Lev. 5 Disk sync found
; d = Lev. 5 Serial port receive buffer full
; e = Lev. 4 Audio ch. 3-0 block finished
; f = Lev. 3 Blitter finished
; g = Lev. 3 Vertical blank
; h = Lev. 3 Copper
; i = Lev. 2 I/O Ports and timers
; j = Lev. 1 Software
; k = Lev. 1 Disk block finished
; l = Lev. 1 Serial port transmit buffer empty

	JumpPtr	Begin

*******************************************************************************
**Macros
*******************************************************************************
WaitBlt:	MACRO
.vent\@:	if	Raster=1
	move.w	#$fff,Color00+_Custom
	endif
	btst	#14,Dmaconr+_Custom
	bne.b	.vent\@
	if	Raster=1
	move.w	#0,Color00+_Custom
	endif
	ENDM

SetInt:	MACRO
	move.l	(Lev\1Vec).w,OldIrq\1
	move.l	#Lev\1Irq,(Lev\1Vec).w
	bra.b	jumpo\@
OldIrq\1:	dc.l	0
jumpo\@:
	ENDM

ClrInt:	MACRO
	move.l	OldIrq\1(pc),(Lev\1Vec).w
	ENDM

Push.l:	MACRO
	movem.l	\1,-(sp)
	ENDM

Push.w:	MACRO
	movem.w	\1,-(sp)
	ENDM

Pull.l:	MACRO
	movem.l	(sp)+,\1
	ENDM

Pull.w:	MACRO
	movem.w	(sp)+,\1
	ENDM

StartPrg:	MACRO
	move.w	#$7fff,Intreq+_Custom
	move.w	#MyDmacon+$8000,Dmacon+_Custom
	move.w	#MyIntena+$8000,Intena+_Custom
	ENDM

StopPrg:	MACRO
	move.w	#$7fff,Intena+_Custom
	move.w	#$7fff,Dmacon+_Custom
	move.w	#$7fff,Intreq+_Custom
	ENDM

StopSystem:	MACRO
	move.w	Intenar+_Custom,OldIntena
	move.w	Dmaconr+_Custom,OldDmacon
	StopPrg
	bra.b	jumpo\@
OldIntena:	dc.w	0
OldDmacon:	dc.w	0
jumpo\@:
	ENDM

StartSystem:	MACRO
	move.w	OldDmacon(pc),d0
	or.w	#$8000,d0
	move.w	d0,Dmacon+_Custom
	move.w	OldIntena(pc),d0
	or.w	#$8000,d0
	move.w	d0,Intena+_Custom
	ENDM

ClearBss:	MACRO
	lea	_Bss\1Start,a0
	move.l	#(_Bss\1End-_Bss\1Start)/4,d0
.clrloop\@	clr.l	(a0)+
	subq.l	#1,d0
	bne.b	.clrloop\@
	ENDM




*******************************************************************************
**
**  Initialisering
**
*******************************************************************************
	SECTION	DenFedeKode,code

Begin:	IFEQ	Track-0
	Push.l	d0-a6
	StopSystem
	ELSE
	move.l	#Lev3Irq,$64.w
	rts
	ENDC

**Init starter -----------------------------------
	ClearBss	1
	ClearBss	2

	bsr	InitMegaMulsTable

	lea	Muls80Tab,a0
	moveq	#0,d0
.loop	move.w	d0,(a0)+
	add.w	#80,d0
	cmp.w	#80*256,d0
	bne.b	.loop

	lea	BltCopper1,a0
	lea	BltCopper2,a1
	move.w	#256-1,d7
.bltloop	move.l	#$00017ffe,(a0)+
	move.l	#$00017ffe,(a1)+
	move.l	#Bltcpth<<16,(a0)+
	move.l	#Bltcpth<<16,(a1)+
	move.l	#Bltcptl<<16,(a0)+
	move.l	#Bltcptl<<16,(a1)+
	move.l	#Bltdpth<<16,(a0)+
	move.l	#Bltdpth<<16,(a1)+
	move.l	#Bltdptl<<16,(a0)+
	move.l	#Bltdptl<<16,(a1)+
	move.l	#Bltapth<<16,(a0)+
	move.l	#Bltapth<<16,(a1)+
	move.l	#Bltaptl<<16,(a0)+
	move.l	#Bltaptl<<16,(a1)+
	move.l	#Bltcon0<<16!$0BFA,(a0)+
	move.l	#Bltcon0<<16!$0BFA,(a1)+
	move.l	#Bltsize<<16!(1<<6!21),(a0)+
	move.l	#Bltsize<<16!(1<<6!21),(a1)+
	dbra	d7,.bltloop
	move.l	#Cop2lch<<16,(a0)+
	move.l	#Cop2lch<<16,(a1)+
	move.l	#Cop2lcl<<16,(a0)+
	move.l	#Cop2lcl<<16,(a1)+
	move.l	#-2,(a0)+
	move.l	#-2,(a1)+

	bsr.w	TypeScreen
	bsr.w	SwapScr
	bsr.w	ClrScr
	bsr.w	CopyWriter

	IFEQ	Track-0
	clr.l	0.w
	SetInt	3
**Init slutter -----------------------------------
	WaitBlt
	StartPrg



*******************************************************************************
**
**  Vent p exitsignal
**
*******************************************************************************
WaitForExit:	tst.b	VBlank
	beq.b	WaitForExit

	clr.b	VBlank
	tst.b	IWantOut
	bne.b	ExitToDos
	bra.b	WaitForExit




*******************************************************************************
**
**  Exit to AmigaDOS
**
*******************************************************************************
ExitToDos:
	StopPrg

**Exit starter -----------------------------------
	move.w	#0,Copcon+_Custom
	ClrInt	3
**Exit slutter -----------------------------------

	StartSystem

	Pull.l	d0-a6
	moveq	#0,d0
	ENDC
	rts



*******************************************************************************
**
**  Level 3 interrupt
**
*******************************************************************************
Lev3Irq:	st	VBlank
	Push.l	d0-a6
**Lev3irq starter --------------------------------
	move.l	#Copper,Cop2lch+_Custom
	move.w	#%10,Copcon+_Custom
	move.w	d0,Copjmp2+_Custom

	bsr.w	SwapScr
	bsr.w	ClrScr
	bsr.w	CopyWriter
	bsr	StoryBoard
**Lev3irq slutter --------------------------------
;	btst	#6,$bfe001
;	seq	IWantOut
	IF	Raster=1
	move.w	#$f00,Color00+_Custom
	ENDIF
	IF	Raster=1
	move.w	#$00f,Color00+_Custom
	ENDIF
	move.b	$dff005,d0
	lsl.w	#8,d0
	move.b	$dff006,d0
	cmp.w	MaxRast,d0
	blt.b	.ud
	move.w	d0,MaxRast
.ud:
	Pull.l	d0-a6
	IFEQ	Track-0
	move.w	#$0020,Intreq+_Custom
	ELSE
	move.w	#$0004,Intreq+_Custom
	ENDC
	rte


*******************************************************************************
**
**  Storyboard
**
*******************************************************************************
Story:	dc.w	0
Story_Pause:	dc.w	0
StoryBoard:	move.w	Story(pc),d0
	beq.b	Story_In
	subq.w	#1,d0
	beq.b	Story_Wait
	subq.w	#1,d0
	beq.b	Story_Out
	st	IWantOut
	rts

Story_In:	addq.w	#1,Writer_FaderPtr
	cmp.w	#255,Writer_FaderPtr
	bne.b	.ok
	addq.w	#1,Story
	move.w	#50*6,Story_Pause
.ok	rts

Story_Wait:	subq.w	#1,Story_Pause
	bne.b	.out
	addq.w	#1,Story
.out	rts

Story_Out:	subq.w	#1,Writer_FaderPtr
	bne.b	.ok
	addq.w	#1,Story
.ok	rts


*******************************************************************************
**
**  Copy Writer
**
*******************************************************************************
CopyWriter:	move.l	BltPtr,a0
	addq.w	#4+2,a0
	lea	FontScreen,a1
	move.l	Screen_Clear,a2
	moveq	#0,d0
	move.w	Writer_FaderPtr(pc),d0
	lsl.w	#8,d0
	lea	MegaMulsTable,a3
	add.l	d0,a3
	lea	Muls80Tab,a4
	move.w	Writer_SinusPtr(pc),d3
	move.w	#12*20-1,d7
.loop	move.w	16*2(a3,d3.w),d0
	move.w	(a3,d3.w),d1
	add.w	#256-1,d1
	sub.w	d7,d1
	bge.b	.yok1
.ynotok	move.w	#320,d0
	moveq	#0,d1
	bra.b	.plotit
.yok1	cmp.w	#255,d1
	bgt.b	.ynotok
	cmp.w	#320,d0
	bgt.b	.ynotok
	cmp.w	#-320,d0
	ble.b	.ynotok
.plotit	add.w	d1,d1
	move.w	(a4,d1.w),d1
	move.w	d0,d2
	asr.w	#4,d0
	add.w	d0,d0
	add.w	d0,d1	;byteoffset
	lsl.b	#4,d2
	or.b	#%1011,d2	;bltcon0
	ext.l	d1
	add.l	a2,d1	;screenbytepos
	move.w	d1,4(a0)
	move.w	d1,8+4(a0)
	swap	d1
	move.w	d1,(a0)
	move.w	d1,8(a0)
	move.l	a1,d1
	move.w	d1,16+4(a0)
	swap	d1
	move.w	d1,16(a0)
	move.b	d2,24(a0)
	lea	36(a0),a0	;nextcopper
	lea	40(a1),a1	;nextline
	addq.w	#2,d3
	and.w	#64*2-1,d3
	dbra	d7,.loop
	addq.w	#2,Writer_SinusPtr
	and.w	#64*2-1,Writer_SinusPtr
	rts


InitMegaMulsTable:	lea	Writer_Fader(pc),a0
	lea	MegaMulsTable,a2
	move.w	#256-1,d6
.loop2	move.w	(a0)+,d1
	lea	Writer_Sinus(pc),a1
	move.w	#64-1,d7
.loop	move.w	(a1)+,d0
	muls	d1,d0
	asr.l	#8,d0
	asr.l	#1,d0
	move.w	d0,64*2(a2)
	move.w	d0,(a2)+
	dbra	d7,.loop
	lea	64*2(a2),a2
	dbra	d6,.loop2
	rts

Writer_SinusPtr:	dc.w	0
Writer_Sinus:	;0,360,64,512,0,l,1,y,n
	QREPT	2
	DC.W	$0019,$004B,$007C,$00AC,$00DA,$0107,$0130,$0157,$017B,$019B
	DC.W	$01B7,$01CE,$01E2,$01F0,$01FA,$01FF,$01FF,$01FA,$01F0,$01E2
	DC.W	$01CE,$01B7,$019B,$017B,$0157,$0130,$0107,$00DA,$00AC,$007C
	DC.W	$004B,$0019,$FFE7,$FFB5,$FF84,$FF54,$FF26,$FEF9,$FED0,$FEA9
	DC.W	$FE85,$FE65,$FE49,$FE32,$FE1E,$FE10,$FE06,$FE01,$FE01,$FE06
	DC.W	$FE10,$FE1E,$FE32,$FE49,$FE65,$FE85,$FEA9,$FED0,$FEF9,$FF26
	DC.W	$FF54,$FF84,$FFB5,$FFE7
	ENDQR

Writer_FaderPtr:	dc.w	0
Writer_Fader:	;180,270,256,256,256,w,1,n,y
	DC.W	$0200,$01FD,$01FA,$01F7,$01F3,$01F0,$01ED,$01EA,$01E7,$01E4
	DC.W	$01E1,$01DD,$01DA,$01D7,$01D4,$01D1,$01CE,$01CB,$01C8,$01C4
	DC.W	$01C1,$01BE,$01BB,$01B8,$01B5,$01B2,$01AF,$01AC,$01A8,$01A5
	DC.W	$01A2,$019F,$019C,$0199,$0196,$0193,$0190,$018D,$018A,$0187
	DC.W	$0184,$0181,$017E,$017A,$0177,$0174,$0171,$016E,$016B,$0168
	DC.W	$0165,$0162,$015F,$015C,$0159,$0156,$0154,$0151,$014E,$014B
	DC.W	$0148,$0145,$0142,$013F,$013C,$0139,$0136,$0133,$0131,$012E
	DC.W	$012B,$0128,$0125,$0122,$011F,$011D,$011A,$0117,$0114,$0111
	DC.W	$010F,$010C,$0109,$0106,$0104,$0101,$00FE,$00FB,$00F9,$00F6
	DC.W	$00F3,$00F1,$00EE,$00EB,$00E9,$00E6,$00E4,$00E1,$00DE,$00DC
	DC.W	$00D9,$00D7,$00D4,$00D2,$00CF,$00CC,$00CA,$00C7,$00C5,$00C3
	DC.W	$00C0,$00BE,$00BB,$00B9,$00B6,$00B4,$00B2,$00AF,$00AD,$00AA
	DC.W	$00A8,$00A6,$00A4,$00A1,$009F,$009D,$009A,$0098,$0096,$0094
	DC.W	$0092,$008F,$008D,$008B,$0089,$0087,$0085,$0083,$0080,$007E
	DC.W	$007C,$007A,$0078,$0076,$0074,$0072,$0070,$006E,$006C,$006A
	DC.W	$0069,$0067,$0065,$0063,$0061,$005F,$005D,$005C,$005A,$0058
	DC.W	$0056,$0055,$0053,$0051,$004F,$004E,$004C,$004A,$0049,$0047
	DC.W	$0046,$0044,$0043,$0041,$003F,$003E,$003C,$003B,$003A,$0038
	DC.W	$0037,$0035,$0034,$0033,$0031,$0030,$002F,$002D,$002C,$002B
	DC.W	$0029,$0028,$0027,$0026,$0025,$0023,$0022,$0021,$0020,$001F
	DC.W	$001E,$001D,$001C,$001B,$001A,$0019,$0018,$0017,$0016,$0015
	DC.W	$0014,$0013,$0013,$0012,$0011,$0010,$000F,$000F,$000E,$000D
	DC.W	$000C,$000C,$000B,$000A,$000A,$0009,$0009,$0008,$0008,$0007
	DC.W	$0007,$0006,$0006,$0005,$0005,$0004,$0004,$0003,$0003,$0003
	DC.W	$0002,$0002,$0002,$0002,$0001,$0001,$0001,$0001,$0001,$0000
	DC.W	$0000,$0000,$0000,$0000,$0000,$0000




*******************************************************************************
**
**  Type screen
**
*******************************************************************************
TypeScreen:	lea	FontScreen+2*40,a6
	lea	PlaneFont,a0
	lea	Text(pc),a1
.next	tst.b	(a1)
	beq.b	.out
	bsr.b	WriteLine
	bra.b	.next
.out	rts

WriteLine:	moveq	#0,d0
	move.b	(a1)+,d0
	cmp.b	#10,d0
	beq.b	.CRLF
	cmp.b	#1,d0
	bne.b	.notvenstre
	moveq	#0,d1	;X-Pos
	bra.b	.printit
.notvenstre	bsr.w	FindPixelSize
	move.w	#320,d1
	sub.w	d3,d1
	cmp.b	#2,d0
	bne.b	.printit
	lsr.w	#1,d1
.printit	moveq	#0,d0
	move.b	(a1)+,d0
	cmp.b	#10,d0
	beq.b	.CRLF
	bsr.b	PrintChar
	add.w	d2,d1
	bra.b	.printit
.CRLF	lea	20*40(a6),a6
	rts


** in:  d0=asciichar
**      d1=pos
**      a0=font
**      a6=screen
** out: d2=charsize
** trashes:
PrintChar:	bra.b	.jump
.wloop	bsr.b	.copybyte
	addq.w	#1,a2
	bsr.b	.copybyte
	lea	35(a2),a2
	lea	38(a3),a3
	dbra	d4,.wloop
	rts
.copybyte	moveq	#0,d5
	move.b	(a2),d5
	ror.w	d3,d5
	or.b	d5,(a3)+
	lsr.w	#8,d5
	or.b	d5,(a3)
	rts
.jump	sub.b	#32,d0
	add.w	d0,d0
	moveq	#0,d2
	moveq	#0,d3
	move.b	FontConverter(PC,d0.w),d3
	move.b	FontConverter+1(PC,d0.w),d2
	cmp.b	#35,d3
	shi	d5
	divu	#36,d3
	move.w	d3,d4
	mulu	#36*17,d4
	swap	d3
	add.w	d3,d4
	lea	(a0,d4.w),a2	;font
	move.w	d1,d3
	move.w	d3,d4
	lsr.w	#3,d4
	lea	(a6,d4.w),a3	;screen
	tst.b	d5
	beq.b	.small
	lea	-2*40(a3),a3
.small	and.w	#7,d3	;scrollvalue
	moveq	#17-1,d4
	cmp.b	#8,d2
	bhi.b	.wloop
.bloop	bsr.b	.copybyte
	lea	36(a2),a2
	lea	39(a3),a3
	dbra	d4,.bloop
	rts

** in:  a1=text
** out: d3=pixelsize
** trashes: d2/d4/a2
FindPixelSize:	move.l	a1,a2
	moveq	#0,d3
.next	moveq	#0,d2
	move.b	(a2)+,d2
	cmp.b	#10,d2
	beq.b	.gotit
	sub.b	#32,d2
	add.w	d2,d2
	moveq	#0,d4
	move.b	FontConverter+1(PC,d2.w),d4
	add.w	d4,d3
	bra.b	.next
.gotit	rts

FontConverter:	dc.b	82,6,82,6,79,8,82,6	 ; SPC - '#'
	dc.b	82,6,82,6,82,6,80,4	 ; '$' - '''
	dc.b	72,6,73,6,82,6,82,6	 ; '(' - '+'
	dc.b	77,4,74,5,76,3,82,6	 ; ',' - '/'
	dc.b	82,6,82,6,82,6,82,6	 ; '0' - '3'
	dc.b	82,6,82,6,82,6,82,6	 ; '4' - '7'
	dc.b	82,6,82,6,78,3,82,6	 ; '8' - ';'
	dc.b	82,6,82,6,82,6,82,6	 ; '<' - '?'
	dc.b	82,6,36,8,37,8,38,8	 ; '@' - 'C'
	dc.b	39,8,40,8,41,8,42,8	 ; 'D' - 'G'
	dc.b	43,8,44,3,45,8,46,8	 ; 'H' - 'K'
	dc.b	47,4,48,12,50,8,51,8 ; 'L' - 'O'
	dc.b	52,8,53,8,54,8,55,8	 ; 'P' - 'S'
	dc.b	56,8,57,8,58,8,59,12 ; 'T' - 'W'
	dc.b	61,8,62,8,63,8,72,6	 ; 'X' - '['
	dc.b	82,6,73,6,82,6,82,6	 ; '\' - '_'
	dc.b	81,8,00,8,01,8,02,8	 ; '`' - 'c'
	dc.b	03,8,04,8,05,8,06,8	 ; 'd' - 'g'
	dc.b	07,8,08,3,09,8,10,8	 ; 'h' - 'k'
	dc.b	11,4,12,12,14,8,15,8 ; 'l' - 'o'
	dc.b	16,8,17,8,18,8,19,8	 ; 'p' - 's'
	dc.b	20,8,21,8,22,8,23,12 ; 't' - 'w'
	dc.b	25,8,26,8,27,8,72,6	 ; 'x' - '{'
	dc.b	82,6,82,6,82,6,82,6	 ; '|' - DEL

	blk.w	32,(82<<8)!6

	dc.b	82,6,82,6,82,6,82,6	 ; SPC - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	71,8,68,8,64,10,82,6 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,69,8,82,6	 ; '' - ''
	dc.b	66,10,82,6,82,6,82,6 ; '' - ''
	dc.b	70,8,82,6,82,8,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	35,8,32,8,28,11,82,6 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,33,8,82,6	 ; '' - ''
	dc.b	30,10,82,6,82,6,82,6 ; '' - ''
	dc.b	34,8,82,6,82,8,82,6	 ; '' - ''


Text:	dc.b	1,'Meln Dezign sends her greets to:',10
	dc.b	3,'(n rder t ll... - NOT)',10
	dc.b	10
	dc.b	2,'Funky Buddhas, Camel Corp., Mvement,',10
	dc.b	2,'Kefrens, Andromeda, Parasite, Shining,',10
	dc.b	2,'Spaceballs, Zenith, Lemon., Triumph, Complex,',10
	dc.b	2,'Hypenosis, Skandal,',10
	dc.b	2,'All the cool dudes on IRC, every MUD-player',10
	dc.b	2,'on ABACUS, all x-nrchists, all x-Rednecks',10
	dc.b	2,'...and at last and least STB.',10
	dc.b	10
	dc.b	2,'P.S. Der er plads til tolv linjer...',10
	dc.b	0
	EVEN


*******************************************************************************
**
**  Clear screen using blitter
**
*******************************************************************************
ClrScr:	move.l	Screen_Clear,d0
	lea	CopBlit1+2,a0
.insert	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	rts



*******************************************************************************
**
**  Swap screen for doublebuffering!
**
*******************************************************************************
SwapScr:	lea	Screen_Clear+3*4,a0
	lea	-4(a0),a1
	move.l	(a1),d7
	moveq	#3-2,d6
.cloop	move.l	-(a1),-(a0)
	dbra	d6,.cloop
	move.l	d7,(a1)

	lea	Copper_PlanePtr+2,a3
	move.l	Screen_Show,d0
.loop	move.w	d0,4(a3)
	swap	d0
	move.w	d0,(a3)

	lea	BltPtr,a0
	move.l	(a0),d0
	lea	BltCopper1,a1
	lea	BltCopper2,a2
	lea	BlitCopPtr,a3

	move.w	d0,6(a3)
	swap	d0
	move.w	d0,2(a3)
	swap	d0
	cmp.l	d0,a1
	beq.b	.make2
	move.l	a1,(a0)
	rts
.make2	move.l	a2,(a0)
	rts




*******************************************************************************
**
**  Variable
**
*******************************************************************************
	SECTION	SjovData,data

Screen_Clear:	dc.l	Screen1
Screen_Draw:	dc.l	Screen2
Screen_Show:	dc.l	Screen3

	SECTION	VariableTing,bss

	CNOP	0,4
_Bss2Start:
MaxRast:	ds.w	1
VBlank:	ds.b	1
	IFEQ	Track-0
IWantOut:	ds.b	1
	ELSE
IWantOut:	EQU	$80
	ds.b	1
	ENDC
Muls80Tab:	ds.w	256
MegaMulsTable:	ds.w	64*2*256
BltPtr:	ds.l	1
	CNOP	0,4
_Bss2End:




*******************************************************************************
**
**  Og den vildeste copperliste...
**
*******************************************************************************
	SECTION	MyCopper,data_c

Copper:	dc.w	Bplcon0,$0201
	dc.w	Bplcon1,$0000
	dc.w	Bplcon2,$0024
	dc.w	Bplcon3,$0c40

	dc.w	Spr0pth,0,Spr0ptl,0
	dc.w	Spr1pth,0,Spr1ptl,0
	dc.w	Spr2pth,0,Spr2ptl,0
	dc.w	Spr3pth,0,Spr3ptl,0
	dc.w	Spr4pth,0,Spr4ptl,0
	dc.w	Spr5pth,0,Spr5ptl,0
	dc.w	Spr6pth,0,Spr6ptl,0
	dc.w	Spr7pth,0,Spr7ptl,0

	dc.w	Color00,$000
	dc.w	Color01,$fff

	dc.w	$1001,$fffe
Copper_PlanePtr:	dc.w	Bpl1pth,0,Bpl1ptl,0

	dc.w	Diwstrt,$2c81
	dc.w	Bplcon0,$1200
	dc.w	Bplcon2,$0024
	dc.w	Bplcon3,$0c40
	dc.w	Diwstop,$2cc1
	dc.w	Ddfstrt,$0038
	dc.w	Ddfstop,$00d0
	dc.w	Bplcon1,$0000
	dc.w	Bpl1mod,80-40
	dc.w	Bpl2mod,80-40

	dc.w	$0001,$7ffe		;WaitBlt
CopBlit1:	dc.w	Bltdpth,0,Bltdptl,0
	dc.w	Bltcon0,$0100,Bltcon1,$0000
	dc.w	Bltdmod,80-40
	dc.w	Bltsize,256<<6!20

	dc.w	$0001,$7ffe		;WaitBlt
	dc.w	Bltcon1,$0000
	dc.w	Bltamod,-2
	dc.w	Bltcmod,80-42
	dc.w	Bltdmod,80-42
	dc.w	Bltafwm,-1
	dc.w	Bltalwm,0

BlitCopPtr:	dc.w	Cop2lch,0
	dc.w	Cop2lcl,0
	dc.w	Copjmp2,0

	dc.l	-2
	dc.l	-2



*******************************************************************************
**
**  Screens+Gfx
**
*******************************************************************************
	INCDIR	Work:Code/Sources/HTSAC/
PlaneFont:	INCBIN	Planefont.raw


	SECTION	Screens,bss_c

	CNOP	0,4
_Bss1Start:
Screen1:	ds.b	256*80
Screen2:	ds.b	256*80
Screen3:	ds.b	256*80
FontScreen:	ds.b	256*40
BltCopper1:	ds.l	9*256+3
BltCopper2:	ds.l	9*256+3
	CNOP	0,4
_Bss1End:




*******************************************************************************
**
**  Print info on program
**
*******************************************************************************



*******************************************************************************
**
**  Hardware registers
**
*******************************************************************************
Bltddat:	EQU	$000
Dmaconr:	EQU	$002
Vposr:	EQU	$004
Vhposr:	EQU	$006
Dskdatr:	EQU	$008
Joy0dat:	EQU	$00a
Joy1dat:	EQU	$00c
Clxdat:	EQU	$00e
Adkconr:	EQU	$010
Pot0dat:	EQU	$012
Pot1dat:	EQU	$014
Potgor:	EQU	$016
Serdatr:	EQU	$018
Dskbytr:	EQU	$01a
Intenar:	EQU	$01c
Intreqr:	EQU	$01e
Dskpth:	EQU	$020
Dskptl:	EQU	$022
Dsklen:	EQU	$024
Dskdat:	EQU	$026
Refptr:	EQU	$028
Vposw:	EQU	$02a
Vhposw:	EQU	$02c
Copcon:	EQU	$02e
Serdat:	EQU	$030
Serper:	EQU	$032
Potgo:	EQU	$034
Joytest:	EQU	$036
Strequ:	EQU	$038
Strvbl:	EQU	$03a
Strhor:	EQU	$03c
Strlong:	EQU	$03e
Bltcon0:	EQU	$040
Bltcon1:	EQU	$042
Bltafwm:	EQU	$044
Bltalwm:	EQU	$046
Bltcpth:	EQU	$048
Bltcptl:	EQU	$04a
Bltbpth:	EQU	$04c
Bltbptl:	EQU	$04e
Bltapth:	EQU	$050
Bltaptl:	EQU	$052
Bltdpth:	EQU	$054
Bltdptl:	EQU	$056
Bltsize:	EQU	$058
Bltcmod:	EQU	$060
Bltbmod:	EQU	$062
Bltamod:	EQU	$064
Bltdmod:	EQU	$066
Bltcdat:	EQU	$070
Bltbdat:	EQU	$072
Bltadat:	EQU	$074
Dsksync:	EQU	$07e
Cop1lch:	EQU	$080
Cop1lcl:	EQU	$082
Cop2lch:	EQU	$084
Cop2lcl:	EQU	$086
Copjmp1:	EQU	$088
Copjmp2:	EQU	$08a
Copins:	EQU	$08c
Diwstrt:	EQU	$08e
Diwstop:	EQU	$090
Ddfstrt:	EQU	$092
Ddfstop:	EQU	$094
Dmacon:	EQU	$096
Clxcon:	EQU	$98
Intena:	EQU	$09a
Intreq:	EQU	$09c
Adkcon:	EQU	$09e
Aud0dat:	EQU	$0aa
Aud1dat:	EQU	$0ba
Aud2dat:	EQU	$0ca
Aud3dat:	EQU	$0da
Aud0lch:	EQU	$0a0
Aud1lch:	EQU	$0b0
Aud2lch:	EQU	$0c0
Aud3lch:	EQU	$0d0
Aud0len:	EQU	$0a4
Aud1len:	EQU	$0b4
Aud2len:	EQU	$0c4
Aud3len:	EQU	$0d4
Aud0per:	EQU	$0a6
Aud1per:	EQU	$0b6
Aud2per:	EQU	$0c6
Aud3per:	EQU	$0d6
Aud0vol:	EQU	$0a8
Aud1vol:	EQU	$0b8
Aud2vol:	EQU	$0c8
Aud3vol:	EQU	$0d8
Aud0lcl:	EQU	$0a2
Aud1lcl:	EQU	$0b2
Aud2lcl:	EQU	$0c2
Aud3lcl:	EQU	$0d2
Bpl1pth:	EQU	$0e0
Bpl1ptl:	EQU	$0e2
Bpl2pth:	EQU	$0e4
Bpl2ptl:	EQU	$0e6
Bpl3pth:	EQU	$0e8
Bpl3ptl:	EQU	$0ea
Bpl4pth:	EQU	$0ec
Bpl4ptl:	EQU	$0ee
Bpl5pth:	EQU	$0f0
Bpl5ptl:	EQU	$0f2
Bpl6pth:	EQU	$0f4
Bpl6ptl:	EQU	$0f6
Bpl7pth:	EQU	$0f8
Bpl7ptl:	EQU	$0fa
Bpl8pth:	EQU	$0fc
Bpl8ptl:	EQU	$0fe
Bplcon0:	EQU	$100
Bplcon1:	EQU	$102
Bplcon2:	EQU	$104
Bplcon3:	EQU	$106
Bpl1mod:	EQU	$108
Bpl2mod:	EQU	$10a
Bpl1dat:	EQU	$110
Bpl2dat:	EQU	$112
Bpl3dat:	EQU	$114
Bpl4dat:	EQU	$116
Bpl5dat:	EQU	$118
Bpl6dat:	EQU	$11a
Spr0pth:	EQU	$120
Spr0ptl:	EQU	$122
Spr1pth:	EQU	$124
Spr1ptl:	EQU	$126
Spr2pth:	EQU	$128
Spr2ptl:	EQU	$12a
Spr3pth:	EQU	$12c
Spr3ptl:	EQU	$12e
Spr4pth:	EQU	$130
Spr4ptl:	EQU	$132
Spr5pth:	EQU	$134
Spr5ptl:	EQU	$136
Spr6pth:	EQU	$138
Spr6ptl:	EQU	$13a
Spr7pth:	EQU	$13c
Spr7ptl:	EQU	$13e
Spr0pos:	EQU	$140
Spr0ctl:	EQU	$142
Spr0data:	EQU	$144
Spr0datb:	EQU	$146
Spr1pos:	EQU	$148
Spr1ctl:	EQU	$14a
Spr1data:	EQU	$14c
Spr1datb:	EQU	$14e
Spr2pos:	EQU	$150
Spr2ctl:	EQU	$152
Spr2data:	EQU	$154
Spr2datb:	EQU	$156
Spr3pos:	EQU	$158
Spr3ctl:	EQU	$15a
Spr3data:	EQU	$15c
Spr3datb:	EQU	$15e
Spr4pos:	EQU	$160
Spr4ctl:	EQU	$162
Spr4data:	EQU	$164
Spr4datb:	EQU	$166
Spr5pos:	EQU	$168
Spr5ctl:	EQU	$16a
Spr5data:	EQU	$16c
Spr5datb:	EQU	$16e
Spr6pos:	EQU	$170
Spr6ctl:	EQU	$172
Spr6data:	EQU	$174
Spr6datb:	EQU	$176
Spr7pos:	EQU	$178
Spr7ctl:	EQU	$17a
Spr7data:	EQU	$17c
Spr7datb:	EQU	$17e
Color00:	EQU	$180
Color01:	EQU	$182
Color02:	EQU	$184
Color03:	EQU	$186
Color04:	EQU	$188
Color05:	EQU	$18a
Color06:	EQU	$18c
Color07:	EQU	$18e
Color08:	EQU	$190
Color09:	EQU	$192
Color10:	EQU	$194
Color11:	EQU	$196
Color12:	EQU	$198
Color13:	EQU	$19a
Color14:	EQU	$19c
Color15:	EQU	$19e
Color16:	EQU	$1a0
Color17:	EQU	$1a2
Color18:	EQU	$1a4
Color19:	EQU	$1a6
Color20:	EQU	$1a8
Color21:	EQU	$1aa
Color22:	EQU	$1ac
Color23:	EQU	$1ae
Color24:	EQU	$1b0
Color25:	EQU	$1b2
Color26:	EQU	$1b4
Color27:	EQU	$1b6
Color28:	EQU	$1b8
Color29:	EQU	$1ba
Color30:	EQU	$1bc
Color31:	EQU	$1be
_Custom:	EQU	$dff000




*******************************************************************************
**
**  Interrupt addresses
**
*******************************************************************************
Lev1Vec:	EQU	$64
Lev2Vec:	EQU	$68
Lev3Vec:	EQU	$6c
Lev4Vec:	EQU	$70
Lev5Vec:	EQU	$74
Lev6Vec:	EQU	$78
Lev7Vec:	EQU	$7c
Trap0:	EQU	$80






