  Uȯw  U  6m  6m  6mȯw  6m  6m;------------------T--------T
******************************************************************************
*   ____    _____                                      ____    ____     ___   *
*  |    \  |         |     | |     | |\    | |  /     |    \  |    \   /   \  *
*  |     | |         |     | |     | | \   | | /      |     ) |     ) |       *
*  |     | |---   -- |-----| |     | |  \  | |/\      |____/  |____/  |  ___  *
*  |     | |         |     | |     | |   \ | |  \     |       |  \    |    |  *
*  |____/  |_____    |     | |_____| |    \| |   \    |       |   \    \___|  *
*                                                                             *
*******************************************************************************
* IN	a0=Address of program in memory
* 
* OUT	d0=Adress of AllocBuffer (auto de allocating!)
* 
DeHunkPrg:	movem.l	d1-d3/a0-a5,-(sp)
	cmp.l	#$3F3,(a0)		; check if header!
	bne.s	DHP_Error
	bra.s	DHP_NextHunk2
DHP_NextHunk:	tst.l	d3
	beq.s	DHP_AllOk
DHP_NextHunk2:	move.l	(a0)+,d0
	cmp.l	#$3F3,d0		; hunk_header
	beq.w	DHP_hunk_header
	cmp.l	#$3e9,d0		; hunk_code
	beq.s	DHP_hunk_code
	cmp.l	#$3ea,d0		; hunk_data
	beq.s	DHP_hunk_data
	cmp.l	#$3eb,d0		; hunk_bss
	beq.s	DHP_hunk_bss

DHP_Error:	illegal
	

DHP_AllOk:	move.l	#1024,d0		; SIZE 1K
	moveq	#1,d1			; TYPE MixM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	lea	HunkBuffer(pc),a0
	move.l	d0,a1
	move.l	#256-1,d2
.loop	move.l	(a0)+,d3		; get size
	move.l	(A0)+,(a1)+		; get and store add
	move.l	d3,(a1)+		; store size
	dbf	d2,.loop
	movem.l	(sp)+,d1-d3/a0-a5
	rts
DHP_hunk_data:
DHP_hunk_code:	move.l	(a0)+,d0		; size of hunk!
	tst.l	(a1)+
	move.l	(a1)+,a3		; dest add
	bra.s	.BLoop
.Loop	move.l	(a0)+,(a3)+
.BLoop	dbf	d0,.Loop
	cmp.l	#$3ec,(a0)
	bne.s	.NoRelocTab
	bsr.b	DHP_hunk_reloc32
.NoRelocTab	cmp.l	#$3f2,(a0)+
	bne.s	DHP_Error		; NoHunkEnd ???
	subq.l	#1,d3			; RestHunk=RestHunk-1
	bra.s	DHP_NextHunk
DHP_hunk_bss	move.l	(a0)+,d0		; size of hunk!
	tst.l	(a1)+
	move.l	(a1)+,a3		; dest add
	bra.s	.BLoop
.Loop	clr.l	(a3)+
.BLoop	dbf	d0,.Loop
	cmp.l	#$3f2,(a0)+		; END?
	bne.s	DHP_Error		; NoHunkEnd ???
	subq.l	#1,d3			; RestHunk=RestHunk-1
	bra.w	DHP_NextHunk
DHP_hunk_reloc32:
	move.l	-4(a1),a4		; HUNK TO BE CORRECTED
	tst.l	(a0)+			; SKIP $3EC.l
.Loop2	move.l	(a0)+,d0		; number of offsets
	beq.s	.LastSection
	move.l	(a0)+,d1		; hunk number
	lsl.l	#3,d1
	move.l	4(a2,d1.l),d2		; MainAddOfHunk
	bra.s	.BLoop
.Loop	move.l	(a0)+,d1
	lea	(a4,d1.l),a5		; add to be corrected
	add.l	d2,(a5)
.BLoop	dbf	d0,.Loop
	bra.s	.Loop2
.LastSection	rts

DHP_hunk_header	lea	HunkBuffer(pc),a1
	moveq	#0,d0			; clr hun buffer!
.loop	clr.l	(a1,d0.w)
	addq.w	#4,d0
	cmp.w	#20*4,d0
	bne.s	.loop
.loop2	tst.l	(a0)+			; skip hunk names!
	bne.s	.loop2
	move.l	(a0)+,d2		; number of hunks
	move.l	d2,d3			; number of hunks
	addq.l	#8,a0			; skip hunk numbers
	bra.s	.BLoop3
.loop3	move.l	(a0)+,d1		; hunk size
	moveq	#0,d0
	move.l	d1,d0
	add.l	d0,d0
	add.l	d0,d0			; d2=size in bytes!
	clr.w	d1
	bclr	#30,d1
	bne.s	.Chip
	bset	#0,d1			; TYPE=FAST
.Chip	move.l	d0,(a1)+		; save size
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(a1)+		; save add
.BLoop3	dbf	d2,.loop3
	lea	HunkBuffer(pc),a1
	move.l	a1,a2
	bra.w	DHP_NextHunk
		
HunkBuffer:	blk.l	128*2,0			; _MAX_ 1228 hunks!!!!!

*******************************************************************************
*      _____  ____    _____  _____                                   ____     *
*     |      |    \  |      |         |     | |     | |\    | |  /  /         *
*     |      |     | |      |         |     | |     | | \   | | /   \___      *
*     |---   |____/  |---   |---      |-----| |     | |  \  | |/\       \     *
*     |      |   \   |      |         |     | |     | |   \ | |  \       )    *
*     |      |    \  |_____ |_____    |     | |_____| |    \| |   \ ____/     *
*                                                                             *
*******************************************************************************
* IN	d0=Address of AllocBuffer
* 
FreeHunks:	movem.l	d1-d2/a0,-(sp)
	move.l	d0,a0
	move.l	d0,d2
.Loop	move.l	(a0)+,d0		; add of chunk
	beq.s	.LastChunk
	move.l	(a0)+,d1		; size of chunk
	bsr.w	FreeMem
	bra.s	.Loop
.LastChunk	move.l	d2,d0			; add of buffer
	move.l	#1024,d1		; size of buffer
	bsr.w	FreeMem
	movem.l	(sp)+,d1-d2/a0
	rts
*******************************************************************************
*                              _____   _____                _____             *
*        /\     |      |      |     | |           |\    /| |      |\    /|    *
*       /  \    |      |      |     | |           | \  / | |      | \  / |    *
*      /____\   |      |      |     | |           |  \/  | |---   |  \/  |    *
*     /      \  |      |      |     | |           |      | |      |      |    *
*    /        \ |_____ |_____ |_____| |_____      |      | |_____ |      |    *
*                                                                             *
*******************************************************************************
* IN	d0=Size of chunk (in bytes)
* 	d1=Type
* OUT	d0=result
* 
* Type:	BIT0	= CLR=CHIP		SET=OTHER
* 	BIT1	= CLR=CLEAR MEM		SET=DON`T CLEAR MEM
* 

AllocMem:	movem.l	d2-d5/a0-a1,-(sp)
	lea	ResChipBuffer(pc),a0
	btst	#0,d1
	beq.s	.GetChip
	lea	ResMixMBuffer(pc),a0
.GetChip	add.l	#1023,d0
	lsr.l	#8,d0
	lsr.l	#2,d0
	lea	8(a0),a1	; start add
	moveq	#0,d1		; start chunk nr
	move.l	4(a0),d2
	sub.l	(a0),d2
	lsr.l	#8,d2
	lsr.l	#2,d2		; size of module
.TryAgain	bsr.b	.FindChunk
	bmi.s	.ErrorNoMem
	cmp.l	d0,d3
	bmi.s	.TryAgain
	bsr.b	.AllocChunk
	lsl.l	#8,d5
	lsl.l	#2,d5
	add.l	(a0),d5
	move.l	d5,d0
.out	movem.l	(sp)+,d2-d5/a0-a1
	rts
.ErrorNoMem:	moveq	#0,d0
	beq.b	.out

.FindChunk	moveq	#0,d3		; found size
.FC_loop1	cmp.l	d2,d1
	beq.s	.FC_Out2
	move.l	d1,d4		; byteadd
	lsr.l	#3,d4
	btst	d1,(a1,d4.l)
	beq.s	.FC_loop2S
	addq.l	#1,d1
	bra.s	.FC_loop1
.FC_loop2S	move.l	d1,d5
.FC_loop2	cmp.l	d2,d1
	beq.s	.FC_Out
	move.l	d1,d4		; byteadd
	lsr.l	#3,d4
	btst	d1,(a1,d4.l)
	bne.s	.FC_Out
	addq.l	#1,d1
	addq.l	#1,d3
	bra.s	.FC_loop2
.FC_Out2	moveq	#-1,d3
.FC_Out	rts

.AllocChunk	move.l	d5,d2
	bra.s	.AC_StartLoop
.AC_loop	move.l	d2,d4		; byteadd
	lsr.l	#3,d4
	btst	d2,(a1,d4.l)
	bne.b	.PANIC
	bset	d2,(a1,d4.l)
	addq.l	#1,d2
.AC_StartLoop	dbf	d0,.AC_loop
	rts
.PANIC	illegal

*******************************************************************************
*           _____  ____    _____  _____               _____                   *
*          |      |    \  |      |          |\    /| |      |\    /|          *
*          |      |     ) |      |          | \  / | |      | \  / |          *
*          |---   |____/  |---   |---       |  \/  | |---   |  \/  |          *
*          |      |   \   |      |          |      | |      |      |          *
*          |      |    \  |_____ |_____     |      | |_____ |      |          *
*                                                                             *
*******************************************************************************
* IN	d0=Add of chunk
* 	d1=Size of chunk (in bytes)
* 
Freeerror:	dc.w	0
FreeMem:	movem.l	d2-d3/a0,-(sp)
	lea	ResChipBuffer(pc),a0
	bsr.s	.ChechModule
	beq.s	.FoundModule
	lea	ResMixMBuffer(pc),a0
	bsr.s	.ChechModule
	beq.s	.FoundModule
	movem.l	(sp)+,d2-d3/a0
	rts
.Error	illegal
.FoundModule	move.l	d0,d3
	sub.l	(a0),d0
	add.l	d1,d3
	cmp.l	4(a0),d3
	bhi.s	.Error		; branch if Add+Size>UpperBorder
	lsr.l	#8,d0
	lsr.l	#2,d0		; d0 = pointer
	add.l	#1023,d1
	lsr.l	#8,d1
	lsr.l	#2,d1		; d1=size in 1024blocks
	lea	8(a0),a0
	bra.s	.StartLoop
.loop	move.l	d0,d2		; byteadd
	lsr.l	#3,d2
	bclr	d0,(a0,d2.l)
	beq.s	.Error
	addq.l	#1,d0
.StartLoop	dbf	d1,.loop
	movem.l	(sp)+,d2-d3/a0
	rts
.ChechModule	move.l	(a0),d2
	cmp.l	d2,d0
	blo.s	.NotThisModule
	move.l	4(a0),d2
	cmp.l	d2,d0
	bhi.s	.NotThisModule
	moveq	#0,d2
	rts
.NotThisModule	moveq	#-1,d2
	rts

ChipSize	=	490 ;K
MixMSize	=	512-6 ;K
ResChipBuffer:	dc.l	0,0
	blk.w	(ChipSize/16)+1,0
ResMixMBuffer:	dc.l	0,0
	blk.w	(MixMSize/16)+1,0

PANIC_NOMEM:	ILLEGAL

