  Bȯw  M t t tȯw t t;------------------T-------T------------------------T
Raster=0
ADDRESS=$1E0000
MUSIC_LEN:	EQU	141426-16
	AUTO	ws\S_START\2\S_BLOCKS\


MyDmacon=%11111100000
;         abcdefghhhh
; a = Blitter nasty
; b = Enable DMA activity (always set this!)
; c = Bitplane enable
; d = Copper enable
; e = Blitter enable
; f = Sprite enable
; g = Disk enable
; h = Audio channels enable

MyIntena=%100000000100100
;         abcdeeeefghijkl
; a = Enable interrupts
; b = Lev. 6 External interrupt
; c = Lev. 5 Disk sync found
; d = Lev. 5 Serial port receive buffer full
; e = Lev. 4 Audio ch. 3-0 block finished
; f = Lev. 3 Blitter finished
; g = Lev. 3 Vertical blank
; h = Lev. 3 Copper
; i = Lev. 2 I/O Ports and timers
; j = Lev. 1 Software
; k = Lev. 1 Disk block finished
; l = Lev. 1 Serial port transmit buffer empty

*******************************************************************************
**Macros
*******************************************************************************
WaitBlt:	MACRO
.vent\@:	if	Raster=1
	move.w	#$fff,Color00+_Custom
	endif
	btst	#14,Dmaconr+_Custom
	bne.b	.vent\@
	if	Raster=1
	move.w	#0,Color00+_Custom
	endif
	ENDM

SetInt:	MACRO
	move.l	#Lev\1Irq,(Lev\1Base).w
	ENDM

ClrInt:	MACRO
	move.l	OldIrq\1(pc),(Lev\1Base).w
	ENDM

Push.l:	MACRO
	movem.l	\1,-(sp)
	ENDM

Push.w:	MACRO
	movem.w	\1,-(sp)
	ENDM

Pull.l:	MACRO
	movem.l	(sp)+,\1
	ENDM

Pull.w:	MACRO
	movem.w	(sp)+,\1
	ENDM

StartPrg:	MACRO
	move.w	#$7fff,Intreq+_Custom
	move.w	#MyDmacon!$8000,Dmacon+_Custom
	move.w	#MyIntena!$8000,Intena+_Custom
	ENDM

StopPrg:	MACRO
	move.w	#$7fff,Intena+_Custom
	move.w	#$7fff,Dmacon+_Custom
	move.w	#$7fff,Intreq+_Custom
	ENDM

StartSystem:	MACRO
	move.w	OldDmacon(pc),d0
	or.w	#$8000,d0
	move.w	d0,Dmacon+_Custom
	move.w	OldIntena(pc),d0
	or.w	#$8000,d0
	move.w	d0,Intena+_Custom
	ENDM

ClearBss:	MACRO
	lea	_Bss\1Start,a0
	move.l	#(_Bss\1End-_Bss\1Start)/4,d0
.clrloop\@	clr.l	(a0)+
	subq.l	#1,d0
	bne.b	.clrloop\@
	ENDM




*******************************************************************************
**
**  Initialisering
**
*******************************************************************************
	ORG	$100
	LOAD	ADDRESS

START:	StopPrg
	move.w	#$7FFF,Adkcon+_Custom
**Init starter -----------------------------------
	lea	(END).w,a0
	move.w	#TheEnd-END-1,d0
.clrloop	clr.b	(a0)+
	dbra	d0,.clrloop

	move.w	#$20,$DFF1DC	;goe gamle PAL!
	clr.l	0.w	;til sprites
	clr.l	4.w	;lkker reset

	move.b	$DFF07C+1,d0
	cmp.b	#$00F8,d0
	seq	(AGA_Chipset).w

	tst.b	(AGA_Chipset).w
	beq.b	.nooo
	moveq	#0,d0
	move.w	#$0C40,d1
	move.w	#$0E40,d2
	lea	_Custom,a6
	moveq	#8-1,d4
.colloop3	move.w	d1,Bplcon3(a6)
	move.w	#$0180,d3
	moveq	#32-1,d5
.colloop	move.w	d4,(a6,d3.w)
	addq.w	#2,d3
	dbra	d5,.colloop
	move.w	d2,Bplcon3(a6)
	move.w	#$0180,d3
	moveq	#32-1,d5
.colloop2	move.w	d4,(a6,d3.w)
	addq.w	#2,d3
	dbra	d5,.colloop2
	add.w	#$2000,d1
	add.w	#$2000,d2
	dbra	d4,.colloop3
.nooo

	lea	$8.w,a0	;guru
	move.w	#($80-$8)/4-1,d0
.loop	move.l	#ShowGuru,(a0)+
	dbra	d0,.loop

	move.l	#TheEnd,(ResChipBuffer).w
	move.l	#TopOfChip,(ResChipBuffer+4).w
	moveq	#-1,d0
	moveq	#0,d1
	move.l	d0,$240000
	cmp.l	$240000,d0
	bne.b	.No20Ram
	move.l	d1,$240000
	cmp.l	$240000,d1
	bne.b	.No20Ram
	move.l	#$200000,(ResMixMBuffer).w
	move.l	#$280000,(ResMixMBuffer+4).w
	bra.b	.MemOk
.No20Ram	move.l	d0,$C40000
	cmp.l	$C40000,d0
	bne.b	.NoC0Ram
	move.l	d1,$C40000
	cmp.l	$C40000,d1
	bne.b	.NoC0Ram
	move.l	#$C00000,(ResMixMBuffer).w
	move.l	#$C80000,(ResMixMBuffer+4).w
	bra.b	.MemOk
.NoC0Ram	move.l	d1,$40000
	move.l	d0,$80000+$40000
	cmp.l	$40000,d0
	beq.b	.No08Ram
	cmp.l	$80000+$40000,d0
	bne.b	.No08Ram
	move.l	d1,$80000+$40000
	cmp.l	$80000+$40000,d1
	bne.b	.No08Ram
	move.l	#$80000,(ResMixMBuffer).w
	move.l	#$100000,(ResMixMBuffer+4).w
	bra.b	.MemOk
.No08Ram	bra.w	Needs1Mb
.MemOk	move.l	(ResMixMBuffer).w,d0
	move.l	d0,(TD_LoadAdd).w
	add.l	#11*512,d0
	move.l	d0,(ResMixMBuffer).w

	move.l	#.super,$80.w	;set supervisor
	trap	#0
.super:	move.l	(ResMixMBuffer).w,a0
	lea	4096(a0),a0
	move.l	a0,a7
	move.w	#0,sr
	lea	4096(a0),a0
	move.l	a0,a7
	move.l	a0,(ResMixMBuffer).w

	move.w	#0,Copcon+_Custom

	clr.b	$80.w

	move.l	#BlackCopper,Cop1lch+_Custom

	SetInt	6
	SetInt	3
	SetInt	1
	StartPrg
**Init slutter -----------------------------------

	bsr	TD_PrepRegs
	bsr.w	TD_Init
	bsr.w	TD_MotorOn
	bsr.w	TD_SeekZero
	bsr	TD_MotorOff

	bsr	LoadLoadPic
	bsr	RunRoutine2

	bsr	LoadMainModule

	moveq	#0,d0
	bsr	LoadSkjerm1
	bsr	WaitForFinish
	st	(pr_moduleok).w	;Start musik
	bsr	RunRoutine1
	bsr	LoadDotTunnel	;Hent dottunnel
	bsr	WaitForFinish
	bsr	UnLoadSkjerm
	bsr	InitDotTunnel
	bsr	RunRoutine2
	bsr	WaitForFinish
	bsr	UnLoadRoutine2
	bsr	LoadTand
	bsr	InitTand
	bsr	RunRoutine1
	moveq	#5,d0
	bsr	LoadSkjerm2
	bsr	WaitForFinish
	bsr	UnLoadRoutine1
	bsr	RunRoutine2
	bsr	LoadMatilde
	bsr	InitMatilde
	bsr	WaitForFinish
	bsr	UnLoadSkjerm
	bsr	RunRoutine1
	bsr	LoadDezign1
	bsr	InitDezign1
	bsr	WaitForFinish
	bsr	UnLoadRoutine1
	bsr	RunRoutine2
	moveq	#2,d0
	bsr	LoadSkjerm1
	bsr	WaitForFinish
	bsr	UnLoadRoutine2
	bsr	RunRoutine1
	bsr	LoadNyNexCube
	bsr	InitNyNexCube
	bsr	WaitForFinish
	bsr	UnLoadSkjerm
	bsr	RunRoutine2
	moveq	#3,d0
	bsr	LoadSkjerm1
	bsr	WaitForFinish
	bsr	RunRoutine1
	bsr	UnLoadRoutine2
	bsr	LoadMatildeCube
	bsr	InitMatildeCube
	bsr	WaitForFinish
	bsr	UnLoadSkjerm
	move.w	#$0400,Dmacon+_Custom
	bsr	RunRoutine2
	bsr	LoadPong
	bsr	InitPong
	bsr	WaitForFinish
	move.w	#$8400,Dmacon+_Custom
	bsr	UnLoadRoutine2
	bsr	RunRoutine1
	moveq	#4,d0
	bsr	LoadSkjerm2
	bsr	WaitForFinish
	bsr	RunRoutine2
	bsr	UnLoadRoutine1
	bsr	LoadEndPart
	bsr	InitEndPart
	bsr	WaitForFinish
	bsr	UnLoadSkjerm
	bsr	RunRoutine1
	bsr	LoadEndPicture
	bsr	InitEndPicture
	bsr	WaitForFinish
	bsr	UnLoadRoutine1
	bsr	RunRoutine2
	bsr	LoadHidden1
	bsr	InitHidden1
	bsr	WaitForFinish
	bsr	UnLoadRoutine2
	bsr	RunRoutine1
	bsr	WaitForFinish
	bsr	UnLoadRoutine1
	bsr	LoadHidden2
	bsr	InitHidden2
	bsr	RunRoutine2
	move.l	#JumpCopper,Cop1lch+_Custom

	bsr.w	TD_Restore	;Stop Trackloader

.hehe	bra.b	.hehe


UnLoadRoutine1:	move.l	(Routine1Ptr).w,d0
	bra	FreeHunks

RunRoutine1:	move.w	#$0C40,$DFF106
	move.l	(Routine1Ptr).w,a0
	move.l	(a0),a0
	jmp	(a0)

UnLoadRoutine2:	move.l	(Routine2Ptr).w,d0
	bra	FreeHunks

RunRoutine2:	move.w	#$0C40,$DFF106
	move.l	(Routine2Ptr).w,a0
	move.l	(a0),a0
	jmp	(a0)


UnLoadSkjerm:	move.l	(PictureLocation).w,d0
	move.l	#40*256*3+16,d1	;size
	bra	FreeMem

LoadSvend:	dc.l	$60000
LoadLoadPic:	bsr	TD_PrepRegs
	bsr	TD_MotorOn

	move.l	#LoadSvend,(Routine2Ptr).w
	move.l	(LoadSvend).w,a0
	moveq	#82,d1
	move.w	#1672,d0
	bsr.w	TD_ReadSectors
	bsr	TD_MotorOff

	move.l	(Routine2Ptr).w,a0
	move.l	(a0),a0
	jmp	10(a0)

LoadSkjerm1:	bsr	_LoadSkjerm
	move.l	#Picture,(Routine1Ptr).w
	move.l	(Routine1Ptr).w,a0
	bra.b	_LoadSkjermInit

LoadSkjerm2:	bsr	_LoadSkjerm
	move.l	#Picture,(Routine2Ptr).w
	move.l	(Routine2Ptr).w,a0
_LoadSkjermInit:	move.l	(a0),a0
	jmp	10(a0)

_LoadSkjerm:	Push.w	d0

	bsr	TD_PrepRegs
	bsr	TD_MotorOn

	move.l	#40*256*3+16,d0	;size
	moveq	#%10,d1
* Type:	BIT0	= CLR=CHIP	SET=OTHER
* 	BIT1	= CLR=CLEAR MEM	SET=DON`T CLEAR MEM
	bsr	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM

	move.l	d0,a0
	Pull.w	d2
	add.w	d2,d2
	add.w	d2,d2
	move.w	Skjerms(PC,d2.w),d0
	move.w	Skjerms+2(PC,d2.w),d1
	Push.l	a0
	bsr	TD_PrepRegs
	bsr.w	TD_ReadSectors
	bsr	TD_MotorOff

	Pull.l	a0
	lea	16(a0),a1
	move.l	a1,-(sp)
	bsr	NormalDecrunch
	move.l	(sp)+,(PictureLocation).w

	rts

Skjerms:	dc.w	215,18
	dc.w	232,16
	dc.w	248,17
	dc.w	265,15
	dc.w	280,17
	dc.w	297,18



PictureLocation:	dc.l	0

LoadDotTunnel:	bsr	TD_PrepRegs
	bsr	TD_MotorOn

	move.l	#512*12,d0	;size
	moveq	#%01,d1
* Type:	BIT0	= CLR=CHIP	SET=OTHER
* 	BIT1	= CLR=CLEAR MEM	SET=DON`T CLEAR MEM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	Push.l	d0

	move.l	d0,a0
	moveq	#12,d1
	tst.b	(AGA_Chipset).w
	beq.b	.norm
	move.w	#329,d0
	bra.b	.goon
.norm	move.w	#315,d0
.goon	bsr	TD_PrepRegs
	bsr.w	TD_ReadSectors
	bsr	TD_MotorOff

	move.l	(sp)+,(Routine2Loc).w
	rts

InitDotTunnel:	move.l	(Routine2Loc).w,a0
	bsr.w	DeHunkPrg
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Routine2Ptr).w

	move.l	(Routine2Loc).w,d0
	move.l	#512*12,d1	;size
	bsr	FreeMem

	move.l	(Routine2Ptr).w,a0
	move.l	(a0),a0
	jmp	10(a0)




LoadTand:	bsr	TD_PrepRegs
	bsr	TD_MotorOn

	move.l	#512*49,d0	;size
	moveq	#%01,d1
* Type:	BIT0	= CLR=CHIP	SET=OTHER
* 	BIT1	= CLR=CLEAR MEM	SET=DON`T CLEAR MEM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	Push.l	d0

	move.l	d0,a0
	moveq	#49,d1
	tst.b	(AGA_Chipset).w
	beq.b	.ecs
	move.w	#394,d0
	bra.b	.load
.ecs	move.w	#343,d0
.load	bsr	TD_PrepRegs
	bsr.w	TD_ReadSectors
	bsr	TD_MotorOff

	move.l	(sp)+,(Routine1Loc).w
	rts

InitTand:	move.l	(Routine1Loc).w,a0
	bsr.w	DeHunkPrg
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Routine1Ptr).w

	move.l	(Routine1Loc).w,d0
	move.l	#512*49,d1	;size
	bsr	FreeMem

	move.l	(Routine1Ptr).w,a0
	move.l	(a0),a0
	jmp	10(a0)




LoadMatilde:	bsr	TD_PrepRegs
	bsr	TD_MotorOn

	move.l	#512*39,d0	;size
	moveq	#%01,d1
* Type:	BIT0	= CLR=CHIP	SET=OTHER
* 	BIT1	= CLR=CLEAR MEM	SET=DON`T CLEAR MEM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	Push.l	d0

	move.l	d0,a0
	moveq	#39,d1
	move.w	#444,d0
	bsr	TD_PrepRegs
	bsr.w	TD_ReadSectors
	bsr	TD_MotorOff

	move.l	(sp)+,(Routine1Loc).w
	rts

InitMatilde:	move.l	(Routine1Loc).w,a0
	bsr.w	DeHunkPrg
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Routine1Ptr).w

	move.l	(Routine1Loc).w,d0
	move.l	#512*39,d1	;size
	bsr	FreeMem

	move.l	(Routine1Ptr).w,a0
	move.l	(a0),a0
	jmp	10(a0)




LoadDezign1:	bsr	TD_PrepRegs
	bsr	TD_MotorOn

	move.l	#512*29,d0	;size
	moveq	#%01,d1
* Type:	BIT0	= CLR=CHIP	SET=OTHER
* 	BIT1	= CLR=CLEAR MEM	SET=DON`T CLEAR MEM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	Push.l	d0

	move.l	d0,a0

	moveq	#29,d1
	tst.b	(AGA_Chipset).w
	beq.b	.norm
	move.w	#515,d0
	bra.b	.goon
.norm	move.w	#485,d0
.goon	bsr	TD_PrepRegs
	bsr.w	TD_ReadSectors

	move.l	(sp)+,(Routine2Loc).w
	rts

InitDezign1:	move.l	(Routine2Loc).w,a0
	bsr.w	DeHunkPrg
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Routine2Ptr).w

	move.l	(Routine2Loc).w,d0
	move.l	#512*29,d1	;size
	bsr	FreeMem

	move.l	(Routine2Ptr).w,a0
	move.l	(a0),a0
	jmp	10(a0)




LoadNyNexCube:	bsr	TD_PrepRegs
	bsr	TD_MotorOn

	tst.b	(AGA_Chipset).w
	beq.b	.norm
	move.l	#512*60,d0	;size
	moveq	#%01,d1
* Type:	BIT0	= CLR=CHIP	SET=OTHER
* 	BIT1	= CLR=CLEAR MEM	SET=DON`T CLEAR MEM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	Push.l	d0
	move.l	d0,a0
	move.w	#594,d0
	moveq	#60,d1
	bra.b	.goon
.norm	move.l	#512*46,d0	;size
	moveq	#%01,d1
* Type:	BIT0	= CLR=CHIP	SET=OTHER
* 	BIT1	= CLR=CLEAR MEM	SET=DON`T CLEAR MEM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	Push.l	d0
	move.l	d0,a0
	move.w	#546,d0
	moveq	#46,d1
.goon	bsr	TD_PrepRegs
	bsr.w	TD_ReadSectors
	bsr	TD_MotorOff

	move.l	(sp)+,(Routine2Loc).w
	rts

InitNyNexCube:	move.l	(Routine2Loc).w,a0
	bsr.w	DeHunkPrg
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Routine2Ptr).w

	move.l	(Routine2Loc).w,d0
	move.l	#512*60,d1	;size
	tst.b	(AGA_Chipset).w
	bne.b	.ok
	move.l	#512*46,d1
.ok	bsr	FreeMem

	move.l	(Routine2Ptr).w,a0
	move.l	(a0),a0
	jmp	10(a0)




LoadMatildeCube:	bsr	TD_PrepRegs
	bsr	TD_MotorOn

	move.l	#512*41,d0	;size
	moveq	#%01,d1
* Type:	BIT0	= CLR=CHIP	SET=OTHER
* 	BIT1	= CLR=CLEAR MEM	SET=DON`T CLEAR MEM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	Push.l	d0
	move.l	d0,a0
	moveq	#41,d1
	tst.b	(AGA_Chipset).w
	beq.b	.norm
	move.w	#700,d0
	bra.b	.goon
.norm	move.w	#657,d0
.goon	bsr	TD_PrepRegs
	bsr.w	TD_ReadSectors
	bsr	TD_MotorOff

	move.l	(sp)+,(Routine2Loc).w
	rts

InitMatildeCube:	move.l	(Routine2Loc).w,a0
	bsr.w	DeHunkPrg
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Routine2Ptr).w

	move.l	(Routine2Loc).w,d0
	move.l	#512*41,d1	;size
	bsr	FreeMem

	move.l	(Routine2Ptr).w,a0
	move.l	(a0),a0
	jmp	10(a0)




LoadPong:	bsr	TD_PrepRegs
	bsr	TD_MotorOn

	move.l	#512*31,d0	;size
	moveq	#%01,d1
* Type:	BIT0	= CLR=CHIP	SET=OTHER
* 	BIT1	= CLR=CLEAR MEM	SET=DON`T CLEAR MEM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	Push.l	d0
	move.l	d0,a0
	moveq	#31,d1
	tst.b	(AGA_Chipset).w
	beq.b	.norm
	move.w	#776,d0
	bra.b	.goon
.norm	move.w	#743,d0
.goon	bsr	TD_PrepRegs
	bsr.w	TD_ReadSectors
	bsr	TD_MotorOff

	move.l	(sp)+,(Routine1Loc).w
	rts

InitPong:	move.l	(Routine1Loc).w,a0
	bsr.w	DeHunkPrg
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Routine1Ptr).w

	move.l	(Routine1Loc).w,d0
	move.l	#512*31,d1	;size
	bsr	FreeMem

	move.l	(Routine1Ptr).w,a0
	move.l	(a0),a0
	jmp	10(a0)




LoadEndPart:	bsr	TD_PrepRegs
	bsr	TD_MotorOn

	move.l	#512*21,d0	;size
	moveq	#%01,d1
* Type:	BIT0	= CLR=CHIP	SET=OTHER
* 	BIT1	= CLR=CLEAR MEM	SET=DON`T CLEAR MEM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	Push.l	d0
	move.l	d0,a0
	moveq	#21,d1
	tst.b	(AGA_Chipset).w
	beq.b	.norm
	move.w	#829,d0
	bra.b	.goon
.norm	move.w	#809,d0
.goon	bsr	TD_PrepRegs
	bsr.w	TD_ReadSectors
	bsr	TD_MotorOff

	move.l	(sp)+,(Routine1Loc).w
	rts

InitEndPart:	move.l	(Routine1Loc).w,a0
	bsr.w	DeHunkPrg
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Routine1Ptr).w

	move.l	(Routine1Loc).w,d0
	move.l	#512*21,d1	;size
	bsr	FreeMem

	move.l	(Routine1Ptr).w,a0
	move.l	(a0),a0
	jmp	10(a0)




LoadEndPicture:	bsr	TD_PrepRegs
	bsr	TD_MotorOn

	move.l	#512*96,d0	;size
	moveq	#%01,d1
* Type:	BIT0	= CLR=CHIP	SET=OTHER
* 	BIT1	= CLR=CLEAR MEM	SET=DON`T CLEAR MEM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	Push.l	d0
	move.l	d0,a0
	moveq	#96,d1
	move.w	#902,d0
	bsr	TD_PrepRegs
	bsr.w	TD_ReadSectors
	bsr	TD_MotorOff

	move.l	(sp)+,(Routine2Loc).w
	rts

InitEndPicture:	move.l	(Routine2Loc).w,a0
	bsr.w	DeHunkPrg
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Routine2Ptr).w

	move.l	(Routine2Loc).w,d0
	move.l	#512*96,d1	;size
	bsr	FreeMem

	move.l	(Routine2Ptr).w,a0
	move.l	(a0),a0
	jmp	10(a0)




LoadHidden1:	bsr	TD_PrepRegs
	bsr	TD_MotorOn

	move.l	#512*58,d0	;size
	moveq	#%01,d1
* Type:	BIT0	= CLR=CHIP	SET=OTHER
* 	BIT1	= CLR=CLEAR MEM	SET=DON`T CLEAR MEM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	Push.l	d0
	move.l	d0,a0
	moveq	#58,d1
	move.w	#1000,d0
	bsr	TD_PrepRegs
	bsr.w	TD_ReadSectors
	bsr	TD_MotorOff

	move.l	(sp)+,(Routine1Loc).w
	rts

InitHidden1:	move.l	(Routine1Loc).w,a0
	bsr.w	DeHunkPrg
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Routine1Ptr).w

	move.l	(Routine1Loc).w,d0
	move.l	#512*58,d1	;size
	bsr	FreeMem

	move.l	(Routine1Ptr).w,a0
	move.l	(a0),a0
	jmp	10(a0)




LoadHidden2:	bsr	TD_PrepRegs
	bsr	TD_MotorOn

	move.l	#512*107,d0	;size
	moveq	#%01,d1
* Type:	BIT0	= CLR=CHIP	SET=OTHER
* 	BIT1	= CLR=CLEAR MEM	SET=DON`T CLEAR MEM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	Push.l	d0
	move.l	d0,a0
	moveq	#107,d1
	move.w	#1060,d0
	bsr	TD_PrepRegs
	bsr.w	TD_ReadSectors
	bsr	TD_MotorOff

	move.l	(sp)+,(Routine2Loc).w
	rts

InitHidden2:	move.l	(Routine2Loc).w,a0
	bsr.w	DeHunkPrg
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Routine2Ptr).w

	move.l	(Routine2Loc).w,d0
	move.l	#512*107,d1	;size
	bsr	FreeMem

	move.l	(Routine2Ptr).w,a0
	move.l	(a0),a0
	jmp	10(a0)




WaitForFinish:	tst.b	$80.w
	beq.b	WaitForFinish
	clr.b	$80.w
	move.l	#Lev1Irq,$64.w
	rts


LoadMainModule:	bsr	TD_PrepRegs
	bsr	TD_MotorOn

	move.l	#MUSIC_LEN+16,d0	;size
	moveq	#%10,d1
* Type:	BIT0	= CLR=CHIP	SET=OTHER
* 	BIT1	= CLR=CLEAR MEM	SET=DON`T CLEAR MEM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(pr_module).w

	move.l	d0,a0
	moveq	#33,d0
	move.w	#181,d1
	bsr	TD_PrepRegs
	bsr.w	TD_ReadSectors
	bsr	TD_MotorOff

	move.l	(pr_module).w,a0
	lea	32(a0),a1
	move.l	a1,-(sp)
	bsr	NormalDecrunch
	move.l	(sp)+,(pr_module).w

	bra	pr_init





*******************************************************************************
**
**  Level 6 interrupt
**
*******************************************************************************
Lev6Irq:	btst	#13,Intreqr+_Custom
	beq.b	.out
**Lev1irq starter --------------------------------
**Lev1irq slutter --------------------------------
	move.w	#$2000,Intreq+_Custom
.out	rte

*******************************************************************************
**
**  Level 1 interrupt
**
*******************************************************************************
Lev1Irq:	btst	#2,Intreqr+1+_Custom
	beq.b	.out
	Push.l	d0-a6
**Lev1irq starter --------------------------------
**Lev1irq slutter --------------------------------
	Pull.l	d0-a6
	move.w	#$0004,Intreq+_Custom	;SOFTWARE interrupt
.out	rte

*******************************************************************************
**
**  Level 3 interrupt
**
*******************************************************************************
Lev3Irq:	st	(VBlank).w
	Push.l	d0-a6
	lea	_Custom,a6
	btst	#5,Intreqr+1(a6)
	beq.b	.out
**Lev3irq starter --------------------------------
	bsr	pr_music
**Lev3irq slutter --------------------------------
	move.w	#$0020,Intreq+_Custom
	move.w	#$8004,Intreq+_Custom	;SOFTWARE interrupt
.out	Pull.l	d0-a6
	rte

JumpCopper:	dc.w	CopJmp2,0

BlackCopper:
	dc.w	Bplcon0,$0200
	dc.w	Bplcon3,$0C40
	dc.w	Color00,$000
	dc.w	Bplcon3,$0E40
	dc.w	Color00,$000
	dc.l	-2

*******************************************************************************
**
**  Picture
**
*******************************************************************************
Picture:	dc.l	.pic
.pic	move.l	#PicIrq,(Lev1Base).w
	rts
	move.w	#1,(PicStatus).w
	lea	CatPlaner+2(pc),a0
	move.l	(PictureLocation).w,d0
	moveq	#3-1,d1
.loop	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	swap	d0
	addq.w	#8,a0
	add.l	#40,d0
	dbra	d1,.loop
	rts

PicIrq:	Push.l	d0-a6
**Lev1irq starter --------------------------------
	move.l	#CatCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	bsr	Piccie
**Lev1irq slutter --------------------------------
	Pull.l	d0-a6
	move.w	#$0004,Intreq+_Custom	;SOFTWARE interrupt
	rte


CatCopper:	dc.w	Ddfstrt,$0038
	dc.w	Ddfstop,$00d0
	dc.w	$1FC,$0000
	dc.w	Diwstrt,$2c81
	dc.w	Diwstop,$2cc1
	dc.w	Bpl1mod,40*2
	dc.w	Bpl2mod,40*2
CatPlaner:	dc.w	Bpl1pth,0,Bpl1ptl,0
	dc.w	Bpl2pth,0,Bpl2ptl,0
	dc.w	Bpl3pth,0,Bpl3ptl,0
	dc.w	Bplcon0,$3200
	dc.w	Bplcon1,$0000
	dc.w	Bplcon2,$0224
	dc.w	Bplcon3,$0E40
	dc.w	Color00,$000,Color01,$000,Color02,$000,Color03,$000
	dc.w	Color04,$000,Color05,$000,Color06,$000,Color07,$000
	dc.w	Bplcon3,$0C40
CatColors:	dc.w	Color00,$000,Color01,$000,Color02,$000,Color03,$000
	dc.w	Color04,$000,Color05,$000,Color06,$000,Color07,$000
	dc.w	Spr0pth,0,Spr0ptl,0
	dc.w	Spr1pth,0,Spr1ptl,0
	dc.w	Spr2pth,0,Spr2ptl,0
	dc.w	Spr3pth,0,Spr3ptl,0
	dc.w	Spr4pth,0,Spr4ptl,0
	dc.w	Spr5pth,0,Spr5ptl,0
	dc.w	Spr6pth,0,Spr6ptl,0
	dc.w	Spr7pth,0,Spr7ptl,0
	dc.l	-2



Piccie:	move.w	PicStatus(pc),d0
	beq.w	.out
	subq.w	#1,d0
	beq.b	.fadeup
	subq.w	#1,d0
	beq.b	.pause

.fadedown	lea	CatColors+2(pc),a0
	moveq	#8-1,d7
.colloop2	move.w	(a0),d0
	moveq	#0,d1
	bsr	fader
	move.w	d0,(a0)
	addq.w	#4,a0
	dbra	d7,.colloop2
	addq.w	#1,(FadeCounter).w
	cmp.w	#16,(FadeCounter).w
	bne.b	.out
	clr.w	(FadeCounter).w
	clr.w	(PicStatus).w
	st	$80.w
	rts

.pause	subq.w	#1,(PicPause).w
	bne.b	.out
	addq.w	#1,(PicStatus).w
	rts

.fadeup:	lea	CatColors+2(pc),a0
	lea	CatColorsBck(pc),a1
	moveq	#8-1,d7
.colloop1:	move.w	(a0),d0
	move.w	(a1)+,d1
	bsr	fader
	move.w	d0,(a0)
	addq.w	#4,a0
	dbra	d7,.colloop1
	addq.w	#1,(FadeCounter).w
	cmp.w	#16,(FadeCounter).w
	bne.b	.out
	clr.w	(FadeCounter).w
	addq.w	#1,(PicStatus).w
	move.w	#200,(PicPause).w
.out	rts

CatColorsBck:	dc.w	$310,$410,$420,$520
	dc.w	$000,$FFF,$87A,$436

**d0=fade from
**d1=fade to
**out: d0=newcol
**USES: d0-d3
fader:	move.w	d0,d2
	move.w	d1,d3
	lsr.w	#8,d2
	lsr.w	#8,d3
	cmp.w	d2,d3
	beq	.nored
	blt	.redsub
	add.w	#$100,d0
	bra	.nored
.redsub:	sub.w	#$100,d0
.nored:	move.w	d0,d2
	move.w	d1,d3
	lsr.w	#4,d2
	lsr.w	#4,d3
	and.w	#$f,d2
	and.w	#$f,d3
	cmp.w	d2,d3
	beq	.nogreen
	blt	.greensub
	add.w	#$10,d0
	bra	.nogreen
.greensub:	sub.w	#$10,d0
.nogreen:	move.w	d0,d2
	move.w	d1,d3
	and.w	#$f,d2
	and.w	#$f,d3
	cmp.w	d2,d3
	beq	.noblue
	blt	.bluesub
	addq.w	#$1,d0
	bra	.noblue
.bluesub:	subq.w	#$1,d0
.noblue:	rts



Needs1Mb:	bra.b	Needs1Mb

ShowGuru:	bra.b	ShowGuru

ShowReadError:	bra.b	ShowReadError

PANIC_NOMEM:	move.w	$dff006,$dff180
	bra.b	PANIC_NOMEM


*******************************************************************************
***                                                                         ***
***                     Non system dos disk controller!                     ***
***                                                                         ***
***-------------------------------------------------------------------------***
**                                                                           **
** To read a file do as follows:                                             **
**                                                                           **
** Call TD_Init before you do anything else.				     **
** Then let A0 point on the name of the file you want to load,		     **
** and let A1 point on the mem loc. you want to load at.		     **
** When you are finished with the drive call TD_Restore			     **
**                                                                           **
*******************************************************************************
TD_Sync 	=	$4489
TD_TrackPause	=	3000 ; micro sec

TD_PrepRegs:	lea	_Custom,a6
	lea	$BFD100,a5
	rts

>=============================================================================<
>                                   TD_Init                                   <
>-----------------------------------------------------------------------------<
>              This will init the FloppyDiskInterfaceController		      <
>                                                                             <
> IN:           A6 = _Customer                                                <
> IN:           A5 = $BFD100                                                  <
> TRASHES:      D0-D1                                                         <
> OUT:          non                                                           <
>=============================================================================<
TD_Init:	move.w	#TD_Sync,Dsksync(a6)	; 
	move.w	Adkconr(a6),TD_Adkcon	; Save system AdkCon
	move.w	#$7FFF,Adkcon(a6)	; Set,Precomp val=0,MFMPrec
	move.w	#$9500,Adkcon(a6)	; WordSync,Fast
	move.w	#$4000,Dsklen(a6)	; Reset DiskLen
	move.w	#$8010,Dmacon(a6)	; Start disk dma
	bsr.b	TD_MotorOn	; 
	moveq	#0,d0	; System head pos
.SeekZero:	btst	#4,$F01(a5)	; Track Zero ?
	beq.b	.TrackZero	; YES!
	bsr.w	TD_StepLower	; Move head towards zero
	addq.w	#1,d0	; 
	bra.b	.SeekZero	; 
.TrackZero	lsl.w	#1,d0	; 
	move.w	d0,TD_SysTrack	; 
	clr.w	TD_CurrentTrack	; Clr track pointer
	bra.w	TD_WaitForReady	; 
	bsr.b	TD_MotorOff	; 
	rts

>=============================================================================<
>                                 TD_Restore                                  <
>-----------------------------------------------------------------------------<
>             This will restore the FloppyDiskInterfaceController	      <
>                                                                             <
> IN:           A6 = _Custom                                                  <
> TRASHES:      D0-D1                                                         <
> OUT:          non                                                           <
>=============================================================================<
TD_Restore:	bsr	TD_PrepRegs
	bsr.b	TD_MotorOn	; 
	move.w	TD_SysTrack,d0	; 
	bsr.w	TD_SeekTrack	; 
	bsr.b	TD_MotorOff	; 

	move.w	#$7FFF,Adkcon(a6)	; Reset
	move.w	TD_Adkcon,d0	; Get system AdkCon
	or.w	#$8000,d0	; Set SET bit
	move.w	d0,Adkcon(a6)	; Restore system AdkCon
	move.w	#$4000,Dsklen(a6)	; Reset DiskLen
	move.w	#$0010,Dmacon(a6)	; Stop disk dma
	rts

>=============================================================================<
>                                 Start Motor                                 <
>-----------------------------------------------------------------------------<
>     Will start the motor on the selected drive, and wait for full speed     <
>                                                                             <
> IN:           A5 = $BFD100                                                  <
> TRASHES:      D0-D2                                                         <
> OUT:          non                                                           <
>=============================================================================<
TD_MotorOn:	move.w	#%01111001,d0	; /SEL3,/SEL2,/SEL1,/SEL0,/STEP
	move.w	TD_CurrentTrack,d1	; Cyl/Head
	and.w	#1,d1	; Mask Head thru
	eor.b	#1,d1	; Side 0 = Surface 1!
	lsl.w	#2,d1	; 
	or.w	d1,d0	; Set to right side
	move.w	d0,d1
	move.w	TD_DrevNr,d2	; Drive to use
	add.w	#3,d2	; 
	bclr	d2,d1	; 
	move.b	d0,(a5)	; 
	nop		; wait
	nop		;
	move.b	d1,(A5)	; Start drive
	bsr.w	TD_WaitForReady
	rts

>=============================================================================<
>                                 Stop Motor                                  <
>-----------------------------------------------------------------------------<
>                    Stops the motor of the selected drive                    <
>                                                                             <
> IN:           A5 = $BFD100                                                  <
> TRASHES:      D0-D2                                                         <
> OUT:          non                                                           <
>=============================================================================<
TD_MotorOff:	move.w	#%11111101,d0	; SEL3,SEL2,SEL1,SEL0,STEP
	move.w	d0,d1	;
	move.w	TD_DrevNr,d2	; 
	addq.w	#3,d2	; 
	bclr	d2,d1	; 
	move.b	d0,(a5)	; 
	nop		; 
	nop		; 
	move.b	d1,(a5)	; 
	nop		; 
	nop		; 
	move.b	d0,$bfd100	; 
	bsr.w	TD_Wait3miliSec	; 
	rts

>=============================================================================<
>                               Seek Track zero                               <
>-----------------------------------------------------------------------------<
>                        Moves the head to track zero                         <
>                                                                             <
> IN:           A5 = $BFD100                                                  <
> TRASHES:      none                                                          <
> OUT:          none                                                          <
>=============================================================================<
TD_SeekZero:	btst	#4,$F01(a5)	; Track Zero ?
	beq.b	.TrackZero	; YES!
	bsr.b	TD_StepLower	; Move head towards zero
	bra.b	TD_SeekZero	; 
.TrackZero	clr.w	TD_CurrentTrack	; Clr track pointer
	bra.w	TD_WaitForReady	; 

>=============================================================================<
>                                Seek a track                                 <
>-----------------------------------------------------------------------------<
>                    Moves the head to a determined track                     <
>                                                                             <
> IN:           A5 = $BFD100                                                  <
>               D0 = Destination track                                        <
> TRASHES:      none                                                          <
> OUT:	none                                                          <
>=============================================================================<
TD_SeekTrack:	Push.l	d0-a6
	move.w	TD_CurrentTrack,d1	; 
.TstTrack	cmp.w	d0,d1	; Have we reached the track?
	beq.b	.OnRightTrack	; YES!
	bls.b	.MoveUp	; Move head up
.MoveDown	subq.w	#1,d1	; 
	btst	#0,d1	; Test side
	beq.b	.TstTrack	; Head = 0
	bsr.b	TD_StepLower	; Move the head
	bra.b	.TstTrack	; and try again
.MoveUp	addq.w	#1,d1	;
	btst	#0,d1	; Test side 
	bne.b	.TstTrack	; Head = 0
	bsr.b	TD_StepHiger	; Move the head
	bra.b	.TstTrack	; and try again
.OnRightTrack	move.w	d0,TD_CurrentTrack	; 
	bsr.w	TD_MotorOn
	Pull.l	d0-a6
	rts

TD_StepLower:
	bset	#1,(a5)	; Stop lower (0)
	bra.b	TD_StepHead	; 
TD_StepHiger:
	bclr	#1,(a5)	; Stop higer (80)
TD_StepHead	bclr	#0,(a5)	; 
	bset	#0,(a5)	; STEP!
	Push.l	d0-d1	;
	move.w	#TD_TrackPause/64,d0	; wait ? micro sec.
	bsr.w	TD_WaitLines	; 
	bsr.w	TD_WaitForReady	; 
	Pull.l	d0-d1	; 
	rts		; 

>=============================================================================<
>                                 Read sectors                                <
>-----------------------------------------------------------------------------<
>                        Read an AmigaDOS V1.0 sectors                        <
>                                                                             <
> IN:           D0 = First sector to read                                     <
>               D1 = Number of sectors to read                                <
>               A0 = Add of dest mem                                          <
>	A6 = _Custom                                                  <
>               A5 = $BFD100                                                  <
> TRASHES:      none                                                          <
> OUT:          TD_ErrorCode = The error (if any)                             <
>=============================================================================<
TD_ReadSectors:
;	bsr	TD_MotorOn

	Push.l	d2
	bra.b	.InReadLoop
.ReadLoop
	bsr.b	TD_ReadSector

	addq.l	#1,d0
	move.l	TD_DosBufPtr(pc),a1
	moveq	#512/(4*4)-1,d2
.CopyLoop	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	dbf	d2,.CopyLoop

.InReadLoop	dbf	d1,.ReadLoop
	
	Pull.l	d2
;	bsr	TD_MotorOff
	rts	
>=============================================================================<
>                                 Read sector                                 <
>-----------------------------------------------------------------------------<
>                        Read an AmigaDOS V1.0 sector                         <
>                                                                             <
> IN:           D0 = Sector to read                                           <
>	A6 = _Custom                                                  <
>               A5 = $BFD100                                                  <
> TRASHES:      none                                                          <
> OUT:          TD_ErrorCode = The error (if any)                             <
>               TD_DosBufPtr = Pointer to sector loc!                         <
>=============================================================================<
TD_ReadSector:	Push.l	d0-a6
	ext.l	d0	; AND.l #$FFFF,d0
	divu	#11,d0	; D0 = Track
	cmp.w	TD_TrackInMem,d0	; 
	beq.b	.TrackInMem	; 
	move.w	d0,TD_TrackInMem	; 
	bsr.w	TD_SeekTrack	; 
	bsr.b	TD_ReadTrack	; 
	tst.w	TD_ErrorCode	; Read error?
	bne.b	.Error	; YES!
.TrackInMem	move.l	(sp),d0
	ext.l	d0	; AND.l #$FFFF,d0
	divu	#11,d0	; D0 = Track
	swap	d0	; 
	mulu	#512,d0	; 
	add.l	TD_LoadAdd,d0	;; 
	move.l	d0,TD_DosBufPtr	; 
	Pull.l	d0-a6
	rts		; 
.Error	move.w	#-1,TD_TrackInMem	; 
	Pull.l	d0-a6
	rts		; 

>=============================================================================<
>                                 Read track                                  <
>-----------------------------------------------------------------------------<
>                    Read and decode (MFM) an entire track                    <
>                                                                             <
> IN:           TD_LoadAdd = Dest add                                         <
>               A6 = _Custom                                                  <
>               A5 = $BFD100                                                  <
> TRASHES:      none                                                          <
> OUT:          TD_ErrorCode = The error (if any)                             <
>=============================================================================<
TD_ReadTrack:	Push.l	d0-a6	; Save regs
	move.w	TD_CurrentTrack,d1	; Track we are on
	move.w	#4,TD_NoOfTrys	; No of MAX read/write errors
.TryAgain:	lea	TD_CodeBuf,a1	; MFM data buffer
	clr.l	2(a1)	; first MFM Header
	move.l	a1,Dskpth(a6)	; 
	move.w	#$4000,Dsklen(a6)	; Reset DiskLen
	move.w	#$9C00,Dsklen(a6)	; (1024+64)*11+Gab (Gab=2048)
	move.w	#$9C00,Dsklen(a6)	; 
	move.w	#$0002,Intreq(a6)
.StillReading	btst	#1,Intreqr+1(a6)
	beq.b	.StillReading

	;move.w	#$4000,DskLen(A6)	; Reset DiskLen
	move.l	TD_LoadAdd,a0	; Decode data
	move.l	#$55555555,d0	; And value!
	moveq	#11-1,d7	; Number of sectors in track
.NextSector:	move.w	#TD_Sync,d1	; 
.NoSync:	cmp.l	#TD_CodeBuf+$3800,a1	; Check if end of MFM buffer!
	bhs.w	.PANICtoFewSec	; PANIC!
	cmp.w	(a1)+,d1	; Find first sync in sector!
	bne.b	.NoSync	; 
.SncAgn:	cmp.w	(a1)+,d1	; 
	beq.b	.SncAgn	; 
	lea	-2(a1),a1	; a1 points after last sync!
	move.l	(a1)+,d1	; Get Format,Track,Sec nr and
	move.l	(a1)+,d2	;  sec rest
	and.l	d0,d1	; 
	and.l	d0,d2	; 
	move.l	d1,d3	; d3 = Header check sum!
	eor.l	d2,d3	; d3 = Header check sum!
	lsl.l	#1,d1	; 
	or.l	d2,d1	; 
	move.l	d1,d2	; d2=Decode Header!
	swap	d2	; 
	and.w	#$FF,d2	; 
	cmp.w	TD_CurrentTrack,d2	; Check if right track!
	bne.b	.PANICwrongTrk	; PANIC!
	lsr.l	#8,d1	; 
	and.l	#$ff,d1	; d1.l = Sector nr.
	Moveq	#9,d2	;
	Lsl.l	d2,d1	; d1.l = 512*Sector nr.
	moveq	#8-1,d2	; Rest of header (to checksum)
.CheckLoop1	move.l	(a1)+,d4	; MFM data
	eor.l	d4,d3	; "ADD" MFM data to CheckSum
	dbf	d2,.CheckLoop1	; 
	move.l	(a1)+,d2	; Get right header CheckSum
	move.l	(a1)+,d4	; 
	and.l	d0,d2	; Decode
	and.l	d0,d4	; 
	lsl.l	#1,d2	; 
	or.l	d4,d2	; d2.l = Decodet Check
	eor.l	d2,d3	; Eor RightChk and CalcChk
	and.l	d0,d3	; "Decode"
	bne.b	.PANIChdrErr	; PANIC!!
	move.l	(a1)+,d3	; Get right sector ChkSum
	move.l	(a1)+,d2	; 
	and.l	d0,d3	; 
	and.l	d0,d2	; 
	lsl.l	#1,d3	; 
	or.l	d2,d3	; d3.l = Decodet BlockChkSum
	lea	(a0,d1.w),a3	; Dest buffer*Sec*512 
	moveq	#128-1,d4	; No. of longs to decode
.BlockDecode	move.l	512(a1),d1	; 
	move.l	(a1)+,d2	; 
	eor.l	d1,d3	; "ADD" to BlockChkSum
	eor.l	d2,d3	; "ADD" to BlockChkSum
	and.l	d0,d1	; Decode
	and.l	d0,d2	; 
	lsl.l	#1,d2	; 
	or.l	d1,d2	; 
	move.l	d2,(a3)+	; Write decode data
	dbf	d4,.BlockDecode	; Decode rest of Block
	and.l	d0,d3	; "Decode" BlockChkSum
	bne.b	.PANICblkErr	; PANIC!!
	lea	510(a1),a1	; 
	dbf	d7,.NextSector	; 
	clr.w	TD_ErrorCode	; 0=TrackOk >0=ReadWriteError
.ExitError	Pull.l	d0-a6	; Save regs
	rts

.PANICwrongTrk	move.w	#1,TD_ErrorCode	; 1 = Block header destroyed
	bra.b	.ContError	; Continue error process
.PANIChdrErr	move.w	#1,TD_ErrorCode	; 1 = Block header destroyed
	bra.b	.ContError	; Continue error process
.PANICblkErr	move.w	#2,TD_ErrorCode	; 2 = Block destroyed (chk)
	bra.b	.ContError	; Continue error process
.PANICtoFewSec	move.w	#3,TD_ErrorCode	; 3 = To few sectors
	bra.w	.ContError	; Continue error process

.ContError	subq.w	#1,TD_NoOfTrys
	beq.b	.ShitTrack	; Track total damaged!
	move.w	TD_CurrentTrack,d0	;
	Push.l	d0-a6
	bsr.w	TD_SeekZero	; Goto track #0
	Pull.l	d0-a6
	bsr.w	TD_SeekTrack	; Try again!
	bra.w	.TryAgain	; 

.ShitTrack	bra.w	ShowReadError

>=============================================================================<
>                                    Wait                                     <
>-----------------------------------------------------------------------------<
>                    Wait a number of selected scan lines                     <
>                                                                             <
> IN:           d0 = Number of scan lines to wait                             <
>               A6 = _Custom                                                  <
> TRASHES:      D1                                                            <
> OUT:          none                                                          <
>=============================================================================<
TD_Wait3miliSec:	moveq	#3000/64,d0	; wait 3000 micro sec.
	bra.w	TD_WaitLines	; 
TD_WaitLines:	subq.w	#1,d0	; 
.WaitLine2	move.b	VHPosr(a6),d1	; 
.WaitLine	cmp.b	VHPosr(a6),d1	; 
	beq.b	.WaitLine	; 
	dbf	d0,.WaitLine2	; 
	rts		; 

>=============================================================================<
>                               Wait for ready                                <
>-----------------------------------------------------------------------------<
>          Wait until the drive is known to be rotating at full speed         <
>                                                                             <
> IN:           A5 = $BFD100                                                  <
> TRASHES:      none                                                          <
> OUT:          none                                                          <
>=============================================================================<
TD_WaitForReady:btst	#5,$f01(a5)	; Test /RDY
	bne.b	TD_WaitForReady	;
	rts

TD_Adkcon:	dc.w	0	; System AdkCon
TD_CurrentTrack:dc.w	0	; Pointer on current track
TD_NoOfTrys:	dc.w	0	; 
TD_DrevNr:	dc.w	0	; 
TD_LoadAdd:	dc.l	0	; 
TD_SysTrack:	dc.w	0	; 
TD_TrackInMem:	dc.w	-1	; 
	dc.w	0
TD_DosBufPtr:	dc.l	0	; 

TD_ErrorCode:	dc.w	0	; 0 = No error

			; 1 = Block header destroyed
			; 2 = Block destroyed (chk)
			; 3 = To few sectors

>0-1-2-3-4-5-6-7-8-9-A-B-C-D-E-F-G--+--|--+--G-F-E-D-C-B-A-9-8-7-6-5-4-3-2-1-0<

******************************************************************************
*   ____    _____                                      ____    ____     ___   *
*  |    \  |         |     | |     | |\    | |  /     |    \  |    \   /   \  *
*  |     | |         |     | |     | | \   | | /      |     ) |     ) |       *
*  |     | |---   -- |-----| |     | |  \  | |/\      |____/  |____/  |  ___  *
*  |     | |         |     | |     | |   \ | |  \     |       |  \    |    |  *
*  |____/  |_____    |     | |_____| |    \| |   \    |       |   \    \___|  *
*                                                                             *
*******************************************************************************
* IN	a0=Address of program in memory
* 
* OUT	d0=Adress of AllocBuffer (auto de allocating!)
* 
DeHunkPrg:	movem.l	d1-d3/a0-a5,-(sp)
	cmp.l	#$3F3,(a0)		; check if header!
	bne.s	DHP_Error
	bra.s	DHP_NextHunk2
DHP_NextHunk:	tst.l	d3
	beq.s	DHP_AllOk
DHP_NextHunk2:	move.l	(a0)+,d0
	cmp.l	#$3F3,d0		; hunk_header
	beq.w	DHP_hunk_header
	cmp.l	#$3e9,d0		; hunk_code
	beq.s	DHP_hunk_code
	cmp.l	#$3ea,d0		; hunk_data
	beq.s	DHP_hunk_data
	cmp.l	#$3eb,d0		; hunk_bss
	beq.s	DHP_hunk_bss

DHP_Error:	illegal
	

DHP_AllOk:	move.l	#1024,d0		; SIZE 1K
	moveq	#1,d1			; TYPE MixM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	lea	HunkBuffer(pc),a0
	move.l	d0,a1
	move.l	#256-1,d2
.loop	move.l	(a0)+,d3		; get size
	move.l	(A0)+,(a1)+		; get and store add
	move.l	d3,(a1)+		; store size
	dbf	d2,.loop
	movem.l	(sp)+,d1-d3/a0-a5
	rts
DHP_hunk_data:
DHP_hunk_code:	move.l	(a0)+,d0		; size of hunk!
	tst.l	(a1)+
	move.l	(a1)+,a3		; dest add
	bra.s	.BLoop
.Loop	move.l	(a0)+,(a3)+
.BLoop	dbf	d0,.Loop
	cmp.l	#$3ec,(a0)
	bne.s	.NoRelocTab
	bsr.b	DHP_hunk_reloc32
.NoRelocTab	cmp.l	#$3f2,(a0)+
	bne.s	DHP_Error		; NoHunkEnd ???
	subq.l	#1,d3			; RestHunk=RestHunk-1
	bra.s	DHP_NextHunk
DHP_hunk_bss	move.l	(a0)+,d0		; size of hunk!
	tst.l	(a1)+
	move.l	(a1)+,a3		; dest add
	bra.s	.BLoop
.Loop	clr.l	(a3)+
.BLoop	dbf	d0,.Loop
	cmp.l	#$3f2,(a0)+		; END?
	bne.s	DHP_Error		; NoHunkEnd ???
	subq.l	#1,d3			; RestHunk=RestHunk-1
	bra.w	DHP_NextHunk
DHP_hunk_reloc32:
	move.l	-4(a1),a4		; HUNK TO BE CORRECTED
	tst.l	(a0)+			; SKIP $3EC.l
.Loop2	move.l	(a0)+,d0		; number of offsets
	beq.s	.LastSection
	move.l	(a0)+,d1		; hunk number
	lsl.l	#3,d1
	move.l	4(a2,d1.l),d2		; MainAddOfHunk
	bra.s	.BLoop
.Loop	move.l	(a0)+,d1
	lea	(a4,d1.l),a5		; add to be corrected
	add.l	d2,(a5)
.BLoop	dbf	d0,.Loop
	bra.s	.Loop2
.LastSection	rts

DHP_hunk_header	lea	HunkBuffer(pc),a1
	moveq	#0,d0			; clr hun buffer!
.loop	clr.l	(a1,d0.w)
	addq.w	#4,d0
	cmp.w	#20*4,d0
	bne.s	.loop
.loop2	tst.l	(a0)+			; skip hunk names!
	bne.s	.loop2
	move.l	(a0)+,d2		; number of hunks
	move.l	d2,d3			; number of hunks
	addq.l	#8,a0			; skip hunk numbers
	bra.s	.BLoop3
.loop3	move.l	(a0)+,d1		; hunk size
	moveq	#0,d0
	move.l	d1,d0
	add.l	d0,d0
	add.l	d0,d0			; d2=size in bytes!
	clr.w	d1
	bclr	#30,d1
	bne.s	.Chip
	bset	#0,d1			; TYPE=FAST
.Chip	move.l	d0,(a1)+		; save size
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(a1)+		; save add
.BLoop3	dbf	d2,.loop3
	lea	HunkBuffer(pc),a1
	move.l	a1,a2
	bra.w	DHP_NextHunk
		
HunkBuffer:	blk.l	128*2,0			; _MAX_ 1228 hunks!!!!!!!!

*******************************************************************************
*      _____  ____    _____  _____                                   ____     *
*     |      |    \  |      |         |     | |     | |\    | |  /  /         *
*     |      |     | |      |         |     | |     | | \   | | /   \___      *
*     |---   |____/  |---   |---      |-----| |     | |  \  | |/\       \     *
*     |      |   \   |      |         |     | |     | |   \ | |  \       )    *
*     |      |    \  |_____ |_____    |     | |_____| |    \| |   \ ____/     *
*                                                                             *
*******************************************************************************
* IN	d0=Address of AllocBuffer
* 
FreeHunks:	movem.l	d1-d2/a0,-(sp)
	move.l	d0,a0
	move.l	d0,d2
.Loop	move.l	(a0)+,d0		; add of chunk
	beq.s	.LastChunk
	move.l	(a0)+,d1		; size of chunk
	bsr.w	FreeMem
	bra.s	.Loop
.LastChunk	move.l	d2,d0			; add of buffer
	move.l	#1024,d1		; size of buffer
	bsr.w	FreeMem
	movem.l	(sp)+,d1-d2/a0
	rts
*******************************************************************************
*                              _____   _____                _____             *
*        /\     |      |      |     | |           |\    /| |      |\    /|    *
*       /  \    |      |      |     | |           | \  / | |      | \  / |    *
*      /____\   |      |      |     | |           |  \/  | |---   |  \/  |    *
*     /      \  |      |      |     | |           |      | |      |      |    *
*    /        \ |_____ |_____ |_____| |_____      |      | |_____ |      |    *
*                                                                             *
*******************************************************************************
* IN	d0=Size of chunk (in bytes)
* 	d1=Type
* OUT	d0=result
* 
* Type:	BIT0	= CLR=CHIP		SET=OTHER
* 	BIT1	= CLR=CLEAR MEM		SET=DON`T CLEAR MEM
* 

AllocMem:	movem.l	d2-d5/a0-a1,-(sp)
	lea	ResChipBuffer(pc),a0
	btst	#0,d1
	beq.s	.GetChip
	lea	ResMixMBuffer(pc),a0
.GetChip	add.l	#1023,d0
	lsr.l	#8,d0
	lsr.l	#2,d0
	lea	8(a0),a1	; start add
	moveq	#0,d1		; start chunk nr
	move.l	4(a0),d2
	sub.l	(a0),d2
	lsr.l	#8,d2
	lsr.l	#2,d2		; size of module
.TryAgain	bsr.b	.FindChunk
	bmi.s	.ErrorNoMem
	cmp.l	d0,d3
	bmi.s	.TryAgain
	bsr.b	.AllocChunk
	lsl.l	#8,d5
	lsl.l	#2,d5
	add.l	(a0),d5
	move.l	d5,d0
.out	movem.l	(sp)+,d2-d5/a0-a1
	rts
.ErrorNoMem:	moveq	#0,d0
	beq.b	.out

.FindChunk	moveq	#0,d3		; found size
.FC_loop1	cmp.l	d2,d1
	beq.s	.FC_Out2
	move.l	d1,d4		; byteadd
	lsr.l	#3,d4
	btst	d1,(a1,d4.l)
	beq.s	.FC_loop2S
	addq.l	#1,d1
	bra.s	.FC_loop1
.FC_loop2S	move.l	d1,d5
.FC_loop2	cmp.l	d2,d1
	beq.s	.FC_Out
	move.l	d1,d4		; byteadd
	lsr.l	#3,d4
	btst	d1,(a1,d4.l)
	bne.s	.FC_Out
	addq.l	#1,d1
	addq.l	#1,d3
	bra.s	.FC_loop2
.FC_Out2	moveq	#-1,d3
.FC_Out	rts

.AllocChunk	move.l	d5,d2
	bra.s	.AC_StartLoop
.AC_loop	move.l	d2,d4		; byteadd
	lsr.l	#3,d4
	btst	d2,(a1,d4.l)
	bne.b	.PANIC
	bset	d2,(a1,d4.l)
	addq.l	#1,d2
.AC_StartLoop	dbf	d0,.AC_loop
	rts
.PANIC	illegal

*******************************************************************************
*           _____  ____    _____  _____               _____                   *
*          |      |    \  |      |          |\    /| |      |\    /|          *
*          |      |     ) |      |          | \  / | |      | \  / |          *
*          |---   |____/  |---   |---       |  \/  | |---   |  \/  |          *
*          |      |   \   |      |          |      | |      |      |          *
*          |      |    \  |_____ |_____     |      | |_____ |      |          *
*                                                                             *
*******************************************************************************
* IN	d0=Add of chunk
* 	d1=Size of chunk (in bytes)
* 
Freeerror:	dc.w	0
FreeMem:	movem.l	d2-d3/a0,-(sp)
	lea	ResChipBuffer(pc),a0
	bsr.s	.ChechModule
	beq.s	.FoundModule
	lea	ResMixMBuffer(pc),a0
	bsr.s	.ChechModule
	beq.s	.FoundModule
	movem.l	(sp)+,d2-d3/a0
	rts
.Error	illegal
.FoundModule	move.l	d0,d3
	sub.l	(a0),d0
	add.l	d1,d3
	cmp.l	4(a0),d3
	bhi.s	.Error		; branch if Add+Size>UpperBorder
	lsr.l	#8,d0
	lsr.l	#2,d0		; d0 = pointer
	add.l	#1023,d1
	lsr.l	#8,d1
	lsr.l	#2,d1		; d1=size in 1024blocks
	lea	8(a0),a0
	bra.s	.StartLoop
.loop	move.l	d0,d2		; byteadd
	lsr.l	#3,d2
	bclr	d0,(a0,d2.l)
	beq.s	.Error
	addq.l	#1,d0
.StartLoop	dbf	d1,.loop
	movem.l	(sp)+,d2-d3/a0
	rts
.ChechModule	move.l	(a0),d2
	cmp.l	d2,d0
	blo.s	.NotThisModule
	move.l	4(a0),d2
	cmp.l	d2,d0
	bhi.s	.NotThisModule
	moveq	#0,d2
	rts
.NotThisModule	moveq	#-1,d2
	rts


**-----------------------------------------------------------
** Jump here to decrunch some data without any overlap checks
** The Regs have to loaded with:
** a0: Adr of Source (with Header)
** a1: Adr of Dest
**-----------------------------------------------------------
NormalDecrunch:
	movem.l	d0-d7/a0-a6,-(sp)
	cmp.l	#"CrM!",(a0)+
	bne.s	.NotCrunched
	tst.w	(a0)+		;skip MinSecDist
	move.l	(a0)+,d1	;OrgLen
	move.l	(a0)+,d2	;CrLen
	move.l	a0,a2
	bsr.s	FastDecruncher
.NotCrunched:
	movem.l	(sp)+,d0-d7/a0-a6
	rts
**-------------------------------------------------------------------
** This is the pure Decrunch-Routine
** The Registers have to be loaded with the following values:
** a1: Adr of Destination (normal)	** a2: Adr of Source (packed)
** d1: Len of Destination		** d2: Len of Source
**-------------------------------------------------------------------
FastDecruncher:
	move.l	a1,a5			;Decrunched Anfang (hier Ende des Decrunchens)
	add.l	d1,a1
	add.l	d2,a2
	move.w	-(a2),d0		;Anz Bits in letztem Wort
	move.l	-(a2),d6		;1.LW
	moveq	#16,d7			;Anz Bits
	sub.w	d0,d7			;Anz Bits, die rotiert werden mssen
	lsr.l	d7,d6			;1.Bits an Anfang bringen
	move.w	d0,d7			;Anz Bits, die noch im Wort sind
	moveq	#16,d3
	moveq	#0,d4
.DecrLoop:
	cmp.l	a5,a1
	ble.L	.DecrEnd		;a1=a5: fertig (a1<a5: eigentlich Fehler)

	bsr.s	.BitTest
	bcc.s	.InsertSeq		;1.Bit 0: Sequenz
	moveq	#0,d4
** einzelne Bytes einfgen **
.InsertBytes:
	moveq	#8,d1
	bsr.w	.GetBits
	move.b	d0,-(a1)
	dbf	d4,.InsertBytes
	bra.s	.DecrLoop
*------------
.SpecialInsert:
	moveq	#14,d4
	moveq	#5,d1
	bsr.s	.BitTest
	bcs.s	.IB1
	moveq	#14,d1
.IB1:	bsr.s	.GetBits
	add.w	d0,d4
	bra.s	.InsertBytes
*------------
.InsertSeq:
** Anzahl der gleichen Bits holen **
	bsr.s	.BitTest
	bcs.s	.AB1
	moveq	#1,d1			;Maske: 0 (1 AB)
	moveq	#1,d4			;normal: Summe 1
	bra.s	.ABGet
.AB1:
	bsr.s	.BitTest
	bcs.s	.AB2
	moveq	#2,d1			;Maske: 01 (2 ABs)
	moveq	#3,d4			;ab hier: Summe mindestens 3
	bra.s	.ABGet
.AB2:
	bsr.s	.BitTest
	bcs.s	.AB3
	moveq	#4,d1			;Maske: 011 (4 ABs)
	moveq	#7,d4			;hier: Summe 11
	bra.s	.ABGet
.AB3:
	moveq	#8,d1			;Maske: 111 (8 ABs)
	moveq	#$17,d4			;hier: Summe 11
.ABGet:
	bsr.s	.GetBits
	add.w	d0,d4			;d0: Lnge der Sequenz - 1
	cmp.w	#22,d4
	beq.s	.SpecialInsert
	blt.s	.Cont
	subq.w	#1,d4
.Cont:
** SequenzAnbstand holen **
	bsr.s	.BitTest
	bcs.s	.DB1
	moveq	#9,d1			;Maske: 0 (9 DBs)
	moveq	#$20,d2
	bra.s	.DBGet
.DB1:
	bsr.s	.BitTest
	bcs.s	.DB2
	moveq	#5,d1			;Maske: 01 (5 DBs)
	moveq	#0,d2
	bra.s	.DBGet
.DB2:
	moveq	#14,d1			;Maske: 11 (12 DBs)
	move.w	#$220,d2
.DBGet:
	bsr.s	.GetBits
	add.w	d2,d0
	lea	0(a1,d0.w),a3		;a3 auf Anf zu kopierender Seq setzten
.InsSeqLoop:
	move.b	-(a3),-(a1)		;Byte kopieren
	dbf	d4,.InsSeqLoop

	bra.w	.DecrLoop
*------------
.BitTest:
	subq.w	#1,d7
	bne.s	.BTNoLoop
	moveq	#16,d7			;hier kein add notwendig: d7 vorher 0
	move.w	d6,d0
	lsr.l	#1,d6			;Bit rausschieben und Flags setzen
	swap	d6			;ror.l	#16,d6
	move.w	-(a2),d6		;nchstes Wort holen
	swap	d6			;rol.l	#16,d6
	lsr.w	#1,d0			;Bit rausschieben und Flags setzen
	rts
.BTNoLoop:
	lsr.l	#1,d6			;Bit rausschieben und Flags setzen
	rts
*----------
.GetBits:				;d1:AnzBits->d0:Bits
	move.w	d6,d0			;d6:Akt Wort
	lsr.l	d1,d6			;nchste Bits nach vorne bringen
	sub.w	d1,d7			;d7:Anz Bits, die noch im Wort sind
	bgt.s	.GBNoLoop
;	add.w	#16,d7			;BitCounter korrigieren
	add.w	d3,d7			;BitCounter korrigieren
	ror.l	d7,d6			;restliche Bits re rausschieben
	move.w	-(a2),d6		;nchstes Wort holen
	rol.l	d7,d6			;und zurckrotieren
.GBNoLoop:
	add.w	d1,d1			;*2 (in Tab sind Ws)
	and.w	.AndData-2(pc,d1.w),d0	;unerwnschte Bits rausschmeien
	rts
*----------
.AndData:
	dc.w	%1,%11,%111,%1111,%11111,%111111,%1111111
	dc.w	%11111111,%111111111,%1111111111
	dc.w	%11111111111,%111111111111
	dc.w	%1111111111111,%11111111111111
*-----------
.DecrEnd:
	rts		;a5: Start of decrunched Data


*****************************************
*					*
* PRORUNNER V2.0			*
* --------------			*
* CODED BY COSMOS OF SANITY IN 1992	*
*					*
*****************************************
*					*
* Supporting the following effects:	*
*					*
*	- Running with 68010/20/30/40	*
*	- Using VBR-register		*
*	- Packed/Normal PT-Moduleformat	*
*	- Fade Sound in/out		*
*	- Variable Musicfadespeed	*
*	- Variable Interrupt-timing	*
*	- Finetune			*
*	- Normal play or Arpeggio	*
*	- Slide Frequenz up		*
*	- Slide	Frequenz down		*
*	- Tone Portamento		*
*	- Vibrato			*
*	- Tone Portamento+Volume Slide	*
*	- Vibrato + Volume Slide	*
*	- Tremolo			*
*	- Set SampleOffset		*
*	- Volume Slide			*
*	- Position Jump			*
*	- Set Volume			*
*	- Pattern Break			*
*	- Set Speed			*
* - E-Commands:				*
*	- Set Filter			*
*	- Fine Slide Up			*
*	- Fine Slide Down		*
*	- Glissando Control		*
*	- Set Vibrato Waveform		*
*	- Set Finetune			*
*	- Set Loop / Jump to Loop	*
*	- Set Tremolo Waveform		*
*	- Retrig Note			*
*	- Fine VolumeSlide Up		*
*	- Fine VolumeSlide Down		*
*	- NoteCut			*
*	- NoteDelay			*
*	- PatternDelay			*
*	- FunkRepeat			*
*					*
*****************************************

YES				EQU	1
NO				EQU	0
INCLUDEFADINGROUTINE		EQU	NO
PACKEDSONGFORMAT		EQU	YES
FADINGSTEPS			EQU	6	; ( 0< FADINGSTEPS <9 )
MAXVOLUME			EQU	2^FADINGSTEPS
INTERRUPTTIME			EQU	$180

SAMPLELENGTHOFFSET		EQU	4
SAMPLEVOLUMEOFFSET		EQU	6
SAMPLEREPEATPOINTOFFSET		EQU	8
SAMPLEWITHLOOP			EQU	12
SAMPLEREPEATLENGTHOFFSET	EQU	14
SAMPLEFINETUNEOFFSET		EQU	16

* Init-Routine *******************************************************

pr_init:
	move.w	#6,(pr_speed)
	move.w	#128,(pr_Patternpositions)
	move.w	#1,(pr_Channel0)
	move.w	#1,(pr_Channel1)
	move.w	#1,(pr_Channel2)
	move.w	#1,(pr_Channel3)
	move.w	#$8000,(pr_dmacon)

	lea	pr_framecounter(pc),a6
	move.w	#$7fff,pr_oldledvalue-pr_framecounter(a6)
	move.l	pr_module(pc),a0
	cmp.l	#0,a0
	bne.s	pr_init1
	rts
pr_init1:
	IFEQ	PACKEDSONGFORMAT-YES
	cmp.l	#'SNT!',(a0)
	beq.s	pr_init2
	ELSE
	cmp.l	#'M.K.',1080(a0)
	beq.s	pr_init2
	cmp.l	#'SNT.',1080(a0)
	beq.s	pr_init2
	ENDC
	rts
pr_init2:
	IFEQ	PACKEDSONGFORMAT-YES
	lea	8(a0),a1
	ELSE
	lea	20(a0),a1
	ENDC
	lea	pr_Sampleinfos(pc),a2
	moveq.l	#32,d7
	moveq	#30,d0
pr_init3:
	IFNE	PACKEDSONGFORMAT-YES
	lea	22(a1),a1		; Samplenamen berspringen
	ENDC
	move.w	(a1)+,SAMPLELENGTHOFFSET(a2)	; Samplelength in Words
	lea	pr_periods(pc),a3
	moveq	#$f,d2
	and.b	(a1)+,d2		; Finetuning
	mulu.w	#36*2,d2
	add.l	d2,a3
	move.l	a3,SAMPLEFINETUNEOFFSET(a2)
	moveq	#0,d1
	move.b	(a1)+,d1
	move.w	d1,SAMPLEVOLUMEOFFSET(a2)	; Volume
	moveq.l	#0,d1
	move.w	(a1)+,d1		; Repeatpoint in Bytes
	add.l	d1,d1
	move.l	d1,SAMPLEREPEATPOINTOFFSET(a2)
	move.w	(a1)+,d1
	clr.w	SAMPLEWITHLOOP(a2)
	cmp.w	#1,d1
	bls.s	pr_init3_2
	addq.w	#1,SAMPLEWITHLOOP(a2)
pr_init3_2:
	move.w	d1,SAMPLEREPEATLENGTHOFFSET(a2)	; Repeatlength
	add.l	d7,a2
	dbf	d0,pr_init3

	moveq	#0,d0
	IFEQ	PACKEDSONGFORMAT-YES
	move.b	256(a0),d0
	ELSE
	move.b	950(a0),d0		; Number of patterns
	ENDC
	subq.w	#1,d0
	move.w	d0,pr_highestpattern-pr_framecounter(a6)
	moveq.l	#0,d1
	lea	pr_Patternpositions(pc),a3
	IFEQ	PACKEDSONGFORMAT-YES
	lea	258(a0),a1		; 1.Patternpos
	lea	770(a0),a2		; 1.Patterndata
	lea	642(a0),a4		; 1.Patternoffset
pr_init4:
	moveq.l	#0,d2
	move.b	(a1)+,d2
	add.w	d2,d2
	move.w	(a4,d2.w),d2
	add.l	a2,d2
	move.l	d2,(a3)+
	dbf	d0,pr_init4
	ELSE
	lea	952(a0),a1		; 1. Patternpos
	lea	1084(a0),a2		; 1. Patterndata
pr_init4:
	move.b	(a1)+,d2		; x. Patternpos
	moveq.l	#0,d3
	move.b	d2,d3
	mulu.w	#1024,d3
	add.l	a2,d3
	move.l	d3,(a3)+
	dbf	d0,pr_init4
	ENDC

	IFEQ	PACKEDSONGFORMAT-YES
	move.l	4(a0),d2
	add.l	a0,d2
	ELSE
	lea	952(a0),a1
	moveq.l	#0,d1
	moveq	#127,d0
pr_init4_1:
	move.b	(a1)+,d2
	cmp.b	d1,d2			; Highest Pattern ?
	bls.s	pr_init4_2
	move.b	d2,d1
pr_init4_2:
	dbf	d0,pr_init4_1
	addq.w	#1,d1
	move.l	a0,d2
	mulu.w	#1024,d1		; Highest Pattern * 1024 Bytes
	add.l	#1084,d2
	add.l	d1,d2
	ENDC
	lea	pr_Sampleinfos(pc),a3
	lea	pr_Sampleinfos+SAMPLELENGTHOFFSET(pc),a2
	moveq.l	#32,d7
	move.l	d2,(a3)
	moveq	#29,d0
pr_init4_3:
	move.l	(a3),d1
	add.l	d7,a3
	moveq.l	#0,d2
	move.w	(a2),d2
	add.l	d7,a2
	add.l	d2,d2
	add.l	d2,d1
	move.l	d1,(a3)
	dbf	d0,pr_init4_3

	lea	pr_Sampleinfos(pc),a2
	lea	pr_Sampleinfos+SAMPLEREPEATPOINTOFFSET(pc),a3
	moveq.l	#32,d7
	moveq	#30,d0
pr_init4_4:
	move.l	(a2),d1
	add.l	d1,(a3)
	add.l	d7,a2
	add.l	d7,a3
	dbf	d0,pr_init4_4
	
	IFNE	PACKEDSONGFORMAT-YES
	
	cmp.l	#'SNT.',1080(a0)
	beq.s	pr_init7
	
	lea	1084(a0),a1
	move.l	pr_Sampleinfos(pc),a2
	move.b	#$f0,d6
	move.w	#$fff,d7
pr_init5:
	move.b	(a1),d0
	move.b	2(a1),d1
	move.w	(a1),d2
	and.w	d7,2(a1)
	and.w	d7,d2
	
	and.b	d6,d0
	lsr.b	#4,d1
	or.b	d1,d0
	move.b	d0,(a1)
	
	tst.w	d2
	beq.s	pr_init5_3
	lea	pr_periods(pc),a4
	moveq	#0,d1
pr_init5_2:
	addq.w	#1,d1
	cmp.w	(a4)+,d2
	bne.s	pr_init5_2
	move.b	d1,1(a1)
pr_init5_3:
	cmp.b	#$d,2(a1)
	bne.s	pr_init5_4

	moveq	#0,d1
	move.b	3(a1),d1
	moveq	#$f,d2
	and.w	d1,d2
	lsr.w	#4,d1
	mulu.w	#10,d1
	add.w	d2,d1
	cmp.b	#63,d1
	bls.s	pr_init5_3_2
	moveq	#63,d1
pr_init5_3_2:
	move.b	d1,3(a1)
pr_init5_4:
	addq.l	#4,a1
	cmp.l	a2,a1
	blt.s	pr_init5	

	move.l	#'SNT.',1080(a0)

	ENDC
	
pr_init7:
	lea	pr_Arpeggiofastlist(pc),a2
	lea	pr_Arpeggiofastlistperiods(pc),a1
	lea	35*2(a1),a1		; to the end of list...
	moveq	#0,d0
	moveq	#35,d1
	move.w	#999,d2
	moveq	#0,d6
pr_init8:
	move.w	-(a1),d7
	addq.w	#1,d6
pr_init8_2:
	cmp.w	d7,d0
	blt.s	pr_init8_4
	subq.w	#1,d1
	tst.b	d1
	bne.s	pr_init8
pr_init8_3:
	move.b	d1,(a2)+
	dbf	d2,pr_init8_3
	bra.s	pr_init8_5	
pr_init8_4:
	move.b	d1,(a2)+
	addq.w	#1,d0
	dbf	d2,pr_init8_2
pr_init8_5:

	lea	pr_Channel0(pc),a1
	move.w	#1,pr_Channel1-pr_Channel0(a1)
	move.w	#1,pr_Channel2-pr_Channel0(a1)
	move.w	#1,pr_Channel3-pr_Channel0(a1)
	move.w	#1,(a1)+
	moveq	#(pr_Channel1-pr_Channel0)/2-2,d0
pr_init9_2:
	clr.w	pr_Channel1-pr_Channel0(a1)
	clr.w	pr_Channel2-pr_Channel0(a1)
	clr.w	pr_Channel3-pr_Channel0(a1)
	clr.w	(a1)+
	dbf	d0,pr_init9_2

	lea	pr_fastperiodlist(pc),a1
	lea	pr_periods(pc),a2
	move.l	a2,(a1)
	moveq.l	#36*2,d1
	moveq	#14,d0
pr_init9_3:
	move.l	(a1)+,d2
	add.l	d1,d2
	move.l	d2,(a1)
	dbf	d0,pr_init9_3
		
	lea	pr_Arpeggiofastdivisionlist(pc),a1
	moveq	#0,d1
	move.w	#$ff,d0
pr_init9_4:
	move.b	d1,(a1)+
	subq.b	#1,d1
	bpl.s	pr_init9_4_2
	moveq	#2,d1
pr_init9_4_2:
	dbf	d0,pr_init9_4
	
	move.w	#6,pr_speed-pr_framecounter(a6)
	move.w	pr_speed(pc),(a6)
	clr.w	pr_Patternct-pr_framecounter(a6)
	move.w	pr_highestpattern(pc),d0
	move.w	pr_startposition(pc),d1
	blt.s	pr_init9_5
	cmp.w	d0,d1
	bls.s	pr_init9_5_2
pr_init9_5:
	clr.w	pr_startposition-pr_framecounter(a6)
pr_init9_5_2:
	move.w	pr_startposition(pc),pr_currentpattern-pr_framecounter(a6)
	
	lea	pr_Patternpositions(pc),a3
	move.l	a3,d0
	moveq.l	#0,d1
	move.w	pr_startposition(pc),d1
	lsl.l	#2,d1
	add.l	d1,d0
	move.l	d0,pr_Patternpt-pr_framecounter(a6)
	move.l	pr_Patternpt(pc),a5
	move.l	(a5),pr_Currentposition-pr_framecounter(a6)
	
	lea	$dff000,a5
	lea	$bfd000,a0
	move.w	#$2000,d0
	move.w	d0,$9a(a5)
	move.w	d0,$9c(a5)
	
	lea	pr_int(pc),a1
	move.l	pr_Vectorbasept(pc),a3
	move.l	a1,$78(a3)

	move.b	#$7f,$d00(a0)
	move.b	#$08,$e00(a0)
	move.w	#INTERRUPTTIME,d0
	move.b	d0,$400(a0)
	lsr.w	#8,d0
	move.b	d0,$500(a0)
pr_init10:
	btst	#0,$bfdd00
	beq.s	pr_init10
	move.b	#$81,$d00(a0)
	move.w	#$2000,$9c(a5)
	move.w	#$a000,$9a(a5)
	move.w	#$f,$96(a5)
	move.w	#$8000,pr_dmacon-pr_framecounter(a6)
	clr.w	$a8(a5)
	clr.w	$b8(a5)
	clr.w	$c8(a5)
	clr.w	$d8(a5)
	moveq	#0,d0
	move.b	$bfe001,d0
	move.w	d0,pr_oldledvalue-pr_framecounter(a6)
	bset	#1,$bfe001
	rts

* End-Routine *********************************************************

pr_end:
	lea	$dff000,a5
	move.w	#$f,$96(a5)
	clr.w	$a8(a5)
	clr.w	$b8(a5)
	clr.w	$c8(a5)
	clr.w	$d8(a5)
	move.w	#$2000,$9a(a5)
	move.w	pr_oldledvalue(pc),d0
	cmp.w	#$7fff,d0
	beq.s	pr_end3
	btst	#1,d0
	beq.s	pr_end2
	bset	#1,$bfe001
	rts
pr_end2:
	bclr	#1,$bfe001
pr_end3:
	rts

* Music-Fading ********************************************************

	IFEQ	INCLUDEFADINGROUTINE-YES
pr_fademusic:	macro
	lea	pr_musicfadect(pc),a0
	move.w	pr_musicfadedirection(pc),d0
	add.w	d0,(a0)
	cmp.w	#MAXVOLUME,(a0)
	bls.s	pr_fademusicend
	bgt.s	pr_fademusictoohigh
	clr.w	(a0)
	clr.w	pr_musicfadedirection-pr_musicfadect(a0)
	rts
pr_fademusictoohigh:
	move.w	#MAXVOLUME,(a0)
	clr.w	pr_musicfadedirection-pr_musicfadect(a0)
pr_fademusicend:
	endm

pr_musicfadect:		dc.w	MAXVOLUME
pr_musicfadedirection:	dc.w	0
	ENDC
	
* MACROS **************************************************************

pr_playchannel:	macro				; do not change: d7,a2-a6
		moveq	#0,d2
		moveq	#0,d0
		moveq	#0,d1
		IFEQ	PACKEDSONGFORMAT-YES
		move.b	(a6),d6
		bpl.s	.pr_playchannel1
		btst	#6,d6
		bne.s	.pr_playchannel0
		subq.l	#2,a6
		clr.w	4(a4)
		bra.s	.pr_playchannelend
.pr_playchannel0:		
		subq.l	#2,a6
		move.b	56(a4),d0
		move.b	57(a4),d1
		move.b	58(a4),d2
		move.w	58(a4),4(a4)
		bra.s	.pr_playchanneljump		
.pr_playchannel1:
		moveq	#$f,d0
		and.b	1(a6),d0
		move.b	d0,4(a4)
		move.b	d0,d2
		move.b	2(a6),5(a4)
		move.w	4(a4),58(a4)
		
		moveq	#1,d0
		and.b	(a6),d0
		move.b	1(a6),d1
		lsr.b	#3,d1
		bclr	#0,d1
		or.b	d1,d0
		move.b	d0,56(a4)		

		move.b	(a6),d1
		lsr.b	#1,d1
		move.b	d1,57(a4)
		ELSE
		move.w	2(a6),4(a4)
		move.b	2(a6),d2
		move.b	(a6),d0
		move.b	1(a6),d1
		ENDC
.pr_playchanneljump:
		add.w	d2,d2
		lea	pr_playchannellist(pc),a0
		move.w	(a0,d2.w),d2
		jsr	(a0,d2.w)
.pr_playchannelend:
		IFEQ	PACKEDSONGFORMAT-YES
		addq.l	#3,a6
		ELSE
		addq.l	#4,a6
		ENDC
		endm

pr_checkchannel:	macro			; do not change: d7,a2-a6
		bsr.w	pr_checkfunkrepeat
		moveq	#0,d0
		move.b	4(a4),d0
		add.b	d0,d0
		lea	pr_Effectchecklist(pc),a0
		move.w	(a0,d0.w),d0
		jsr	(a0,d0.w)
		endm
		
pr_copyplayvalues:	macro
		tst.w	pr_commandnotedelay-pr_framecounter(a2)
		bne.s	.pr_copyplayvalues2
		move.w	2(a4),6(a3)
.pr_copyplayvalues2:
		IFEQ	INCLUDEFADINGROUTINE-YES
		move.w	12(a4),d0
		mulu.w	pr_musicfadect-pr_framecounter(a2),d0
 		lsr.l	#FADINGSTEPS,d0
		move.w	d0,8(a3)
		ELSE
		move.w	12(a4),8(a3)
		ENDC
		endm

* Music-Routine *******************************************************

pr_music:
	tst.w	pr_moduleok
	bne.b	.playit
	rts
.playit
	IFEQ	INCLUDEFADINGROUTINE-YES
	pr_fademusic
	ENDC
	lea	$dff000,a5

	lea	pr_framecounter(pc),a2
	subq.w	#1,(a2)
	beq.s	pr_music2
	bra.w	pr_checkeffects
pr_music2:
	cmp.b	#1,pr_patterndelaytime-pr_framecounter+1(a2)
	blt.s	pr_music2_2
	bsr.w	pr_checkeffects
	bra.w	pr_music2_9
pr_music2_2:
	move.l	pr_Currentposition(pc),a6
	lea	pr_Channel0(pc),a4
	lea	$a0(a5),a3
	moveq	#1,d7
	pr_playchannel
	pr_copyplayvalues
pr_music2_3:	
	lea	pr_Channel1(pc),a4
	lea	$b0(a5),a3
	moveq	#2,d7
	pr_playchannel
	pr_copyplayvalues
pr_music2_4:
	lea	pr_Channel2(pc),a4
	lea	$c0(a5),a3
	moveq	#4,d7
	pr_playchannel
	pr_copyplayvalues
pr_music2_5:
	lea	pr_Channel3(pc),a4
	lea	$d0(a5),a3
	moveq	#8,d7
	pr_playchannel
	pr_copyplayvalues
	
	lea	pr_int(pc),a0
	move.l	pr_Vectorbasept(pc),a1
	move.l	a0,$78(a1)
	move.b	#$19,$bfde00

pr_music2_9:
	move.w	pr_speed(pc),(a2)
	tst.w	pr_patternhasbeenbreaked-pr_framecounter(a2)
	bne.s	pr_music3
	tst.w	pr_patterndelaytime-pr_framecounter(a2)
	beq.s	pr_music3_1
	subq.w	#1,pr_patterndelaytime-pr_framecounter(a2)
	beq.s	pr_music3_1
	bra.s	pr_nonextpattern
pr_music3:
	clr.w	pr_patternhasbeenbreaked-pr_framecounter(a2)
	tst.w	pr_patterndelaytime-pr_framecounter(a2)
	beq.s	pr_music3_1
	subq.w	#1,pr_patterndelaytime-pr_framecounter(a2)
pr_music3_1:
	lea	pr_Patternct(pc),a1
	tst.w	pr_dontcalcnewposition-pr_framecounter(a2)
	bne.s	pr_music3_2
	move.l	a6,pr_Currentposition-pr_framecounter(a2)
	addq.w	#1,(a1)
pr_music3_2:
	clr.w	pr_dontcalcnewposition-pr_framecounter(a2)
	moveq.l	#64,d1
	cmp.w	(a1),d1
	bgt.s	pr_nonextpattern
	sub.w	d1,(a1)
	lea	pr_currentpattern(pc),a0
	move.w	(a1),d1
	beq.s	pr_music3_3
	IFEQ	PACKEDSONGFORMAT-YES
	move.l	pr_module(pc),a1
	lea	386(a1),a1
	move.w	(a0),d1
	add.w	d1,d1
	move.w	(a1,d1.w),d1
	ELSE
	lsl.w	#4,d1
	ENDC
pr_music3_3:
	addq.l	#4,pr_Patternpt-pr_framecounter(a2)
	addq.w	#1,(a0)
	move.w	(a0),d0
	cmp.w	pr_highestpattern-pr_framecounter(a2),d0
	bls.s	pr_nohighestpattern
	lea	pr_Patternpositions(pc),a1
	move.l	a1,pr_Patternpt-pr_framecounter(a2)
	clr.w	(a0)
pr_nohighestpattern:
	move.l	pr_Patternpt-pr_framecounter(a2),a6
	move.l	(a6),d0
	add.l	d1,d0
	move.l	d0,pr_Currentposition-pr_framecounter(a2)
pr_nonextpattern:
	rts

	
pr_int:
	tst.b	$bfdd00
	move.b	#$19,$bfde00
	move.w	pr_dmacon(pc),$dff096
	move.w	#$2000,$dff09c
	move.l	a0,-(sp)
	move.l	pr_Vectorbasept(pc),a0
	add.l	#pr_int2-pr_int,$78(a0)
	move.l	(sp)+,a0
	rte

pr_int2:
	tst.b	$bfdd00
	movem.l	a5-a6,-(sp)
	lea	$dff000,a5
	lea	pr_Channel0+6(pc),a6
	move.l	(a6),$a0(a5)
	move.w	4(a6),$a4(a5)
	move.l	pr_Channel1-pr_Channel0(a6),$b0(a5)
	move.w	4+pr_Channel1-pr_Channel0(a6),$b4(a5)
	move.l	pr_Channel2-pr_Channel0(a6),$c0(a5)
	move.w	4+pr_Channel2-pr_Channel0(a6),$c4(a5)
	move.l	pr_Channel3-pr_Channel0(a6),$d0(a5)
	move.w	4+pr_Channel3-pr_Channel0(a6),$d4(a5)
	move.w	#$2000,$9c(a5)
	move.l	pr_Vectorbasept(pc),a6
	move.l	pr_old78(pc),$78(a6)
	movem.l	(sp)+,a5-a6
	rte
		
pr_playchannellist:
	dc.w	pr_playnormalchannel-pr_playchannellist		; 0
	dc.w	pr_playnormalchannel-pr_playchannellist		; 1
	dc.w	pr_playnormalchannel-pr_playchannellist		; 2
	dc.w	pr_playtpchannel-pr_playchannellist		; 3
	dc.w	pr_playnormalchannel-pr_playchannellist		; 4
	dc.w	pr_playtpchannel-pr_playchannellist		; 5
	dc.w	pr_playnormalchannel-pr_playchannellist		; 6
	dc.w	pr_playnormalchannel-pr_playchannellist		; 7
	dc.w	pr_playnormalchannel-pr_playchannellist		; 8
	dc.w	pr_playsochannel-pr_playchannellist		; 9
	dc.w	pr_playnormalchannel-pr_playchannellist		; A
	dc.w	pr_playnormalchannel-pr_playchannellist		; B
	dc.w	pr_playnormalchannel-pr_playchannellist		; C
	dc.w	pr_playnormalchannel-pr_playchannellist		; D
	dc.w	pr_playnormalchannel-pr_playchannellist		; E
	dc.w	pr_playnormalchannel-pr_playchannellist		; F
	
* KANAL NORMAL SPIELEN ************************************************

pr_playnormalchannel:
	lea	pr_Sampleinfos(pc),a0
	lea	(a0),a1
	lea	SAMPLEFINETUNEOFFSET(a1),a1
	clr.w	pr_commandnotedelay-pr_framecounter(a2)
	moveq	#-1,d4
	lsl.w	#4,d4
	and.w	4(a4),d4
	cmp.w	#$ed0,d4
	bne.s	pr_playnormalsamplenotedelay
	addq.w	#1,pr_commandnotedelay-pr_framecounter(a2)
pr_playnormalsamplenotedelay:
	tst.b	d0
	beq.w	pr_playnormalnonewsample	; Irgendein Sample ?
	move.w	d0,(a4)				; Trage Samplenummer ein
	tst.b	d1
	bne.s	pr_playnormalsample
	subq.b	#1,d0
	lsl.l	#5,d0
	add.l	d0,a0
	addq.l	#6,a0
	move.w	(a0)+,12(a4)
	move.l	(a0)+,d2
	move.l	d2,6(a4)
	tst.w	(a0)+
	beq.s	pr_playnormalchannel2
	move.l	d2,36(a4)
	move.l	d2,40(a4)
pr_playnormalchannel2:
	move.w	(a0)+,10(a4)
	bra.w	pr_playnormalnonewperiod
pr_playnormalsample:
	or.w	d7,pr_dmacon-pr_framecounter(a2)
	tst.w	pr_commandnotedelay-pr_framecounter(a2)
	beq.w	pr_playnormalsamplenoedcom
	subq.b	#1,d0
	lsl.l	#5,d0
	add.l	d0,a0
	move.w	6(a0),12(a4)
	move.l	8(a0),6(a4)
	move.w	14(a0),10(a4)
	bra.s	pr_playnormalnewperiod
pr_playnormalsamplenoedcom:
	move.w	d7,$96(a5)
	subq.b	#1,d0
	lsl.l	#5,d0
	add.l	d0,a0
	move.l	(a0)+,(a3)		; Setze Samplestart
	move.w	(a0)+,4(a3)		; Setze Audiodatenlnge
	move.w	(a0)+,12(a4)		; Setze Samplelautstrke
	move.l	(a0)+,d2
	move.l	d2,6(a4)		; Samplerepeatpoint eintragen
	tst.w	(a0)+
	beq.s	pr_playnormalsample2
	move.l	d2,36(a4)
	move.l	d2,40(a4)
pr_playnormalsample2:
	move.w	(a0)+,10(a4)		; Samplerepeatlength eintragen
	bra.s	pr_playnormalnewperiod
pr_playnormalnonewsample:
	clr.l	14(a4)
	tst.b	d1
	beq.s	pr_playnormalnonewperiod	; Irgend ne neue Frequenz ?
	move.w	(a4),d0			; Alte Samplenummer holen
	or.w	d7,pr_dmacon-pr_framecounter(a2)
	tst.w	pr_commandnotedelay-pr_framecounter(a2)
	bne.s	pr_playnormalnewperiod
	move.w	d7,$96(a5)
pr_playnormalnonewsamplenoedcom:
	subq.b	#1,d0
	lsl.l	#5,d0
	add.l	d0,a0
	move.l	(a0)+,(a3)		; Setze Samplestart
	move.w	(a0)+,4(a3)		; Setze Audiodatenlnge
	addq.l	#2,a0
	move.l	(a0)+,d2
	move.l	d2,6(a4)		; Samplerepeatpoint eintragen
	tst.w	(a0)+
	beq.s	pr_playnormalnonewsample2
	move.l	d2,36(a4)
	move.l	d2,40(a4)
pr_playnormalnonewsample2:
	move.w	(a0)+,10(a4)		; Samplerepeatlength eintragen
pr_playnormalnewperiod:
	subq.b	#1,d1
	add.b	d1,d1
	move.w	(a4),d0
	subq.b	#1,d0
	lsl.w	#5,d0
	move.l	(a1,d0.w),a1
	move.w	(a1,d1.w),2(a4)		; Frequenz eintragen
pr_playnormalnonewperiod:
	bra.w	pr_playeffect

* KANAL MIT OFFSET SPIELEN *********************************************

pr_playsochannel:
	lea	pr_Sampleinfos(pc),a0
	lea	(a0),a1
	lea	SAMPLEFINETUNEOFFSET(a1),a1
	tst.b	d0
	beq.w	pr_playsononewsample	; Irgendein Sample ?
	move.w	d0,(a4)				; Trage Samplenummer ein
	tst.b	d1
	bne.s	pr_playsosample
	subq.b	#1,d0
	lsl.l	#5,d0
	add.l	d0,a0
	addq.l	#6,a0
	move.w	(a0)+,12(a4)
	move.l	(a0)+,d2
	move.l	d2,6(a4)
	tst.w	(a0)+
	beq.s	pr_playsochannel2
	move.l	d2,36(a4)
	move.l	d2,40(a4)
pr_playsochannel2:
	move.w	(a0)+,10(a4)
	bra.w	pr_playsononewperiod
pr_playsosample:
	move.w	d7,$96(a5)
	or.w	d7,pr_dmacon-pr_framecounter(a2)
	moveq.l	#0,d6
	move.b	5(a4),d6
	lsl.w	#7,d6
	subq.b	#1,d0
	lsl.l	#5,d0
	add.l	d0,a0
	move.l	(a0)+,d2
	move.w	(a0)+,d3
	cmp.w	d3,d6
	bge.s	pr_playsosample2
	sub.w	d6,d3
	add.l	d6,d6
	add.l	d6,d2
	move.l	d2,(a3)			; Setze Samplestart
	move.w	d3,4(a3)		; Setze Audiodatenlnge
	move.w	(a0)+,12(a4)		; Setze Samplelautstrke
	move.l	(a0)+,d2
	move.l	d2,6(a4)		; Samplerepeatpoint eintragen
	tst.w	(a0)+
	beq.s	pr_playsosample1
	move.l	d2,36(a4)
	move.l	d2,40(a4)
pr_playsosample1:
	move.w	(a0)+,10(a4)		; Samplerepeatlength eintragen
	bra.w	pr_playsonewperiod
pr_playsosample2:
	move.w	(a0)+,12(a4)
	move.l	(a0),(a3)
	move.w	4(a0),4(a3)
	move.l	(a0)+,d2
	move.l	d2,6(a4)
	tst.w	(a0)+
	beq.s	pr_playsosample4
	move.l	d2,36(a4)
	move.l	d2,40(a4)
pr_playsosample4:
	move.w	(a0)+,10(a4)
	bra.s	pr_playsonewperiod
pr_playsononewsample:
	clr.l	14(a4)
	tst.b	d1
	beq.b	pr_playsononewperiod	; Irgend ne neue Frequenz ?
	move.w	(a4),d0			; Alte Samplenummer holen
	move.w	d7,$96(a5)
	or.w	d7,pr_dmacon-pr_framecounter(a2)
	moveq.l	#0,d6
	move.b	5(a4),d6
	lsl.w	#7,d6
	subq.b	#1,d0
	lsl.l	#5,d0
	add.l	d0,a0
	move.l	(a0)+,d2
	move.w	(a0)+,d3
	cmp.w	d3,d6
	bge.s	pr_playsosample3
	sub.w	d6,d3
	add.l	d6,d6
	add.l	d6,d2
	move.l	d2,(a3)			; Setze Samplestart
	move.w	d3,4(a3)		; Setze Audiodatenlnge
	addq.l	#2,a0
	move.l	(a0)+,d2
	move.l	d2,6(a4)		; Samplerepeatpoint eintragen
	tst.w	(a0)+
	beq.s	pr_playsononewsample2
	move.l	d2,36(a4)
	move.l	d2,40(a4)
pr_playsononewsample2:
	move.w	(a0)+,10(a4)		; Samplerepeatlength eintragen
	bra.s	pr_playsonewperiod
pr_playsosample3:
	addq.l	#2,a0
	move.l	(a0),(a3)
	move.w	4(a0),4(a3)
	move.l	(a0)+,d2
	move.l	d2,6(a4)
	tst.w	(a0)+
	beq.s	pr_playsosample5
	move.l	d2,36(a4)
	move.l	d2,40(a4)
pr_playsosample5:
	move.w	(a0)+,10(a4)
	bra.w	pr_playsonewperiod
pr_playsonewperiod:
	subq.w	#1,d1
	add.b	d1,d1
	move.w	(a4),d0
	subq.b	#1,d0
	lsl.w	#5,d0
	move.l	(a1,d0.w),a1
	move.w	(a1,d1.w),2(a4)		; Frequenz eintragen
pr_playsononewperiod:
	bra.b	pr_playeffect

* Kanal spielen mit TONE PORTAMENTO **********************************

pr_playtpchannel:
	lea	pr_Sampleinfos(pc),a0
	lea	(a0),a1
	lea	SAMPLEFINETUNEOFFSET(a1),a1
	tst.b	d0
	beq.s	pr_playtpnonewsample	; Irgendein Sample ?
	move.w	d0,(a4)			; Trage Samplenummer ein
	subq.b	#1,d0
	lsl.l	#5,d0
	add.l	d0,a0
	addq.l	#6,a0
	move.w	(a0)+,12(a4)		; Lautstrke eintragen
	move.l	(a0)+,d2
	move.l	d2,6(a4)		; Repeatpoint eintragen
	tst.w	(a0)+
	beq.s	pr_playtpchannel2
	move.l	d2,36(a4)
	move.l	d2,40(a4)
pr_playtpchannel2:
	move.w	(a0)+,10(a4)		; Repeatlength eintragen
pr_playtpnonewsample:
	tst.b	d1
	beq.s	pr_playtpnonewperiod	; Irgend ne neue Frequenz ?
pr_playtpnewperiod:
	move.w	2(a4),14(a4)
	subq.w	#1,d1
	add.b	d1,d1
	move.w	(a4),d0
	subq.b	#1,d0
	lsl.w	#5,d0
	move.l	(a1,d0.w),a1
	move.w	(a1,d1.w),d2
	move.w	d2,16(a4)		; Frequenz eintragen
	bra.s	pr_playtpallowed
pr_playtpnonewperiod:
	tst.w	16(a4)
	bne.s	pr_playtpallowed
	clr.w	14(a4)
	clr.l	26(a4)
pr_playtpallowed:
	bra.w	pr_playeffect

pr_playeffect:
	bsr.w	pr_checkfunkrepeat
	moveq	#0,d0
	move.b	4(a4),d0
	add.b	d0,d0
	lea	pr_normaleffectlist(pc),a0
	move.w	(a0,d0.w),d0
	jmp	(a0,d0.w)
pr_playnoeffect:
	rts

pr_normaleffectlist:
	dc.w	pr_playnoeffect-pr_normaleffectlist		; 0
	dc.w	pr_playnoeffect-pr_normaleffectlist		; 1
	dc.w	pr_playnoeffect-pr_normaleffectlist		; 2
	dc.w	pr_preptoneportamento-pr_normaleffectlist	; 3
	dc.w	pr_prepvibrato-pr_normaleffectlist		; 4
	dc.w	pr_playnoeffect-pr_normaleffectlist		; 5
	dc.w	pr_prepvibandvolslide-pr_normaleffectlist	; 6
	dc.w	pr_preptremolo-pr_normaleffectlist		; 7
	dc.w	pr_playnoeffect-pr_normaleffectlist		; 8
	dc.w	pr_playnoeffect-pr_normaleffectlist		; 9
	dc.w	pr_playnoeffect-pr_normaleffectlist		; A
	dc.w	pr_jumptopattern-pr_normaleffectlist		; B
	dc.w	pr_newvolume-pr_normaleffectlist		; C
	dc.w	pr_patternbreak-pr_normaleffectlist		; D
	dc.w	pr_play_e_command-pr_normaleffectlist		; E
	dc.w	pr_newspeed-pr_normaleffectlist			; F

pr_play_e_command:
	moveq	#0,d0
	move.b	5(a4),d0
	lsr.b	#3,d0
	bclr	#0,d0
	lea	pr_e_commandeffectlist(pc),a0
	move.w	(a0,d0.w),d0
	jmp	(a0,d0.w)
	
pr_e_commandeffectlist:
	dc.w	pr_setfilter-pr_e_commandeffectlist		; 0
	dc.w	pr_fineslideup-pr_e_commandeffectlist		; 1
	dc.w	pr_fineslidedown-pr_e_commandeffectlist		; 2
	dc.w	pr_setglissandocontrol-pr_e_commandeffectlist	; 3
	dc.w	pr_setvibratowaveform-pr_e_commandeffectlist	; 4
	dc.w	pr_playfinetune-pr_e_commandeffectlist		; 5
	dc.w	pr_jumptoloop-pr_e_commandeffectlist		; 6
	dc.w	pr_settremolowaveform-pr_e_commandeffectlist	; 7
	dc.w	pr_playnoeffect-pr_e_commandeffectlist		; 8
	dc.w	pr_prepretrignote-pr_e_commandeffectlist	; 9
	dc.w	pr_finevolumeslideup-pr_e_commandeffectlist	; A
	dc.w	pr_finevolumeslidedown-pr_e_commandeffectlist	; B
	dc.w	pr_prepnotecut-pr_e_commandeffectlist		; C
	dc.w	pr_prepnotedelay-pr_e_commandeffectlist		; D
	dc.w	pr_preppatterndelay-pr_e_commandeffectlist	; E
	dc.w	pr_prepfunkrepeat-pr_e_commandeffectlist	; F

pr_preppatterndelay:
	cmp.b	#1,pr_patterndelaytime-pr_framecounter+1(a2)
	bge.s	pr_preppatterndelayend
	moveq	#$f,d0
	and.b	5(a4),d0
	addq.b	#1,d0
	move.b	d0,pr_patterndelaytime-pr_framecounter+1(a2)
pr_preppatterndelayend:
	rts

pr_setvibratowaveform:
	moveq	#$f,d0
	and.b	5(a4),d0
	move.w	d0,50(a4)
	rts

pr_settremolowaveform:
	moveq	#$f,d0
	and.b	5(a4),d0
	move.w	d0,52(a4)
	rts

pr_setglissandocontrol:
	moveq	#$f,d0
	and.b	5(a4),d0
	move.w	d0,48(a4)
	rts

pr_playfinetune:
	moveq	#$f,d0
	and.b	5(a4),d0
	lsl.w	#2,d0
	lea	pr_fastperiodlist(pc),a0
	move.l	(a0,d0.w),a0
	moveq	#0,d1
	IFEQ	PACKEDSONGFORMAT-YES
	move.b	(a6),d1
	lsr.b	#1,d1
	ELSE
	move.b	1(a6),d1
	ENDC
	beq.s	pr_playfinetuneend
	subq.b	#1,d1
	add.w	d1,d1
	move.w	(a0,d1.w),2(a4)		; Frequenz eintragen
pr_playfinetuneend:
	rts
	
pr_jumptoloop:
	moveq	#$f,d0
	and.b	5(a4),d0
	beq.s	pr_prepjumptoloop
	addq.b	#1,47(a4)
	cmp.b	47(a4),d0
	blt.s	pr_jumptoloopend
	moveq.l	#0,d0
	move.w	44(a4),d0
	move.w	d0,pr_Patternct-pr_framecounter(a2)
	move.l	pr_Patternpt(pc),a0
	move.l	(a0),d5
	IFEQ	PACKEDSONGFORMAT-YES
	moveq.l	#0,d0
	move.w	60(a4),d0
	ELSE
	lsl.l	#4,d0
	ENDIF
	add.l	d0,d5
	move.l	d5,pr_Currentposition-pr_framecounter(a2)
	addq.w	#1,pr_dontcalcnewposition-pr_framecounter(a2)
	rts
pr_jumptoloopend:
	clr.w	46(a4)
	rts
pr_prepjumptoloop:
	tst.w	46(a4)
	bne.s	pr_prepjumptoloopend
	move.w	pr_Patternct-pr_framecounter(a2),44(a4)
	IFEQ	PACKEDSONGFORMAT-YES
	move.l	pr_Currentposition(pc),d0
	move.l	pr_Patternpt(pc),a1
	sub.l	(a1),d0
	move.w	d0,60(a4)
	ENDC
	clr.w	46(a4)
pr_prepjumptoloopend:
	rts

pr_prepnotedelay:
	IFEQ	PACKEDSONGFORMAT-YES
	tst.b	57(a4)
	ELSE
	tst.b	1(a6)
	ENDC
	beq.s	pr_prepnotedelayend2

	moveq	#$f,d0
	and.b	5(a4),d0
	bne.s	pr_prepnotedelay2
	move.w	#$fff,18(a4)
	bra.w	pr_checknotedelay2
pr_prepnotedelay2:
	move.w	d7,d0
	not.b	d0
	and.b	d0,pr_dmacon-pr_framecounter+1(a2)
	clr.w	18(a4)
	rts
pr_prepnotedelayend2:
	move.w	#$fff,18(a4)
	rts

pr_prepretrignote:
	clr.w	18(a4)
	IFEQ	PACKEDSONGFORMAT-YES
	tst.b	56(a4)
	ELSE
	tst.w	(a6)
	ENDC
	bne.s	pr_prepretrignoteend
	bra.w	pr_checkretrignote2	
pr_prepretrignoteend:
	rts

pr_prepnotecut:
	clr.w	18(a4)
	moveq	#$f,d0
	and.b	5(a4),d0
	tst.b	d0
	bne.s	pr_prepnotecutend
	clr.w	12(a4)
pr_prepnotecutend:
	rts
	
pr_finevolumeslideup:
	moveq	#$f,d0
	and.b	5(a4),d0
	move.w	12(a4),d1
	add.w	d0,d1
	moveq	#64,d0
	cmp.w	d0,d1
	bls.s	pr_finevolumeslideup2
	move.w	d0,d1
pr_finevolumeslideup2:
	move.w	d1,12(a4)
	rts

pr_finevolumeslidedown:
	moveq	#$f,d0
	and.b	5(a4),d0
	move.w	12(a4),d1
	sub.w	d0,d1
	bpl.s	pr_finevolumeslidedown2
	moveq	#0,d1
pr_finevolumeslidedown2:
	move.w	d1,12(a4)
	rts

pr_fineslideup:
	moveq	#$f,d0
	and.b	5(a4),d0
	move.w	2(a4),d1
	sub.w	d0,d1
	cmp.w	#108,d1
	bge.s	pr_fineslideup2
	move.w	#108,d1
pr_fineslideup2:
	move.w	d1,2(a4)
	rts

pr_fineslidedown:
	moveq	#$f,d0
	and.b	5(a4),d0
	move.w	2(a4),d1
	add.w	d0,d1
	cmp.w	#907,d1
	bls.s	pr_fineslidedown2
	move.w	#907,d1
pr_fineslidedown2:
	move.w	d1,2(a4)
	rts

pr_setfilter:
	btst	#0,5(a4)
	beq.s	pr_setfilteron
pr_setfilteroff:
	bset	#1,$bfe001
	rts
pr_setfilteron:
	bclr	#1,$bfe001
	rts

pr_prepvibandvolslide:
	cmp.b	#1,pr_speed-pr_framecounter+1(a2)
	beq.s	pr_prepvibandvolslide2
	IFEQ	PACKEDSONGFORMAT-YES
	move.b	(a6),d1
	lsr.b	#1,d1
	ELSE
	tst.b	1(a6)
	ENDC
	beq.s	pr_prepvibandvolslide2
	clr.w	18(a4)
pr_prepvibandvolslide2:
	rts

pr_preptoneportamento:
	tst.b	5(a4)
	beq.s	pr_preptoneportamento2
	move.w	4(a4),22(a4)
pr_preptoneportamento2:
	rts

pr_prepvibrato:
	cmp.b	#1,pr_speed-pr_framecounter+1(a2)
	beq.s	pr_prepvibrato2
	IFEQ	PACKEDSONGFORMAT-YES
	move.b	(a6),d1
	lsr.b	#1,d1
	ELSE
	tst.b	1(a6)
	ENDC
	beq.s	pr_prepvibrato0
	clr.w	18(a4)
pr_prepvibrato0:
	move.b	5(a4),d0
	move.b	d0,d1
	lsr.b	#4,d1
	beq.s	pr_prepvibrato1
	move.b	d1,24(a4)
pr_prepvibrato1:
	and.b	#$f,d0
	beq.s	pr_prepvibrato2
	move.b	d0,25(a4)
pr_prepvibrato2:
	rts

pr_preptremolo:
	cmp.b	#1,pr_speed-pr_framecounter+1(a2)
	beq.s	pr_preptremolo2
	IFEQ	PACKEDSONGFORMAT-YES
	move.b	(a6),d1
	lsr.b	#1,d1
	ELSE
	tst.b	1(a6)
	ENDC
	beq.s	pr_preptremolo0
	clr.w	18(a4)
pr_preptremolo0:
	move.w	12(a4),20(a4)
	move.b	5(a4),d0
	move.b	d0,d1
	lsr.b	#4,d1
	beq.s	pr_preptremolo1
	move.b	d1,30(a4)
pr_preptremolo1:
	and.b	#$f,d0
	beq.s	pr_preptremolo2
	move.b	d0,31(a4)
pr_preptremolo2:
	rts

pr_newvolume:
	move.b	5(a4),d0
	cmp.b	#64,d0
	bls.s	pr_newvolumeend
	moveq	#64,d0
pr_newvolumeend:
	move.b	d0,13(a4)
	rts

pr_newspeed:
	move.b	5(a4),d0
	tst.b	d0
	bne.s	pr_newspeed2
	moveq	#1,d0
pr_newspeed2:
	move.b	d0,pr_speed-pr_framecounter+1(a2)
	rts

pr_patternbreak:
	moveq	#0,d0
	move.b	5(a4),d0
	add.w	#64,d0
	move.w	d0,pr_Patternct-pr_framecounter(a2)
	addq.w	#1,pr_patternhasbeenbreaked-pr_framecounter(a2)
	addq.w	#1,pr_dontcalcnewposition-pr_framecounter(a2)
	rts
		
pr_jumptopattern:
	moveq.l	#0,d0
	move.b	5(a4),d0
	subq.b	#1,d0
	bpl.s	pr_playjumptopattern2
	move.w	#128,d0
pr_playjumptopattern2:
	move.b	d0,pr_currentpattern-pr_framecounter+1(a2)
	lsl.l	#2,d0
	lea	pr_Patternpositions(pc),a0
	add.l	a0,d0
	move.l	d0,pr_Patternpt-pr_framecounter(a2)
	move.w	#64,pr_Patternct-pr_framecounter(a2)
	addq.w	#1,pr_patternhasbeenbreaked-pr_framecounter(a2)
	addq.w	#1,pr_dontcalcnewposition-pr_framecounter(a2)
	rts

* Control FX every frame **********************************************

pr_checkeffects:
	moveq	#1,d7
	lea	$a0(a5),a3
	lea	pr_Channel0(pc),a4
	move.w	12(a4),54(a4)
	pr_checkchannel
	IFEQ	INCLUDEFADINGROUTINE-YES
	move.w	54(a4),d0
	mulu.w	pr_musicfadect-pr_framecounter(a2),d0
	lsr.l	#FADINGSTEPS,d0
	move.w	d0,8(a3)
	ELSE
	move.w	54(a4),8(a3)
	ENDC
	
	moveq	#2,d7
	lea	$b0(a5),a3
	lea	pr_Channel1(pc),a4
	move.w	12(a4),54(a4)
	pr_checkchannel
	IFEQ	INCLUDEFADINGROUTINE-YES
	move.w	54(a4),d0
	mulu.w	pr_musicfadect-pr_framecounter(a2),d0
	lsr.l	#FADINGSTEPS,d0
	move.w	d0,8(a3)
	ELSE
	move.w	54(a4),8(a3)
	ENDC

	moveq	#4,d7
	lea	$c0(a5),a3
	lea	pr_Channel2(pc),a4
	move.w	12(a4),54(a4)
	pr_checkchannel
	IFEQ	INCLUDEFADINGROUTINE-YES
	move.w	54(a4),d0
	mulu.w	pr_musicfadect-pr_framecounter(a2),d0
	lsr.l	#FADINGSTEPS,d0
	move.w	d0,8(a3)
	ELSE
	move.w	54(a4),8(a3)
	ENDC

	moveq	#8,d7
	lea	$d0(a5),a3
	lea	pr_Channel3(pc),a4
	move.w	12(a4),54(a4)
	pr_checkchannel
	IFEQ	INCLUDEFADINGROUTINE-YES
	move.w	54(a4),d0
	mulu.w	pr_musicfadect-pr_framecounter(a2),d0
	lsr.l	#FADINGSTEPS,d0
	move.w	d0,8(a3)
	ELSE
	move.w	54(a4),8(a3)
	ENDC

	lea	pr_int(pc),a0
	move.l	pr_Vectorbasept(pc),a1
	move.l	a0,$78(a1)
	move.b	#$19,$bfde00
	rts

***********************************************************************

pr_checknotchannel:
	rts

pr_check_e_commands
	moveq	#0,d0
	move.b	5(a4),d0
	lsr.b	#3,d0
	bclr	#0,d0
	lea	pr_E_Command_checklist(pc),a0
	move.w	(a0,d0.w),d0
	jmp	(a0,d0.w)
	
pr_Effectchecklist:
	dc.w	pr_checkarpeggio-pr_Effectchecklist		; 0
	dc.w	pr_checkperiodslideup-pr_Effectchecklist	; 1
	dc.w	pr_checkperiodslidedown-pr_Effectchecklist	; 2
	dc.w	pr_checktoneportamento-pr_Effectchecklist	; 3
	dc.w	pr_checkvibrato-pr_Effectchecklist		; 4
	dc.w	pr_checktpandvolslide-pr_Effectchecklist	; 5
	dc.w	pr_checkvibandvolslide-pr_Effectchecklist	; 6
	dc.w	pr_checktremolo-pr_Effectchecklist		; 7
	dc.w	pr_checknotchannel-pr_Effectchecklist		; 8
	dc.w	pr_checknotchannel-pr_Effectchecklist		; 9
	dc.w	pr_checkvolumeslide-pr_Effectchecklist		; A
	dc.w	pr_checknotchannel-pr_Effectchecklist		; B
	dc.w	pr_checknotchannel-pr_Effectchecklist		; C
	dc.w	pr_checknotchannel-pr_Effectchecklist		; D
	dc.w	pr_check_e_commands-pr_Effectchecklist		; E
	dc.w	pr_checknotchannel-pr_Effectchecklist		; F

pr_E_Command_checklist:
	dc.w	pr_checknotchannel-pr_E_Command_checklist	; 0
	dc.w	pr_checknotchannel-pr_E_Command_checklist	; 1
	dc.w	pr_checknotchannel-pr_E_Command_checklist	; 2
	dc.w	pr_checknotchannel-pr_E_Command_checklist	; 3
	dc.w	pr_checknotchannel-pr_E_Command_checklist	; 4
	dc.w	pr_checknotchannel-pr_E_Command_checklist	; 5
	dc.w	pr_checknotchannel-pr_E_Command_checklist	; 6
	dc.w	pr_checknotchannel-pr_E_Command_checklist	; 7
	dc.w	pr_checknotchannel-pr_E_Command_checklist	; 8
	dc.w	pr_checkretrignote-pr_E_Command_checklist	; 9
	dc.w	pr_checknotchannel-pr_E_Command_checklist	; A
	dc.w	pr_checknotchannel-pr_E_Command_checklist	; B
	dc.w	pr_checknotecut-pr_E_Command_checklist		; C
	dc.w	pr_checknotedelay-pr_E_Command_checklist	; D
	dc.w	pr_checknotchannel-pr_E_Command_checklist	; E
	dc.w	pr_checknotchannel-pr_E_Command_checklist	; F

pr_prepfunkrepeat:
	moveq	#$f,d0
	and.b	5(a4),d0
	move.b	d0,33(a4)
	tst.b	d0
	bne.s	pr_checkfunkrepeat
	rts
pr_checkfunkrepeat:
	move.w	32(a4),d0
	beq.s	pr_checkfunkrepeatend
	lea	pr_FunkTable(pc),a0
	move.b	(a0,d0.w),d0
	move.b	35(a4),d1
	add.b	d0,d1
	bmi.s	pr_checkfunkrepeat2
	move.b	d1,35(a4)
	rts
pr_checkfunkrepeat2:
	clr.b	35(a4)

	move.l	36(a4),d0
	beq.s	pr_checkfunkrepeatend
	move.l	d0,d2
	moveq.l	#0,d1
	move.w	10(a4),d1
	add.l	d1,d0
	add.l	d1,d0
	move.l	40(a4),a0
	addq.l	#1,a0
	cmp.l	d0,a0
	blo.s	pr_checkfunkrepeatok
	move.l	d2,a0
pr_checkfunkrepeatok:
	move.l	a0,40(a4)
	moveq	#-1,d0
	sub.b	(a0),d0
	move.b	d0,(a0)
pr_checkfunkrepeatend:
	rts

pr_checknotedelay:
	move.w	18(a4),d1
	addq.w	#1,d1
	cmp.w	d0,d1
	bne.s	pr_checknotedelayend
pr_checknotedelay2:
	move.w	d7,$96(a5)
	or.w	d7,pr_dmacon-pr_framecounter(a2)
	moveq.l	#0,d0
	move.w	(a4),d0
	subq.w	#1,d0
	lsl.w	#5,d0
	lea	pr_Sampleinfos(pc),a0
	add.l	d0,a0
	move.w	2(a4),6(a3)
	move.l	(a0)+,(a3)		; Setze Samplestart
	move.w	(a0)+,4(a3)		; Setze Audiodatenlnge
	addq.l	#2,a0
	move.l	(a0)+,d2
	move.l	d2,6(a4)		; Samplerepeatpoint eintragen
	tst.w	(a0)+
	beq.s	pr_checknotedelay3
	move.l	d2,36(a4)
	move.l	d2,40(a4)
pr_checknotedelay3:
	move.w	(a0)+,10(a4)		; Samplerepeatlength eintragen
pr_checknotedelayend:
	move.w	d1,18(a4)
	rts

pr_checkretrignote:
	moveq	#$f,d0
	and.b	5(a4),d0
	move.w	18(a4),d1
	addq.w	#1,d1
	cmp.w	d0,d1
	bne.s	pr_checkretrignoteend
pr_checkretrignote2:
	moveq	#0,d1
	move.w	d7,$96(a5)
	or.w	d7,pr_dmacon-pr_framecounter(a2)
	move.w	(a4),d0
	subq.w	#1,d0
	lsl.w	#5,d0
	lea	pr_Sampleinfos(pc),a0
	move.l	(a0,d0.w),(a3)
	move.w	4(a0,d0.w),4(a3)
pr_checkretrignoteend:
	move.w	d1,18(a4)
	rts

pr_checknotecut:
	moveq	#$f,d0
	and.b	5(a4),d0
	addq.w	#1,18(a4)
	move.w	18(a4),d1
	cmp.w	d0,d1
	blt.s	pr_checknotecutend
	clr.w	12(a4)
	clr.w	54(a4)
pr_checknotecutend:
	rts

pr_checkarpeggio:
	tst.b	5(a4)
	bne.s	pr_checkarpeggio0
	rts
pr_checkarpeggio0:
	move.w	(a2),d0
	lea	pr_Arpeggiofastdivisionlist(pc),a1
	move.b	(a1,d0.w),d0
	beq.s	pr_checkarpeggio2
	cmp.b	#2,d0
	beq.s	pr_checkarpeggio1
	moveq	#0,d0
	move.b	5(a4),d0
	lsr.b	#4,d0
	bra.s	pr_checkarpeggio3
pr_checkarpeggio2:
	move.w	2(a4),6(a3)
	rts
pr_checkarpeggio1:
	moveq	#$f,d0
	and.b	5(a4),d0
pr_checkarpeggio3:
	asl.w	#1,d0
	move.w	(a4),d1
	lsl.w	#5,d1
	lea	pr_Sampleinfos+SAMPLEFINETUNEOFFSET(pc),a0
	move.l	(a0,d1.w),a0
	move.w	2(a4),d1
	lea	pr_Arpeggiofastlist(pc),a1
	moveq.l	#0,d2
	move.b	(a1,d1.w),d2
	add.b	d2,d2
	add.l	d2,a0
	moveq	#36,d7
pr_checkarpeggioloop:
	cmp.w	(a0)+,d1
	bhs.s	pr_checkarpeggio4
	dbf	d7,pr_checkarpeggioloop
	rts
pr_checkarpeggio4:
	subq.l	#2,a0
	move.w	(a0,d0.w),6(a3)
	rts

pr_checktpandvolslide:
	bsr.w	pr_checkvolumeslide
	moveq	#0,d2
	move.b	23(a4),d2
	move.w	26(a4),d0
	move.w	28(a4),d1
	bsr.s	pr_checktoneportamento2
	move.w	14(a4),26(a4)
	rts
	
pr_checktoneportamento:
	moveq	#0,d2
	move.b	5(a4),d2
	bne.s	pr_checktoneportamento1
	move.b	23(a4),d2
pr_checktoneportamento1:
	move.w	14(a4),d0
	move.w	16(a4),d1
pr_checktoneportamento2:
	cmp.w	d0,d1
	bgt.s	pr_checktoneportamentoplus
	blt.s	pr_checktoneportamentominus
	cmp.w	#1,(a2)
	beq.s	pr_savetpvalues
	rts
pr_checktoneportamentoplus:
	add.w	d2,d0
	cmp.w	d0,d1
	bgt.s	pr_checktoneportamentoend
	move.w	d1,d0
	move.w	d1,14(a4)
	move.w	d1,2(a4)
	tst.w	48(a4)
	bne.s	pr_checktoneportamentoglissando
	move.w	d1,6(a3)
	cmp.w	#1,(a2)
	beq.s	pr_savetpvalues
	rts
pr_checktoneportamentominus:
	sub.w	d2,d0
	cmp.w	d0,d1
	blt.s	pr_checktoneportamentoend
	move.w	d1,d0
	move.w	d1,14(a4)
	move.w	d1,2(a4)
	tst.w	48(a4)
	bne.s	pr_checktoneportamentoglissando
	move.w	d1,6(a3)
	cmp.w	#1,(a2)
	beq.s	pr_savetpvalues
	rts
pr_checktoneportamentoend:
	move.w	d0,14(a4)
	move.w	d0,2(a4)
	tst.w	48(a4)
	bne.s	pr_checktoneportamentoglissando
	move.w	d0,6(a3)
	cmp.w	#1,(a2)
	beq.s	pr_savetpvalues
	rts	
pr_savetpvalues:
	move.l	14(a4),26(a4)
	rts
pr_checktoneportamentoglissando:
	move.w	(a4),d1
	lsl.w	#5,d1
	lea	pr_Sampleinfos+SAMPLEFINETUNEOFFSET(pc),a0
	move.l	(a0,d1.w),a0
	lea	pr_Arpeggiofastlist(pc),a1
	moveq.l	#0,d2
	move.b	(a1,d0.w),d2
	add.w	d2,d2
	add.l	d2,a0
	moveq	#0,d3
	moveq	#36*2,d1
pr_checktoneportamentoglissandoloop:
	cmp.w	(a0,d3.w),d0
	bhs.s	pr_checktoneportamentoglissando2
	addq.w	#2,d3
	cmp.w	d1,d3
	blo.s	pr_checktoneportamentoglissandoloop
	moveq	#35*2,d3
pr_checktoneportamentoglissando2:
	move.w	(a0,d3.w),6(a3)
	cmp.w	#1,(a2)
	beq.s	pr_savetpvalues
	rts

pr_checkvolumeslide:
	moveq	#0,d0
	move.b	5(a4),d0
	move.w	d0,d1
	lsr.b	#4,d1
	beq.s	pr_checkvolumeslidedown
	move.w	12(a4),d2
	add.w	d1,d2
	bmi.s	pr_checkvolumeslide0
	moveq	#64,d0
	cmp.w	d0,d2
	bgt.s	pr_checkvolumeslide64
	move.w	d2,12(a4)
	move.w	d2,54(a4)
	rts
pr_checkvolumeslidedown:	
	and.b	#$f,d0
	move.w	12(a4),d2
	sub.w	d0,d2
	bmi.s	pr_checkvolumeslide0
	moveq	#64,d0
	cmp.w	d0,d2
	bgt.s	pr_checkvolumeslide64
	move.w	d2,12(a4)
	move.w	d2,54(a4)
	rts
pr_checkvolumeslide64:
	move.w	d0,12(a4)
	move.w	d0,54(a4)
	rts
pr_checkvolumeslide0:
	clr.w	12(a4)
	clr.w	54(a4)
	rts
	
pr_checkperiodslidedown:
	moveq	#0,d0
	move.b	5(a4),d0
	add.w	d0,2(a4)
	cmp.w	#907,2(a4)
	bls.s	pr_checkperiodslidedown2
	move.w	#907,2(a4)
pr_checkperiodslidedown2:
	move.w	2(a4),6(a3)
	rts

pr_checkperiodslideup:
	moveq	#0,d0
	move.b	5(a4),d0
	sub.w	d0,2(a4)
	cmp.w	#108,2(a4)
	bge.s	pr_checkperiodslideup2
	move.w	#108,2(a4)
pr_checkperiodslideup2:
	move.w	2(a4),6(a3)
	rts

pr_checkvibandvolslide:
	bsr.w	pr_checkvolumeslide
	moveq.l	#0,d0
	moveq.l	#0,d1
	move.b	25(a4),d0
	move.b	24(a4),d1
	bra.s	pr_checkvibrato4

pr_checkvibrato:
	moveq.l	#0,d0
	moveq.l	#0,d1
	move.b	5(a4),d0	; Tiefe
pr_checkvibrato2:
	move.w	d0,d1		; Geschwindigkeit
	and.w	#$f,d0
	bne.s	pr_checkvibrato3
	move.b	25(a4),d0
pr_checkvibrato3:
	lsr.b	#4,d1
	bne.s	pr_checkvibrato4
	move.b	24(a4),d1
pr_checkvibrato4:
	move.w	18(a4),d2	;Position
	lsr.w	#2,d2
	and.w	#$1f,d2
	move.w	50(a4),d3
	beq.s	pr_checkvibratosine
	btst	#0,d3
	bne.s	pr_checkvibratorampdown
	move.b	#255,d3
	bra.s	pr_checkvibratoset
pr_checkvibratorampdown:
	lsl.b	#3,d2
	tst.b	19(a4)
	bmi.s	pr_checkvibratorampdown2
	move.b	#255,d3
	sub.b	d2,d3
	bra.s	pr_checkvibratoset
pr_checkvibratorampdown2:
	move.b	d2,d3
	bra.s	pr_checkvibratoset
pr_checkvibratosine:
	lea	pr_VibratoTable(pc),a0
	moveq	#0,d3
	move.b	(a0,d2.w),d3
pr_checkvibratoset:
	mulu.w	d0,d3
	lsr.w	#7,d3
	move.w	2(a4),d2
	tst.b	19(a4)
	bpl.s	pr_checkvibratoneg
	add.w	d3,d2
	bra.s	pr_checkvibrato5
pr_checkvibratoneg:
	sub.w	d3,d2
pr_checkvibrato5:
	move.w	d2,6(a3)
	lsl.w	#2,d1
	add.b	d1,19(a4)
	rts

pr_checktremolo:
	moveq	#0,d0
	moveq.l	#0,d1
	move.b	5(a4),d0	; Tiefe
pr_checktremolo2:
	move.w	d0,d1		; Geschwindigkeit
	and.w	#$f,d0
	bne.s	pr_checktremolo3
	move.b	31(a4),d0
pr_checktremolo3:
	lsr.b	#4,d1
	bne.s	pr_checktremolo4
	move.b	30(a4),d1
pr_checktremolo4:
	move.w	18(a4),d2	;Position
	lsr.w	#2,d2
	and.w	#$1f,d2
	move.w	52(a4),d3
	beq.s	pr_checktremolosine
	btst	#0,d3
	bne.s	pr_checktremolorampdown
	move.b	#255,d3
	bra.s	pr_checktremoloset
pr_checktremolorampdown:
	lsl.b	#3,d2
	tst.b	19(a4)
	bmi.s	pr_checktremolorampdown2
	move.b	#255,d3
	sub.b	d2,d3
	bra.s	pr_checktremoloset
pr_checktremolorampdown2:
	move.b	d2,d3
	bra.s	pr_checktremoloset
pr_checktremolosine:
	lea	pr_VibratoTable(pc),a0
	moveq	#0,d3
	move.b	(a0,d2.w),d3
pr_checktremoloset:
	mulu.w	d0,d3
	lsr.w	#6,d3
	move.w	20(a4),d2
	tst.b	19(a4)
	bpl.s	pr_checktremoloneg
	add.w	d3,d2
	moveq	#64,d4
	cmp.w	d4,d2
	bls.s	pr_checktremolo5
	move.w	d4,d2
	bra.s	pr_checktremolo5
pr_checktremoloneg:
	sub.w	d3,d2
	bpl.s	pr_checktremolo5
	moveq	#0,d2
pr_checktremolo5:
	move.w	d2,54(a4)
	lsl.w	#2,d1
	add.b	d1,19(a4)
	rts

pr_VibratoTable:	
	dc.b	0,24,49,74,97,120,141,161
	dc.b	180,197,212,224,235,244,250,253
	dc.b	255,253,250,244,235,224,212,197
	dc.b	180,161,141,120,97,74,49,24
pr_FunkTable:
	dc.b	0,5,6,7,8,10,11,13,16,19,22,26,32,43,64,128
	
* Variables ***********************************************************

pr_module:	dc.l	0
pr_moduleok:	dc.w	0
pr_periods:
; Tuning 0, Normal
	dc.w	856,808,762,720,678,640,604,570,538,508,480,453
	dc.w	428,404,381,360,339,320,302,285,269,254,240,226
	dc.w	214,202,190,180,170,160,151,143,135,127,120,113
; Tuning 1
	dc.w	850,802,757,715,674,637,601,567,535,505,477,450
	dc.w	425,401,379,357,337,318,300,284,268,253,239,225
	dc.w	213,201,189,179,169,159,150,142,134,126,119,113
; Tuning 2
	dc.w	844,796,752,709,670,632,597,563,532,502,474,447
	dc.w	422,398,376,355,335,316,298,282,266,251,237,224
	dc.w	211,199,188,177,167,158,149,141,133,125,118,112
; Tuning 3
	dc.w	838,791,746,704,665,628,592,559,528,498,470,444
	dc.w	419,395,373,352,332,314,296,280,264,249,235,222
	dc.w	209,198,187,176,166,157,148,140,132,125,118,111
; Tuning 4
	dc.w	832,785,741,699,660,623,588,555,524,495,467,441
	dc.w	416,392,370,350,330,312,294,278,262,247,233,220
	dc.w	208,196,185,175,165,156,147,139,131,124,117,110
; Tuning 5
	dc.w	826,779,736,694,655,619,584,551,520,491,463,437
	dc.w	413,390,368,347,328,309,292,276,260,245,232,219
	dc.w	206,195,184,174,164,155,146,138,130,123,116,109
; Tuning 6
	dc.w	820,774,730,689,651,614,580,547,516,487,460,434
	dc.w	410,387,365,345,325,307,290,274,258,244,230,217
	dc.w	205,193,183,172,163,154,145,137,129,122,115,109
pr_Arpeggiofastlistperiods:
; Tuning 7
	dc.w	814,768,725,684,646,610,575,543,513,484,457,431
	dc.w	407,384,363,342,323,305,288,272,256,242,228,216
	dc.w	204,192,181,171,161,152,144,136,128,121,114,108
; Tuning -8
	dc.w	907,856,808,762,720,678,640,604,570,538,508,480
	dc.w	453,428,404,381,360,339,320,302,285,269,254,240
	dc.w	226,214,202,190,180,170,160,151,143,135,127,120
; Tuning -7
	dc.w	900,850,802,757,715,675,636,601,567,535,505,477
	dc.w	450,425,401,379,357,337,318,300,284,268,253,238
	dc.w	225,212,200,189,179,169,159,150,142,134,126,119
; Tuning -6
	dc.w	894,844,796,752,709,670,632,597,563,532,502,474
	dc.w	447,422,398,376,355,335,316,298,282,266,251,237
	dc.w	223,211,199,188,177,167,158,149,141,133,125,118
; Tuning -5
	dc.w	887,838,791,746,704,665,628,592,559,528,498,470
	dc.w	444,419,395,373,352,332,314,296,280,264,249,235
	dc.w	222,209,198,187,176,166,157,148,140,132,125,118
; Tuning -4
	dc.w	881,832,785,741,699,660,623,588,555,524,494,467
	dc.w	441,416,392,370,350,330,312,294,278,262,247,233
	dc.w	220,208,196,185,175,165,156,147,139,131,123,117
; Tuning -3
	dc.w	875,826,779,736,694,655,619,584,551,520,491,463
	dc.w	437,413,390,368,347,328,309,292,276,260,245,232
	dc.w	219,206,195,184,174,164,155,146,138,130,123,116
; Tuning -2
	dc.w	868,820,774,730,689,651,614,580,547,516,487,460
	dc.w	434,410,387,365,345,325,307,290,274,258,244,230
	dc.w	217,205,193,183,172,163,154,145,137,129,122,115
; Tuning -1
	dc.w	862,814,768,725,684,646,610,575,543,513,484,457
	dc.w	431,407,384,363,342,323,305,288,272,256,242,228
	dc.w	216,203,192,181,171,161,152,144,136,128,121,114

END:

pr_startposition:		dc.w	0
pr_speed:			dc.w	6
pr_highestpattern:		dc.w	0
pr_currentpattern:		dc.w	0
pr_framecounter:		dc.w	0
pr_patterndelaytime:		dc.w	0
pr_patternhasbeenbreaked:	dc.w	0
pr_Patternpositions:		ds.l	128
pr_Patternpt:			dc.l	0
pr_Currentposition:		dc.l	0
pr_Patternct:			dc.w	0
pr_oldledvalue:			dc.w	0
pr_dontcalcnewposition:		dc.w	0
pr_commandnotedelay:		dc.w	0
pr_old78:			dc.l	0
pr_Vectorbasept:		dc.l	0
pr_Channel0:			dc.w	1
				ds.w	30
pr_Channel1:			dc.w	1
				ds.w	30
pr_Channel2:			dc.w	1
				ds.w	30
pr_Channel3:			dc.w	1
				ds.w	30
pr_dmacon:			dc.w	$8000

pr_Arpeggiofastlist:		ds.b	1000
pr_Arpeggiofastdivisionlist:	ds.b	$100
pr_fastperiodlist:		ds.l	16
pr_Sampleinfos:			ds.b	32*32


Routine1Ptr:	dc.l	0
Routine1Loc:	dc.l	0
Routine2Ptr:	dc.l	0
Routine2Loc:	dc.l	0
ResChipBuffer:	dc.l	0,0
	blk.b	512/8,0
ResMixMBuffer:	dc.l	0,0
	blk.b	512/8,0
VBlank:	dc.b	0
AGA_Chipset:	dc.b	0
PicStatus:	dc.w	0	;0=gr ingenting
			;1=fade up
			;2=vent lidt
			;3=fade ned
PicPause:	dc.w	0
FadeCounter:	dc.w	0

	CNOP	0,8	;AGA-skrm-justering

TheEnd:

TD_CodeBuf:	equ	$80000-(($1C00+2)*2)
TopOfChip:	equ	TD_CodeBuf

S_END:	EQU	END-START+ADDRESS
S_START:	EQU	ADDRESS
S_BLOCKS:	EQU	(END-START+511)/512







*******************************************************************************
**
**  Hardware registers
**
*******************************************************************************
Bltddat:	EQU	$000
Dmaconr:	EQU	$002
Vposr:	EQU	$004
VHPosr:	EQU	$006
Dskdatr:	EQU	$008
Joy0dat:	EQU	$00a
Joy1dat:	EQU	$00c
Clxdat:	EQU	$00e
Adkconr:	EQU	$010
Pot0dat:	EQU	$012
Pot1dat:	EQU	$014
Potgor:	EQU	$016
Serdatr:	EQU	$018
Dskbytr:	EQU	$01a
Intenar:	EQU	$01c
Intreqr:	EQU	$01e
Dskpth:	EQU	$020
Dskptl:	EQU	$022
Dsklen:	EQU	$024
Dskdat:	EQU	$026
Refptr:	EQU	$028
Vposw:	EQU	$02a
Vhposw:	EQU	$02c
Copcon:	EQU	$02e
Serdat:	EQU	$030
Serper:	EQU	$032
Potgo:	EQU	$034
Joytest:	EQU	$036
Strequ:	EQU	$038
Strvbl:	EQU	$03a
Strhor:	EQU	$03c
Strlong:	EQU	$03e
Bltcon0:	EQU	$040
Bltcon1:	EQU	$042
Bltafwm:	EQU	$044
Bltalwm:	EQU	$046
Bltcpth:	EQU	$048
Bltcptl:	EQU	$04a
Bltbpth:	EQU	$04c
Bltbptl:	EQU	$04e
Bltapth:	EQU	$050
Bltaptl:	EQU	$052
Bltdpth:	EQU	$054
Bltdptl:	EQU	$056
Bltsize:	EQU	$058
Bltcmod:	EQU	$060
Bltbmod:	EQU	$062
Bltamod:	EQU	$064
Bltdmod:	EQU	$066
Bltcdat:	EQU	$070
Bltbdat:	EQU	$072
Bltadat:	EQU	$074
Dsksync:	EQU	$07e
Cop1lch:	EQU	$080
Cop1lcl:	EQU	$082
Cop2lch:	EQU	$084
Cop2lcl:	EQU	$086
Copjmp1:	EQU	$088
Copjmp2:	EQU	$08a
Copins:	EQU	$08c
Diwstrt:	EQU	$08e
Diwstop:	EQU	$090
Ddfstrt:	EQU	$092
Ddfstop:	EQU	$094
Dmacon:	EQU	$096
Clxcon:	EQU	$98
Intena:	EQU	$09a
Intreq:	EQU	$09c
Adkcon:	EQU	$09e
Aud0dat:	EQU	$0aa
Aud1dat:	EQU	$0ba
Aud2dat:	EQU	$0ca
Aud3dat:	EQU	$0da
Aud0lch:	EQU	$0a0
Aud1lch:	EQU	$0b0
Aud2lch:	EQU	$0c0
Aud3lch:	EQU	$0d0
Aud0len:	EQU	$0a4
Aud1len:	EQU	$0b4
Aud2len:	EQU	$0c4
Aud3len:	EQU	$0d4
Aud0per:	EQU	$0a6
Aud1per:	EQU	$0b6
Aud2per:	EQU	$0c6
Aud3per:	EQU	$0d6
Aud0vol:	EQU	$0a8
Aud1vol:	EQU	$0b8
Aud2vol:	EQU	$0c8
Aud3vol:	EQU	$0d8
Aud0lcl:	EQU	$0a2
Aud1lcl:	EQU	$0b2
Aud2lcl:	EQU	$0c2
Aud3lcl:	EQU	$0d2
Bpl1pth:	EQU	$0e0
Bpl1ptl:	EQU	$0e2
Bpl2pth:	EQU	$0e4
Bpl2ptl:	EQU	$0e6
Bpl3pth:	EQU	$0e8
Bpl3ptl:	EQU	$0ea
Bpl4pth:	EQU	$0ec
Bpl4ptl:	EQU	$0ee
Bpl5pth:	EQU	$0f0
Bpl5ptl:	EQU	$0f2
Bpl6pth:	EQU	$0f4
Bpl6ptl:	EQU	$0f6
Bpl7pth:	EQU	$0f8
Bpl7ptl:	EQU	$0fa
Bpl8pth:	EQU	$0fc
Bpl8ptl:	EQU	$0fe
Bplcon0:	EQU	$100
Bplcon1:	EQU	$102
Bplcon2:	EQU	$104
Bplcon3:	EQU	$106
Bpl1mod:	EQU	$108
Bpl2mod:	EQU	$10a
Bpl1dat:	EQU	$110
Bpl2dat:	EQU	$112
Bpl3dat:	EQU	$114
Bpl4dat:	EQU	$116
Bpl5dat:	EQU	$118
Bpl6dat:	EQU	$11a
Spr0pth:	EQU	$120
Spr0ptl:	EQU	$122
Spr1pth:	EQU	$124
Spr1ptl:	EQU	$126
Spr2pth:	EQU	$128
Spr2ptl:	EQU	$12a
Spr3pth:	EQU	$12c
Spr3ptl:	EQU	$12e
Spr4pth:	EQU	$130
Spr4ptl:	EQU	$132
Spr5pth:	EQU	$134
Spr5ptl:	EQU	$136
Spr6pth:	EQU	$138
Spr6ptl:	EQU	$13a
Spr7pth:	EQU	$13c
Spr7ptl:	EQU	$13e
Spr0pos:	EQU	$140
Spr0ctl:	EQU	$142
Spr0data:	EQU	$144
Spr0datb:	EQU	$146
Spr1pos:	EQU	$148
Spr1ctl:	EQU	$14a
Spr1data:	EQU	$14c
Spr1datb:	EQU	$14e
Spr2pos:	EQU	$150
Spr2ctl:	EQU	$152
Spr2data:	EQU	$154
Spr2datb:	EQU	$156
Spr3pos:	EQU	$158
Spr3ctl:	EQU	$15a
Spr3data:	EQU	$15c
Spr3datb:	EQU	$15e
Spr4pos:	EQU	$160
Spr4ctl:	EQU	$162
Spr4data:	EQU	$164
Spr4datb:	EQU	$166
Spr5pos:	EQU	$168
Spr5ctl:	EQU	$16a
Spr5data:	EQU	$16c
Spr5datb:	EQU	$16e
Spr6pos:	EQU	$170
Spr6ctl:	EQU	$172
Spr6data:	EQU	$174
Spr6datb:	EQU	$176
Spr7pos:	EQU	$178
Spr7ctl:	EQU	$17a
Spr7data:	EQU	$17c
Spr7datb:	EQU	$17e
Color00:	EQU	$180
Color01:	EQU	$182
Color02:	EQU	$184
Color03:	EQU	$186
Color04:	EQU	$188
Color05:	EQU	$18a
Color06:	EQU	$18c
Color07:	EQU	$18e
Color08:	EQU	$190
Color09:	EQU	$192
Color10:	EQU	$194
Color11:	EQU	$196
Color12:	EQU	$198
Color13:	EQU	$19a
Color14:	EQU	$19c
Color15:	EQU	$19e
Color16:	EQU	$1a0
Color17:	EQU	$1a2
Color18:	EQU	$1a4
Color19:	EQU	$1a6
Color20:	EQU	$1a8
Color21:	EQU	$1aa
Color22:	EQU	$1ac
Color23:	EQU	$1ae
Color24:	EQU	$1b0
Color25:	EQU	$1b2
Color26:	EQU	$1b4
Color27:	EQU	$1b6
Color28:	EQU	$1b8
Color29:	EQU	$1ba
Color30:	EQU	$1bc
Color31:	EQU	$1be
_Custom:	EQU	$dff000




*******************************************************************************
**
**  Interrupt addresses
**
*******************************************************************************
Lev1Base:	EQU	$64
Lev2Base:	EQU	$68
Lev3Base:	EQU	$6c
Lev4Base:	EQU	$70
Lev5Base:	EQU	$74
Lev6Base:	EQU	$78
Lev7Base:	EQU	$7c
Trap0:	EQU	$80






