  K    KKKKKK;------------------T--------T
Track:	EQU	1
Raster:	EQU	0
A1200:	EQU	0


MyDmacon=%01111100000
;         abcdefghhhh
; a = Blitter nasty
; b = Enable DMA activity (always set this!)
; c = Bitplane enable
; d = Copper enable
; e = Blitter enable
; f = Sprite enable
; g = Disk enable
; h = Audio channels enable

MyIntena=%100000000100000
;         abcdeeeefghijkl
; a = Enable interrupts
; b = Lev. 6 External interrupt
; c = Lev. 5 Disk sync found
; d = Lev. 5 Serial port receive buffer full
; e = Lev. 4 Audio ch. 3-0 block finished
; f = Lev. 3 Blitter finished
; g = Lev. 3 Vertical blank
; h = Lev. 3 Copper
; i = Lev. 2 I/O Ports and timers
; j = Lev. 1 Software
; k = Lev. 1 Disk block finished
; l = Lev. 1 Serial port transmit buffer empty

	JumpPtr	Begin

*******************************************************************************
**Macros
*******************************************************************************
WaitBlt:	MACRO
.vent\@:	if	Raster=1
	move.w	#$fff,Color00+_Custom
	endif
	btst	#14,Dmaconr+_Custom
	bne.b	.vent\@
	if	Raster=1
	move.w	#0,Color00+_Custom
	endif
	ENDM

SetInt:	MACRO
	move.l	(Lev\1Base).w,OldIrq\1
	move.l	#Lev\1Irq,(Lev\1Base).w
	bra.b	jumpo\@
OldIrq\1:	dc.l	0
jumpo\@:
	ENDM

ClrInt:	MACRO
	move.l	OldIrq\1(pc),(Lev\1Base).w
	ENDM

Push.l:	MACRO
	movem.l	\1,-(sp)
	ENDM

Push.w:	MACRO
	movem.w	\1,-(sp)
	ENDM

Pull.l:	MACRO
	movem.l	(sp)+,\1
	ENDM

Pull.w:	MACRO
	movem.w	(sp)+,\1
	ENDM

StartPrg:	MACRO
	move.w	#$7fff,Intreq+_Custom
	move.w	#MyDmacon+$8000,Dmacon+_Custom
	move.w	#MyIntena+$8000,Intena+_Custom
	ENDM

StopPrg:	MACRO
	move.w	#$7fff,Intena+_Custom
	move.w	#$7fff,Dmacon+_Custom
	move.w	#$7fff,Intreq+_Custom
	move.w	#$0200,Bplcon0+_Custom
	move.w	#$000,Color00+_Custom
	ENDM

StopSystem:	MACRO
	move.w	Intenar+_Custom,OldIntena
	move.w	Dmaconr+_Custom,OldDmacon
	StopPrg
	bra.b	jumpo\@
OldIntena:	dc.w	0
OldDmacon:	dc.w	0
jumpo\@:
	ENDM

StartSystem:	MACRO
	move.w	OldDmacon(pc),d0
	or.w	#$8000,d0
	move.w	d0,Dmacon+_Custom
	move.w	OldIntena(pc),d0
	or.w	#$8000,d0
	move.w	d0,Intena+_Custom
	ENDM

ClearBss:	MACRO
	lea	_Bss\1Start,a0
	move.l	#(_Bss\1End-_Bss\1Start)/4,d0
.clrloop\@	clr.l	(a0)+
	subq.l	#1,d0
	bne.b	.clrloop\@
	ENDM




*******************************************************************************
**
**  Initialisering
**
*******************************************************************************
	SECTION	DenFedeKode,code

Begin:	IFEQ	Track-0
	Push.l	d0-a6
	StopSystem
	ELSE
	move.l	#Lev3Irq,$64.w
	rts
	ENDC

**Init starter -----------------------------------
	ClearBss	1
	ClearBss	2

	lea	Picture1(pc),a0
	lea	208*4(a0),a1
	move.w	#208-1,d0
.initpic1	move.l	(a0),a2
	add.l	a1,a2
	move.l	a2,(a0)+
	dbra	d0,.initpic1

	lea	StretchBuffer,a0
	move.w	#128-1,d0		;antal strrelser
	moveq	#0,d2		;strrelse
.nextsize	moveq	#-128,d1		;startpos
.nextword	move.w	d2,d3
	muls	d1,d3
	divs	#104,d3
	add.w	#128,d3
	muls	#44*2,d3
	move.w	d3,(a0)+
	addq.w	#1,d1
	cmp.w	#128,d1
	bne.b	.nextword
	addq.w	#1,d2
	dbra	d0,.nextsize

	lea	PrecalcBuffer+256*2,a0
	moveq	#1,d0
.entryloop2	moveq	#0,d1
.entryloop	move.w	d1,d2
	muls	#208,d2
	divs	d0,d2
	add.w	d2,d2
	add.w	d2,d2
	move.w	d2,(a0)+
	addq.b	#1,d1
	bne.b	.entryloop
	addq.b	#1,d0
	bne.b	.entryloop2

	lea	Lsl9Tab,a0
	moveq	#0,d0
.lsl9	move.l	d0,d1
	add.l	#StretchBuffer,d1
	move.l	d1,(a0)+
	add.l	#1<<9,d0
	cmp.l	#256<<9,d0
	bne.b	.lsl9

	IFEQ	Track-0
	SetInt	3
**Init slutter -----------------------------------

	WaitBlt
	StartPrg




*******************************************************************************
**
**  Vent p exitsignal
**
*******************************************************************************
WaitForExit:	tst.b	VBlank
	beq.b	WaitForExit

	clr.b	VBlank
	tst.b	IWantOut
	bne.b	ExitToDos
	bra.b	WaitForExit




*******************************************************************************
**
**  Exit to AmigaDOS
**
*******************************************************************************
ExitToDos:
	StopPrg

**Exit starter -----------------------------------
	ClrInt	3
**Exit slutter -----------------------------------

	StartSystem

	Pull.l	d0-a6
	moveq	#0,d0
	ENDC
	rts




*******************************************************************************
**
**  Level 3 interrupt
**
*******************************************************************************
Lev3Irq:	st	VBlank
	push.l	d0-a6
**Lev3irq starter --------------------------------
	lea	Routines(pc),a0
	move.w	Status(pc),d0
	add.w	d0,d0
	add.w	d0,d0
	move.l	(a0,d0.w),a0
	jsr	(a0)
**Lev3irq slutter --------------------------------
	IFEQ	Track-0
	btst	#6,$bfe001
	bne.b	.noleft
	st	IWantOut
.noleft	ENDC
	IF	Raster=1
	move.w	#$f00,Color00+_Custom
	ENDIF
	WaitBlt
	IF	Raster=1
	move.w	#$00f,Color00+_Custom
	ENDIF
	move.b	$dff005,d0
	lsl.w	#8,d0
	move.b	$dff006,d0
	cmp.w	MaxRast,d0
	blt.b	.ud
	move.w	d0,MaxRast
.ud:
	pull.l	d0-a6
	IFEQ	Track-0
	move.w	#$0020,Intreq+_Custom
	ELSE
	move.w	#$0004,Intreq+_Custom
	ENDC
	rte


Status:	dc.w	0
Routines:	dc.l	FadeHandler,CubeHandler,FadeHandler2

FadeHandler:	move.l	#FaderCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom

	move.w	Svend(pc),d0
	moveq	#0,d1
	bsr	ParFader
	move.w	d0,Svend
	lsr.w	#4,d0
	tst.w	d0
	bge.b	.ok
	moveq	#0,d0
.ok	move.w	d0,d1
	add.w	#$d8,d0
	move.b	d0,FaderCopper|.pos2
	neg.w	d1
	add.w	#$d8,d1
	move.b	d1,FaderCopper|.pos1
	cmp.w	#$100,d0
	bge.b	.pal
	move.w	#$0001,FaderCopper|.pal
.pal	cmp.b	#$d8,d1
	bne.b	.out
	addq.w	#1,Status
.out
	rts

Svend:	dc.w	200*16


FadeHandler2:	move.l	#FaderCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom

	move.w	ParSpeed(pc),d0
	sub.w	d0,OldGed
	lsr.w	#4,d0
	bne.b	.norm
	moveq	#1,d0
.norm	add.w	d0,ParSpeed

	move.w	OldGed(pc),d0
	tst.w	d0
	bgt.b	.norm2
	st	IWantOut
	moveq	#0,d0
.norm2	move.b	d0,FaderCopper|.pos1
	move.w	#$d8,d1
	sub.w	d0,d1
	add.w	#$d8,d1
	cmp.w	#$100,d1
	blt.b	.nopal
	move.w	#$ffe1,FaderCopper|.pal
.nopal	move.b	d1,FaderCopper|.pos2
	rts

OldGed:	dc.w	$d8

ParSpeed:	dc.w	1

**in:
** d0=fra
** d1=til
**out:
** d0=ny pos
ParFader:	sub.w	d0,d1
	beq.b	.out
	asr.w	#4,d1
	tst.w	d1
	bne.b	.norm
	moveq	#1,d1
.norm	add.w	d1,d0
.out	rts



CubeHandler:	move.l	#Copper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#%10,Copcon+_Custom

	bsr	SwapScr
	bsr	MoveObject
	bsr	DrawCube
	bsr	FadeSvend
	rts

FadeEmNow:	dc.w	0

FadeSvend:	cmp.w	#16*2,SinusPtr
	ble.b	.fadeem
	tst.w	FadeEmNow
	bne.b	.fadedn
	rts

.fadedn	lea	Colors+2,a1
	moveq	#4-1,d7
.loop2	move.w	(a1),d0
	move.w	#$043,d1
	bsr	fader
	move.w	d0,(a1)
	addq.w	#4,a1
	dbra	d7,.loop2
	rts

.fadeem	lea	Colors+2,a1
	lea	ColBck,a0
	moveq	#4-1,d7
.loop	move.w	(a1),d0
	move.w	(a0)+,d1
	bsr	fader
	move.w	d0,(a1)
	addq.w	#4,a1
	dbra	d7,.loop
	rts

ColBck:	dc.w	$0043
	dc.w	$0300
	dc.w	$0620
	dc.w	$0FFF


**d0=fade from
**d1=fade to
**out: d0=newcol
fader:	move.w	d0,d2
	move.w	d1,d3
	lsr.w	#8,d2
	lsr.w	#8,d3
	cmp.w	d2,d3
	beq.b	.nored
	blt.b	.redsub
	add.w	#$100,d0
	bra.b	.nored
.redsub:	sub.w	#$100,d0
.nored:	move.w	d0,d2
	move.w	d1,d3
	lsr.w	#4,d2
	lsr.w	#4,d3
	and.w	#$f,d2
	and.w	#$f,d3
	cmp.w	d2,d3
	beq.b	.nogreen
	blt.b	.greensub
	add.w	#$10,d0
	bra.b	.nogreen
.greensub:	sub.w	#$10,d0
.nogreen:	move.w	d0,d2
	move.w	d1,d3
	and.w	#$f,d2
	and.w	#$f,d3
	cmp.w	d2,d3
	beq.b	.noblue
	blt.b	.bluesub
	addq.w	#$1,d0
	bra.b	.noblue
.bluesub:	subq.w	#$1,d0
.noblue:	rts


*******************************************************************************
**
**  Move object
**
*******************************************************************************
ObjStat:	dc.w	0
ObjPause:	dc.w	0
MoveObject:	move.w	ObjStat(pc),d0
	beq.b	Stat_00
	subq.w	#1,d0
	beq.b	Stat_Pause
	subq.w	#1,d0
	beq.b	Stat_01
	IFEQ	A1200-0
	subq.w	#1,d0
	beq.w	Stat_A500
	ENDC
	subq.w	#1,d0
	beq.w	Stat_02
	subq.w	#1,d0
	beq.w	Stat_03
	rts

MoveIt:	lea	XSinus(pc),a0
	lea	ZSinus(pc),a1
	move.w	SinusPtr(pc),d0
	move.w	(a0,d0.w),XCenter
	move.w	(a1,d0.w),ZCenter
	addq.w	#2,SinusPtr
	rts

Stat_00:	bsr	MoveIt
	move.w	#30,YAdd
	cmp.w	#201*2,SinusPtr
	bne.b	.out
	addq.w	#1,ObjStat
	move.w	#50*3,ObjPause
.out	rts

Stat_Pause:	subq.w	#1,ObjPause
	bne.b	.out
	addq.w	#1,ObjStat
.out	rts

Stat_01Pause:	dc.w	4
Stat_01:	subq.w	#1,Stat_01Pause
	bne.b	.out
	move.w	#6,Stat_01Pause
	subq.w	#2,YAdd
	cmp.w	#-40,YAdd
	bne.b	.out
	addq.w	#1,ObjStat
.out	rts

Stat_02:	tst.w	YCenter
	bne.b	.makezero
	move.w	Stat_01Pause,YCenter
	subq.w	#2,Stat_01Pause
	cmp.w	#-72,Stat_01Pause
	bgt.b	.out
	addq.w	#1,ObjStat
.out	rts
.makezero	clr.w	YCenter
	rts

Stat_03:	move.w	#-100,YAdd
	add.w	#1000,ZCenter
	sub.w	#500,XCenter
	cmp.w	#14000,ZCenter
	shi	FadeEmNow
	cmp.w	#30000,ZCenter
	blt.b	.out
	addq.w	#1,Status
.out	rts

	IFEQ	A1200-0

Stat_A500:	lea	A500Sinus(pc),a0
	add.w	A500Ptr(pc),a0
	move.w	(a0),YCenter
	addq.w	#2,A500Ptr
	cmp.w	#35*2+2,A500Ptr
	bne.b	.out
	addq.w	#1,ObjStat
.out	rts

A500Ptr:	dc.w	0
A500Sinus:	;0,180,35,600,0,w,1,y,n
	DC.W	$001A,$0050,$0085,$00B9,$00EB,$011C,$014A,$0176,$019E,$01C3
	DC.W	$01E5,$0203,$021C,$0231,$0242,$024E,$0255,$0258,$0255,$024E
	DC.W	$0242,$0231,$021C,$0203,$01E5,$01C3,$019E,$0176,$014A,$011C
	DC.W	$00EB,$00B9,$0085,$0050,$001A
	dc.w	0

	ENDC



SinusPtr:	dc.w	0

XSinus:	;180,270,200,10000,10000,w,1,y,n
	DC.W	$26E9,$269B,$264C,$25FE,$25AF,$2561,$2512,$24C4,$2475,$2427
	DC.W	$23D9,$238B,$233C,$22EE,$22A0,$2252,$2204,$21B6,$2169,$211B
	DC.W	$20CD,$2080,$2033,$1FE5,$1F98,$1F4B,$1EFE,$1EB1,$1E65,$1E18
	DC.W	$1DCC,$1D80,$1D34,$1CE8,$1C9C,$1C50,$1C05,$1BBA,$1B6F,$1B24
	DC.W	$1AD9,$1A8F,$1A44,$19FA,$19B0,$1967,$191D,$18D4,$188B,$1842
	DC.W	$17F9,$17B1,$1769,$1721,$16DA,$1692,$164B,$1604,$15BE,$1578
	DC.W	$1532,$14EC,$14A7,$1461,$141D,$13D8,$1394,$1350,$130C,$12C9
	DC.W	$1286,$1243,$1201,$11BF,$117D,$113C,$10FB,$10BB,$107A,$103A
	DC.W	$0FFB,$0FBC,$0F7D,$0F3F,$0F00,$0EC3,$0E85,$0E49,$0E0C,$0DD0
	DC.W	$0D94,$0D59,$0D1E,$0CE3,$0CA9,$0C70,$0C36,$0BFE,$0BC5,$0B8D
	DC.W	$0B56,$0B1F,$0AE8,$0AB2,$0A7C,$0A47,$0A12,$09DD,$09A9,$0976
	DC.W	$0943,$0910,$08DE,$08AD,$087C,$084B,$081B,$07EB,$07BC,$078D
	DC.W	$075F,$0732,$0704,$06D8,$06AC,$0680,$0655,$062A,$0600,$05D7
	DC.W	$05AE,$0585,$055D,$0536,$050F,$04E8,$04C3,$049D,$0479,$0454
	DC.W	$0431,$040E,$03EB,$03C9,$03A8,$0387,$0366,$0347,$0327,$0309
	DC.W	$02EB,$02CD,$02B0,$0294,$0278,$025D,$0242,$0228,$020F,$01F6
	DC.W	$01DE,$01C6,$01AF,$0199,$0183,$016D,$0159,$0145,$0131,$011E
	DC.W	$010C,$00FA,$00E9,$00D8,$00C8,$00B9,$00AA,$009C,$008F,$0082
	DC.W	$0076,$006A,$005F,$0054,$004B,$0041,$0039,$0031,$0029,$0022
	DC.W	$001C,$0017,$0012,$000E,$000A,$0007,$0004,$0002,$0001,$0001

	dc.w	0


ZSinus:	IFEQ	A1200-1
	;90,180,200,25000,2650,w,1,y,n
	DC.W	$6C01,$6C00,$6BFD,$6BF8,$6BF2,$6BEA,$6BE1,$6BD6,$6BCA,$6BBC
	DC.W	$6BAD,$6B9C,$6B89,$6B75,$6B60,$6B48,$6B30,$6B16,$6AFA,$6ADD
	DC.W	$6ABE,$6A9E,$6A7C,$6A59,$6A34,$6A0E,$69E6,$69BD,$6992,$6965
	DC.W	$6938,$6908,$68D7,$68A5,$6871,$683C,$6805,$67CD,$6793,$6758
	DC.W	$671B,$66DD,$669E,$665D,$661A,$65D6,$6591,$654A,$6502,$64B8
	DC.W	$646D,$6420,$63D2,$6383,$6332,$62E0,$628C,$6237,$61E1,$6189
	DC.W	$6130,$60D5,$607A,$601C,$5FBE,$5F5E,$5EFC,$5E9A,$5E36,$5DD1
	DC.W	$5D6A,$5D02,$5C99,$5C2E,$5BC3,$5B56,$5AE7,$5A78,$5A07,$5994
	DC.W	$5921,$58AC,$5837,$57BF,$5747,$56CD,$5653,$55D7,$555A,$54DB
	DC.W	$545C,$53DB,$5359,$52D6,$5252,$51CD,$5146,$50BF,$5036,$4FAC
	DC.W	$4F22,$4E96,$4E09,$4D7B,$4CEB,$4C5B,$4BCA,$4B38,$4AA5,$4A10
	DC.W	$497B,$48E5,$484D,$47B5,$471C,$4682,$45E6,$454A,$44AD,$440F
	DC.W	$4371,$42D1,$4230,$418F,$40EC,$4049,$3FA5,$3F00,$3E5A,$3DB4
	DC.W	$3D0C,$3C64,$3BBB,$3B11,$3A67,$39BB,$390F,$3862,$37B5,$3707
	DC.W	$3658,$35A8,$34F8,$3447,$3395,$32E3,$3230,$317C,$30C8,$3013
	DC.W	$2F5E,$2EA8,$2DF1,$2D3A,$2C82,$2BCA,$2B12,$2A58,$299E,$28E4
	DC.W	$2829,$276E,$26B3,$25F6,$253A,$247D,$23C0,$2302,$2244,$2185
	DC.W	$20C6,$2007,$1F47,$1E87,$1DC7,$1D06,$1C46,$1B84,$1AC3,$1A01
	DC.W	$193F,$187D,$17BB,$16F8,$1635,$1572,$14AF,$13EC,$1328,$1265
	DC.W	$11A1,$10DD,$1019,$0F55,$0E91,$0DCD,$0D09,$0C44,$0B80,$0ABC
	dc.w	2650
	ELSE
	;90,180,200,23500,4100,w,1,y,n
	DC.W	$6B6B,$6B6A,$6B67,$6B63,$6B5D,$6B56,$6B4D,$6B43,$6B37,$6B2A
	DC.W	$6B1C,$6B0C,$6AFA,$6AE8,$6AD3,$6ABE,$6AA6,$6A8E,$6A74,$6A58
	DC.W	$6A3C,$6A1D,$69FE,$69DC,$69BA,$6996,$6970,$694A,$6921,$68F8
	DC.W	$68CC,$68A0,$6872,$6843,$6812,$67E0,$67AC,$6778,$6741,$670A
	DC.W	$66D1,$6696,$665A,$661D,$65DF,$659F,$655E,$651B,$64D7,$6492
	DC.W	$644B,$6403,$63BA,$636F,$6323,$62D6,$6287,$6238,$61E6,$6194
	DC.W	$6140,$60EB,$6095,$603D,$5FE4,$5F8A,$5F2E,$5ED2,$5E74,$5E15
	DC.W	$5DB4,$5D53,$5CF0,$5C8B,$5C26,$5BC0,$5B58,$5AEF,$5A85,$5A19
	DC.W	$59AD,$593F,$58D1,$5861,$57EF,$577D,$570A,$5695,$5620,$55A9
	DC.W	$5531,$54B8,$543E,$53C3,$5347,$52C9,$524B,$51CC,$514B,$50CA
	DC.W	$5047,$4FC4,$4F3F,$4EBA,$4E33,$4DAB,$4D23,$4C99,$4C0F,$4B84
	DC.W	$4AF7,$4A6A,$49DC,$494D,$48BD,$482C,$479A,$4707,$4673,$45DF
	DC.W	$454A,$44B4,$441D,$4385,$42EC,$4253,$41B8,$411D,$4081,$3FE5
	DC.W	$3F47,$3EA9,$3E0A,$3D6B,$3CCB,$3C29,$3B88,$3AE5,$3A42,$399E
	DC.W	$38FA,$3855,$37AF,$3709,$3662,$35BA,$3512,$3469,$33C0,$3316
	DC.W	$326B,$31C0,$3115,$3068,$2FBC,$2F0F,$2E61,$2DB3,$2D04,$2C55
	DC.W	$2BA6,$2AF6,$2A45,$2994,$28E3,$2831,$277F,$26CD,$261A,$2567
	DC.W	$24B4,$2400,$234C,$2297,$21E3,$212E,$2078,$1FC3,$1F0D,$1E57
	DC.W	$1DA1,$1CEA,$1C33,$1B7C,$1AC5,$1A0E,$1956,$189F,$17E7,$172F
	DC.W	$1677,$15BF,$1507,$144F,$1396,$12DE,$1225,$116D,$10B4,$0FFC
	dc.w	4050
	ENDC






*******************************************************************************
**
**  FillScr
**
*******************************************************************************
A=%11110000
B=%11001100
C=%10101010

FillScr:	lea	_Custom,a6
	move.l	Screen_Draw(pc),a0
	lea	88(a0),a1
	WaitBlt
	move.l	a1,Bltdpth(a6)
	move.l	a1,Bltcpth(a6)
	move.l	a0,Bltapth(a6)
	move.l	#(%1011<<24)!(((A&~C)!(~A&C))<<16),Bltcon0(a6)
	move.l	#0,Bltamod(a6)
	move.w	#0,Bltcmod(a6)
	move.l	#-1,Bltafwm(a6)
	move.w	#180<<6!44,Bltsize(a6)
	rts




*******************************************************************************
**
**  Draw cube
**
*******************************************************************************
CubeXPos:	dc.w	0
CubeXSize:	dc.w	207
CubeYBase:	dc.w	50
CubeYMax:	dc.w	127-50
DrawCube:	bsr	Rotate
	move.w	PerspCoords+4(pc),d1
	move.w	PerspCoords(pc),d0
	sub.w	d0,d1
	ble.b	.face2
	move.w	d0,CubeXPos
	move.w	d1,CubeXSize
	move.w	PerspCoords+6(pc),d1
	move.w	PerspCoords+2(pc),d0
	sub.w	d0,d1
	sub.w	#128,d0
	move.w	d0,CubeYBase
	move.w	d1,CubeYMax
	bsr	DrawFace

.face2	move.w	PerspCoords+4+4(pc),d1
	move.w	PerspCoords+4(pc),d0
	sub.w	d0,d1
	ble.b	.face3
	move.w	d0,CubeXPos
	move.w	d1,CubeXSize
	move.w	PerspCoords+6+4(pc),d1
	move.w	PerspCoords+2+4(pc),d0
	sub.w	d0,d1
	sub.w	#128,d0
	move.w	d0,CubeYBase
	move.w	d1,CubeYMax
	bsr	DrawFace

.face3	rts


DrawFace:	move.l	Screen_Draw(pc),a5
	lea	Picture1(pc),a6

	moveq	#0,d2
	move.w	CubeXSize(pc),d2
	lsl.l	#8,d2
	add.l	d2,d2
	lea	PrecalcBuffer,a2
	lea	(a2,d2.l),a2
	move.w	CubeXSize(pc),d2
	moveq	#0,d3
	move.w	d2,d4
	move.w	CubeYMax(pc),d5
	move.w	CubeYBase(pc),d6
	move.w	CubeXPos(pc),d7
	lea	Lsl9Tab,a3
	bra.b	.jumpin
.loop	moveq	#0,d0
	move.w	d3,d0
	muls	d5,d0
	divs	d4,d0
	add.w	d6,d0
	add.w	d0,d0
	add.w	d0,d0
	move.l	(a3,d0.w),a0
	move.w	d3,d0
	add.w	d7,d0
	move.w	d0,d1
	not.b	d1
	and.w	#%111,d1		;bitpos
	lsr.w	#3,d0
	lea	(a5,d0.w),a1	;screen
	pea	.jump(pc)
	move.w	d3,d0
	add.w	d0,d0
	move.w	(a2,d0.w),d0
	move.l	(a6,d0.w),-(sp)
	rts
.jump	addq.w	#1,d3
.jumpin	dbra	d2,.loop
	rts

*******************************************************************************
**
**  Prv lidt rotation
**
*******************************************************************************
Rotate:	lea	Coords,a0
	lea	PerspCoords,a1
	lea	CosTable,a2
	lea	SinTable,a3
	lea	Angles,a4
	lea	XCenter,a5
	sub.w	a6,a6

.nextkoord	cmp.w	#$8000,(a0)
	beq.w	.out

	move.w	(a0)+,d0
.RotXZ:	move	(a0)+,d1	;d0=Xp , d1=Zp & d2=Vinkel
	move	(a4),d2
	move	(a2,d2.w),d3
	move	(a3,d2.w),d4
	move	d0,d5
	move	d1,d6
	muls	d3,d0
	muls	d4,d1
	muls	d4,d5
	muls	d3,d6
	sub.l	d1,d0
	add.l	d6,d5
	lsl.l	#2,d0
	lsl.l	#2,d5
	swap	d0		;X
	swap	d5		;Z
	move.w	d5,d1
	move.w	#750,d7

	add.w	4(a5),d1	;Z
	add.w	(a5),d0
	add.w	2(a5),d7
	ext.l	d0
	ext.l	d7
	lsl.l	#8,d0
	lsl.l	#8,d7
	divs	d1,d0
	divs	d1,d7
	add	#352/2,d0
	add	#256/2,d7
.GemCor:	move	d0,(a1)+
	move	d7,(a1)+
	addq.w	#1,a6
	bra.w	.nextkoord
.Out:
	move.w	YAdd(pc),d0
	lea	Angles(pc),a0
	add.w	d0,(a0)
	and.w	#512-1,(a0)
	rts






;Option n  = 1
;Min. y-val = -1.63840E+04
;Max. y-val =  1.63840E+04
;Startvalue = min
;Length     = 1024
SinTable:	dc.w	0,101,201,302,402,503,603,704,804,904,1005,1105,1205,1306,1406,1506
	dc.w	1606,1706,1806,1906,2006,2105,2205,2305,2404,2503,2603,2702,2801,2900,2999,3098
	dc.w	3196,3295,3393,3492,3590,3688,3786,3883,3981,4078,4176,4273,4370,4467,4563,4660
	dc.w	4756,4852,4948,5044,5139,5235,5330,5425,5520,5614,5708,5803,5897,5990,6084,6177
	dc.w	6270,6363,6455,6547,6639,6731,6823,6914,7005,7096,7186,7276,7366,7456,7545,7635
	dc.w	7723,7812,7900,7988,8076,8163,8250,8337,8423,8509,8595,8680,8765,8850,8935,9019
	dc.w	9102,9186,9269,9352,9434,9516,9598,9679,9760,9841,9921,10001,10080,10159,10238,10316
	dc.w	10394,10471,10549,10625,10702,10778,10853,10928,11003,11077,11151,11224,11297,11370,11442,11514
	dc.w	11585,11656,11727,11797,11866,11935,12004,12072,12140,12207,12274,12340,12406,12472,12537,12601
	dc.w	12665,12729,12792,12854,12916,12978,13039,13100,13160,13219,13279,13337,13395,13453,13510,13567
	dc.w	13623,13678,13733,13788,13842,13896,13949,14001,14053,14104,14155,14206,14256,14305,14354,14402
	dc.w	14449,14497,14543,14589,14635,14680,14724,14768,14811,14854,14896,14937,14978,15019,15059,15098
	dc.w	15137,15175,15213,15250,15286,15322,15357,15392,15426,15460,15493,15525,15557,15588,15619,15649
	dc.w	15679,15707,15736,15763,15791,15817,15843,15868,15893,15917,15941,15964,15986,16008,16029,16049
	dc.w	16069,16088,16107,16125,16143,16160,16176,16192,16207,16221,16235,16248,16261,16273,16284,16295
	dc.w	16305,16315,16324,16332,16340,16347,16353,16359,16364,16369,16373,16376,16379,16381,16383,16384
CosTable:	dc.w	16384,16384,16383,16381,16379,16376,16373,16369,16364,16359,16353,16347,16340,16332,16324,16315
	dc.w	16305,16295,16284,16273,16261,16248,16235,16221,16207,16192,16176,16160,16143,16125,16107,16088
	dc.w	16069,16049,16029,16008,15986,15964,15941,15917,15893,15868,15843,15817,15791,15763,15736,15707
	dc.w	15679,15649,15619,15588,15557,15525,15493,15460,15426,15392,15357,15322,15286,15250,15213,15175
	dc.w	15137,15098,15059,15019,14978,14937,14896,14854,14811,14768,14724,14680,14635,14589,14543,14497
	dc.w	14449,14402,14354,14305,14256,14206,14155,14104,14053,14001,13949,13896,13842,13788,13733,13678
	dc.w	13623,13567,13510,13453,13395,13337,13279,13219,13160,13100,13039,12978,12916,12854,12792,12729
	dc.w	12665,12601,12537,12472,12406,12340,12274,12207,12140,12072,12004,11935,11866,11797,11727,11656
	dc.w	11585,11514,11442,11370,11297,11224,11151,11077,11003,10928,10853,10778,10702,10625,10549,10471
	dc.w	10394,10316,10238,10159,10080,10001,9921,9841,9760,9679,9598,9516,9434,9352,9269,9186
	dc.w	9102,9019,8935,8850,8765,8680,8595,8509,8423,8337,8250,8163,8076,7988,7900,7812
	dc.w	7723,7635,7545,7456,7366,7276,7186,7096,7005,6914,6823,6731,6639,6547,6455,6363
	dc.w	6270,6177,6084,5990,5897,5803,5708,5614,5520,5425,5330,5235,5139,5044,4948,4852
	dc.w	4756,4660,4563,4467,4370,4273,4176,4078,3981,3883,3786,3688,3590,3492,3393,3295
	dc.w	3196,3098,2999,2900,2801,2702,2603,2503,2404,2305,2205,2105,2006,1906,1806,1706
	dc.w	1606,1506,1406,1306,1205,1105,1005,904,804,704,603,503,402,302,201,101
	dc.w	0,-101,-201,-302,-402,-503,-603,-703,-804,-904,-1005,-1105,-1205,-1306,-1406,-1506
	dc.w	-1606,-1706,-1806,-1906,-2006,-2105,-2205,-2305,-2404,-2503,-2603,-2702,-2801,-2900,-2999,-3098
	dc.w	-3196,-3295,-3393,-3492,-3590,-3688,-3786,-3883,-3981,-4078,-4176,-4273,-4370,-4467,-4563,-4660
	dc.w	-4756,-4852,-4948,-5044,-5139,-5235,-5330,-5425,-5520,-5614,-5708,-5803,-5897,-5990,-6084,-6177
	dc.w	-6270,-6363,-6455,-6547,-6639,-6731,-6823,-6914,-7005,-7096,-7186,-7276,-7366,-7456,-7545,-7635
	dc.w	-7723,-7812,-7900,-7988,-8076,-8163,-8250,-8337,-8423,-8509,-8595,-8680,-8765,-8850,-8935,-9019
	dc.w	-9102,-9186,-9269,-9352,-9434,-9516,-9598,-9679,-9760,-9840,-9921,-10001,-10080,-10159,-10238,-10316
	dc.w	-10394,-10471,-10549,-10625,-10702,-10778,-10853,-10928,-11003,-11077,-11151,-11224,-11297,-11370,-11442,-11514
	dc.w	-11585,-11656,-11727,-11797,-11866,-11935,-12004,-12072,-12140,-12207,-12274,-12340,-12406,-12472,-12537,-12601
	dc.w	-12665,-12729,-12792,-12854,-12916,-12978,-13039,-13100,-13160,-13219,-13279,-13337,-13395,-13453,-13510,-13567
	dc.w	-13623,-13678,-13733,-13788,-13842,-13896,-13949,-14001,-14053,-14104,-14155,-14206,-14256,-14305,-14354,-14402
	dc.w	-14449,-14497,-14543,-14589,-14635,-14680,-14724,-14768,-14811,-14854,-14896,-14937,-14978,-15019,-15059,-15098
	dc.w	-15137,-15175,-15213,-15250,-15286,-15322,-15357,-15392,-15426,-15460,-15493,-15525,-15557,-15588,-15619,-15649
	dc.w	-15679,-15707,-15736,-15763,-15791,-15817,-15843,-15868,-15893,-15917,-15941,-15964,-15986,-16008,-16029,-16049
	dc.w	-16069,-16088,-16107,-16125,-16143,-16160,-16176,-16192,-16207,-16221,-16235,-16248,-16261,-16273,-16284,-16295
	dc.w	-16305,-16315,-16324,-16332,-16340,-16347,-16353,-16359,-16364,-16369,-16373,-16376,-16379,-16381,-16383,-16384
	dc.w	-16384,-16384,-16383,-16381,-16379,-16376,-16373,-16369,-16364,-16359,-16353,-16347,-16340,-16332,-16324,-16315
	dc.w	-16305,-16295,-16284,-16273,-16261,-16248,-16235,-16221,-16207,-16192,-16176,-16160,-16143,-16125,-16107,-16088
	dc.w	-16069,-16049,-16029,-16008,-15986,-15964,-15941,-15917,-15893,-15868,-15843,-15817,-15791,-15763,-15736,-15707
	dc.w	-15679,-15649,-15619,-15588,-15557,-15525,-15493,-15460,-15426,-15392,-15357,-15322,-15286,-15250,-15213,-15175
	dc.w	-15137,-15098,-15059,-15019,-14978,-14937,-14896,-14854,-14811,-14768,-14724,-14680,-14635,-14589,-14543,-14497
	dc.w	-14449,-14402,-14354,-14305,-14256,-14206,-14155,-14104,-14053,-14001,-13949,-13896,-13842,-13788,-13733,-13678
	dc.w	-13623,-13567,-13510,-13453,-13395,-13337,-13279,-13219,-13160,-13100,-13039,-12978,-12916,-12854,-12792,-12729
	dc.w	-12665,-12601,-12537,-12472,-12406,-12340,-12274,-12207,-12140,-12072,-12004,-11935,-11866,-11797,-11727,-11656
	dc.w	-11585,-11514,-11442,-11370,-11297,-11224,-11151,-11077,-11003,-10928,-10853,-10778,-10702,-10625,-10549,-10471
	dc.w	-10394,-10316,-10238,-10159,-10080,-10001,-9921,-9841,-9760,-9679,-9598,-9516,-9434,-9352,-9269,-9186
	dc.w	-9102,-9019,-8935,-8850,-8765,-8680,-8595,-8509,-8423,-8337,-8250,-8163,-8076,-7988,-7900,-7812
	dc.w	-7723,-7635,-7545,-7456,-7366,-7277,-7186,-7096,-7005,-6914,-6823,-6731,-6639,-6547,-6455,-6363
	dc.w	-6270,-6177,-6084,-5990,-5897,-5803,-5708,-5614,-5520,-5425,-5330,-5235,-5139,-5044,-4948,-4852
	dc.w	-4756,-4660,-4563,-4467,-4370,-4273,-4176,-4078,-3981,-3883,-3786,-3688,-3590,-3492,-3393,-3295
	dc.w	-3196,-3098,-2999,-2900,-2801,-2702,-2603,-2503,-2404,-2305,-2205,-2105,-2006,-1906,-1806,-1706
	dc.w	-1606,-1506,-1406,-1306,-1205,-1105,-1005,-904,-804,-704,-603,-503,-402,-302,-201,-101
	dc.w	0,101,201,302,402,503,603,704,804,904,1005,1105,1205,1306,1406,1506
	dc.w	1606,1706,1806,1906,2006,2105,2205,2305,2404,2503,2603,2702,2801,2900,2999,3098
	dc.w	3196,3295,3393,3492,3590,3688,3786,3883,3981,4078,4176,4273,4370,4467,4563,4660
	dc.w	4756,4852,4948,5044,5139,5235,5330,5425,5520,5614,5708,5803,5897,5990,6084,6177
	dc.w	6270,6363,6455,6547,6639,6731,6823,6914,7005,7096,7186,7276,7366,7456,7545,7635
	dc.w	7723,7812,7900,7988,8076,8163,8250,8337,8423,8509,8595,8680,8765,8850,8935,9019
	dc.w	9102,9186,9269,9352,9434,9516,9598,9679,9760,9841,9921,10001,10080,10159,10238,10316
	dc.w	10394,10471,10549,10625,10702,10778,10853,10928,11003,11077,11151,11224,11297,11370,11442,11514
	dc.w	11585,11656,11727,11797,11866,11935,12004,12072,12140,12207,12274,12340,12406,12472,12537,12601
	dc.w	12665,12729,12792,12854,12916,12978,13039,13100,13160,13219,13279,13337,13395,13453,13510,13567
	dc.w	13623,13678,13733,13788,13842,13896,13949,14001,14053,14104,14155,14206,14256,14305,14354,14402
	dc.w	14449,14497,14543,14589,14635,14680,14724,14768,14811,14854,14896,14937,14978,15019,15059,15098
	dc.w	15137,15175,15213,15250,15286,15322,15357,15392,15426,15460,15493,15525,15557,15588,15619,15649
	dc.w	15679,15707,15736,15763,15791,15817,15843,15868,15893,15917,15941,15964,15986,16008,16029,16049
	dc.w	16069,16088,16107,16125,16143,16160,16176,16192,16207,16221,16235,16248,16261,16273,16284,16295
	dc.w	16305,16315,16324,16332,16340,16347,16353,16359,16364,16369,16373,16376,16379,16381,16383,16384





*******************************************************************************
**
**  Clear screen using blitter
**
*******************************************************************************
ClrScr:	lea	_Custom,a6
	WaitBlt
	move.l	Screen_Clear,Bltdpth(a6)
	move.l	#$01000000,Bltcon0(a6)
	move.w	#0,Bltdmod(a6)
	move.w	#256<<6!44,Bltsize(a6)
	rts




*******************************************************************************
**
**  Swap screen for doublebuffering!
**
*******************************************************************************
SwapScr:	lea	Screen_Clear+4*4,a0
	lea	-4(a0),a1
	move.l	(a1),d7
	moveq	#3-1,d6
.cloop	move.l	-(a1),-(a0)
	dbra	d6,.cloop
	move.l	d7,(a1)

	lea	Copper_PlanePtr+2,a3
	move.l	Screen_Show(pc),d0
	moveq	#2-1,d1
.loop	move.w	d0,4(a3)
	swap	d0
	move.w	d0,(a3)
	swap	d0
	add.l	#44,d0
	addq.w	#8,a3
	dbra	d1,.loop

	lea	Copper_FillPtr+2,a3
	move.l	Screen_Fill(pc),d0
	add.l	#(44-32)/2,d0
	move.l	d0,d1
	add.l	#88,d1
	move.w	d1,4(a3)
	move.w	d1,8+4(a3)
	swap	d1
	move.w	d1,(a3)
	move.w	d1,8(a3)
	move.w	d0,16+4(a3)
	swap	d0
	move.w	d0,16(a3)

	lea	Copper_ClrPtr+2,a3
	move.l	Screen_Clear(pc),d0
	add.l	#(44-32)/2,d0
	move.w	d0,4(a3)
	swap	d0
	move.w	d0,(a3)

	rts




*******************************************************************************
**
**  Variable
**
*******************************************************************************

Coords:	dc.w	-750,750
	dc.w	-750,-750
	dc.w	750,-750
	dc.w	$8000

PerspCoords:	dc.l	0,0,0

Screen_Clear:	dc.l	Screen1
Screen_Draw:	dc.l	Screen2
Screen_Fill:	dc.l	Screen3
Screen_Show:	dc.l	Screen4

XCenter:	dc.w	7000
YCenter:	dc.w	0
ZCenter:	dc.w	2600*10

YAdd:	dc.w	20

Angles:	dc.w	0

MaxRast:	dc.w	0
VBlank:	dc.b	0
	IFEQ	Track-0
IWantOut:	dc.b	0
	ELSE
	dc.b	0
IWantOut:	EQU	$80
	ENDC

	INCDIR	"Work:Code/Sources/HTSAC/FractalCube/"
Picture1:	INCBIN	"Picture1.CODE"



*******************************************************************************
**
**  Og den vildeste copperliste...
**
*******************************************************************************

	SECTION	MyCopper,data_c

FaderCopper:	dc.w	Bplcon0,$0200
	dc.w	$106,$c40
	dc.w	Color00,$0043
	dc.w	$1801,$fffe
.pos1	dc.w	$0811,$fffe
	dc.w	Color00,$0000
.pal	dc.w	$ffe1,$fffe
.pos2	dc.w	$f011,$fffe
	dc.w	Color00,$0034
	dc.l	-2
	dc.l	-2


Copper:	dc.w	$1001,$fffe
	dc.w	Bplcon0,$0201
	dc.w	Bplcon1,$0000
	dc.w	Bplcon2,$0024

	dc.w	Spr0pth,0,Spr0ptl,0
	dc.w	Spr1pth,0,Spr1ptl,0
	dc.w	Spr2pth,0,Spr2ptl,0
	dc.w	Spr3pth,0,Spr3ptl,0
	dc.w	Spr4pth,0,Spr4ptl,0
	dc.w	Spr5pth,0,Spr5ptl,0
	dc.w	Spr6pth,0,Spr6ptl,0
	dc.w	Spr7pth,0,Spr7ptl,0

	dc.w	Bplcon3,$0c40

Colors:	dc.w	$0180,$0043
	dc.w	$0182,$0043
	dc.w	$0184,$0043
	dc.w	$0186,$0043

	dc.w	$1001,$fffe
Copper_PlanePtr:	dc.w	Bpl1pth,0,Bpl1ptl,0
	dc.w	Bpl2pth,0,Bpl2ptl,0

	dc.w	Bplcon2,$0224
	dc.w	Ddfstrt,$0030
	dc.w	Ddfstop,$00d8
	dc.w	Diwstrt,$3071
	dc.w	Diwstop,$30d1
	dc.w	Bplcon1,$0000

	dc.w	Bpl1mod,44
	dc.w	Bpl2mod,44

	dc.w	Bplcon0,$2200

	dc.l	$01fe0000
	dc.l	$00017FFE
	dc.l	$00017FFE
	dc.l	$01fe0000
	dc.l	$01fe0000
Copper_FillPtr:	dc.w	Bltdpth,0,Bltdptl,0
	dc.w	Bltcpth,0,Bltcptl,0
	dc.w	Bltapth,0,Bltaptl,0
	dc.w	Bltcon0,(%1011<<8)!((A&~C)!(~A&C))
	dc.w	Bltcon1,0
	dc.w	Bltamod,44-32
	dc.w	Bltcmod,44-32
	dc.w	Bltdmod,44-32
	dc.w	Bltafwm,-1
	dc.w	Bltalwm,-1
	dc.w	Bltsize,(256*2)<<6!16

	dc.l	$01fe0000
	dc.l	$00017FFE
	dc.l	$00017FFE
	dc.l	$01fe0000
	dc.l	$01fe0000
Copper_ClrPtr:	dc.w	Bltdpth,0,Bltdptl,0
	dc.w	Bltcon0,$0100
	dc.w	Bltcon1,$0000
	dc.w	Bltdmod,44-32
	dc.w	Bltsize,(256*2)<<6!16

	dc.w	$d811,$fffe
	dc.w	$0180,$0034

	dc.l	-2
	dc.l	-2




*******************************************************************************
**
**  Screens+Gfx
**
*******************************************************************************
	SECTION	Screens,bss_c

	CNOP	0,8
_Bss1Start:
Screen1:	ds.b	256*44*2
Screen2:	ds.b	256*44*2
Screen3:	ds.b	256*44*2
Screen4:	ds.b	256*44*2

	CNOP	0,4
_Bss1End:


	SECTION	Buffers,bss
	CNOP	0,4
_Bss2Start:
StretchBuffer:	ds.w	256*128
PrecalcBuffer:	ds.w	256*256
Lsl9Tab:	ds.l	256
	CNOP	0,4
_Bss2End:


*******************************************************************************
**
**  Hardware registers
**
*******************************************************************************
Bltddat:	EQU	$000
Dmaconr:	EQU	$002
Vposr:	EQU	$004
Vhposr:	EQU	$006
Dskdatr:	EQU	$008
Joy0dat:	EQU	$00a
Joy1dat:	EQU	$00c
Clxdat:	EQU	$00e
Adkconr:	EQU	$010
Pot0dat:	EQU	$012
Pot1dat:	EQU	$014
Potgor:	EQU	$016
Serdatr:	EQU	$018
Dskbytr:	EQU	$01a
Intenar:	EQU	$01c
Intreqr:	EQU	$01e
Dskpth:	EQU	$020
Dskptl:	EQU	$022
Dsklen:	EQU	$024
Dskdat:	EQU	$026
Refptr:	EQU	$028
Vposw:	EQU	$02a
Vhposw:	EQU	$02c
Copcon:	EQU	$02e
Serdat:	EQU	$030
Serper:	EQU	$032
Potgo:	EQU	$034
Joytest:	EQU	$036
Strequ:	EQU	$038
Strvbl:	EQU	$03a
Strhor:	EQU	$03c
Strlong:	EQU	$03e
Bltcon0:	EQU	$040
Bltcon1:	EQU	$042
Bltafwm:	EQU	$044
Bltalwm:	EQU	$046
Bltcpth:	EQU	$048
Bltcptl:	EQU	$04a
Bltbpth:	EQU	$04c
Bltbptl:	EQU	$04e
Bltapth:	EQU	$050
Bltaptl:	EQU	$052
Bltdpth:	EQU	$054
Bltdptl:	EQU	$056
Bltsize:	EQU	$058
Bltcmod:	EQU	$060
Bltbmod:	EQU	$062
Bltamod:	EQU	$064
Bltdmod:	EQU	$066
Bltcdat:	EQU	$070
Bltbdat:	EQU	$072
Bltadat:	EQU	$074
Dsksync:	EQU	$07e
Cop1lch:	EQU	$080
Cop1lcl:	EQU	$082
Cop2lch:	EQU	$084
Cop2lcl:	EQU	$086
Copjmp1:	EQU	$088
Copjmp2:	EQU	$08a
Copins:	EQU	$08c
Diwstrt:	EQU	$08e
Diwstop:	EQU	$090
Ddfstrt:	EQU	$092
Ddfstop:	EQU	$094
Dmacon:	EQU	$096
Clxcon:	EQU	$98
Intena:	EQU	$09a
Intreq:	EQU	$09c
Adkcon:	EQU	$09e
Aud0dat:	EQU	$0aa
Aud1dat:	EQU	$0ba
Aud2dat:	EQU	$0ca
Aud3dat:	EQU	$0da
Aud0lch:	EQU	$0a0
Aud1lch:	EQU	$0b0
Aud2lch:	EQU	$0c0
Aud3lch:	EQU	$0d0
Aud0len:	EQU	$0a4
Aud1len:	EQU	$0b4
Aud2len:	EQU	$0c4
Aud3len:	EQU	$0d4
Aud0per:	EQU	$0a6
Aud1per:	EQU	$0b6
Aud2per:	EQU	$0c6
Aud3per:	EQU	$0d6
Aud0vol:	EQU	$0a8
Aud1vol:	EQU	$0b8
Aud2vol:	EQU	$0c8
Aud3vol:	EQU	$0d8
Aud0lcl:	EQU	$0a2
Aud1lcl:	EQU	$0b2
Aud2lcl:	EQU	$0c2
Aud3lcl:	EQU	$0d2
Bpl1pth:	EQU	$0e0
Bpl1ptl:	EQU	$0e2
Bpl2pth:	EQU	$0e4
Bpl2ptl:	EQU	$0e6
Bpl3pth:	EQU	$0e8
Bpl3ptl:	EQU	$0ea
Bpl4pth:	EQU	$0ec
Bpl4ptl:	EQU	$0ee
Bpl5pth:	EQU	$0f0
Bpl5ptl:	EQU	$0f2
Bpl6pth:	EQU	$0f4
Bpl6ptl:	EQU	$0f6
Bpl7pth:	EQU	$0f8
Bpl7ptl:	EQU	$0fa
Bpl8pth:	EQU	$0fc
Bpl8ptl:	EQU	$0fe
Bplcon0:	EQU	$100
Bplcon1:	EQU	$102
Bplcon2:	EQU	$104
Bplcon3:	EQU	$106
Bpl1mod:	EQU	$108
Bpl2mod:	EQU	$10a
Bpl1dat:	EQU	$110
Bpl2dat:	EQU	$112
Bpl3dat:	EQU	$114
Bpl4dat:	EQU	$116
Bpl5dat:	EQU	$118
Bpl6dat:	EQU	$11a
Spr0pth:	EQU	$120
Spr0ptl:	EQU	$122
Spr1pth:	EQU	$124
Spr1ptl:	EQU	$126
Spr2pth:	EQU	$128
Spr2ptl:	EQU	$12a
Spr3pth:	EQU	$12c
Spr3ptl:	EQU	$12e
Spr4pth:	EQU	$130
Spr4ptl:	EQU	$132
Spr5pth:	EQU	$134
Spr5ptl:	EQU	$136
Spr6pth:	EQU	$138
Spr6ptl:	EQU	$13a
Spr7pth:	EQU	$13c
Spr7ptl:	EQU	$13e
Spr0pos:	EQU	$140
Spr0ctl:	EQU	$142
Spr0data:	EQU	$144
Spr0datb:	EQU	$146
Spr1pos:	EQU	$148
Spr1ctl:	EQU	$14a
Spr1data:	EQU	$14c
Spr1datb:	EQU	$14e
Spr2pos:	EQU	$150
Spr2ctl:	EQU	$152
Spr2data:	EQU	$154
Spr2datb:	EQU	$156
Spr3pos:	EQU	$158
Spr3ctl:	EQU	$15a
Spr3data:	EQU	$15c
Spr3datb:	EQU	$15e
Spr4pos:	EQU	$160
Spr4ctl:	EQU	$162
Spr4data:	EQU	$164
Spr4datb:	EQU	$166
Spr5pos:	EQU	$168
Spr5ctl:	EQU	$16a
Spr5data:	EQU	$16c
Spr5datb:	EQU	$16e
Spr6pos:	EQU	$170
Spr6ctl:	EQU	$172
Spr6data:	EQU	$174
Spr6datb:	EQU	$176
Spr7pos:	EQU	$178
Spr7ctl:	EQU	$17a
Spr7data:	EQU	$17c
Spr7datb:	EQU	$17e
Color00:	EQU	$180
Color01:	EQU	$182
Color02:	EQU	$184
Color03:	EQU	$186
Color04:	EQU	$188
Color05:	EQU	$18a
Color06:	EQU	$18c
Color07:	EQU	$18e
Color08:	EQU	$190
Color09:	EQU	$192
Color10:	EQU	$194
Color11:	EQU	$196
Color12:	EQU	$198
Color13:	EQU	$19a
Color14:	EQU	$19c
Color15:	EQU	$19e
Color16:	EQU	$1a0
Color17:	EQU	$1a2
Color18:	EQU	$1a4
Color19:	EQU	$1a6
Color20:	EQU	$1a8
Color21:	EQU	$1aa
Color22:	EQU	$1ac
Color23:	EQU	$1ae
Color24:	EQU	$1b0
Color25:	EQU	$1b2
Color26:	EQU	$1b4
Color27:	EQU	$1b6
Color28:	EQU	$1b8
Color29:	EQU	$1ba
Color30:	EQU	$1bc
Color31:	EQU	$1be
_Custom:	EQU	$dff000




*******************************************************************************
**
**  Interrupt addresses
**
*******************************************************************************
Lev1Base:	EQU	$64
Lev2Base:	EQU	$68
Lev3Base:	EQU	$6c
Lev4Base:	EQU	$70
Lev5Base:	EQU	$74
Lev6Base:	EQU	$78
Lev7Base:	EQU	$7c
Trap0:	EQU	$80






