  hhhhhhhh;---------------T--------T
Raster=0
Track=0	;0=ASM-One version
	;1=Track version

MyDmaco2=%01001000000
MyDmacon=%11111100000
;         abcdefghhhh
; a = Blitter nasty
; b = Enable DMA activity (always set this!)
; c = Bitplane enable
; d = Copper enable
; e = Blitter enable
; f = Sprite enable
; g = Disk enable
; h = Audio channels enable

MyIntena=%110000000100000
;         abcdeeeefghijkl
; a = Enable interrupts
; b = Lev. 6 External interrupt
; c = Lev. 5 Disk sync found
; d = Lev. 5 Serial port receive buffer full
; e = Lev. 4 Audio ch. 3-0 block finished
; f = Lev. 3 Blitter finished
; g = Lev. 3 Vertical blank
; h = Lev. 3 Copper
; i = Lev. 2 I/O Ports and timers
; j = Lev. 1 Software
; k = Lev. 1 Disk block finished
; l = Lev. 1 Serial port transmit buffer empty

	ORG	$40000
	LOAD	$40000
	JUMPPTR	Begin

*******************************************************************************
**Macros
*******************************************************************************
CopBltWait:	EQU	$00017ffe

WaitBlt:	macro
.vent\@:	if	Raster=1
	move.w	#$fff,Color00+Base
	endif
	btst	#14,Dmaconr+Base
	bne.b	.vent\@
	if	Raster=1
	move.w	#0,Color00+Base
	endif
	endm

SetInt:	macro
	move.l	(Lev\1Base).w,OldIrq\1
	move.l	#Lev\1Irq,(Lev\1Base).w
	bra.b	jumpo\@
OldIrq\1:	dc.l	0
jumpo\@:
	endm

ClrInt:	macro
	move.l	OldIrq\1(pc),(Lev\1Base).w
	endm

Push.l:	macro
	movem.l	\1,-(sp)
	endm

Push.w:	macro
	movem.w	\1,-(sp)
	endm

Pull.l:	macro
	movem.l	(sp)+,\1
	endm

Pull.w:	macro
	movem.w	(sp)+,\1
	endm

StartPrg:	macro
	move.w	#$7fff,Intreq+Base
	move.w	#MyDmacon+$8000,Dmacon+Base
	move.w	#MyIntena+$8000,Intena+Base
	endm

StopPrg:	macro
	move.w	#$7fff,Intena+Base
	move.w	#$7fff,Dmacon+Base
	endm

StopSystem:	macro
	move.w	Intenar+Base,OldIntena
	move.w	Dmaconr+Base,OldDmacon
	StopPrg
	bra.b	jumpo\@
OldIntena:	dc.w	0
OldDmacon:	dc.w	0
jumpo\@:
	endm

StartSystem:	macro
	move.w	OldDmacon(pc),d0
	or.w	#$8000,d0
	move.w	d0,Dmacon+Base
	move.w	OldIntena(pc),d0
	or.w	#$8000,d0
	move.w	d0,Intena+Base
	endm


*******************************************************************************
**Initialisering
*******************************************************************************
Begin:
	Push.l	d0-a6
	StopSystem

**Init starter -----------------------------------
	bsr	RndInit

	lea	Clear,a0
	move.l	#(TheEnd-Clear)/4,d0
.clrloop	clr.l	(a0)+
	subq.l	#1,d0
	bne.b	.clrloop

	bsr	InitExplo

	move.w	#MyDmaco2+$8000,Dmacon+Base

	lea	MyCat+16*2,a0
	lea	CatScreen+127*44+20,a1
	moveq	#4-1,d7
	lea	Base,a6
.catloop	WaitBlt
	move.l	a0,Bltapth(a6)
	move.l	a1,Bltdpth(a6)
	move.l	#$19f00000,Bltcon0(a6)
	move.l	#$7fff0000,Bltafwm(a6)
	move.l	#((4*4-6)&$ffff)<<16!((44-6)&$ffff),Bltamod(a6)
	move.w	#28<<6+3,Bltsize(a6)
	addq.w	#4,a0
	add.w	#283*44,a1
	dbra	d7,.catloop

	SetInt	3

	clr.l	0.w

**Init slutter -----------------------------------

	WaitBlt
	StartPrg

*******************************************************************************
**Vent p exitsignal
*******************************************************************************
WaitForExit:	move.w	VBlank(pc),d0
	beq.b	WaitForExit
	clr.w	VBlank
	tst.w	IWantOut
	bne.b	ExitToDos
	bra.b	WaitForExit

*******************************************************************************
**Exit to AmigaDOS
*******************************************************************************
ExitToDos:
	StopPrg

**Exit starter -----------------------------------
	ClrInt	3
**Exit slutter -----------------------------------

	StartSystem

	Pull.l	d0-a6
	moveq	#0,d0
	rts

*******************************************************************************
**Level 3 interrupt
*******************************************************************************
Status:	dc.w	0
MaxRast:	dc.w	0
VBlank:	dc.w	0
IWantOut:	dc.w	0
Lev3Irq:	move.w	#1,VBlank

**Lev3irq starter --------------------------------
	move.w	#%10,CopCon+Base

	move.w	Status(pc),d0
	add.w	d0,d0
	add.w	d0,d0
	lea	Routines(pc),a0
	move.l	(a0,d0.w),a0
	jsr	(a0)

**Lev3irq slutter --------------------------------
	move.b	$dff005,d0
	lsl.w	#8,d0
	move.b	$dff006,d0
	cmp.w	MaxRast(pc),d0
	blt.b	.ud
	move.w	d0,MaxRast
.ud:	IF	Raster=1
	move.w	#$ccc,Color00+Base
	ENDIF
	btst	#6,$bfe001
	bne.b	.noleft
	move.w	#-1,IWantOut
.noleft:
	move.w	#$0020,Intreq+Base
	rte

Routines:	dc.l	DrawAnim,FadeUp,MoveCat,Explo,EOR

EOR:	move.w	#1,IWantOut
	rts

*******************************************************************************
**Randomnumberroutine
*******************************************************************************
RndInit:	move.b	$bfe801,RndSeed
	move.b	$bfd800,RndSeed+1
	move.w	VHPosr+Base,d0
	eor.w	d0,RndSeed
	rts


**input:
**d1: max. number +1
**output:
**d0: rnd number
Rnd:	moveq	#0,d0
	move.b	$bfe801,d0
	lsl.w	#8,d0
	move.b	$bfd800,d0
	move.w	VHPosr+Base,d2
	eor.w	d2,d0
	move.w	RndSeed(pc),d2
	eor.w	d2,d0
	divu	d1,d0
	swap	d0
	rts

RndSeed:	dc.w	0


*******************************************************************************
**Explosion
*******************************************************************************
ExploDims:	dc.w	0
ExploPause:	dc.w	0

InitExplo:	lea	ExploArray(pc),a0
	moveq	#0,d4
	moveq	#20-1,d1
.loopy	moveq	#20-1,d0
.loopx
	push.w	d0-d2

	move.w	#30,d1
	bsr	Rnd
	sub.w	#15,d0
	move.w	d0,(a0)+

	move.w	#30+1,d1
	bsr	Rnd
	subq.w	#5,d0
	neg.w	d0
	move.w	d0,(a0)+

	pull.w	d0-d2

	move.w	d0,d2
	add.w	#130-10,d2
	move.w	d2,(a0)+
	move.w	d1,d2
	add.w	#155-10,d2
	move.w	d2,(a0)+


	dbra	d0,.loopx
	dbra	d1,.loopy
	rts

StarColPtr:	dc.w	0

ExploScreen:	dc.l	Screen
Explo:	move.l	#StarCopper,Cop2lch+Base
	move.w	d0,Copjmp2+Base
	lea	ExploScreen(pc),a0
	lea	StarPlaner(pc),a1
	lea	Screen,a2
	lea	288*44(a2),a3
	move.l	(a0),d0
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	cmp.l	(a0),a2
	beq.b	.set3
	move.l	a2,(a0)
	bra.b	.moveon
.set3	move.l	a3,(a0)
	lea	MyCat,a3
	add.w	StarColPtr,a3
	move.w	(a3),StarColor+2
	addq.w	#2,StarColPtr
	and.w	#32-1,StarColPtr

.moveon	lea	Base,a6
	WaitBlt
	move.l	(a0),Bltdpth(a6)
	move.l	#$01000000,Bltcon0(a6)
	move.w	#0,Bltdmod(a6)
	move.w	#288<<6+22,Bltsize(a6)

	move.w	#$5258,.svend	;addq.w	#1,(a0)+
	not.w	ExploDims
	beq.b	.NOOOOT
	move.w	#$5448,.svend	;addq.w	#2,a0
.NOOOOT
	move.l	(a0),a6
	lea	ExploArray(pc),a0
	moveq	#-10,d1
.loopy	moveq	#-10,d0
.loopx	move.w	(a0)+,d4
	move.w	(a0),d5
.svend	nop
	move.w	(a0),d2
	add.w	d4,(a0)+
	move.w	(a0),d3
	add.w	d5,(a0)+
	tst.w	d2
	blt.b	.next
	tst.w	d3
	blt.b	.next
	cmp.w	#320+32,d2
	bge.b	.next
	cmp.w	#256+32,d3
	bge.b	.next
	mulu	#44,d3
	move.w	d2,d6
	lsr.w	#3,d6
	add.w	d6,d3
	not.b	d2
	bset	d2,(a6,d3.w)
.next	addq.w	#1,d0
	cmp.w	#9,d0
	ble.b	.loopx
	addq.w	#1,d1
	cmp.w	#9,d1
	ble.b	.loopy

	addq.w	#1,ExploPause
	cmp.w	#125,ExploPause
	bne.b	.herut
	addq.w	#1,Status
.herut	rts



ExploArray:	blk.w	20*20*4,0

*******************************************************************************
**Fade Up
*******************************************************************************
FadePause:	dc.w	0
FadeUp:	move.l	#Copper,Cop2lch+Base
	move.w	d0,Copjmp2+Base

	lea	CopColors+2(pc),a0

	lea	MyCat,a1
	moveq	#16-1,d7
.loop	move.w	(a0),d0
	move.w	(a1)+,d1
	bsr.b	fader
	move.w	d0,(a0)
	addq.w	#4,a0
	dbra	d7,.loop

	lea	MyCat,a1
	moveq	#16-1,d7
.loop2	move.w	(a0),d0
	move.w	(a1)+,d1
	bsr.b	fader
	move.w	d0,(a0)
	addq.w	#4,a0
	dbra	d7,.loop2

	addq.w	#1,FadePause
	cmp.w	#16,FadePause
	bne.b	.ud
	addq.w	#1,Status
.ud	rts

**d0=fade from
**d1=fade to
**out: d0=newcol
fader:	move.w	d0,d2
	move.w	d1,d3
	lsr.w	#8,d2
	lsr.w	#8,d3
	cmp.w	d2,d3
	beq	.nored
	blt	.redsub
	add.w	#$100,d0
	bra	.nored
.redsub:	sub.w	#$100,d0
.nored:	move.w	d0,d2
	move.w	d1,d3
	lsr.w	#4,d2
	lsr.w	#4,d3
	and.w	#$f,d2
	and.w	#$f,d3
	cmp.w	d2,d3
	beq	.nogreen
	blt	.greensub
	add.w	#$10,d0
	bra	.nogreen
.greensub:	sub.w	#$10,d0
.nogreen:	move.w	d0,d2
	move.w	d1,d3
	and.w	#$f,d2
	and.w	#$f,d3
	cmp.w	d2,d3
	beq	.noblue
	blt	.bluesub
	addq.w	#$1,d0
	bra	.noblue
.bluesub:	subq.w	#$1,d0
.noblue:	rts






*******************************************************************************
**Draw skak-anim
*******************************************************************************
MorphPause:	dc.w	0

DrawAnim:	move.l	#Copper,Cop2lch+Base
	move.w	d0,Copjmp2+Base

	lea	CopColors+16*4+2(pc),a0
	move.w	(a0),d0
	move.w	#$fff,d1
	bsr	fader
	moveq	#16-1,d7
.colloop	move.w	d0,(a0)
	addq.w	#4,a0
	dbra	d7,.colloop

	addq.w	#1,MorphPause
	cmp.w	#128,MorphPause
	beq.b	.out
	move.l	#MyAnim,AnimData
	move.l	#Screen,DestGfx1
	move.l	#Screen+283*44,DestGfx2
	move.w	#128,NoFrames
	bsr	ShowAnim
	rts
.out	addq.w	#1,Status
	rts

AnimRegs:	blk.l	15,0
AnimMode:	dc.w	0
ShowAnim:	move.w	AnimMode(pc),d0
	beq.b	.anim0
	subq.w	#1,d0
	beq.b	.anim1
	subq.w	#1,d0
	beq.w	.anim2
	rts

.anim0	move.l	AnimData(pc),a0		; IFF file
	move.l	DestGfx1(pc),a1		; Pointer to Screen1
	move.l	DestGfx2(pc),a4		; Pointer to screen2
	move.w	NoFrames(pc),d7		; No. of frames to show

	move.l	#`BODY`,d0
	bsr	FindChung
	move.l	a4,a2
	bsr	DecrunchBODY

	move.l	AnimData(pc),a0		; IFF file
	move.l	#`BODY`,d0
	bsr	FindChung
	move.l	a1,a2
	bsr	DecrunchBODY

	push.l	d0/a0			; Show scr2
	move.l	DestGfx2,d0		; 
	lea	Matildeplaner,a0		; 
	move.w	d0,6(a0)		; 
	swap	d0			; 
	move.w	d0,2(a0)		; 
	pull.l	d0/a0			; 

	addq.w	#1,AnimMode
	movem.l	d0-a6,AnimRegs
	rts

.anim1	movem.l	AnimRegs,d0-a6
	subq.w	#1,d7
	beq	.End

.Loop	move.l	#`DLTA`,d0
	bsr	FindChung
	cmp.l	#$40,d0
	beq.s	.NoNew1
	move.l	a4,a2
	bsr	DecrunchDLTA
.NoNew1
	push.l	d0/a0			; Show scr2
	move.l	DestGfx2,d0		; 
	lea	MatildePlaner,a0		; 
	move.w	d0,6(a0)		; 
	swap	d0			; 
	move.w	d0,2(a0)		; 
	pull.l	d0/a0			; 

	move.w	#2,AnimMode
	movem.l	d0-a6,AnimRegs
	rts

.anim2	movem.l	AnimRegs,d0-a6
	subq.w	#1,d7
	beq	.End

	move.l	#`DLTA`,d0
	bsr	FindChung
	cmp.l	#$40,d0
	beq.s	.NoNew2
	move.l	a1,a2
	bsr	DecrunchDLTA
.NoNew2
	push.l	d0/a0			; Show scr2
	move.l	DestGfx1,d0		; 
	lea	MatildePlaner,a0		; 
	move.w	d0,6(a0)		; 
	swap	d0			; 
	move.w	d0,2(a0)		; 
	pull.l	d0/a0			; 

	move.w	#1,AnimMode
	movem.l	d0-a6,AnimRegs
	rts

.End:	addq.w	#1,MorphPause
	rts

DecrunchDLTA:	add.l	#64,a0
	moveq	#44-1,d0
.TheLoop2	move.l	a2,a3
	moveq	#0,d3
	move.b	(a0)+,d3	; Antal commands in this ROW!
	beq.s	.NoCommands
	subq	#1,d3

.TheLoop	moveq	#0,d1
	move.b	(a0)+,d1	; Command!
	beq.s	.DoFill
	btst	#7,d1
	beq.s	.DoMove

	sub.w	#$81,d1
.Loop1	move.b	(a0)+,(a3)
	lea	44(a3),a3
	dbf	d1,.Loop1
	bra.s	.JmpNextLine
	
.DoMove	mulu	#44,d1
	add.l	d1,a3
	bra.s	.JmpNextLine

.DoFill	move.b	(a0)+,d1	; Antal
	move.b	(a0)+,d2	; With
	subq.w	#1,d1
.Loop2	move.b	d2,(a3)
	lea	44(a3),a3
	dbf	d1,.Loop2
		
.JmpNextLine	dbf	d3,.TheLoop
.NoCommands	addq.l	#1,a2
	dbf	d0,.TheLoop2
	rts

DecrunchBODY:	moveq	#0,d1
	move.b	(a0)+,d1
	subq.l	#1,d0

	btst	#7,d1
	bne.s	.DeCrunch1
.Loop1	move.b	(a0)+,(a2)+
	subq.l	#1,d0
	dbf	d1,.Loop1
	bra.s	.DeCrunch2

.DeCrunch1	move.w	#$100,d2
	sub.w	d1,d2
	move.b	(a0)+,d1
	subq.l	#1,d0
.Loop2	move.b	d1,(a2)+
	dbf	d2,.Loop2

.DeCrunch2	tst.l	d0
	beq.s	.OUT
	bpl.s	DecrunchBODY
.OUT	rts



FindChung:	move.l	a0,d1
	bclr.l	#0,d1
	move.l	d1,a0

	move.l	d0,d1
	swap	d1

.Loop	cmp.w	(a0)+,d1
	bne.s	.Loop
	cmp.w	(a0),d0
	bne.s	.Loop
	tst.w	(a0)+
	move.l	(a0)+,d0
	rts

AnimData:	dc.l	0	; IFF file
DestGfx1:	dc.l	0	; Pointer to Screen1
DestGfx2:	dc.l	0	; Pointer to screen2
DecrunchPauser:	dc.l	0	; Pauser in anim!
NoFrames:	dc.w	0	; No. of frames to show







*******************************************************************************
**Flyt satan
*******************************************************************************
MovePause:	dc.w	0
MoveCat:	move.l	#Copper,Cop2lch+Base
	move.w	d0,Copjmp2+Base

	lea	CatScreen+127*44+20,a1
	moveq	#4-1,d7
	lea	Base,a6
.catloop	WaitBlt
	move.l	a1,Bltdpth(a6)
	move.l	#$01000000,Bltcon0(a6)
	move.w	#44-6,Bltamod(a6)
	move.w	#28<<6+3,Bltsize(a6)
	add.w	#283*44,a1
	dbra	d7,.catloop

	move.w	CatX(pc),d0
	move.w	CatY(pc),d1
	move.w	#28,d5
	lea	spr1(pc),a0
	add.w	AnimFrame(pc),a0
	bsr	makesprite
	lea	spr2(pc),a1
	add.w	AnimFrame(pc),a1
	lea	spr3(pc),a2
	add.w	AnimFrame(pc),a2
	lea	spr4(pc),a3
	add.w	AnimFrame(pc),a3
	move.l	-4(a0),(a1)
	or.b	#$80,3(a1)
	move.l	-4(a0),(a2)
	move.l	-4(a0),(a3)
	or.b	#$80,3(a3)
	addq.w	#8,(a2)
	addq.w	#8,(a3)

	moveq	#0,d1
	move.w	AnimFrame(pc),d1
	lea	SprCopper(pc),a0
	move.l	#Spr1,d0
	add.l	d1,d0
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	addq.w	#8,a0
	move.l	#Spr2,d0
	add.l	d1,d0
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	addq.w	#8,a0
	move.l	#Spr3,d0
	add.l	d1,d0
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	addq.w	#8,a0
	move.l	#Spr4,d0
	add.l	d1,d0
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)

	subq.w	#1,CatX
	add.w	#120,AnimFrame
	cmp.w	#5*120,AnimFrame
	bne.b	.ud
	clr.w	AnimFrame
.ud	addq.w	#1,MovePause
	cmp.w	#50,MovePause
	bne.b	.herut
	addq.w	#1,Status

	lea	Base,a6
	WaitBlt
	move.l	#Screen,Bltdpth(a6)
	move.l	#$01000000,Bltcon0(a6)
	move.w	#0,Bltdmod(a6)
	move.w	#288<<6+44,Bltsize(a6)

.herut	rts


CatX:	dc.w	18*8+1
CatY:	dc.w	(256-28)/2
AnimFrame:	dc.w	0


*******************************************************************************
**Make Sprite CTL-words
*******************************************************************************
**d0=x
**d1=y
**d5=height
**a0=spritestruct
*******************************************************************************
makesprite:	add.w	#$80,d0
	add.w	#$2c,d1
	moveq	#0,d3
	moveq	#0,d4
	move.w	d0,d2
	roxr.w	#1,d4
	roxr.w	#1,d2
	bcc.b	.nohihsat
	roxr.w	#1,d4
	bset	#0,d3
.nohihsat:	move.w	d1,-(sp)
	ror.w	#8,d1
	roxr.b	#1,d1
	bcc.b	.nohivstart
	bset	#2,d3
	roxr.w	#1,d4
.nohivstart:	or.w	d1,d2
	move.w	(sp)+,d1
	add.w	d5,d1	;height
	ror.w	#8,d1
	roxr.b	#1,d1
	bcc.b	.nohivstop
	roxr.w	#1,d4
	bset	#1,d3
.nohivstop:	or.w	d1,d3
	move.w	d2,(a0)+
	move.w	d3,(a0)+
	rts


*******************************************************************************
**Copper
*******************************************************************************
Copper:
	dc.w	Diwstrt,$1f71
	dc.w	Diwstop,$3ad1
	dc.w	Ddfstrt,$0030
	dc.w	Ddfstop,$00d8

CopColors:	dc.w	Color00,$000,Color01,$000,Color02,$000,Color03,$000
	dc.w	Color04,$000,Color05,$000,Color06,$000,Color07,$000
	dc.w	Color08,$000,Color09,$000,Color10,$000,Color11,$000
	dc.w	Color12,$000,Color13,$000,Color14,$000,Color15,$000

	dc.w	Color16,$000,Color17,$000,Color18,$000,Color19,$000
	dc.w	Color20,$000,Color21,$000,Color22,$000,Color23,$000
	dc.w	Color24,$000,Color25,$000,Color26,$000,Color27,$000
	dc.w	Color28,$000,Color29,$000,Color30,$000,Color31,$000

	dc.w	$0801,$fffe
Matildeplaner:	dc.w	Bpl5pth,Screen>>16,Bpl5ptl,Screen&$ffff

CatPlaner:	dc.w	Bpl1pth,(CatScreen)>>16
	dc.w	Bpl1ptl,(CatScreen)&$ffff
	dc.w	Bpl2pth,(CatScreen+44*283)>>16
	dc.w	Bpl2ptl,(CatScreen+44*283)&$ffff
	dc.w	Bpl3pth,(CatScreen+44*283*2)>>16
	dc.w	Bpl3ptl,(CatScreen+44*283*2)&$ffff
	dc.w	Bpl4pth,(CatScreen+44*283*3)>>16
	dc.w	Bpl4ptl,(CatScreen+44*283*3)&$ffff

	dc.w	Bpl1mod,0
	dc.w	Bpl2mod,0

SprCopper:	dc.w	Spr0pth,$0000
	dc.w	Spr0ptl,$0000
	dc.w	Spr1pth,$0000
	dc.w	Spr1ptl,$0000
	dc.w	Spr2pth,$0000
	dc.w	Spr2ptl,$0000
	dc.w	Spr3pth,$0000
	dc.w	Spr3ptl,$0000

	dc.w	Spr4pth,$0000
	dc.w	Spr4ptl,$0000
	dc.w	Spr5pth,$0000
	dc.w	Spr5ptl,$0000
	dc.w	Spr6pth,$0000
	dc.w	Spr6ptl,$0000
	dc.w	Spr7pth,$0000
	dc.w	Spr7ptl,$0000

	dc.w	Bplcon0,$5200
	dc.w	Bplcon1,$0000
	dc.w	Bplcon2,$0024

	dc.l	-2




StarCopper:
	dc.w	Diwstrt,$1c71
	dc.w	Diwstop,$3cd1
	dc.w	Ddfstrt,$0030
	dc.w	Ddfstop,$00d8

	dc.w	Color00,$000
StarColor:	dc.w	Color01,$fff

	dc.w	Spr0pth,$0000
	dc.w	Spr0ptl,$0000
	dc.w	Spr1pth,$0000
	dc.w	Spr1ptl,$0000
	dc.w	Spr2pth,$0000
	dc.w	Spr2ptl,$0000
	dc.w	Spr3pth,$0000
	dc.w	Spr3ptl,$0000

	dc.w	Spr4pth,$0000
	dc.w	Spr4ptl,$0000
	dc.w	Spr5pth,$0000
	dc.w	Spr5ptl,$0000
	dc.w	Spr6pth,$0000
	dc.w	Spr6ptl,$0000
	dc.w	Spr7pth,$0000
	dc.w	Spr7ptl,$0000

	dc.w	$1001,$fffe
StarPlaner:	dc.w	Bpl1pth,Screen>>16,Bpl1ptl,Screen&$ffff

	dc.w	Bpl1mod,0
	dc.w	Bpl2mod,0


	dc.w	Bplcon0,$1200
	dc.w	Bplcon1,$0000
	dc.w	Bplcon2,$0024

	dc.l	-2




*******************************************************************************
**Screens+Gfx
*******************************************************************************
	;LEFT SIDE
	;Even ATTACH pair follows:
spr1:	dc.l	0
	dc.w	$0020,$0000
	dc.w	$0040,$0000
	dc.w	$028A,$0020
	dc.w	$71E9,$B460
	dc.w	$2431,$1D67
	dc.w	$1A03,$0E6F
	dc.w	$0DC6,$0FFF
	dc.w	$05A9,$0FFF
	dc.w	$0BF2,$07FE
	dc.w	$0AF1,$0AFF
	dc.w	$00E3,$1FFF
	dc.w	$1283,$1FFF
	dc.w	$000B,$1AFF
	dc.w	$1006,$1FFE
	dc.w	$142F,$1FFF
	dc.w	$089D,$0FFD
	dc.w	$0FF6,$1FF6
	dc.w	$06D9,$06D8
	dc.w	$01E2,$01E0
	dc.w	$0206,$0000
	dc.w	$0092,$0108
	dc.w	$0001,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0001,$0003
	dc.w	$0003,$0003
	dc.w	$0003,$0003
	dc.w	$0001,$0003
	dc.l	0

	dc.l	0
	dc.w	$0020,$0000
	dc.w	$0040,$0000
	dc.w	$028A,$0020
	dc.w	$71E9,$B460
	dc.w	$2431,$1D67
	dc.w	$1A03,$0E6F
	dc.w	$0DC6,$0FFF
	dc.w	$05A9,$0FFF
	dc.w	$0BF2,$07FE
	dc.w	$0AF1,$0AFF
	dc.w	$00E3,$1FFF
	dc.w	$1283,$1FFF
	dc.w	$000B,$1AFF
	dc.w	$1006,$1FFE
	dc.w	$142F,$1FFF
	dc.w	$089D,$0FFD
	dc.w	$0FF6,$1FF6
	dc.w	$06D9,$06D8
	dc.w	$01E2,$01E0
	dc.w	$0206,$0000
	dc.w	$0092,$0108
	dc.w	$0001,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0001
	dc.w	$0001,$0001
	dc.w	$0001,$0001
	dc.w	$0000,$0001
	dc.l	0

	dc.l	0
	dc.w	$0020,$0000
	dc.w	$0040,$0000
	dc.w	$028A,$0020
	dc.w	$71E9,$B460
	dc.w	$2431,$1D67
	dc.w	$1A03,$0E6F
	dc.w	$0DC6,$0FFF
	dc.w	$05A9,$0FFF
	dc.w	$0BF2,$07FE
	dc.w	$0AF1,$0AFF
	dc.w	$00E3,$1FFF
	dc.w	$1283,$1FFF
	dc.w	$000B,$1AFF
	dc.w	$1006,$1FFE
	dc.w	$142F,$1FFF
	dc.w	$089D,$0FFD
	dc.w	$0FF6,$1FF6
	dc.w	$06D9,$06D8
	dc.w	$01E2,$01E0
	dc.w	$0206,$0000
	dc.w	$0092,$0108
	dc.w	$0001,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0003,$0000
	dc.w	$0007,$0000
	dc.w	$0007,$0000
	dc.w	$0003,$0000
	dc.l	0

	dc.l	0
	dc.w	$0020,$0000
	dc.w	$0040,$0000
	dc.w	$028A,$0020
	dc.w	$71E9,$B460
	dc.w	$2431,$1D67
	dc.w	$1A03,$0E6F
	dc.w	$0DC6,$0FFF
	dc.w	$05A9,$0FFF
	dc.w	$0BF2,$07FE
	dc.w	$0AF1,$0AFF
	dc.w	$00E3,$1FFF
	dc.w	$1283,$1FFF
	dc.w	$000B,$1AFF
	dc.w	$1006,$1FFE
	dc.w	$142F,$1FFF
	dc.w	$089D,$0FFD
	dc.w	$0FF6,$1FF6
	dc.w	$06D9,$06D8
	dc.w	$01E2,$01E0
	dc.w	$0206,$0000
	dc.w	$0092,$0108
	dc.w	$0001,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0001,$0000
	dc.w	$0001,$0000
	dc.w	$0000,$0000
	dc.l	0

	dc.l	0
	dc.w	$0020,$0000
	dc.w	$0040,$0000
	dc.w	$028A,$0020
	dc.w	$71E9,$B460
	dc.w	$2431,$1D67
	dc.w	$1A03,$0E6F
	dc.w	$0DC6,$0FFF
	dc.w	$05A9,$0FFF
	dc.w	$0BF2,$07FE
	dc.w	$0AF1,$0AFF
	dc.w	$00E3,$1FFF
	dc.w	$1283,$1FFF
	dc.w	$000B,$1AFF
	dc.w	$1006,$1FFE
	dc.w	$142F,$1FFF
	dc.w	$089D,$0FFD
	dc.w	$0FF6,$1FF6
	dc.w	$06D9,$06D8
	dc.w	$01E2,$01E0
	dc.w	$0206,$0000
	dc.w	$0092,$0108
	dc.w	$0001,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0002,$0007
	dc.w	$0007,$0007
	dc.w	$0006,$0007
	dc.w	$0002,$0007
	dc.l	0

	;Odd ATTACH pair follows:
spr2:	dc.l	0
	dc.w	$0000,$0020
	dc.w	$0020,$0240
	dc.w	$0140,$028E
	dc.w	$CC65,$0110
	dc.w	$23AD,$0000
	dc.w	$199B,$0000
	dc.w	$0CC6,$0000
	dc.w	$05A8,$0000
	dc.w	$0BF1,$0000
	dc.w	$07F0,$0000
	dc.w	$15E0,$0000
	dc.w	$0780,$0000
	dc.w	$0500,$0000
	dc.w	$0001,$0000
	dc.w	$0000,$0000
	dc.w	$1002,$0000
	dc.w	$1009,$0000
	dc.w	$0927,$0000
	dc.w	$061F,$0000
	dc.w	$03FF,$0000
	dc.w	$01FB,$0000
	dc.w	$0001,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0002,$0000
	dc.w	$0001,$0000
	dc.w	$0001,$0000
	dc.w	$0002,$0000
	dc.l	0

	dc.l	0
	dc.w	$0000,$0020
	dc.w	$0020,$0240
	dc.w	$0140,$028E
	dc.w	$CC65,$0110
	dc.w	$23AD,$0000
	dc.w	$199B,$0000
	dc.w	$0CC6,$0000
	dc.w	$05A8,$0000
	dc.w	$0BF1,$0000
	dc.w	$07F0,$0000
	dc.w	$15E0,$0000
	dc.w	$0780,$0000
	dc.w	$0500,$0000
	dc.w	$0001,$0000
	dc.w	$0000,$0000
	dc.w	$1002,$0000
	dc.w	$1009,$0000
	dc.w	$0927,$0000
	dc.w	$061F,$0000
	dc.w	$03FF,$0000
	dc.w	$01FB,$0000
	dc.w	$0001,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0001,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0001,$0000
	dc.l	0

	dc.l	0
	dc.w	$0000,$0020
	dc.w	$0020,$0240
	dc.w	$0140,$028E
	dc.w	$CC65,$0110
	dc.w	$23AD,$0000
	dc.w	$199B,$0000
	dc.w	$0CC6,$0000
	dc.w	$05A8,$0000
	dc.w	$0BF1,$0000
	dc.w	$07F0,$0000
	dc.w	$15E0,$0000
	dc.w	$0780,$0000
	dc.w	$0500,$0000
	dc.w	$0001,$0000
	dc.w	$0000,$0000
	dc.w	$1002,$0000
	dc.w	$1009,$0000
	dc.w	$0927,$0000
	dc.w	$061F,$0000
	dc.w	$03FF,$0000
	dc.w	$01FB,$0000
	dc.w	$0001,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0003,$0000
	dc.w	$0007,$0000
	dc.w	$0007,$0000
	dc.w	$0003,$0000
	dc.l	0

	dc.l	0
	dc.w	$0000,$0020
	dc.w	$0020,$0240
	dc.w	$0140,$028E
	dc.w	$CC65,$0110
	dc.w	$23AD,$0000
	dc.w	$199B,$0000
	dc.w	$0CC6,$0000
	dc.w	$05A8,$0000
	dc.w	$0BF1,$0000
	dc.w	$07F0,$0000
	dc.w	$15E0,$0000
	dc.w	$0780,$0000
	dc.w	$0500,$0000
	dc.w	$0001,$0000
	dc.w	$0000,$0000
	dc.w	$1002,$0000
	dc.w	$1009,$0000
	dc.w	$0927,$0000
	dc.w	$061F,$0000
	dc.w	$03FF,$0000
	dc.w	$01FB,$0000
	dc.w	$0001,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0001,$0000
	dc.w	$0001,$0000
	dc.w	$0000,$0000
	dc.l	0

	dc.l	0
	dc.w	$0000,$0020
	dc.w	$0020,$0240
	dc.w	$0140,$028E
	dc.w	$CC65,$0110
	dc.w	$23AD,$0000
	dc.w	$199B,$0000
	dc.w	$0CC6,$0000
	dc.w	$05A8,$0000
	dc.w	$0BF1,$0000
	dc.w	$07F0,$0000
	dc.w	$15E0,$0000
	dc.w	$0780,$0000
	dc.w	$0500,$0000
	dc.w	$0001,$0000
	dc.w	$0000,$0000
	dc.w	$1002,$0000
	dc.w	$1009,$0000
	dc.w	$0927,$0000
	dc.w	$061F,$0000
	dc.w	$03FF,$0000
	dc.w	$01FB,$0000
	dc.w	$0001,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0004,$0000
	dc.w	$0003,$0000
	dc.w	$0002,$0000
	dc.w	$0004,$0000
	dc.l	0

	;RIGHT SIDE
	;Even ATTACH pair follows:
spr3:	dc.l	0
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$8000,$D000
	dc.w	$B800,$F000
	dc.w	$A000,$8000
	dc.w	$0000,$4000
	dc.w	$0080,$81A0
	dc.w	$0180,$01D0
	dc.w	$00F0,$01E0
	dc.w	$0040,$01E0
	dc.w	$0030,$80F0
	dc.w	$8070,$0030
	dc.w	$6630,$3C30
	dc.w	$B9D0,$7F70
	dc.w	$54B0,$FFE0
	dc.w	$FE00,$FFD0
	dc.w	$6C60,$FFC0
	dc.w	$32C0,$FFE0
	dc.w	$8180,$FF80
	dc.w	$EF40,$FF00
	dc.w	$B900,$B940
	dc.w	$8100,$8140
	dc.w	$A740,$8100
	dc.w	$BCA0,$8180
	dc.w	$5B40,$C3C0
	dc.w	$5A80,$C3A0
	dc.w	$BD00,$8140
	dc.l	0

	dc.l	0
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$8000,$D000
	dc.w	$B800,$F000
	dc.w	$A000,$8000
	dc.w	$0000,$4000
	dc.w	$0080,$81A0
	dc.w	$0180,$01D0
	dc.w	$00F0,$01E0
	dc.w	$0040,$01E0
	dc.w	$0030,$80F0
	dc.w	$8070,$0030
	dc.w	$6630,$3C30
	dc.w	$B9D0,$7F70
	dc.w	$54B0,$FFE0
	dc.w	$FE00,$FFD0
	dc.w	$6C60,$FFC0
	dc.w	$32C0,$FFE0
	dc.w	$8180,$FF80
	dc.w	$EF40,$FF00
	dc.w	$B8A0,$B980
	dc.w	$C040,$C0C0
	dc.w	$D320,$45E0
	dc.w	$5680,$C9E0
	dc.w	$AFE0,$E1E0
	dc.w	$2FE0,$E0C0
	dc.w	$4780,$D000
	dc.l	0

	dc.l	0
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$8000,$D000
	dc.w	$B800,$F000
	dc.w	$A000,$8000
	dc.w	$0000,$4000
	dc.w	$0080,$81A0
	dc.w	$0180,$01D0
	dc.w	$00F0,$01E0
	dc.w	$0040,$01E0
	dc.w	$0030,$80F0
	dc.w	$8070,$0030
	dc.w	$6630,$3C30
	dc.w	$B9D0,$7F70
	dc.w	$54B0,$FFE0
	dc.w	$FE00,$FFD0
	dc.w	$6C60,$FFC0
	dc.w	$32C0,$FFE0
	dc.w	$8180,$FF80
	dc.w	$EF40,$FF00
	dc.w	$F900,$F940
	dc.w	$6300,$6300
	dc.w	$E2C0,$2E00
	dc.w	$AAC0,$EE00
	dc.w	$DD60,$FF00
	dc.w	$9960,$FF00
	dc.w	$AAC0,$EE00
	dc.l	0

	dc.l	0
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$8000,$D000
	dc.w	$B800,$F000
	dc.w	$A000,$8000
	dc.w	$0000,$4000
	dc.w	$0080,$81A0
	dc.w	$0180,$01D0
	dc.w	$00F0,$01E0
	dc.w	$0040,$01E0
	dc.w	$0030,$80F0
	dc.w	$8070,$0030
	dc.w	$6630,$3C30
	dc.w	$B9D0,$7F70
	dc.w	$54B0,$FFE0
	dc.w	$FE00,$FFD0
	dc.w	$6C60,$FFC0
	dc.w	$32C0,$FFE0
	dc.w	$8180,$FF80
	dc.w	$EF40,$FF00
	dc.w	$78A0,$7880
	dc.w	$60F0,$60C0
	dc.w	$79B8,$3480
	dc.w	$96BC,$3380
	dc.w	$6F5C,$7FC0
	dc.w	$5658,$77C0
	dc.w	$AEA0,$2390
	dc.l	0

	dc.l	0
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$8000,$D000
	dc.w	$B800,$F000
	dc.w	$A000,$8000
	dc.w	$0000,$4000
	dc.w	$0080,$81A0
	dc.w	$0180,$01D0
	dc.w	$00F0,$01E0
	dc.w	$0040,$01E0
	dc.w	$0030,$80F0
	dc.w	$8070,$0030
	dc.w	$6630,$3C30
	dc.w	$B9D0,$7F70
	dc.w	$54B0,$FFE0
	dc.w	$FE00,$FFD0
	dc.w	$6C60,$FFC0
	dc.w	$32C0,$FFE0
	dc.w	$8180,$FF80
	dc.w	$EF40,$FF00
	dc.w	$B900,$B940
	dc.w	$81C0,$8180
	dc.w	$A780,$9080
	dc.w	$1E80,$23A0
	dc.w	$BF40,$87C0
	dc.w	$BE40,$87C0
	dc.w	$1E80,$43A0
	dc.l	0

	;Odd ATTACH pair follows:
spr4:	dc.l	0
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$B000,$0000
	dc.w	$8800,$0000
	dc.w	$6000,$0000
	dc.w	$C000,$0000
	dc.w	$8160,$0000
	dc.w	$00B0,$0000
	dc.w	$00D0,$0000
	dc.w	$0150,$0000
	dc.w	$80A0,$0000
	dc.w	$8060,$0000
	dc.w	$C260,$0000
	dc.w	$B8C0,$0000
	dc.w	$5410,$0000
	dc.w	$FE30,$0000
	dc.w	$6C20,$0000
	dc.w	$3020,$0000
	dc.w	$0040,$0000
	dc.w	$00C0,$0000
	dc.w	$46C0,$0000
	dc.w	$7EC0,$0000
	dc.w	$66C0,$0000
	dc.w	$7E60,$0000
	dc.w	$3F20,$0000
	dc.w	$3E60,$0000
	dc.w	$7EC0,$0000
	dc.l	0

	dc.l	0
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$B000,$0000
	dc.w	$8800,$0000
	dc.w	$6000,$0000
	dc.w	$C000,$0000
	dc.w	$8160,$0000
	dc.w	$00B0,$0000
	dc.w	$00D0,$0000
	dc.w	$0150,$0000
	dc.w	$80A0,$0000
	dc.w	$8060,$0000
	dc.w	$C260,$0000
	dc.w	$B8C0,$0000
	dc.w	$5410,$0000
	dc.w	$FE30,$0000
	dc.w	$6C20,$0000
	dc.w	$3020,$0000
	dc.w	$0040,$0000
	dc.w	$00C0,$0000
	dc.w	$4660,$0000
	dc.w	$3F20,$0000
	dc.w	$B600,$0000
	dc.w	$3E80,$0000
	dc.w	$9EC0,$0000
	dc.w	$1F20,$0000
	dc.w	$3780,$0000
	dc.l	0

	dc.l	0
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$B000,$0000
	dc.w	$8800,$0000
	dc.w	$6000,$0000
	dc.w	$C000,$0000
	dc.w	$8160,$0000
	dc.w	$00B0,$0000
	dc.w	$00D0,$0000
	dc.w	$0150,$0000
	dc.w	$80A0,$0000
	dc.w	$8060,$0000
	dc.w	$C260,$0000
	dc.w	$B8C0,$0000
	dc.w	$5410,$0000
	dc.w	$FE30,$0000
	dc.w	$6C20,$0000
	dc.w	$3020,$0000
	dc.w	$0040,$0000
	dc.w	$00C0,$0000
	dc.w	$06C0,$0000
	dc.w	$9C80,$0000
	dc.w	$DDC0,$0000
	dc.w	$11C0,$0000
	dc.w	$CCE0,$0000
	dc.w	$88E0,$0000
	dc.w	$11C0,$0000
	dc.l	0

	dc.l	0
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$B000,$0000
	dc.w	$8800,$0000
	dc.w	$6000,$0000
	dc.w	$C000,$0000
	dc.w	$8160,$0000
	dc.w	$00B0,$0000
	dc.w	$00D0,$0000
	dc.w	$0150,$0000
	dc.w	$80A0,$0000
	dc.w	$8060,$0000
	dc.w	$C260,$0000
	dc.w	$B8C0,$0000
	dc.w	$5410,$0000
	dc.w	$FE30,$0000
	dc.w	$6C20,$0000
	dc.w	$3020,$0000
	dc.w	$0040,$0000
	dc.w	$00C0,$0000
	dc.w	$8760,$0000
	dc.w	$9F30,$0000
	dc.w	$4D78,$0000
	dc.w	$CC7C,$0000
	dc.w	$E33C,$0000
	dc.w	$CA38,$0000
	dc.w	$DC70,$0000
	dc.l	0

	dc.l	0
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$B000,$0000
	dc.w	$8800,$0000
	dc.w	$6000,$0000
	dc.w	$C000,$0000
	dc.w	$8160,$0000
	dc.w	$00B0,$0000
	dc.w	$00D0,$0000
	dc.w	$0150,$0000
	dc.w	$80A0,$0000
	dc.w	$8060,$0000
	dc.w	$C260,$0000
	dc.w	$B8C0,$0000
	dc.w	$5410,$0000
	dc.w	$FE30,$0000
	dc.w	$6C20,$0000
	dc.w	$3020,$0000
	dc.w	$0040,$0000
	dc.w	$00C0,$0000
	dc.w	$46C0,$0000
	dc.w	$7E40,$0000
	dc.w	$7740,$0000
	dc.w	$FC60,$0000
	dc.w	$7B20,$0000
	dc.w	$7A20,$0000
	dc.w	$DC60,$0000
	dc.l	0

	INCDIR	"dh1:Code/Sources/HTSAC/ExploCat/"
MyAnim:	INCBIN	"Skak2.anim"
MyCat:	INCBIN	"Cat#1.blit4*32*28+cmap"

Clear:
Screen:	blk.b	44*283*2,0
CatScreen:	blk.b	44*283*4,0

TheEnd:

*******************************************************************************
**Print info on program
*******************************************************************************
	printt
	printt	'Memory used for demo:'
	printt	'---------------------'
	printt	'Startaddress:'
	printv	Begin
	printt	'Endaddress:'
	printv	TheEnd
	printt
	printt	'Length in bytes:'
	printv	TheEnd-Begin
	printt	'Length in kilobytes:'
	printv	(TheEnd-Begin)/1024
	printt	'Percentage of total available memory:'
	printv	((TheEnd-Begin)*100/524288)
	printt

*******************************************************************************
**Hardware registers
*******************************************************************************
Bltddat=$000
Dmaconr=$002
Vposr=$004
Vhposr=$006
Dskdatr=$008
Joy0dat=$00a
Joy1dat=$00c
Clxdat=$00e
Adkconr=$010
Pot0dat=$012
Pot1dat=$014
Potgor=$016
Serdatr=$018
Dskbytr=$01a
Intenar=$01c
Intreqr=$01e
Dskpth=$020
Dskptl=$022
Dsklen=$024
Dskdat=$026
Refptr=$028
Vposw=$02a
Vhposw=$02c
Copcon=$02e
Serdat=$030
Serper=$032
Potgo=$034
Joytest=$036
Strequ=$038
Strvbl=$03a
Strhor=$03c
Strlong=$03e
Bltcon0=$040
Bltcon1=$042
Bltafwm=$044
Bltalwm=$046
Bltcpth=$048
Bltcptl=$04a
Bltbpth=$04c
Bltbptl=$04e
Bltapth=$050
Bltaptl=$052
Bltdpth=$054
Bltdptl=$056
Bltsize=$058
Bltcmod=$060
Bltbmod=$062
Bltamod=$064
Bltdmod=$066
Bltcdat=$070
Bltbdat=$072
Bltadat=$074
Dsksync=$07e
Cop1lch=$080
Cop1lcl=$082
Cop2lch=$084
Cop2lcl=$086
Copjmp1=$088
Copjmp2=$08a
Copins=$08c
Diwstrt=$08e
Diwstop=$090
Ddfstrt=$092
Ddfstop=$094
Dmacon=$096
Clxcon=$98
Intena=$09a
Intreq=$09c
Adkcon=$09e
Aud0dat=$0aa
Aud1dat=$0ba
Aud2dat=$0ca
Aud3dat=$0da
Aud0lch=$0a0
Aud1lch=$0b0
Aud2lch=$0c0
Aud3lch=$0d0
Aud0len=$0a4
Aud1len=$0b4
Aud2len=$0c4
Aud3len=$0d4
Aud0per=$0a6
Aud1per=$0b6
Aud2per=$0c6
Aud3per=$0d6
Aud0vol=$0a8
Aud1vol=$0b8
Aud2vol=$0c8
Aud3vol=$0d8
Aud0lcl=$0a2
Aud1lcl=$0b2
Aud2lcl=$0c2
Aud3lcl=$0d2
Bpl1pth=$0e0
Bpl1ptl=$0e2
Bpl2pth=$0e4
Bpl2ptl=$0e6
Bpl3pth=$0e8
Bpl3ptl=$0ea
Bpl4pth=$0ec
Bpl4ptl=$0ee
Bpl5pth=$0f0
Bpl5ptl=$0f2
Bpl6pth=$0f4
Bpl6ptl=$0f6
Bplcon0=$100
Bplcon1=$102
Bplcon2=$104
Bpl1mod=$108
Bpl2mod=$10a
Bpl1dat=$110
Bpl2dat=$112
Bpl3dat=$114
Bpl4dat=$116
Bpl5dat=$118
Bpl6dat=$11a
Spr0pth=$120
Spr0ptl=$122
Spr1pth=$124
Spr1ptl=$126
Spr2pth=$128
Spr2ptl=$12a
Spr3pth=$12c
Spr3ptl=$12e
Spr4pth=$130
Spr4ptl=$132
Spr5pth=$134
Spr5ptl=$136
Spr6pth=$138
Spr6ptl=$13a
Spr7pth=$13c
Spr7ptl=$13e
Spr0pos=$140
Spr0ctl=$142
Spr0data=$144
Spr0datb=$146
Spr1pos=$148
Spr1ctl=$14a
Spr1data=$14c
Spr1datb=$14e
Spr2pos=$150
Spr2ctl=$152
Spr2data=$154
Spr2datb=$156
Spr3pos=$158
Spr3ctl=$15a
Spr3data=$15c
Spr3datb=$15e
Spr4pos=$160
Spr4ctl=$162
Spr4data=$164
Spr4datb=$166
Spr5pos=$168
Spr5ctl=$16a
Spr5data=$16c
Spr5datb=$16e
Spr6pos=$170
Spr6ctl=$172
Spr6data=$174
Spr6datb=$176
Spr7pos=$178
Spr7ctl=$17a
Spr7data=$17c
Spr7datb=$17e
Color00=$180
Color01=$182
Color02=$184
Color03=$186
Color04=$188
Color05=$18a
Color06=$18c
Color07=$18e
Color08=$190
Color09=$192
Color10=$194
Color11=$196
Color12=$198
Color13=$19a
Color14=$19c
Color15=$19e
Color16=$1a0
Color17=$1a2
Color18=$1a4
Color19=$1a6
Color20=$1a8
Color21=$1aa
Color22=$1ac
Color23=$1ae
Color24=$1b0
Color25=$1b2
Color26=$1b4
Color27=$1b6
Color28=$1b8
Color29=$1ba
Color30=$1bc
Color31=$1be
Base=$dff000

*******************************************************************************
**Interrupt addresses
*******************************************************************************
Lev1Base=$64
Lev2Base=$68
Lev3Base=$6c
Lev4Base=$70
Lev5Base=$74
Lev6Base=$78
Lev7Base=$7c
Trap0=$80












