  Gg  RGgGgGgGgGgGg;-------------------T--------T

Track=1	;0=ASM-One version
	;1=Track version
Raster=0
Width=352
Height=288
BckCol=$202
TandCol=$884
TandColAGA=($808040>>1)&$7f7f7f
AGA=0


MyDmaco2=%11001000000
MyDmacon=%11111100000
;         abcdefghhhh
; a = Blitter nasty
; b = Enable DMA activity (always set this!)
; c = Bitplane enable
; d = Copper enable
; e = Blitter enable
; f = Sprite enable
; g = Disk enable
; h = Audio channels enable

MyIntena=%100000000100000
;         abcdeeeefghijkl
; a = Enable interrupts
; b = Lev. 6 External interrupt
; c = Lev. 5 Disk sync found
; d = Lev. 5 Serial port receive buffer full
; e = Lev. 4 Audio ch. 3-0 block finished
; f = Lev. 3 Blitter finished
; g = Lev. 3 Vertical blank
; h = Lev. 3 Copper
; i = Lev. 2 I/O Ports and timers
; j = Lev. 1 Software
; k = Lev. 1 Disk block finished
; l = Lev. 1 Serial port transmit buffer empty

	JumpPtr	Begin

	SECTION	Kode,code

*******************************************************************************
**Macros
*******************************************************************************
CopBltWait:	EQU	$00017ffe

WaitBlt:	MACRO
	btst	#14,Dmaconr+_Custom
.vent\@:	if	Raster=1
	move.w	#$fff,Color00+_Custom
	endif
	btst	#14,Dmaconr+_Custom
	bne.b	.vent\@
	if	Raster=1
	move.w	#0,Color00+_Custom
	endif
	ENDM

SetInt:	MACRO
	move.l	(Lev\1Base).w,OldIrq\1
	move.l	#Lev\1Irq,(Lev\1Base).w
	bra.b	jumpo\@
OldIrq\1:	dc.l	0
jumpo\@:
	ENDM

ClrInt:	MACRO
	move.l	OldIrq\1(pc),(Lev\1Base).w
	ENDM

Push.l:	MACRO
	movem.l	\1,-(sp)
	ENDM

Push.w:	MACRO
	movem.w	\1,-(sp)
	ENDM

Pull.l:	MACRO
	movem.l	(sp)+,\1
	ENDM

Pull.w:	MACRO
	movem.w	(sp)+,\1
	ENDM

StartPrg:	MACRO
	move.w	#$7fff,Intreq+_Custom
	move.w	#MyDmacon+$8000,Dmacon+_Custom
	move.w	#MyIntena+$8000,Intena+_Custom
	ENDM

StopPrg:	MACRO
	move.w	#$7fff,Intena+_Custom
	move.w	#$7fff,Dmacon+_Custom
	move.w	#$7fff,Intreq+_Custom
	ENDM

StopSystem:	MACRO
	move.w	Intenar+_Custom,OldIntena
	move.w	Dmaconr+_Custom,OldDmacon
	StopPrg
	bra.b	jumpo\@
OldIntena:	dc.w	0
OldDmacon:	dc.w	0
jumpo\@:
	ENDM

StartSystem:	MACRO
	move.w	OldDmacon(pc),d0
	or.w	#$8000,d0
	move.w	d0,Dmacon+_Custom
	move.w	OldIntena(pc),d0
	or.w	#$8000,d0
	move.w	d0,Intena+_Custom
	ENDM


*******************************************************************************
**Initialisering
*******************************************************************************
Begin:
	IF	Track=0
	Push.l	d0-a6
	StopSystem
	ELSE
	move.l	#Lev3Irq,(Lev1Base).w
	rts
	ENDC
**Init starter -----------------------------------
	lea	Clear,a0
	move.l	#(TheEnd-Clear)/4,d0
.clrloop:	clr.l	(a0)+
	subq.l	#1,d0
	bne.b	.clrloop

	lea	SinusTabel(pc),a0
	move.w	#1024+256-1,d0
.loop	asr.w	#1,(a0)+
	dbra	d0,.loop

	lea	ScrollPointer,a0
	move.l	#ScrollGfx,d0
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)

	WaitBlt

**Init slutter -----------------------------------

	IFEQ	Track-0
	SetInt	3
	clr.l	$0.w
	StartPrg

*******************************************************************************
**Vent p exitsignal
*******************************************************************************
WaitForExit:	bsr.b	WaitVBlank
	tst.w	IWantOut
	bne.b	ExitToDos
	bra.b	WaitForExit

WaitBlanks:	bsr.b	WaitVBlank
	dbra	d0,WaitBlanks
	rts
WaitVBlank:	clr.w	VBlank
.wait	tst.w	VBlank
	beq.b	.wait
	rts

*******************************************************************************
**Exit to AmigaDOS
*******************************************************************************
ExitToDos:
	StopPrg

**Exit starter -----------------------------------
	ClrInt	3
**Exit slutter -----------------------------------

	StartSystem

	Pull.l	d0-a6
	moveq	#0,d0
	ENDC
	rts

*******************************************************************************
**Level 3 interrupt
*******************************************************************************
MegaPause:	dc.w	0
MegaStory:	dc.w	0
MaxRast:	dc.w	0
VBlank:	dc.w	0
	IF	Track=0
IWantOut:	dc.w	0
	ELSE
IWantOut:	EQU	$80
	ENDC
Lev3Irq:	move.w	#1,VBlank
	Push.l	d0-a6
**Lev3irq starter --------------------------------
	bsr.b	MegaStoryBoard
**Lev3irq slutter --------------------------------
	IFEQ	Track-0
	btst	#6,$bfe001
	bne.b	.noleft
	move.w	#-1,IWantOut
.noleft
	ENDC
	WaitBlt
	IF	Raster=1
	move.w	#$f00,$dff180
	ENDIF
	move.b	$dff005,d0
	lsl.w	#8,d0
	move.b	$dff006,d0
	cmp.w	MaxRast(pc),d0
	bls.b	.nooot
	move.w	d0,MaxRast
.nooot	Pull.l	d0-a6
	IFEQ	Track-0
	move.w	#$0020,Intreq+_Custom
	ELSE
	move.w	#$0004,Intreq+_Custom
	ENDC
	rte


MegaStoryBoard:	move.w	MegaStory(pc),d0
	add.w	d0,d0
	add.w	d0,d0
	move.l	.routines(PC,d0.w),a0
	jmp	(a0)

.routines	dc.l	FadeUp
	dc.l	Init_Vec,Lev3_Vec,MoveGfx
	dc.l	FadeDown,MakeExit

Ting:	dc.w	0

FadeUp:	move.l	#SunCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom

	moveq	#2-1,d7
	lea	FadeColsBck(pc),a1
	lea	FadeCopper+2,a0
.dloop	move.w	(a0),d0
	move.w	(a1)+,d1
	bsr.w	fader
	move.w	d0,(a0)
	addq.w	#4,a0
	dbra	d7,.dloop

	addq.w	#1,Ting
	cmp.w	#20,Ting
	bne.b	.out
	addq.w	#1,MegaStory
.out	rts

FadeDown:	move.l	#Copper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom

	moveq	#4-1,d7
	lea	CopColors+2,a0
.dloop	move.w	(a0),d0
	moveq	#0,d1
	bsr.w	fader
	move.w	d0,(a0)
	addq.w	#4,a0
	dbra	d7,.dloop

	subq.w	#1,Ting
	bne.b	.out
	addq.w	#1,MegaStory
.out	rts


FadeColsBck:	dc.w	BckCol
	dc.w	0



MakeExit:	move.l	#Copper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	move.w	#-1,IWantOut
	rts


GfxPause:	dc.w	35
GfxTing:	dc.w	0
MoveGfx:	move.l	#Copper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#%10,Copcon+_Custom

	move.l	#ScrollGfx,d0
	moveq	#0,d1
	move.w	GfxTing(pc),d1
	add.l	d1,d0

	lea	ScrollPointer,a0
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)

	cmp.w	#50,GfxTing
	bne.b	.norm
	tst.w	GfxPause
	beq.b	.norm
	subq.w	#1,GfxPause
	rts
.norm	addq.w	#2,GfxTing
	cmp.w	#88,GfxTing
	bne.b	.out
	addq.w	#1,MegaStory
.out

	rts

Lev3_Vec:	move.l	#Copper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#%10,Copcon+_Custom

	bsr.w	SwapScr
	bsr.w	ClrScr
	bsr.w	RotatePoints
	bsr.w	CalcFaces
	bsr.w	DrawFaces
	bsr.w	FillScr
	bsr.w	MoveObject
	bsr.w	FadeSvend

	cmp.w	#7000,ZCenter
	beq.b	.dont
	sub.w	#400,ZCenter
	bra.b	.goon
.dont	addq.w	#1,MegaStory
.goon	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	IF	Raster=1
	move.l	#Color00<<16!$fff,(a6)+
	ENDIF
	move.l	#ScrollCopper,d0
	move.w	#Cop2lcl,(a6)+
	move.w	d0,(a6)+
	swap	d0
	move.w	#Cop2lch,(a6)+
	move.w	d0,(a6)+
	move.l	#Copjmp2<<16,(a6)+
	move.l	a6,BltCopPtr

;	cmp.w	#820,MegaPause
;	bne.b	.noleft
;	addq.w	#1,MegaStory
.noleft	addq.w	#1,MegaPause

	rts

Init_Vec:	move.l	#BlackCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	bsr.w	SwapScr
	bsr.w	ClrScr
	bsr.w	MoveObject
	bsr.w	RotatePoints
	bsr.w	CalcFaces
	bsr.w	DrawFaces
	bsr.w	FillScr
	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	IF	Raster=1
	move.l	#Color00<<16+$888,(a6)+
	ENDIF
	move.l	#-2,(a6)
	addq.w	#1,MegaStory
	rts




*******************************************************************************
**Fade svend
*******************************************************************************
FadeSvend:	cmp.w	#20,MegaPause
	blt.b	.up
	rts
.up	moveq	#6-1,d7
	lea	BckVecColors(pc),a1
	lea	VecColors(pc),a0
.dloop	move.w	(a0),d0
	move.w	(a1)+,d1
	bsr.b	fader
	move.w	d0,(a0)+
	dbra	d7,.dloop
	rts


BckVecColors:	dc.w	$604
	dc.w	$fde
	blk.w	6,0



**d0=fade from
**d1=fade to
**out: d0=newcol
fader:	move.w	d0,d2
	move.w	d1,d3
	lsr.w	#8,d2
	lsr.w	#8,d3
	cmp.w	d2,d3
	beq.b	.nored
	blt.b	.redsub
	add.w	#$100,d0
	bra.b	.nored
.redsub:	sub.w	#$100,d0
.nored:	move.w	d0,d2
	move.w	d1,d3
	lsr.w	#4,d2
	lsr.w	#4,d3
	and.w	#$f,d2
	and.w	#$f,d3
	cmp.w	d2,d3
	beq.b	.nogreen
	blt.b	.greensub
	add.w	#$10,d0
	bra.b	.nogreen
.greensub:	sub.w	#$10,d0
.nogreen:	move.w	d0,d2
	move.w	d1,d3
	and.w	#$f,d2
	and.w	#$f,d3
	cmp.w	d2,d3
	beq.b	.noblue
	blt.b	.bluesub
	addq.w	#$1,d0
	bra.b	.noblue
.bluesub:	subq.w	#$1,d0
.noblue:	rts







*******************************************************************************
**Calc faces
*******************************************************************************
CalcFaces:
	lea	Faces(pc),a0
	lea	Rotated(pc),a1
	lea	FaceColors(pc),a2
	lea	VecColors(pc),a3
	lea	AllColors(pc),a4
	clr.w	-(sp)

.nextface:	clr.w	(a2)

	move.w	(a0)+,(sp)	;farve
	blt.w	.ud

	move.w	(a0)+,d6	;antal linjer

	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d0
	move.w	2(a1,d7.w),d1

	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d2
	move.w	2(a1,d7.w),d3

	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d4
	move.w	2(a1,d7.w),d5
	

	sub.w	d0,d2
	sub.w	d1,d3
	sub.w	d0,d4
	sub.w	d1,d5
	muls	d2,d5
	muls	d3,d4
	sub.l	d4,d5

	move.w	(sp),d0
	move.w	d0,(a2)
	subq.w	#1,d0
	add.w	d0,d0
	move.w	d0,-(sp)

	divs	#40,d5

	move.w	(a3),d4
	move.w	d4,d0
	move.w	d4,d1
	move.w	d4,d2
	and.w	#$f00,d0
	and.w	#$0f0,d1
	and.w	#$00f,d2
	lsr.w	#4,d0
	lsl.w	#4,d2
	mulu	d5,d0
	mulu	d5,d1
	mulu	d5,d2
	lsr.l	#8,d0
	lsr.l	#8,d1
	lsr.l	#8,d2

	lsl.w	#4,d0
	lsr.w	#4,d2
	and.w	#$f00,d0
	and.w	#$0f0,d1
	and.w	#$00f,d2
	or.w	d1,d0
	or.w	d2,d0
	move.w	d0,d4

	move.w	(sp)+,d5
	move.w	d4,(a4,d5.w)


.donext:	addq.w	#2,a3
	subq.w	#3,d6
	add.w	d6,d6
	add.w	d6,a0
	addq.w	#2,a2
	bra.w	.nextface

.ud:	addq.w	#2,sp
	lea	AllColors(pc),a0
	lea	CopColors,a1
	move.w	(a0)+,4*1+2(a1)
	move.w	2(a0),4*3+2(a1)

	rts

VecColors:	blk.w	8,0
AllColors:	blk.w	16,0








*******************************************************************************
**Draw Faces
*******************************************************************************

DrawFaces:
	bsr.w	Init_Line

	lea	Faces(pc),a0
	lea	Rotated(pc),a1
	lea	FaceColors(pc),a3

.nextface:
	tst.w	(a0)+
	blt.w	.ud

	move.w	(a0)+,d6	;antal linjer

	move.w	(a3)+,LineCol
	bne.b	.drawit

;	addq.w	#1,d6
	add.w	d6,d6
	add.w	d6,a0
	bra.b	.nextface

.drawit:	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d0
	move.w	2(a1,d7.w),d1

	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d2
	move.w	2(a1,d7.w),d3

	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d4
	move.w	2(a1,d7.w),d5

	Push.w	d0-d1

	Push.w	d0-d5

	movem.w	(sp),d0-d3
	bsr.w	Line_Draw
	movem.w	4(sp),d0-d3
	bsr.w	Line_Draw
	addq.w	#8,sp
	movem.w	(sp)+,d0-d1

	subq.w	#3,d6
	bra.b	.jumpin

.lines:	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d2
	move.w	2(a1,d7.w),d3
	Push.w	d2-d3
	bsr.w	Line_Draw
	Pull.w	d0-d1
.jumpin	dbra	d6,.lines

	Pull.w	d2-d3
	bsr.w	Line_Draw

	bra.w	.nextface

.ud:
	lea	MinX1(pc),a0

	cmp.w	#Width-1,(a0)
	bgt.b	.makeno1
	cmp.w	#Height-1,2(a0)
	bgt.b	.makeno1
	tst.w	4(a0)
	blt.b	.makeno1
	tst.w	6(a0)
	blt.b	.makeno1

	tst.w	(a0)+
	bge.b	.xok1
	clr.w	-2(a0)
.xok1:	tst.w	(a0)+
	bge.b	.yok1
	clr.w	-2(a0)
.yok1:	cmp.w	#Width-1,(a0)+
	ble.b	.xok2
	move.w	#Width-1,-2(a0)
.xok2:	cmp.w	#Height-1,(a0)+
	ble.b	.yok2
	move.w	#Height-1,-2(a0)
	bra.b	.yok2
.makeno1:	move.l	#$7fff7fff,(a0)+
	move.l	#$80008000,(a0)+
.yok2:
	cmp.w	#Width-1,(a0)
	bgt.b	.makeno2
	cmp.w	#Height-1,2(a0)
	bgt.b	.makeno2
	tst.w	4(a0)
	blt.b	.makeno2
	tst.w	6(a0)
	blt.b	.makeno2

	tst.w	(a0)+
	bge.b	.xok12
	clr.w	-2(a0)
.xok12:	tst.w	(a0)+
	bge.b	.yok12
	clr.w	-2(a0)
.yok12:	cmp.w	#Width-1,(a0)+
	ble.b	.xok22
	move.w	#Width-1,-2(a0)
.xok22:	cmp.w	#Height-1,(a0)+
	ble.b	.yok22
	move.w	#Height-1,-2(a0)
	rts
.makeno2:	move.l	#$7fff7fff,(a0)+
	move.l	#$80008000,(a0)+
.yok22:
	cmp.w	#Width-1,(a0)
	bgt.b	.makeno3
	cmp.w	#Height-1,2(a0)
	bgt.b	.makeno3
	tst.w	4(a0)
	blt.b	.makeno3
	tst.w	6(a0)
	blt.b	.makeno3

	tst.w	(a0)+
	bge.b	.xok13
	clr.w	-2(a0)
.xok13:	tst.w	(a0)+
	bge.b	.yok13
	clr.w	-2(a0)
.yok13:	cmp.w	#Width-1,(a0)+
	ble.b	.xok23
	move.w	#Width-1,-2(a0)
.xok23	cmp.w	#Height-1,(a0)+
	ble.b	.yok23
	move.w	#Height-1,-2(a0)
	rts
.makeno3	move.l	#$7fff7fff,(a0)+
	move.l	#$80008000,(a0)+
.yok23
	rts






*******************************************************************************
**Rotate Points
*******************************************************************************
RotatePoints:
	lea	Points(pc),a5
	lea	Rotated(pc),a6
	lea	SinusTabel(pc),a0
	lea	CosinusTabel(pc),a1

.nextpoint:	move.w	(a5)+,d5
	cmp.w	#$8000,d5
	beq.w	.ud
	move.w	(a5)+,d6
	move.w	(a5)+,d7

**Rotation om z-aksen

	add.w	XCenter(pc),d5
	add.w	YCenter(pc),d6
	add.w	ZCenter(pc),d7
	moveq	#9,d4
	ext.l	d5
	ext.l	d6
	asl.l	d4,d5
	asl.l	d4,d6
	divs	d7,d5
	divs	d7,d6

	add.w	#Width/2,d5
	add.w	#Height/2,d6

	movem.w	d5-d6,(a6)
	addq.w	#4,a6
	bra.w	.nextpoint

.ud:	rts

fak=15

Points:	dc.w	-115*fak,-39*fak,0	;0
	dc.w	115*fak,-39*fak,0	;1
	dc.w	115*fak,39*fak,0	;2
	dc.w	-115*fak,39*fak,0	;3
	dc.w	0,-39*fak,0	;4
	dc.w	0,39*fak,0		;5

	dc.w	-106*fak,-35*fak,0	;6
	dc.w	-93*fak,-35*fak,0	;7
	dc.w	-88*fak,-30*fak,0	;8
	dc.w	-83*fak,-35*fak,0	;9
	dc.w	-70*fak,-35*fak,0	;10
	dc.w	-70*fak,34*fak,0	;11
	dc.w	-83*fak,34*fak,0	;12
	dc.w	-83*fak,-23*fak,0	;13
	dc.w	-88*fak,-18*fak,0	;14
	dc.w	-93*fak,-23*fak,0	;15
	dc.w	-93*fak,34*fak,0	;16
	dc.w	-111*fak,34*fak,0	;17
	dc.w	-111*fak,-1*fak,0	;18
	dc.w	-106*fak,-6*fak,0	;19

	dc.w	-61*fak,-35*fak,0	;20
	dc.w	-39*fak,-35*fak,0	;21
	dc.w	-39*fak,-22*fak,0	;22
	dc.w	-48*fak,-22*fak,0	;23
	dc.w	-48*fak,-18*fak,0	;24
	dc.w	-43*fak,-18*fak,0	;25
	dc.w	-43*fak,-15*fak,0	;26
	dc.w	-48*fak,-15*fak,0	;27
	dc.w	-48*fak,11*fak,0	;28
	dc.w	-25*fak,11*fak,0	;29
	dc.w	-25*fak,34*fak,0	;30
	dc.w	-66*fak,34*fak,0	;31
	dc.w	-66*fak,-1*fak,0	;32
	dc.w	-61*fak,-6*fak,0	;33

	dc.w	-16*fak,-35*fak,0	;34
	dc.w	-3*fak,-35*fak,0	;35
	dc.w	-3*fak,11*fak,0	;36
	dc.w	20*fak,11*fak,0	;37
	dc.w	20*fak,34*fak,0	;38
	dc.w	-21*fak,34*fak,0	;39
	dc.w	-21*fak,-1*fak,0	;40
	dc.w	-16*fak,-6*fak,0	;41

	dc.w	34*fak,-35*fak,0	;42
	dc.w	60*fak,-35*fak,0	;43
	dc.w	65*fak,-30*fak,0	;44
	dc.w	65*fak,34*fak,0	;45
	dc.w	24*fak,34*fak,0	;46
	dc.w	24*fak,-1*fak,0	;47
	dc.w	29*fak,-6*fak,0	;48
	dc.w	29*fak,-30*fak,0	;49

	dc.w	42*fak,-22*fak,0	;50
	dc.w	52*fak,-22*fak,0	;51
	dc.w	52*fak,11*fak,0	;52
	dc.w	42*fak,11*fak,0	;53

	dc.w	74*fak,-35*fak,0	;54
	dc.w	87*fak,-35*fak,0	;55
	dc.w	97*fak,-25*fak,0	;56
	dc.w	97*fak,-35*fak,0	;57
	dc.w	110*fak,-35*fak,0	;58
	dc.w	110*fak,34*fak,0	;59
	dc.w	97*fak,34*fak,0	;60
	dc.w	97*fak,-13*fak,0	;61
	dc.w	87*fak,-23*fak,0	;62
	dc.w	87*fak,34*fak,0	;63
	dc.w	69*fak,34*fak,0	;64
	dc.w	69*fak,-1*fak,0	;65
	dc.w	74*fak,-6*fak,0	;66



	dc.w	$8000

Rotated:	blk.l	67,0

Faces:	dc.w	1,4,3,0,4,5
	dc.w	3,4,1,2,5,4

	dc.w	2,14,6,7,8,9,10,11,12,13,14,15,16,17,18,19
	dc.w	2,14,20,21,22,23,24,25,26,27,28,29,30,31,32,33
	dc.w	2,8,34,35,36,37,38,39,40,41
	dc.w	2,8,42,43,44,45,46,47,48,49
	dc.w	2,4,50,51,52,53
	dc.w	2,13,54,55,56,57,58,59,60,61,62,63,64,65,66

	dc.w	$8000







*******************************************************************************
**Double-buffer
*******************************************************************************
Screen:	dc.l	Screen1
BltCop:	dc.l	BltCopper1
BltCopPtr:	dc.l	BltCopper1
SwapScr:
	move.l	BltCop(pc),d0
	lea	Bltpointer,a0
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)

	lea	Screen(pc),a0
	lea	Screen1,a1
	lea	Screen2,a2
	cmp.l	(a0),a1
	beq.b	.scr2
	move.l	a1,(a0)
	move.l	#BltCopper1,BltCop
	move.l	#BltCopper1,BltCopPtr
	bra.b	.dorest
.scr2:	move.l	a2,(a0)
	move.l	#BltCopper2,BltCop
	move.l	#BltCopper2,BltCopPtr
.dorest:
	move.l	Screen(pc),d0
	lea	Bitplaner,a0
	moveq	#2-1,d1
.loop:	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	add.l	#ByteWidth/2,d0
	addq.w	#8,a0
	dbra	d1,.loop

	rts

*******************************************************************************
**Fill Screen
*******************************************************************************
FillScr:
	cmp.l	#$7fff7fff,MinX1
	beq.w	.bpl2
	move.w	MaxY1(pc),d0
	muls	#ByteWidth,d0
	move.l	d0,a0
	move.w	MaxX1(pc),d1
	lsr.w	#3,d1
	and.w	#$fffe,d1
	add.w	d1,a0
	add.l	Screen(pc),a0	;Pointer
	move.w	MinX1(pc),d0
	lsr.w	#3,d0
	and.w	#$fffe,d0
	move.w	#ByteWidth-2,d2
	sub.w	d1,d2
	add.w	d0,d2
	move.w	d2,d3
	swap	d3
	move.w	d2,d3	;modulo
	move.w	MaxY1(pc),d2
	sub.w	MinY1(pc),d2
	addq.w	#1,d2
	lsl.w	#6,d2
	sub.w	d0,d1
	lsr.w	#1,d1
	addq.w	#1,d1
	or.w	d1,d2	;bltsize

	move.l	a0,d0
	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltaptl,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d0,(a6)+
	swap	d0
	move.w	#Bltapth,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdpth,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	#%0000100111110000,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	#$12,(a6)+
	move.w	#Bltafwm,(a6)+
	move.w	#-1,(a6)+
	move.w	#Bltalwm,(a6)+
	move.w	#-1,(a6)+
	move.w	#Bltdmod,(a6)+
	move.w	d3,(a6)+
	swap	d3
	move.w	#Bltamod,(a6)+
	move.w	d3,(a6)+
	move.w	#Bltsize,(a6)+
	move.w	d2,(a6)+
	move.l	a6,BltCopPtr

.bpl2:
	cmp.l	#$7fff7fff,MinX2
	beq.w	.bpl3
	move.w	MaxY2(pc),d0
	muls	#ByteWidth,d0
	move.l	d0,a0
	move.w	MaxX2(pc),d1
	lsr.w	#3,d1
	and.w	#$fffe,d1
	add.w	d1,a0
	add.l	Screen(pc),a0
	add.w	#ByteWidth/2,a0	;Pointer
	move.w	MinX2(pc),d0
	lsr.w	#3,d0
	and.w	#$fffe,d0
	move.w	#ByteWidth-2,d2
	sub.w	d1,d2
	add.w	d0,d2
	move.w	d2,d3
	swap	d3
	move.w	d2,d3	;modulo
	move.w	MaxY2(pc),d2
	sub.w	MinY2(pc),d2
	addq.w	#1,d2
	lsl.w	#6,d2
	sub.w	d0,d1
	lsr.w	#1,d1
	addq.w	#1,d1
	or.w	d1,d2	;bltsize

	move.l	a0,d0
	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltaptl,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d0,(a6)+
	swap	d0
	move.w	#Bltapth,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdpth,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	#%0000100111110000,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	#$12,(a6)+
	move.w	#Bltafwm,(a6)+
	move.w	#-1,(a6)+
	move.w	#Bltalwm,(a6)+
	move.w	#-1,(a6)+
	move.w	#Bltdmod,(a6)+
	move.w	d3,(a6)+
	swap	d3
	move.w	#Bltamod,(a6)+
	move.w	d3,(a6)+
	move.w	#Bltsize,(a6)+
	move.w	d2,(a6)+
	move.l	a6,BltCopPtr

.bpl3:
	rts






	
MinX1:	dc.w	$7fff
MinY1:	dc.w	$7fff
MaxX1:	dc.w	$8000
MaxY1:	dc.w	$8000
MinX2:	dc.w	$7fff
MinY2:	dc.w	$7fff
MaxX2:	dc.w	$8000
MaxY2:	dc.w	$8000
MinX3:	dc.w	$7fff
MinY3:	dc.w	$7fff
MaxX3:	dc.w	$8000
MaxY3:	dc.w	$8000

	dc.l	$7fff7fff,$80008000
	dc.l	$7fff7fff,$80008000
	dc.l	$7fff7fff,$80008000

	dc.l	$7fff7fff,$80008000
	dc.l	$7fff7fff,$80008000
	dc.l	$7fff7fff,$80008000


*******************************************************************************
**Line routine
**regs used: d0-d5/a0/a6
*******************************************************************************
ByteWidth=44*2
LineCol:	dc.w	0

Init_Line:	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltcmod,(a6)+
	move.w	#ByteWidth,(a6)+
	move.w	#Bltbdat,(a6)+
	move.w	#$ffff,(a6)+
	move.w	#Bltadat,(a6)+
	move.w	#$8000,(a6)+
	move.w	#Bltafwm,(a6)+
	move.w	#-1,(a6)+
	move.w	#Bltalwm,(a6)+
	move.w	#-1,(a6)+
	move.l	a6,BltCopPtr
	rts

Line_Draw:	move.w	LineCol(pc),d7
	btst	#0,d7
	beq.b	.tstbpl2
	lea	MinX1(pc),a2
	cmp.w	(a2)+,d0
	bgt.b	.minxok1
	move.w	d0,-2(a2)
.minxok1:	cmp.w	(a2)+,d1
	bgt.b	.minyok1
	move.w	d1,-2(a2)
.minyok1:	cmp.w	(a2)+,d0
	blt.b	.maxxok1
	move.w	d0,-2(a2)
.maxxok1:	cmp.w	(a2)+,d1
	blt.b	.tstbpl2
	move.w	d1,-2(a2)
.tstbpl2:	btst	#1,d7
	beq.b	.tstbpl3
	lea	MinX2(pc),a2
	cmp.w	(a2)+,d0
	bgt.b	.minxok2
	move.w	d0,-2(a2)
.minxok2:	cmp.w	(a2)+,d1
	bgt.b	.minyok2
	move.w	d1,-2(a2)
.minyok2:	cmp.w	(a2)+,d0
	blt.b	.maxxok2
	move.w	d0,-2(a2)
.maxxok2:	cmp.w	(a2)+,d1
	blt.b	.tstbpl3
	move.w	d1,-2(a2)
.tstbpl3:
.makeline:
	bsr.w	Line_Clip
	beq.w	.out

	cmp.w	d1,d3
	bgt.b	.line1
	exg	d0,d2
	exg	d1,d3
	beq.w	.out
.line1:	move.w	d1,d4
	muls	#ByteWidth,d4
	move.w	d0,d5
	add.l	Screen(pc),d4
	asr.w	#3,d5
	ext.l	d5
	add.l	d5,d4
	moveq	#0,d5
	sub.w	d1,d3
	sub.w	d0,d2
	bpl.s	.line2
	moveq	#1,d5
	neg.w	d2
.line2:	move.w	d3,d1
	add.w	d1,d1
	cmp.w	d2,d1
	dbhi	d3,.line3
.line3:	move.w	d3,d1
	sub.w	d2,d1
	bpl.s	.line4
	exg	d2,d3
.line4:	addx.w	d5,d5
	add.w	d2,d2
	move.w	d2,d1
	sub.w	d3,d2
	addx.w	d5,d5
	and.w	#15,d0
	ror.w	#4,d0
	or.w	#$a4a,d0
	move.w	d2,-(sp)
	sub.w	d3,d2
	lsl.w	#6,d3
	addq.w	#2,d3
	lea	Octants(pc),a2
	move.b	(a2,d5.w),d5
	swap	d1
	move.w	d2,d1
	btst	#0,d7
	beq.b	.bpl2

	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltaptl,(a6)+
	move.w	(sp),(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	d5,(a6)+
	move.w	#Bltcptl,(a6)+
	move.w	d4,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d4,(a6)+
	swap	d4
	move.w	#Bltcpth,(a6)+
	move.w	d4,(a6)+
	move.w	#Bltdpth,(a6)+
	move.w	d4,(a6)+
	swap	d4
	move.w	#Bltamod,(a6)+
	move.w	d1,(a6)+
	swap	d1
	move.w	#Bltbmod,(a6)+
	move.w	d1,(a6)+
	swap	d1
	move.w	#Bltsize,(a6)+
	move.w	d3,(a6)+
	move.l	a6,BltCopPtr
.bpl2:	add.l	#ByteWidth/2,d4
	btst	#1,d7
	beq.b	.bpl3
	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltaptl,(a6)+
	move.w	(sp),(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	d5,(a6)+
	move.w	#Bltcptl,(a6)+
	move.w	d4,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d4,(a6)+
	swap	d4
	move.w	#Bltcpth,(a6)+
	move.w	d4,(a6)+
	move.w	#Bltdpth,(a6)+
	move.w	d4,(a6)+
	swap	d4
	move.w	#Bltamod,(a6)+
	move.w	d1,(a6)+
	swap	d1
	move.w	#Bltbmod,(a6)+
	move.w	d1,(a6)+
	swap	d1
	move.w	#Bltsize,(a6)+
	move.w	d3,(a6)+
	move.l	a6,BltCopPtr
.bpl3:
	addq.w	#2,sp
.out	tst.w	Clip_Mark
	beq.b	.out2
	move.w	#(Width-1),d0
	move.w	Clip_LineY1(pc),d1
	move.w	#(Width-1),d2
	move.w	Clip_LineY2(pc),d3
	bra.w	.makeline
.out2:	RTS

Octants:	dc.b	$03,$43,$13,$53,$0b,$4b,$17,$57

*******************************************************************************
**ClipLine routine
**regs used: d0-d5
**input:
**d0: xstart  d1: ystart  d2: xstop  d3: ystop
**output:
**d0: xstart  d1: ystart  d2: xstop  d3: ystop
**d4: 0 if line is not supposed to be drawn
**sr: tst.w d4
*******************************************************************************
Screen_Width:	EQU	352
Screen_Height:	EQU	288
Clip_LineY1:	dc.w	0
Clip_LineY2:	dc.w	0
Clip_Mark:	dc.w	0
Line_Clip:	clr.l	Clip_LineY1
	clr.w	Clip_Mark
.tryagain:	cmp.w	d1,d3
	bge.b	.yturned
	exg	d0,d2
	exg	d1,d3
.yturned:	tst.w	d3
	blt.b	.dontdraw
	cmp.w	#Screen_Height-1,d1
	bgt.b	.dontdraw
	cmp.w	#Screen_Height-1,d3
	bgt.b	.clipdown
	tst.w	d1
	blt.w	.clipup

	cmp.w	d0,d2
	bge.b	.xturned
	exg	d0,d2
	exg	d1,d3
.xturned:	tst.w	d2
	blt.b	.dontdraw
	cmp.w	#Screen_Width-1,d0
	bgt.b	.dontdraw2
	tst.w	d0
	blt.b	.clipleft
	cmp.w	#Screen_Width-1,d2
	bgt.b	.clipright

	moveq	#-1,d4	;drawit
	rts
.dontdraw:	moveq	#0,d4	;dontdrawit
	rts
.dontdraw2:	moveq	#0,d4
	move.w	#Screen_Width-1,d0
	move.w	#Screen_Width-1,d2
	rts

.clipright:	move.w	#Screen_Width-1,d4
	sub.w	d0,d4	;skal ns
	sub.w	d0,d2	;er nu
	move.w	d3,Clip_LineY1
	sub.w	d1,d3
	muls	d4,d3
	divs	d2,d3
	add.w	d1,d3
	move.w	d3,Clip_LineY2
	move.w	#-1,Clip_Mark
	move.w	#Screen_Width-1,d2
	bra.b	.tryagain

.clipleft:		;skal ns=d2
	sub.w	d2,d0
	neg.w	d0	;er nu
	sub.w	d3,d1
	muls	d2,d1
	divs	d0,d1
	add.w	d3,d1
	moveq	#0,d0
	bra.w	.tryagain

.clipdown:	move.w	#Screen_Height-1,d4
	sub.w	d1,d4	;skal ns
	sub.w	d1,d3	;er nu
	sub.w	d0,d2
	muls	d4,d2
	divs	d3,d2
	add.w	d0,d2
	move.w	#Screen_Height-1,d3
	bra.w	.tryagain

.clipup:		;skal ns=d3
	sub.w	d3,d1
	neg.w	d1	;er nu
	sub.w	d2,d0
	muls	d3,d0
	divs	d1,d0
	add.w	d2,d0
	moveq	#0,d1
	bra.w	.tryagain









*******************************************************************************
**Move object
*******************************************************************************
StartPosX:	EQU	9000
StartPosY:	EQU	-3000
StartPosZ:	EQU	30000

StopPosX:	EQU	-3500
StopPosY:	EQU	1500
StopPosZ:	EQU	2000

MovePause:	dc.w	10

MoveObject:	lea	XAdd(pc),a0
	lea	XAngle(pc),a1
	moveq	#3-1,d1
.loop:	move.w	(a0)+,d0
	add.w	d0,(a1)
	and.w	#1024-1,(a1)+
	dbra	d1,.loop

	rts


XAdd:	dc.w	6
YAdd:	dc.w	3
ZAdd:	dc.w	4

XAngle:	dc.w	0
YAngle:	dc.w	0
ZAngle:	dc.w	0

XCenter:	dc.w	0
YCenter:	dc.w	-1000
ZCenter:	dc.w	32200

MoveNumber:	dc.w	0

FaceColors:	blk.w	30,0











*******************************************************************************
**Clear Screen
*******************************************************************************
ClrScr:
	lea	MinX1+48(pc),a1
	lea	MinX1+72(pc),a2
	moveq	#12-1,d0
.moveloop:	move.l	-(a1),-(a2)
	dbra	d0,.moveloop

	lea	MinX1(pc),a0
	move.l	#$7fff7fff,d0
	move.l	#$80008000,d1
	move.l	d0,(a0)+
	move.l	d1,(a0)+
	move.l	d0,(a0)+
	move.l	d1,(a0)+
	move.l	d0,(a0)+
	move.l	d1,(a0)+

	lea	_Custom,a6

	move.w	MinY1+48(pc),d0
	cmp.w	#$7fff,d0
	beq.w	.bpl2
	muls	#ByteWidth,d0
	move.l	d0,a0
	move.w	MinX1+48(pc),d1
	lsr.w	#3,d1
	and.w	#$fffe,d1
	add.w	d1,a0
	add.l	Screen(pc),a0	;Pointer
	move.w	MaxX1+48(pc),d0
	lsr.w	#3,d0
	and.w	#$fffe,d0
	move.w	#ByteWidth-2,d2
	sub.w	d0,d2
	add.w	d1,d2
	move.w	d2,d3
	swap	d3
	move.w	d2,d3	;modulo
	move.w	MaxY1+48(pc),d2
	sub.w	MinY1+48(pc),d2
	addq.w	#1,d2
	lsl.w	#6,d2
	sub.w	d1,d0
	lsr.w	#1,d0
	addq.w	#1,d0
	or.w	d0,d2	;bltsize

	move.l	a0,d0
	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d0,(a6)+
	swap	d0
	move.w	#Bltdpth,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdmod,(a6)+
	move.w	d3,(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	#$0100,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	#$0000,(a6)+
	move.w	#Bltsize,(a6)+
	move.w	d2,(a6)+
	move.l	a6,BltCopPtr

.bpl2:
	move.w	MinY2+48(pc),d0
	cmp.w	#$7fff,d0
	beq.w	.bpl3
	muls	#ByteWidth,d0
	move.l	d0,a0
	move.w	MinX2+48(pc),d1
	lsr.w	#3,d1
	and.w	#$fffe,d1
	add.w	d1,a0
	add.l	Screen(pc),a0
	add.w	#ByteWidth/2,a0	;Pointer
	move.w	MaxX2+48(pc),d0
	lsr.w	#3,d0
	and.w	#$fffe,d0
	move.w	#ByteWidth-2,d2
	sub.w	d0,d2
	add.w	d1,d2
	move.w	d2,d3
	swap	d3
	move.w	d2,d3	;modulo
	move.w	MaxY2+48(pc),d2
	sub.w	MinY2+48(pc),d2
	addq.w	#1,d2
	lsl.w	#6,d2
	sub.w	d1,d0
	lsr.w	#1,d0
	addq.w	#1,d0
	or.w	d0,d2	;bltsize

	move.l	a0,d0
	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d0,(a6)+
	swap	d0
	move.w	#Bltdpth,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdmod,(a6)+
	move.w	d3,(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	#$0100,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	#$0000,(a6)+
	move.w	#Bltsize,(a6)+
	move.w	d2,(a6)+
	move.l	a6,BltCopPtr

.bpl3:
	rts







*******************************************************************************
**Tabeller
*******************************************************************************
SinusTabel:
;Option n  = 1
;Min. y-val = -3.27680E+04
;Max. y-val =  3.27670E+04
;Startvalue = min
;Length     = 1024
	dc.w	-1,201,402,603,804,1005,1206,1406,1607,1808,2009,2209,2410,2610,2811,3011
	dc.w	3211,3411,3611,3811,4011,4210,4409,4609,4807,5006,5205,5403,5601,5799,5997,6195
	dc.w	6392,6589,6786,6983,7179,7375,7571,7766,7961,8156,8351,8545,8739,8933,9126,9319
	dc.w	9511,9704,9895,10087,10278,10469,10659,10849,11039,11228,11416,11605,11792,11980,12167,12353
	dc.w	12539,12725,12910,13094,13278,13462,13645,13827,14009,14191,14372,14552,14732,14911,15090,15268
	dc.w	15446,15623,15799,15975,16151,16325,16499,16673,16845,17017,17189,17360,17530,17700,17868,18037
	dc.w	18204,18371,18537,18703,18867,19031,19195,19357,19519,19680,19841,20000,20159,20317,20475,20631
	dc.w	20787,20942,21096,21250,21402,21554,21705,21855,22005,22153,22301,22448,22594,22739,22884,23027
	dc.w	23170,23311,23452,23592,23731,23869,24007,24143,24279,24413,24547,24680,24811,24942,25072,25201
	dc.w	25329,25456,25582,25707,25832,25955,26077,26198,26319,26438,26556,26673,26790,26905,27019,27132
	dc.w	27245,27356,27466,27575,27683,27790,27896,28001,28105,28208,28310,28410,28510,28609,28706,28803
	dc.w	28898,28992,29085,29177,29268,29358,29447,29534,29621,29706,29791,29874,29956,30037,30117,30195
	dc.w	30273,30349,30424,30498,30571,30643,30714,30783,30852,30919,30985,31050,31113,31176,31237,31297
	dc.w	31356,31414,31470,31526,31580,31633,31685,31736,31785,31833,31880,31926,31971,32014,32057,32098
	dc.w	32137,32176,32213,32250,32285,32318,32351,32382,32412,32441,32469,32495,32521,32545,32567,32589
	dc.w	32609,32628,32646,32663,32678,32692,32705,32717,32728,32737,32745,32752,32757,32761,32765,32766

CosinusTabel:
;Option n  = 1
;Min. y-val = -3.27680E+04
;Max. y-val =  3.27670E+04
;Startvalue = max
;Length     = 1024
	dc.w	32767,32766,32765,32761,32757,32752,32745,32737,32728,32717,32705,32692,32678,32663,32646,32628
	dc.w	32609,32589,32567,32545,32521,32495,32469,32441,32412,32382,32351,32318,32285,32250,32213,32176
	dc.w	32137,32098,32057,32014,31971,31926,31880,31833,31785,31736,31685,31633,31580,31526,31470,31414
	dc.w	31356,31297,31237,31176,31113,31050,30985,30919,30852,30783,30714,30643,30571,30498,30424,30349
	dc.w	30273,30195,30117,30037,29956,29874,29791,29706,29621,29534,29447,29358,29268,29177,29085,28992
	dc.w	28898,28803,28706,28609,28510,28410,28310,28208,28105,28001,27896,27790,27683,27575,27466,27356
	dc.w	27245,27132,27019,26905,26790,26673,26556,26438,26319,26198,26077,25955,25832,25707,25582,25456
	dc.w	25329,25201,25072,24942,24811,24680,24547,24413,24279,24143,24007,23869,23731,23592,23452,23311
	dc.w	23170,23027,22884,22739,22594,22448,22301,22153,22005,21855,21705,21554,21402,21250,21096,20942
	dc.w	20787,20631,20475,20317,20159,20000,19841,19680,19519,19357,19195,19031,18867,18703,18537,18371
	dc.w	18204,18037,17868,17700,17530,17360,17189,17017,16845,16673,16499,16325,16151,15975,15799,15623
	dc.w	15446,15268,15090,14911,14732,14552,14372,14191,14009,13827,13645,13462,13278,13094,12910,12725
	dc.w	12539,12353,12167,11980,11792,11605,11416,11228,11039,10849,10659,10469,10278,10087,9895,9704
	dc.w	9511,9319,9126,8933,8739,8545,8351,8156,7961,7766,7571,7375,7179,6983,6786,6589
	dc.w	6392,6195,5997,5799,5601,5403,5205,5006,4807,4609,4409,4210,4011,3811,3611,3411
	dc.w	3211,3011,2811,2610,2410,2209,2009,1808,1607,1406,1206,1005,804,603,402,201
	dc.w	-1,-202,-403,-604,-805,-1006,-1207,-1407,-1608,-1809,-2010,-2210,-2411,-2611,-2812,-3012
	dc.w	-3212,-3412,-3612,-3812,-4012,-4211,-4410,-4610,-4808,-5007,-5206,-5404,-5602,-5800,-5998,-6196
	dc.w	-6393,-6590,-6787,-6984,-7180,-7376,-7572,-7767,-7962,-8157,-8352,-8546,-8740,-8934,-9127,-9320
	dc.w	-9512,-9705,-9896,-10088,-10279,-10470,-10660,-10850,-11040,-11229,-11417,-11606,-11793,-11981,-12168,-12354
	dc.w	-12540,-12726,-12911,-13095,-13279,-13463,-13646,-13828,-14010,-14192,-14373,-14553,-14733,-14912,-15091,-15269
	dc.w	-15447,-15624,-15800,-15976,-16152,-16326,-16500,-16674,-16846,-17018,-17190,-17361,-17531,-17701,-17869,-18038
	dc.w	-18205,-18372,-18538,-18704,-18868,-19032,-19196,-19358,-19520,-19681,-19842,-20001,-20160,-20318,-20476,-20632
	dc.w	-20788,-20943,-21097,-21251,-21403,-21555,-21706,-21856,-22006,-22154,-22302,-22449,-22595,-22740,-22885,-23028
	dc.w	-23171,-23312,-23453,-23593,-23732,-23870,-24008,-24144,-24280,-24414,-24548,-24681,-24812,-24943,-25073,-25202
	dc.w	-25330,-25457,-25583,-25708,-25833,-25956,-26078,-26199,-26320,-26439,-26557,-26674,-26791,-26906,-27020,-27133
	dc.w	-27246,-27357,-27467,-27576,-27684,-27791,-27897,-28002,-28106,-28209,-28311,-28411,-28511,-28610,-28707,-28804
	dc.w	-28899,-28993,-29086,-29178,-29269,-29359,-29448,-29535,-29622,-29707,-29792,-29875,-29957,-30038,-30118,-30196
	dc.w	-30274,-30350,-30425,-30499,-30572,-30644,-30715,-30784,-30853,-30920,-30986,-31051,-31114,-31177,-31238,-31298
	dc.w	-31357,-31415,-31471,-31527,-31581,-31634,-31686,-31737,-31786,-31834,-31881,-31927,-31972,-32015,-32058,-32099
	dc.w	-32138,-32177,-32214,-32251,-32286,-32319,-32352,-32383,-32413,-32442,-32470,-32496,-32522,-32546,-32568,-32590
	dc.w	-32610,-32629,-32647,-32664,-32679,-32693,-32706,-32718,-32729,-32738,-32746,-32753,-32758,-32762,-32766,-32767
	dc.w	-32768,-32767,-32766,-32762,-32758,-32753,-32746,-32738,-32729,-32718,-32706,-32693,-32679,-32664,-32647,-32629
	dc.w	-32610,-32590,-32568,-32546,-32522,-32496,-32470,-32442,-32413,-32383,-32352,-32319,-32286,-32251,-32214,-32177
	dc.w	-32138,-32099,-32058,-32015,-31972,-31927,-31881,-31834,-31786,-31737,-31686,-31634,-31581,-31527,-31471,-31415
	dc.w	-31357,-31298,-31238,-31177,-31114,-31051,-30986,-30920,-30853,-30784,-30715,-30644,-30572,-30499,-30425,-30350
	dc.w	-30274,-30196,-30118,-30038,-29957,-29875,-29792,-29707,-29622,-29535,-29448,-29359,-29269,-29178,-29086,-28993
	dc.w	-28899,-28804,-28707,-28610,-28511,-28411,-28311,-28209,-28106,-28002,-27897,-27791,-27684,-27576,-27467,-27357
	dc.w	-27246,-27133,-27020,-26906,-26791,-26674,-26557,-26439,-26320,-26199,-26078,-25956,-25833,-25708,-25583,-25457
	dc.w	-25330,-25202,-25073,-24943,-24812,-24681,-24548,-24414,-24280,-24144,-24008,-23870,-23732,-23593,-23453,-23312
	dc.w	-23171,-23028,-22885,-22740,-22595,-22449,-22302,-22154,-22006,-21856,-21706,-21555,-21403,-21251,-21097,-20943
	dc.w	-20788,-20632,-20476,-20318,-20160,-20001,-19842,-19681,-19520,-19358,-19196,-19032,-18868,-18704,-18538,-18372
	dc.w	-18205,-18038,-17869,-17701,-17531,-17361,-17190,-17018,-16846,-16674,-16500,-16326,-16152,-15976,-15800,-15624
	dc.w	-15447,-15269,-15091,-14912,-14733,-14553,-14373,-14192,-14010,-13828,-13646,-13463,-13279,-13095,-12911,-12726
	dc.w	-12540,-12354,-12168,-11981,-11793,-11606,-11417,-11229,-11040,-10850,-10660,-10470,-10279,-10088,-9896,-9705
	dc.w	-9512,-9320,-9127,-8934,-8740,-8546,-8352,-8157,-7962,-7767,-7572,-7376,-7180,-6984,-6787,-6590
	dc.w	-6393,-6196,-5998,-5800,-5603,-5404,-5206,-5007,-4809,-4610,-4410,-4211,-4012,-3812,-3612,-3412
	dc.w	-3212,-3012,-2812,-2612,-2411,-2210,-2010,-1809,-1608,-1407,-1207,-1006,-805,-604,-403,-202
	dc.w	-1,201,402,603,804,1005,1206,1406,1607,1808,2009,2209,2410,2610,2811,3011
	dc.w	3211,3411,3611,3811,4011,4210,4409,4609,4807,5006,5205,5403,5601,5799,5997,6195
	dc.w	6392,6589,6786,6983,7179,7375,7571,7766,7961,8156,8351,8545,8739,8933,9126,9319
	dc.w	9511,9704,9895,10087,10278,10469,10659,10849,11039,11228,11416,11605,11792,11980,12167,12353
	dc.w	12539,12725,12910,13094,13278,13462,13645,13827,14009,14191,14372,14552,14732,14911,15090,15268
	dc.w	15446,15623,15799,15975,16151,16325,16499,16673,16845,17017,17189,17360,17530,17700,17868,18037
	dc.w	18204,18371,18537,18703,18867,19031,19195,19357,19519,19680,19841,20000,20159,20317,20475,20631
	dc.w	20787,20942,21096,21250,21402,21554,21705,21855,22005,22153,22301,22448,22594,22739,22884,23027
	dc.w	23170,23311,23452,23592,23731,23869,24007,24143,24279,24413,24547,24680,24811,24942,25072,25201
	dc.w	25329,25456,25582,25707,25832,25955,26077,26198,26319,26438,26556,26673,26790,26905,27019,27132
	dc.w	27245,27356,27466,27575,27683,27790,27896,28001,28105,28208,28310,28410,28510,28609,28706,28803
	dc.w	28898,28992,29085,29177,29268,29358,29447,29534,29621,29706,29791,29874,29956,30037,30117,30195
	dc.w	30273,30349,30424,30498,30571,30643,30714,30783,30852,30919,30985,31050,31113,31176,31237,31297
	dc.w	31356,31414,31470,31526,31580,31633,31685,31736,31785,31833,31880,31926,31971,32014,32057,32098
	dc.w	32137,32176,32213,32250,32285,32318,32351,32382,32412,32441,32469,32495,32521,32545,32567,32589
	dc.w	32609,32628,32646,32663,32678,32692,32705,32717,32728,32737,32745,32752,32757,32761,32765,32766














*******************************************************************************
**Og den vildeste copperliste...
*******************************************************************************
	SECTION	Copper,data_c
SunCopper:	dc.w	$1001,$fffe

	dc.w	Diwstrt,$1c71
	dc.w	Bplcon0,$0200
	dc.w	Bplcon2,$0024
	dc.w	Bplcon3,$0c40
	dc.w	Diwstop,$3cd1
	dc.w	Ddfstrt,$0030
	dc.w	Ddfstop,$00d8
	dc.w	Bplcon1,$0000
	dc.w	Bpl1mod,0
	dc.w	Bpl2mod,0

	dc.w	Spr0pth,0,Spr0ptl,0
	dc.w	Spr1pth,0,Spr1ptl,0
	dc.w	Spr2pth,0,Spr2ptl,0
	dc.w	Spr3pth,0,Spr3ptl,0
	dc.w	Spr4pth,0,Spr4ptl,0
	dc.w	Spr5pth,0,Spr5ptl,0
	dc.w	Spr6pth,0,Spr6ptl,0
	dc.w	Spr7pth,0,Spr7ptl,0

	dc.w	$106,$0c40

FadeCopper:	dc.w	Color00,$000	;000
	dc.w	Color01,$000	;001

	dc.l	-2
	dc.l	-2



BlackCopper:	dc.w	$1001,$fffe

	dc.w	Diwstrt,$1c71
	dc.w	Bplcon0,$0200
	dc.w	Bplcon2,$0024
	dc.w	Bplcon3,$0c40
	dc.w	Diwstop,$3cd1
	dc.w	Ddfstrt,$0030
	dc.w	Ddfstop,$00d8
	dc.w	Bplcon1,$0000
	dc.w	Bpl1mod,0
	dc.w	Bpl2mod,0

	dc.w	Spr0pth,0,Spr0ptl,0
	dc.w	Spr1pth,0,Spr1ptl,0
	dc.w	Spr2pth,0,Spr2ptl,0
	dc.w	Spr3pth,0,Spr3ptl,0
	dc.w	Spr4pth,0,Spr4ptl,0
	dc.w	Spr5pth,0,Spr5ptl,0
	dc.w	Spr6pth,0,Spr6ptl,0
	dc.w	Spr7pth,0,Spr7ptl,0

Copper_PlanePtr2:	dc.w	Bpl1pth,0,Bpl1ptl,0

	dc.w	$106,$0c40

	dc.w	Color00,BckCol	;000
	dc.w	Color01,$fff	;001

	IFEQ	AGA-1
	dc.w	$106,$0e40

	dc.w	Color00,$000	;000
	dc.w	Color01,$000	;001
	ENDC

	dc.l	-2
	dc.l	-2



Copper:	dc.w	$1001,$fffe

	dc.w	Diwstrt,$1c71
	dc.w	Diwstop,$3cd1
	dc.w	Ddfstrt,$0030
	dc.w	Ddfstop,$00d8

	dc.w	Spr0pth,$0000,Spr0ptl,$0000
	dc.w	Spr1pth,$0000,Spr1ptl,$0000
	dc.w	Spr2pth,$0000,Spr2ptl,$0000
	dc.w	Spr3pth,$0000,Spr3ptl,$0000
	dc.w	Spr4pth,$0000,Spr4ptl,$0000
	dc.w	Spr5pth,$0000,Spr5ptl,$0000
	dc.w	Spr6pth,$0000,Spr6ptl,$0000
	dc.w	Spr7pth,$0000,Spr7ptl,$0000

	dc.w	Bpl1mod,ByteWidth-44
	dc.w	Bpl2mod,ByteWidth-44

	dc.w	$100,$201
	dc.w	$106,$0c40

CopColors:	dc.w	Color00,BckCol	;000
	dc.w	Color01,BckCol	;001
	dc.w	Color02,TandCol	;010
	dc.w	Color03,TandCol	;011
	dc.w	Color04,BckCol	;100
	dc.w	Color05,BckCol	;101
	dc.w	Color06,TandCol	;110
	dc.w	Color07,TandCol	;111

Bitplaner:	dc.w	Bpl1pth,0
	dc.w	Bpl1ptl,0
	dc.w	Bpl2pth,0
	dc.w	Bpl2ptl,0

	dc.w	Bplcon0,$2201
	dc.w	Bplcon1,$0000
	dc.w	Bplcon2,$0024

	dc.w	$106,$0c40

Bltpointer:	dc.w	Cop2lch,0
	dc.w	Cop2lcl,0
	dc.w	Copjmp2,$1992


ScrollCopper:	dc.w	$b001,$fffe
	dc.w	Bplcon0,$0200
	dc.w	Bpl1mod,80-44
	dc.w	Color01,$535
ScrollPointer:	dc.w	Bpl1pth,0,Bpl1ptl,0
	dc.w	$b101,$fffe
	dc.w	Bplcon0,$1200
	dc.w	$c201,$fffe
	dc.w	Bplcon0,$0200
	dc.l	-2
	dc.l	-2



*******************************************************************************
**Screens+Gfx
*******************************************************************************
	INCDIR	"Work:Code/Sources/HTSAC/"
ScrollGfx:	INCBIN	"Presented.raw640*17"
	blk.b	80,0


	SECTION	Gfx,bss_c
Clear:
Screen1:	ds.b	288*44*2
Screen2:	ds.b	288*44*2

BltCopper1:	ds.l	2000
BltCopper2:	ds.l	2000

TheEnd:







	IF	Track=0
	PRINTT	`ASM-ONE VERSION`
	ELSE
	PRINTT	`TRACK VERSION`
	ENDC
	PRINTT

*******************************************************************************
**Hardware registers
*******************************************************************************
Bltddat=$000
Dmaconr=$002
Vposr=$004
Vhposr=$006
Dskdatr=$008
Joy0dat=$00a
Joy1dat=$00c
Clxdat=$00e
Adkconr=$010
Pot0dat=$012
Pot1dat=$014
Potgor=$016
Serdatr=$018
Dskbytr=$01a
Intenar=$01c
Intreqr=$01e
Dskpth=$020
Dskptl=$022
Dsklen=$024
Dskdat=$026
Refptr=$028
Vposw=$02a
Vhposw=$02c
Copcon=$02e
Serdat=$030
Serper=$032
Potgo=$034
Joytest=$036
Strequ=$038
Strvbl=$03a
Strhor=$03c
Strlong=$03e
Bltcon0=$040
Bltcon1=$042
Bltafwm=$044
Bltalwm=$046
Bltcpth=$048
Bltcptl=$04a
Bltbpth=$04c
Bltbptl=$04e
Bltapth=$050
Bltaptl=$052
Bltdpth=$054
Bltdptl=$056
Bltsize=$058
Bltcmod=$060
Bltbmod=$062
Bltamod=$064
Bltdmod=$066
Bltcdat=$070
Bltbdat=$072
Bltadat=$074
Dsksync=$07e
Cop1lch=$080
Cop1lcl=$082
Cop2lch=$084
Cop2lcl=$086
Copjmp1=$088
Copjmp2=$08a
Copins=$08c
Diwstrt=$08e
Diwstop=$090
Ddfstrt=$092
Ddfstop=$094
Dmacon=$096
Clxcon=$98
Intena=$09a
Intreq=$09c
Adkcon=$09e
Aud0dat=$0aa
Aud1dat=$0ba
Aud2dat=$0ca
Aud3dat=$0da
Aud0lch=$0a0
Aud1lch=$0b0
Aud2lch=$0c0
Aud3lch=$0d0
Aud0len=$0a4
Aud1len=$0b4
Aud2len=$0c4
Aud3len=$0d4
Aud0per=$0a6
Aud1per=$0b6
Aud2per=$0c6
Aud3per=$0d6
Aud0vol=$0a8
Aud1vol=$0b8
Aud2vol=$0c8
Aud3vol=$0d8
Aud0lcl=$0a2
Aud1lcl=$0b2
Aud2lcl=$0c2
Aud3lcl=$0d2
Bpl1pth=$0e0
Bpl1ptl=$0e2
Bpl2pth=$0e4
Bpl2ptl=$0e6
Bpl3pth=$0e8
Bpl3ptl=$0ea
Bpl4pth=$0ec
Bpl4ptl=$0ee
Bpl5pth=$0f0
Bpl5ptl=$0f2
Bpl6pth=$0f4
Bpl6ptl=$0f6
Bplcon0=$100
Bplcon1=$102
Bplcon2=$104
Bplcon3=$106
Bpl1mod=$108
Bpl2mod=$10a
Bpl1dat=$110
Bpl2dat=$112
Bpl3dat=$114
Bpl4dat=$116
Bpl5dat=$118
Bpl6dat=$11a
Spr0pth=$120
Spr0ptl=$122
Spr1pth=$124
Spr1ptl=$126
Spr2pth=$128
Spr2ptl=$12a
Spr3pth=$12c
Spr3ptl=$12e
Spr4pth=$130
Spr4ptl=$132
Spr5pth=$134
Spr5ptl=$136
Spr6pth=$138
Spr6ptl=$13a
Spr7pth=$13c
Spr7ptl=$13e
Spr0pos=$140
Spr0ctl=$142
Spr0data=$144
Spr0datb=$146
Spr1pos=$148
Spr1ctl=$14a
Spr1data=$14c
Spr1datb=$14e
Spr2pos=$150
Spr2ctl=$152
Spr2data=$154
Spr2datb=$156
Spr3pos=$158
Spr3ctl=$15a
Spr3data=$15c
Spr3datb=$15e
Spr4pos=$160
Spr4ctl=$162
Spr4data=$164
Spr4datb=$166
Spr5pos=$168
Spr5ctl=$16a
Spr5data=$16c
Spr5datb=$16e
Spr6pos=$170
Spr6ctl=$172
Spr6data=$174
Spr6datb=$176
Spr7pos=$178
Spr7ctl=$17a
Spr7data=$17c
Spr7datb=$17e
Color00=$180
Color01=$182
Color02=$184
Color03=$186
Color04=$188
Color05=$18a
Color06=$18c
Color07=$18e
Color08=$190
Color09=$192
Color10=$194
Color11=$196
Color12=$198
Color13=$19a
Color14=$19c
Color15=$19e
Color16=$1a0
Color17=$1a2
Color18=$1a4
Color19=$1a6
Color20=$1a8
Color21=$1aa
Color22=$1ac
Color23=$1ae
Color24=$1b0
Color25=$1b2
Color26=$1b4
Color27=$1b6
Color28=$1b8
Color29=$1ba
Color30=$1bc
Color31=$1be
_Custom=$dff000

*******************************************************************************
**Interrupt addresses
*******************************************************************************
Lev1Base=$64
Lev2Base=$68
Lev3Base=$6c
Lev4Base=$70
Lev5Base=$74
Lev6Base=$78
Lev7Base=$7c
Trap0=$80

