  ;------------------T--------T
Track:	EQU	0
NoOfRings:	EQU	40	;40 A1200
			;30 A500
YSpace:	EQU	32
Raster:	EQU	0


MyDmacon=%01111100000
;         abcdefghhhh
; a = Blitter nasty
; b = Enable DMA activity (always set this!)
; c = Bitplane enable
; d = Copper enable
; e = Blitter enable
; f = Sprite enable
; g = Disk enable
; h = Audio channels enable

MyIntena=%100000000100000
;         abcdeeeefghijkl
; a = Enable interrupts
; b = Lev. 6 External interrupt
; c = Lev. 5 Disk sync found
; d = Lev. 5 Serial port receive buffer full
; e = Lev. 4 Audio ch. 3-0 block finished
; f = Lev. 3 Blitter finished
; g = Lev. 3 Vertical blank
; h = Lev. 3 Copper
; i = Lev. 2 I/O Ports and timers
; j = Lev. 1 Software
; k = Lev. 1 Disk block finished
; l = Lev. 1 Serial port transmit buffer empty

	JumpPtr	Begin

*******************************************************************************
**Macros
*******************************************************************************
WaitBlt:	MACRO
.vent\@:	if	Raster=1
	move.w	#$fff,Color00+_Custom
	endif
	btst	#14,Dmaconr+_Custom
	bne.b	.vent\@
	if	Raster=1
	move.w	#0,Color00+_Custom
	endif
	ENDM

SetInt:	MACRO
	move.l	(Lev\1Base).w,OldIrq\1
	move.l	#Lev\1Irq,(Lev\1Base).w
	bra.b	jumpo\@
OldIrq\1:	dc.l	0
jumpo\@:
	ENDM

ClrInt:	MACRO
	move.l	OldIrq\1(pc),(Lev\1Base).w
	ENDM

Push.l:	MACRO
	movem.l	\1,-(sp)
	ENDM

Push.w:	MACRO
	movem.w	\1,-(sp)
	ENDM

Pull.l:	MACRO
	movem.l	(sp)+,\1
	ENDM

Pull.w:	MACRO
	movem.w	(sp)+,\1
	ENDM

StartPrg:	MACRO
	move.w	#$7fff,Intreq+_Custom
	move.w	#MyDmacon+$8000,Dmacon+_Custom
	move.w	#MyIntena+$8000,Intena+_Custom
	ENDM

StopPrg:	MACRO
	move.w	#$7fff,Intena+_Custom
	move.w	#$7fff,Dmacon+_Custom
	move.w	#$7fff,Intreq+_Custom
	ENDM

StopSystem:	MACRO
	move.w	Intenar+_Custom,OldIntena
	move.w	Dmaconr+_Custom,OldDmacon
	StopPrg
	bra.b	jumpo\@
OldIntena:	dc.w	0
OldDmacon:	dc.w	0
jumpo\@:
	ENDM

StartSystem:	MACRO
	move.w	OldDmacon(pc),d0
	or.w	#$8000,d0
	move.w	d0,Dmacon+_Custom
	move.w	OldIntena(pc),d0
	or.w	#$8000,d0
	move.w	d0,Intena+_Custom
	ENDM

ClearBss:	MACRO
	lea	_Bss1Start,a0
	move.l	#(_Bss1End-_Bss1Start)/4,d0
.clrloop\@	clr.l	(a0)+
	subq.l	#1,d0
	bne.b	.clrloop\@
	ENDM




*******************************************************************************
**
**  Initialisering
**
*******************************************************************************
	SECTION	DenFedeKode,code

Begin:	IFEQ	Track-0
	Push.l	d0-a6
	StopSystem
	ELSE
	move.l	#Lev3Irq,$64.w
	rts
	ENDC

**Init starter -----------------------------------
	ClearBss	1
	ClearBss	2

	bsr	ComputeColors
	bsr	InitAGACopper
	lea	ColorArray,a0
	lea	AGA_Colors,a1
	moveq	#0,d0
	moveq	#7,d1
	bsr	LoadAGACopper
	bsr	Init_Rings
	bsr	InitPerspTable
	bsr	InitCodeBuffer

	IFEQ	Track-0
	clr.l	0.w
	SetInt	3
**Init slutter -----------------------------------
	WaitBlt
	StartPrg



*******************************************************************************
**
**  Vent p exitsignal
**
*******************************************************************************
WaitForExit:	tst.b	VBlank
	beq.b	WaitForExit

	clr.b	VBlank
	tst.b	IWantOut
	bne.b	ExitToDos
	bra.b	WaitForExit




*******************************************************************************
**
**  Exit to AmigaDOS
**
*******************************************************************************
ExitToDos:
	StopPrg

**Exit starter -----------------------------------
	move.w	#0,Copcon+_Custom
	ClrInt	3
**Exit slutter -----------------------------------

	StartSystem

	Pull.l	d0-a6
	moveq	#0,d0
	ENDC
	rts



*******************************************************************************
**
**  Level 3 interrupt
**
*******************************************************************************
Lev3Irq:	st	VBlank
	push.l	d0-a6
**Lev3irq starter --------------------------------
	move.l	#Copper,Cop2lch+_Custom
	move.w	#%10,Copcon+_Custom
	move.w	d0,Copjmp2+_Custom

	lea	Routines(pc),a0
	move.w	Status(pc),d0
	add.w	d0,d0
	add.w	d0,d0
	move.l	(a0,d0.w),a0
	jsr	(a0)

**Lev3irq slutter --------------------------------
	IF	Raster=1
	move.w	#$f00,Color00+_Custom
	ENDIF
	IF	Raster=1
	move.w	#$00f,Color00+_Custom
	ENDIF
	move.b	$dff005,d0
	lsl.w	#8,d0
	move.b	$dff006,d0
	cmp.w	MaxRast,d0
	blt.b	.ud
	move.w	d0,MaxRast
.ud:
	pull.l	d0-a6
	IFEQ	Track-0
	move.w	#$0020,Intreq+_Custom
	ELSE
	move.w	#$0004,Intreq+_Custom
	ENDC
	rte

Status:	dc.w	0
Routines:	dc.l	FadeUp,RingHandler,FadeDown

RingHandler:	bsr	SwapScr
	bsr	ClrScr
	bsr	Storyboard
	bsr	Draw_Rings
	bsr	Move_Rings
	rts


*******************************************************************************
**
**  Storyboard
**
*******************************************************************************
Storyboard:	move.w	Story,d0
	beq.b	Story_00
	subq.w	#1,d0
	beq.b	Story_01
	subq.w	#1,d0
	beq.b	Story_02
	rts

Story_00:	addq.w	#2,Ring_Max
	cmp.w	#256,Ring_Max
	bne.b	.not
	addq.w	#1,Story
	move.w	#10*50,Story_Pause
.not	rts

Story_01:	subq.w	#1,Story_Pause
	beq.b	.next
	IFEQ	Track-0
	btst	#6,$bfe001
	beq.b	.next
	ENDC
	rts
.next	addq.w	#1,Story
	rts

Story_02:	addq.w	#2,Ring_Min
	cmp.w	#256,Ring_Min
	bne.b	.out
	addq.w	#1,Status
.out	rts

FadeUp:	move.l	#FadeCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom

	move.w	FadeCopper|.col+2,d0
	move.w	#$312,d1
	bsr	fader
	move.w	d0,FadeCopper|.col+2
	cmp.w	#$312,d0
	bne.b	.out
	addq.w	#1,Status
.out	rts
	
FadeDown:	move.l	#FadeCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom

	move.w	FadeCopper|.col+2,d0
	moveq	#0,d1
	bsr	fader
	move.w	d0,FadeCopper|.col+2
	tst.w	d0
	seq	IWantOut
	rts
	



**d0=fade from
**d1=fade to
**out: d0=newcol
fader:	move.w	d0,d2
	move.w	d1,d3
	lsr.w	#8,d2
	lsr.w	#8,d3
	cmp.w	d2,d3
	beq.b	.nored
	blt.b	.redsub
	add.w	#$100,d0
	bra.b	.nored
.redsub:	sub.w	#$100,d0
.nored:	move.w	d0,d2
	move.w	d1,d3
	lsr.w	#4,d2
	lsr.w	#4,d3
	and.w	#$f,d2
	and.w	#$f,d3
	cmp.w	d2,d3
	beq.b	.nogreen
	blt.b	.greensub
	add.w	#$10,d0
	bra.b	.nogreen
.greensub:	sub.w	#$10,d0
.nogreen:	move.w	d0,d2
	move.w	d1,d3
	and.w	#$f,d2
	and.w	#$f,d3
	cmp.w	d2,d3
	beq.b	.noblue
	blt.b	.bluesub
	addq.w	#$1,d0
	bra.b	.noblue
.bluesub:	subq.w	#$1,d0
.noblue:	rts


*******************************************************************************
**
**  Initialiser PerspTable
**
*******************************************************************************
InitPerspTable:	lea	PerspTable,a0
	move.w	#256-1,d7
.loop	move.w	d7,d0
	mulu	#190,d0
	add.w	#6000,d0
	move.l	#6000*255,d1
	divu	d0,d1
	move.w	d1,(a0)+
	dbra	d7,.loop
	rts




*******************************************************************************
**
**  Draw all rings
**
*******************************************************************************
Draw_Rings:	clr.w	Ring_Counter
.next	lea	Ring_Array,a0
	move.w	Ring_Counter,d0
	mulu	#Ring_SIZEOF,d0
	add.w	d0,a0
	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	move.w	(a0)+,d1
	move.b	(a0)+,d2
	move.b	(a0)+,d0
	cmp.w	Ring_Min,d0
	blt.b	.dont
	cmp.w	Ring_Max,d0
	bgt.b	.dont

	ext.l	d1
	move.w	d0,d3
	not.b	d3
	mulu	#3,d3
	lsr.l	#8,d3
	mulu	#(288+113+YSpace)*80,d3
	add.l	d3,d1

;	lea	PerspTable,a0
;	add.w	d0,d0
;	move.w	(a0,d0.w),d0
	bsr	DrawCircle
.dont	addq.w	#1,Ring_Counter
	cmp.w	#NoOfRings,Ring_Counter
	bne.b	.next
	rts

Move_Rings:	lea	Ring_Array,a0
	moveq	#0,d7
.next	addq.b	#2,3(a0)
	bcs.b	.ooops
	addq.w	#4,a0
.donext	addq.w	#1,d7
	cmp.w	#NoOfRings,d7
		bne.b	.next
	rts
.ooops	bsr	Init_OneRing
	bra.b	.donext


Init_Rings:	lea	Ring_Array,a0
	moveq	#NoOfRings-1,d0		;ringnumber
.next	bsr	Init_OneRing
	move.w	#256,d1
	mulu	d0,d1
	divu	#NoOfRings,d1
	move.b	d1,-1(a0)
	subq.w	#1,d0
	bge.b	.next
	rts

Init_OneRing:	lea	Tunnel_YTab,a1
	add.w	Tunnel_YTabPtr,a1
	move.w	(a1),d2
	lea	Tunnel_XTab,a1
	add.w	Tunnel_XTabPtr,a1
	move.w	(a1),d3
	addq.w	#2,Tunnel_YTabPtr
	and.w	#128-1,Tunnel_YTabPtr
	addq.w	#2,Tunnel_XTabPtr
	and.w	#128-1,Tunnel_XTabPtr
	move.w	d3,d4
	asr.w	#3,d4
	add.w	d4,d2
	and.w	#7,d3
	move.w	d2,(a0)+
	move.b	d3,(a0)+
	addq.w	#1,a0
	rts


**input:
**  d0.w: size
**  d1.l: byteoffset
**  d2.w: bitoffset
DrawCircle:	lea	CodeTable,a0
	add.w	d0,d0
	add.w	d0,d0
	move.l	(a0,d0.w),JumpCode+2
	move.w	#$4000,Intena+_Custom
	move.l	a7,OldSP
	move.l	Screen_Draw,a7
	add.l	d1,a7
	add.w	#144*80+22,a7
	add.w	d2,d2
	add.w	d2,d2
	move.l	_BitJumps(PC,d2.w),a1
	jmp	(a1)

_BitJumps:	dc.l	_Bit0,_Bit1,_Bit2,_Bit3,_Bit4,_Bit5,_Bit6,_Bit7

_Bit0:	move.l	a7,a0
	move.l	a7,a1
	move.l	a7,a2
	move.l	a7,a3
	move.l	a7,a4
	move.l	a7,a5
	move.l	a7,a6
	moveq	#0,d0
	moveq	#1,d1
	moveq	#2,d2
	moveq	#3,d3
	moveq	#4,d4
	moveq	#5,d5
	moveq	#6,d6
	moveq	#7,d7
	jmp	JumpCode
_Bit1:	lea	1(a7),a0
	move.l	a7,a1
	move.l	a7,a2
	move.l	a7,a3
	move.l	a7,a4
	move.l	a7,a5
	move.l	a7,a6
	moveq	#7,d0
	moveq	#0,d1
	moveq	#1,d2
	moveq	#2,d3
	moveq	#3,d4
	moveq	#4,d5
	moveq	#5,d6
	moveq	#6,d7
	jmp	JumpCode
_Bit2:	lea	1(a7),a0
	move.l	a0,a1
	move.l	a7,a2
	move.l	a7,a3
	move.l	a7,a4
	move.l	a7,a5
	move.l	a7,a6
	moveq	#6,d0
	moveq	#7,d1
	moveq	#0,d2
	moveq	#1,d3
	moveq	#2,d4
	moveq	#3,d5
	moveq	#4,d6
	moveq	#5,d7
	jmp	JumpCode
_Bit3:	lea	1(a7),a0
	move.l	a0,a1
	move.l	a0,a2
	move.l	a7,a3
	move.l	a7,a4
	move.l	a7,a5
	move.l	a7,a6
	moveq	#5,d0
	moveq	#6,d1
	moveq	#7,d2
	moveq	#0,d3
	moveq	#1,d4
	moveq	#2,d5
	moveq	#3,d6
	moveq	#4,d7
	jmp	JumpCode
_Bit4:	lea	1(a7),a0
	move.l	a0,a1
	move.l	a0,a2
	move.l	a0,a3
	move.l	a7,a4
	move.l	a7,a5
	move.l	a7,a6
	moveq	#4,d0
	moveq	#5,d1
	moveq	#6,d2
	moveq	#7,d3
	moveq	#0,d4
	moveq	#1,d5
	moveq	#2,d6
	moveq	#3,d7
	jmp	JumpCode
_Bit5:	lea	1(a7),a0
	move.l	a0,a1
	move.l	a0,a2
	move.l	a0,a3
	move.l	a0,a4
	move.l	a7,a5
	move.l	a7,a6
	moveq	#3,d0
	moveq	#4,d1
	moveq	#5,d2
	moveq	#6,d3
	moveq	#7,d4
	moveq	#0,d5
	moveq	#1,d6
	moveq	#2,d7
	jmp	JumpCode
_Bit6:	lea	1(a7),a0
	move.l	a0,a1
	move.l	a0,a2
	move.l	a0,a3
	move.l	a0,a4
	move.l	a0,a5
	move.l	a7,a6
	moveq	#2,d0
	moveq	#3,d1
	moveq	#4,d2
	moveq	#5,d3
	moveq	#6,d4
	moveq	#7,d5
	moveq	#0,d6
	moveq	#1,d7
	jmp	JumpCode
_Bit7:	lea	1(a7),a0
	move.l	a0,a1
	move.l	a0,a2
	move.l	a0,a3
	move.l	a0,a4
	move.l	a0,a5
	move.l	a0,a6
	moveq	#1,d0
	moveq	#2,d1
	moveq	#3,d2
	moveq	#4,d3
	moveq	#5,d4
	moveq	#6,d5
	moveq	#7,d6
	moveq	#0,d7
	jmp	JumpCode

RestoreSP:	move.l	OldSP,a7
	move.w	#$4000!$8000,Intena+_Custom
	rts




*******************************************************************************
**
**  Compute some colors
**
*******************************************************************************
ComputeColors:	lea	ColorArray,a0
	moveq	#0,d0
.exanext	moveq	#0,d1
.testigen	btst	d1,d0
	bne.b	.found
	addq.w	#1,d1
	cmp.w	#3,d1
	bne.b	.testigen
	move.l	#$331122,d2
	bra.b	.gotcolor
.found	add.w	d1,d1
	add.w	d1,d1
	move.l	.colors(PC,d1.w),d2
.gotcolor	move.l	d2,(a0)+
	addq.w	#1,d0
	cmp.w	#8,d0
	bne.b	.exanext
	rts
.colors	dc.l	$ffbbff,$bb77aa,$774466




*******************************************************************************
**
**  Fade 24bit colors
**
**  input:
**  d0.l=source color
**  d1.l=dest color
**  d6.w=step
**  d7.w=last step
**
**  output:
**  d2.l=new color
**
**  trashed regs:
**  d0-d6
**
*******************************************************************************
FadeAGA:	move.l	d0,d2
	move.l	d1,d3
	swap	d2
	swap	d3
	sub.w	d2,d3
	muls	d6,d3
	divs	d7,d3
	add.w	d2,d3
	swap	d3
	clr.w	d3		;R
	move.l	d0,d2
	move.l	d1,d4
	and.w	#$ff00,d2
	and.w	#$ff00,d4
	sub.w	d2,d4
	lsr.w	#8,d4
	muls	d6,d4
	divs	d7,d4
	lsl.w	#8,d4
	add.w	d2,d4
	and.l	#$00ff00,d4	;G
	move.w	d0,d5
	move.w	d1,d2
	and.w	#$00ff,d5
	and.w	#$00ff,d2
	sub.w	d5,d2
	muls	d6,d2
	divs	d7,d2
	add.w	d5,d2
	and.l	#$0000ff,d2	;B
	or.l	d3,d2
	or.l	d4,d2	;color
	rts





*******************************************************************************
**
**  Load AGA copper with colors
**
**  input:
**  a0.l=24bit color array (00000000RRRRRRRRGGGGGGGGBBBBBBBB per color)
**  a1.l=initialized aga copper array
**  d0.w=start color
**  d1.w=end color
**
*******************************************************************************
LoadAGACopper:	moveq	#0,d2	;color index to current bank
	sub.w	d0,d1	;number of colors to load
	move.w	d1,d7	;color countdown
	move.w	d0,d6
	beq.b	.noskip
	add.w	d0,d0
	add.w	d0,d0
	add.w	d0,a0	;skip first colors
	move.w	d6,d0
	lsr.w	#5,d0
	mulu	#33*2*4,d0
	add.w	d0,a1	;skip first banks
	and.w	#$1f,d6
.noskip	addq.w	#4,a1
	clr.w	-(sp)
	lea	(8+1)*4(a1),a2	;lower nibbles
.next	move.l	(a0)+,d0
	move.l	d0,d3
	move.w	d0,d1
	move.l	d0,d2
	and.w	#$000f,d0
	and.w	#$0f00,d1
	lsr.w	#4,d1
	swap	d2
	and.w	#$f,d2
	lsl.w	#8,d2
	or.w	d2,d1
	or.w	d1,d0
	move.w	d0,2(a2)
	move.l	d3,d0
	move.w	d0,d1
	move.l	d0,d2
	and.w	#$f0,d0
	lsr.w	#4,d0
	move.w	d1,(sp)
	move.b	(sp),d1
	and.w	#$00f0,d1
	swap	d2
	and.w	#$00f0,d2
	lsl.w	#4,d2
	or.w	d2,d1
	or.w	d1,d0
	move.w	d0,2(a1)
	addq.w	#4,a1
	addq.w	#4,a2
	subq.w	#1,d7
	blt.b	.out
	addq.w	#1,d6
	cmp.w	#$20,d6
	bne.b	.next
	lea	34*4(a1),a1
	lea	34*4(a2),a2
	moveq	#0,d6
	bra.b	.next
.out	clr.w	(sp)+
	rts

*******************************************************************************
**
**  Init AGA copper-array
**
*******************************************************************************
InitAGACopper:	lea	AGA_Colors,a0
	move.l	#Bplcon3<<16!$0c40,d0
	move.l	#Bplcon3<<16!$0e40,d1
	moveq	#1-1,d7
.loop	move.l	d0,(a0)+
	bsr	.fillit
	move.l	d1,(a0)+
	bsr	.fillit
	add.w	#$2000,d0
	add.w	#$2000,d1
	dbra	d7,.loop
	rts
.fillit	move.w	#Color00,d2
	moveq	#8-1,d6
.fillloop	move.w	d2,(a0)+
	clr.w	(a0)+
	addq.w	#2,d2
	dbra	d6,.fillloop
	rts




*******************************************************************************
**
**  Initialiser CodeBuffer
**
*******************************************************************************
InitCodeBuffer:	lea	CodeBuffer,a0
	lea	SinTable,a1
	lea	CosTable,a2
	lea	CodeTable,a3
	lea	PerspTable,a4
	moveq	#0,d0		;ringsize
	moveq	#0,d1		;angle

.next	move.l	a0,(a3)+
	moveq	#64-1,d7
.loop	moveq	#0,d2
	moveq	#0,d3
	move.w	(a1,d1.w),d2
	move.w	(a2,d1.w),d3
	move.w	d0,d4
	add.w	d4,d4
	move.w	(a4,d4.w),d4
	muls	d4,d2
	muls	d4,d3
	swap	d2
	swap	d3
	rol.l	#2,d2
	rol.l	#2,d3
	muls	#80,d3
	move.w	d2,d4
	asr.w	#3,d4
	add.w	d4,d3		;byteoffset
	bsr	_GetOpcode
	move.w	d4,(a0)+
	move.w	d3,(a0)+
	add.w	#2048/64,d1
	and.w	#2048-1,d1
	dbra	d7,.loop
	move.w	#$4EF9,(a0)+
	move.l	#RestoreSP,(a0)+
	add.w	#2,d1
	and.w	#2048-1,d1
	addq.w	#1,d0
	cmp.w	#64,d0
	bne.b	.next

.next2	move.l	a0,(a3)+
	moveq	#64-1,d7
.loop2	moveq	#0,d2
	moveq	#0,d3
	move.w	(a1,d1.w),d2
	move.w	(a2,d1.w),d3
	move.w	d0,d4
	add.w	d4,d4
	move.w	(a4,d4.w),d4
	muls	d4,d2
	muls	d4,d3
	swap	d2
	swap	d3
	rol.l	#2,d2
	rol.l	#2,d3
	muls	#80,d3
	move.w	d2,d4
	asr.w	#3,d4
	add.w	d4,d3		;byteoffset
	bsr	_GetOpcode
	move.w	d4,(a0)+
	move.w	d3,(a0)+
	move.w	d4,(a0)+
	add.w	#80,d3
	move.w	d3,(a0)+
	add.w	#2048/64,d1
	and.w	#2048-1,d1
	dbra	d7,.loop2
	move.w	#$4EF9,(a0)+
	move.l	#RestoreSP,(a0)+
	add.w	#2,d1
	and.w	#2048-1,d1
	addq.w	#1,d0
	cmp.w	#64*2,d0
	bne.b	.next2

.next3	move.l	a0,(a3)+
	moveq	#64-1,d7
.loop3	moveq	#0,d2
	moveq	#0,d3
	move.w	(a1,d1.w),d2
	move.w	(a2,d1.w),d3
	move.w	d0,d4
	add.w	d4,d4
	move.w	(a4,d4.w),d4
	muls	d4,d2
	muls	d4,d3
	swap	d2
	swap	d3
	rol.l	#2,d2
	rol.l	#2,d3
	push.w	d2/d3
	muls	#80,d3
	move.w	d2,d4
	asr.w	#3,d4
	add.w	d4,d3		;byteoffset
	bsr	_GetOpcode
	move.w	d4,(a0)+
	move.w	d3,(a0)+
	move.w	d4,(a0)+
	add.w	#80,d3
	move.w	d3,(a0)+
	pull.w	d2/d3
	addq.w	#1,d2
	muls	#80,d3
	move.w	d2,d4
	asr.w	#3,d4
	add.w	d4,d3		;byteoffset
	bsr	_GetOpcode
	move.w	d4,(a0)+
	move.w	d3,(a0)+
	add.w	#2048/64,d1
	and.w	#2048-1,d1
	dbra	d7,.loop3
	move.w	#$4EF9,(a0)+
	move.l	#RestoreSP,(a0)+
	add.w	#2,d1
	and.w	#2048-1,d1
	addq.w	#1,d0
	cmp.w	#64*3,d0
	bne.b	.next3

.next4	move.l	a0,(a3)+
	moveq	#64-1,d7
.loop4	moveq	#0,d2
	moveq	#0,d3
	move.w	(a1,d1.w),d2
	move.w	(a2,d1.w),d3
	move.w	d0,d4
	add.w	d4,d4
	move.w	(a4,d4.w),d4
	muls	d4,d2
	muls	d4,d3
	swap	d2
	swap	d3
	rol.l	#2,d2
	rol.l	#2,d3
	push.w	d2/d3
	muls	#80,d3
	move.w	d2,d4
	asr.w	#3,d4
	add.w	d4,d3		;byteoffset
	bsr	_GetOpcode
	move.w	d4,(a0)+
	move.w	d3,(a0)+
	move.w	d4,(a0)+
	add.w	#80,d3
	move.w	d3,(a0)+
	pull.w	d2/d3
	addq.w	#1,d2
	muls	#80,d3
	move.w	d2,d4
	asr.w	#3,d4
	add.w	d4,d3		;byteoffset
	bsr	_GetOpcode
	move.w	d4,(a0)+
	move.w	d3,(a0)+
	move.w	d4,(a0)+
	add.w	#80,d3
	move.w	d3,(a0)+
	add.w	#2048/64,d1
	and.w	#2048-1,d1
	dbra	d7,.loop4
	move.w	#$4EF9,(a0)+
	move.l	#RestoreSP,(a0)+
	add.w	#2,d1
	and.w	#2048-1,d1
	addq.w	#1,d0
	cmp.w	#256,d0
	bne.w	.next4

	rts

**input:
**  d2.w: bitnummer
**output:
**  d4.w: opcode
_GetOpcode:	and.w	#7,d2
	add.w	d2,d2
	add.w	d2,d2
	move.w	_DotCode(PC,d2.w),d4
	rts

_DotCode:	bset	d7,0(a7)
	bset	d6,0(a6)
	bset	d5,0(a5)
	bset	d4,0(a4)
	bset	d3,0(a3)
	bset	d2,0(a2)
	bset	d1,0(a1)
	bset	d0,0(a0)




*******************************************************************************
**
**  Clear screen using blitter
**
*******************************************************************************
ClrScr:	move.l	Screen_Clear,d0
	lea	CopBlit1+2,a0
	bsr.b	.insert
	lea	CopBlit2+2,a0
	bsr.b	.insert
	lea	CopBlit3+2,a0
.insert	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	swap	d0
	add.l	#(288+113+YSpace)*80,d0
	rts



*******************************************************************************
**
**  Swap screen for doublebuffering!
**
*******************************************************************************
SwapScr:	lea	Screen_Clear+3*4,a0
	lea	-4(a0),a1
	move.l	(a1),d7
	moveq	#3-2,d6
.cloop	move.l	-(a1),-(a0)
	dbra	d6,.cloop
	move.l	d7,(a1)

	lea	Copper_PlanePtr+2,a3
	move.l	Screen_Show,d0
	moveq	#3-1,d7
.loop	move.w	d0,4(a3)
	swap	d0
	move.w	d0,(a3)
	swap	d0
	add.l	#(288+113+YSpace)*80,d0
	addq.w	#8,a3
	dbra	d7,.loop
	rts




*******************************************************************************
**
**  Variable
**
*******************************************************************************
	SECTION	VariableTing,bss

	CNOP	0,4
_Bss2Start:
OldSP:	ds.l	1
MaxRast:	ds.w	1
VBlank:	ds.b	1
	IFEQ	Track-0
IWantOut:	ds.b	1
	ELSE
IWantOut:	EQU	$80
	ds.b	1
	ENDC
ColorArray:	ds.l	8
CodeBuffer:	ds.b	64*(4*64*1+6)
	ds.b	64*(4*64*2+6)
	ds.b	64*(4*64*3+6)
	ds.b	64*(4*64*4+6)
_CodeBufferEnd:
CodeTable:	ds.l	256

	RSRESET
Ring_BytePos:	rs.w	1
Ring_BitPos:	rs.b	1
Ring_Size:	rs.b	1
Ring_SIZEOF:	rs.b	0

Ring_Array:	ds.b	NoOfRings*Ring_SIZEOF
Ring_Counter:	ds.w	1
Tunnel_YTabPtr:	ds.w	1
Tunnel_XTabPtr:	ds.w	1
PerspTable:	ds.w	256
Story:	ds.w	1
Ring_Min:	ds.w	1
Ring_Max:	ds.w	1
Story_Pause:	ds.w	1
	CNOP	0,4
_Bss2End:


	SECTION	SjovData,data

Screen_Clear:	dc.l	Screen1
Screen_Draw:	dc.l	Screen2
Screen_Show:	dc.l	Screen3

;Option n  = 1
;Min. y-val = -1.63840E+04
;Max. y-val =  1.63840E+04
;Startvalue = min
;Length     = 1024
SinTable:	dc.w	0,101,201,302,402,503,603,704,804,904,1005,1105,1205,1306,1406,1506
	dc.w	1606,1706,1806,1906,2006,2105,2205,2305,2404,2503,2603,2702,2801,2900,2999,3098
	dc.w	3196,3295,3393,3492,3590,3688,3786,3883,3981,4078,4176,4273,4370,4467,4563,4660
	dc.w	4756,4852,4948,5044,5139,5235,5330,5425,5520,5614,5708,5803,5897,5990,6084,6177
	dc.w	6270,6363,6455,6547,6639,6731,6823,6914,7005,7096,7186,7276,7366,7456,7545,7635
	dc.w	7723,7812,7900,7988,8076,8163,8250,8337,8423,8509,8595,8680,8765,8850,8935,9019
	dc.w	9102,9186,9269,9352,9434,9516,9598,9679,9760,9841,9921,10001,10080,10159,10238,10316
	dc.w	10394,10471,10549,10625,10702,10778,10853,10928,11003,11077,11151,11224,11297,11370,11442,11514
	dc.w	11585,11656,11727,11797,11866,11935,12004,12072,12140,12207,12274,12340,12406,12472,12537,12601
	dc.w	12665,12729,12792,12854,12916,12978,13039,13100,13160,13219,13279,13337,13395,13453,13510,13567
	dc.w	13623,13678,13733,13788,13842,13896,13949,14001,14053,14104,14155,14206,14256,14305,14354,14402
	dc.w	14449,14497,14543,14589,14635,14680,14724,14768,14811,14854,14896,14937,14978,15019,15059,15098
	dc.w	15137,15175,15213,15250,15286,15322,15357,15392,15426,15460,15493,15525,15557,15588,15619,15649
	dc.w	15679,15707,15736,15763,15791,15817,15843,15868,15893,15917,15941,15964,15986,16008,16029,16049
	dc.w	16069,16088,16107,16125,16143,16160,16176,16192,16207,16221,16235,16248,16261,16273,16284,16295
	dc.w	16305,16315,16324,16332,16340,16347,16353,16359,16364,16369,16373,16376,16379,16381,16383,16384
CosTable:	dc.w	16384,16384,16383,16381,16379,16376,16373,16369,16364,16359,16353,16347,16340,16332,16324,16315
	dc.w	16305,16295,16284,16273,16261,16248,16235,16221,16207,16192,16176,16160,16143,16125,16107,16088
	dc.w	16069,16049,16029,16008,15986,15964,15941,15917,15893,15868,15843,15817,15791,15763,15736,15707
	dc.w	15679,15649,15619,15588,15557,15525,15493,15460,15426,15392,15357,15322,15286,15250,15213,15175
	dc.w	15137,15098,15059,15019,14978,14937,14896,14854,14811,14768,14724,14680,14635,14589,14543,14497
	dc.w	14449,14402,14354,14305,14256,14206,14155,14104,14053,14001,13949,13896,13842,13788,13733,13678
	dc.w	13623,13567,13510,13453,13395,13337,13279,13219,13160,13100,13039,12978,12916,12854,12792,12729
	dc.w	12665,12601,12537,12472,12406,12340,12274,12207,12140,12072,12004,11935,11866,11797,11727,11656
	dc.w	11585,11514,11442,11370,11297,11224,11151,11077,11003,10928,10853,10778,10702,10625,10549,10471
	dc.w	10394,10316,10238,10159,10080,10001,9921,9841,9760,9679,9598,9516,9434,9352,9269,9186
	dc.w	9102,9019,8935,8850,8765,8680,8595,8509,8423,8337,8250,8163,8076,7988,7900,7812
	dc.w	7723,7635,7545,7456,7366,7276,7186,7096,7005,6914,6823,6731,6639,6547,6455,6363
	dc.w	6270,6177,6084,5990,5897,5803,5708,5614,5520,5425,5330,5235,5139,5044,4948,4852
	dc.w	4756,4660,4563,4467,4370,4273,4176,4078,3981,3883,3786,3688,3590,3492,3393,3295
	dc.w	3196,3098,2999,2900,2801,2702,2603,2503,2404,2305,2205,2105,2006,1906,1806,1706
	dc.w	1606,1506,1406,1306,1205,1105,1005,904,804,704,603,503,402,302,201,101
	dc.w	0,-101,-201,-302,-402,-503,-603,-703,-804,-904,-1005,-1105,-1205,-1306,-1406,-1506
	dc.w	-1606,-1706,-1806,-1906,-2006,-2105,-2205,-2305,-2404,-2503,-2603,-2702,-2801,-2900,-2999,-3098
	dc.w	-3196,-3295,-3393,-3492,-3590,-3688,-3786,-3883,-3981,-4078,-4176,-4273,-4370,-4467,-4563,-4660
	dc.w	-4756,-4852,-4948,-5044,-5139,-5235,-5330,-5425,-5520,-5614,-5708,-5803,-5897,-5990,-6084,-6177
	dc.w	-6270,-6363,-6455,-6547,-6639,-6731,-6823,-6914,-7005,-7096,-7186,-7276,-7366,-7456,-7545,-7635
	dc.w	-7723,-7812,-7900,-7988,-8076,-8163,-8250,-8337,-8423,-8509,-8595,-8680,-8765,-8850,-8935,-9019
	dc.w	-9102,-9186,-9269,-9352,-9434,-9516,-9598,-9679,-9760,-9840,-9921,-10001,-10080,-10159,-10238,-10316
	dc.w	-10394,-10471,-10549,-10625,-10702,-10778,-10853,-10928,-11003,-11077,-11151,-11224,-11297,-11370,-11442,-11514
	dc.w	-11585,-11656,-11727,-11797,-11866,-11935,-12004,-12072,-12140,-12207,-12274,-12340,-12406,-12472,-12537,-12601
	dc.w	-12665,-12729,-12792,-12854,-12916,-12978,-13039,-13100,-13160,-13219,-13279,-13337,-13395,-13453,-13510,-13567
	dc.w	-13623,-13678,-13733,-13788,-13842,-13896,-13949,-14001,-14053,-14104,-14155,-14206,-14256,-14305,-14354,-14402
	dc.w	-14449,-14497,-14543,-14589,-14635,-14680,-14724,-14768,-14811,-14854,-14896,-14937,-14978,-15019,-15059,-15098
	dc.w	-15137,-15175,-15213,-15250,-15286,-15322,-15357,-15392,-15426,-15460,-15493,-15525,-15557,-15588,-15619,-15649
	dc.w	-15679,-15707,-15736,-15763,-15791,-15817,-15843,-15868,-15893,-15917,-15941,-15964,-15986,-16008,-16029,-16049
	dc.w	-16069,-16088,-16107,-16125,-16143,-16160,-16176,-16192,-16207,-16221,-16235,-16248,-16261,-16273,-16284,-16295
	dc.w	-16305,-16315,-16324,-16332,-16340,-16347,-16353,-16359,-16364,-16369,-16373,-16376,-16379,-16381,-16383,-16384
	dc.w	-16384,-16384,-16383,-16381,-16379,-16376,-16373,-16369,-16364,-16359,-16353,-16347,-16340,-16332,-16324,-16315
	dc.w	-16305,-16295,-16284,-16273,-16261,-16248,-16235,-16221,-16207,-16192,-16176,-16160,-16143,-16125,-16107,-16088
	dc.w	-16069,-16049,-16029,-16008,-15986,-15964,-15941,-15917,-15893,-15868,-15843,-15817,-15791,-15763,-15736,-15707
	dc.w	-15679,-15649,-15619,-15588,-15557,-15525,-15493,-15460,-15426,-15392,-15357,-15322,-15286,-15250,-15213,-15175
	dc.w	-15137,-15098,-15059,-15019,-14978,-14937,-14896,-14854,-14811,-14768,-14724,-14680,-14635,-14589,-14543,-14497
	dc.w	-14449,-14402,-14354,-14305,-14256,-14206,-14155,-14104,-14053,-14001,-13949,-13896,-13842,-13788,-13733,-13678
	dc.w	-13623,-13567,-13510,-13453,-13395,-13337,-13279,-13219,-13160,-13100,-13039,-12978,-12916,-12854,-12792,-12729
	dc.w	-12665,-12601,-12537,-12472,-12406,-12340,-12274,-12207,-12140,-12072,-12004,-11935,-11866,-11797,-11727,-11656
	dc.w	-11585,-11514,-11442,-11370,-11297,-11224,-11151,-11077,-11003,-10928,-10853,-10778,-10702,-10625,-10549,-10471
	dc.w	-10394,-10316,-10238,-10159,-10080,-10001,-9921,-9841,-9760,-9679,-9598,-9516,-9434,-9352,-9269,-9186
	dc.w	-9102,-9019,-8935,-8850,-8765,-8680,-8595,-8509,-8423,-8337,-8250,-8163,-8076,-7988,-7900,-7812
	dc.w	-7723,-7635,-7545,-7456,-7366,-7277,-7186,-7096,-7005,-6914,-6823,-6731,-6639,-6547,-6455,-6363
	dc.w	-6270,-6177,-6084,-5990,-5897,-5803,-5708,-5614,-5520,-5425,-5330,-5235,-5139,-5044,-4948,-4852
	dc.w	-4756,-4660,-4563,-4467,-4370,-4273,-4176,-4078,-3981,-3883,-3786,-3688,-3590,-3492,-3393,-3295
	dc.w	-3196,-3098,-2999,-2900,-2801,-2702,-2603,-2503,-2404,-2305,-2205,-2105,-2006,-1906,-1806,-1706
	dc.w	-1606,-1506,-1406,-1306,-1205,-1105,-1005,-904,-804,-704,-603,-503,-402,-302,-201,-101
	dc.w	0,101,201,302,402,503,603,704,804,904,1005,1105,1205,1306,1406,1506
	dc.w	1606,1706,1806,1906,2006,2105,2205,2305,2404,2503,2603,2702,2801,2900,2999,3098
	dc.w	3196,3295,3393,3492,3590,3688,3786,3883,3981,4078,4176,4273,4370,4467,4563,4660
	dc.w	4756,4852,4948,5044,5139,5235,5330,5425,5520,5614,5708,5803,5897,5990,6084,6177
	dc.w	6270,6363,6455,6547,6639,6731,6823,6914,7005,7096,7186,7276,7366,7456,7545,7635
	dc.w	7723,7812,7900,7988,8076,8163,8250,8337,8423,8509,8595,8680,8765,8850,8935,9019
	dc.w	9102,9186,9269,9352,9434,9516,9598,9679,9760,9841,9921,10001,10080,10159,10238,10316
	dc.w	10394,10471,10549,10625,10702,10778,10853,10928,11003,11077,11151,11224,11297,11370,11442,11514
	dc.w	11585,11656,11727,11797,11866,11935,12004,12072,12140,12207,12274,12340,12406,12472,12537,12601
	dc.w	12665,12729,12792,12854,12916,12978,13039,13100,13160,13219,13279,13337,13395,13453,13510,13567
	dc.w	13623,13678,13733,13788,13842,13896,13949,14001,14053,14104,14155,14206,14256,14305,14354,14402
	dc.w	14449,14497,14543,14589,14635,14680,14724,14768,14811,14854,14896,14937,14978,15019,15059,15098
	dc.w	15137,15175,15213,15250,15286,15322,15357,15392,15426,15460,15493,15525,15557,15588,15619,15649
	dc.w	15679,15707,15736,15763,15791,15817,15843,15868,15893,15917,15941,15964,15986,16008,16029,16049
	dc.w	16069,16088,16107,16125,16143,16160,16176,16192,16207,16221,16235,16248,16261,16273,16284,16295
	dc.w	16305,16315,16324,16332,16340,16347,16353,16359,16364,16369,16373,16376,16379,16381,16383,16384

Tunnel_YTab:	;0,360,64,32,0,w,80,y,n
	DC.W	$0050,$0140,$0230,$0320,$0410,$0500,$05F0,$0690,$0730,$07D0
	DC.W	$0870,$08C0,$0960,$09B0,$09B0,$09B0,$09B0,$09B0,$09B0,$0960
	DC.W	$08C0,$0870,$07D0,$0730,$0690,$05F0,$0500,$0410,$0320,$0230
	DC.W	$0140,$0050,$FFB0,$FEC0,$FDD0,$FCE0,$FBF0,$FB00,$FA10,$F970
	DC.W	$F8D0,$F830,$F790,$F740,$F6A0,$F650,$F650,$F650,$F650,$F650
	DC.W	$F650,$F6A0,$F740,$F790,$F830,$F8D0,$F970,$FA10,$FB00,$FBF0
	DC.W	$FCE0,$FDD0,$FEC0,$FFB0


Tunnel_XTab:	;90,450,64,80,0,w,1,y,n
	DC.W	$004F,$004F,$004D,$004B,$0048,$0044,$0040,$003B,$0035,$002F
	DC.W	$0029,$0022,$001A,$0013,$000B,$0003,$FFFD,$FFF5,$FFED,$FFE6
	DC.W	$FFDE,$FFD7,$FFD1,$FFCB,$FFC5,$FFC0,$FFBC,$FFB8,$FFB5,$FFB3
	DC.W	$FFB1,$FFB1,$FFB1,$FFB1,$FFB3,$FFB5,$FFB8,$FFBC,$FFC0,$FFC5
	DC.W	$FFCB,$FFD1,$FFD7,$FFDE,$FFE6,$FFED,$FFF5,$FFFD,$0003,$000B
	DC.W	$0013,$001A,$0022,$0029,$002F,$0035,$003B,$0040,$0044,$0048
	DC.W	$004B,$004D,$004F,$004F




JumpCode:	jmp	0




*******************************************************************************
**
**  Og den vildeste copperliste...
**
*******************************************************************************
	SECTION	MyCopper,data_c

FadeCopper:	dc.w	Bplcon0,$0201
	dc.w	$1001,$fffe
.col	dc.w	Color00,0
	dc.l	-2

Copper:	dc.w	Bplcon0,$0201
	dc.w	Bplcon1,$0000
	dc.w	Bplcon2,$0024
	dc.w	Bplcon3,$0c40
;	dc.w	$01fc,$0000
;	dc.w	$01e4,$0000

	dc.w	Spr0pth,0,Spr0ptl,0
	dc.w	Spr1pth,0,Spr1ptl,0
	dc.w	Spr2pth,0,Spr2ptl,0
	dc.w	Spr3pth,0,Spr3ptl,0
	dc.w	Spr4pth,0,Spr4ptl,0
	dc.w	Spr5pth,0,Spr5ptl,0
	dc.w	Spr6pth,0,Spr6ptl,0
	dc.w	Spr7pth,0,Spr7ptl,0

AGA_Colors:	blk.l	(8+1)*2,0

	dc.w	$1001,$fffe
Copper_PlanePtr:	dc.w	Bpl1pth,0,Bpl1ptl,0
	dc.w	Bpl2pth,0,Bpl2ptl,0
	dc.w	Bpl3pth,0,Bpl3ptl,0

;	dc.w	$010c,$0011
	dc.w	Diwstrt,$2071
	dc.w	Bplcon0,$3200
	dc.w	Bplcon2,$0024
	dc.w	Bplcon3,$0c40
	dc.w	Diwstop,$40d1
	dc.w	Ddfstrt,$0030
	dc.w	Ddfstop,$00d8
	dc.w	Bplcon1,$0000
	dc.w	Bpl1mod,80-44
	dc.w	Bpl2mod,80-44

;	dc.w	$01dc,$0020
;	dc.w	$01e4,$2100
;	dc.w	$01fc,$0003

	dc.w	$0001,$7ffe		;WaitBlt
CopBlit1:	dc.w	Bltdpth,0,Bltdptl,0
	dc.w	Bltcon0,$0100,Bltcon1,$0000
	dc.w	Bltdmod,80-44
	dc.w	Bltsize,288<<6!22

	dc.w	$0001,$7ffe		;WaitBlt
CopBlit2:	dc.w	Bltdpth,0,Bltdptl,0
;	dc.w	Bltcon0,$0100,Bltcon1,$0000
;	dc.w	Bltdmod,80-44
	dc.w	Bltsize,288<<6!22

	dc.w	$0001,$7ffe		;WaitBlt
CopBlit3:	dc.w	Bltdpth,0,Bltdptl,0
;	dc.w	Bltcon0,$0100,Bltcon1,$0000
;	dc.w	Bltdmod,80-44
	dc.w	Bltsize,288<<6!22


	dc.l	-2
	dc.l	-2




*******************************************************************************
**
**  Screens+Gfx
**
*******************************************************************************
	SECTION	Screens,bss_c

	CNOP	0,4
_Bss1Start:
	ds.b	(113+YSpace)*80
Screen1:	ds.b	288*80
	ds.b	(113+YSpace)*80
	ds.b	288*80
	ds.b	(113+YSpace)*80
	ds.b	288*80
	ds.b	(113+YSpace)*80
Screen2:	ds.b	288*80
	ds.b	(113+YSpace)*80
	ds.b	288*80
	ds.b	(113+YSpace)*80
	ds.b	288*80
	ds.b	(113+YSpace)*80
Screen3:	ds.b	288*80
	ds.b	(113+YSpace)*80
	ds.b	288*80
	ds.b	(113+YSpace)*80
	ds.b	288*80
	ds.b	(113+YSpace)*80
	CNOP	0,4
_Bss1End:




*******************************************************************************
**
**  Print info on program
**
*******************************************************************************

	PRINTT	'          '
	PRINTT	'Code buffer size:'
	PRINTV	_CodeBufferEnd-CodeBuffer
	PRINTT
	PRINTT	'Bitmap size:'
	PRINTV	_Bss1End-_Bss1Start
	PRINTT
	PRINTT	'Dots ialt:'


*******************************************************************************
**
**  Hardware registers
**
*******************************************************************************
Bltddat:	EQU	$000
Dmaconr:	EQU	$002
Vposr:	EQU	$004
Vhposr:	EQU	$006
Dskdatr:	EQU	$008
Joy0dat:	EQU	$00a
Joy1dat:	EQU	$00c
Clxdat:	EQU	$00e
Adkconr:	EQU	$010
Pot0dat:	EQU	$012
Pot1dat:	EQU	$014
Potgor:	EQU	$016
Serdatr:	EQU	$018
Dskbytr:	EQU	$01a
Intenar:	EQU	$01c
Intreqr:	EQU	$01e
Dskpth:	EQU	$020
Dskptl:	EQU	$022
Dsklen:	EQU	$024
Dskdat:	EQU	$026
Refptr:	EQU	$028
Vposw:	EQU	$02a
Vhposw:	EQU	$02c
Copcon:	EQU	$02e
Serdat:	EQU	$030
Serper:	EQU	$032
Potgo:	EQU	$034
Joytest:	EQU	$036
Strequ:	EQU	$038
Strvbl:	EQU	$03a
Strhor:	EQU	$03c
Strlong:	EQU	$03e
Bltcon0:	EQU	$040
Bltcon1:	EQU	$042
Bltafwm:	EQU	$044
Bltalwm:	EQU	$046
Bltcpth:	EQU	$048
Bltcptl:	EQU	$04a
Bltbpth:	EQU	$04c
Bltbptl:	EQU	$04e
Bltapth:	EQU	$050
Bltaptl:	EQU	$052
Bltdpth:	EQU	$054
Bltdptl:	EQU	$056
Bltsize:	EQU	$058
Bltcmod:	EQU	$060
Bltbmod:	EQU	$062
Bltamod:	EQU	$064
Bltdmod:	EQU	$066
Bltcdat:	EQU	$070
Bltbdat:	EQU	$072
Bltadat:	EQU	$074
Dsksync:	EQU	$07e
Cop1lch:	EQU	$080
Cop1lcl:	EQU	$082
Cop2lch:	EQU	$084
Cop2lcl:	EQU	$086
Copjmp1:	EQU	$088
Copjmp2:	EQU	$08a
Copins:	EQU	$08c
Diwstrt:	EQU	$08e
Diwstop:	EQU	$090
Ddfstrt:	EQU	$092
Ddfstop:	EQU	$094
Dmacon:	EQU	$096
Clxcon:	EQU	$98
Intena:	EQU	$09a
Intreq:	EQU	$09c
Adkcon:	EQU	$09e
Aud0dat:	EQU	$0aa
Aud1dat:	EQU	$0ba
Aud2dat:	EQU	$0ca
Aud3dat:	EQU	$0da
Aud0lch:	EQU	$0a0
Aud1lch:	EQU	$0b0
Aud2lch:	EQU	$0c0
Aud3lch:	EQU	$0d0
Aud0len:	EQU	$0a4
Aud1len:	EQU	$0b4
Aud2len:	EQU	$0c4
Aud3len:	EQU	$0d4
Aud0per:	EQU	$0a6
Aud1per:	EQU	$0b6
Aud2per:	EQU	$0c6
Aud3per:	EQU	$0d6
Aud0vol:	EQU	$0a8
Aud1vol:	EQU	$0b8
Aud2vol:	EQU	$0c8
Aud3vol:	EQU	$0d8
Aud0lcl:	EQU	$0a2
Aud1lcl:	EQU	$0b2
Aud2lcl:	EQU	$0c2
Aud3lcl:	EQU	$0d2
Bpl1pth:	EQU	$0e0
Bpl1ptl:	EQU	$0e2
Bpl2pth:	EQU	$0e4
Bpl2ptl:	EQU	$0e6
Bpl3pth:	EQU	$0e8
Bpl3ptl:	EQU	$0ea
Bpl4pth:	EQU	$0ec
Bpl4ptl:	EQU	$0ee
Bpl5pth:	EQU	$0f0
Bpl5ptl:	EQU	$0f2
Bpl6pth:	EQU	$0f4
Bpl6ptl:	EQU	$0f6
Bpl7pth:	EQU	$0f8
Bpl7ptl:	EQU	$0fa
Bpl8pth:	EQU	$0fc
Bpl8ptl:	EQU	$0fe
Bplcon0:	EQU	$100
Bplcon1:	EQU	$102
Bplcon2:	EQU	$104
Bplcon3:	EQU	$106
Bpl1mod:	EQU	$108
Bpl2mod:	EQU	$10a
Bpl1dat:	EQU	$110
Bpl2dat:	EQU	$112
Bpl3dat:	EQU	$114
Bpl4dat:	EQU	$116
Bpl5dat:	EQU	$118
Bpl6dat:	EQU	$11a
Spr0pth:	EQU	$120
Spr0ptl:	EQU	$122
Spr1pth:	EQU	$124
Spr1ptl:	EQU	$126
Spr2pth:	EQU	$128
Spr2ptl:	EQU	$12a
Spr3pth:	EQU	$12c
Spr3ptl:	EQU	$12e
Spr4pth:	EQU	$130
Spr4ptl:	EQU	$132
Spr5pth:	EQU	$134
Spr5ptl:	EQU	$136
Spr6pth:	EQU	$138
Spr6ptl:	EQU	$13a
Spr7pth:	EQU	$13c
Spr7ptl:	EQU	$13e
Spr0pos:	EQU	$140
Spr0ctl:	EQU	$142
Spr0data:	EQU	$144
Spr0datb:	EQU	$146
Spr1pos:	EQU	$148
Spr1ctl:	EQU	$14a
Spr1data:	EQU	$14c
Spr1datb:	EQU	$14e
Spr2pos:	EQU	$150
Spr2ctl:	EQU	$152
Spr2data:	EQU	$154
Spr2datb:	EQU	$156
Spr3pos:	EQU	$158
Spr3ctl:	EQU	$15a
Spr3data:	EQU	$15c
Spr3datb:	EQU	$15e
Spr4pos:	EQU	$160
Spr4ctl:	EQU	$162
Spr4data:	EQU	$164
Spr4datb:	EQU	$166
Spr5pos:	EQU	$168
Spr5ctl:	EQU	$16a
Spr5data:	EQU	$16c
Spr5datb:	EQU	$16e
Spr6pos:	EQU	$170
Spr6ctl:	EQU	$172
Spr6data:	EQU	$174
Spr6datb:	EQU	$176
Spr7pos:	EQU	$178
Spr7ctl:	EQU	$17a
Spr7data:	EQU	$17c
Spr7datb:	EQU	$17e
Color00:	EQU	$180
Color01:	EQU	$182
Color02:	EQU	$184
Color03:	EQU	$186
Color04:	EQU	$188
Color05:	EQU	$18a
Color06:	EQU	$18c
Color07:	EQU	$18e
Color08:	EQU	$190
Color09:	EQU	$192
Color10:	EQU	$194
Color11:	EQU	$196
Color12:	EQU	$198
Color13:	EQU	$19a
Color14:	EQU	$19c
Color15:	EQU	$19e
Color16:	EQU	$1a0
Color17:	EQU	$1a2
Color18:	EQU	$1a4
Color19:	EQU	$1a6
Color20:	EQU	$1a8
Color21:	EQU	$1aa
Color22:	EQU	$1ac
Color23:	EQU	$1ae
Color24:	EQU	$1b0
Color25:	EQU	$1b2
Color26:	EQU	$1b4
Color27:	EQU	$1b6
Color28:	EQU	$1b8
Color29:	EQU	$1ba
Color30:	EQU	$1bc
Color31:	EQU	$1be
_Custom:	EQU	$dff000




*******************************************************************************
**
**  Interrupt addresses
**
*******************************************************************************
Lev1Base:	EQU	$64
Lev2Base:	EQU	$68
Lev3Base:	EQU	$6c
Lev4Base:	EQU	$70
Lev5Base:	EQU	$74
Lev6Base:	EQU	$78
Lev7Base:	EQU	$7c
Trap0:	EQU	$80






