  kGg  jGgGgGgGgGgGg;-------------------T--------T

Track=0	;0=ASM-One version
	;1=Track version
Raster=0
Width=352
Height=288
BckCol=$132
TandCol=$312
TandColAGA=($301020>>1)&$7f7f7f
AGA=1


MyDmaco2=%11001000000
MyDmacon=%11111100000
;         abcdefghhhh
; a = Blitter nasty
; b = Enable DMA activity (always set this!)
; c = Bitplane enable
; d = Copper enable
; e = Blitter enable
; f = Sprite enable
; g = Disk enable
; h = Audio channels enable

MyIntena=%100000000100000
;         abcdeeeefghijkl
; a = Enable interrupts
; b = Lev. 6 External interrupt
; c = Lev. 5 Disk sync found
; d = Lev. 5 Serial port receive buffer full
; e = Lev. 4 Audio ch. 3-0 block finished
; f = Lev. 3 Blitter finished
; g = Lev. 3 Vertical blank
; h = Lev. 3 Copper
; i = Lev. 2 I/O Ports and timers
; j = Lev. 1 Software
; k = Lev. 1 Disk block finished
; l = Lev. 1 Serial port transmit buffer empty

	JumpPtr	Begin

	SECTION	Kode,code

*******************************************************************************
**Macros
*******************************************************************************
CopBltWait:	EQU	$00017ffe

WaitBlt:	MACRO
	btst	#14,Dmaconr+_Custom
.vent\@:	if	Raster=1
	move.w	#$fff,Color00+_Custom
	endif
	btst	#14,Dmaconr+_Custom
	bne.b	.vent\@
	if	Raster=1
	move.w	#0,Color00+_Custom
	endif
	ENDM

SetInt:	MACRO
	move.l	(Lev\1Base).w,OldIrq\1
	move.l	#Lev\1Irq,(Lev\1Base).w
	bra.b	jumpo\@
OldIrq\1:	dc.l	0
jumpo\@:
	ENDM

ClrInt:	MACRO
	move.l	OldIrq\1(pc),(Lev\1Base).w
	ENDM

Push.l:	MACRO
	movem.l	\1,-(sp)
	ENDM

Push.w:	MACRO
	movem.w	\1,-(sp)
	ENDM

Pull.l:	MACRO
	movem.l	(sp)+,\1
	ENDM

Pull.w:	MACRO
	movem.w	(sp)+,\1
	ENDM

StartPrg:	MACRO
	move.w	#$7fff,Intreq+_Custom
	move.w	#MyDmacon+$8000,Dmacon+_Custom
	move.w	#MyIntena+$8000,Intena+_Custom
	ENDM

StopPrg:	MACRO
	move.w	#$7fff,Intena+_Custom
	move.w	#$7fff,Dmacon+_Custom
	move.w	#$7fff,Intreq+_Custom
	ENDM

StopSystem:	MACRO
	move.w	Intenar+_Custom,OldIntena
	move.w	Dmaconr+_Custom,OldDmacon
	StopPrg
	bra.b	jumpo\@
OldIntena:	dc.w	0
OldDmacon:	dc.w	0
jumpo\@:
	ENDM

StartSystem:	MACRO
	move.w	OldDmacon(pc),d0
	or.w	#$8000,d0
	move.w	d0,Dmacon+_Custom
	move.w	OldIntena(pc),d0
	or.w	#$8000,d0
	move.w	d0,Intena+_Custom
	ENDM


*******************************************************************************
**Initialisering
*******************************************************************************
Begin:
	IF	Track=0
	Push.l	d0-a6
	StopSystem
	ELSE
	move.l	#Lev3Irq,(Lev1Base).w
	rts
	ENDC
**Init starter -----------------------------------
	lea	Clear,a0
	move.l	#(TheEnd-Clear)/4,d0
.clrloop:	clr.l	(a0)+
	subq.l	#1,d0
	bne.b	.clrloop

	lea	SinusTabel(pc),a0
	move.w	#1024+256-1,d0
.loop	asr.w	#1,(a0)+
	dbra	d0,.loop

	bsr.w	InitMegaMulsTable_Plane

	lea	Muls80Tab,a0
	moveq	#0,d0
.mloop	move.w	d0,(a0)+
	add.w	#88,d0
	cmp.w	#88*288,d0
	bne.b	.mloop

	lea	Extra_Screen1+288*44,a0
	moveq	#-1,d6
	moveq	#4-1,d5
.sloop2	moveq	#128-1,d7
.sloop	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	lea	44-16(a0),a0
	dbra	d7,.sloop
	lea	(144-128)*44(a0),a0
	dbra	d5,.sloop2

	move.l	#BltCopper2,BltPtr

	move.l	#FontScreen,d0
	lea	TextPlan+2,a0
	lea	Copper_PlanePtr2+2,a1
	move.w	d0,4(a0)
	move.w	d0,4(a1)
	swap	d0
	move.w	d0,(a0)
	move.w	d0,(a1)

	bsr.w	TypeScreen_Plane

	WaitBlt

**Init slutter -----------------------------------

	IFEQ	Track-0
	SetInt	3
	clr.l	$0.w
	StartPrg

*******************************************************************************
**Vent p exitsignal
*******************************************************************************
WaitForExit:	bsr.b	WaitVBlank
	tst.w	IWantOut
	bne.b	ExitToDos
	bra.b	WaitForExit

WaitBlanks:	bsr.b	WaitVBlank
	dbra	d0,WaitBlanks
	rts
WaitVBlank:	clr.w	VBlank
.wait	tst.w	VBlank
	beq.b	.wait
	rts

*******************************************************************************
**Exit to AmigaDOS
*******************************************************************************
ExitToDos:
	StopPrg

**Exit starter -----------------------------------
	ClrInt	3
**Exit slutter -----------------------------------

	StartSystem

	Pull.l	d0-a6
	moveq	#0,d0
	ENDC
	rts

	IFEQ	Track-0
NoCopper:	dc.w	Copjmp2,0
	dc.w	Bplcon0,$0200
	dc.w	Color00,$0
	dc.w	Ddfstrt,$38
	dc.w	Ddfstop,$d0
	dc.w	Diwstrt,$2c81
	dc.w	Diwstop,$2c81
	dc.w	Bpl1mod,0
	dc.w	Bpl2mod,0
	dc.l	-2
	ENDC


*******************************************************************************
**Level 3 interrupt
*******************************************************************************
MegaPause:	dc.w	0
MegaStory:	dc.w	0
MaxRast:	dc.w	0
VBlank:	dc.w	0
	IF	Track=0
IWantOut:	dc.w	0
	ELSE
IWantOut:	EQU	$80
	ENDC
Lev3Irq:	move.w	#1,VBlank
	Push.l	d0-a6
**Lev3irq starter --------------------------------
	bsr.b	MegaStoryBoard
**Lev3irq slutter --------------------------------
	IFEQ	Track-0
	btst	#6,$bfe001
	bne.b	.noleft
	move.w	#-1,IWantOut
.noleft
	ENDC
	WaitBlt
	IF	Raster=1
	move.w	#$f00,$dff180
	ENDIF
	move.b	$dff005,d0
	lsl.w	#8,d0
	move.b	$dff006,d0
	cmp.w	MaxRast(pc),d0
	bls.b	.nooot
	move.w	d0,MaxRast
.nooot	Pull.l	d0-a6
	IFEQ	Track-0
	move.w	#$0020,Intreq+_Custom
	ELSE
	move.w	#$0004,Intreq+_Custom
	ENDC
	rte


MegaStoryBoard:	move.w	MegaStory(pc),d0
	add.w	d0,d0
	add.w	d0,d0
	move.l	.routines(PC,d0.w),a0
	jmp	(a0)

.routines	dc.l	Init_Plane1,Init_Plane2,FadeUp,Lev3_Plane
	dc.l	Init_Vec,Init_Vec2,Init_Vec3,Lev3_Vec0,Lev3_Vec
	dc.l	Lev3_Vec2
	dc.l	Init_Plane11,Init_Plane21,Init_Plane3
	dc.l	Lev3_Plane
	dc.l	FadeDown,MakeExit

Ting:	dc.w	0

FadeUp:	move.l	#SunCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom

	moveq	#2-1,d7
	lea	FadeColsBck(pc),a1
	lea	FadeCopper+2,a0
.dloop	move.w	(a0),d0
	move.w	(a1)+,d1
	bsr.w	fader
	move.w	d0,(a0)
	addq.w	#4,a0
	dbra	d7,.dloop

	addq.w	#1,Ting
	cmp.w	#20,Ting
	bne.b	.out
	addq.w	#1,MegaStory
.out	rts

FadeDown:	move.l	#SunCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom

	moveq	#2-1,d7
	lea	FadeCopper+2,a0
.dloop	move.w	(a0),d0
	moveq	#0,d1
	bsr.w	fader
	move.w	d0,(a0)
	addq.w	#4,a0
	dbra	d7,.dloop

	subq.w	#1,Ting
	bne.b	.out
	addq.w	#1,MegaStory
.out	rts


FadeColsBck:	dc.w	BckCol
	dc.w	0



TPause:	dc.w	100
TestPause:	move.l	#BlackCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	subq.w	#1,TPause
	bne.b	.out
	addq.w	#1,MegaStory
	move.w	#100,TPause
.out	rts

MakeExit:	move.l	#SunCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	move.w	#-1,IWantOut
	rts


Lev3_Vec:	move.l	#Copper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#%10,Copcon+_Custom

	bsr.w	SwapScr
	bsr.w	ClrScr
	bsr.w	RotatePoints
	bsr.w	CalcFaces
	bsr.w	DrawFaces
	bsr.w	FillScr
	bsr.w	TegnBette
	bsr.w	MoveObject
	bsr.w	FadeSvend

	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
;	IF	Raster=1
;	move.l	#Color00<<16+$888,(a6)+
;	ENDIF
	move.l	#-2,(a6)+
	move.l	a6,BltCopPtr

;	cmp.w	#820,MegaPause
;	bne.b	.noleft
;	addq.w	#1,MegaStory
.noleft	addq.w	#1,MegaPause

	rts

Lev3_Vec0:	move.l	#Copper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#%10,Copcon+_Custom

	bsr.w	SwapScr
	bsr.w	ClrScr
	bsr.w	RotatePoints
	bsr.w	CalcFaces
	bsr.w	DrawFaces
	bsr.w	FillScr
	bsr.w	MoveObject
	bsr.w	FadeSvend

	move.w	YCenter(pc),d0
	moveq	#0,d1
	bsr.w	ParFader
	move.w	d0,YCenter
	tst.w	d0
	bne.b	.heh
	addq.w	#1,MegaStory

.heh	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
;	IF	Raster=1
;	move.l	#Color00<<16+$888,(a6)+
;	ENDIF
	move.l	#-2,(a6)+
	move.l	a6,BltCopPtr

;	cmp.w	#820,MegaPause
;	bne.b	.noleft
;	addq.w	#1,MegaStory
.noleft	addq.w	#1,MegaPause

	rts

Lev3_Vec2:	move.l	#Copper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#%10,Copcon+_Custom

	bsr.w	SwapScr
	bsr.w	ClrScr
	bsr.w	RotatePoints
	bsr.w	CalcFaces
	bsr.w	DrawFaces
	bsr.w	FillScr
	bsr.w	MoveObject
	bsr.w	FadeSvend

	move.w	ParSpeed(pc),d0
	sub.w	d0,YCenter
	lsr.w	#4,d0
	bne.b	.norm
	moveq	#1,d0
.norm	add.w	d0,ParSpeed
	cmp.w	#-4000,YCenter
	bgt.b	.heh
	addq.w	#1,MegaStory

.heh	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
;	IF	Raster=1
;	move.l	#Color00<<16+$888,(a6)+
;	ENDIF
	move.l	#-2,(a6)+
	move.l	a6,BltCopPtr

;	cmp.w	#820,MegaPause
;	bne.b	.noleft
;	addq.w	#1,MegaStory
.noleft	addq.w	#1,MegaPause

	rts

ParSpeed:	dc.w	1

**in:
** d0=fra
** d1=til
**out:
** d0=ny pos
ParFader:	sub.w	d0,d1
	beq.b	.out
	asr.w	#4,d1
	tst.w	d1
	bne.b	.norm
	moveq	#1,d1
.norm	add.w	d1,d0
.out	rts

Init_Vec:	move.l	#BlackCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	bsr.w	SwapScr
	bsr.w	ClrScr
	bsr.w	MoveObject
	bsr.w	RotatePoints
	bsr.w	CalcFaces
	bsr.w	DrawFaces
	bsr.w	FillScr
	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	IF	Raster=1
	move.l	#Color00<<16+$888,(a6)+
	ENDIF
	move.l	#-2,(a6)
	addq.w	#1,MegaStory
	rts

Init_Vec2:	move.l	#BlackCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	lea	_Custom,a6
	WaitBlt
	move.l	#Tand_Screen1,Bltdpth(a6)
	move.l	#$01000000,Bltcon0(a6)
	move.w	#0,Bltdmod(a6)
	move.w	#288<<6!44,Bltsize(a6)
	addq.w	#1,MegaStory
	rts

Init_Vec3:	move.l	#BlackCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	lea	_Custom,a6
	WaitBlt
	move.l	#Tand_Screen2,Bltdpth(a6)
	move.l	#$01000000,Bltcon0(a6)
	move.w	#0,Bltdmod(a6)
	move.w	#288<<6!44,Bltsize(a6)
	addq.w	#1,MegaStory
	rts



Lev3_Plane:	move.l	#WriterCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#%10,Copcon+_Custom
	bsr.w	SwapScr_Plane
	bsr.w	ClrScr_Plane
	bsr.w	CopyWriter_Plane
	bsr.w	StoryBoard_Plane
	rts


Init_Plane1Var:	dc.w	0
Init_Plane1:	move.l	#SunCopper,Cop2lch+_Custom
	bra.b	Init_Plane11|.hehe
Init_Plane11:	move.l	#BlackCopper,Cop2lch+_Custom
.hehe	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	lea	BltCopper1,a0
	lea	BltCopper2,a1
	move.w	Init_Plane1Var(pc),d0
	move.w	d0,d1
	mulu	#24*36,d0
	add.w	d0,a0
	add.w	d0,a1
	cmp.w	#10,d1
	beq.b	.svend
	move.w	#24-1,d7
.bltloop	move.l	#$00017ffe,(a0)+
	move.l	#$00017ffe,(a1)+
	move.l	#Bltcpth<<16,(a0)+
	move.l	#Bltcpth<<16,(a1)+
	move.l	#Bltcptl<<16,(a0)+
	move.l	#Bltcptl<<16,(a1)+
	move.l	#Bltdpth<<16,(a0)+
	move.l	#Bltdpth<<16,(a1)+
	move.l	#Bltdptl<<16,(a0)+
	move.l	#Bltdptl<<16,(a1)+
	move.l	#Bltapth<<16,(a0)+
	move.l	#Bltapth<<16,(a1)+
	move.l	#Bltaptl<<16,(a0)+
	move.l	#Bltaptl<<16,(a1)+
	move.l	#Bltcon0<<16!$0BFA,(a0)+
	move.l	#Bltcon0<<16!$0BFA,(a1)+
	move.l	#Bltsize<<16!(1<<6!23),(a0)+
	move.l	#Bltsize<<16!(1<<6!23),(a1)+
	dbra	d7,.bltloop
	addq.w	#1,Init_Plane1Var
	rts
.svend	move.l	#Cop2lch<<16,(a0)+
	move.l	#Cop2lch<<16,(a1)+
	move.l	#Cop2lcl<<16,(a0)+
	move.l	#Cop2lcl<<16,(a1)+
	move.l	#-2,(a0)+
	move.l	#-2,(a1)+
	addq.w	#1,MegaStory
	clr.w	Init_Plane1Var
	rts

Init_Plane2:	move.l	#SunCopper,Cop2lch+_Custom
	bra.b	Init_Plane21|.hehe
Init_Plane21:	move.l	#BlackCopper,Cop2lch+_Custom
.hehe	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	bsr.w	SwapScr_Plane
	bsr.w	ClrScr_Plane
	bsr.w	CopyWriter_Plane
	addq.w	#1,MegaStory
	rts

Init_Plane3:	move.l	#BlackCopper,Cop2lch+_Custom
	move.w	d0,Copjmp2+_Custom
	move.w	#0,Copcon+_Custom
	lea	_Custom,a6
	WaitBlt
	move.l	#FontScreen,Bltapth(a6)
	move.l	#Screen1,Bltdpth(a6)
	move.l	#44,Bltamod(a6)
	move.l	#-1,Bltafwm(a6)
	move.l	#$09f00000,Bltcon0(a6)
	move.w	#288<<6!22,Bltsize(a6)
	WaitBlt
	move.l	#FontScreen,Bltapth(a6)
	move.l	#Screen2,Bltdpth(a6)
	move.l	#44,Bltamod(a6)
	move.l	#-1,Bltafwm(a6)
	move.l	#$09f00000,Bltcon0(a6)
	move.w	#288<<6!22,Bltsize(a6)
	addq.w	#1,MegaStory
	rts



*******************************************************************************
**
**  Storyboard
**
*******************************************************************************
Story_Plane:	dc.w	0
StoryBoard_Plane:	move.w	Story_Plane(pc),d0
	beq.b	Story_In_Plane
	subq.w	#1,d0
	beq.b	Story_Out_Plane
	rts

Story_In_Plane:	addq.w	#1,Writer_FaderPtr_Plane
	cmp.w	#255,Writer_FaderPtr_Plane
	bne.b	.ok
	addq.w	#1,Story_Plane
	addq.w	#1,MegaStory
.ok	rts

Story_Out_Plane:	subq.w	#1,Writer_FaderPtr_Plane
	bne.b	.ok
	addq.w	#1,Story_Plane
	addq.w	#1,MegaStory
.ok	rts


*******************************************************************************
**
**  Copy Writer
**
*******************************************************************************
CopyWriter_Plane:	move.l	BltPtr,a0
	addq.w	#4+2,a0
	lea	FontScreen+24*44,a1
	move.l	Screen_Draw,a2
	moveq	#0,d0
	move.w	Writer_FaderPtr_Plane(pc),d0
	lsl.w	#8,d0
	lea	MegaMulsTable,a3
	add.l	d0,a3
	lea	Muls80Tab,a4
	move.w	Writer_SinusPtr_Plane(pc),d3
	move.w	#240-1,d7
.loop	move.w	16*2(a3,d3.w),d0
	move.w	(a3,d3.w),d1
	add.w	#240-1+24,d1
	sub.w	d7,d1
	bge.b	.yok1
.ynotok	move.w	#352,d0
	moveq	#0,d1
	bra.b	.plotit
.yok1	cmp.w	#287,d1
	bgt.b	.ynotok
	cmp.w	#352,d0
	bgt.b	.ynotok
	cmp.w	#-352,d0
	ble.b	.ynotok
.plotit	add.w	d1,d1
	move.w	(a4,d1.w),d1
	move.w	d0,d2
	asr.w	#4,d0
	add.w	d0,d0
	add.w	d0,d1	;byteoffset
	lsl.b	#4,d2
	or.b	#%1011,d2	;bltcon0
	ext.l	d1
	add.l	a2,d1	;screenbytepos
	move.w	d1,4(a0)
	move.w	d1,8+4(a0)
	swap	d1
	move.w	d1,(a0)
	move.w	d1,8(a0)
	move.l	a1,d1
	move.w	d1,16+4(a0)
	swap	d1
	move.w	d1,16(a0)
	move.b	d2,24(a0)
	lea	36(a0),a0	;nextcopper
	lea	44(a1),a1	;nextline
	addq.w	#2,d3
	and.w	#64*2-1,d3
	dbra	d7,.loop
	addq.w	#2,Writer_SinusPtr_Plane
	and.w	#64*2-1,Writer_SinusPtr_Plane
	rts


InitMegaMulsTable_Plane:	lea	Writer_Fader_Plane(pc),a0
	lea	MegaMulsTable,a2
	move.w	#256-1,d6
.loop2	move.w	(a0)+,d1
	lea	Writer_Sinus_Plane(pc),a1
	move.w	#64-1,d7
.loop	move.w	(a1)+,d0
	muls	d1,d0
	asr.l	#8,d0
	asr.l	#1,d0
	move.w	d0,64*2(a2)
	move.w	d0,(a2)+
	dbra	d7,.loop
	lea	64*2(a2),a2
	dbra	d6,.loop2
	rts

Writer_SinusPtr_Plane:	dc.w	0
Writer_Sinus_Plane:	;0,360,64,512,0,l,1,y,n
	QREPT	2
	DC.W	$0019,$004B,$007C,$00AC,$00DA,$0107,$0130,$0157,$017B,$019B
	DC.W	$01B7,$01CE,$01E2,$01F0,$01FA,$01FF,$01FF,$01FA,$01F0,$01E2
	DC.W	$01CE,$01B7,$019B,$017B,$0157,$0130,$0107,$00DA,$00AC,$007C
	DC.W	$004B,$0019,$FFE7,$FFB5,$FF84,$FF54,$FF26,$FEF9,$FED0,$FEA9
	DC.W	$FE85,$FE65,$FE49,$FE32,$FE1E,$FE10,$FE06,$FE01,$FE01,$FE06
	DC.W	$FE10,$FE1E,$FE32,$FE49,$FE65,$FE85,$FEA9,$FED0,$FEF9,$FF26
	DC.W	$FF54,$FF84,$FFB5,$FFE7
	ENDQR

Writer_FaderPtr_Plane:	dc.w	0
Writer_Fader_Plane:	;180,270,256,256,256,w,1,n,y
	DC.W	$0200,$01FD,$01FA,$01F7,$01F3,$01F0,$01ED,$01EA,$01E7,$01E4
	DC.W	$01E1,$01DD,$01DA,$01D7,$01D4,$01D1,$01CE,$01CB,$01C8,$01C4
	DC.W	$01C1,$01BE,$01BB,$01B8,$01B5,$01B2,$01AF,$01AC,$01A8,$01A5
	DC.W	$01A2,$019F,$019C,$0199,$0196,$0193,$0190,$018D,$018A,$0187
	DC.W	$0184,$0181,$017E,$017A,$0177,$0174,$0171,$016E,$016B,$0168
	DC.W	$0165,$0162,$015F,$015C,$0159,$0156,$0154,$0151,$014E,$014B
	DC.W	$0148,$0145,$0142,$013F,$013C,$0139,$0136,$0133,$0131,$012E
	DC.W	$012B,$0128,$0125,$0122,$011F,$011D,$011A,$0117,$0114,$0111
	DC.W	$010F,$010C,$0109,$0106,$0104,$0101,$00FE,$00FB,$00F9,$00F6
	DC.W	$00F3,$00F1,$00EE,$00EB,$00E9,$00E6,$00E4,$00E1,$00DE,$00DC
	DC.W	$00D9,$00D7,$00D4,$00D2,$00CF,$00CC,$00CA,$00C7,$00C5,$00C3
	DC.W	$00C0,$00BE,$00BB,$00B9,$00B6,$00B4,$00B2,$00AF,$00AD,$00AA
	DC.W	$00A8,$00A6,$00A4,$00A1,$009F,$009D,$009A,$0098,$0096,$0094
	DC.W	$0092,$008F,$008D,$008B,$0089,$0087,$0085,$0083,$0080,$007E
	DC.W	$007C,$007A,$0078,$0076,$0074,$0072,$0070,$006E,$006C,$006A
	DC.W	$0069,$0067,$0065,$0063,$0061,$005F,$005D,$005C,$005A,$0058
	DC.W	$0056,$0055,$0053,$0051,$004F,$004E,$004C,$004A,$0049,$0047
	DC.W	$0046,$0044,$0043,$0041,$003F,$003E,$003C,$003B,$003A,$0038
	DC.W	$0037,$0035,$0034,$0033,$0031,$0030,$002F,$002D,$002C,$002B
	DC.W	$0029,$0028,$0027,$0026,$0025,$0023,$0022,$0021,$0020,$001F
	DC.W	$001E,$001D,$001C,$001B,$001A,$0019,$0018,$0017,$0016,$0015
	DC.W	$0014,$0013,$0013,$0012,$0011,$0010,$000F,$000F,$000E,$000D
	DC.W	$000C,$000C,$000B,$000A,$000A,$0009,$0009,$0008,$0008,$0007
	DC.W	$0007,$0006,$0006,$0005,$0005,$0004,$0004,$0003,$0003,$0003
	DC.W	$0002,$0002,$0002,$0002,$0001,$0001,$0001,$0001,$0001,$0000
	DC.W	$0000,$0000,$0000,$0000,$0000,$0000




*******************************************************************************
**
**  Type screen
**
*******************************************************************************
TypeScreen_Plane:	lea	FontScreen+2*44+24*44,a6
	lea	PlaneFont,a0
	lea	Text_Plane(pc),a1
.next	tst.b	(a1)
	beq.b	.out
	bsr.b	WriteLine_Plane
	bra.b	.next
.out	rts

WriteLine_Plane:	moveq	#0,d0
	move.b	(a1)+,d0
	cmp.b	#10,d0
	beq.b	.CRLF
	cmp.b	#1,d0
	bne.b	.notvenstre
	moveq	#0,d1	;X-Pos
	bra.b	.printit
.notvenstre	bsr.w	FindPixelSize_Plane
	move.w	#352,d1
	sub.w	d3,d1
	bge.b	.ok
	moveq	#0,d1
.ok	cmp.b	#2,d0
	bne.b	.printit
	lsr.w	#1,d1
.printit	moveq	#0,d0
	move.b	(a1)+,d0
	cmp.b	#10,d0
	beq.b	.CRLF
	bsr.b	PrintChar_Plane
	add.w	d2,d1
	bra.b	.printit
.CRLF	lea	20*44(a6),a6
	rts


** in:  d0=asciichar
**      d1=pos
**      a0=font
**      a6=screen
** out: d2=charsize
** trashes:
PrintChar_Plane:	bra.b	.jump
.wloop	bsr.b	.copybyte
	addq.w	#1,a2
	bsr.b	.copybyte
	lea	35(a2),a2
	lea	42(a3),a3
	dbra	d4,.wloop
	rts
.copybyte	moveq	#0,d5
	move.b	(a2),d5
	ror.w	d3,d5
	or.b	d5,(a3)+
	lsr.w	#8,d5
	or.b	d5,(a3)
	rts
.jump	sub.b	#32,d0
	add.w	d0,d0
	moveq	#0,d2
	moveq	#0,d3
	move.b	FontConverter_Plane(PC,d0.w),d3
	move.b	FontConverter_Plane+1(PC,d0.w),d2
	cmp.b	#35,d3
	shi	d5
	divu	#36,d3
	move.w	d3,d4
	mulu	#36*17,d4
	swap	d3
	add.w	d3,d4
	lea	(a0,d4.w),a2	;font
	move.w	d1,d3
	move.w	d3,d4
	lsr.w	#3,d4
	lea	(a6,d4.w),a3	;screen
	tst.b	d5
	beq.b	.small
	lea	-2*44(a3),a3
.small	and.w	#7,d3	;scrollvalue
	moveq	#17-1,d4
	cmp.b	#8,d2
	bhi.b	.wloop
.bloop	bsr.b	.copybyte
	lea	36(a2),a2
	lea	43(a3),a3
	dbra	d4,.bloop
	rts

** in:  a1=text_Plane
** out: d3=pixelsize
** trashes: d2/d4/a2
FindPixelSize_Plane:	move.l	a1,a2
	moveq	#0,d3
.next	moveq	#0,d2
	move.b	(a2)+,d2
	cmp.b	#10,d2
	beq.b	.gotit
	sub.b	#32,d2
	add.w	d2,d2
	moveq	#0,d4
	move.b	FontConverter_Plane+1(PC,d2.w),d4
	add.w	d4,d3
	bra.b	.next
.gotit	rts

FontConverter_Plane:	dc.b	82,6,86,3,79,8,82,6	 ; SPC - '#'
	dc.b	82,6,82,6,75,8,80,4	 ; '$' - '''
	dc.b	72,6,73,6,89,10,82,6	 ; '(' - '+'
	dc.b	77,4,74,5,76,3,83,11	 ; ',' - '/'
	dc.b	82,6,87,7,88,8,82,6	 ; '0' - '3'
	dc.b	82,6,82,6,82,6,82,6	 ; '4' - '7'
	dc.b	82,6,82,6,78,3,82,6	 ; '8' - ';'
	dc.b	82,6,82,6,82,6,85,8	 ; '<' - '?'
	dc.b	82,6,36,8,37,8,38,8	 ; '@' - 'C'
	dc.b	39,8,40,8,41,8,42,8	 ; 'D' - 'G'
	dc.b	43,8,44,3,45,8,46,8	 ; 'H' - 'K'
	dc.b	47,4,48,12,50,8,51,8 ; 'L' - 'O'
	dc.b	52,8,53,8,54,8,55,8	 ; 'P' - 'S'
	dc.b	56,8,57,8,58,8,59,12 ; 'T' - 'W'
	dc.b	61,8,62,8,63,8,72,6	 ; 'X' - '['
	dc.b	82,6,73,6,82,6,82,6	 ; '\' - '_'
	dc.b	81,8,00,8,01,8,02,8	 ; '`' - 'c'
	dc.b	03,8,04,8,05,8,06,8	 ; 'd' - 'g'
	dc.b	07,8,08,3,09,8,10,8	 ; 'h' - 'k'
	dc.b	11,4,12,12,14,8,15,8 ; 'l' - 'o'
	dc.b	16,8,17,8,18,8,19,8	 ; 'p' - 's'
	dc.b	20,8,21,8,22,8,23,12 ; 't' - 'w'
	dc.b	25,8,26,8,27,8,72,6	 ; 'x' - '{'
	dc.b	82,6,82,6,82,6,82,6	 ; '|' - DEL

	blk.w	32,(82<<8)!6

	dc.b	82,6,82,6,82,6,82,6	 ; SPC - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	71,8,68,8,64,10,82,6 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,69,8,82,6	 ; '' - ''
	dc.b	66,10,82,6,82,6,82,6 ; '' - ''
	dc.b	70,8,82,6,82,8,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	35,8,32,8,28,11,82,6 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,82,6,82,6	 ; '' - ''
	dc.b	82,6,82,6,33,8,82,6	 ; '' - ''
	dc.b	30,10,82,6,82,6,82,6 ; '' - ''
	dc.b	34,8,82,6,82,8,82,6	 ; '' - ''


Text_Plane:	dc.b	1,'  Solnova sends matricides to:',10
	dc.b	2,' ',10
	dc.b	2,'*Marie*, Shining, Funky Buddhas, Lemon',10
	dc.b	2,'Impulse, Majic 12, The Blues Brothers',10
	dc.b	2,'*Melon Dezign*, Camel Koop., Kefrens',10
	dc.b	2,'Skrat-Skratterat-Skrum-Skrirum-Skrat',10
	dc.b	2,'Andromeda, Sarillon''&''Kyberiad Institutti',10
	dc.b	2,'Dens Design, *The Pornos*, Static Bytes ',10
	dc.b	2,'Parasite, Ted''s Farm/Movement, Kdsovs',10
	dc.b	2,'*Matilde*'
	dc.b	10
	dc.b	3,'...and so what?   ',10
	dc.b	0
	EVEN


*******************************************************************************
**
**  Clear screen using blitter
**
*******************************************************************************
ClrScr_Plane:	move.l	Screen_Show,d0
	lea	CopBlit1+2,a0
.insert	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	rts



*******************************************************************************
**
**  Swap screen for doublebuffering!
**
*******************************************************************************
SwapScr_Plane:	move.l	Screen_Draw(pc),a0
	move.l	Screen_Show(pc),a1
	move.l	a1,Screen_Draw
	move.l	a0,Screen_Show

	lea	Copper_PlanePtr+2,a3
	move.l	Screen_Draw,d0
.loop	move.w	d0,4(a3)
	swap	d0
	move.w	d0,(a3)

	lea	BltPtr,a0
	move.l	(a0),d0
	lea	BltCopper1,a1
	lea	BltCopper2,a2
	lea	BlitCopPtr,a3

	move.w	d0,6(a3)
	swap	d0
	move.w	d0,2(a3)
	swap	d0
	cmp.l	d0,a1
	beq.b	.make2
	move.l	a1,(a0)
	rts
.make2	move.l	a2,(a0)
	rts







Screen_Draw:	dc.l	Screen2
Screen_Show:	dc.l	Screen1



TegnAntal:	dc.w	0
TegnBette:	bsr.w	ClrBette
	bsr.w	DrawFaces2
	bsr.w	FillBette
	bsr.b	CopyBette
	addq.w	#1,TegnAntal
	cmp.w	#288*3,TegnAntal
	bne.b	.ok
	addq.w	#1,MegaStory
.ok	move.w	TegnAntal(pc),d0
	mulu	#44,d0
	add.l	#Extra_Screen1,d0
	move.l	d0,Extra_Screen
	rts


BettePos:	dc.w	288,288+144,288+288


CopyBette:	move.w	BettePos(pc),d0
	bsr.b	.makeit
	move.w	BettePos+2(pc),d0
	cmp.w	#2*288,TegnAntal
	bgt.b	.not
	bsr.b	.makeit
.not	move.w	BettePos+4(pc),d0
	cmp.w	#2*288+144,TegnAntal
	bgt.b	.not2
	bsr.b	.makeit
.not2
	lea	BettePos(pc),a0
	moveq	#3-1,d2
.lop	move.w	(a0),d1
	subq.w	#1,d1
	cmp.w	#-144,d1
	bne.b	.tja
	move.w	#288,d1
.tja	move.w	d1,(a0)+
	dbra	d2,.lop
	rts


.makeit	add.w	#22,d0
	cmp.w	#288,d0
	bge.w	.out
	cmp.w	#-86,d0
	ble.w	.out

	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+

	moveq	#0,d1	;startoffset
	move.w	#86,d2	;hjde

	tst.w	d0
	bge.b	.yok1
	sub.w	d0,d1
	moveq	#0,d0
	sub.w	d1,d2
.yok1	cmp.w	#287-86,d0
	ble.b	.yok2
	move.w	#288,d2
	sub.w	d0,d2
.yok2	tst.w	d2
	beq.b	.out

	lsl.w	#7,d2
	or.w	#8,d2	;bltsize
	lsl.w	#5,d1	;mulu #32,d1
	ext.l	d1
	add.l	#BetteScreen+16*2*22,d1	;bltapt
	mulu	#88,d0
	add.l	Screen(pc),d0	;bltdpt

	move.w	#Bltaptl,(a6)+
	move.w	d1,(a6)+
	swap	d1
	move.w	#Bltapth,(a6)+
	move.w	d1,(a6)+

	move.w	#Bltdptl,(a6)+
	move.w	d0,(a6)+
	swap	d0
	move.w	#Bltdpth,(a6)+
	move.w	d0,(a6)+

	move.l	#Bltcon0<<16!$09F0,(a6)+
	move.l	#Bltcon1<<16,(a6)+
	move.l	#Bltafwm<<16!$FFFF,(a6)+
	move.l	#Bltalwm<<16!$FFFF,(a6)+
	move.l	#Bltdmod<<16!(44-16),(a6)+
	move.l	#Bltamod<<16,(a6)+
	move.w	#Bltsize,(a6)+
	move.w	d2,(a6)+
	move.l	a6,BltCopPtr

.out	rts




FillBette:	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+

	move.l	#BetteScreen+108*16*2-2-2,d0
	move.w	#Bltaptl,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d0,(a6)+
	swap	d0
	move.w	#Bltapth,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdpth,(a6)+
	move.w	d0,(a6)+
	move.l	#Bltcon0<<16!$09F0,(a6)+
	move.l	#Bltcon1<<16!$0012,(a6)+
	move.l	#Bltafwm<<16!$FFFF,(a6)+
	move.l	#Bltalwm<<16!$FFFF,(a6)+
	move.l	#Bltdmod<<16!4,(a6)+
	move.l	#Bltamod<<16!4,(a6)+
	move.l	#Bltsize<<16!((108*2)<<6!6),(a6)+
	move.l	a6,BltCopPtr
	rts


ClrBette:	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+

	move.l	#BetteScreen+20*16*2+2,d0
	move.w	#Bltdptl,(a6)+
	move.w	d0,(a6)+
	swap	d0
	move.w	#Bltdpth,(a6)+
	move.w	d0,(a6)+
	move.l	#Bltcon0<<16!$0100,(a6)+
	move.l	#Bltcon1<<16,(a6)+
	move.l	#Bltdmod<<16!4,(a6)+
	move.l	#Bltsize<<16!((108*2)<<6!6),(a6)+
	move.l	a6,BltCopPtr
	rts


*******************************************************************************
**Fade svend
*******************************************************************************
FadeSvend:	cmp.w	#20,MegaPause
	blt.b	.up
	rts
.up	moveq	#6-1,d7
	lea	BckVecColors(pc),a1
	lea	VecColors(pc),a0
.dloop	move.w	(a0),d0
	move.w	(a1)+,d1
	bsr.b	fader
	move.w	d0,(a0)+
	dbra	d7,.dloop
	rts


LamFarve:	macro
	dc.w	((\1>>4)<<8)!((\2>>4)<<4)!(\3>>4)
	endm

BckVecColors:
	LamFarve	217,165,255
	LamFarve	081,255,226
	LamFarve	255,154,206
	LamFarve	255,229,174
	LamFarve	139,165,255
	LamFarve	136,238,255
	


	dc.w	$6cf,$6fc,$6ff,$f6c,$f6f,$ff6



**d0=fade from
**d1=fade to
**out: d0=newcol
fader:	move.w	d0,d2
	move.w	d1,d3
	lsr.w	#8,d2
	lsr.w	#8,d3
	cmp.w	d2,d3
	beq.b	.nored
	blt.b	.redsub
	add.w	#$100,d0
	bra.b	.nored
.redsub:	sub.w	#$100,d0
.nored:	move.w	d0,d2
	move.w	d1,d3
	lsr.w	#4,d2
	lsr.w	#4,d3
	and.w	#$f,d2
	and.w	#$f,d3
	cmp.w	d2,d3
	beq.b	.nogreen
	blt.b	.greensub
	add.w	#$10,d0
	bra.b	.nogreen
.greensub:	sub.w	#$10,d0
.nogreen:	move.w	d0,d2
	move.w	d1,d3
	and.w	#$f,d2
	and.w	#$f,d3
	cmp.w	d2,d3
	beq.b	.noblue
	blt.b	.bluesub
	addq.w	#$1,d0
	bra.b	.noblue
.bluesub:	subq.w	#$1,d0
.noblue:	rts







*******************************************************************************
**Calc faces
*******************************************************************************
CalcFaces:
	lea	Faces(pc),a0
	lea	Rotated(pc),a1
	lea	FaceColors(pc),a2
	lea	VecColors(pc),a3
	lea	AllColors(pc),a4
	clr.w	-(sp)

.nextface:	clr.w	(a2)

	move.w	(a0)+,(sp)	;farve
	blt.w	.ud

	move.w	(a0)+,d6	;antal linjer

	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d0
	move.w	2(a1,d7.w),d1

	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d2
	move.w	2(a1,d7.w),d3

	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d4
	move.w	2(a1,d7.w),d5
	

	sub.w	d0,d2
	sub.w	d1,d3
	sub.w	d0,d4
	sub.w	d1,d5
	muls	d2,d5
	muls	d3,d4
	sub.l	d4,d5
	ble.w	.donext

	move.w	(sp),d0
	move.w	d0,(a2)
	subq.w	#1,d0
	add.w	d0,d0
	move.w	d0,-(sp)

	divs	#45,d5

	move.w	(a3),d4
	move.w	d4,d0
	move.w	d4,d1
	move.w	d4,d2
	and.w	#$f00,d0
	and.w	#$0f0,d1
	and.w	#$00f,d2
	lsr.w	#4,d0
	lsl.w	#4,d2
	mulu	d5,d0
	mulu	d5,d1
	mulu	d5,d2
	lsr.l	#8,d0
	lsr.l	#8,d1
	lsr.l	#8,d2

	Push.l	d0-d2
	lsl.w	#4,d0
	lsr.w	#4,d2
	and.w	#$f00,d0
	and.w	#$0f0,d1
	and.w	#$00f,d2
	or.w	d1,d0
	or.w	d2,d0
	move.w	d0,d4
	Pull.l	d0-d2

	lsl.w	#8,d0
	lsl.w	#4,d1
	and.w	#$f00,d0
	and.w	#$0f0,d1
	and.w	#$00f,d2
	or.w	d1,d0
	or.w	d2,d0

	move.w	(sp)+,d5
	move.w	d4,(a4,d5.w)
	move.w	d0,6(a4,d5.w)


.donext:	addq.w	#2,a3
	subq.w	#3,d6
	add.w	d6,d6
	add.w	d6,a0
	addq.w	#2,a2
	bra.w	.nextface

.ud:	addq.w	#2,sp
	lea	AllColors(pc),a0
	lea	CopColors,a1
	move.w	(a0)+,4*1+2(a1)
	move.w	(a0)+,4*4+2(a1)
	move.w	(a0)+,4*5+2(a1)
	IFEQ	AGA-1
	lea	CopColorsAga,a2
	move.w	(a0)+,4*1+2(a2)
	move.w	(a0)+,4*4+2(a2)
	move.w	(a0)+,4*5+2(a2)
	ENDC

	lea	AllColors(pc),a0
	move.w	(a0)+,d0
	move.w	4(a0),d1
	bsr.b	HalfFade
	move.w	d0,4*3+2(a1)
	IFEQ	AGA-1
	move.w	d1,4*3+2(a2)
	ENDC
	move.w	(a0)+,d0
	move.w	4(a0),d1
	bsr.b	HalfFade
	move.w	d0,4*6+2(a1)
	IFEQ	AGA-1
	move.w	d1,4*6+2(a2)
	ENDC
	move.w	(a0)+,d0
	move.w	4(a0),d1
	bsr.b	HalfFade
	move.w	d0,4*7+2(a1)
	IFEQ	AGA-1
	move.w	d1,4*7+2(a2)
	ENDC
	rts

HalfFade:	moveq	#0,d2
	move.w	d0,d2
	and.w	#$f00,d2
	lsr.w	#4,d2
	swap	d2		;Megasmart optimering!!!!
	move.w	d0,d2
	and.w	#$0f0,d2
	lsl.w	#8,d2
	move.b	d0,d2
	lsl.b	#4,d2	;d2=udspredt d0..

	moveq	#0,d3
	move.w	d1,d3
	and.w	#$f00,d3
	lsr.w	#8,d3
	swap	d3		;Megasmart optimering!!!!
	move.w	d1,d3
	and.w	#$0f0,d3
	lsl.w	#4,d3
	move.b	d1,d3
	and.b	#$f,d3	;d3=udspredt d1..

	or.l	d3,d2	;d2 agafarve

	lsr.l	#1,d2
	and.l	#$7f7f7f,d2
	add.l	#TandColAGA,d2

	move.l	d2,d0
	swap	d0
	lsl.w	#4,d0
	and.w	#$f00,d0
	move.w	d2,d3
	and.w	#$f000,d3
	lsr.w	#8,d3
	or.w	d3,d0
	move.w	d2,d3
	and.w	#$f0,d3
	lsr.w	#4,d3
	or.w	d3,d0

	move.l	d2,d1
	swap	d1
	lsl.w	#8,d1
	and.w	#$f00,d1
	move.w	d2,d3
	and.w	#$f00,d3
	lsr.w	#4,d3
	or.w	d3,d1
	move.w	d2,d3
	and.w	#$f,d3
	or.w	d3,d1
	rts

VecColors:	dc.w	$000,$000,$000,$000,$000,$000
AllColors:	blk.w	6,0








*******************************************************************************
**Draw Faces
*******************************************************************************

DrawFaces:
	bsr.w	Init_Line

	lea	Faces(pc),a0
	lea	Rotated(pc),a1
	lea	FaceColors(pc),a3

.nextface:
	tst.w	(a0)+
	blt.w	.ud

	move.w	(a0)+,d6	;antal linjer

	move.w	(a3)+,LineCol
	bne.b	.drawit

;	addq.w	#1,d6
	add.w	d6,d6
	add.w	d6,a0
	bra.b	.nextface

.drawit:	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d0
	move.w	2(a1,d7.w),d1

	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d2
	move.w	2(a1,d7.w),d3

	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d4
	move.w	2(a1,d7.w),d5

	Push.w	d0-d1

	Push.w	d0-d5

	movem.w	(sp),d0-d3
	bsr.w	Line_Draw
	movem.w	4(sp),d0-d3
	bsr.w	Line_Draw
	addq.w	#8,sp
	movem.w	(sp)+,d0-d1

	subq.w	#3,d6
	bra.b	.jumpin

.lines:	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d2
	move.w	2(a1,d7.w),d3
	Push.w	d2-d3
	bsr.w	Line_Draw
	Pull.w	d0-d1
.jumpin	dbra	d6,.lines

	Pull.w	d2-d3
	bsr.w	Line_Draw

	bra.w	.nextface

.ud:
	lea	MinX1(pc),a0

	cmp.w	#Width-1,(a0)
	bgt.b	.makeno1
	cmp.w	#Height-1,2(a0)
	bgt.b	.makeno1
	tst.w	4(a0)
	blt.b	.makeno1
	tst.w	6(a0)
	blt.b	.makeno1

	tst.w	(a0)+
	bge.b	.xok1
	clr.w	-2(a0)
.xok1:	tst.w	(a0)+
	bge.b	.yok1
	clr.w	-2(a0)
.yok1:	cmp.w	#Width-1,(a0)+
	ble.b	.xok2
	move.w	#Width-1,-2(a0)
.xok2:	cmp.w	#Height-1,(a0)+
	ble.b	.yok2
	move.w	#Height-1,-2(a0)
	bra.b	.yok2
.makeno1:	move.l	#$7fff7fff,(a0)+
	move.l	#$80008000,(a0)+
.yok2:
	cmp.w	#Width-1,(a0)
	bgt.b	.makeno2
	cmp.w	#Height-1,2(a0)
	bgt.b	.makeno2
	tst.w	4(a0)
	blt.b	.makeno2
	tst.w	6(a0)
	blt.b	.makeno2

	tst.w	(a0)+
	bge.b	.xok12
	clr.w	-2(a0)
.xok12:	tst.w	(a0)+
	bge.b	.yok12
	clr.w	-2(a0)
.yok12:	cmp.w	#Width-1,(a0)+
	ble.b	.xok22
	move.w	#Width-1,-2(a0)
.xok22:	cmp.w	#Height-1,(a0)+
	ble.b	.yok22
	move.w	#Height-1,-2(a0)
	rts
.makeno2:	move.l	#$7fff7fff,(a0)+
	move.l	#$80008000,(a0)+
.yok22:
	rts






DrawFaces2:	bsr.w	Init_Line2

	lea	Faces(pc),a0
	lea	Rotated2(pc),a1
	lea	FaceColors(pc),a3

.nextface:
	tst.w	(a0)+
	blt.w	.ud

	move.w	(a0)+,d6	;antal linjer

	move.w	(a3)+,LineCol
	bne.b	.drawit

;	addq.w	#1,d6
	add.w	d6,d6
	add.w	d6,a0
	bra.b	.nextface

.drawit:	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d0
	move.w	2(a1,d7.w),d1

	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d2
	move.w	2(a1,d7.w),d3

	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d4
	move.w	2(a1,d7.w),d5

	Push.w	d0-d1

	Push.w	d0-d5

	movem.w	(sp),d0-d3
	bsr.w	Line_Draw2
	movem.w	4(sp),d0-d3
	bsr.w	Line_Draw2
	addq.w	#8,sp
	movem.w	(sp)+,d0-d1

	subq.w	#3,d6
	bra.b	.jumpin

.lines:	move.w	(a0)+,d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	(a1,d7.w),d2
	move.w	2(a1,d7.w),d3
	Push.w	d2-d3
	bsr.w	Line_Draw2
	Pull.w	d0-d1
.jumpin	dbra	d6,.lines

	Pull.w	d2-d3
	bsr.w	Line_Draw2

	bra.w	.nextface

.ud	rts






*******************************************************************************
**Rotate Points
*******************************************************************************
RotatePoints:
	lea	Points(pc),a5
	lea	Rotated(pc),a6
	lea	SinusTabel(pc),a0
	lea	CosinusTabel(pc),a1

	move.w	ZAngle(pc),d4
	add.w	d4,d4
	move.w	(a0,d4.w),d0
	swap	d0
	move.w	(a1,d4.w),d0
	move.l	d0,a2

	move.w	XAngle(pc),d4
	add.w	d4,d4
	move.w	(a0,d4.w),d0
	swap	d0
	move.w	(a1,d4.w),d0
	move.l	d0,a3

	move.w	YAngle(pc),d4
	add.w	d4,d4
	move.w	(a0,d4.w),d0
	swap	d0
	move.w	(a1,d4.w),d0
	move.l	d0,a4

	lea	Rotated2,a0

.nextpoint:	move.w	(a5)+,d5
	cmp.w	#$8000,d5
	beq.w	.ud
	move.w	(a5)+,d6
	move.w	(a5)+,d7

**Rotation om z-aksen
	move.l	a2,d0
	move.w	d0,d1	;cos
	swap	d0	;sin
	move.w	d0,d2
	add.w	d1,d2	;sin+cos
	muls	d6,d0	;y*sin
	muls	d5,d1	;x*cos
	add.w	d5,d6	;x+y
	move.l	d1,d5
	sub.l	d0,d5
	swap	d5
	add.w	d5,d5
	add.w	d5,d5	;x*cos-y*sin
	muls	d2,d6	;(x+y)*(sin+cos)=x*sin+y*cos+x*cos+y*sin
	sub.l	d0,d6	;x*sin+y*cos+x*cos
	sub.l	d1,d6	;x*sin+y*cos
	swap	d6
	add.w	d6,d6
	add.w	d6,d6

**Rotation om x-aksen
	move.l	a3,d0
	move.w	d0,d1	;cos
	swap	d0	;sin
	move.w	d0,d2
	add.w	d1,d2	;sin+cos
	muls	d6,d0	;y*sin
	muls	d7,d1	;z*cos
	add.w	d7,d6	;z+y
	move.l	d1,d7
	sub.l	d0,d7
	swap	d7
	add.w	d7,d7
	add.w	d7,d7	;z*cos-y*sin
	muls	d2,d6	;(z+y)*(sin+cos)=z*sin+y*cos+z*cos+y*sin
	sub.l	d0,d6	;z*sin+y*cos+z*cos
	sub.l	d1,d6	;z*sin+y*cos
	swap	d6
	add.w	d6,d6
	add.w	d6,d6

**Rotation om y-aksen
	move.l	a4,d0
	move.w	d0,d1	;cos
	swap	d0	;sin
	move.w	d0,d2
	add.w	d1,d2	;sin+cos
	muls	d5,d0	;x*sin
	muls	d7,d1	;z*cos
	add.w	d7,d5	;z+x
	move.l	d1,d7
	sub.l	d0,d7
	swap	d7
	add.w	d7,d7
	add.w	d7,d7	;z*cos-x*sin
	muls	d2,d5	;(z+x)*(sin+cos)=z*sin+x*cos+z*cos+x*sin
	sub.l	d0,d5	;z*sin+x*cos+z*cos
	sub.l	d1,d5	;z*sin+x*cos
	swap	d5
	add.w	d5,d5
	add.w	d5,d5

**3d -> 2d
	add.w	XCenter(pc),d5
	add.w	YCenter(pc),d6
	add.w	ZCenter(pc),d7
	moveq	#9,d4
	ext.l	d5
	ext.l	d6
	asl.l	d4,d5
	asl.l	d4,d6
	divs	d7,d5
	divs	d7,d6

	moveq	#0,d7
	move.w	d5,d0
	move.w	d6,d1
	asr.w	#1,d0
	addx.w	d7,d0
	asr.w	#1,d1
	addx.w	d7,d1
	add.w	#64,d0
	add.w	#64,d1

	add.w	#Width*2/3,d5
	add.w	#Height/2,d6

	movem.w	d5-d6,(a6)
	addq.w	#4,a6
	movem.w	d0-d1,(a0)
	addq.w	#4,a0
	bra.w	.nextpoint

.ud:	rts

fak=15

Points:
	dc.w	-50*fak,-50*fak,-50*fak
	dc.w	50*fak,-50*fak,-50*fak
	dc.w	50*fak,50*fak,-50*fak
	dc.w	-50*fak,50*fak,-50*fak
	dc.w	-50*fak,-50*fak,50*fak
	dc.w	50*fak,-50*fak,50*fak
	dc.w	50*fak,50*fak,50*fak
	dc.w	-50*fak,50*fak,50*fak
	dc.w	$8000

Rotated:	blk.l	8,0
Rotated2:	blk.l	8,0

Faces:
	dc.w	1,4,0,1,2,3
	dc.w	1,4,7,6,5,4
	dc.w	2,4,4,5,1,0
	dc.w	2,4,3,2,6,7
	dc.w	3,4,0,3,7,4
	dc.w	3,4,2,1,5,6
	dc.w	$8000







*******************************************************************************
**Double-buffer
*******************************************************************************
Extra_Screen:	dc.l	Extra_Screen1
Screen:	dc.l	Tand_Screen1
BltCop:	dc.l	BltCopper1
BltCopPtr:	dc.l	BltCopper1
SwapScr:
	move.l	BltCop(pc),d0
	lea	Bltpointer,a0
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)

	lea	Screen(pc),a0
	lea	Tand_Screen1,a1
	lea	Tand_Screen2,a2
	cmp.l	(a0),a1
	beq.b	.scr2
	move.l	a1,(a0)
	move.l	#BltCopper1,BltCop
	move.l	#BltCopper1,BltCopPtr
	bra.b	.dorest
.scr2:	move.l	a2,(a0)
	move.l	#BltCopper2,BltCop
	move.l	#BltCopper2,BltCopPtr
.dorest:
	move.l	Screen(pc),d0
	lea	Bitplaner+4*2,a0
	moveq	#2-1,d1
.loop:	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	add.l	#ByteWidth/2,d0
	addq.w	#8,a0
	dbra	d1,.loop

	move.l	Extra_Screen(pc),d0
	lea	Bitplaner,a0
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)

	rts

*******************************************************************************
**Fill Screen
*******************************************************************************
FillScr:
	cmp.l	#$7fff7fff,MinX1
	beq.w	.bpl2
	move.w	MaxY1(pc),d0
	muls	#ByteWidth,d0
	move.l	d0,a0
	move.w	MaxX1(pc),d1
	lsr.w	#3,d1
	and.w	#$fffe,d1
	add.w	d1,a0
	add.l	Screen(pc),a0	;Pointer
	move.w	MinX1(pc),d0
	lsr.w	#3,d0
	and.w	#$fffe,d0
	move.w	#ByteWidth-2,d2
	sub.w	d1,d2
	add.w	d0,d2
	move.w	d2,d3
	swap	d3
	move.w	d2,d3	;modulo
	move.w	MaxY1(pc),d2
	sub.w	MinY1(pc),d2
	addq.w	#1,d2
	lsl.w	#6,d2
	sub.w	d0,d1
	lsr.w	#1,d1
	addq.w	#1,d1
	or.w	d1,d2	;bltsize

	move.l	a0,d0
	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltaptl,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d0,(a6)+
	swap	d0
	move.w	#Bltapth,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdpth,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	#%0000100111110000,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	#$12,(a6)+
	move.w	#Bltafwm,(a6)+
	move.w	#-1,(a6)+
	move.w	#Bltalwm,(a6)+
	move.w	#-1,(a6)+
	move.w	#Bltdmod,(a6)+
	move.w	d3,(a6)+
	swap	d3
	move.w	#Bltamod,(a6)+
	move.w	d3,(a6)+
	move.w	#Bltsize,(a6)+
	move.w	d2,(a6)+
	move.l	a6,BltCopPtr

.bpl2:
	cmp.l	#$7fff7fff,MinX2
	beq.w	.bpl3
	move.w	MaxY2(pc),d0
	muls	#ByteWidth,d0
	move.l	d0,a0
	move.w	MaxX2(pc),d1
	lsr.w	#3,d1
	and.w	#$fffe,d1
	add.w	d1,a0
	add.l	Screen(pc),a0
	add.w	#ByteWidth/2,a0	;Pointer
	move.w	MinX2(pc),d0
	lsr.w	#3,d0
	and.w	#$fffe,d0
	move.w	#ByteWidth-2,d2
	sub.w	d1,d2
	add.w	d0,d2
	move.w	d2,d3
	swap	d3
	move.w	d2,d3	;modulo
	move.w	MaxY2(pc),d2
	sub.w	MinY2(pc),d2
	addq.w	#1,d2
	lsl.w	#6,d2
	sub.w	d0,d1
	lsr.w	#1,d1
	addq.w	#1,d1
	or.w	d1,d2	;bltsize

	move.l	a0,d0
	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltaptl,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d0,(a6)+
	swap	d0
	move.w	#Bltapth,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdpth,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	#%0000100111110000,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	#$12,(a6)+
	move.w	#Bltafwm,(a6)+
	move.w	#-1,(a6)+
	move.w	#Bltalwm,(a6)+
	move.w	#-1,(a6)+
	move.w	#Bltdmod,(a6)+
	move.w	d3,(a6)+
	swap	d3
	move.w	#Bltamod,(a6)+
	move.w	d3,(a6)+
	move.w	#Bltsize,(a6)+
	move.w	d2,(a6)+
	move.l	a6,BltCopPtr

.bpl3:
	rts






	
MinX1:	dc.w	$7fff
MinY1:	dc.w	$7fff
MaxX1:	dc.w	$8000
MaxY1:	dc.w	$8000
MinX2:	dc.w	$7fff
MinY2:	dc.w	$7fff
MaxX2:	dc.w	$8000
MaxY2:	dc.w	$8000
MinX3:	dc.w	$7fff
MinY3:	dc.w	$7fff
MaxX3:	dc.w	$8000
MaxY3:	dc.w	$8000

	dc.l	$7fff7fff,$80008000
	dc.l	$7fff7fff,$80008000
	dc.l	$7fff7fff,$80008000

	dc.l	$7fff7fff,$80008000
	dc.l	$7fff7fff,$80008000
	dc.l	$7fff7fff,$80008000


*******************************************************************************
**Line routine
**regs used: d0-d5/a0/a6
*******************************************************************************
ByteWidth=44*2
LineCol:	dc.w	0

Init_Line:	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltcmod,(a6)+
	move.w	#ByteWidth,(a6)+
	move.w	#Bltbdat,(a6)+
	move.w	#$ffff,(a6)+
	move.w	#Bltadat,(a6)+
	move.w	#$8000,(a6)+
	move.w	#Bltafwm,(a6)+
	move.w	#-1,(a6)+
	move.w	#Bltalwm,(a6)+
	move.w	#-1,(a6)+
	move.l	a6,BltCopPtr
	rts

Line_Draw:	move.w	LineCol(pc),d7
	btst	#0,d7
	beq.b	.tstbpl2
	lea	MinX1(pc),a2
	cmp.w	(a2)+,d0
	bgt.b	.minxok1
	move.w	d0,-2(a2)
.minxok1:	cmp.w	(a2)+,d1
	bgt.b	.minyok1
	move.w	d1,-2(a2)
.minyok1:	cmp.w	(a2)+,d0
	blt.b	.maxxok1
	move.w	d0,-2(a2)
.maxxok1:	cmp.w	(a2)+,d1
	blt.b	.tstbpl2
	move.w	d1,-2(a2)
.tstbpl2:	btst	#1,d7
	beq.b	.tstbpl3
	lea	MinX2(pc),a2
	cmp.w	(a2)+,d0
	bgt.b	.minxok2
	move.w	d0,-2(a2)
.minxok2:	cmp.w	(a2)+,d1
	bgt.b	.minyok2
	move.w	d1,-2(a2)
.minyok2:	cmp.w	(a2)+,d0
	blt.b	.maxxok2
	move.w	d0,-2(a2)
.maxxok2:	cmp.w	(a2)+,d1
	blt.b	.tstbpl3
	move.w	d1,-2(a2)
.tstbpl3:	btst	#2,d7
	beq.b	.makeline
	lea	MinX3(pc),a2
	cmp.w	(a2)+,d0
	bgt.b	.minxok3
	move.w	d0,-2(a2)
.minxok3:	cmp.w	(a2)+,d1
	bgt.b	.minyok3
	move.w	d1,-2(a2)
.minyok3:	cmp.w	(a2)+,d0
	blt.b	.maxxok3
	move.w	d0,-2(a2)
.maxxok3:	cmp.w	(a2)+,d1
	blt.b	.makeline
	move.w	d1,-2(a2)
.makeline:
	bsr.w	Line_Clip
	beq.w	.out

	cmp.w	d1,d3
	bgt.b	.line1
	exg	d0,d2
	exg	d1,d3
	beq.w	.out
.line1:	move.w	d1,d4
	muls	#ByteWidth,d4
	move.w	d0,d5
	add.l	Screen(pc),d4
	asr.w	#3,d5
	ext.l	d5
	add.l	d5,d4
	moveq	#0,d5
	sub.w	d1,d3
	sub.w	d0,d2
	bpl.s	.line2
	moveq	#1,d5
	neg.w	d2
.line2:	move.w	d3,d1
	add.w	d1,d1
	cmp.w	d2,d1
	dbhi	d3,.line3
.line3:	move.w	d3,d1
	sub.w	d2,d1
	bpl.s	.line4
	exg	d2,d3
.line4:	addx.w	d5,d5
	add.w	d2,d2
	move.w	d2,d1
	sub.w	d3,d2
	addx.w	d5,d5
	and.w	#15,d0
	ror.w	#4,d0
	or.w	#$a4a,d0
	move.w	d2,-(sp)
	sub.w	d3,d2
	lsl.w	#6,d3
	addq.w	#2,d3
	lea	Octants(pc),a2
	move.b	(a2,d5.w),d5
	swap	d1
	move.w	d2,d1
	btst	#0,d7
	beq.b	.bpl2

	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltaptl,(a6)+
	move.w	(sp),(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	d5,(a6)+
	move.w	#Bltcptl,(a6)+
	move.w	d4,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d4,(a6)+
	swap	d4
	move.w	#Bltcpth,(a6)+
	move.w	d4,(a6)+
	move.w	#Bltdpth,(a6)+
	move.w	d4,(a6)+
	swap	d4
	move.w	#Bltamod,(a6)+
	move.w	d1,(a6)+
	swap	d1
	move.w	#Bltbmod,(a6)+
	move.w	d1,(a6)+
	swap	d1
	move.w	#Bltsize,(a6)+
	move.w	d3,(a6)+
	move.l	a6,BltCopPtr
.bpl2:	add.l	#ByteWidth/2,d4
	btst	#1,d7
	beq.b	.bpl3
	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltaptl,(a6)+
	move.w	(sp),(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	d5,(a6)+
	move.w	#Bltcptl,(a6)+
	move.w	d4,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d4,(a6)+
	swap	d4
	move.w	#Bltcpth,(a6)+
	move.w	d4,(a6)+
	move.w	#Bltdpth,(a6)+
	move.w	d4,(a6)+
	swap	d4
	move.w	#Bltamod,(a6)+
	move.w	d1,(a6)+
	swap	d1
	move.w	#Bltbmod,(a6)+
	move.w	d1,(a6)+
	swap	d1
	move.w	#Bltsize,(a6)+
	move.w	d3,(a6)+
	move.l	a6,BltCopPtr
.bpl3:
	addq.w	#2,sp
	tst.w	Clip_Mark
	beq.b	.out
	move.w	#(Width-1),d0
	move.w	Clip_LineY1(pc),d1
	move.w	#(Width-1),d2
	move.w	Clip_LineY2(pc),d3
	bra.w	.makeline
.out:	RTS

Octants:	dc.b	$03,$43,$13,$53,$0b,$4b,$17,$57

Init_Line2:	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltcmod,(a6)+
	move.w	#16*2,(a6)+
	move.w	#Bltbdat,(a6)+
	move.w	#$ffff,(a6)+
	move.w	#Bltadat,(a6)+
	move.w	#$8000,(a6)+
	move.w	#Bltafwm,(a6)+
	move.w	#-1,(a6)+
	move.w	#Bltalwm,(a6)+
	move.w	#-1,(a6)+
	move.l	a6,BltCopPtr
	rts

Line_Draw2:	move.w	LineCol(pc),d7

.makeline
	cmp.w	d1,d3
	bgt.b	.line1
	exg	d0,d2
	exg	d1,d3
	beq.w	.out
.line1:	move.w	d1,d4
	muls	#16*2,d4
	move.w	d0,d5
	add.l	#BetteScreen,d4
	asr.w	#3,d5
	ext.l	d5
	add.l	d5,d4
	moveq	#0,d5
	sub.w	d1,d3
	sub.w	d0,d2
	bpl.s	.line2
	moveq	#1,d5
	neg.w	d2
.line2:	move.w	d3,d1
	add.w	d1,d1
	cmp.w	d2,d1
	dbhi	d3,.line3
.line3:	move.w	d3,d1
	sub.w	d2,d1
	bpl.s	.line4
	exg	d2,d3
.line4:	addx.w	d5,d5
	add.w	d2,d2
	move.w	d2,d1
	sub.w	d3,d2
	addx.w	d5,d5
	and.w	#15,d0
	ror.w	#4,d0
	or.w	#$a4a,d0
	move.w	d2,-(sp)
	sub.w	d3,d2
	lsl.w	#6,d3
	addq.w	#2,d3
	lea	Octants(pc),a2
	move.b	(a2,d5.w),d5
	swap	d1
	move.w	d2,d1
	btst	#0,d7
	beq.b	.bpl2

	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltaptl,(a6)+
	move.w	(sp),(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	d5,(a6)+
	move.w	#Bltcptl,(a6)+
	move.w	d4,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d4,(a6)+
	swap	d4
	move.w	#Bltcpth,(a6)+
	move.w	d4,(a6)+
	move.w	#Bltdpth,(a6)+
	move.w	d4,(a6)+
	swap	d4
	move.w	#Bltamod,(a6)+
	move.w	d1,(a6)+
	swap	d1
	move.w	#Bltbmod,(a6)+
	move.w	d1,(a6)+
	swap	d1
	move.w	#Bltsize,(a6)+
	move.w	d3,(a6)+
	move.l	a6,BltCopPtr
.bpl2:	add.l	#16*2/2,d4
	btst	#1,d7
	beq.b	.bpl3
	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltaptl,(a6)+
	move.w	(sp),(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	d5,(a6)+
	move.w	#Bltcptl,(a6)+
	move.w	d4,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d4,(a6)+
	swap	d4
	move.w	#Bltcpth,(a6)+
	move.w	d4,(a6)+
	move.w	#Bltdpth,(a6)+
	move.w	d4,(a6)+
	swap	d4
	move.w	#Bltamod,(a6)+
	move.w	d1,(a6)+
	swap	d1
	move.w	#Bltbmod,(a6)+
	move.w	d1,(a6)+
	swap	d1
	move.w	#Bltsize,(a6)+
	move.w	d3,(a6)+
	move.l	a6,BltCopPtr
.bpl3:
	addq.w	#2,sp
	tst.w	Clip_Mark
	beq.b	.out
	move.w	#(Width-1),d0
	move.w	Clip_LineY1(pc),d1
	move.w	#(Width-1),d2
	move.w	Clip_LineY2(pc),d3
	bra.w	.makeline
.out:	RTS




*******************************************************************************
**ClipLine routine
**regs used: d0-d5
**input:
**d0: xstart  d1: ystart  d2: xstop  d3: ystop
**output:
**d0: xstart  d1: ystart  d2: xstop  d3: ystop
**d4: 0 if line is not supposed to be drawn
**sr: tst.w d4
*******************************************************************************
Screen_Width:	EQU	352
Screen_Height:	EQU	288
Clip_LineY1:	dc.w	0
Clip_LineY2:	dc.w	0
Clip_Mark:	dc.w	0
Line_Clip:	clr.l	Clip_LineY1
	clr.w	Clip_Mark
.tryagain:	cmp.w	d1,d3
	bge.b	.yturned
	exg	d0,d2
	exg	d1,d3
.yturned:	tst.w	d3
	blt.b	.dontdraw
	cmp.w	#Screen_Height-1,d1
	bgt.b	.dontdraw
	cmp.w	#Screen_Height-1,d3
	bgt.b	.clipdown
	tst.w	d1
	blt.b	.clipup

	cmp.w	d0,d2
	bge.b	.xturned
	exg	d0,d2
	exg	d1,d3
.xturned:	tst.w	d2
	blt.b	.dontdraw
	cmp.w	#Screen_Width-1,d0
	bgt.b	.dontdraw
	tst.w	d0
	blt.b	.clipleft
	cmp.w	#Screen_Width-1,d2
	bgt.b	.clipright

	moveq	#-1,d4	;drawit
	rts
.dontdraw:	moveq	#0,d4	;dontdrawit
	rts

.clipright:	move.w	#Screen_Width-1,d4
	sub.w	d0,d4	;skal ns
	sub.w	d0,d2	;er nu
	move.w	d3,Clip_LineY1
	sub.w	d1,d3
	muls	d4,d3
	divs	d2,d3
	add.w	d1,d3
	move.w	d3,Clip_LineY2
	move.w	#-1,Clip_Mark
	move.w	#Screen_Width-1,d2
	bra.b	.tryagain

.clipleft:		;skal ns=d2
	sub.w	d2,d0
	neg.w	d0	;er nu
	sub.w	d3,d1
	muls	d2,d1
	divs	d0,d1
	add.w	d3,d1
	moveq	#0,d0
	bra.b	.tryagain

.clipdown:	move.w	#Screen_Height-1,d4
	sub.w	d1,d4	;skal ns
	sub.w	d1,d3	;er nu
	sub.w	d0,d2
	muls	d4,d2
	divs	d3,d2
	add.w	d0,d2
	move.w	#Screen_Height-1,d3
	bra.w	.tryagain

.clipup:		;skal ns=d3
	sub.w	d3,d1
	neg.w	d1	;er nu
	sub.w	d2,d0
	muls	d3,d0
	divs	d1,d0
	add.w	d2,d0
	moveq	#0,d1
	bra.w	.tryagain









*******************************************************************************
**Move object
*******************************************************************************
StartPosX:	EQU	9000
StartPosY:	EQU	-3000
StartPosZ:	EQU	30000

StopPosX:	EQU	-3500
StopPosY:	EQU	1500
StopPosZ:	EQU	2000

MovePause:	dc.w	10

MoveObject:
	lea	XAdd(pc),a0
	lea	XAngle(pc),a1
	moveq	#3-1,d1
.loop:	move.w	(a0)+,d0
	add.w	d0,(a1)
	and.w	#1024-1,(a1)+
	dbra	d1,.loop

	rts


XAdd:	dc.w	2
YAdd:	dc.w	1
ZAdd:	dc.w	3

XAngle:	dc.w	0
YAngle:	dc.w	0
ZAngle:	dc.w	0

XCenter:	dc.w	0
YCenter:	dc.w	4000
ZCenter:	dc.w	8000

MoveNumber:	dc.w	0

FaceColors:	blk.w	12,0






*******************************************************************************
**Clear Screen
*******************************************************************************
ClrScr:
	lea	MinX1+48(pc),a1
	lea	MinX1+72(pc),a2
	moveq	#12-1,d0
.moveloop:	move.l	-(a1),-(a2)
	dbra	d0,.moveloop

	lea	MinX1(pc),a0
	move.l	#$7fff7fff,d0
	move.l	#$80008000,d1
	move.l	d0,(a0)+
	move.l	d1,(a0)+
	move.l	d0,(a0)+
	move.l	d1,(a0)+
	move.l	d0,(a0)+
	move.l	d1,(a0)+

	lea	_Custom,a6

	move.w	MinY1+48(pc),d0
	cmp.w	#$7fff,d0
	beq.w	.bpl2
	muls	#ByteWidth,d0
	move.l	d0,a0
	move.w	MinX1+48(pc),d1
	lsr.w	#3,d1
	and.w	#$fffe,d1
	add.w	d1,a0
	add.l	Screen(pc),a0	;Pointer
	move.w	MaxX1+48(pc),d0
	lsr.w	#3,d0
	and.w	#$fffe,d0
	move.w	#ByteWidth-2,d2
	sub.w	d0,d2
	add.w	d1,d2
	move.w	d2,d3
	swap	d3
	move.w	d2,d3	;modulo
	move.w	MaxY1+48(pc),d2
	sub.w	MinY1+48(pc),d2
	addq.w	#1,d2
	lsl.w	#6,d2
	sub.w	d1,d0
	lsr.w	#1,d0
	addq.w	#1,d0
	or.w	d0,d2	;bltsize

	move.l	a0,d0
	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d0,(a6)+
	swap	d0
	move.w	#Bltdpth,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdmod,(a6)+
	move.w	d3,(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	#$0100,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	#$0000,(a6)+
	move.w	#Bltsize,(a6)+
	move.w	d2,(a6)+
	move.l	a6,BltCopPtr

.bpl2:
	move.w	MinY2+48(pc),d0
	cmp.w	#$7fff,d0
	beq.w	.bpl3
	muls	#ByteWidth,d0
	move.l	d0,a0
	move.w	MinX2+48(pc),d1
	lsr.w	#3,d1
	and.w	#$fffe,d1
	add.w	d1,a0
	add.l	Screen(pc),a0
	add.w	#ByteWidth/2,a0	;Pointer
	move.w	MaxX2+48(pc),d0
	lsr.w	#3,d0
	and.w	#$fffe,d0
	move.w	#ByteWidth-2,d2
	sub.w	d0,d2
	add.w	d1,d2
	move.w	d2,d3
	swap	d3
	move.w	d2,d3	;modulo
	move.w	MaxY2+48(pc),d2
	sub.w	MinY2+48(pc),d2
	addq.w	#1,d2
	lsl.w	#6,d2
	sub.w	d1,d0
	lsr.w	#1,d0
	addq.w	#1,d0
	or.w	d0,d2	;bltsize

	move.l	a0,d0
	move.l	BltCopPtr(pc),a6
	move.l	#$01FE0000,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#CopBltWait,(a6)+
	move.l	#$01FE0000,(a6)+
	move.l	#$01FE0000,(a6)+
	move.w	#Bltdptl,(a6)+
	move.w	d0,(a6)+
	swap	d0
	move.w	#Bltdpth,(a6)+
	move.w	d0,(a6)+
	move.w	#Bltdmod,(a6)+
	move.w	d3,(a6)+
	move.w	#Bltcon0,(a6)+
	move.w	#$0100,(a6)+
	move.w	#Bltcon1,(a6)+
	move.w	#$0000,(a6)+
	move.w	#Bltsize,(a6)+
	move.w	d2,(a6)+
	move.l	a6,BltCopPtr

.bpl3:
	rts







*******************************************************************************
**Tabeller
*******************************************************************************
SinusTabel:
;Option n  = 1
;Min. y-val = -3.27680E+04
;Max. y-val =  3.27670E+04
;Startvalue = min
;Length     = 1024
	dc.w	-1,201,402,603,804,1005,1206,1406,1607,1808,2009,2209,2410,2610,2811,3011
	dc.w	3211,3411,3611,3811,4011,4210,4409,4609,4807,5006,5205,5403,5601,5799,5997,6195
	dc.w	6392,6589,6786,6983,7179,7375,7571,7766,7961,8156,8351,8545,8739,8933,9126,9319
	dc.w	9511,9704,9895,10087,10278,10469,10659,10849,11039,11228,11416,11605,11792,11980,12167,12353
	dc.w	12539,12725,12910,13094,13278,13462,13645,13827,14009,14191,14372,14552,14732,14911,15090,15268
	dc.w	15446,15623,15799,15975,16151,16325,16499,16673,16845,17017,17189,17360,17530,17700,17868,18037
	dc.w	18204,18371,18537,18703,18867,19031,19195,19357,19519,19680,19841,20000,20159,20317,20475,20631
	dc.w	20787,20942,21096,21250,21402,21554,21705,21855,22005,22153,22301,22448,22594,22739,22884,23027
	dc.w	23170,23311,23452,23592,23731,23869,24007,24143,24279,24413,24547,24680,24811,24942,25072,25201
	dc.w	25329,25456,25582,25707,25832,25955,26077,26198,26319,26438,26556,26673,26790,26905,27019,27132
	dc.w	27245,27356,27466,27575,27683,27790,27896,28001,28105,28208,28310,28410,28510,28609,28706,28803
	dc.w	28898,28992,29085,29177,29268,29358,29447,29534,29621,29706,29791,29874,29956,30037,30117,30195
	dc.w	30273,30349,30424,30498,30571,30643,30714,30783,30852,30919,30985,31050,31113,31176,31237,31297
	dc.w	31356,31414,31470,31526,31580,31633,31685,31736,31785,31833,31880,31926,31971,32014,32057,32098
	dc.w	32137,32176,32213,32250,32285,32318,32351,32382,32412,32441,32469,32495,32521,32545,32567,32589
	dc.w	32609,32628,32646,32663,32678,32692,32705,32717,32728,32737,32745,32752,32757,32761,32765,32766

CosinusTabel:
;Option n  = 1
;Min. y-val = -3.27680E+04
;Max. y-val =  3.27670E+04
;Startvalue = max
;Length     = 1024
	dc.w	32767,32766,32765,32761,32757,32752,32745,32737,32728,32717,32705,32692,32678,32663,32646,32628
	dc.w	32609,32589,32567,32545,32521,32495,32469,32441,32412,32382,32351,32318,32285,32250,32213,32176
	dc.w	32137,32098,32057,32014,31971,31926,31880,31833,31785,31736,31685,31633,31580,31526,31470,31414
	dc.w	31356,31297,31237,31176,31113,31050,30985,30919,30852,30783,30714,30643,30571,30498,30424,30349
	dc.w	30273,30195,30117,30037,29956,29874,29791,29706,29621,29534,29447,29358,29268,29177,29085,28992
	dc.w	28898,28803,28706,28609,28510,28410,28310,28208,28105,28001,27896,27790,27683,27575,27466,27356
	dc.w	27245,27132,27019,26905,26790,26673,26556,26438,26319,26198,26077,25955,25832,25707,25582,25456
	dc.w	25329,25201,25072,24942,24811,24680,24547,24413,24279,24143,24007,23869,23731,23592,23452,23311
	dc.w	23170,23027,22884,22739,22594,22448,22301,22153,22005,21855,21705,21554,21402,21250,21096,20942
	dc.w	20787,20631,20475,20317,20159,20000,19841,19680,19519,19357,19195,19031,18867,18703,18537,18371
	dc.w	18204,18037,17868,17700,17530,17360,17189,17017,16845,16673,16499,16325,16151,15975,15799,15623
	dc.w	15446,15268,15090,14911,14732,14552,14372,14191,14009,13827,13645,13462,13278,13094,12910,12725
	dc.w	12539,12353,12167,11980,11792,11605,11416,11228,11039,10849,10659,10469,10278,10087,9895,9704
	dc.w	9511,9319,9126,8933,8739,8545,8351,8156,7961,7766,7571,7375,7179,6983,6786,6589
	dc.w	6392,6195,5997,5799,5601,5403,5205,5006,4807,4609,4409,4210,4011,3811,3611,3411
	dc.w	3211,3011,2811,2610,2410,2209,2009,1808,1607,1406,1206,1005,804,603,402,201
	dc.w	-1,-202,-403,-604,-805,-1006,-1207,-1407,-1608,-1809,-2010,-2210,-2411,-2611,-2812,-3012
	dc.w	-3212,-3412,-3612,-3812,-4012,-4211,-4410,-4610,-4808,-5007,-5206,-5404,-5602,-5800,-5998,-6196
	dc.w	-6393,-6590,-6787,-6984,-7180,-7376,-7572,-7767,-7962,-8157,-8352,-8546,-8740,-8934,-9127,-9320
	dc.w	-9512,-9705,-9896,-10088,-10279,-10470,-10660,-10850,-11040,-11229,-11417,-11606,-11793,-11981,-12168,-12354
	dc.w	-12540,-12726,-12911,-13095,-13279,-13463,-13646,-13828,-14010,-14192,-14373,-14553,-14733,-14912,-15091,-15269
	dc.w	-15447,-15624,-15800,-15976,-16152,-16326,-16500,-16674,-16846,-17018,-17190,-17361,-17531,-17701,-17869,-18038
	dc.w	-18205,-18372,-18538,-18704,-18868,-19032,-19196,-19358,-19520,-19681,-19842,-20001,-20160,-20318,-20476,-20632
	dc.w	-20788,-20943,-21097,-21251,-21403,-21555,-21706,-21856,-22006,-22154,-22302,-22449,-22595,-22740,-22885,-23028
	dc.w	-23171,-23312,-23453,-23593,-23732,-23870,-24008,-24144,-24280,-24414,-24548,-24681,-24812,-24943,-25073,-25202
	dc.w	-25330,-25457,-25583,-25708,-25833,-25956,-26078,-26199,-26320,-26439,-26557,-26674,-26791,-26906,-27020,-27133
	dc.w	-27246,-27357,-27467,-27576,-27684,-27791,-27897,-28002,-28106,-28209,-28311,-28411,-28511,-28610,-28707,-28804
	dc.w	-28899,-28993,-29086,-29178,-29269,-29359,-29448,-29535,-29622,-29707,-29792,-29875,-29957,-30038,-30118,-30196
	dc.w	-30274,-30350,-30425,-30499,-30572,-30644,-30715,-30784,-30853,-30920,-30986,-31051,-31114,-31177,-31238,-31298
	dc.w	-31357,-31415,-31471,-31527,-31581,-31634,-31686,-31737,-31786,-31834,-31881,-31927,-31972,-32015,-32058,-32099
	dc.w	-32138,-32177,-32214,-32251,-32286,-32319,-32352,-32383,-32413,-32442,-32470,-32496,-32522,-32546,-32568,-32590
	dc.w	-32610,-32629,-32647,-32664,-32679,-32693,-32706,-32718,-32729,-32738,-32746,-32753,-32758,-32762,-32766,-32767
	dc.w	-32768,-32767,-32766,-32762,-32758,-32753,-32746,-32738,-32729,-32718,-32706,-32693,-32679,-32664,-32647,-32629
	dc.w	-32610,-32590,-32568,-32546,-32522,-32496,-32470,-32442,-32413,-32383,-32352,-32319,-32286,-32251,-32214,-32177
	dc.w	-32138,-32099,-32058,-32015,-31972,-31927,-31881,-31834,-31786,-31737,-31686,-31634,-31581,-31527,-31471,-31415
	dc.w	-31357,-31298,-31238,-31177,-31114,-31051,-30986,-30920,-30853,-30784,-30715,-30644,-30572,-30499,-30425,-30350
	dc.w	-30274,-30196,-30118,-30038,-29957,-29875,-29792,-29707,-29622,-29535,-29448,-29359,-29269,-29178,-29086,-28993
	dc.w	-28899,-28804,-28707,-28610,-28511,-28411,-28311,-28209,-28106,-28002,-27897,-27791,-27684,-27576,-27467,-27357
	dc.w	-27246,-27133,-27020,-26906,-26791,-26674,-26557,-26439,-26320,-26199,-26078,-25956,-25833,-25708,-25583,-25457
	dc.w	-25330,-25202,-25073,-24943,-24812,-24681,-24548,-24414,-24280,-24144,-24008,-23870,-23732,-23593,-23453,-23312
	dc.w	-23171,-23028,-22885,-22740,-22595,-22449,-22302,-22154,-22006,-21856,-21706,-21555,-21403,-21251,-21097,-20943
	dc.w	-20788,-20632,-20476,-20318,-20160,-20001,-19842,-19681,-19520,-19358,-19196,-19032,-18868,-18704,-18538,-18372
	dc.w	-18205,-18038,-17869,-17701,-17531,-17361,-17190,-17018,-16846,-16674,-16500,-16326,-16152,-15976,-15800,-15624
	dc.w	-15447,-15269,-15091,-14912,-14733,-14553,-14373,-14192,-14010,-13828,-13646,-13463,-13279,-13095,-12911,-12726
	dc.w	-12540,-12354,-12168,-11981,-11793,-11606,-11417,-11229,-11040,-10850,-10660,-10470,-10279,-10088,-9896,-9705
	dc.w	-9512,-9320,-9127,-8934,-8740,-8546,-8352,-8157,-7962,-7767,-7572,-7376,-7180,-6984,-6787,-6590
	dc.w	-6393,-6196,-5998,-5800,-5603,-5404,-5206,-5007,-4809,-4610,-4410,-4211,-4012,-3812,-3612,-3412
	dc.w	-3212,-3012,-2812,-2612,-2411,-2210,-2010,-1809,-1608,-1407,-1207,-1006,-805,-604,-403,-202
	dc.w	-1,201,402,603,804,1005,1206,1406,1607,1808,2009,2209,2410,2610,2811,3011
	dc.w	3211,3411,3611,3811,4011,4210,4409,4609,4807,5006,5205,5403,5601,5799,5997,6195
	dc.w	6392,6589,6786,6983,7179,7375,7571,7766,7961,8156,8351,8545,8739,8933,9126,9319
	dc.w	9511,9704,9895,10087,10278,10469,10659,10849,11039,11228,11416,11605,11792,11980,12167,12353
	dc.w	12539,12725,12910,13094,13278,13462,13645,13827,14009,14191,14372,14552,14732,14911,15090,15268
	dc.w	15446,15623,15799,15975,16151,16325,16499,16673,16845,17017,17189,17360,17530,17700,17868,18037
	dc.w	18204,18371,18537,18703,18867,19031,19195,19357,19519,19680,19841,20000,20159,20317,20475,20631
	dc.w	20787,20942,21096,21250,21402,21554,21705,21855,22005,22153,22301,22448,22594,22739,22884,23027
	dc.w	23170,23311,23452,23592,23731,23869,24007,24143,24279,24413,24547,24680,24811,24942,25072,25201
	dc.w	25329,25456,25582,25707,25832,25955,26077,26198,26319,26438,26556,26673,26790,26905,27019,27132
	dc.w	27245,27356,27466,27575,27683,27790,27896,28001,28105,28208,28310,28410,28510,28609,28706,28803
	dc.w	28898,28992,29085,29177,29268,29358,29447,29534,29621,29706,29791,29874,29956,30037,30117,30195
	dc.w	30273,30349,30424,30498,30571,30643,30714,30783,30852,30919,30985,31050,31113,31176,31237,31297
	dc.w	31356,31414,31470,31526,31580,31633,31685,31736,31785,31833,31880,31926,31971,32014,32057,32098
	dc.w	32137,32176,32213,32250,32285,32318,32351,32382,32412,32441,32469,32495,32521,32545,32567,32589
	dc.w	32609,32628,32646,32663,32678,32692,32705,32717,32728,32737,32745,32752,32757,32761,32765,32766














*******************************************************************************
**Og den vildeste copperliste...
*******************************************************************************
	SECTION	Copper,data_c
SunCopper:	dc.w	$1001,$fffe

	dc.w	Diwstrt,$1c71
	dc.w	Bplcon0,$0200
	dc.w	Bplcon2,$0024
	dc.w	Bplcon3,$0c40
	dc.w	Diwstop,$3cd1
	dc.w	Ddfstrt,$0030
	dc.w	Ddfstop,$00d8
	dc.w	Bplcon1,$0000
	dc.w	Bpl1mod,0
	dc.w	Bpl2mod,0

	dc.w	Spr0pth,0,Spr0ptl,0
	dc.w	Spr1pth,0,Spr1ptl,0
	dc.w	Spr2pth,0,Spr2ptl,0
	dc.w	Spr3pth,0,Spr3ptl,0
	dc.w	Spr4pth,0,Spr4ptl,0
	dc.w	Spr5pth,0,Spr5ptl,0
	dc.w	Spr6pth,0,Spr6ptl,0
	dc.w	Spr7pth,0,Spr7ptl,0

	dc.w	$106,$0c40

FadeCopper:	dc.w	Color00,$000	;000
	dc.w	Color01,$000	;001

	IFEQ	AGA-1
	dc.w	$106,$0e40

	dc.w	Color00,$000	;000
	dc.w	Color01,$000	;001
	ENDC

	dc.l	-2
	dc.l	-2



BlackCopper:	dc.w	$1001,$fffe

	dc.w	Diwstrt,$1c71
	dc.w	Bplcon0,$1200
	dc.w	Bplcon2,$0024
	dc.w	Bplcon3,$0c40
	dc.w	Diwstop,$3cd1
	dc.w	Ddfstrt,$0030
	dc.w	Ddfstop,$00d8
	dc.w	Bplcon1,$0000
	dc.w	Bpl1mod,0
	dc.w	Bpl2mod,0

	dc.w	Spr0pth,0,Spr0ptl,0
	dc.w	Spr1pth,0,Spr1ptl,0
	dc.w	Spr2pth,0,Spr2ptl,0
	dc.w	Spr3pth,0,Spr3ptl,0
	dc.w	Spr4pth,0,Spr4ptl,0
	dc.w	Spr5pth,0,Spr5ptl,0
	dc.w	Spr6pth,0,Spr6ptl,0
	dc.w	Spr7pth,0,Spr7ptl,0

Copper_PlanePtr2:	dc.w	Bpl1pth,0,Bpl1ptl,0

	dc.w	$106,$0c40

	dc.w	Color00,BckCol	;000
	dc.w	Color01,$fff	;001

	IFEQ	AGA-1
	dc.w	$106,$0e40

	dc.w	Color00,$000	;000
	dc.w	Color01,$000	;001
	ENDC

	dc.l	-2
	dc.l	-2



Copper:	dc.w	$1001,$fffe

	dc.w	Diwstrt,$1c71
	dc.w	Diwstop,$3cd1
	dc.w	Ddfstrt,$0030
	dc.w	Ddfstop,$00d8

	dc.w	Spr0pth,$0000,Spr0ptl,$0000
	dc.w	Spr1pth,$0000,Spr1ptl,$0000
	dc.w	Spr2pth,$0000,Spr2ptl,$0000
	dc.w	Spr3pth,$0000,Spr3ptl,$0000
	dc.w	Spr4pth,$0000,Spr4ptl,$0000
	dc.w	Spr5pth,$0000,Spr5ptl,$0000
	dc.w	Spr6pth,$0000,Spr6ptl,$0000
	dc.w	Spr7pth,$0000,Spr7ptl,$0000

	dc.w	Bpl1mod,ByteWidth-44,Bpl2mod,0

	dc.w	$100,$201
	dc.w	$106,$0c40

CopColors:	dc.w	Color00,BckCol	;000
	dc.w	Color01,BckCol	;001
	dc.w	Color02,TandCol	;010
	dc.w	Color03,TandCol	;011
	dc.w	Color04,BckCol	;100
	dc.w	Color05,BckCol	;101
	dc.w	Color06,TandCol	;110
	dc.w	Color07,TandCol	;111


	dc.w	Color08,$fff,Color09,$fff,Color10,$fff,Color11,$fff
	dc.w	Color12,$fff,Color13,$fff,Color14,$fff,Color15,$fff


	IFEQ	AGA-1
	dc.w	$106,$0e40

CopColorsAga:	dc.w	Color00,$000	;000
	dc.w	Color01,$000	;001
	dc.w	Color02,$000	;010
	dc.w	Color03,$000	;011
	dc.w	Color04,$000	;100
	dc.w	Color05,$000	;101
	dc.w	Color06,$000	;110
	dc.w	Color07,$000	;111

	dc.w	Color08,0,Color09,0,Color10,0,Color11,0
	dc.w	Color12,0,Color13,0,Color14,0,Color15,0
	ENDC


Bitplaner:	dc.w	Bpl2pth,0
	dc.w	Bpl2ptl,0
	dc.w	Bpl1pth,0
	dc.w	Bpl1ptl,0
	dc.w	Bpl3pth,0
	dc.w	Bpl3ptl,0

TextPlan:	dc.w	Bpl4pth,0
	dc.w	Bpl4ptl,0

	dc.w	Bplcon0,$4201
	dc.w	Bplcon1,$0000
	dc.w	Bplcon2,$0024

	dc.w	$106,$0e40

Bltpointer:	dc.w	Cop2lch,0
	dc.w	Cop2lcl,0
	dc.w	Copjmp2,$1992







WriterCopper:	dc.w	$1001,$fffe
	dc.w	Bplcon0,$0201
	dc.w	Bplcon1,$0000
	dc.w	Bplcon2,$0024
	dc.w	Bplcon3,$0c40

	dc.w	Spr0pth,0,Spr0ptl,0
	dc.w	Spr1pth,0,Spr1ptl,0
	dc.w	Spr2pth,0,Spr2ptl,0
	dc.w	Spr3pth,0,Spr3ptl,0
	dc.w	Spr4pth,0,Spr4ptl,0
	dc.w	Spr5pth,0,Spr5ptl,0
	dc.w	Spr6pth,0,Spr6ptl,0
	dc.w	Spr7pth,0,Spr7ptl,0

	dc.w	$106,$0c40

	dc.w	Color00,BckCol
	dc.w	Color01,$fff
	dc.w	Color02,TandCol
	dc.w	Color03,$fff

	IFEQ	AGA-1
	dc.w	$106,$0e40

	dc.w	Color00,$000	;000
	dc.w	Color01,$000	;001
	dc.w	Color02,$000	;010
	dc.w	Color03,$000	;011
	ENDC

Copper_PlanePtr:	dc.w	Bpl1pth,0,Bpl1ptl,0

	dc.w	Diwstrt,$1c71
	dc.w	Bplcon0,$1200
	dc.w	Bplcon2,$0024
	dc.w	Bplcon3,$0c40
	dc.w	Diwstop,$3cd1
	dc.w	Ddfstrt,$0030
	dc.w	Ddfstop,$00d8
	dc.w	Bplcon1,$0000
	dc.w	Bpl1mod,88-44
	dc.w	Bpl2mod,0

	dc.w	$0001,$7ffe		;WaitBlt
CopBlit1:	dc.w	Bltdpth,0,Bltdptl,0
	dc.w	Bltcon0,$0100,Bltcon1,$0000
	dc.w	Bltdmod,88-44
	dc.w	Bltsize,288<<6!22

	dc.w	$0001,$7ffe		;WaitBlt
	dc.w	Bltcon1,$0000
	dc.w	Bltamod,-2
	dc.w	Bltcmod,88-46
	dc.w	Bltdmod,88-46
	dc.w	Bltafwm,-1
	dc.w	Bltalwm,0

BlitCopPtr:	dc.w	Cop2lch,0
	dc.w	Cop2lcl,0
	dc.w	Copjmp2,0

	dc.l	-2
	dc.l	-2


*******************************************************************************
**Screens+Gfx
*******************************************************************************
	INCDIR	Work:Code/Sources/HTSAC/PlaneWriter/
PlaneFont:	INCBIN	Planefont.raw

	SECTION	Gfx,bss_c
Clear:
FontScreen:	ds.b	288*44
Screen1:	ds.b	288*88
Screen2:	ds.b	288*88

Tand_Screen1:	EQU	Screen1
Tand_Screen2:	EQU	Tand_Screen1+288*44*2

Extra_Screen1:	ds.b	288*44*4

BetteScreen:	ds.b	16*2*128

BltCopper1:	ds.l	9*240+3+200
BltCopper2:	ds.l	9*240+3+200

TheEnd:

	SECTION	Other,bss

Muls80Tab:	ds.w	288
MegaMulsTable:	ds.w	64*2*256
BltPtr:	ds.l	1






	IF	Track=0
	PRINTT	`ASM-ONE VERSION`
	ELSE
	PRINTT	`TRACK VERSION`
	ENDC
	PRINTT

*******************************************************************************
**Hardware registers
*******************************************************************************
Bltddat=$000
Dmaconr=$002
Vposr=$004
Vhposr=$006
Dskdatr=$008
Joy0dat=$00a
Joy1dat=$00c
Clxdat=$00e
Adkconr=$010
Pot0dat=$012
Pot1dat=$014
Potgor=$016
Serdatr=$018
Dskbytr=$01a
Intenar=$01c
Intreqr=$01e
Dskpth=$020
Dskptl=$022
Dsklen=$024
Dskdat=$026
Refptr=$028
Vposw=$02a
Vhposw=$02c
Copcon=$02e
Serdat=$030
Serper=$032
Potgo=$034
Joytest=$036
Strequ=$038
Strvbl=$03a
Strhor=$03c
Strlong=$03e
Bltcon0=$040
Bltcon1=$042
Bltafwm=$044
Bltalwm=$046
Bltcpth=$048
Bltcptl=$04a
Bltbpth=$04c
Bltbptl=$04e
Bltapth=$050
Bltaptl=$052
Bltdpth=$054
Bltdptl=$056
Bltsize=$058
Bltcmod=$060
Bltbmod=$062
Bltamod=$064
Bltdmod=$066
Bltcdat=$070
Bltbdat=$072
Bltadat=$074
Dsksync=$07e
Cop1lch=$080
Cop1lcl=$082
Cop2lch=$084
Cop2lcl=$086
Copjmp1=$088
Copjmp2=$08a
Copins=$08c
Diwstrt=$08e
Diwstop=$090
Ddfstrt=$092
Ddfstop=$094
Dmacon=$096
Clxcon=$98
Intena=$09a
Intreq=$09c
Adkcon=$09e
Aud0dat=$0aa
Aud1dat=$0ba
Aud2dat=$0ca
Aud3dat=$0da
Aud0lch=$0a0
Aud1lch=$0b0
Aud2lch=$0c0
Aud3lch=$0d0
Aud0len=$0a4
Aud1len=$0b4
Aud2len=$0c4
Aud3len=$0d4
Aud0per=$0a6
Aud1per=$0b6
Aud2per=$0c6
Aud3per=$0d6
Aud0vol=$0a8
Aud1vol=$0b8
Aud2vol=$0c8
Aud3vol=$0d8
Aud0lcl=$0a2
Aud1lcl=$0b2
Aud2lcl=$0c2
Aud3lcl=$0d2
Bpl1pth=$0e0
Bpl1ptl=$0e2
Bpl2pth=$0e4
Bpl2ptl=$0e6
Bpl3pth=$0e8
Bpl3ptl=$0ea
Bpl4pth=$0ec
Bpl4ptl=$0ee
Bpl5pth=$0f0
Bpl5ptl=$0f2
Bpl6pth=$0f4
Bpl6ptl=$0f6
Bplcon0=$100
Bplcon1=$102
Bplcon2=$104
Bplcon3=$106
Bpl1mod=$108
Bpl2mod=$10a
Bpl1dat=$110
Bpl2dat=$112
Bpl3dat=$114
Bpl4dat=$116
Bpl5dat=$118
Bpl6dat=$11a
Spr0pth=$120
Spr0ptl=$122
Spr1pth=$124
Spr1ptl=$126
Spr2pth=$128
Spr2ptl=$12a
Spr3pth=$12c
Spr3ptl=$12e
Spr4pth=$130
Spr4ptl=$132
Spr5pth=$134
Spr5ptl=$136
Spr6pth=$138
Spr6ptl=$13a
Spr7pth=$13c
Spr7ptl=$13e
Spr0pos=$140
Spr0ctl=$142
Spr0data=$144
Spr0datb=$146
Spr1pos=$148
Spr1ctl=$14a
Spr1data=$14c
Spr1datb=$14e
Spr2pos=$150
Spr2ctl=$152
Spr2data=$154
Spr2datb=$156
Spr3pos=$158
Spr3ctl=$15a
Spr3data=$15c
Spr3datb=$15e
Spr4pos=$160
Spr4ctl=$162
Spr4data=$164
Spr4datb=$166
Spr5pos=$168
Spr5ctl=$16a
Spr5data=$16c
Spr5datb=$16e
Spr6pos=$170
Spr6ctl=$172
Spr6data=$174
Spr6datb=$176
Spr7pos=$178
Spr7ctl=$17a
Spr7data=$17c
Spr7datb=$17e
Color00=$180
Color01=$182
Color02=$184
Color03=$186
Color04=$188
Color05=$18a
Color06=$18c
Color07=$18e
Color08=$190
Color09=$192
Color10=$194
Color11=$196
Color12=$198
Color13=$19a
Color14=$19c
Color15=$19e
Color16=$1a0
Color17=$1a2
Color18=$1a4
Color19=$1a6
Color20=$1a8
Color21=$1aa
Color22=$1ac
Color23=$1ae
Color24=$1b0
Color25=$1b2
Color26=$1b4
Color27=$1b6
Color28=$1b8
Color29=$1ba
Color30=$1bc
Color31=$1be
_Custom=$dff000

*******************************************************************************
**Interrupt addresses
*******************************************************************************
Lev1Base=$64
Lev2Base=$68
Lev3Base=$6c
Lev4Base=$70
Lev5Base=$74
Lev6Base=$78
Lev7Base=$7c
Trap0=$80

