  Yȯw  Y  گ  گ  گȯw  گ  گ;---------------T----------T--------------------T
DISKNR:	macro
	dc.b	"00"
	endm

>-----------------------------------------------------------------------------<
>
>
>
>
>
>
>
>-----------------------------------------------------------------------------<

 Config code 

	JumpPtr	Begin

	incdir	ass_incl:
	include	Hardware.i
	include	DivMacros.i

	AUTO	ws\$70100\2\(theend-begin+511)/512\
	printt	"Loader size:"
	printv	theend-begin
	org	$100
	load	$70100
 Int and Dma Enable bits 

My_IntEna = %1100000000100000
;            |||||||||||||||| Lev
;            |||||||||||||||+- 1 TBE     Transmit Buffer Empty
;            ||||||||||||||+-- 1 DSKBLK  DiSK BLocK Finished
;            |||||||||||||+--- 1 SOFT    SOFTware interrupt
;            ||||||||||||+---- 2 PORTS   I/O PORTS and timers
;            |||||||||||+----- 3 COPER   Copper 
;            ||||||||||+----- 3 VERTB   VERTical Blanking 
;            |||||||||+------- 3 BLIT    BLITte finished
;            |||||++++-------- 4 AUDx    AUDio channel x finished (3-0)
;            ||||+------------ 5 RBF     Resiver Buffer Full
;            |||+------------- 5 DSKSYN  DiSK SYNc
;            ||+-------------- 6 EXTER   EXTERnal interrupt
;            |+---------------   INTEN   Master interrupt (enable, only)
;            +----------------   SET/CLR Control bit

My_DmaCon = %1000011111110000
;            |||  |||||||||||
;            |||  |||||||++++-   AUDxEN  AUDio channel x able (3-0)
;            |||  ||||||+-----   DSKEN   DISK dma ENable 
;            |||  |||||+------   SPREN   Sprite dma ENable 
;            |||  ||||+-------   BLTEN   BLiTter dma ENable 
;            |||  |||+--------   COPEN   COPper dma ENable 
;            |||  ||+---------   BPLEN   Bit PLane dma ENable
;            |||  |+----------   DMAEN   ENable aLL DMA below
;            |||  +-----------   BLTPRI  BLItter dma PRIority (1=blitter nasty)
;            ||+--------------   BZERO   Blitter logic ZErO status bit 
;            |+---------------   BBUSY   Blitter BUSY status byte
;            +----------------   SET/CLR control bit


 INIT! 

Begin:	pea	BeginSuper(pc)
	move.l	(a7)+,$80.w
	Trap	#0

BeginSuper:	lea	UserStack,a7
>-----------------------------------------------------------------------------<
	lea	base,a6
	move.w	#$7FFF,DmaCon(a6)
	move.w	#$7FFF,IntEna(a6)
	clr.l	0.w
	clr.l	4.w
	move.w	#$20,$1DC(a6)	;change to pal
	bsr	SetUpFunkyGuru
>-----------------------------------------------------------------------------<

	move.l	#TheEnd2,(ResChipBuffer).w
	move.l	#TD_CodeBuf,(ResChipBuffer+4).w

	moveq	#-1,d0
	moveq	#0,d1
	move.l	d0,$240000
	cmp.l	$240000,d0
	bne.b	.No20Ram
	move.l	d1,$240000
	cmp.l	$240000,d1
	bne.b	.No20Ram
	move.l	#$200000,(ResMixMBuffer).w
	move.l	#$280000,(ResMixMBuffer+4).w
	bra.b	.MemOk
.No20Ram
	move.l	d0,$c40000
	cmp.l	$c40000,d0
	bne.b	.NoC0Ram
	move.l	d1,$c40000
	cmp.l	$c40000,d1
	bne.b	.NoC0Ram
	move.l	#$C00000,(ResMixMBuffer).w
	move.l	#$C80000,(ResMixMBuffer+4).w
	bra.b	.MemOk
.NoC0Ram
	move.l	d1,$40000
	move.l	d0,$C0000
	cmp.l	$40000,d0
	beq.b	.No80Ram
	cmp.l	$c0000,d0
	bne.b	.No80Ram
	move.l	#$80000,(ResMixMBuffer).w
	move.l	#$100000,(ResMixMBuffer+4).w
	bra.b	.MemOk

.No80Ram	bsr	CopyDecrunch2
	move.l	#UserStack-1024-(512*11),(TD_DosBuf).w
	move.l	#TheEnd,(ModuleLoadMem).w
	bra.w	ShowNeed1MB


.MemOk	move.l	(ResMixMBuffer).w,d0
	move.l	d0,(PPDecrunchAdd).w
	add.l	#PPDecrunchLen,d0
	move.l	d0,(TD_DosBuf).w
	add.l	#11*512,d0
	move.l	d0,(ResMixMBuffer).w

	bsr.w	CopyDecrunch

	btst	#6,$bfe001
	bne.b	.NoSelector

	move.l	(ResMixMBuffer).w,(ModuleLoadMem).w
	bra.w	MusicSelector

.NoSelector
	
>-----------------------------------------------------------------------------<
	move.l	#My_Irq3,$6c.w
	move.w	#My_DmaCon,DmaCon(a6)
	move.w	#My_IntEna,IntEna(a6)
	bra.w	TestLoad

 Lev 3 Irq 
My_Irq3:	Push	d0-a6
	btst	#5,Intreqr+1+Base
	beq.w	.Out
>-----------------------------------------------------------------------------<
	move.l	(CopperP).w,Cop1Lch(a6)
	clr.w	CopJmp1(a6)
	move.w	#0,CopCon(a6)

	tst.w	Sherloc
	beq.b	.NoSherloc
	move.w	(SherlocC).w,d0
	addq.w	#1,(SherlocC).w
	sub.w	#15,d0
	bpl.b	.NoFadeGodUp
	sub.w	#$111,(GodCol+2).w
	bra.b	.NoSherloc
.NoFadeGodUp
	sub.w	#60,d0
	bpl.b	.NoWait1
	bra.b	.NoSherloc
.NoWait1
	sub.w	#15,d0
	bpl.b	.NoSherlocUp
	sub.w	#$111,(NoShitCol+2).w
	bra.b	.NoSherloc
.NoSherlocUp
	sub.w	#30,d0
	bpl.b	.NoWait3
	bra.b	.NoSherloc
.NoWait3
	sub.w	#15,d0
	bpl.b	.NoSherlocDown
	add.w	#$111,(NoShitCol+2).w
	bra.b	.NoSherloc
.NoSherlocDown
	sub.w	#120,d0
	bpl.b	.NoWait4
	bra.b	.NoSherloc
.NoWait4
	sub.w	#15,d0
	bpl.b	.NoFadeDown
	add.w	#$111,(GodCol+2).w
	bra.b	.NoSherloc
.NoFadeDown	move.w	#0,Sherloc
	
.NoSherloc
>-----------------------------------------------------------------------------<
	move.w	#$0020,IntReq+Base
.Out	pull	d0-a6
	rte

Sherloc:	dc.w	0
SherlocC:	dc.w	0

CopperP:	dc.l	BlackCopper

 Test TD rutiner 

TestLoad:	;move.l	#FileName,TD_FileName
	;move.l	#MusicData-32,TD_FileAdd
	;bsr	ReadFile
	;tst.w	TD_ErrorCode
	;bne.b	.ReadError

	lea	Base,a6
	lea	$BFD100,a5
	bsr.w	TD_Init
	bsr.w	TD_MotorOn
	bsr.w	TD_SeekZero

	lea	(SpreadEnd).w,a0
	lea	$70000,a3
	lea	(SpreadLogo+4).w,a5
	lea	$DFF180,a6
	bsr.w	Decrunch

	move.l	#SpreadCopper,(CopperP).w
	move.l	(CopperP).w,Cop1Lch(a6)
	clr.w	CopJmp1(a6)
	move.w	#0,CopCon(a6)

	lea	Base,a6
	lea	$BFD100,a5

	bsr.w	ReadFirstModule
	bsr.w	ReadMegaSinTab
	bsr.w	ReadIntroCode

	move.l	(Modul1Add).w,$80.w
	add.l	#32,$80.w
	move.l	#ReadTunnel,$84.w
	move.l	(SinTabAdd).w,$88.w
	add.l	#32,$88.w

	move.l	#BlackCopper,(CopperP).w
	move.l	(CopperP).w,Cop1Lch(a6)
	clr.w	CopJmp1(a6)
	move.w	#0,CopCon(a6)

	move.l	(DeHunket1Add).w,a0
	move.l	(a0),a0
	jsr	(a0)	; start intro

	move.l	#BlackCopper,(CopperP).w
	move.l	(CopperP).w,Cop1Lch(a6)
	clr.w	CopJmp1(a6)
	move.w	#0,CopCon(a6)

	bsr.w	AntiReadMegaSinTab
	bsr.w	FreeIntroCode
	bsr.w	FreeFirstModule
	bsr.w	DeHunkTunnelCode

	move.l	(Modul2Add).w,$80.w
	add.l	#32,$80.w
	move.l	#ReadPopPart,$84.w
	move.l	(DeHunket2Add).w,a0
	move.l	(a0),a0
	jsr	(a0)	; start tunnel

	;lea	base,a6
	;waitblit

	bsr.w	FreeTunnelCode
	bsr.w	FreeSecModule
	bsr.w	DeHunkPopCode

	move.l	(Modul3Add).w,$80.w
	add.l	#32,$80.w
	move.l	#ReadBuddha,$84.w
	move.l	(DeHunket3Add).w,a0
	move.l	(a0),a0
	;lea	base,a6
	;waitblit
	jsr	(a0)	; start tunnel

	move.l	#GodSherlocCopper,(CopperP).w
	bsr.w	ReadSherloc
	move.l	(CopperP).w,Cop1Lch(a6)
	clr.w	CopJmp1(a6)
	move.w	#0,CopCon(a6)
	move.w	#1,(Sherloc).w

	move.w	#My_DmaCon,DmaCon(a6)
	move.w	#My_IntEna,IntEna(a6)
	lea	base,a6
	waitblit
	bsr.w	FreePopCode
	bsr.w	Free3rdModule

	bsr.w	DeCrunch4thModule
	bsr.w	DeCrunchSinTab
	bsr.w	DeHunkBuddhaCode
	bsr	FreeSherloc

	move.l	(Modul4Add2).w,$80.w
	move.l	#ReadCredits,$84.w
	move.l	(SinTabAdd2).w,$88.w
	move.l	(DeHunket4Add).w,a0
	move.l	(a0),a0
	jsr	(a0)	; start intro

	lea	base,a6
	move.l	#BlackCopper,(CopperP).w
	move.l	(CopperP).w,Cop1Lch(a6)
	move.w	d0,CopJmp1(a6)
	move.w	#0,CopCon(a6)


	bsr.w	AntiReadMegaSinTab2
	bsr.w	Free4thMusic
	bsr.w	FreeBuddha
	bsr.w	Copy5thToChip

	lea	Base,a6
	lea	$BFD100,a5
	bsr.w	ReadCreditsCode	; to fast

	bsr.w	DeJohnCredits

	move.l	(Modul5Add).w,$80.w
	add.l	#32,$80.w
	move.l	(DeHunket5Add).w,a0
	move.l	(a0),a0
	jmp	(a0)	; start intro


.ReadError

PANIC_NOMEM:	illegal

ReadSherloc:	
	moveq	#%00,d1	; dont clear + fast
	move.l	#32+3280,d0
	bsr.w	AllocMem
	tst.l	d0
	beq.b	PANIC_NOMEM
	move.l	d0,(GodAdd).w
	move.w	#60,d0
	move.w	#3,d1
	move.l	(GodAdd).w,a0
	bsr.w	TD_ReadSectors
	move.l	(GodAdd).w,a0
	add.l	#1204,a0	; end of pp obj
	move.l	(GodAdd).w,a3	; decrunch add
	add.l	#32,a3
	move.l	(GodAdd).w,a5
	add.l	#4,a5	; start of pp obj
	bsr.w	Decrunch

	moveq	#%00,d1	; dont clear + fast
	move.l	#32+1760,d0
	bsr.w	AllocMem
	tst.l	d0
	beq.b	PANIC_NOMEM
	move.l	d0,(ShitAdd).w
	move.w	#58,d0
	move.w	#1,d1
	move.l	(ShitAdd).w,a0
	bsr.w	TD_ReadSectors
	move.l	(ShitAdd).w,a0
	add.l	#480,a0	; end of pp obj
	move.l	(ShitAdd).w,a3	; decrunch add
	add.l	#32,a3
	move.l	(ShitAdd).w,a5
	add.l	#4,a5	; start of pp obj
	bsr.w	Decrunch

	move.l	(GodAdd).w,d0
	add.l	#32,d0
	lea	(GodBpl).w,a0
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	move.l	(ShitAdd).w,d0
	add.l	#32,d0
	lea	(NoShitBpl).w,a0
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	rts
FreeSherloc:		move.l	(GodAdd).w,d0
	move.l	#32+3280,d1
	bsr.w	FreeMem
	move.l	(ShitAdd).w,d0
	move.l	#32+1760,d1
	bsr.w	FreeMem
	rts
GodAdd:	dc.l	0
ShitAdd:	dc.l	0


; DO THIS WHILE SHOWING INTRO
ReadTunnel:	lea	Base,a6
	lea	$BFD100,a5
	bsr.w	ReadSecModule
	lea	Base,a6
	lea	$BFD100,a5
	bsr.w	ReadTunnelCode
	rts

; DO THIS WHILE TUNNEL!
ReadPopPart:	lea	Base,a6
	lea	$BFD100,a5
	bsr.w	Read3rdModule
	lea	Base,a6
	lea	$BFD100,a5
	bsr.w	ReadPopCode
	rts

; DO THIS WHILE POPPING!
ReadBuddha:	lea	Base,a6
	lea	$BFD100,a5
	bsr.w	Read4thModule	; to fast
	lea	Base,a6
	lea	$BFD100,a5
	bsr.w	ReadBuddhaCode	; to fast
	lea	Base,a6
	lea	$BFD100,a5
	bsr.w	ReadMegaSinTab2
	rts

; DO THIS WHILE FLYING
ReadCredits:	lea	Base,a6
	lea	$BFD100,a5
	bsr.w	Read5thModule	; to fast
	rts



MoveToFast:	

Free4thMusic:	move.l	(Modul4Add2).w,d0
	move.l	#206200,d1	; size
	bsr.w	FreeMem
	rts
DeCrunch4thModule:
	moveq	#%00,d1	; dont clear + fast
	move.l	#206200,d0
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Modul4Add2).w
	move.l	(Modul4Add).w,a0
	add.l	#173632,a0	; end of pp obj
	move.l	(Modul4Add2).w,a3	; decrunch add
	move.l	(Modul4Add).w,a5
	add.l	#4,a5	; start of pp obj
	lea	$DFF180,a6
	bsr.w	Decrunch
	move.l	(Modul4Add2).w,a0
	move.l	#206200-2,d0	; size
	bsr.w	DeltaDePacker
	move.l	(Modul4Add).w,d0	; add
	move.l	#173632,d1	; size
	bsr.w	FreeMem
	rts
Modul4Add2:	dc.l	0
DeCrunchSinTab:	move.l	#25616,d0	; size
	moveq	#%01,d1	; dont clear + fast
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(SinTabAdd2).w
	move.l	(SinTabAdd).w,a0
	add.l	#3368,a0	; end of pp obj
	move.l	(SinTabAdd2).w,a3	; decrunch add
	move.l	(SinTabAdd).w,a5
	add.l	#4,a5	; start of pp obj
	lea	$DFF180,a6
	bsr.w	Decrunch

	move.l	(SinTabAdd2).w,a0
	move.l	#(25616/2)-2,d0	; size
	bsr.w	DeltaDePackerWord

	move.l	(SinTabAdd).w,d0	; add
	move.l	#3368,d1	; size
	bsr.w	FreeMem
	rts
SinTabAdd2:	dc.l	0






FreeFirstModule:
	move.l	(Modul1Add).w,d0	; add
	move.l	#32+294694,d1	; size
	bsr.w	FreeMem
	rts
ReadFirstModule:
; ALLOC MEM FOR FIRST MODULE
	move.l	#32+294694,d0	; size
	moveq	#%00,d1	; chip + dont clear
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Modul1Add).w
; READ FIRST MODULE
	move.w	#354,d0
	move.w	#366,d1
	move.l	(Modul1Add).w,a0
	bsr.w	TD_ReadSectors
; PP DEPACK FIRST MODULE
	move.l	(Modul1Add).w,a0
	add.l	#187336,a0	; end of pp obj
	move.l	(Modul1Add).w,a3	; decrunch add
	add.l	#32,a3
	move.l	(Modul1Add).w,a5
	add.l	#4,a5	; start of pp obj
	lea	$DFF180,a6
	bsr.w	Decrunch
	lea	Base,a6
	lea	$BFD100,a5
; DELTA DEPACK FIRST MODULE
	move.l	(Modul1Add).w,a0
	add.l	#32,a0
	move.l	#294694-2,d0	; size
	bsr.w	DeltaDePacker
	rts	
Modul1Add:	dc.l	0




FreeSecModule:
	move.l	(Modul2Add).w,d0	; add
	move.l	#32+65190,d1	; size
	bsr.w	FreeMem
	rts
ReadSecModule:
; ALLOC MEM FOR 2nd MODULE
	move.l	#32+65190,d0	; size
	moveq	#%00,d1	; chip + dont clear
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Modul2Add).w
; READ FIRST MODULE
	move.w	#1665,d0
	move.w	#94,d1
	move.l	(Modul2Add).w,a0
	bsr.w	TD_ReadSectors
; PP DEPACK FIRST MODULE
	move.l	(Modul2Add).w,a0
	add.l	#47972,a0	; end of pp obj
	move.l	(Modul2Add).w,a3	; decrunch add
	add.l	#32,a3
	move.l	(Modul2Add).w,a5
	add.l	#4,a5	; start of pp obj
	lea	$DFF180,a6
	bsr.w	Decrunch
	lea	Base,a6
	lea	$BFD100,a5
; DELTA DEPACK FIRST MODULE
	move.l	(Modul2Add).w,a0
	add.l	#32,a0
	move.l	#65192-2,d0	; size
	bsr.w	DeltaDePacker
	rts	
Modul2Add:	dc.l	0



Free3rdModule:
	move.l	(Modul3Add).w,d0	; add
	move.l	#32+129828,d1	; size
	bsr.w	FreeMem
	rts
Read3rdModule:
; ALLOC MEM FOR 3rd MODULE
	move.l	#32+129828,d0	; size
	moveq	#%00,d1	; chip + dont clear
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Modul3Add).w

; READ MODULE
	move.w	#1171,d0
	move.w	#152,d1	;152,d1
	move.l	(Modul3Add).w,a0
	bsr.w	TD_ReadSectors

; PP DEPACK MODULE
	move.l	(Modul3Add).w,a0
	add.l	#77708,a0	; end of pp obj
	move.l	(Modul3Add).w,a3	; decrunch add
	add.l	#32,a3
	move.l	(Modul3Add).w,a5
	add.l	#4,a5	; start of pp obj
	lea	$DFF180,a6
	bsr.w	Decrunch
	lea	Base,a6
	lea	$BFD100,a5
; DELTA DEPACK MODULE
	move.l	(Modul3Add).w,a0
	add.l	#32,a0
	move.l	#129828-2,d0	; size
	bsr.w	DeltaDePacker

	rts	
Modul3Add:	dc.l	0




Read5thModule:
; ALLOC MEM FOR 3rd MODULE
	move.l	#32+317500,d0	; size
	moveq	#%01,d1	; chip + dont clear
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Modul5Add).w

; READ MODULE
	move.w	#721,d0
	move.w	#449,d1	;152,d1
	move.l	(Modul5Add).w,a0
	bsr.w	TD_ReadSectors

; PP DEPACK MODULE
	move.l	(Modul5Add).w,a0
	add.l	#229384,a0	; end of pp obj
	move.l	(Modul5Add).w,a3	; decrunch add
	add.l	#32,a3
	move.l	(Modul5Add).w,a5
	add.l	#4,a5	; start of pp obj
	lea	$DFF180,a6
	bsr.w	Decrunch
	lea	Base,a6
	lea	$BFD100,a5
; DELTA DEPACK MODULE
	move.l	(Modul5Add).w,a0
	add.l	#32,a0
	move.l	#317500-2,d0	; size
	bsr.w	DeltaDePacker
	rts	

Modul5Add:	dc.l	0
Copy5thToChip:	move.l	#317500,d0	; size
	moveq	#%00,d1	; chip + dont clear
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,a0
	move.l	(Modul5Add).w,a1
	move.l	a1,a2
	move.l	d0,(Modul5Add).w
	move.l	#317500/8-1,d0	; size
.loop	move.l	(a1)+,(a0)+	
	move.l	(a1)+,(a0)+	
	dbra	d0,.loop

	move.l	a2,d0	; add
	move.l	#32+317500,d1	; size
	bsr.w	FreeMem
	rts




Free4thModule:
	move.l	(Modul4Add).w,d0	; add
	move.l	#32+206200,d1	; size
	bsr.w	FreeMem
	rts
Read4thModule:
; ALLOC MEM FOR 4th MODULE
	;move.l	#32+206200,d0	; size
	move.l	#173632,d0	; size
	moveq	#%01,d1	; chip + dont clear
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Modul4Add).w

; READ MODULE
	move.w	#1324,d0
	move.w	#340,d1	;152,d1
	move.l	(Modul4Add).w,a0
	bsr.w	TD_ReadSectors

 rem
; PP DEPACK MODULE
	move.l	(Modul4Add).w,a0
	add.l	#173632,a0	; end of pp obj
	move.l	(Modul4Add).w,a3	; decrunch add
	add.l	#32,a3
	move.l	(Modul4Add).w,a5
	add.l	#4,a5	; start of pp obj
	lea	$DFF180,a6
	bsr	Decrunch
	lea	Base,a6
	lea	$BFD100,a5
; DELTA DEPACK MODULE
	move.l	(Modul4Add).w,a0
	add.l	#32,a0
	move.l	#206200-2,d0	; size
	bsr	DeltaDePacker
 endrem
	rts	
Modul4Add:	dc.l	0










CREDITS_LEN	equ	80200
CREDITS_LENP	equ	15228
ReadCreditsCode:
; ALLOC MEM FOR INTRO
	move.l	#32+CREDITS_LEN,d0	; size
	moveq	#%01,d1
* Type:	BIT0	= CLR=CHIP		SET=OTHER
* 	BIT1	= CLR=CLEAR MEM		SET=DON`T CLEAR MEM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Hunk5Add).w
; READ INTRO
	move.w	#64,d0
	move.w	#30,d1
	move.l	(Hunk5Add).w,a0
	bsr.w	TD_ReadSectors
; PP DEPACK INTRO
	move.l	(Hunk5Add).w,a0
	add.l	#CREDITS_LENP,a0	; end of pp obj
	move.l	(Hunk5Add).w,a3	; decrunch add
	add.l	#32,a3
	move.l	(Hunk5Add).w,a5
	add.l	#4,a5	; start of pp obj
	lea	$DFF180,a6
	bsr.w	Decrunch
	rts
DeJohnCredits:
	move.l	(Hunk5Add).w,a0
	add.l	#32,a0	; hunk add
	bsr.w	DeHunkPrg
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,DeHunket5Add

	move.l	(Hunk5Add).w,d0	; add
	move.l	#32+CREDITS_LEN,d1	; size
	bsr.w	FreeMem

	lea	Base,a6
	lea	$BFD100,a5
	rts	

Hunk5Add:	dc.l	0
DeHunket5Add:	dc.l	0






INTRO_LEN	equ	150208
INTRO_LENP	equ	24040
FreeIntroCode:	move.l	DeHunket1Add,d0
	bsr.w	FreeHunks
	rts
ReadIntroCode:
; ALLOC MEM FOR INTRO
	move.l	#32+INTRO_LEN,d0	; size
	moveq	#%01,d1
* Type:	BIT0	= CLR=CHIP		SET=OTHER
* 	BIT1	= CLR=CLEAR MEM		SET=DON`T CLEAR MEM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Hunk1Add).w
; READ INTRO
	move.w	#298,d0
	move.w	#47,d1
	move.l	(Hunk1Add).w,a0
	bsr.w	TD_ReadSectors
; PP DEPACK INTRO
	move.l	(Hunk1Add).w,a0
	add.l	#INTRO_LENP,a0	; end of pp obj
	move.l	(Hunk1Add).w,a3	; decrunch add
	add.l	#32,a3
	move.l	(Hunk1Add).w,a5
	add.l	#4,a5	; start of pp obj
	lea	$DFF180,a6
	bsr.w	Decrunch

	move.l	(Hunk1Add).w,a0
	add.l	#32,a0	; hunk add
	bsr.w	DeHunkPrg
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,DeHunket1Add

	move.l	(Hunk1Add).w,d0	; add
	move.l	#32+INTRO_LEN,d1	; size
	bsr.w	FreeMem


	lea	Base,a6
	lea	$BFD100,a5
	rts	

Hunk1Add:	dc.l	0
DeHunket1Add:	dc.l	0



TUNNEL_LEN	equ	17740
TUNNEL_LENP	equ	9244
FreeTunnelCode:	move.l	(DeHunket2Add).w,d0
	bsr.w	FreeHunks
	rts
ReadTunnelCode:
; ALLOC MEM FOR INTRO
	move.l	#32+TUNNEL_LEN,d0	; size
	moveq	#%01,d1
* Type:	BIT0	= CLR=CHIP		SET=OTHER
* 	BIT1	= CLR=CLEAR MEM		SET=DON`T CLEAR MEM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Hunk2Add).w
; READ INTRO
	move.w	#278,d0
	move.w	#19,d1
	move.l	(Hunk2Add).w,a0
	bsr.w	TD_ReadSectors
; PP DEPACK INTRO
	move.l	(Hunk2Add).w,a0
	add.l	#TUNNEL_LENP,a0	; end of pp obj
	move.l	(Hunk2Add).w,a3	; decrunch add
	add.l	#32,a3
	move.l	(Hunk2Add).w,a5
	add.l	#4,a5	; start of pp obj
	lea	$DFF180,a6
	bsr.w	Decrunch
	rts

DeHunkTunnelCode:
	move.l	(Hunk2Add).w,a0
	add.l	#32,a0	; hunk add
	bsr.w	DeHunkPrg
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(DeHunket2Add).w

	move.l	(Hunk2Add).w,d0	; add
	move.l	#32+TUNNEL_LEN,d1	; size
	bsr.w	FreeMem

	lea	Base,a6
	lea	$BFD100,a5
	rts	

Hunk2Add:	dc.l	0
DeHunket2Add:	dc.l	0






POPPART_LEN	equ	204996
POPPART_LENP	equ	68756
FreePopCode:	move.l	(DeHunket3Add).w,d0
	bsr.w	FreeHunks
	rts
ReadPopCode:
; ALLOC MEM FOR POP
	move.l	#32+POPPART_LEN,d0	; size
	moveq	#%01,d1
* Type:	BIT0	= CLR=CHIP		SET=OTHER
* 	BIT1	= CLR=CLEAR MEM		SET=DON`T CLEAR MEM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Hunk3Add).w
; READ INTRO
	move.w	#142,d0
	move.w	#135,d1
	move.l	(Hunk3Add).w,a0
	bsr.w	TD_ReadSectors
; PP DEPACK INTRO
	move.l	(Hunk3Add).w,a0
	add.l	#POPPART_LENP,a0	; end of pp obj
	move.l	(Hunk3Add).w,a3	; decrunch add
	add.l	#32,a3
	move.l	(Hunk3Add).w,a5
	add.l	#4,a5	; start of pp obj
	lea	$DFF180,a6
	bsr.w	Decrunch
	rts	

DeHunkPopCode:
	move.l	(Modul3Add).w,a0
	move.l	(ResChipBuffer).w,a1
	move.l	#(32+129828)/2,d0	; size
.MoveLoop	move.w	(a0)+,(a1)+
	sub.l	#1,d0
	bne.b	.MoveLoop

	lea	(ResChipBuffer+8).w,a0
	move.w	#((ChipSize/16)+1)-1,d0
.ClrLoop	clr.w	(a0)+
	dbf	d0,.ClrLoop

	move.l	#32+129828,d0	; size
	moveq	#%00,d1
* Type:	BIT0	= CLR=CHIP		SET=OTHER
* 	BIT1	= CLR=CLEAR MEM		SET=DON`T CLEAR MEM
	bsr.w	AllocMem
	move.l	d0,(Modul3Add).w

	move.l	(Hunk3Add).w,a0
	add.l	#32,a0	; hunk add
	bsr.w	DeHunkPrg
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(DeHunket3Add).w

	move.l	(Hunk3Add).w,d0	; add
	move.l	#32+POPPART_LEN,d1	; size
	bsr.w	FreeMem

	lea	Base,a6
	lea	$BFD100,a5
	rts

Hunk3Add:	dc.l	0
DeHunket3Add:	dc.l	0






BUDDHA_LEN	equ	49516
BUDDHA_LENP	equ	23268
FreeBuddha:	move.l	(DeHunket4Add).w,d0
	bsr.w	FreeHunks
	rts
ReadBuddhaCode:
	move.l	#BUDDHA_LENP,d0	; size
	moveq	#%01,d1
* Type:	BIT0	= CLR=CHIP		SET=OTHER
* 	BIT1	= CLR=CLEAR MEM		SET=DON`T CLEAR MEM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Hunk4Add).w
	move.w	#95,d0
	move.w	#46,d1
	move.l	(Hunk4Add).w,a0
	bsr.w	TD_ReadSectors
	rts	

DeHunkBuddhaCode:
	move.l	#BUDDHA_LEN,d0	; size
	moveq	#%00,d1	; dont clear + fast
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(Hunk4Add2).w	;
	move.l	(Hunk4Add).w,a0
	add.l	#BUDDHA_LENP,a0	; end of pp obj
	move.l	(Hunk4Add2).w,a3	; decrunch add
	move.l	(Hunk4Add).w,a5
	add.l	#4,a5	; start of pp obj
	lea	$DFF180,a6
	bsr.w	Decrunch
	move.l	(Hunk4Add2).w,a0
	bsr.w	DeHunkPrg
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(DeHunket4Add).w
	move.l	(Hunk4Add).w,d0	; add
	move.l	#BUDDHA_LENP,d1	; size
	bsr.w	FreeMem
	move.l	(Hunk4Add2).w,d0	; add
	move.l	#BUDDHA_LEN,d1	; size
	bsr.w	FreeMem
	rts
Hunk4Add:	dc.l	0
Hunk4Add2:	dc.l	0
DeHunket4Add:	dc.l	0









AntiReadMegaSinTab:
	move.l	(SinTabAdd).w,d0
	move.l	#32+25616,d1	; size
	bsr.w	FreeMem
	rts

ReadMegaSinTab:
; ALLOC MEM FOR SIN TAB
	move.l	#32+25616,d0	; size
	moveq	#%01,d1	; dont clear + fast
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(SinTabAdd).w
; READ FIRST MODULE
	move.w	#346,d0
	move.w	#7,d1
	move.l	(SinTabAdd).w,a0
	bsr.w	TD_ReadSectors

; PP DEPACK FIRST MODULE
	move.l	(SinTabAdd).w,a0
	add.l	#3368,a0	; end of pp obj
	move.l	(SinTabAdd).w,a3	; decrunch add
	add.l	#32,a3
	move.l	(SinTabAdd).w,a5
	add.l	#4,a5	; start of pp obj
	lea	$DFF180,a6
	bsr.w	Decrunch
	lea	Base,a6
	lea	$BFD100,a5
; DELTA DEPACK FIRST MODULE
	move.l	(SinTabAdd).w,a0
	add.l	#32,a0
	move.l	#(25616/2)-2,d0	; size
	bsr.w	DeltaDePackerWord

	rts	







AntiReadMegaSinTab2:
	move.l	#25616,d1	; size
	move.l	(SinTabAdd2).w,d0
	bsr.w	FreeMem
	rts

ReadMegaSinTab2:
	;move.l	#32+25616,d0	; size
	move.l	#3368,d0	; size
	moveq	#%01,d1	; dont clear + fast
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(SinTabAdd).w
	move.w	#346,d0
	move.w	#7,d1
	move.l	(SinTabAdd).w,a0
	bsr.w	TD_ReadSectors
	rts
SinTabAdd:	dc.l	0

 Copper data 
 Copper data 
 Copper data 

SetUpFunkyGuru:	lea	$8.w,a0
	lea	$80.w,a1
.loop	cmp.l	a0,a1
	beq.b	.out
	move.l	#ShowGuru,(a0)+
	bra.b	.loop
.out	rts
	
;IN: a0=CrunchEnd, a1=Decrunch, a2=Crunch+4
ShowNeed1MB:	lea	base,a6
	move.w	#$7FFF,DmaCon(a6)
	move.w	#$7FFF,IntEna(a6)
	lea	(RekviresEnd).w,a0
	lea	(Rekvires+4).w,a2
	lea	$70000,a1
	bsr	PPDecrunch
	bsr.w	ShowDecrunch2
	move.w	#300*100,d0
	bsr	TD_WaitLines
	bra.w	MusicSelector

ShowGuru:	lea	base,a6
	move.w	#$7FFF,DmaCon(a6)
	move.w	#$7FFF,IntEna(a6)
	move.l	(PPDecrunchAdd).w,a0
	move.l	a0,a5
	add.l	#FUNKYGURUEnd-PPDecrunch,a0
	add.l	#FUNKYGURU-PPDecrunch+4,a5
	move.w	#$9811,(TextP1).w
	move.w	#$C011,(TextP2).w
	bsr.b	ShowDecrunch
.loop	bra.b	.loop

ShowReadError:	lea	base,a6
	move.w	#$7FFF,DmaCon(a6)
	move.w	#$7FFF,IntEna(a6)
	move.l	(PPDecrunchAdd).w,a0
	move.l	a0,a5
	add.l	#ReadErrorEnd-PPDecrunch,a0
	add.l	#ReadError-PPDecrunch+4,a5
	move.w	#$9811,(TextP1).w
	move.w	#$C011,(TextP2).w
	bsr.w	ShowDecrunch
.loop	bra.b	.loop
	
ShowDecrunch:	lea	$70000,a3
	bsr.w	Decrunch
ShowDecrunch2:	lea	base,a6
	move.w	#My_DmaCon,DmaCon(a6)
	move.l	#TextCopper,Cop1Lch(a6)
	move.w	d0,CopJmp1(a6)
	move.w	#0,CopCon(a6)
	rts

BlackCopper:	dc.w	BplCon0,$0200
	dc.w	Color00,$000
	EndCop

TextCopper:	dc.w	DiwStrt,$2C81,DiwStop,$2CC1
	dc.w	DdfStrt,$0038,DdfStop,$00D0
	dc.w	BplCon0,$0200,BplCon1,$0000,BplCon2,$0024
	dc.w	Bpl1Mod,0
	SPRZERO
	dc.w	Bpl1Pth,7,Bpl1Ptl,$0
	dc.w	Color00,$000
	dc.w	Color01,$fff
TextP1:	dc.w	$9d11,$fffe
	dc.w	BplCon0,$1200
TextP2:	dc.w	$ba11,$fffe
	dc.w	BplCon0,$0200
	EndCop

SpreadCopper:	dc.w	DiwStrt,$2C81,DiwStop,$2CC1
	dc.w	DdfStrt,$0038,DdfStop,$00D0
	dc.w	BplCon0,$1200,BplCon1,$0000,BplCon2,$0024
	dc.w	Bpl1Mod,0
	SPRZERO
	dc.w	Bpl1Pth,7,Bpl1Ptl,$0
	dc.w	Color00,$000
	dc.w	Color01,$440
	dc.w	$4011,$fffe
	dc.w	Color01,$644
	dc.w	$F011,$fffe
	dc.w	Color01,$440
	EndCop

GodSherlocCopper:
	dc.w	DiwStrt,$2C81,DiwStop,$2CC1
	dc.w	DdfStrt,$0038+4,DdfStop,$00D0+4
	dc.w	BplCon0,$0200,BplCon1,$0000,BplCon2,$0024
	dc.w	Bpl1Mod,0
	SPRZERO
GodBpl:	dc.w	Bpl1Pth,0,Bpl1Ptl,$0
	dc.w	Color00,$fff
GodCol:	dc.w	Color01,$fff
	dc.w	$8311,$fffe
	dc.w	BplCon0,$9200
	dc.w	$ac11,$fffe
	dc.w	BplCon0,$0200
NoShitBpl:	dc.w	Bpl1Pth,0,Bpl1Ptl,$0
NoShitCol:	dc.w	Color01,$fff
	dc.w	$ae11,$fffe
	dc.w	BplCon0,$9200
	dc.w	$c411,$fffe
	dc.w	BplCon0,$0200
	EndCop


*******************************************************************************
***                                                                         ***
***                     Non system dos disk controller!                     ***
***                                                                         ***
***-------------------------------------------------------------------------***
**                                                                           **
** To read a file do as follows:                                             **
**                                                                           **
** Call TD_Init before you do anything else.				     **
** Then let A0 point on the name of the file you want to load,		     **
** and let A1 point on the mem loc. you want to load at.		     **
** When you are finished with the drive call TD_Restore			     **
**                                                                           **
*******************************************************************************
TD_Sync 	=	$4489
TD_TrackPause	=	5000 ; micro sec

>=============================================================================<
>                                   TD_Init                                   <
>-----------------------------------------------------------------------------<
>              This will init the FloppyDiskInterfaceController		      <
>                                                                             <
> IN:           A6 = _Customer                                                <
> IN:           A5 = $BFD100                                                  <
> TRASHES:      D0-D1                                                         <
> OUT:          non                                                           <
>=============================================================================<
TD_Init:	move.w	#TD_Sync,DskSync(a6)	; 
	move.w	AdkCon(a6),TD_AdkCon	; Save system AdkCon
	move.w	#$7FFF,AdkCon(a6)	; Set,Precomp val=0,MFMPrec
	move.w	#$9500,AdkCon(a6)	; WordSync,Fast
	move.w	#$4000,DskLen(a6)	; Reset DiskLen
	move.w	#$8010,DmaCon(a6)	; Start disk dma
	bsr.b	TD_MotorOn	; 
	moveq	#0,d0	; System head pos
.SeekZero:	btst	#4,$F01(a5)	; Track Zero ?
	beq.b	.TrackZero	; YES!
	bsr.w	TD_StepLower	; Move head towards zero
	addq.w	#1,d0	; 
	bra.b	.SeekZero	; 
.TrackZero	lsl.w	#1,d0	; 
	move.w	d0,TD_SysTrack	; 
	clr.w	TD_CurrentTrack	; Clr track pointer
	bra.w	TD_WaitForReady	; 
	bsr.b	TD_MotorOff	; 
	rts

>=============================================================================<
>                                 TD_Restore                                  <
>-----------------------------------------------------------------------------<
>             This will restore the FloppyDiskInterfaceController	      <
>                                                                             <
> IN:           A6 = _Custom                                                  <
> TRASHES:      D0-D1                                                         <
> OUT:          non                                                           <
>=============================================================================<
TD_Restore:	bsr.b	TD_MotorOn	; 
	move.w	TD_SysTrack,d0	; 
	bsr.w	TD_SeekTrack	; 
	bsr.b	TD_MotorOff	; 

	move.w	#$7FFF,AdkCon(a6)	; Reset
	move.w	TD_AdkCon,d0	; Get system AdkCon
	or.w	#$8000,d0	; Set SET bit
	move.w	d0,AdkCon(a6)	; Restore system AdkCon
	move.w	#$4000,DskLen(a6)	; Reset DiskLen
	move.w	#$0010,DmaCon(a6)	; Stop disk dma
	rts

>=============================================================================<
>                                 Start Motor                                 <
>-----------------------------------------------------------------------------<
>     Will start the motor on the selected drive, and wait for full speed     <
>                                                                             <
> IN:           A5 = $BFD100                                                  <
> TRASHES:      D0-D2                                                         <
> OUT:          non                                                           <
>=============================================================================<
TD_MotorOn:	move.w	#%01111001,d0	; /SEL3,/SEL2,/SEL1,/SEL0,/STEP
	move.w	TD_CurrentTrack,d1	; Cyl/Head
	and.w	#1,d1	; Mask Head thru
	eor.b	#1,d1	; Side 0 = Surface 1!
	lsl.w	#2,d1	; 
	or.w	d1,d0	; Set to right side
	move.w	d0,d1
	move.w	TD_DrevNr,d2	; Drive to use
	add.w	#3,d2	; 
	bclr	d2,d1	; 
	move.b	d0,(a5)	; 
	nop		; wait
	nop		;
	move.b	d1,(A5)	; Start drive
	bsr.w	TD_WaitForReady
	rts

>=============================================================================<
>                                 Stop Motor                                  <
>-----------------------------------------------------------------------------<
>                    Stops the motor of the selected drive                    <
>                                                                             <
> IN:           A5 = $BFD100                                                  <
> TRASHES:      D0-D2                                                         <
> OUT:          non                                                           <
>=============================================================================<
TD_MotorOff:	move.w	#%11111101,d0	; SEL3,SEL2,SEL1,SEL0,STEP
	move.w	d0,d1	;
	move.w	TD_DrevNr,d1	; 
	addq.w	#3,d1	; 
	bclr	d2,d1	; 
	move.b	d0,(a5)	; 
	nop		; 
	nop		; 
	move.b	d1,(a5)	; 
	nop		; 
	nop		; 
	move.b	d0,$bfd100	; 
	bsr.w	TD_Wait3miliSec	; 
	rts

>=============================================================================<
>                               Seek Track zero                               <
>-----------------------------------------------------------------------------<
>                        Moves the head to track zero                         <
>                                                                             <
> IN:           A5 = $BFD100                                                  <
> TRASHES:      none                                                          <
> OUT:          none                                                          <
>=============================================================================<
TD_SeekZero:	btst	#4,$F01(a5)	; Track Zero ?
	beq.b	.TrackZero	; YES!
	bsr.b	TD_StepLower	; Move head towards zero
	bra.b	TD_SeekZero	; 
.TrackZero	clr.w	TD_CurrentTrack	; Clr track pointer
	bra.w	TD_WaitForReady	; 

>=============================================================================<
>                                Seek a track                                 <
>-----------------------------------------------------------------------------<
>                    Moves the head to a determined track                     <
>                                                                             <
> IN:           A5 = $BFD100                                                  <
>               D0 = Destination track                                        <
> TRASHES:      none                                                          <
> OUT:	none                                                          <
>=============================================================================<
TD_SeekTrack:	push.l	d0-a6
	move.w	TD_CurrentTrack,d1	; 
.TstTrack	cmp.w	d0,d1	; Have we reached the track?
	beq.b	.OnRightTrack	; YES!
	bls.b	.MoveUp	; Move head up
.MoveDown	subq.w	#1,d1	; 
	btst	#0,d1	; Test side
	beq.b	.TstTrack	; Head = 0
	bsr.b	TD_StepLower	; Move the head
	bra.b	.TstTrack	; and try again
.MoveUp	addq.w	#1,d1	;
	btst	#0,d1	; Test side 
	bne.b	.TstTrack	; Head = 0
	bsr.b	TD_StepHiger	; Move the head
	bra.b	.TstTrack	; and try again
.OnRightTrack	move.w	d0,TD_CurrentTrack	; 
	bsr.w	TD_MotorOn
	pull.l	d0-a6
	rts

TD_StepLower:
	bset	#1,(a5)	; Stop lower (0)
	bra.b	TD_StepHead	; 
TD_StepHiger:
	bclr	#1,(a5)	; Stop higer (80)
TD_StepHead	bclr	#0,(a5)	; 
	bset	#0,(a5)	; STEP!
	push.l	d0-d1	;
	move.w	#TD_TrackPause/64,d0	; wait ? micro sec.
	bsr.w	TD_WaitLines	; 
	bsr.w	TD_WaitForReady	; 
	pull.l	d0-d1	; 
	rts		; 

>=============================================================================<
>                                 Read sectors                                <
>-----------------------------------------------------------------------------<
>                        Read an AmigaDOS V1.0 sectors                        <
>                                                                             <
> IN:           D0 = First sector to read                                     <
>               D1 = Number of sectors to read                                <
>               A0 = Add of dest mem                                          <
>	A6 = _Custom                                                  <
>               A5 = $BFD100                                                  <
> TRASHES:      none                                                          <
> OUT:          TD_ErrorCode = The error (if any)                             <
>=============================================================================<
TD_ReadSectors:
;	bsr	TD_MotorOn

	push.l	d2
	bra.b	.InReadLoop
.ReadLoop
	bsr.b	TD_ReadSector

	addq.l	#1,d0
	move.l	TD_DosBufPtr(pc),a1
	moveq	#512/(4*4)-1,d2
.CopyLoop	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	dbf	d2,.CopyLoop

.InReadLoop	dbf	d1,.ReadLoop
	
	pull.l	d2
;	bsr	TD_MotorOff
	rts	
>=============================================================================<
>                                 Read sector                                 <
>-----------------------------------------------------------------------------<
>                        Read an AmigaDOS V1.0 sector                         <
>                                                                             <
> IN:           D0 = Sector to read                                           <
>	A6 = _Custom                                                  <
>               A5 = $BFD100                                                  <
> TRASHES:      none                                                          <
> OUT:          TD_ErrorCode = The error (if any)                             <
>               TD_DosBufPtr = Pointer to sector loc!                         <
>=============================================================================<
TD_ReadSector:	push.l	d0-a6
	ext.l	d0	; AND.l #$FFFF,d0
	divu	#11,d0	; D0 = Track
	cmp.w	TD_TrackInMem,d0	; 
	beq.b	.TrackInMem	; 
	move.w	d0,TD_TrackInMem	; 
	bsr.w	TD_SeekTrack	; 
	move.l	TD_DosBuf,TD_LoadAdd;;
	bsr.b	TD_ReadTrack	; 
	tst.w	TD_ErrorCode	; Read error?
	bne.b	.Error	; YES!
.TrackInMem	move.l	(sp),d0
	ext.l	d0	; AND.l #$FFFF,d0
	divu	#11,d0	; D0 = Track
	swap	d0	; 
	mulu	#512,d0	; 
	add.l	TD_DosBuf,d0	;; 
	move.l	d0,TD_DosBufPtr	; 
	pull.l	d0-a6
	rts		; 
.Error	move.w	#-1,TD_TrackInMem	; 
	pull.l	d0-a6
	rts		; 

>=============================================================================<
>                                 Read track                                  <
>-----------------------------------------------------------------------------<
>                    Read and decode (MFM) an entire track                    <
>                                                                             <
> IN:           TD_LoadAdd = Dest add                                         <
>               A6 = _Custom                                                  <
>               A5 = $BFD100                                                  <
> TRASHES:      none                                                          <
> OUT:          TD_ErrorCode = The error (if any)                             <
>=============================================================================<
TD_ReadTrack:	push.l	d0-a6	; Save regs
	move.w	TD_CurrentTrack,d1	; Track we are on
	move.w	#4,TD_NoOfTrys	; No of MAX read/write errors
.TryAgain:	lea	TD_CodeBuf,a1	; MFM data buffer
	clr.l	2(a1)	; first MFM Header
	move.l	a1,DskPth(a6)	; 
	move.w	#$4000,DskLen(a6)	; Reset DiskLen
	move.w	#$9C00,DskLen(a6)	; (1024+64)*11+Gab (Gab=2048)
	move.w	#$9C00,DskLen(a6)	; 
	move.w	#$0002,IntReq(a6)
.StillReading	btst	#1,IntReqr+1(a6)
	beq.b	.StillReading

	;move.w	#$4000,DskLen(A6)	; Reset DiskLen
	move.l	TD_LoadAdd,a0	; Decode data
	move.l	#$55555555,d0	; And value!
	moveq	#11-1,d7	; Number of sectors in track
.NextSector:	move.w	#TD_Sync,d1	; 
.NoSync:	cmp.l	#TD_CodeBuf+$3800,a1	; Check if end of MFM buffer!
	bhs.w	.PANICtoFewSec	; PANIC!
	cmp.w	(a1)+,d1	; Find first sync in sector!
	bne.b	.NoSync	; 
.SncAgn:	cmp.w	(a1)+,d1	; 
	beq.b	.SncAgn	; 
	lea	-2(a1),a1	; a1 points after last sync!
	move.l	(a1)+,d1	; Get Format,Track,Sec nr and
	move.l	(a1)+,d2	;  sec rest
	and.l	d0,d1	; 
	and.l	d0,d2	; 
	move.l	d1,d3	; d3 = Header check sum!
	eor.l	d2,d3	; d3 = Header check sum!
	lsl.l	#1,d1	; 
	or.l	d2,d1	; 
	move.l	d1,d2	; d2=Decode Header!
	swap	d2	; 
	and.w	#$FF,d2	; 
	cmp.w	TD_CurrentTrack,d2	; Check if right track!
	bne.b	.PANICwrongTrk	; PANIC!
	lsr.l	#8,d1	; 
	and.l	#$ff,d1	; d1.l = Sector nr.
	Moveq	#9,d2	;
	Lsl.l	d2,d1	; d1.l = 512*Sector nr.
	moveq	#8-1,d2	; Rest of header (to checksum)
.CheckLoop1	move.l	(a1)+,d4	; MFM data
	eor.l	d4,d3	; "ADD" MFM data to CheckSum
	dbf	d2,.CheckLoop1	; 
	move.l	(a1)+,d2	; Get right header CheckSum
	move.l	(a1)+,d4	; 
	and.l	d0,d2	; Decode
	and.l	d0,d4	; 
	lsl.l	#1,d2	; 
	or.l	d4,d2	; d2.l = Decodet Check
	eor.l	d2,d3	; Eor RightChk and CalcChk
	and.l	d0,d3	; "Decode"
	bne.b	.PANIChdrErr	; PANIC!!
	move.l	(a1)+,d3	; Get right sector ChkSum
	move.l	(a1)+,d2	; 
	and.l	d0,d3	; 
	and.l	d0,d2	; 
	lsl.l	#1,d3	; 
	or.l	d2,d3	; d3.l = Decodet BlockChkSum
	lea	(a0,d1.w),a3	; Dest buffer*Sec*512 
	moveq	#128-1,d4	; No. of longs to decode
.BlockDecode	move.l	512(a1),d1	; 
	move.l	(a1)+,d2	; 
	eor.l	d1,d3	; "ADD" to BlockChkSum
	eor.l	d2,d3	; "ADD" to BlockChkSum
	and.l	d0,d1	; Decode
	and.l	d0,d2	; 
	lsl.l	#1,d2	; 
	or.l	d1,d2	; 
	move.l	d2,(a3)+	; Write decode data
	dbf	d4,.BlockDecode	; Decode rest of Block
	and.l	d0,d3	; "Decode" BlockChkSum
	bne.b	.PANICblkErr	; PANIC!!
	lea	510(a1),a1	; 
	dbf	d7,.NextSector	; 
	clr.w	TD_ErrorCode	; 0=TrackOk >0=ReadWriteError
.ExitError	pull.l	d0-a6	; Save regs
	rts

.PANICwrongTrk	move.w	#1,TD_ErrorCode	; 1 = Block header destroyed
	bra.b	.ContError	; Continue error process
.PANIChdrErr	move.w	#1,TD_ErrorCode	; 1 = Block header destroyed
	bra.b	.ContError	; Continue error process
.PANICblkErr	move.w	#2,TD_ErrorCode	; 2 = Block destroyed (chk)
	bra.b	.ContError	; Continue error process
.PANICtoFewSec	move.w	#3,TD_ErrorCode	; 3 = To few sectors
	bra.w	.ContError	; Continue error process

.ContError	subq.w	#1,TD_NoOfTrys
	beq.b	.ShitTrack	; Track total damaged!
	move.w	TD_CurrentTrack,d0	;
	push.l	d0-a6
	bsr.w	TD_SeekZero	; Goto track #0
	pull.l	d0-a6
	bsr.w	TD_SeekTrack	; Try again!
	bra.w	.TryAgain	; 

.ShitTrack	bra.w	ShowReadError

>=============================================================================<
>                                    Wait                                     <
>-----------------------------------------------------------------------------<
>                    Wait a number of selected scan lines                     <
>                                                                             <
> IN:           d0 = Number of scan lines to wait                             <
>               A6 = _Custom                                                  <
> TRASHES:      D1                                                            <
> OUT:          none                                                          <
>=============================================================================<
TD_Wait3miliSec:moveq	#3000/64,d0	; wait 3000 micro sec.
	bra.w	TD_WaitLines	; 
TD_WaitLines:	subq.w	#1,d0	; 
.WaitLine2	move.w	VHPosr(a6),d1	; 
	lsr.w	#8,d1	; 
.WaitLine	move.w	VHPosr(a6),d2	; 
	lsr.w	#8,d2	; 
	cmp.w	d1,d2	; 
	beq.b	.WaitLine	; 
	dbf	d0,.WaitLine2	; 
	rts		; 

>=============================================================================<
>                               Wait for ready                                <
>-----------------------------------------------------------------------------<
>          Wait until the drive is known to be rotating at full speed         <
>                                                                             <
> IN:           A5 = $BFD100                                                  <
> TRASHES:      none                                                          <
> OUT:          none                                                          <
>=============================================================================<
TD_WaitForReady:btst	#5,$f01(a5)	; Test /RDY
	bne.b	TD_WaitForReady	;
	rts

TD_AdkCon:	dc.w	0	; System AdkCon
TD_CurrentTrack:dc.w	0	; Pointer on current track
TD_NoOfTrys:	dc.w	0	; 
TD_DrevNr:	dc.w	0	; 
TD_LoadAdd:	dc.l	0	; 
TD_SysTrack:	dc.w	0	; 
TD_TrackInMem:	dc.w	-1	; 
	dc.w	0
TD_DosBufPtr:	dc.l	0	; 

TD_ErrorCode:	dc.w	0	; 0 = No error

			; 1 = Block header destroyed
			; 2 = Block destroyed (chk)
			; 3 = To few sectors

>0-1-2-3-4-5-6-7-8-9-A-B-C-D-E-F-G--+--|--+--G-F-E-D-C-B-A-9-8-7-6-5-4-3-2-1-0<


******************************************************************************
*   ____    _____                                      ____    ____     ___   *
*  |    \  |         |     | |     | |\    | |  /     |    \  |    \   /   \  *
*  |     | |         |     | |     | | \   | | /      |     ) |     ) |       *
*  |     | |---   -- |-----| |     | |  \  | |/\      |____/  |____/  |  ___  *
*  |     | |         |     | |     | |   \ | |  \     |       |  \    |    |  *
*  |____/  |_____    |     | |_____| |    \| |   \    |       |   \    \___|  *
*                                                                             *
*******************************************************************************
* IN	a0=Address of program in memory
* 
* OUT	d0=Adress of AllocBuffer (auto de allocating!)
* 
DeHunkPrg:	movem.l	d1-d3/a0-a5,-(sp)
	cmp.l	#$3F3,(a0)		; check if header!
	bne.s	DHP_Error
	bra.s	DHP_NextHunk2
DHP_NextHunk:	tst.l	d3
	beq.s	DHP_AllOk
DHP_NextHunk2:	move.l	(a0)+,d0
	cmp.l	#$3F3,d0		; hunk_header
	beq.w	DHP_hunk_header
	cmp.l	#$3e9,d0		; hunk_code
	beq.s	DHP_hunk_code
	cmp.l	#$3ea,d0		; hunk_data
	beq.s	DHP_hunk_data
	cmp.l	#$3eb,d0		; hunk_bss
	beq.s	DHP_hunk_bss

DHP_Error:	illegal
	

DHP_AllOk:	move.l	#1024,d0		; SIZE 1K
	moveq	#1,d1			; TYPE MixM
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	lea	HunkBuffer(pc),a0
	move.l	d0,a1
	move.l	#256-1,d2
.loop	move.l	(a0)+,d3		; get size
	move.l	(A0)+,(a1)+		; get and store add
	move.l	d3,(a1)+		; store size
	dbf	d2,.loop
	movem.l	(sp)+,d1-d3/a0-a5
	rts
DHP_hunk_data:
DHP_hunk_code:	move.l	(a0)+,d0		; size of hunk!
	tst.l	(a1)+
	move.l	(a1)+,a3		; dest add
	bra.s	.BLoop
.Loop	move.l	(a0)+,(a3)+
.BLoop	dbf	d0,.Loop
	cmp.l	#$3ec,(a0)
	bne.s	.NoRelocTab
	bsr.b	DHP_hunk_reloc32
.NoRelocTab	cmp.l	#$3f2,(a0)+
	bne.s	DHP_Error		; NoHunkEnd ???
	subq.l	#1,d3			; RestHunk=RestHunk-1
	bra.s	DHP_NextHunk
DHP_hunk_bss	move.l	(a0)+,d0		; size of hunk!
	tst.l	(a1)+
	move.l	(a1)+,a3		; dest add
	bra.s	.BLoop
.Loop	clr.l	(a3)+
.BLoop	dbf	d0,.Loop
	cmp.l	#$3f2,(a0)+		; END?
	bne.s	DHP_Error		; NoHunkEnd ???
	subq.l	#1,d3			; RestHunk=RestHunk-1
	bra.w	DHP_NextHunk
DHP_hunk_reloc32:
	move.l	-4(a1),a4		; HUNK TO BE CORRECTED
	tst.l	(a0)+			; SKIP $3EC.l
.Loop2	move.l	(a0)+,d0		; number of offsets
	beq.s	.LastSection
	move.l	(a0)+,d1		; hunk number
	lsl.l	#3,d1
	move.l	4(a2,d1.l),d2		; MainAddOfHunk
	bra.s	.BLoop
.Loop	move.l	(a0)+,d1
	lea	(a4,d1.l),a5		; add to be corrected
	add.l	d2,(a5)
.BLoop	dbf	d0,.Loop
	bra.s	.Loop2
.LastSection	rts

DHP_hunk_header	lea	HunkBuffer(pc),a1
	moveq	#0,d0			; clr hun buffer!
.loop	clr.l	(a1,d0.w)
	addq.w	#4,d0
	cmp.w	#20*4,d0
	bne.s	.loop
.loop2	tst.l	(a0)+			; skip hunk names!
	bne.s	.loop2
	move.l	(a0)+,d2		; number of hunks
	move.l	d2,d3			; number of hunks
	addq.l	#8,a0			; skip hunk numbers
	bra.s	.BLoop3
.loop3	move.l	(a0)+,d1		; hunk size
	moveq	#0,d0
	move.l	d1,d0
	add.l	d0,d0
	add.l	d0,d0			; d2=size in bytes!
	clr.w	d1
	bclr	#30,d1
	bne.s	.Chip
	bset	#0,d1			; TYPE=FAST
.Chip	move.l	d0,(a1)+		; save size
	bsr.w	AllocMem
	tst.l	d0
	beq.w	PANIC_NOMEM
	move.l	d0,(a1)+		; save add
.BLoop3	dbf	d2,.loop3
	lea	HunkBuffer(pc),a1
	move.l	a1,a2
	bra.w	DHP_NextHunk
		
HunkBuffer:	blk.l	128*2,0			; _MAX_ 1228 hunks!!!!!!!!

*******************************************************************************
*      _____  ____    _____  _____                                   ____     *
*     |      |    \  |      |         |     | |     | |\    | |  /  /         *
*     |      |     | |      |         |     | |     | | \   | | /   \___      *
*     |---   |____/  |---   |---      |-----| |     | |  \  | |/\       \     *
*     |      |   \   |      |         |     | |     | |   \ | |  \       )    *
*     |      |    \  |_____ |_____    |     | |_____| |    \| |   \ ____/     *
*                                                                             *
*******************************************************************************
* IN	d0=Address of AllocBuffer
* 
FreeHunks:	movem.l	d1-d2/a0,-(sp)
	move.l	d0,a0
	move.l	d0,d2
.Loop	move.l	(a0)+,d0		; add of chunk
	beq.s	.LastChunk
	move.l	(a0)+,d1		; size of chunk
	bsr.w	FreeMem
	bra.s	.Loop
.LastChunk	move.l	d2,d0			; add of buffer
	move.l	#1024,d1		; size of buffer
	bsr.w	FreeMem
	movem.l	(sp)+,d1-d2/a0
	rts
*******************************************************************************
*                              _____   _____                _____             *
*        /\     |      |      |     | |           |\    /| |      |\    /|    *
*       /  \    |      |      |     | |           | \  / | |      | \  / |    *
*      /____\   |      |      |     | |           |  \/  | |---   |  \/  |    *
*     /      \  |      |      |     | |           |      | |      |      |    *
*    /        \ |_____ |_____ |_____| |_____      |      | |_____ |      |    *
*                                                                             *
*******************************************************************************
* IN	d0=Size of chunk (in bytes)
* 	d1=Type
* OUT	d0=result
* 
* Type:	BIT0	= CLR=CHIP		SET=OTHER
* 	BIT1	= CLR=CLEAR MEM		SET=DON`T CLEAR MEM
* 

AllocMem:	movem.l	d2-d5/a0-a1,-(sp)
	lea	ResChipBuffer(pc),a0
	btst	#0,d1
	beq.s	.GetChip
	lea	ResMixMBuffer(pc),a0
.GetChip	add.l	#1023,d0
	lsr.l	#8,d0
	lsr.l	#2,d0
	lea	8(a0),a1	; start add
	moveq	#0,d1		; start chunk nr
	move.l	4(a0),d2
	sub.l	(a0),d2
	lsr.l	#8,d2
	lsr.l	#2,d2		; size of module
.TryAgain	bsr.b	.FindChunk
	bmi.s	.ErrorNoMem
	cmp.l	d0,d3
	bmi.s	.TryAgain
	bsr.b	.AllocChunk
	lsl.l	#8,d5
	lsl.l	#2,d5
	add.l	(a0),d5
	move.l	d5,d0
.out	movem.l	(sp)+,d2-d5/a0-a1
	rts
.ErrorNoMem:	moveq	#0,d0
	beq.b	.out

.FindChunk	moveq	#0,d3		; found size
.FC_loop1	cmp.l	d2,d1
	beq.s	.FC_Out2
	move.l	d1,d4		; byteadd
	lsr.l	#3,d4
	btst	d1,(a1,d4.l)
	beq.s	.FC_loop2S
	addq.l	#1,d1
	bra.s	.FC_loop1
.FC_loop2S	move.l	d1,d5
.FC_loop2	cmp.l	d2,d1
	beq.s	.FC_Out
	move.l	d1,d4		; byteadd
	lsr.l	#3,d4
	btst	d1,(a1,d4.l)
	bne.s	.FC_Out
	addq.l	#1,d1
	addq.l	#1,d3
	bra.s	.FC_loop2
.FC_Out2	moveq	#-1,d3
.FC_Out	rts

.AllocChunk	move.l	d5,d2
	bra.s	.AC_StartLoop
.AC_loop	move.l	d2,d4		; byteadd
	lsr.l	#3,d4
	btst	d2,(a1,d4.l)
	bne.b	.PANIC
	bset	d2,(a1,d4.l)
	addq.l	#1,d2
.AC_StartLoop	dbf	d0,.AC_loop
	rts
.PANIC	illegal

*******************************************************************************
*           _____  ____    _____  _____               _____                   *
*          |      |    \  |      |          |\    /| |      |\    /|          *
*          |      |     ) |      |          | \  / | |      | \  / |          *
*          |---   |____/  |---   |---       |  \/  | |---   |  \/  |          *
*          |      |   \   |      |          |      | |      |      |          *
*          |      |    \  |_____ |_____     |      | |_____ |      |          *
*                                                                             *
*******************************************************************************
* IN	d0=Add of chunk
* 	d1=Size of chunk (in bytes)
* 
Freeerror:	dc.w	0
FreeMem:	movem.l	d2-d3/a0,-(sp)
	lea	ResChipBuffer(pc),a0
	bsr.s	.ChechModule
	beq.s	.FoundModule
	lea	ResMixMBuffer(pc),a0
	bsr.s	.ChechModule
	beq.s	.FoundModule
	movem.l	(sp)+,d2-d3/a0
	rts
.Error	illegal
.FoundModule	move.l	d0,d3
	sub.l	(a0),d0
	add.l	d1,d3
	cmp.l	4(a0),d3
	bhi.s	.Error		; branch if Add+Size>UpperBorder
	lsr.l	#8,d0
	lsr.l	#2,d0		; d0 = pointer
	add.l	#1023,d1
	lsr.l	#8,d1
	lsr.l	#2,d1		; d1=size in 1024blocks
	lea	8(a0),a0
	bra.s	.StartLoop
.loop	move.l	d0,d2		; byteadd
	lsr.l	#3,d2
	bclr	d0,(a0,d2.l)
	beq.s	.Error
	addq.l	#1,d0
.StartLoop	dbf	d1,.loop
	movem.l	(sp)+,d2-d3/a0
	rts
.ChechModule	move.l	(a0),d2
	cmp.l	d2,d0
	blo.s	.NotThisModule
	move.l	4(a0),d2
	cmp.l	d2,d0
	bhi.s	.NotThisModule
	moveq	#0,d2
	rts
.NotThisModule	moveq	#-1,d2
	rts

*******************************************************************************
*  PowerPacker Decrunch assembler subroutine V2.0 (reentrant !)               *
*******************************************************************************
PPDecrunchAdd:	dc.l	0

CopyDecrunch:	lea	PPDecrunch(pc),a0
	move.l	PPDecrunchAdd,a1
	move.w	#PPDecrunchLen-1,d0
.CopyLoop	move.b	(a0)+,(a1)+
	dbra	d0,.CopyLoop
	rts	

CopyDecrunch2:	lea	PPDecrunch(pc),a0
	move.l	a0,(PPDecrunchAdd).w
	rts

Decrunch:	move.l	a3,a1
	move.l	a5,a2
	move.l	PPDecrunchAdd(pc),a3
	jmp	(a3)



; a0 = data
; d0 = len-1

DeltaDePacker:	;lea	BinStart2,a0
	;move.l	#BinLen-2,d0
.PackLoop:	move.b	(a0)+,d1
	move.b	(a0),d2
	add.b	d1,d2
	move.b	d2,(a0)
	dbf	d0,.PackLoop
	sub.l	#$10000,d0
	bpl.b	.PackLoop
	rts

DeltaDePackerWord:
	;lea	BinStart2,a0
	;move.l	#BinLen-2,d0
.PackLoop:	move.w	(a0)+,d1
	move.w	(a0),d2
	add.w	d1,d2
	move.w	d2,(a0)
	dbf	d0,.PackLoop
	sub.l	#$10000,d0
	bpl.b	.PackLoop
	rts

ChipSize	=	490 ;K
MixMSize	=	512-6 ;K
ResChipBuffer:	dc.l	0,0
	blk.w	(ChipSize/16)+1,0
ResMixMBuffer:	dc.l	0,0
	blk.w	(MixMSize/16)+1,0


 Misc data 

TD_DosBuf:	dc.l	0	;blk.b	512*11,0
TD_CodeBuf:	equ	$80000-(($1C00+2)*2)
UserStack	equ	TD_CodeBuf

 Include data and large data blocks 

TheEnd2:




************ PowerPacker Decruncher ************
;IN: a0=CrunchEnd, a1=Decrunch, a2=Crunch+4

PPDecrunch:
	movem.l	d2-d7/a2-a6,-(a7)
	lea	PPTable(pc),a5
	moveq	#$18,d6
	moveq	#$00,d4
	move.w	#$00ff,d7
;;	lea	$dff180,a3
	moveq	#$01,d5
	move.l	a1,a4
	move.l	-(a0),d1
	tst.b	d1
	beq.b	lb_a9f6
	lsr.l	#1,d5
	beq.b	lb_aa32
lb_a9f2	subq.b	#1,d1
	lsr.l	d1,d5
lb_a9f6	lsr.l	#8,d1
	adda.l	d1,a1
lb_a9fa	lsr.l	#1,d5
	beq.b	lb_aa38
lb_a9fe	bcs.w	lb_aaa0
	moveq	#$00,d2
lb_aa04	moveq	#$00,d1
	lsr.l	#1,d5
	beq.b	lb_aa3e
lb_aa0a	roxl.w	#1,d1
	lsr.l	#1,d5
	beq.b	lb_aa44
lb_aa10	roxl.w	#1,d1
	add.w	d1,d2
	subq.w	#3,d1
	beq.b	lb_aa04
	moveq	#$00,d0
lb_aa1a	move.b	d5,d4
	lsr.l	#8,d5
	beq.b	lb_aa56
lb_aa20	move.b	-$80(a5,d4.w),d0
	move.b	d0,-(a1)
	dbf	d2,lb_aa1a
	cmpa.l	a1,a4
	bcs.b	lb_aaa0
	bra.w	lb_ab80
lb_aa32	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_a9f2
lb_aa38	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_a9fe
lb_aa3e	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_aa0a
lb_aa44	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_aa10
lb_aa4a	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_aaa6
lb_aa50	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_aaac
lb_aa56	move.b	$7f(a5,d4.w),d0
	move.l	-(a0),d5
	move.w	d5,d3
	lsl.w	d0,d3
	bchg	d0,d3
	eor.w	d3,d4
	and.w	d7,d4
	moveq	#$08,d1
	sub.w	d0,d1
	lsr.l	d1,d5
	add.w	d6,d0
	bset	d0,d5
	bra.b	lb_aa20
lb_aa72	move.b	$7f(a5,d4.w),d0
	move.l	-(a0),d5
	move.w	d5,d3
	lsl.w	d0,d3
	bchg	d0,d3
	eor.w	d3,d4
	and.w	d7,d4
	moveq	#$08,d1
	sub.w	d0,d1
	lsr.l	d1,d5
	add.w	d6,d0
	bset	d0,d5
	bra.b	lb_aab4
lb_aa8e	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_aaee
lb_aa94	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_aaf4
lb_aa9a	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_aafa
lb_aaa0	moveq	#$00,d2
	lsr.l	#1,d5
	beq.b	lb_aa4a
lb_aaa6	roxl.w	#1,d2
	lsr.l	#1,d5
	beq.b	lb_aa50
lb_aaac	roxl.w	#1,d2
	move.b	d5,d4
	lsr.l	#8,d5
	beq.b	lb_aa72
lb_aab4	moveq	#$00,d3
	move.b	-$80(a5,d4.w),d3
	cmp.w	#$0003,d2
	bne.b	lb_ab3c
	bclr	#$07,d3
	beq.b	lb_ab0e
	moveq	#$0d,d0
	sub.b	(a2,d2.w),d0
	move.w	d0,d1
	add.w	d0,d0
	add.w	d1,d0
	add.w	d0,d0
	jmp	lb_aaea(pc,d0.w)
lb_aad8	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_ab00
lb_aade	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_ab06
lb_aae4	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_ab0c
lb_aaea	lsr.l	#1,d5
	beq.b	lb_aa8e
lb_aaee	roxl.w	#1,d3
	lsr.l	#1,d5
	beq.b	lb_aa94
lb_aaf4	roxl.w	#1,d3
	lsr.l	#1,d5
	beq.b	lb_aa9a
lb_aafa	roxl.w	#1,d3
	lsr.l	#1,d5
	beq.b	lb_aad8
lb_ab00	roxl.w	#1,d3
	lsr.l	#1,d5
	beq.b	lb_aade
lb_ab06	roxl.w	#1,d3
	lsr.l	#1,d5
	beq.b	lb_aae4
lb_ab0c	roxl.w	#1,d3
lb_ab0e	moveq	#$00,d1
	lsr.l	#1,d5
	beq.b	lb_ab2a
lb_ab14	roxl.w	#1,d1
	lsr.l	#1,d5
	beq.b	lb_ab30
lb_ab1a	roxl.w	#1,d1
	lsr.l	#1,d5
	beq.b	lb_ab36
lb_ab20	roxl.w	#1,d1
	add.w	d1,d2
	subq.w	#7,d1
	beq.b	lb_ab0e
	bra.b	lb_ab6c
lb_ab2a	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_ab14
lb_ab30	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_ab1a
lb_ab36	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_ab20
lb_ab3c	moveq	#$0d,d0
	sub.b	(a2,d2.w),d0
	move.w	d0,d1
	add.w	d0,d0
	add.w	d1,d0
	add.w	d0,d0
	jmp	lb_ab4e(pc,d0.w)
lb_ab4e	lsr.l	#1,d5
	beq.b	lb_ab86
lb_ab52	roxl.w	#1,d3
	lsr.l	#1,d5
	beq.b	lb_ab8c
lb_ab58	roxl.w	#1,d3
	lsr.l	#1,d5
	beq.b	lb_ab92
lb_ab5e	roxl.w	#1,d3
	lsr.l	#1,d5
	beq.b	lb_ab98
lb_ab64	roxl.w	#1,d3
	lsr.l	#1,d5
	beq.b	lb_ab9e
lb_ab6a	roxl.w	#1,d3
lb_ab6c	move.b	(a1,d3.w),-(a1)
lb_ab70	move.b	(a1,d3.w),-(a1)
	dbf	d2,lb_ab70
;;	move.w	a1,(a3)
	cmpa.l	a1,a4
	bcs.w	lb_a9fa
lb_ab80	movem.l	(a7)+,d2-d7/a2-a6
	rts	
lb_ab86	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_ab52
lb_ab8c	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_ab58
lb_ab92	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_ab5e
lb_ab98	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_ab64
lb_ab9e	move.l	-(a0),d5
	roxr.l	#1,d5
	bra.b	lb_ab6a

	dc.w	$0080,$40c0,$20a0,$60e0,$1090,$50d0,$30b0,$70f0
	dc.w	$0888,$48c8,$28a8,$68e8,$1898,$58d8,$38b8,$78f8
	dc.w	$0484,$44c4,$24a4,$64e4,$1494,$54d4,$34b4,$74f4
	dc.w	$0c8c,$4ccc,$2cac,$6cec,$1c9c,$5cdc,$3cbc,$7cfc
	dc.w	$0282,$42c2,$22a2,$62e2,$1292,$52d2,$32b2,$72f2
	dc.w	$0a8a,$4aca,$2aaa,$6aea,$1a9a,$5ada,$3aba,$7afa
	dc.w	$0686,$46c6,$26a6,$66e6,$1696,$56d6,$36b6,$76f6
	dc.w	$0e8e,$4ece,$2eae,$6eee,$1e9e,$5ede,$3ebe,$7efe
PPTable:	dc.w	$0181,$41c1,$21a1,$61e1,$1191,$51d1,$31b1,$71f1
	dc.w	$0989,$49c9,$29a9,$69e9,$1999,$59d9,$39b9,$79f9
	dc.w	$0585,$45c5,$25a5,$65e5,$1595,$55d5,$35b5,$75f5
	dc.w	$0d8d,$4dcd,$2dad,$6ded,$1d9d,$5ddd,$3dbd,$7dfd
	dc.w	$0383,$43c3,$23a3,$63e3,$1393,$53d3,$33b3,$73f3
	dc.w	$0b8b,$4bcb,$2bab,$6beb,$1b9b,$5bdb,$3bbb,$7bfb
	dc.w	$0787,$47c7,$27a7,$67e7,$1797,$57d7,$37b7,$77f7
	dc.w	$0f8f,$4fcf,$2faf,$6fef,$1f9f,$5fdf,$3fbf,$7fff
	dc.w	$0001,$0102,$0202,$0203,$0303,$0303,$0303,$0304
	dc.w	$0404,$0404,$0404,$0404,$0404,$0404,$0404,$0405
	dc.w	$0505,$0505,$0505,$0505,$0505,$0505,$0505,$0505
	dc.w	$0505,$0505,$0505,$0505,$0505,$0505,$0505,$0506
	dc.w	$0606,$0606,$0606,$0606,$0606,$0606,$0606,$0606
	dc.w	$0606,$0606,$0606,$0606,$0606,$0606,$0606,$0606
	dc.w	$0606,$0606,$0606,$0606,$0606,$0606,$0606,$0606
	dc.w	$0606,$0606,$0606,$0606,$0606,$0606,$0606,$0607
	dc.w	$0707,$0707,$0707,$0707,$0707,$0707,$0707,$0707
	dc.w	$0707,$0707,$0707,$0707,$0707,$0707,$0707,$0707
	dc.w	$0707,$0707,$0707,$0707,$0707,$0707,$0707,$0707
	dc.w	$0707,$0707,$0707,$0707,$0707,$0707,$0707,$0707
	dc.w	$0707,$0707,$0707,$0707,$0707,$0707,$0707,$0707
	dc.w	$0707,$0707,$0707,$0707,$0707,$0707,$0707,$0707
	dc.w	$0707,$0707,$0707,$0707,$0707,$0707,$0707,$0707
	dc.w	$0707,$0707,$0707,$0707,$0707,$0707,$0707,$0700

	incdir	ass:abdication/bit/
ReadError:	incbin	READERROR.pp
ReadErrorEnd:

	incdir	ass:abdication/bit/
FUNKYGURU:	incbin	FUNKYGURU.pp
FUNKYGURUEnd:


PPDecrunchLen:	equ	*-PPDecrunch





	incdir	ass:abdication/bit/
SpreadLogo:	incbin	DoSpread.pp
SpreadEnd:


	incdir	ass:abdication/bit/
Rekvires:	incbin	Need1MB.pp
RekviresEnd:



JnsWait	equ	1000
ModuleLoadMem:	dc.l	0
MusicSelector:
	lea	base,a6
	move.w	#$7FFF,DmaCon(a6)
	move.w	#$7FFF,IntEna(a6)

	FixPtr	ScreenBpl,SelectorGfx,2,40
	FixPtr	ScrollnBpl,ScrollerGfx,2,-46*1
	FixPtr	SprPtr,spr_FunkyLogo1,3,(spr_FunkyLogo2-spr_FunkyLogo1)

	move.w	#My_DmaCon,(JnsActiveDma).w
	lea	base,a6
	move.l	#My_Irq32,$6c.w
	move.w	#My_DmaCon,DmaCon(a6)
	move.w	#My_IntEna,IntEna(a6)

	lea	Base,a6
	lea	$BFD100,a5
	bsr.w	TD_Init
	bsr.w	TD_MotorOn
	bsr.w	TD_SeekZero


MainLoop:	WaitMouse
	move.w	ModNr(pc),d0
	mulu	#12,d0
	lea	ModTab(pc),a0

	tst.w	LastModule
	beq.w	.FirstModule

	cmp.l	#$80000,(ModuleLoadMem).w
	bhi.b	.ExtraMem

	bsr	FadeModule
.ExtraMem
	push.l	d0-a6
	move.w	10(a0,d0.w),d1	; sectors
	move.w	8(a0,d0.w),d0	; pos
	move.l	(ModuleLoadMem).w,a0
	bsr	TD_ReadSectors
	pull.l	d0-a6

	push.l	d0-a6
	move.l	a0,a1
	move.l	(ModuleLoadMem).w,a0
	add.l	4(a1,d0.w),a0
	move.l	(ModuleLoadMem).w,a3	; decrunch add
	add.w	#32,a3
	move.l	(ModuleLoadMem).w,a5
	add.w	#4,a5	; start of pp obj
	bsr.w	Decrunch
	pull.l	d0-a6

	push.l	d0-a6
	move.l	(a0,d0.w),d0
	move.l	(ModuleLoadMem).w,a0
	add.w	#32,a0
	bsr.w	DeltaDePacker
	pull.l	d0-a6

	cmp.l	#$80000,(ModuleLoadMem).w
	blo.b	.NoExtraMem2

	bsr	FadeModule
.NoExtraMem2

	cmp.l	#$80000,(ModuleLoadMem).w
	blo.b	.NoModuleCopy2

	lea	(TheEnd).w,a1
	move.l	(ModuleLoadMem).w,a2
	move.l	(a0,d0.w),d0
	lsr.l	#2,d0
.CoptLoop2	move.l	(a2)+,(a1)+
	subq.l	#1,d0
	bne.b	.CoptLoop2

.NoModuleCopy2	lea	(TheEnd).w,a0
	add.w	#32,a0
	move.l	a0,(ModulPtr).w
	bsr	JnsInit
	st	JnsModuleValid
	bra.w	MainLoop


.FirstModule
	move.w	#1,LastModule
	push.l	d0-a6
	move.w	10(a0,d0.w),d1	; sectors
	move.w	8(a0,d0.w),d0	; pos
	move.l	(ModuleLoadMem).w,a0
	bsr	TD_ReadSectors
	pull.l	d0-a6

	push.l	d0-a6
	move.l	a0,a1
	move.l	(ModuleLoadMem).w,a0
	add.l	4(a1,d0.w),a0
	move.l	(ModuleLoadMem).w,a3	; decrunch add
	add.w	#32,a3
	move.l	(ModuleLoadMem).w,a5
	add.w	#4,a5	; start of pp obj
	bsr.w	Decrunch
	pull.l	d0-a6

	push.l	d0-a6
	move.l	(a0,d0.w),d0
	move.l	(ModuleLoadMem).w,a0
	add.w	#32,a0
	bsr.w	DeltaDePacker
	pull.l	d0-a6

	cmp.l	#$80000,(ModuleLoadMem).w
	blo.b	.NoModuleCopy

	lea	(TheEnd).w,a1
	move.l	(ModuleLoadMem).w,a2
	move.l	(a0,d0.w),d0
	lsr.l	#2,d0
.CoptLoop	move.l	(a2)+,(a1)+
	subq.l	#1,d0
	bne.b	.CoptLoop
	
.NoModuleCopy	lea	(TheEnd).w,a0
	add.w	#32,a0
	move.l	a0,(ModulPtr).w
	bsr	JnsInit
	st	(JnsModuleValid).w
	bra.w	MainLoop


FadeModule:	st	JnsFaderActive
.WaitFade	cmp.w	#64,(JnsFadeStep).w
	bne.b	.WaitFade
	sf	JnsModuleValid
	sf	JnsFaderActive
	move.w	#0,(JnsFadeStep).w
	rts
 Lev 3 Irq 
LastModule:	dc.w	0
My_Irq32:	Push	d0-a6
	lea	Base,a6
	move.l	#SelectCopper,Cop2Lch(a6)
	clr.w	CopJmp2(a6)
>-----------------------------------------------------------------------------<

	jsr	JnsMusic

	jsr	Selector

	jsr	Scroller

	btst	#10,PotInp(a6)
	bne.b	.NoCol
	cmp.b	#0,RightDownC
	bne.b	.col2
	bsr	MakeRndColor
	bra.b	.nocol2

.col2	sub.b	#1,RightDownC
	tst.b	RightDown
	bne	.NoCol2
	bsr	MakeRndColor
	st	RightDown
	bra.b	.NoCol2
.NoCol	sf	RightDown
	move.b	#30,RightDownC
.NoCol2

>-----------------------------------------------------------------------------<
	pull	d0-a6
	move.w	#$0020,IntReq+base
	rte
MaxRaster:	dc.w	0
RightDown:	dc.b	0
RightDownC:	dc.b	30
 Copper data 
SelectCopper:	dc.w	DiwStrt,$2C71,DiwStop,$2Cd1
	dc.w	DdfStrt,$0038,DdfStop,$00D0
	dc.w	BplCon0,$0200,BplCon1,$0000,BplCon2,$0024
	dc.w	Bpl1Mod,40,Bpl2Mod,40
SprPtr:	SPRZERO

	dc.w	color00,$000
	;dc.w	color00,$400
Cop_Col02:	dc.w	color02,$740	; 
Cop_Col03:	dc.w	color03,$200	; 222-666

Cop_Col03_1:	dc.w	color17,$200	; 
Cop_Col03_2:	dc.w	color21,$200	; 
	dc.w	$5c11,$fffe
	dc.w	BplCon0,$1200
Cop_Col00:	dc.w	color00,$400
	dc.w	color01,$400
	dc.w	$7c11,$fffe
ScreenBpl:	dc.w	Bpl1Pth,0,Bpl1Ptl,0
	dc.w	Bpl2Pth,0,Bpl2Ptl,0
	dc.w	BplCon0,$2200
Cop_Col01:	dc.w	color01,$a70

Cop_Pos1:	dc.w	$9111,$fffe
	dc.w	color01,$fff
Cop_Pos2:	dc.w	$9711,$fffe
Cop_Col01_3:	dc.w	color01,$a70

	dc.w	$c511,$fffe
	dc.w	BplCon0,$0200
ScrollnBpl:	dc.w	Bpl1Pth,0,Bpl1Ptl,0
	dc.w	Bpl2Pth,0,Bpl2Ptl,0
	dc.w	DdfStrt,$0030,DdfStop,$00D8
	dc.w	Bpl1Mod,2,Bpl2Mod,2
	dc.w	$d411,$fffe
	dc.w	BplCon0,$2200
	dc.w	BplCon1,$0020
Cop_Col01_1:	dc.w	color01,$a70
Cop_Col03_3:	dc.w	color02,$200
Cop_Col01_2:	dc.w	color03,$a70

	dc.w	$df11,$fffe
	dc.w	BplCon0,$0200

	dc.w	$e511,$fffe
	dc.w	color00,$000
	EndCop


>0-1-2-3-4-5-6-7-8-9-A-B-C-D-E-F-G-H-I-J-I-H-G-F-E-D-C-B-A-9-8-7-6-5-4-3-2-1-0<
 

MakeRndColor:
	moveq	#0,d7	; new base color
	move.w	#5+1,d0
	bsr	RangeRnd
	lsl.w	#8,d0
	or.w	d0,d7
	move.w	#5+1,d0
	bsr	RangeRnd
	lsl.w	#4,d0
	or.w	d0,d7
	move.w	#5+1,d0
	bsr	RangeRnd
	or.w	d0,d7
	move.w	d7,Cop_Col03+2
	move.w	d7,Cop_Col03_2+2
	move.w	d7,Cop_Col03_1+2
	move.w	d7,Cop_Col03_3+2

	move.w	#2+1,d0
	bsr	RangeRnd
	cmp.w	#0,d0
	beq.b	.AddRed
	cmp.w	#1,d0
	beq.b	.AddGreen
	cmp.w	#2,d0
	beq.b	.AddBlue
	illegal

.AddRed	move.w	#8,d6
	move.w	#1+1,d0
	bsr	RangeRnd
	cmp.w	#0,d0
	beq.b	.AddGreen_red
	cmp.w	#1,d0
	beq.b	.AddBlue_red
	illegal
.AddGreen_red	move.w	#4,d5
	bra.b	.dorestcol
.AddBlue_red	move.w	#0,d5
	bra.b	.dorestcol

.AddGreen	move.w	#4,d6
	move.w	#1+1,d0
	bsr	RangeRnd
	cmp.w	#0,d0
	beq.b	.AddRed_green
	cmp.w	#1,d0
	beq.b	.AddBlue_green
	illegal
.AddRed_green	move.w	#8,d5
	bra.b	.dorestcol
.AddBlue_green	move.w	#0,d5
	bra.b	.dorestcol

.AddBlue	move.w	#0,d6
	move.w	#1+1,d0
	bsr	RangeRnd
	cmp.w	#0,d0
	beq.b	.AddRed_blue
	cmp.w	#1,d0
	beq.b	.AddGreen_blue
	illegal
.AddRed_blue	move.w	#8,d5
	bra.b	.dorestcol
.AddGreen_blue	move.w	#4,d5
	bra.w	.dorestcol

.dorestcol	move.w	d7,d3
	move.w	#5,d4
	lsl.w	d6,d4
	add.w	d4,d3
	move.w	#4,d4
	lsl.w	d5,d4
	add.w	d4,d3
	move.w	d3,Cop_Col02+2

	move.w	d7,d3
	move.w	#9,d4
	lsl.w	d6,d4
	add.w	d4,d3
	move.w	#7,d4
	lsl.w	d5,d4
	add.w	d4,d3
	move.w	d3,Cop_Col01+2
	move.w	d3,Cop_Col01_1+2
	move.w	d3,Cop_Col01_2+2
	move.w	d3,Cop_Col01_3+2

	move.w	#4,d4
	lsl.w	d6,d4
	add.w	d4,d7
	move.w	d7,Cop_Col00+2
	move.w	d7,Cop_Col00+2+4



.UseOrgColor	rts

Peletter:	dc.w	$400,$a70,$740,$200
	dc.w	$004,$07a,$047,$002
	dc.w	$040,$7a0,$470,$020

Selector:	bsr	ReadMouse
	move.w	MouseY(pc),d0

	lea	AttractTab(pc),a0
	moveq	#10-1,d7
.loop	cmp.w	(a0),d0
	blo.b	.NoAttract
	cmp.w	2(a0),d0
	bhi.b	.NoAttract

	add.w	4(a0),d0
	move.w	d0,MouseY
	bra.b	.out

.NoAttract:	lea	8(a0),a0
	dbra	d7,.loop
	
.out	move.w	6(a0),d1
	move.w	d1,ModNr
	add.w	#$91,d0
	move.b	d0,Cop_Pos1
	add.b	#7,d0
	move.b	d0,Cop_Pos2
	rts

AttractTab:
	dc.w	0,0,0,0
	dc.w	1,3,-1,0

	dc.w	4,5,1,1
	dc.w	6,6,0,1
	dc.w	7,10,-1,1

	dc.w	11,14,1,2
	dc.w	15,15,0,2
	dc.w	16,19,-1,2

	dc.w	20,23,1,3
	dc.w	24,24,0,3

ModNr:	dc.w	0

ModTab:	dc.l	65190,47972	; org len, cru len
	dc.w	1665,94	; pos, sectors
	dc.l	129828,77708	; org len, cru len
	dc.w	1171,152	; pos, sectors
	dc.l	206200,173632	; org len, cru len
	dc.w	1324,340	; pos, sectors
	dc.l	317500,229384	; org len, cru len
	dc.w	721,449	; pos, sectors



;;0 6 15 24
;	dc.w	4,10,1
;	dc.w	11,20,-1
;	dc.w	31,40,1


Scroller:	lea	base,a6
	waitblit
	move.l	#ScrollerGfx,BltDPth(a6)
	move.l	#ScrollerGfx+2,BltAPth(a6)
	move.l	#$E9F00000,BltCon0(A6)
	move.l	#-1,BltAfwm(a6)
	move.w	#0,BltAMod(a6)
	move.w	#0,BltDMod(a6)
	move.w	#9<<6+23,BltSize(a6)

	subq.w	#1,NewFont
	bne.b	.out
	move.w	#4,NewFont
	lea	Text(pc),a0
.ff	move.w	TextP(pc),d0
	addq.w	#1,TextP
	move.b	(a0,d0.w),d0
	bne.b	.ok
	clr.w	TextP
	bra.b	.ff
.ok	ext.w	d0
	sub.b	#32,d0
	lea	HITH_TO_ASCII(pc),a0
	add.w	d0,d0
	move.w	(a0,d0.w),d0
	lea	ScrollFont(pc),a0
	lea	(a0,d0.w),a0
	lea	ScrollerGfx+45+46(pc),a1
	clr.b	-46(a1)
	moveq	#8-1,d2
.loop	move.b	(a0),(a1)
	add.w	#54,a0
	add.w	#46,a1
	dbf	d2,.loop
.out	rts

NewFont:	dc.w	1
TextP:	dc.w	0
Text:	dc.b	"DETTE ER DISK NR "
	DISKNR	
	blk.b	44," "
 DC.B "HEWOV! WELCOME TO PLANE (THE LYDSPOR), LMB TO DICK A TUNE, "
 DC.B "RMB TO CHANGE THE PALETTE-ULF. I'M A SMALL "
 DC.B "TIRED BOY SO I'LL JUST GIVE A MASSAGE (A B=MB?) OR TWO.... "
 DC.B "OG HERE WE GO IN ALFABETISK R<K'F=LGE: "

 DC.B "AN=RCHY- HEJ SLAM, ER DO K>D I D>SEN? (I'M WAITING FOR MY "
 DC.B "CUE....) TUSIND MILLIONER TAK "
 DC.B "FOR HJ<LPEN, DET VAR S=RME FLINKT AF DIG, MIN DRENG... "
 DC.B "XIENCE: WEJ WYNES WAT WIT W<G WER WEGA WEJ! WOG WIT W>R "
 DC.B "WER WODT W> WEJ, WEH?....WELEASE WRODEWRICK...WELEASE "
 DC.B "WRIAN, WEH?(SAY HEY TO BIGUS DICKUS, EH?)..PLAT!, EH?.. "
 DC.B "                   "                                               
 DC.B "D-D-7, ER DET SA'N MAN STAVER DET? JEG ER KED AF AT JEG IKKE HAVDE "
 DC.B "NOGLE MODULER DU KUNNE F>, MEN JEG H>BER DU KAN BRUGE DENNEHER, EH?"
 DC.B "                   "
 DC.B "HIMSELF- BORED, JONES GIDER IKKE SKRIVE NOGET TIL DIG, MEN DET ER "
 DC.B "NU OGS> LIGE MEGET, FOR INDTIL NU HAR JEG SKREVET DET HELE SELV, "
 DC.B "GRRRRRRR! JEG ER TR<T!!!! KLOKKEN ER OM MORGENEN OG JEG VIL SOVE. "
 DC.B "JONES ER SIKKERT F<RDIG MED DEMOEN INDENFOR ET PAR TIMER, NOT! "
 DC.B "                  "
 DC.B "K>VFRANS- HEJ AWK OG HAWK. DET ER KUN FOR SJOV, AT VI L<NER JERES "
 DC.B "INTRO-ULF, JEG H>BER IK' AT I ER SURE....TUSIND TAK FOR L>N AF "  
 DC.B "THE EAR-STEAKS, AWK, OG FOR GFX'EN, EH? (STOP IT!) "
 DC.B "                   "
 DC.B "MELON- JUBEL-TAK FORDI DU FIK OS MED I KONKURRENCE, SEEN. DET VAR "
 DC.B "<VERLIGT AT VI IK' N>'ED DET. H>BER DU GIDER SPREDE DEN, OG AT "
 DC.B "DU LIDE DEN KAN."
 DC.B "                   "
 DC.B "PARAJUNK- JUHUU (EH?), <SEL. LEGER DU GODT. SPRED VORES ULFTRO, "
 DC.B "FOR DEN ER N<MLI' BARE GU'ER, JA DEN ER, JA DEN ER S>. LEV GODT. "
 DC.B "                   "
 DC.B "SCOOPEX- EXECUTIONER, SPRED SOM VAR DU MED I REDNEX, GAMLE DRENG! "
 DC.B "DET VAR T<T P> EN BJ=RNSK OPLEVELSE AT SE DIG TR<T, EH? "
 DC.B "                   "
 DC.B "SHINING- CORNY, HERE IS THE FINAL VERSION, I HOPE IT WORKS ON YOUR "
 DC.B "SM=LF...SEE YA SOON, EH? "
 DC.B "                   "
 DC.B "SILENTS- BIONIC! VI SKA' SNART LEGE SAMMEN, EH? HVIS DU VIL SPREDE "
 DC.B "MINE, SKAL JEG NOK SPREDE DINE, EH? (SKA' VI SE HINANDENS....) "
 DC.B " <RGERLIGT MED DEN DEADLINE P> DIN...."
 DC.B "                   "
 DC.B "STATICK BITES- (SO B-WARE, EH?), EH?. QUACKANKER, JEG ER KED "
 DC.B "AF ET HAVE HUGGET JERES ENESTE RIGTIGE KODER P< DELSM=LF. "
 DC.B "JEG SKAL NOK G=RE DET SM=LF IGEN, EH? (SNUT UP!, EH? (>HHH NEJ, HUH?) "
 DC.B "ARGHH! IT'S GETTIN' OUT OF HAND HERE, EH?...SHUT UP!........LEGEJOHN, "
 DC.B "JEG SKA' GI' DIG IDEA AND CONCEPT, SKA' JEG, JA JEG SKA', EH!!, OG "
 DC.B "ALLE JER ANDRE, MASSER JER SELV JEG ER FOR TR<T TIL AT G=RE DET, EH? "
 DC.B "                   " 
 DC.B "WARPIGS(W?P)- HALLO DIETER(DT) NEH?, UND HALLO MEGA MADNESS(MM(SMELTER I "
 DC.B "H>RET IKKE I ...NEH?)). UND HALLO TSG(TSG) UND CASTOR(CST), NEH? "
 DC.B "MACHEN SIE VIELE PRODUKZIONEN, NEH? (EH?). "
 DC.B "                   "
 DC.B "WEBELS- WALLO WEBEL WONNIE, WARE WU WIXELLIZING, WOR WHAT, WEH? "
 DC.B "                   "
 dc.b "ELVIS IS DEAD, BUT IS REDNEX....MEGA HEJ TIL "
 DC.B "HAM DEN FLINKE FRA MAJIC 12 (TFG?), SOM SKREV S> P<NT OM RNX, "
 DC.B "GRUPPEN DER IK' VAR FOR B=RN, MEN HAVDE MIG MED! "
 DC.B " NU BURDE JEG BRUGE FYRRE LINJER P> AT UNDSKYLDE FOR STAVEFEJL, OG "
 DC.B "DEM VI HAR GLEMT, MEN DET GIDER JEG SGU' SM=LF!....FARVEL!.............."
 dc.b "DENNE SCROLL INDEHOLDER 23 EH?'ER.....................REDNEX RULEZ!  "
 blk.b 80," "
 DC.B 0

	even

HITH_TO_ASCII:	dc.w	53,38,43,0	; " !"#"
	dc.w	0,0,48,44	; "$%&'"
	dc.w	40,41,50,50	; "()*+"
	dc.w	46,47,45,42	; ",-./"
	dc.w	14,29,30,31	; "0123"
	dc.w	32,33,34,35	; "4567"
	dc.w	36,37,49,0	; "89:;"
	dc.w	26,27,28,39	; "<=>?"
	dc.w	0,0,1,2	; "@ABC"
	dc.w	3,4,5,6	; "DEFG"
	dc.w	7,8,9,10	; "HIJK"
	dc.w	11,12,13,14	; "LMNO"
	dc.w	15,16,17,18	; "PQRS"
	dc.w	19,20,21,22	; "TUVW"
	dc.w	23,24,25,0	; "XYZ "


 

ReadMouse:	move.w	Joy0dat+Base,d7
	move.w	d7,d1
	lsr.w	#8,d1
;	move.w	d7,d0
;	sub.b	OldMouseX,d0
	sub.b	OldMouseY,d1
;	ext.w	d0
	ext.w	d1
;	add.w	d0,MouseX
	add.w	d1,MouseY
	move.w	d7,OldMouseY
	cmp.w	#24,MouseY
	ble.b	.yok1
	move.w	#24,MouseY
.yok1:	tst.w	MouseY
	bge.b	.yok2
	clr.w	MouseY
.yok2:	;cmp.w	#255,MouseX
	;ble.b	.xok1
	;move.w	#255,MouseX
.xok1:	;tst.w	MouseX
	;bge.b	.xok2
	;clr.w	MouseX
.xok2:
	rts


OldMouseY:	dc.b	0
OldMouseX:	dc.b	0
;MouseX:	dc.w	0
MouseY:	dc.w	0

RangeRnd:	Movem.l	d1/d2,-(sp)
	Move.l	d0,d1
	Move.l	d0,d2
	Subq.l	#1,d1
	Move.l	RndBase,d0
	Add.l	#11,d0
RangeRndL1:	Add.l	d0,d0
	Bhi	RangeRndL2
	Eori.l	#$1D872B41,d0
RangeRndL2:	Lsr.w	#1,d1
	Bne	RangeRndL1
	add.l	d0,RndBase
	Mulu	d2,d0
	Clr.w	d0
	Swap	d0
	Movem.l	(sp)+,d1/d2
	Rts
InitRnd:	Moveq	#0,d0
	Move.w	VhPosr+base,d0
	Move.l	$dff00a,d1
	Rol.l	#5,d1
	Add.L	d1,d0
	Move.l	d0,RndBase
	Rts
RndBase:	dc.l	0



**********************************************************************
;n_note		=	0  ; W
n_cmd		=	2  ; W
n_cmdlo		=	3  ; B
n_start		=	4  ; L
n_length	=	8  ; W
n_loopstart	=	10 ; L
n_replen	=	14 ; W
n_period	=	16 ; W
n_finetune	=	18 ; B
n_volume	=	19 ; B
n_dmabit	=	20 ; W
n_toneportdirec	=	22 ; B
n_toneportspeed	=	23 ; B
n_wantedperiod	=	24 ; W
n_vibratocmd	=	26 ; B
n_vibratopos	=	27 ; B
n_tremolocmd	=	28 ; B
n_tremolopos	=	29 ; B
n_wavecontrol	=	30 ; B
n_glissfunk	=	31 ; B
n_sampleoffset	=	32 ; B
n_pattpos	=	33 ; B
n_loopcount	=	34 ; B
n_funkoffset	=	35 ; B
n_wavestart	=	36 ; L
n_reallength	=	40 ; W


JnsInit:	movem.l	d0-d2/a0-a2,-(sp)
	Lea	Base,a6
	move.l	ModulPtr(pc),a0
	move.l	a0,JnsModulPtr
	cmp.w	#$FEDE,(a0)
	beq.w	NoModule
	move.l	a0,a1
	lea	$3b8(a1),a1
	moveq	#$7f,d0
	moveq	#0,d1
JnsInitLoop1	move.l	d1,d2
	subq.w	#1,d0
JnsInitLoop2	move.b	(a1)+,d1
	cmp.b	d2,d1
	bgt.s	JnsInitLoop1
	dbra	d0,JnsInitLoop2
	addq.b	#1,d2
	lea	JnsSampleStarts(pc),a1
	asl.l	#8,d2
	asl.l	#2,d2
	add.l	#1084,d2
	add.l	a0,d2
	move.l	d2,a2
	moveq	#30,d0
JnsLoop3	clr.l	(a2)
	move.l	a2,(a1)+
	moveq	#0,d1
	move.w	42(a0),d1
	asl.l	#1,d1
	add.l	d1,a2
	add.w	#30,a0
	dbra	d0,JnsLoop3

	or.b	#2,$bfe001
	move.b	#6,JnsSpeed
	clr.b	JnsCounter
	clr.b	JnsSongPos
	clr.w	JnsPatternPos
	clr.b	JnsPBreakPos
	clr.b	JnsPosJumpFlag
	clr.b	JnsPBreakFlag
	clr.b	JnsPattDelTime
	clr.b	JnsPattDelTime2
	;;clr.b	$474f
	clr.b	JnsLowMask
	clr.w	JnsDMACONtemp
	move.w	#15,$96(a6)
	clr.w	$a8(a6)
	clr.w	$b8(a6)
	clr.w	$c8(a6)
	clr.w	$d8(a6)
	lea	JnsChan1Temp(pc),a0
	moveq	#1,d0
	bsr.s	JnsInitCall1
	lea	JnsChan2Temp(pc),a0
	moveq	#2,d0
	bsr.s	JnsInitCall1
	lea	JnsChan3Temp(pc),a0
	moveq	#4,d0
	bsr.s	JnsInitCall1
	lea	JnsChan4Temp(pc),a0
	moveq	#8,d0
	bsr.s	JnsInitCall1
	move.l	$78.w,JnsSysIrq
	move.b	$bfdd00,d0
	or.b	#$80,d0
	move.b	d0,JnsBFDD
	move.b	#$7f,$bfdd00
	move.b	#$81,$bfdd00
	move.b	$bfde00,JnsBFDE
	move.b	#0,$bfd400
	move.b	#2,$bfd500
	move.b	#$88,$bfde00
	move.w	#$2000,$9c(a6)
	move.w	#$a000,$9a(a6)
	movem.l	(sp)+,d0-d2/a0-a2
NoModule	rts

JnsInitCall1:	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	swap	d0
	move.l	d0,(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	rts

JnsRestore:	move.l	JnsSysIrq(pc),$78.w
	move.b	JnsBFDD(pc),$bfdd00
	move.b	JnsBFDE(pc),$bfde00
	rts

JnsIrq2:	movem.l	d0/a6,-(sp)
	lea	$dff000,a6
	tst.b	$bfdd00
	move.w	JnsDMACONtemp(pc),D0
	or.w	#$8000,d0
	move.w	d0,$96(a6)
	move.w	#$2000,$9c(a6)
	lea	JnsIrq1(pc),a6
	move.l	a6,$78
	move.b	#$89,$bfde00
	movem.l	(sp)+,d0/a6
	rte

JnsIrq1:	movem.l	d0/a0/a6,-(sp)
	lea	$dff000,a6
	tst.b	$bfdd00
	lea	Jnschan1temp(pc),a0
	move.l	AudChannel1(pc),a6
	move.l	n_loopstart(a0),(a6)
	move.w	n_replen(a0),4(a6)
	lea	Jnschan2temp(pc),a0
	move.l	AudChannel2(pc),a6
	move.l	n_loopstart(a0),(a6)
	move.w	n_replen(a0),4(a6)
	lea	Jnschan3Temp(pc),a0
	move.l	AudChannel3(pc),a6
	move.l	n_loopstart(a0),(a6)
	move.w	n_replen(a0),4(a6)
	lea	JnsChan4Temp(pc),a0
	move.l	AudChannel4(pc),a6
	move.l	n_loopstart(a0),(a6)
	move.w	n_replen(a0),4(a6)
	move.w	#$2000,$dff09c
	movem.l	(sp)+,d0/a0/a6
	rte

JnsEnd:	lea	$dff000,a6
	move.w	#15,$96(a6)
	clr.w	$a8(a6)
	clr.w	$b8(a6)
	clr.w	$c8(a6)
	clr.w	$d8(a6)
	move.w	#15,$96(a6)
	rts

JnsMusic:	movem.l	a5/a6,-(a7)
	move.l	JnsModulPtr(pc),a0
	cmp.w	#$FEDE,(a0)
	beq.w	JnsExit
	tst.b	JnsModuleValid
	beq.w	JnsExit
	tst.b	JnsFaderActive
	beq.s	lbc00027a

	lea	JnsFadeStep(pc),a0
	subq.w	#1,JnsFadeSkip
	bpl.s	JnsFadeNoAdd
	move.w	#1,JnsFadeSkip	;<<<--- FADE DOWN SPEED!
	addq.w	#1,(a0)
JnsFadeNoAdd	cmp.w	#64,(a0)
	blt.s	JnsFadeStetOver
	move.w	#64,(a0)
JnsFadeStetOver	move.w	(a0),d1
	moveq	#0,d0
	lea	Jnschan1temp(pc),a1
	move.b	$13(a1),d0	; GET VOL
	sub.w	d1,d0
	bpl.s	JnsFadeChan1
	clr.w	d0
JnsFadeChan1	move.l	AudChannel1(pc),a2
	move.w	d0,8(a2)
	lea	Jnschan2temp(pc),a1
	move.b	$13(a1),d0
	sub.w	d1,d0
	bpl.s	JnsFadeChan2
	clr.w	d0
JnsFadeChan2	move.l	AudChannel2(pc),a2
	move.w	d0,8(a2)
	lea	Jnschan3Temp(pc),a1
	move.b	$13(a1),d0
	sub.w	d1,d0
	bpl.s	JnsFadeChan3
	clr.w	d0
JnsFadeChan3	move.l	AudChannel3(pc),a2
	move.w	d0,8(a2)
	lea	JnsChan4Temp(pc),a1
	move.b	$13(a1),d0
	sub.w	d1,d0
	bpl.s	JnsFadeChan4
	clr.w	d0
JnsFadeChan4	move.l	AudChannel4(pc),a2
	move.w	d0,8(a2)
	bra.s	lbc000290

lbc00027a	tst.w	JnsFadeStep
	beq.s	lbc000290
	subq.w	#1,JnsFadeSkip
	bpl.s	lbc000290
	move.w	#1,JnsFadeSkip
	subq.w	#1,JnsFadeStep

lbc000290	move.w	#$fff,d5
	lea	JnsCounter(pc),a0
	addq.b	#1,(a0)
	move.b	(a0),d0
	cmp.b	JnsSpeed(pc),d0
	blo.s	JnsNoNewNote
	clr.b	(a0)
	tst.b	JnsPattDelTime2
	beq.s	JnsGetNewNote
	pea	JnsDskip(pc)
	bra.s	JnsNoNewAllChannels
JnsNoNewNote	pea	JnsNoNewPosYet(pc)
	bra.w	jnsnonewallchannels
JnsNoNewAllChannels
	move.l	AudChannel1(pc),a4
	lea	JnsChan1Temp(pc),a6
	bsr.w	JnsCheckEfx
	move.l	AudChannel2(pc),a4
	lea	JnsChan2Temp(pc),a6
	bsr.w	JnsCheckEfx
	move.l	AudChannel3(pc),a4
	lea	JnsChan3Temp(pc),a6
	bsr.w	JnsCheckEfx
	move.l	AudChannel4(pc),a4
	lea	JnsChan4Temp(pc),a6
	bra.w	JnsCheckEfx

JnsGetNewNote	move.L	JnsModulPtr(pc),a0
	lea	12(a0),a3
	lea	952(a0),a2	;pattpo
	lea	1084(a0),a0	;patterndata
	moveq	#0,d0
	moveq	#0,d1
	move.b	JnsSongPos(pc),d0
	move.b	(a2,d0.w),d1
	asl.l	#8,d1
	add.l	d1,d1
	add.l	d1,d1
	add.w	JnsPatternPos(pc),d1
	clr.w	JnsDMACONtemp
	move.l	AudChannel1(pc),a4
	lea	Jnschan1temp(pc),a6
	bsr.w	JnsPlayVoice
	move.l	AudChannel2(pc),a4
	lea	Jnschan2temp(pc),a6
	bsr.w	JnsPlayVoice
	move.l	AudChannel3(pc),a4
	lea	Jnschan3Temp(pc),a6
	bsr.w	JnsPlayVoice
	move.l	AudChannel4(pc),a4
	lea	JnsChan4Temp(pc),a6
	bsr.w	JnsPlayVoice
	lea	JnsIrq2(pc),a4
	move.l	a4,$78.w
	move.b	#137,$bfde00
JnsDskip	add.w	#16,JnsPatternPos
	move.b	JnsPattDelTime(pc),d0
	beq.s	JnsDskc
	move.b	d0,JnsPattDelTime2
	clr.b	JnsPattDelTime
JnsDskc	tst.b	JnsPattDelTime2
	beq.s	JnsDska
	subq.b	#1,JnsPattDelTime2
	beq.s	JnsDska
	sub.w	#16,JnsPatternPos
JnsDska	tst.b	JnsPBreakFlag
	beq.s	JnsNnpysk
	sf	JnsPBreakFlag
	moveq	#0,d0
	move.b	JnsPBreakPos(pc),d0
	clr.b	JnsPBreakPos
	lsl.w	#4,d0
	move.w	d0,JnsPatternPos
JnsNnpysk	cmp.w	#1024,JnsPatternPos
	bcs.s	JnsNoNewPosYet
JnsNextPosition
;	TX_txtR	"NewPat"

	moveq	#0,d0
	move.b	JnsPBreakPos(pc),d0
	lsl.w	#4,d0
	move.w	d0,JnsPatternPos
	clr.b	JnsPBreakPos
	clr.b	JnsPosJumpFlag
	addq.b	#1,JnsSongPos
	and.b	#$7f,JnsSongPos
	move.b	JnsSongPos,d1
	move.l	JnsModulPtr(pc),a0
	cmp.b	950(a0),d1
	blo.s	JnsNoNewPosYet
	clr.b	JnsSongPos
JnsNoNewPosYet	tst.b	JnsPosJumpFlag
	bne.s	JnsNextPosition
JnsExit	movem.l	(sp)+,a5/a6
	rts

JnsPlayVoice	tst.l	(a6)
	bne.s	JnsPlvskip
	move.w	$10(a6),6(a4)	
JnsPlvskip	move.l	(a0,d1.l),(a6)
	addq.l	#4,d1
	moveq	#0,d2
	move.b	n_cmd(a6),d2
	and.b	#$f0,d2
	lsr.b	#4,d2
	move.b	(a6),d0
	and.b	#$f0,d0
	or.b	d0,d2
	beq.w	JnsSetRegs
	moveq	#0,d3
	lea	JnsSampleStarts(pc),a1

	move.w	d2,d4
	subq.l	#1,d2
	add.l	d2,d2
	add.l	d2,d2
	add.w	d4,d4	\
	move.w	d4,d3	  MULU #30,d4
	lsl.w	#4,d4
	sub.w	d3,d4	/
	move.l	(a1,d2.l),n_start(a6)
	move.w	(a3,d4.w),n_length(a6)
	move.w	(a3,d4.w),n_reallength(a6)
	move.w	2(a3,d4.w),n_finetune(a6)
	move.w	4(a3,d4.w),d3	; Get repeat
	beq.s	JnsNoLoop
	move.l	n_start(a6),d2	; Get start
	add.w	d3,d3
	add.l	d3,d2
	move.l	d2,n_loopstart(a6)
	move.l	d2,n_wavestart(a6)
	move.w	4(a3,d4.w),d0	; Get repeat
	add.w	6(a3,d4.w),d0	; Add replen
	move.w	d0,n_length(a6)
	move.w	6(a3,d4.w),n_replen(a6)	; Save replen
	moveq	#0,d0
	move.b	n_volume(a6),d0
	sub.w	JnsFadeStep(pc),d0
	bpl.s	lbc000460
	clr.w	d0
lbc000460	move.w	d0,8(a4)
	bra.s	JnsSetRegs

JnsNoLoop	move.l	n_start(a6),d2
	add.l	d3,d2
	move.l	d2,n_loopstart(a6)
	move.l	d2,n_wavestart(a6)
	move.w	6(a3,d4.w),n_replen(a6)	; Save replen
	moveq	#0,d0
	move.b	n_volume(a6),d0
	sub.w	JnsFadeStep(pc),d0
	bpl.s	lbc000488
	clr.w	d0
lbc000488	move.w	d0,8(a4)

JnsSetRegs	move.w	(a6),d0
	and.w	d5,d0	; $FFF
	beq.w	JnsCheckMoreFx	; IF NO NOTE
	move.w	2(a6),d0
	and.w	#$ff0,d0
	cmp.w	#$e50,d0
	beq.s	JnsDoSetFineTune
	move.b	2(a6),d0
	and.b	#$0F,d0
	cmp.b	#3,d0	; TONEPORTAMENTO
	beq.s	JnsCnkTonePorta
	cmp.b	#5,d0
	beq.s	JnsCnkTonePorta
	cmp.b	#9,d0	; SAMPLE OFFSET
	bne.s	JnsSetPeriod
	pea	JnsSetPeriod(pc)
	bra.w	JnsCheckMoreFx

JnsCnkTonePorta	pea	JnsCheckMoreFx(pc)
	bra.w	JnsSetTonePorta

JnsDoSetFineTune
	bsr.w	JnsSetFineTune
JnsSetPeriod	tst.b	$12(a6)
	beq.s	lbc000508
	movem.l	d1/a0/a1,-(sp)
	move.w	(a6),d1
	and.w	d5,d1	; #$0FFF
	lea	JnsPeriodTable(pc),a1
	moveq	#0,d0
	moveq	#36,d7
JnsFtuloop	cmp.w	(a1,d0.w),d1
	bhs.s	JnsFtufound
	addq.l	#2,d0
	dbra	d7,JnsFtuloop
JnsFtufound	moveq	#0,d1
	move.b	n_finetune(a6),d1
	mulu	#36*2,d1
	add.l	d1,a1
	move.w	(a1,d0.w),n_period(a6)
	movem.l	(sp)+,d1/a0/a1
	bra.s	lbc000510

lbC000508	move.w	(a6),d0
	and.w	d5,d0
	move.w	d0,$10(a6)
lbc000510	move.w	2(a6),d0
	and.w	#$ff0,d0
	cmp.w	#$ed0,d0 ; Notedelay
	move.w	n_dmabit(a6),d0
	move.w	d1,-(sp)
	move.w	JnsActiveDma(pc),d1
	not.w	d1
	and.w	d1,d0
	move.w	d0,$dff096
	move.w	(sp)+,d1
	btst	#2,n_wavecontrol(a6)
	bne.s	JnsVibnoc
	clr.b	n_vibratopos(a6)
JnsVibnoc	btst	#6,n_wavecontrol(a6)
	bne.s	JnsTrenoc
	clr.b	n_tremolopos(a6)
JnsTrenoc	move.l	n_start(a6),(a4)
	move.w	n_length(a6),4(a4)	; Set length
	move.w	n_period(a6),d0
	move.w	d0,6(a4)
	move.w	n_dmabit(a6),D0
	or.w	d0,JnsDMACONtemp
	bra.w	JnsCheckMoreFx

JnsCheckEfx	move.b	n_cmd(a6),d0
	lsr.b	#4,d0
	beq.s	JnsPerNop
	bsr.w	JnsUpdateFunk
JnsPerNop	move.w	n_cmd(a6),d0
	and.w	d5,d0	; $0f
	beq.s	JnsArpeggio
	moveq	#0,d0
	move.b	n_cmd(a6),d0
	and.b	#$F,d0
	add.b	d0,d0
	add.b	d0,d0
	jmp	JnsEffektTab(pc,d0.w)

;; Must be WORDS
JnsEffektTab	bra.w	DetVedJegSkuIk
	bra.w	JnsPortaUp
	bra.w	JnsPortaDown
	bra.w	JnsTonePortamento
	bra.w	JnsVibrato
	bra.w	JnsTonePlusVolSlide
	bra.w	JnsVibratoPlusVolSlide
	bra.w	JnsTremolo
	bra.w	JnsNoCommand2
	bra.w	JnsNoCommand2
	bra.w	JnsVolumeSlide
	bra.w	JnsNoCommand2
	bra.w	JnsNoCommand2
	bra.w	JnsNoCommand2
	bra.w	JnsECommands
	bra.w	JnsNoCommand2
JnsNoCommand2	move.w	$10(a6),6(a4)
	rts

JnsReturn	rts

JnsArpeggio	move.w	$10(a6),6(a4)
	rts

DetVedJegSkuIk:	moveq	#0,d0
	move.b	JnsCounter(pc),D0
	divs	#3,d0
	swap	d0
	cmp.w	#0,d0
	beq.s	JnsArpeggio2
	cmp.w	#2,d0
	beq.s	JnsArpeggio1
	moveq	#0,d0
	move.b	n_cmdlo(a6),d0
	lsr.b	#4,d0
	bra.s	JnsArpeggio3

JnsArpeggio1	moveq	#0,d0
	move.b	n_cmdlo(a6),d0
	and.b	#$0f,d0
	bra.s	JnsArpeggio3
JnsArpeggio2	move.w	n_period(a6),d2
	bra.s	JnsArpeggio4
JnsArpeggio3	add.w	d0,d0
	moveq	#0,d1
	move.b	n_finetune(a6),d1
	mulu	#36*2,d1
	lea	JnsPeriodTable(pc),a0
	add.l	d1,a0
	moveq	#0,d1
	move.w	n_period(a6),d1

	moveq	#36,d7
JnsArpLoop	move.w	(a0,d0.w),d2
	cmp.w	(a0),d1
	bcc.s	JnsArpeggio4
	addq.l	#2,a0
	dbra	d7,JnsArpLoop
	rts
JnsArpeggio4	move.w	d2,6(a4)
	rts

JnsFinePortaUp:	tst.b	JnsCounter
	bne.s	JnsReturn
	move.b	#$0f,JnsLowMask

JnsPortaUp:	moveq	#0,d0
	move.b	n_cmdlo(a6),d0
	and.b	JnsLowMask(pc),d0
	move.b	#$ff,JnsLowMask
	sub.w	d0,n_period(a6)
	move.w	n_period(a6),d0
	and.w	d5,d0	; #$0FFF
	cmp.w	#113,d0
	bpl.s	JnsPortaUskip
	and.w	#$f000,n_period(a6)
	or.w	#113,n_period(a6)
JnsPortaUskip	move.w	n_period(a6),d0
	and.w	d5,d0	; #$0FFF
	move.w	d0,6(a4)
	rts

JnsFinePortaDown:
	tst.b	JnsCounter
	bne.w	JnsReturn
	move.b	#$0f,JnsLowMask

JnsPortaDown:	clr.w	d0
	move.b	n_cmdlo(a6),d0
	and.b	JnsLowMask(pc),D0
	move.b	#$ff,JnsLowMask
	add.w	d0,n_period(a6)
	move.w	n_period(a6),d0
	and.w	d5,d0	; #$0FFF
	cmp.w	#856,d0
	bmi.s	JnsPortaDskip
	and.w	#$f000,n_period(a6)
	or.w	#856,n_period(a6)
JnsPortaDskip	move.w	n_period(a6),d0
	and.w	d5,d0	; #$0fff
	move.w	d0,6(a4)
	rts

JnsSetTonePorta:move.l	a0,-(sp)
	move.w	(a6),d2
	and.w	d5,d2	; #$0FFF
	moveq	#0,d0
	move.b	n_finetune(a6),d0
	mulu	#37*2,d0
	lea	JnsPeriodTable(pc),a0
	add.l	d0,a0
	moveq	#0,d0
JnsStpLoop	cmp.w	(a0,d0.w),d2
	bhs.s	JnsStpFound
	addq.w	#2,d0
	cmp.w	#37*2,d0
	bcs.s	JnsStpLoop
	moveq	#35*2,d0

JnsStpFound	move.b	n_finetune(a6),d2
	and.b	#8,d2
	beq.s	JnsStpGoss
	tst.w	d0
	beq.s	JnsStpGoss
	subq.w	#2,d0
JnsStpGoss:	move.w	(a0,d0.w),d2
	move.l	(sp)+,a0
	move.w	d2,n_wantedperiod(a6)
	move.w	n_period(a6),d0
	clr.b	n_toneportdirec(a6)
	cmp.w	d0,d2
	beq.s	JnsClearTonePorta
	bge.w	JnsReturn
	move.b	#1,n_toneportdirec(a6)
	rts
JnsClearTonePorta
	clr.w	n_wantedperiod(a6)
	rts

JnsTonePortamento:
	move.b	n_cmdlo(a6),d0
	beq.s	JnsTonePortNoChange
	move.b	d0,n_toneportspeed(a6)
	clr.b	n_cmdlo(a6)
JnsTonePortNoChange
	tst.w	n_wantedperiod(a6)
	beq.w	JnsReturn
	moveq	#0,d0
	move.b	n_toneportspeed(a6),d0
	tst.b	n_toneportdirec(a6)
	bne.s	JnsTonePortaUp
;mt_TonePortaDown:
	add.w	d0,n_period(a6)
	move.w	n_wantedperiod(a6),d0
	cmp.w	n_period(a6),d0
	bgt.s	JnsPeriod
	move.w	n_wantedperiod(a6),n_period(a6)
	clr.w	n_wantedperiod(a6)
	bra.s	JnsPeriod	;	BRA.S	mt_TonePortaSetPer
JnsTonePortaUp	sub.w	d0,n_period(a6)
	move.w	n_wantedperiod(a6),d0
	cmp.w	n_period(a6),d0
	blt.s	JnsPeriod	;	BLT.S	mt_TonePortaSetPer
	move.w	n_wantedperiod(a6),n_period(a6)
	clr.w	n_wantedperiod(a6)
;mt_TonePortaSetPer:
JnsPeriod	move.w	n_period(a6),d2
	move.b	n_glissfunk(a6),d0
	and.b	#$F,d0
	beq.s	JnsGlissSkip
	moveq	#0,d0
	move.b	n_finetune(a6),d0
	mulu	#36*2,d0
	lea	JnsPeriodTable(pc),a0
	add.l	d0,a0
	moveq	#0,d0
JnsGlissLoop	cmp.w	0(a0,d0.w),d2
	bhs.s	JnsGlissFound
	addq.w	#2,d0
	cmp.w	#36*2,d0
	blo.s	JnsGlissLoop
	moveq	#35*2,d0
JnsGlissFound	move.w	(a0,d0.w),d2
JnsGlissSkip	move.w	d2,6(a4); Set period
	rts

JnsVibrato:	move.b	n_cmdlo(a6),d0
	beq.s	JnsVibrato2
	move.b	n_vibratocmd(a6),d2
	and.b	#$0F,d0
	beq.s	JnsVibSkip
	and.b	#$f0,d2
	or.b	d0,d2
JnsVibSkip	move.b	n_cmdlo(a6),d0
	and.b	#$f0,d0
	beq.s	JnsVibSkip2
	and.b	#$0f,d2
	or.b	d0,d2
JnsVibSkip2	move.b	d2,n_vibratocmd(a6)

JnsVibrato2	move.b	n_vibratopos(a6),d0
	lea	JnsVibratoTable(pc),a0
	lsr.w	#2,d0
	and.w	#$001f,d0
	moveq	#0,d2
	move.b	n_wavecontrol(a6),d2
	and.b	#3,d2
	beq.s	JnsVib_sine
	lsl.b	#3,d0
	cmp.b	#1,d2
	beq.s	JnsVib_rampdown
	move.b	#255,d2
	bra.s	JnsVib_set

JnsVib_rampdown	tst.b	n_vibratopos(a6)
	bpl.s	JnsVib_rampdown2
	move.b	#255,d2
	sub.b	d0,d2
	bra.s	JnsVib_set
JnsVib_rampdown2
	move.b	d0,d2
	bra.s	JnsVib_set
JnsVib_sine	move.b	(a0,d0.w),d2
JnsVib_set	move.b	n_vibratocmd(a6),d0
	and.w	#15,d0
	mulu	d0,d2
	lsr.w	#7,d2
	move.w	n_period(a6),d0
	tst.b	n_vibratopos(a6)
	bmi.s	JnsVibratoNeg
	add.w	d2,d0
	bra.s	JnsVibrato3
JnsVibratoNeg	sub.w	d2,d0
JnsVibrato3	move.w	d0,6(a4)
	move.b	n_vibratocmd(a6),d0
	lsr.w	#2,d0
	and.w	#$003c,d0
	add.b	d0,n_vibratopos(a6)
	rts

JnsTonePlusVolSlide:
	pea	JnsVolumeSlide(pc)
	bra.w	JnsTonePortNoChange
JnsVibratoPlusVolSlide:
	pea	JnsVolumeSlide(pc)
	bra.s	JnsVibrato2

JnsTremolo	move.w	$10(a6),6(a4)
	move.b	n_cmdlo(a6),d0
	beq.s	JnsTremolo2
	move.b	n_tremolocmd(a6),d2
	and.b	#$0f,d0
	beq.s	JnsTreSkip
	and.b	#$f0,d2
	or.b	d0,d2
JnsTreSkip	move.b	n_cmdlo(a6),d0
	and.b	#$f0,d0
	beq.s	JnsTreSkip2
	and.b	#$0f,d2
	or.b	d0,d2
JnsTreSkip2	move.b	d2,n_tremolocmd(a6)
JnsTremolo2	move.b	n_tremolopos(a6),d0
	lea	JnsVibratoTable(pc),a0
	lsr.w	#2,d0
	and.w	#$001f,d0
	moveq	#0,d2
	move.b	n_wavecontrol(a6),d2
	lsr.b	#4,d2
	and.b	#$03,d2
	beq.s	JnsTreSine
	lsl.b	#3,d0
	cmp.b	#1,d2
	beq.s	JnsTreRampDown
	move.b	#255,d2
	bra.s	JnsTreSet
JnsTreRampDown	tst.b	n_vibratopos(a6)
	bpl.s	JnsTreRampDown2
	move.b	#255,d2
	sub.b	d0,d2
	bra.s	JnsTreSet
JnsTreRampDown2	move.b	d0,d2
	bra.s	JnsTreSet
JnsTreSine	move.b	(a0,d0.w),d2
JnsTreSet	move.b	n_tremolocmd(a6),d0
	and.w	#15,d0
	mulu	d0,d2
	lsr.w	#6,d2
	moveq	#0,d0
	move.b	n_volume(a6),d0
	tst.b	n_tremolopos(a6)
	bmi.s	JnsTremoloNeg
	add.w	d2,d0
	bra.s	JnsTremolo3
JnsTremoloNeg	sub.w	d2,d0
JnsTremolo3	bpl.s	JnsTremoloSkip
	clr.w	d0
JnsTremoloSkip	cmp.w	#$40,d0
	bls.s	JnsTremoloOk
	move.w	#$40,d0
JnsTremoloOk	sub.w	JnsFadeStep(pc),d0
	bpl.s	JnsFadeVol
	clr.w	d0
JnsFadeVol	move.w	d0,8(a4)
	move.b	n_tremolocmd(a6),d0
	lsr.w	#2,d0
	and.w	#$003c,d0
	add.b	d0,n_tremolopos(a6)
	rts

JnsSampleOffset:moveq	#0,d0
	move.b	n_cmdlo(a6),d0
	beq.s	JnsSoNoNew
	move.b	d0,n_sampleoffset(a6)
JnsSoNoNew	move.b	n_sampleoffset(a6),d0
	lsl.w	#7,d0
	cmp.w	n_length(a6),d0
	bge.s	JnsSofSkip
	sub.w	d0,n_length(a6)
	lsl.w	#1,d0
	add.l	d0,n_start(a6)
	rts
JnsSofSkip	move.w	#$0001,n_length(a6)
	rts

JnsVolumeSlide:	move.w	$10(a6),6(a4)
	moveq	#0,d0
	move.b	n_cmdlo(a6),d0
	lsr.b	#4,d0
	tst.b	d0
	beq.s	JnsVolSlideDown
jnsvolslideup:	add.b	d0,n_volume(a6)
	cmp.b	#$40,n_volume(a6)
	bmi.s	JnsVsuSkip
	move.b	#$40,n_volume(a6)
JnsVsuSkip:	move.b	n_volume(a6),d0
	sub.w	JnsFadeStep(pc),d0
	bpl.s	JnsVolMulu
	clr.w	d0
JnsVolMulu:	move.w	d0,8(a4)
	rts

JnsVolSlideDown:moveq	#0,d0
	move.b	n_cmdlo(a6),d0
	and.b	#$0f,d0
JnsVolSlideDown2:
	sub.b	d0,n_volume(a6)
	bpl.s	JnsVsdSkip
	clr.b	n_volume(a6)
JnsVsdSkip:	move.b	n_volume(a6),d0
	sub.w	JnsFadeStep(pc),d0
	bpl.s	JnsVolMuld
	clr.w	d0
JnsVolMuld:	move.w	d0,8(a4)
	rts

JnsPositionJump:move.b	n_cmdlo(a6),d0
	subq.b	#1,d0
	move.b	d0,JnsSongPos
JnsNj2	clr.b	JnsPBreakPos
	st 	JnsPosJumpFlag
	rts

JnsVolumeChange:moveq	#0,d0		; $9ba
	move.b	n_cmdlo(a6),d0	;
	cmp.b	#$40,d0		;
	bls.s	JnsVolumeOk	;
	moveq	#$40,d0		;
JnsVolumeOk	move.b	d0,n_volume(a6)	;
	sub.w	JnsFadeStep(pc),d0	; $158
	bpl.s	JnsVolumeClr	; $9dc
	clr.w	d0		; 
JnsVolumeClr	move.w	d0,8(a4)	; 
	rts		; 

JnsPatternBreak:moveq	#0,d0		;	$9da
	move.b	n_cmdlo(a6),d0	;
	move.l	d0,d2		;
	lsr.b	#4,d0		;
	mulu	#10,d0		;
	and.b	#$0f,d2		;
	add.b	d2,d0		;
	cmp.b	#63,d0		;
	bhi.s	JnsNj2		;	$9b0
	move.b	d0,JnsPBreakPos	;	$4749
	st 	JnsPosJumpFlag	;	$474a
	rts

JnsSetSpeed:	move.b	n_cmdlo(a6),d0
	beq.w	JnsReturn
	clr.b	JnsCounter
	move.b	d0,JnsSpeed
	rts

JnsCheckMoreFx	move.b	n_glissfunk(a6),d0	;
	lsr.b	#4,d0		;
	beq.s	JnsChkFunk		;
	bsr.w	JnsUpdateFunk
JnsChkFunk	move.b	n_cmd(a6),d0		;
	and.b	#$0f,d0		;
	beq.b	JnsNoCommand
	sub.b	#9,d0		;
	beq.w	JnsSampleOffset
	subq.b	#2,d0		;
	beq.w	JnsPositionJump
	subq.b	#1,d0		;
	beq.w	JnsVolumeChange		; 
	subq.b	#1,d0		;
	beq.b	JnsPatternBreak		;
	subq.b	#1,d0		;
	beq.s	JnsECommands
	subq.b	#1,d0		;
	beq.s	JnsSetSpeed
JnsNoCommand	rts

JnsECommands	moveq	#0,d0
	move.b	n_cmdlo(a6),d0
	lsr.b	#2,d0
	jmp	JnsECommandsTab(pc,d0.w)
lbc000a58	rts
;; Must be word alligned
JnsECommandsTab:bra.w	JnsFilterOnOff
	bra.w	JnsFinePortaUp
	bra.w	JnsFinePortaDown
	bra.w	JnsSetGlissControl
	bra.w	JnsSetVibratoControl
	bra.w	JnsSetFineTune
	bra.w	JnsJumpLoop
	bra.w	JnsSetTremoloControl
	bra.w	lbc000a58
	bra.w	JnsRetrigNote
	bra.w	JnsVolumeFineUp
	bra.w	JnsVolumeFineDown
	bra.w	JnsNoteCut
	bra.w	JnsNoteDelay
	bra.w	JnsPatternDelay
	bra.w	JnsFunkIt

JnsFilterOnOff:	move.b	n_cmdlo(a6),d0
	and.b	#1,d0
	asl.b	#1,d0
	and.b	#$fd,$bfe001
	or.b	d0,$bfe001
	rts

JnsSetGlissControl:
	move.b	n_cmdlo(a6),d0
	and.b	#$0f,d0
	and.b	#$f0,n_glissfunk(a6)
	or.b	d0,n_glissfunk(a6)
	rts

JnsSetVibratoControl:
	move.b	n_cmdlo(a6),d0
	and.b	#$0f,d0
	and.b	#$f0,n_wavecontrol(a6)
	or.b	d0,n_wavecontrol(a6)
	rts

JnsSetFineTune	move.b	3(a6),d0
	and.b	#$F,d0
	move.b	d0,$12(a6)
	rts

JnsJumpLoop:	tst.b	JnsCounter
	bne.w	JnsReturn
	move.b	n_cmdlo(a6),d0
	and.b	#$0f,d0
	beq.s	JnsSetLoop
	tst.b	n_loopcount(a6)
	beq.s	JnsJumpCnt
	subq.b	#1,n_loopcount(a6)
	beq.w	JnsReturn
JsnJmpLoop	move.b	n_pattpos(a6),JnsPBreakPos
	st 	JnsPBreakFlag
	rts

JnsJumpCnt	move.b	d0,n_loopcount(a6)
	bra.s	JsnJmpLoop
JnsSetLoop	move.w	JnsPatternPos(pc),D0
	lsr.w	#4,d0
	move.b	d0,$21(a6)
	rts

JnsSetTremoloControl:
	move.b	n_cmdlo(a6),d0
	and.b	#$0f,d0
	lsl.b	#4,d0
	and.b	#$0f,n_wavecontrol(a6)
	or.b	d0,n_wavecontrol(a6)
	rts

JnsRetrigNote:	move.l	d1,-(sp)
	moveq	#0,d0
	move.b	n_cmdlo(a6),d0
	and.b	#$0f,d0
	beq.s	JnsRtnEnd
	moveq	#0,d1
	move.b	JnsCounter(pc),d1
	bne.s	JnsRtnSkp
	move.w	(a6),d1
	and.w	d5,d1	;#$0FFF
	bne.s	JnsRtnEnd
	moveq	#0,d1
	move.b	JnsCounter(pc),d1
JnsRtnSkp	divu	d0,d1
	swap	d1
	tst.w	d1
	bne.s	JnsRtnEnd
JnsDoRetrig	move.w	$14(a6),d0
	move.w	JnsActiveDma(pc),d1
	not.w	d1
	and.w	d1,d0
	move.w	d0,$dff096
	move.l	4(a6),(a4)
	move.w	8(a6),4(a4)
	move.w	#JnsWait,d0		; WAIT
;	move.w	#$fff,$dff180
JnsRtnLoop1	dbra	d0,JnsRtnLoop1
	move.w	n_dmabit(a6),d0
	bset	#15,d0
	move.w	d0,$dff096
	move.w	#JnsWait,d0
;	move.w	#$fff,$dff180
JnsRtnLoop2	dbra	d0,JnsRtnLoop2
	move.l	n_loopstart(a6),(a4)
	move.l	n_replen(a6),4(a4)
JnsRtnEnd	move.l	(sp)+,d1
	rts

JnsVolumeFineUp:tst.b	JnsCounter
	bne.w	JnsReturn
	move.b	n_cmdlo(a6),d0
	and.b	#$F,d0
	bra.w	JnsVolSlideUp

JnsVolumeFineDown:
	tst.b	JnsCounter
	bne.w	JnsReturn
	moveq	#0,d0
	move.b	n_cmdlo(a6),d0
	and.b	#$f,d0
	bra.w	JnsVolSlideDown

JnsNoteCut:	moveq	#0,d0
	move.b	n_cmdlo(a6),d0
	and.b	#$0F,d0
	cmp.b	JnsCounter,D0
	bne.w	JnsReturn
	clr.b	n_volume(a6)
	move.w	#0,8(a4)
	rts

JnsNoteDelay:	moveq	#0,d0
	move.b	n_cmdlo(a6),d0
	and.b	#$0f,d0
	cmp.b	JnsCounter(pc),d0
	bne.w	JnsReturn
	move.w	(a6),d0
	beq.w	JnsReturn
	move.l	d1,-(sp)
	bra.w	JnsDoRetrig

JnsPatternDelay:tst.b	JnsCounter
	bne.w	JnsReturn
	moveq	#0,d0
	move.b	n_cmdlo(a6),d0
	and.b	#$0F,d0
	tst.b	JnsPattDelTime2
	bne.w	JnsReturn
	addq.b	#1,d0
	move.b	d0,JnsPattDelTime
	rts

JnsFunkIt:	tst.b	JnsCounter
	bne.w	JnsReturn
	move.b	n_cmdlo(a6),d0
	and.b	#$0f,d0
	lsl.b	#4,d0
	and.b	#$0f,n_glissfunk(a6)
	or.b	d0,n_glissfunk(a6)
	tst.b	d0
	beq.w	JnsReturn

JnsUpdateFunk	movem.l	d1/d2/a0,-(sp)
	moveq	#0,d0
	move.b	n_glissfunk(a6),d0
	lsr.b	#4,d0
	beq.s	JnsFunkEnd
	lea	JnsFunkTable(pc),a0
	move.b	(a0,d0.w),d0
	add.b	d0,n_funkoffset(a6)
	btst	#7,n_funkoffset(a6)
	clr.b	n_funkoffset(a6)
	move.l	n_loopstart(a6),d1
	moveq	#0,d2
	move.w	n_replen(a6),d2
	lsl.w	#1,d2
	add.l	d2,d1
	move.w	n_replen(a6),d2
	lsl.l	#1,d2
	sub.l	d2,d1
	move.l	n_wavestart(a6),d2
	moveq	#0,d0
	move.w	n_replen(a6),d0
	lsl.l	#1,d0
	add.l	d0,d2
	cmp.l	d1,d2
	bls.s	JnsFunkOk
	move.l	n_loopstart(a6),d2
JnsFunkOk	move.l	d2,n_wavestart(a6)
	move.l	d2,(a4)
JnsFunkEnd	movem.l	(sp)+,d1/d2/a0
	rts
JnsFunkTable:	dc.b 0,5,6,7,8,10,11,13,16,19,22,26,32,43,64,128

JnsVibratoTable:dc.b   0, 24, 49, 74, 97,120,141,161
	dc.b 180,197,212,224,235,244,250,253
	dc.b 255,253,250,244,235,224,212,197
	dc.b 180,161,141,120, 97, 74, 49, 24

JnsPeriodTable:
; Tuning 0, Normal
	dc.w	856,808,762,720,678,640,604,570,538,508,480,453
	dc.w	428,404,381,360,339,320,302,285,269,254,240,226
	dc.w	214,202,190,180,170,160,151,143,135,127,120,113
; Tuning 1
	dc.w	850,802,757,715,674,637,601,567,535,505,477,450
	dc.w	425,401,379,357,337,318,300,284,268,253,239,225
	dc.w	213,201,189,179,169,159,150,142,134,126,119,113
; Tuning 2
	dc.w	844,796,752,709,670,632,597,563,532,502,474,447
	dc.w	422,398,376,355,335,316,298,282,266,251,237,224
	dc.w	211,199,188,177,167,158,149,141,133,125,118,112
; Tuning 3
	dc.w	838,791,746,704,665,628,592,559,528,498,470,444
	dc.w	419,395,373,352,332,314,296,280,264,249,235,222
	dc.w	209,198,187,176,166,157,148,140,132,125,118,111
; Tuning 4
	dc.w	832,785,741,699,660,623,588,555,524,495,467,441
	dc.w	416,392,370,350,330,312,294,278,262,247,233,220
	dc.w	208,196,185,175,165,156,147,139,131,124,117,110
; Tuning 5
	dc.w	826,779,736,694,655,619,584,551,520,491,463,437
	dc.w	413,390,368,347,328,309,292,276,260,245,232,219
	dc.w	206,195,184,174,164,155,146,138,130,123,116,109
; Tuning 6
	dc.w	820,774,730,689,651,614,580,547,516,487,460,434
	dc.w	410,387,365,345,325,307,290,274,258,244,230,217
	dc.w	205,193,183,172,163,154,145,137,129,122,115,109
; Tuning 7
	dc.w	814,768,725,684,646,610,575,543,513,484,457,431
	dc.w	407,384,363,342,323,305,288,272,256,242,228,216
	dc.w	204,192,181,171,161,152,144,136,128,121,114,108
; Tuning -8
	dc.w	907,856,808,762,720,678,640,604,570,538,508,480
	dc.w	453,428,404,381,360,339,320,302,285,269,254,240
	dc.w	226,214,202,190,180,170,160,151,143,135,127,120
; Tuning -7
	dc.w	900,850,802,757,715,675,636,601,567,535,505,477
	dc.w	450,425,401,379,357,337,318,300,284,268,253,238
	dc.w	225,212,200,189,179,169,159,150,142,134,126,119
; Tuning -6
	dc.w	894,844,796,752,709,670,632,597,563,532,502,474
	dc.w	447,422,398,376,355,335,316,298,282,266,251,237
	dc.w	223,211,199,188,177,167,158,149,141,133,125,118
; Tuning -5
	dc.w	887,838,791,746,704,665,628,592,559,528,498,470
	dc.w	444,419,395,373,352,332,314,296,280,264,249,235
	dc.w	222,209,198,187,176,166,157,148,140,132,125,118
; Tuning -4
	dc.w	881,832,785,741,699,660,623,588,555,524,494,467
	dc.w	441,416,392,370,350,330,312,294,278,262,247,233
	dc.w	220,208,196,185,175,165,156,147,139,131,123,117
; Tuning -3
	dc.w	875,826,779,736,694,655,619,584,551,520,491,463
	dc.w	437,413,390,368,347,328,309,292,276,260,245,232
	dc.w	219,206,195,184,174,164,155,146,138,130,123,116
; Tuning -2
	dc.w	868,820,774,730,689,651,614,580,547,516,487,460
	dc.w	434,410,387,365,345,325,307,290,274,258,244,230
	dc.w	217,205,193,183,172,163,154,145,137,129,122,115
; Tuning -1
	dc.w	862,814,768,725,684,646,610,575,543,513,484,457
	dc.w	431,407,384,363,342,323,305,288,272,256,242,228
	dc.w	216,203,192,181,171,161,152,144,136,128,121,114

JnsChan1Temp:	dc.l	0,0,0,0,0,$00010000,0,  0,0,0,0
JnsChan2Temp:	dc.l	0,0,0,0,0,$00020000,0,  0,0,0,0
JnsChan3Temp:	dc.l	0,0,0,0,0,$00040000,0,  0,0,0,0
JnsChan4Temp:	dc.l	0,0,0,0,0,$00080000,0,  0,0,0,0


ModulPtr:	dc.l	0
JnsModulPtr:	dc.l	0
JnsSpeed:	dc.b	0
JnsCounter:	dc.b	0
JnsSongPos:	dc.b	0
JnsPBreakPos:	dc.b	0
JnsPosJumpFlag:	dc.b	0
JnsPBreakFlag:	dc.b	0
JnsPattDelTime:	dc.b	0
JnsPattDelTime2:dc.b	0
JnsLowMask:	dc.b	0
JnsModuleValid:	dc.b	0	0=No
JnsBFDD:	dc.b	0
JnsBFDE:	dc.b	0
	even
JnsDMACONtemp:	dc.w	0
JnsPatternPos:	dc.w	0
JnsActiveDma:	dc.w	0
JnsSysIrq:	dc.l	0

JnsFadeSkip:	dc.w	0	; How many frames before fader becomes
		; active!
JnsFaderActive:	dc.w	0
JnsFadeStep:	dc.w	0	; 64=vol0   0=vol64

AudChannel1:	dc.l	$dff0A0
AudChannel2:	dc.l	$dff0B0
AudChannel3:	dc.l	$dff0C0
AudChannel4:	dc.l	$dff0D0

JnsSampleStarts:blk.l	31,0

 Misc data 
Sys_IntEna:	dc.l	0
Sys_DmaCon:	dc.l	0
Sys_IntReq:	dc.l	0
Sys_Irq3:	dc.l	0
SpriteEmpty:	dc.l	0
 Include data and large data blocks 

SPRITEPOS:	MACRO	* x pos, ypos, x size
	dc.b	\2&$FF
	dc.b	\1>>1&$FF
	dc.b	(\2+\3)&$FF
	dc.b	((\2>>8)&1)<<2+(((\2+\3)>>8)&1)<<1+(\1&1)
	ENDM


FunkyLogoX	equ	$80+270
FunkyLogoY	equ	$5c+3

spr_FunkyLogo1:	SPRITEPOS	FunkyLogoX,FunkyLogoY,16
	dc.w	$000F,$0000
	dc.w	$000C,$0000
	dc.w	$000F,$0000
	dc.w	$000C,$0000
	dc.w	$000C,$0000
	dc.w	$0000,$0000
	dc.w	$F36F,$0000
	dc.w	$DB6D,$0000
	dc.w	$DB6D,$0000
	dc.w	$DB6D,$0000
	dc.w	$F36D,$0000
	dc.w	$DB6D,$0000
	dc.w	$DB6D,$0000
	dc.w	$DB6D,$0000
	dc.w	$DB6D,$0000
	dc.w	$F1CF,$0000
	dc.w	$0000,$0000


spr_FunkyLogo2:	SPRITEPOS	(FunkyLogoX+16),FunkyLogoY,16
	dc.w	$B6F3,$0000
	dc.w	$36DB,$0000
	dc.w	$36DB,$0000
	dc.w	$36DB,$0000
	dc.w	$1CDB,$0000
	dc.w	$0000,$0000
	dc.w	$3CD9,$0000
	dc.w	$B6DB,$0000
	dc.w	$B6DB,$0000
	dc.w	$B6DB,$0000
	dc.w	$B6FB,$0000
	dc.w	$B6DB,$0000
	dc.w	$B6DB,$0000
	dc.w	$B6DB,$0000
	dc.w	$B6DB,$0000
	dc.w	$3CDB,$0000
	dc.w	$0000,$0000

spr_FunkyLogo3:	SPRITEPOS	(FunkyLogoX+32),FunkyLogoY,16
	dc.w	$6D80,$0000
	dc.w	$6D80,$0000
	dc.w	$CF00,$0000
	dc.w	$6600,$0000
	dc.w	$6600,$0000
	dc.w	$0000,$0000
	dc.w	$C780,$0000
	dc.w	$6C00,$0000
	dc.w	$6C00,$0000
	dc.w	$6C00,$0000
	dc.w	$E700,$0000
	dc.w	$6180,$0000
	dc.w	$6180,$0000
	dc.w	$6180,$0000
	dc.w	$6180,$0000
	dc.w	$6F00,$0000
	dc.w	$0000,$0000


	incdir	ass:abdication/bit/
SelectorGfx:	incbin	selector.gfx
ScrollFont:	incbin	SCROLLFONT	; 54*8

	blk.b	2*46,0
ScrollerGfx:	blk.b	9*46,0
	blk.b	2*46,0

TheEnd:	end
-
-End of source-
-

>0-1-2-3-4-5-6-7-8-9-A-B-C-D-E-F-G-H-I-J-I-H-G-F-E-D-C-B-A-9-8-7-6-5-4-3-2-1-0<
 






















dd
