; Fast Vector Runner, Uses the Fast Vector Code Segment, rotates and
; Zooms an LSD Logo.  

	Opt	c-
	Section	"Fast Vec Runner",Code_c

Start	Movem.l	d0-d7/a0-a6,-(sp) 
	Bsr	KillSys	  
	
	Lea	CopperList(pc),a0 
	Lea	HardWare,a6	  
	Move.l	a0,Cop1Lc(a6)	  
	Move.w	#$83c0,DMACon(a6)

Loop	Bsr	VBL
	Move.w	#$1200,$Dff100	
	Move.w	#$0000,$Dff180	
	Move.w	#$0fff,$Dff182
	Lea	VectorData(pc),a0
	Move.l	PicBase1(pc),a1
	Move.l	PicBase2(pc),a2
	Move.w	ZRot(pc),d0
	Move.w	XPos(pc),d1
	Move.w	YPos(pc),d2
	Move.w	DistX(pc),d3
	Move.w	DistY(pc),d4
	Bsr	FastVecSeg+$20
	Lea	ZRot(pc),a5
	Move.w	d0,(a5)
	
	Add.w	#8,(a5)
	Bsr	DoXYSine
	
	Btst	#6,$Bfe001	  
	Bne	Loop	  
		
	Bsr	ReturnSys	  
	Movem.l	(sp)+,d0-d7/a0-a6 
	Moveq	#0,d0	  
	Rts

DoXYSine	Lea	DistX(pc),a4
	Lea	SineXPt(pc),a5
	Bsr	DoSine
	Asr.w	#1,d3
	Move.w	d3,(a4)
	Lea	DistY(pc),a4
	Lea	SineYPt(pc),a5
	Bsr	DoSine
	Asr.w	#1,d3
	Move.w	d3,(a4)
	Lea	DistX(pc),a4
	And.w	#4095,0(a4)
	And.w	#4095,2(a4)
	Move.w	0(a4),2(a4)
	Rts

DoSine	Lea	SineData(pc),a6
	Moveq	#0,d2
	Moveq	#0,d3
	Move.l	08(a5),d0
	Move.l	12(a5),d1
	Add.l	d0,00(a5)
	Add.l	d1,04(a5)
	And.l	#$ffe,00(a5)	
	And.l	#$ffe,04(a5)	
	Move.l	00(a5),d0
	Move.l	04(a5),d1	
	Move.w	(a6,d0.l),d2
	Move.w	(a6,d1.l),d3	
	Add.l	d2,d3	
	Asl.w	#3,d3
	Add.w	#4096,d3
	Rts		

KillSys	Bsr.s	SysWait	

	Move.l	$4,a6	
	Lea	GFXName(pc),a1	
	Moveq	#0,d0	
	Jsr	-552(a6)	
		
	Lea	OldCop1(pc),a5
	Move.l	$26(a0),$0(a5)	
	Move.l	$32(a0),$4(a5)	
	
	Lea	HardWare,a6
	Move.w	IntEnaR(a6),d0	
	Move.w	DMAConR(a6),d1  
	Or.w	#$8000,d0	
	And.w	#$03ff,d1	
	Or.w	#$8000,d1	
	Move.w	d0,$8(a5)	
	Move.w	d1,$a(a5)	
	
	Move.w	#$7fff,IntEna(a6) 
	Move.w	#$7fff,DMACon(a6) 
	Rts

SysWait	Move.w	#15,d7	
SysWaitLoop	Move.l	#$05000,d1	
	Bsr.s	WaitVBL	
	Bsr.s	VBL	
	Dbf	d7,SysWaitLoop	
	Rts

VBL	Move.l	#$13000,d1	
WaitVBL	Movem.l	d0-d1/a6,-(sp)	
	Lea	HardWare,a6	
WaitVBLLoop	Move.l	VPosR(a6),d0	
	And.l	#$1ff00,d0	
	Cmp.l	d1,d0	
	Bne.s	WaitVBLLoop	
	Movem.l	(sp)+,d0-d1/a6	
	Rts		

ReturnSys	Lea	HardWare,a6	
	Move.w	OldIntEna(pc),IntEna(a6)
	Move.w	OldDMACon(pc),DMACon(a6)
	Move.l	OldCop1(pc),Cop1lc(a6)
	Move.l	OldCop2(pc),Cop2lc(a6)
	Rts	

GFXName	Dc.b	"graphics.library",0
	Even
OldCop1	Dc.l	0	
OldCop2	Dc.l	0	
OldIntEna	Dc.w	0	
OldDmaCon	Dc.w	0

PicBase1	Dc.l	$e0000
PicBase2	Dc.l	$e4000
	
ZRot	Dc.w	10
XPos	Dc.w	176
YPos	Dc.w	148
DistX	Dc.w	500
DistY	Dc.w	500

SineXPt	Dc.l	0
SineXPt1	Dc.l	0
SineXAdd	Dc.l	70
SineXAdd1	Dc.l	54

SineYPt	Dc.l	0
SineYPt1	Dc.l	0
SineYAdd	Dc.l	66
SineYAdd1	Dc.l	44

Cmv	Macro
	Dc.w	\2,\1
	EndM
	
Cwt	Macro
	Dc.w	(\1*$100)+$01,$fffe
	EndM	
	
CwtBlit	Macro
	Dc.w	$1,0
	EndM	

Pal	Macro
	Dc.w	$ffe1,$fffe
	EndM	

EndCop	Macro
	Dc.w	$ffff,$fffe
	EndM	

CopperList	Cwt	$15	
	Cmv	$0200,BplCon0	
	Cmv	$00bb,BplCon1	
	Cmv	$000a,BplCon2	
	Cmv	$1681,DiwStrt	
	Cmv	$36c1,DiwStop
	Cmv	$0034,DdfStrt	
	Cmv	$00c8,DdfStop	
	Cmv	$0,BplMod1
	Cmv	$0,BplMod2
	
	Cwt	$25		
	Cmv	$0000,Color01
	Cmv	$0fff,Color01
	
CopperBPLS	Cmv	$c,BplPt0h	
	Cmv	$0,BplPt0l	
	Cmv	$0,BplPt1h	
	Cmv	$0,BplPt1l	
	Cmv	$0,BplPt2h	
	Cmv	$0,BplPt2l	
	Cmv	$0,BplPt3h	
	Cmv	$0,BplPt3l	
	Cmv	$0,BplPt4h
	Cmv	$0,BplPt4l 
	
	Cwt	$28	
	Cmv	$1200,BplCon0	

	EndCop

VectorData	
*****************************************************************************
* LSD Vector Logo Data - L / S (top, dot, bottom) / D   *   Phagex 27-8-93  *
*****************************************************************************

L_Points	Dc.w	42
	Dc.w	$FF79,$FFEB,$FF6E,$0000,$FF79,$0017,$FFCC,$0017
	Dc.w	$FFD4,$0008,$FF95,$0008,$FF92,$0001,$FF9D,$FFEB

STop_Points	Dc.w	$FFCB,$FFEB,$0026,$FFEB,$001F,$FFFA,$FFE7,$FFFA
	Dc.w	$FFE3,$0001,$FFE5,$0005,$FFC2,$0005,$FFC0,$0001

SDot_Points	Dc.w	$FFF4,$FFFF,$FFF9,$FFFD,$FFFE,$FFFD,$0003,$FFFF
	Dc.w	$0003,$0003,$FFFE,$0005,$FFF9,$0005,$FFF4,$0003

SBot_Points	Dc.w	$0012,$FFFD,$0035,$FFFD,$0037,$0001,$002C,$0017
	Dc.w	$FFD1,$0017,$FFD8,$0008,$0010,$0008,$0014,$0001

D_Points	Dc.w	$002B,$FFEB,$0088,$FFEB,$0093,$0001,$0088,$0017
	Dc.w	$0031,$0017,$0038,$0008,$006B,$0008,$006F,$0000
	Dc.w	$006C,$FFFA,$0024,$FFFA

LSDConnects	Dc.w	42
	Dc.w	00,01,01,02,02,03,03,04,04,05,05,06,06,07,07,00
	Dc.w	08,09,09,10,10,11,11,12,12,13,13,14,14,15,15,08
	Dc.w	16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,16
	Dc.w	24,25,25,26,26,27,27,28,28,29,29,30,30,31,31,24
	Dc.w	32,33,33,34,34,35,35,36,36,37,37,38,38,39,39,40,40,41,41,32

SineData	Incbin	Df1:SysData/Sine1024Bs.Dat
	Incbin	Df1:SysData/Sine1024Bs.Dat
FastVecSeg	Incbin	Df1:CodeSegments/FastVec-Seg

****Custom Chip Registers****

Hardware	= $Dff000

;Control Registers

Dmaconr	= $002
Vposr	= $004
Vhposr	= $006
Joy0dat	= $00A
Joy1dat	= $00C
Clxdat	= $00E
Intenar	= $01C
Intereqr	= $01E
Copcon	= $02E

;Blitter Registers

Bltcon0	= $040
Bltcon1	= $042
Bltafwm	= $044
Bltalwm	= $046
Bltcpth	= $048
Bltcptl	= $04A
Bltbpth	= $04C
Bltbptl	= $04E
Bltapth	= $050
Bltaptl	= $052
Bltdpth	= $054
Bltdptl	= $056
Bltsize	= $058
Bltcmod	= $060
Bltbmod	= $062
Bltamod	= $064
Bltdmod	= $066
Bltcdat	= $070
Bltbdat	= $072
Bltadat	= $074

;Copper Registers

Cop1lc	= $080
Cop1lch	= $080
Cop1lcl	= $082
Cop2lc	= $084
Cop2lch	= $084
Cop2lcl	= $086
Copjmp1	= $088
Copjmp2	= $08A
Diwstrt	= $08E
Diwstop	= $090
Ddfstrt	= $092
Ddfstop	= $094
Dmacon	= $096
Clxcon	= $098
Intena	= $09A
Intreq	= $09C

;BitPlane Registers 

BplCon0	= $100
BplCon1	= $102
BplCon2	= $104
BplMod1	= $108
BplMod2	= $10a

BplPt0h	= $0e0
BplPt0l	= $0e2
BplPt1h	= $0e4
BplPt1l	= $0e6
BplPt2h	= $0e8
BplPt2l	= $0ea
BplPt3h	= $0ec
BplPt3l	= $0ee
BplPt4h	= $0f0
BplPt4l	= $0f2
BplPt5h	= $0f4
BplPt5l	= $0f6

;Colour Registers

Color00	= $180
Color01	= $182
Color02	= $184
Color03	= $186
Color04	= $188
Color05	= $18a
Color06	= $18c
Color07	= $18e
Color08	= $190
Color09	= $192
Color10	= $194
Color11	= $196
Color12	= $198
Color13 	= $19a
Color14 	= $19c
Color15 	= $19e
Color16 	= $1a0
Color17 	= $1a2
Color18 	= $1a4
Color19 	= $1a6
Color20 	= $1a8
Color21 	= $1aa
Color22 	= $1ac
Color23 	= $1ae
Color24 	= $1b0
Color25 	= $1b2
Color26 	= $1b4
Color27 	= $1b6
Color28 	= $1b8
Color29 	= $1ba
Color30 	= $1bc
Color31 	= $1be

EcsNop	= $1fe

































