	Opt	c-
*****************************************************************************
*  Psykos Exteme Hardware Only Disk Routines, Read And Write, Version 8.0   *
*    For in-group use only.    Illeagle wait states at the mo, soon be CIA  *
*  Copyright 1992 The Retro Corporation.                     Psyko 6/11/92  *
*****************************************************************************
; revitalised 21-5-93 especially 4 nzoid.
;
; no hanging up or crashing out, i think.
;
; Reg. D0		Reg. D1
; 0 = SetTrack 0	Drive No.
;
; 1 = Start Drive	Drive No.
;
; 2 = Read Sector	Sector No.
; a0 = Data Address	a1 = MFM Buffer
;
; 3 = Stop Drive	Drive No.



	Section	"Disk Trakker",Code_C

Start      	Movem.l	d0-d7/a0-a6,-(sp)
	
	Cmpi.b	#0,d0
	Beq	Set0Ex
	Cmpi.b	#1,d0
	Beq	StartEx
	Cmpi.b	#2,d0
	Beq	ReadEx
	Cmpi.b	#3,d0
	Beq	StopEx
	
ReadEx	Lea	StartSector(pc),a6
	Move.w	d1,(a6)
	Lea	MFMBufferPt(pc),a6
	Move.l	a1,0(a6)
	Move.l	a0,4(a6)
	Bsr	Initialize
	Lea	Drive(pc),a0
	Moveq	#0,d1
	Move.w	(a0),d1
	Add.w	d1,d1
	Lea	DTrack0(pc),a0
	Move.w	(a0,d1),8(a0)
	Bsr	LoadSector
	Lea	Drive(pc),a0
	Moveq	#0,d1
	Move.w	(a0),d1
	Add.w	d1,d1
	Lea	DTrack0(pc),a0
	Move.w	8(a0),(a0,d1)	
Quit	Bsr	RestoreSystem
QuitEx	Movem.l	(sp)+,d0-d7/a0-a6
	Moveq	#0,d0
	Rts
	
Set0Ex	Lea	Drive(pc),a0
	Move.w	d1,(a0)
	Add.w	d1,d1
	Lea	DTrack0(pc),a0
	Move.w	#0,(a0,d1)
	Bsr	StartDrive
	Bsr	GotoTrack0
	Bra	QuitEx
	
StartEx	Lea	Drive(pc),a0
	Move.w	d1,(a0)
	Bsr	StartDrive
	Bra	QuitEx

StopEx	Lea	Drive(pc),a0
	Move.w	d1,(a0)
	Bsr	StopDrive
	Bra	QuitEx

Initialize	Lea	$Dff000,a6
	Lea	AdkSav(pc),a0
	Move.w	$10(a6),d0
	Move.w	d0,(a0)
	Move.w	#$7fff,$9e(a6)
	Move.w	#$8100,$9e(a6)
	Rts


StartDrive	Move.w	Drive(pc),d1
	And.w	#3,d1
	Add.b	#3,d1
	Bclr	#7,$Bfd100
	Nop
	Nop
	Nop
	Bclr	d1,$Bfd100
	Bsr	WaitDrive
    	Rts

StopDrive	Move.w	Drive(pc),d1
	And.w	#3,d1
	Add.b	#3,d1
	Bset	#7,$Bfd100
	Nop
	Nop
	Nop
	Bclr	d1,$Bfd100
	Nop
	Nop
	Nop
	Bset	d1,$Bfd100
	Bsr	WaitDrive
    	Rts

MFMAmount	= $3400

ReadMFM	Move.l	MFMBufferPt(pc),a0
	Move.w	#MFMAmount,d7
ClearMFMBuffer	Move.b	#$0,(a0)+
	Dbf	d7,ClearMFMBuffer
	
	Bsr	SetDiskSide
	Lea	$Dff000,a6
	Move.w	#$8210,$96(a6)
	Move.w	#2,$9c(a6)
	Move.w	ReadSync(pc),$7e(a6)
	Move.l	MFMBufferPt(pc),$20(a6)
	Move.w	#$7f00,$9e(a6)
	Move.w	#$4000,$24(a6)
	Move.w	#$9500,$9e(a6)
	Bsr	WaitDrive
	Move.w	#(MFMAmount/2)!$8000,d1
	Move.w	d1,$24(a6)
	Move.w	d1,$24(a6)
	Bsr	WaitDiskDMA
	Move.w	#$0010,$96(a6)
	Rts	

WaitDrive	Move.l	d6,-(sp)
	Move.w	#20,d6
WaitX	Move.w	#20,d0
	Bsr	WaitRaster
	Btst	#5,$Bfe001
	Beq	NoWaitX
	Dbf	d6,WaitX
NoWaitX	Move.l	(sp)+,d6
	Rts

WaitDiskDMA	Move.w	$1e(a6),d0
	Btst	#1,d0
	Beq	WaitDiskDMA
	Move.w	#2,$9c(a6)
	Rts

WaitRaster	Move.b	$Dff006,d7
WaitNextLine	Cmp.b	$Dff006,d7
	Beq	WaitNextLine
	Dbf	d0,WaitRaster
	Rts

DecodeMFM	Move.l	MFMBufferPt(pc),a2
	Lea	MFMSectorList(pc),a5
	Moveq.l	#10,d5
DecodeLoop	Move.l	#$55555555,d7
FindSync1	Move.w	ReadSync(pc),d3
	Move.w	(a2)+,d4
	Cmp.w	d3,d4
	Bne	FindSync1
	Move.w	(a2),d4
	Cmp.w	d3,d4
	Bne	NoSync
	Addq.l	#2,a2
NoSync	Move.l	(a2),d3
	Move.w	6(a2),d4
	And.w	d7,d3
	And.w	d7,d4
	Add.w	d3,d3
	Or.w	d4,d3
	Add.w	d3,d3
	Moveq	#0,d6
	And.w	#$ff00,d3
	Asr.w	#7,d3
	Move.w	d3,d6
	Lea	$38(a2),a2
	Move.l	a2,(a5,d6)
	Lea	$200(a2),a2
	Dbf	d5,DecodeLoop
	Rts

DecodeSectors	Lea	DataBufferPt(pc),a4
	Move.l	(a4),a3
	Lea	MFMSectorList(pc),a0
	Moveq	#10,d5	
	Move.w	SectorLoad(pc),d0
GetSector	Move.l	(a0)+,a2
	Btst	#0,d0
	Bne	DecSector
	Asr.w	#1,d0
	Dbf	d5,GetSector
	Rts
	
DecSector	Moveq.l	#$7f,d6
	Move.l	#$55555555,d7
DecodeSector	Move.l	$200(a2),d3
	Move.l	(a2)+,d4
	And.l	d7,d4
	And.l	d7,d3
	Add.l	d4,d4
	Or.l	d3,d4
	Move.l	d4,(a3)+
	Dbf	d6,DecodeSector
	Asr.w	#1,d0
	Dbf	d5,GetSector
	Move.l	a3,(a4)
	Rts

GotoTrack0  	Btst	#4,$Bfe001
        	Beq	FoundTrack0
        	Bset	#1,$Bfd100
        	Bclr	#0,$Bfd100
        	Bset	#0,$Bfd100
        	Bsr	WaitDrive
        	Bra	GotoTrack0
FoundTrack0    	Bsr	WaitDrive
        	Rts

IncTrack	Bclr	#1,$Bfd100
	Move.w	#1,d0
	Bsr	WaitRaster
        	Bclr	#0,$Bfd100
	Move.w	#1,d0
	Bsr	WaitRaster
        	Bset	#0,$Bfd100
        	Bsr	WaitDrive
	Rts

DecTrack	Bset	#1,$Bfd100
	Move.w	#1,d0
	Bsr	WaitRaster
        	Bclr	#0,$Bfd100
	Move.w	#1,d0
	Bsr	WaitRaster
        	Bset	#0,$Bfd100
        	Bsr	WaitDrive
	Rts

SetDiskSide	Move.w	DiskSide(pc),d4
	Btst	#0,d4
	Bne	SetSide1
	Bset	#2,$Bfd100
	Bra	SideSet
SetSide1	Bclr	#2,$Bfd100
SideSet	Rts

RestoreSystem	Lea	$Dff000,a6
	Move.w	ADKsav(pc),d0
        	Bset	#15,d0
        	Move.w	d0,$9e(a6)
        	Rts

FindTrack	Bsr	WaitDrive
	Move.w	Track(pc),d0
	Move.w	LTrack(pc),d1
	Cmp.b	d1,d0
	Beq	GotTrack
	Cmp.b	d1,d0
	Bls	AddTrack
	Cmp.b	d1,d0
	Bgt	SubTrack
	Bra	FindTrack
AddTrack	Movem.l	d0-d7/a0-a6,-(sp)
	Lea	Track(pc),a0
	Add.w	#1,(a0)
	Bsr	IncTrack
	Movem.l	(sp)+,d0-d7/a0-a6
	Bra	FindTrack
SubTrack	Movem.l	d0-d7/a0-a6,-(sp)
	Lea	Track(pc),a0
	Sub.w	#1,(a0)
	Bsr	DecTrack
	Movem.l	(sp)+,d0-d7/a0-a6
	Bra	FindTrack
GotTrack	Rts	

LoadSector	Lea	SectorsLoaded(pc),a0
	Move.w	StartSector(pc),d0
	Moveq	#0,d7
CheckLoop	Move.w	(a0)+,d1
	Cmp.w	d0,d1
	Beq	FoundSecLoad
	Addq	#1,d7
	Cmpi.b	#11,d7
	Bne	CheckLoop
	Bra	LoadNewMFM
	
FoundSecLoad	Moveq	#0,d6
	Bset	d7,d6
	Lea	SectorLoad(pc),a5
	Move.w	d6,(a5)
	Bsr	DecodeSectors
	Rts
	
LoadNewMFM	Move.w	StartSector(pc),d0
	Lea	DiskSide(pc),a5
	Divs	#11,d0
	Move.l	d0,d1
	Move.w	d0,0(a5)
	Asr.w	#1,d0
	Move.w	d0,4(a5)
	Swap	d1
	Moveq	#0,d6
	And.w	#$f,d1
	Bset	d1,d6
	Move.w	d6,6(a5)
	Bsr	FindTrack
	Bsr	ReadMFM
	Bsr	DecodeMFM
	Bsr	DecodeSectors
	Move.w	DiskSide(pc),d0
	Muls	#11,d0
	Lea	SectorsLoaded(pc),a0
	Moveq	#10,d7
SaveSecLoad	Move.w	d0,(a0)+
	Addq	#1,d0
	Dbf	d7,SaveSecLoad
	Rts

StartSector	Dc.w	880

MFMBufferPt 	Dc.l	$b0000
DataBufferPt	Dc.l	$c0000
ADKsav  	Dc.w	0

ReadSync	Dc.w	$4489

DTrack0	Dc.w	0
DTrack1	Dc.w	0
DTrack2	Dc.w	0
DTrack3	Dc.w	0
Track	Dc.w	0
DiskSide	Dc.w	0
Drive	Dc.w	0
LTrack	Dc.w	40
SectorLoad	Dc.w	0

MFMSectorList	Ds.l	11

SectorsLoaded	Dcb.w	11,$ffff




