(* code compiled by brian zhou (zoob) of think productions *)
(* these are useful routines i've found or written *)
(* remove these comments and you shall meet your death *)
(* things marked with x's are called automatically when using another proc *)
{$G+}
unit stuff;
Interface
uses crt,dos;

Function LoStr(S : String) : String;          { convert string to lower case }
Function UpStr(S : String) : String;          { convert string to upper case }
Function detShare : Boolean;                  { detect share                 }
Procedure VGA_SetBlink(BlinkMode : Boolean);  {xinitialize adf               }
Procedure Set8x16Font;                        {xset to adf font              }
Procedure DisplayADF(Filename : String);      { display *.adf files          }
Function ShiftState : Byte;                   {xchecks the shiftstate of keys}
Function AltKey : Boolean;                    { checks if alt is pressed     }
Function Hex2Byte (HexByte : String) : Byte;  { convert hex to byte          }
Function StrComp(Str1, Str2 : String) : Boolean;{compare strings             }
Function fExists(FN : String) : Boolean;      { check if file exists         }
Procedure ShowCursor;                         { show cursor                  }
Procedure HideCursor;                         { hide cursor                  }
Procedure enable_interrupts;                  { enable interrupts            }
Procedure disable_interrupts;                 { disable interrupts           }

Const
{ Keyboard Extended Keys .... }

  F1  = #59;   CtrlF1  =  #94;   AltF1  = #104;   Homekey   = #71;
  F2  = #60;   CtrlF2  =  #95;   AltF2  = #105;   Endkey    = #79;
  F3  = #61;   CtrlF3  =  #96;   AltF3  = #106;   PgUp      = #73;
  F4  = #62;   CtrlF4  =  #97;   AltF4  = #107;   PgDn      = #81;
  F5  = #63;   CtrlF5  =  #98;   AltF5  = #108;   UpArrow   = #72;
  F6  = #64;   CtrlF6  =  #99;   AltF6  = #109;   RtArrow   = #77;
  F7  = #65;   CtrlF7  = #100;   AltF7  = #110;   DnArrow   = #80;
  F8  = #66;   CtrlF8  = #101;   AltF8  = #111;   LfArrow   = #75;
  F9  = #67;   CtrlF9  = #102;   AltF9  = #112;   InsertKey = #82;
  F10 = #68;   CtrlF10 = #103;   AltF10 = #113;   DeleteKey = #83;

  AltQ = #16;   AltA = #30;   AltZ = #44;     Alt1 = #120;  ShftF1 = #84;
  AltW = #17;   AltS = #31;   AltX = #45;     Alt2 = #121;  ShftF2 = #85;
  AltE = #18;   AltD = #32;   AltC = #46;     Alt3 = #122;  ShftF3 = #86;
  AltR = #19;   AltF = #33;   AltV = #47;     Alt4 = #123;  ShftF4 = #87;
  AltT = #20;   AltG = #34;   AltB = #48;     Alt5 = #124;  ShftF5 = #88;
  AltY = #21;   AltH = #35;   AltN = #49;     Alt6 = #125;  ShftF6 = #89;
  AltU = #22;   AltJ = #36;   AltM = #50;     Alt7 = #126;  ShftF7 = #90;
  AltI = #23;   AltK = #37;   AltPlus  = #78; Alt8 = #127;  ShftF8 = #91;
  AltO = #24;   AltL = #38;   AltMinus = #74; Alt9 = #128;  ShftF9 = #92;
  AltP = #25;   CtrlLf = #115;                Alt0 = #129;  ShftF10= #93;
                CtrlRt = #116;

  CtrlA  = #1;  CtrlK = #11; CtrlU = #21; CtrlB = #2;  CtrlL = #12;
  CtrlV  = #22; CtrlC = #3;  CtrlM = #13; CtrlW = #23; CtrlD = #4;
  CtrlN  = #14; CtrlX = #24; CtrlE = #5;  CtrlO = #15; CtrlY = #25;
  CtrlF  = #6;  CtrlP = #16; CtrlZ = #26; CtrlG = #7;  CtrlQ = #17;
  CtrlS  = #19; CtrlH = #8;  CtrlR = #18; CtrlI = #9;  CtrlJ = #10;
  CtrlT = #20;  BkSpace = #8; Escape = #27; Enter = #13; Null = #0;
  Space = #32;

Implementation

Function LoStr(S : String) : String;
Var I : Byte;
Begin
  For I := 1 To Length(S) Do
    If (S[I] In ['A'..'Z']) Then S[I]:=Chr(Ord(S[I])+32);
  LoStr := S;
End;

Function UpStr(S : String) : String;
Var I : Byte;
Begin
   For I := 1 To Length(S) Do S[I] := UpCase(S[I]);

   UpStr := S;
End;

Function detShare : Boolean; Assembler;
ASM
  MOV AX,$1000
  INT $2f
End;

Procedure VGA_SetBlink(BlinkMode : Boolean); Assembler;
ASM
 MOV    DX,$03DA
 IN     AL,DX
 MOV    DX,$03C0
 MOV    AL,10h+20h
 OUT    DX,AL
 MOV    DX,$03C1
 IN     AL,DX
 MOV    DX,$03C0
 CMP    [BlinkMode],TRUE
 JE     @SetBlinkBit
@BlinkOff:
 AND    AL,NOT 008h
 JMP    @SetBlinkBit
@BlinkOn:
 OR     AL,008h
@SetBlinkBit:
 OUT    DX,AL
END;

Procedure Set8x16Font;Assembler;
Asm
 mov dx,03c4h
 mov ax,0100h
 out dx,ax
 mov dx,03c4h
 mov ax,0301h
 out dx,ax
 mov dx,03c2h
 mov al,063h
 out dx,al
 mov dx,03c4h
 mov ax,0300h
 out dx,ax
 mov dx,03d4h
 mov ax,4f09h
 out dx,ax
end;

Procedure DisplayADF(Filename : String);
Var    X : word;
 NumRead : Integer;
       F : File;
 ADF_Version  : Char;
 ADF_Pallette : Array[0..63,1..3] of Byte;
 ADF_Font     : Array[1..4096] of Char;
 ADF_Handle   : File;
 Regs : Registers;
Begin
 VGA_Setblink(False);
 Set8x16Font;
 hidecursor;
 Assign(F,Filename);
 Reset(F,1);
 Seek(F,0);
 BlockRead(F,ADF_Version,1);
 BlockRead(F,ADF_Pallette,Sizeof(ADF_Pallette));
 BlockRead(F,ADF_Font[1],4096);
 For X := 0 to 63 do
  Begin
   Port[$3c8] := X;
   Port[$3c9] := ADF_Pallette[X,1];
   Port[$3c9] := ADF_Pallette[X,2];
   Port[$3c9] := ADF_Pallette[X,3];
  End;
 Seek(F,4289);
 regs.bx:= 4096;
 regs.es:= seg(ADF_Font);
 regs.bp:= ofs(ADF_Font);
 regs.ax:= 4368;
 regs.cx:= 256;
 regs.dx:= 0;
 Intr(16, Regs);
 hidecursor;
 BlockRead(F,Mem[$b800:0000],Filesize(F)-4289);
 Close(F);
End;

Function ShiftState : Byte;
Var Regs: Registers;
Begin
  Regs.Ah:=2;
  Intr($16, Regs);
  ShiftState:=Regs.Al;
End;

Function AltKey : Boolean;
Begin
 AltKey := (ShiftState and 8)<>0;
End;

Function Hex2Byte (HexByte : String) : Byte;
ASSEMBLER;
ASM
  LES     DI, [HexByte]
  MOV     AX, ES:[DI+1]
  SUB     AX, 3030h
  CMP     AL, 9
  JLE     @Done1
  SUB     AL, 7

@DONE1:
  SHL     AL, 4
  CMP     AH, 9
  JLE     @Done2
  SUB     AH, 7

@DONE2:
  OR      AL, AH
END;

Function StrComp(Str1, Str2 : String) : Boolean;
Begin
   StrComp:=False;
   If Length(Str1)<>Length(Str2) Then Exit
   Else If UpStr(Str1)=UpStr(Str2) Then StrComp:=True;
End;

Function fExists(FN : String) : Boolean;
var F : File;
begin
   {$I-}
   Assign(F, FN);
   Reset(F);
   Close(F);
   {$I+}
   fExists := (IOResult = 0) and (FN <> '');
end;

procedure showcursor;assembler;
asm
  mov ax,0100h
  mov cx,0100h
  mov cx,0506h
  int 10h
end;

procedure hidecursor;assembler;
asm
  mov ax,100h
  mov cx,02607h
  int 10h
end;

Procedure disable_interrupts;
begin
INLINE
  (
  $FA    {CLI}
  );
end;

Procedure enable_interrupts;
begin
INLINE
  (
  $FB    {STI}
  );
end;

end.
