(*  Local thinkANSI graphics parser v0.1.2 by Brian Zhou(Think)
    Copyright (C) 1998 by Brian Zhou.  All Rights Reserved.
    --------------------------------------------------------------------------
    Most things are commented, but if not, they may be in later versions.
    Forgive me if the code is sloppy, I'm trying my best to optimize it.

    Here is a short documentation of the ANSI escape sequences, ones with
    stars are not supported:
  
     Esc[2J       - This code is used to clear the screen, and place the cursor 
                    at the home position (1,1).
  
     Esc[K        - This code is used to clear the line from the current cursor 
                    position to the end of the line, placing the cursor back to 
                    the original position.
  
     Esc[row;colH - This code is used to position the cursor on the screen.     
                    'row' represents the 'y' coordinate, and 'col' represents the 
                    'x' coordinate.
  
     Esc[Na       - This code is used to move the cursor up 'n' rows.
  
     Esc[Nb       - This code is used to move the cursor down 'n' rows.

     Esc[Nc       - This code is used to move the cursor right 'n' columns.

     Esc[Nd       - This code is used to move the cursor left 'n' columns.

     Esc[6n       - This code is sent by standard ansi detectors.  If you are
                     implementing this code into a Terminal, please modify
                     this procedure to send the coordinates through the modem.

     Esc[s        - This code is used to save the current cursor position.

     Esc[u        - This code is used to return the cursor to the saved         
                    position.

     Esc[nm       - This code allows you to select a character attribute using  
                    'n' as the attribute, which can be one set of the following.

                    0  - No Special Attributes.
                    1  - High Intensity.
                    2  - Low Intensity.
                  * 3  - Italic.
                  * 4  - Underline.
                    5  - Blink.
                  * 6  - Rapid Blink.
                    7  - Reverse Video.
                    8  - Concealed Text (No Display).

                    30 - Foreground Black.
                    31 - Foreground Red.
                    32 - Foreground Green.
                    33 - Foreground Yellow.
                    34 - Foreground Blue.
                    35 - Foreground Magenta.
                    36 - Foreground Cyan.
                    37 - Foreground White.

                    40 - Background Black.
                    41 - Background Red.
                    42 - Background Green.
                    43 - Background Yellow.
                    44 - Background Blue.
                    45 - Background Magenta.
                    46 - Background Cyan.
                    47 - Background White.

    --------------------------------------------------------------------------

    Files included in archive ZO-ANSIS.ZIP

    ANSIDRV .PAS  <-- The actual ANSI emulator unit
    FILE_ID .DIZ  <-- BBS description file
    IR-THNK8.ANS  <-- Test ANSI drawn by me
    TESTANS .PAS  <-- Program to test the ANSI emulator

    --------------------------------------------------------------------------

    History:

    v0.1.2 : First public release.

    --------------------------------------------------------------------------
*)

Unit AnsiDrv;
Interface
Uses Crt;

Const
     MaxCh = 20;
Var
    Buff        : String[MaxCh+1];       (* Buffer                          *)
    Escape,                              (* True if first character is Esc  *)
    Escape2,                             (* True if second char is [        *)
    Hi,                                  (* High intensity                  *)
    Blink       : Boolean;               (* Blink                           *)
    PosBuff,                             (* Postion in buffer               *)
    SaveX,                               (* Saved X position                *)
    SaveY       : Byte;                  (* Saved Y position                *)

Procedure cAnsi (C : Char);

IMPLEMENTATION

Procedure cAnsi;
Const
  C_Ansi  : Set of Char = ['A','B','C','D','F','H','J','K','M','N','S','U'];
  Colours : Array[0..7] Of Byte = (0,4,2,6,1,5,3,7);

Procedure Ansi;
Var Tab              : Array [1..20] of Byte;
    Colour, Colour2,
    Nbr_Num,
    Nbr_Chifr,
    i, x             : Byte;
    XStr, YStr       : String[2];

Begin
     Nbr_Num := 0;
     Nbr_Chifr := 1;
     x := 1;
     Tab[1] := 1;
     Tab[2] := 1;

While (x <> PosBuff) do
   Begin
   If Nbr_Num = 0 Then Inc (Nbr_Num);
   If (Buff[x] in ['0'..'9']) And (Nbr_Chifr < 3) Then
      Begin
      If Nbr_Chifr = 1 Then Tab [Nbr_Num] := (Ord (Buff[x]) - 48)
      Else Tab [Nbr_Num] := (Tab [Nbr_Num] * 10) + (Ord (Buff[x]) - 48);
      Inc (Nbr_Chifr);
      End
   Else If Buff[x] = ';' Then
            Begin
            If (Nbr_Chifr = 1) Then Tab [Nbr_Num] := 1;
            Inc (Nbr_Num);
            Nbr_Chifr := 1;
            End;
   Inc (x);
   End;  (* While *)

Case Buff [PosBuff] of     (* Parse the commands *)
      'M' : For i := 1 to Nbr_Num do
               Case Tab [i] of
               (* All Attributes off *)
               0  : Begin
                         TextColor (7);
                         TextBackGround (0);
                         Hi := False;
                         Blink := False;
                    End;

               (* High intensity on *)
               1  : Begin
                        Hi := True;
                        Colour := (TextAttr and 15);
                        If Colour < 8 Then Colour := Colour + 8;
                        TextColor (Colour);
                    End;

               (* Blinking on *)
               5,
               6  : Blink := True;

               (* Inverse video on *)
               7  : Begin
                         Colour := (TextAttr and 15);
                         If Colour > 8 Then Dec (Colour, 8);
                         Colour2 := ((TextAttr Shr 4) and 7);
                         TextColor (Colour2);
                         TextBackGround (Colour);
                    End;

               (* Concealed on *)
               8  : Begin
                         Colour := ((TextAttr Shr 3) and 7);
                         TextColor (Colour);
                    End;

               (* Change foreground colour *)
               30..37 : Begin
                             Colour := Colours[Tab[I]-30];
                             If Hi Then Inc (Colour, 8);
                             If Blink Then Inc (Colour, 128);
                             TextColor (Colour);
                        End;

               (* Change background colour *)
               40..47: TextBackGround(Colours[Tab[I]-40]);
               End;

      (* Move cursor to x, y coordinates *)
      'H','F' : GotoXy (Tab[2], Tab[1]);

      (* Responds to a standard ANSI detect *)
      'N' : Begin
                 Str (WhereX, XStr);
                 Str (WhereY, YStr);
            End;

      (* Move Up x lines *)
      'A' : GotoXy (WhereX, WhereY - Tab [1]);

      (* Move Down x lines *)
      'B' : GotoXy (WhereX, WhereY + Tab [1]);

      (* Move right x cols *)
      'C' : GotoXy (WhereX + Tab [1], WhereY);

      (* Move left x cols *)
      'D' : GotoXy (WhereX - Tab [1], WhereY);

      (* Clear Screen *)
      'J' : ClrScr;

      (* Save cursor position *)
      'S' : Begin
                 SaveX := WhereX;
                 SaveY := WhereY;
            End;

      (* Restore saved cursor position *)
      'U' : GotoXy (SaveX,SaveY);

      (* Clear to end of line *)
      'K' : ClrEol;
       End;  (* Case of *)
End;  (* Ansi *)


Begin
     If C = '' Then Escape := True
      Else If (C = '[') and Escape Then Escape2 := True
      Else If Escape and Escape2 Then
              Begin
                   Inc (PosBuff);
                   Buff [PosBuff] := UpCase (C);
                   If PosBuff < MaxCh Then
                   Begin
                        If UpCase (C) in C_Ansi Then Begin
                            Ansi;
                            Escape := False;
                            Escape2 := False;
                            PosBuff := 0;
                        End;
                   End
                   Else Begin
                        Escape := False;
                        Escape2 := False;
                        PosBuff := 0;
                   End;
              End
              Else Write (C);
End;

(* Unit initialization *)
Begin
     (* Flush buffer *)
     FillChar (Buff, MaxCh+1, ' ');

     (* Reset variables *)
     Hi := False;
     Blink := False;
     Escape := False;
     Escape2 := False;
     PosBuff := 0;
     SaveX := 1;
     SaveY := 1;
End.
