/* be sure to check gz-bump.tut included which will help when explaining
this source*/


#include "..\units\gzfx.h"

#define FACE_RED                0
#define FACE_GREEN              0
#define FACE_BLUE               0
#define LIGHT                   50 //       40   40
#define REFLECT                 150//       30   150
#define AMBIENT                 0  //       30   0


/*  VARS */
//typedef
struct pcxheader
{
  char  manufacturer;   // always 10
  char  version;        // should be 5
  char  encoding;       // 1 for RLE
  char  bits_per_pixel; // usually 8, for 256-color
  short xmin, ymin;     // the width  is *usually*  (xmax-xmin+1)
  short xmax, ymax;     // the height is *usually*  (ymax-ymin+1)
  short horz_res, vert_res;     // DPI for printing
  char  ega_palette[48];        // junk  :)
  char  reserved;       
  char  num_color_planes;       // usually 1 (3 for 24-bit color)
  short bytes_per_line;         // MUST BE an EVEN number
  short palette_type;           // should be 1
  char  padding[58];            // junk

};         //__attribute__ ((packed)) pcxheader;

byte far *envptr;
dword envmap;
byte far *bumptr;
dword bumpmap;

/* PROGRAM */
void make_env()
{
  byte *temptr=(byte *)envmap;
  word x=0;
  word y=0;
   float r,g,b,intensity;                 
   for (word loop=0; loop<256; loop++ )   //props for this mad pallette to 
       {                                 //phlash of AZuRE in his azr-bump.zip
         intensity = cos ( (248-loop) / 496.0 * pi );
//         intensity = cos ( (255-loop)/512.0 * pi); 
         r= FACE_RED*AMBIENT/63.0  + FACE_RED*intensity  + pow(intensity,REFLECT)*LIGHT;
         if (r>63) r=63;
         g= FACE_GREEN*AMBIENT/63.0+ FACE_GREEN*intensity+ pow(intensity,REFLECT)*LIGHT;
         if (g>63) g=63;
         b= FACE_BLUE*AMBIENT/63.0 + FACE_BLUE*intensity + pow(intensity,REFLECT)*LIGHT;
         if (b>63) b=63;
         pal(loop,round(r),round(g),round(b));
       }
  for (y=0; y<256;y++)            //makes the env map, props to  zaphod@sci.fi
     for(x=0; x<256; x++)       // aka sqrt(-1).. good stuff
     {
        float nX=(x-128);
        nX=nX/128;
        float nY=(y-128);
        nY=nY/128;
        float nZ=1-sqrt(nX*nX + nY*nY);
        if (nZ<0) nZ=0;
//        if (y<200) putpixel(x,y,round(nZ*256),vga);
        *temptr++=round(nZ*255);
     }
}

void check(byte x)     //this is a very simple yet invaluable routine for
{                     // debugging
 settext();
 printf("check %d\n",x);
 getch();
 setmcga();
}


void load_bump()
{
  byte *bump=(byte *)(bumpmap);    //loades the .bmp to the bumpmap
  FILE *fp;

  fp=fopen("o2-bump.bmp", "rb");
  fseek(fp,1078,SEEK_SET);
  for (word y=0;y<200;y++)
    for (word x=0;x<320;x++)
       *(bump + x + (200-y)*320)=fgetc(fp);
  fclose(fp);
}


void loadpcx()
{
  word count=0;          // current pixel number in the image
  byte key;             // current byte read from the image
  FILE *fp;
  byte *bump=(byte *)(bumpmap);

  fp=fopen("1.pcx","rb");

  byte temp;
  fseek(fp,128,SEEK_SET);
  do {
    key=fgetc(fp);              // get a character
    if ((key && 0x00C0)== key)
      {
        key = key&&0x003f;
        temp=fgetc(fp);
        for (word loop=0;loop<key;loop++)
         {
          *bump++=temp;
          count++;
         }
      }
    else
      {
        *bump++=key;
        count++;
      }
    } while (count<64000);
  fclose(fp);
}


void mapit(int lightx, int lighty)
{
  byte *vs = (byte *) (0xa0000);
  byte *tbump =(byte *)(bumpmap);
  byte *temptr=(byte *)(envmap);

  lightx-=129;
  int lX=-lightx;
  int lY=-lighty-128;
  for (word y=0;y<200;y++)
    {
    for (word x=0;x<320;x++)            //ph33r
      {
        int nX=*tbump++ - *(tbump - 2);
        int nY=*(tbump + 319) - *(tbump - 321);
        nX-=lX++;
        nY-=lY;
          if (nX>0 && nX<255 && nY>0 && nY<255)
              *vs++=*(temptr+(nY<<8)+nX);
          else
             vs++;
      }
      lX=-lightx;
      lY++;
    }
}

void playpal(word amount, word phil, word amb)
{
   float r,g,b,intensity;               
   int new_r,new_g,new_b;

   if (phil==0)                     //this is to either fade to green,red,or
     {                             // whatever
       new_g=FACE_GREEN+amount;
       new_r=FACE_RED+(63-amount);
       new_b=FACE_BLUE;
     }
   if (phil==1)
     {
       new_g=FACE_GREEN+63;
       new_r=FACE_RED+amount;
       new_b=FACE_BLUE;
     }
   if (phil==2)
     {
       new_g=FACE_GREEN+(63-amount);
       new_r=FACE_RED+63;
       new_b=FACE_BLUE;
     }


   for (word loop=0; loop<256; loop++ )
       {
         intensity = cos ( (248-loop) / 496.0 * pi );
         r= (new_r)*intensity + pow(intensity,REFLECT)*LIGHT+amb;
           if (r>63) r=63;
         g= (new_g)*intensity + pow(intensity,REFLECT)*LIGHT+amb;
           if (g>63) g=63;
         b= (new_b)*intensity + pow(intensity,REFLECT)*LIGHT+amb;
           if (b>63) b=63;
         pal(loop,round(r),round(g),round(b));
       }
}

/* MAINLINE */
void main()
{
      setmcga();
      bumptr = (byte far *) malloc(65536);
      bumpmap = FP_OFF(bumptr); 
      byte *bump=(byte *)(bumpmap);
      load_bump();
//      loadpcx();  //never got this to work properly
      envptr=(byte far *) malloc(65536);
      envmap=FP_OFF(envptr); 
      make_env();
      cls(vga,0);
      word lx,ly,degree,palinc,palfin;
      word palfin2=0;
      word rot_dist=0;
      do
      {
        palinc+=2;
        rot_dist+=3;
        if (rot_dist>360) rot_dist=0;
        if (palinc>90)
          {
            palinc=0;
            palfin2+=1;
            if (palfin2>2) palfin2=0;
          }
        palfin=round(63*sin(rad(palinc)));
        degree+=20;
        lx=round(cos(rad(degree/13))*66+400); //moves the light around
        ly=round(sin(rad(degree/23))*66+100);//got this from a water source
        mapit(lx,ly);           //draws out the map
        playpal(palfin,palfin2,0);           //plays with the pallette
      }while (!kbhit());

      for (word loop=0;loop<63;loop++)
        {
        palinc+=2;
        if (palinc>90)
          {
            palinc=0;
            palfin2+=1;
            if (palfin2>2) palfin2=0;
          }
        palfin=round(63*sin(rad(palinc)));
        degree+=20;
        lx=round(cos(rad(degree/13))*66+160);
        ly=round(sin(rad(degree/23))*66+100);
        mapit(lx,ly);
        playpal(palfin,palfin2,loop); //this is the only difference from the 
        }                           //above repeat thing.. i inc the ambient
      free(&envptr);               //component
      free(&bumptr);
      settext();
      for (loop=0;loop<25;loop++)
        printf("\n");
      printf("                                                                 surge '97\n");
      printf("                                                                art: o2sin\n");
      printf("                                                               code: gz   \n");
}
