{ For Use With APP.PAS }
{ Written by Zealot }

{$G+}
Unit APPUtils;

Interface
Uses APPRecs;
Function Getfone(blank:char): string;
Function Getstr(c1,c2: byte; limit: integer): string;
Function Yesno(default: boolean): boolean;
Function ChooseOne(c : choicetype): byte;
Procedure Putstr (s : string; limit: integer);
Procedure Markfromlist (var lst: listtype);

Procedure CursorOff;
Procedure CursorOn;

Implementation


Uses Crt,Dos;

Var
   Regs: Registers;

Function YesNo(Default: Boolean): Boolean;
Var
   ch : char;
   temp : boolean;
   x, y : integer;
Begin
   Ch:= #0;
   X:= Wherex;
   Y:= Wherey;
    If Default
       Then Write('Yes')
       Else Write('No ');
    Gotoxy (x, y);
    While (upcase (ch) <> 'Y') and (upcase(ch) <> 'N') and (ch <> #13) do
       Ch:=Readkey;
    If Upcase(ch) = 'Y'
       Then Temp:= True
       Else If Upcase(Ch) = 'N'
               Then Temp:= False
               Else If Ch = #13
                       Then Temp:= Default;
    TextColor(15);
    TextBackground(7);
     If Temp
        Then Write ('Yes')
        Else Write ('No ');
   YesNo:= Temp;
End;

Procedure MarkFromList(Var Lst: ListType);
Var
   Temp: Integer;
   Current: Integer;
   Ch: Char;
   Need: Boolean;
Begin
   Current:= 0;
   Ch:= #0;
   Need:= TRUE;
   While (ch <> #13) and (ch <> #27) do
      Begin
         If Need
            Then
             Begin
                For Temp:= 0 to Lst.Limit-1 do
                   Begin
                      If Temp = Current
                         Then
                          Begin
                             Textcolor(lst.c3);
                             Textbackground(lst.c4);
                          End
                         Else
                          Begin
                             Textcolor(lst.c1);
                             Textbackground(lst.c2);
                          End;
                     Gotoxy(lst.x, lst.y + temp);
                     Write('(');
                      If Lst.Chosen[Temp]
                         Then Write(lst.marked_char)
                         Else Write (' ');
                     Write (') ', lst.choices[temp]);
                   End;
                Need:= FALSE;
             End;
       If Keypressed
          Then
           Begin
              Need:= TRUE;
              ch := readkey;
              if ch = ' '
                 then lst.chosen[current] := not lst.chosen[current];
              if ch = #0
                 then
                  Begin
                     ch := readkey;
                     if ch = #72
                        Then
                           Begin
                            dec (current);
                            if current < 0 then inc (current);
                         End
                        Else if ch = #80
                             then
                              begin
                                 inc(current);
                                 if current = lst.limit then dec (current);
                              End;
                  End;
           End;
      End;
  Gotoxy(lst.x, lst.y + current);
  Textcolor (lst.c1);
  Textbackground (lst.c2);
  Write ('(');
  If lst.chosen[current]
     then write (lst.marked_char)
     else write (' ');
  write (') ', lst.choices[current]);
End;

Function ChooseOne(C: Choicetype): Byte;
Var
   Current,Temp: Integer;
   Ch: Char;
Begin
   Current:= 0;
   Ch:= #0;
   TextColor(c.c1);
   TextBackGround(c.c2);
   Gotoxy(c.x, c.y);
{   Write(c.choices[current]);}


      While (ch <> #13) and (ch <> #27) do
         begin
            write (c.choices[current]);
            temp := length (c.choices[current]);
               while temp < c.max do
                  begin
                     write (' ');
                     inc (temp);
                  end;

      gotoxy (c.x, c.y);
      while not keypressed do;
       ch := readkey;
      if ch = ' ' then begin
         inc (current);
         if current > c.limit - 1 then current := 0;
         end;
      end;
ChooseOne:= Current;
end;

procedure foneput (ch, ch2 : char);
begin
     if (ch >= '0') and (ch <= '9') then
        write (ch)
     else write (ch2);
end;

function getfone (blank : char) : string;
var
   temp : array[1..10] of char;
   tempstr : string;
   temp2, curloc : integer;
   ch : char;
   x, y : byte;
   need, done : boolean;
begin
for temp2 := 1 to 10 do
    temp[temp2] := #0;
need := TRUE;
done := FALSE;
ch := #0;
curloc := 0;
x := wherex;
y := wherey;
while (ch <> #13) or (not done) do
begin
     if need then begin
        gotoxy (x, y);
        foneput (temp[1], blank);
        gotoxy (x + 1, y);
        foneput (temp[2], blank);
        gotoxy (x + 2, y);
        foneput (temp[3], blank);
        gotoxy (x + 4, y);
        foneput (temp[4], blank);
        gotoxy (x + 5, y);
        foneput (temp[5], blank);
        gotoxy (x + 6, y);
        foneput (temp[6], blank);
        gotoxy (x + 8, y);
        foneput (temp[7], blank);
        gotoxy (x + 9, y);
        foneput (temp[8], blank);
        gotoxy (x + 10, y);
        foneput (temp[9], blank);
        gotoxy (x + 11, y);
        foneput (temp[10], blank);
        need := false;
        if curloc < 3 then gotoxy (x + curloc, y)
        else if (curloc > 2) and (curloc < 6) then gotoxy (x + curloc + 1, y)
        else gotoxy (curloc + x + 2, y);
        end;
     if keypressed then begin
        ch := readkey;
        need := TRUE;
        if ch = #8 then begin (*  backspace  *)
           dec (curloc);
           if curloc < 0 then curloc := 0;
        end else if (ch >= '0') and (ch <= '9') then begin
           inc (curloc);
           temp[curloc] := ch;
           if curloc > 9 then curloc := 9;
           done := TRUE;
           for temp2 := 1 to 10 do
               if (temp[temp2] < '0') or (temp[temp2] > '9') then done := FALSE;
        end else if ch = ' ' then begin
           done := FALSE;
           temp[curloc] := ' ';
           inc (curloc);
           if curloc > 9 then curloc := 9;
        end;
     end;
end;
tempstr := '';
for temp2 := 1 to 10 do begin
    if temp2 = 4 then tempstr := tempstr + '-';
    if temp2 = 7 then tempstr := tempstr + '-';
    tempstr := tempstr + temp[temp2];
    end;
getfone := tempstr;
end;

procedure putstr (s : string; limit : integer);
var
   count : integer;
begin
   Textcolor(15);
   Textbackground(0);
   write (s);
   count := length (s);
   while count < limit do
      begin
         write(' ');
         inc (count);
      end;
end;

function getstr (c1, c2 : byte;  limit : integer) : string;
var
   temp : array[0..79] of char;
   sx, sy, current, tempi : integer;
   tempstr : string;
   ch : char;
begin
   ch := #0;
   textcolor (c1);
   textbackground (c2);
   sx := wherex;
   sy := wherey;
      for current := 0 to 79 do
         temp[current] := #0;
   tempi := 0;
   gotoxy (sx, sy);
   current := 0;
   while (tempi < 80) and (tempi < limit) do
      begin
         if temp[tempi] = #0
            then write (' ')
            else write (temp[tempi]);
            inc (tempi);
      End;
   gotoxy (sx, sy);
   while (ch <> #13) and (ch <> #27) do
      Begin
          while not keypressed do;
          ch := readkey;
          if ch = #8
             then
                begin (*  backspace  *)
                   dec (current);
                   if current < 0 then current := 0;
                   temp[current] := #0;
               end;
          if (ch <> #8) and (ch <> #13) and (ch <> #27)
             then
               begin
                  temp[current] := ch;
                  inc (current);
                  if current > 79 then current := 79;
                  if current > limit - 1 then current := limit - 1;
               end;
          tempi := 0;
          gotoxy (sx, sy);
          while (tempi < 80) and (tempi < limit) do
             begin
                if tempi > current then write (' ')
                else write (temp[tempi]);
                inc (tempi);
             end;
         gotoxy (sx + current, sy);
      End;
   tempi := 0;                                {-1}
   tempstr := '';
 while (temp[tempi] <> #0) and (tempi < limit ) and (tempi < 80) do
    Begin
       tempstr := tempstr + temp[tempi];
       inc (tempi);
    End;
  Getstr := tempstr;
End;


Procedure CursorSize(Size:Byte);
Begin
   Regs.AH:=$01;
   Case Size Of
    0:Begin
        Regs.CH:=$20;
        Regs.CL:=$20;
      End;
    1:Begin
         Regs.CH:=$6;
         Regs.CL:=$7;
       End;
    2:Begin
        Regs.CH:=$3;
        Regs.CL:=$7;
      End;
   End;
   Intr($10,Regs);
End;

PROCEDURE CursorOff;
BEGIN
    CursorSize(0);
END; {of CursorOff procedure}

PROCEDURE CursorOn;
BEGIN
   CursorSize(1);
END; {of NormCursorOn procedure}

End.