// A POV-Ray v2 scene description file (for animation)
// Contains a <rotating> wheel and <bulging> spheres
// Requires the Perl script 'wheel.pl' to create the values for animation
// variables.
// by Jussi Kantola (jkantola@paju.oulu.fi)
//

#default { texture { finish { ambient 0.05 diffuse 0.95 } } }

#declare SkyBlue = color red 0.196078 green 0.6 blue 0.8
#declare Tan = color red 0.858824 green 0.576471 blue 0.439216
#declare White = color rgb <1, 1, 1>
#declare Black = color rgb <0, 0, 0>

#include "colors.inc"

#declare Colors3 = color_map  // Very realistic!
   {
   [0.0 0.1 color SkyBlue color SkyBlue]
   [0.70 color rgb <4/5, 4/5, 5/6>]
   [1.0 color White]
   }

#declare CloudSky = texture  // this is the cloud texture
   {
   pigment
      {
      bozo
      turbulence 0.5
      octaves 3   // doesn't have much effect
      lambda 6    // bigger values are worth trying
      color_map { Colors3 }
      }
   finish { ambient 1 diffuse 0 }
   scale 1/6   // please notice
   }

/*#declare Sphere1_Rad = 1
#declare Sphere2_Rad = 1
#declare Sphere3_Rad = 1
#declare Sphere4_Rad = 1
#declare TRad = 5
#declare WheelRot = 0*/

camera
   {
   location <0, 6, -14>
   right 4/3*x
   up y
   direction z
   look_at <0, 1, 0>
   }

// mirrors

object
   {
   union
      {
      sphere { <-5, 1,  5>, Sphere1_Rad }
      sphere { <-5, 1, -5>, Sphere2_Rad }
      sphere { < 5, 1,  5>, Sphere3_Rad }
      sphere { < 5, 1, -5>, Sphere4_Rad }
      }
   pigment { color Black }
   finish { reflection 0.92 specular 1.0 roughness 0.0003 }
   }

// wheel

object
   {
   union
      {
      torus { TRad, TRad/15 translate <0, TRad/15, 0> }
      union
         {
         cylinder { <-TRad, TRad/15, 0>, <TRad, TRad/15, 0>, TRad/15 }
         cylinder { <0, TRad/15, -TRad>, <0, TRad/15, TRad>, TRad/15 }
         bounded_by { box { <-TRad, 0, -TRad>, <TRad, 2*TRad/15, TRad> } }
         }
      bounded_by 
         { 
         box 
            { 
            <-TRad-TRad/15, 0, -TRad-TRad/15>,
            <TRad+TRad/15, 2*TRad, TRad+TRad/15>
            }
         }
      }
   pigment { color rgb <1/5, 1/2, 1> }
   finish { specular 1.0 roughness 0.01 }
   rotate <0, WheelRot, 0>
   }

plane
   {
   y, 0
   pigment { color Tan }
   finish { reflection 0.3 }
   }

sphere
   {
   <0, 0, 0>, 1
   texture { CloudSky }
   scale <90, 15, 90>
   }
      
light_source 
   { 
   <-5, 8, -2> color White 
   spotlight
      point_at <-3+L1X, 0, -1+L1Z>
      radius 30
      falloff 40
   }

light_source 
   { 
   < 5, 9, -5> color White 
   spotlight
      point_at <2+L2X, 0, -2+L2Z>
      radius 30
      falloff 40
    }




